<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sections_view = new sections_view();

// Run the page
$sections_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sections_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sections->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fsectionsview = currentForm = new ew.Form("fsectionsview", "view");

// Form_CustomValidate event
fsectionsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsectionsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsectionsview.lists["x_Activated[]"] = <?php echo $sections_view->Activated->Lookup->toClientList() ?>;
fsectionsview.lists["x_Activated[]"].options = <?php echo JsonEncode($sections_view->Activated->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sections->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $sections_view->ExportOptions->render("body") ?>
<?php $sections_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $sections_view->showPageHeader(); ?>
<?php
$sections_view->showMessage();
?>
<?php if (!$sections_view->IsModal) { ?>
<?php if (!$sections->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sections_view->Pager)) $sections_view->Pager = new PrevNextPager($sections_view->StartRec, $sections_view->DisplayRecs, $sections_view->TotalRecs, $sections_view->AutoHidePager) ?>
<?php if ($sections_view->Pager->RecordCount > 0 && $sections_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sections_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sections_view->pageUrl() ?>start=<?php echo $sections_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sections_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sections_view->pageUrl() ?>start=<?php echo $sections_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sections_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sections_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sections_view->pageUrl() ?>start=<?php echo $sections_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sections_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sections_view->pageUrl() ?>start=<?php echo $sections_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sections_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fsectionsview" id="fsectionsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sections_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sections_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sections">
<input type="hidden" name="modal" value="<?php echo (int)$sections_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($sections->SectionID->Visible) { // SectionID ?>
	<tr id="r_SectionID">
		<td class="<?php echo $sections_view->TableLeftColumnClass ?>"><span id="elh_sections_SectionID"><?php echo $sections->SectionID->caption() ?></span></td>
		<td data-name="SectionID"<?php echo $sections->SectionID->cellAttributes() ?>>
<span id="el_sections_SectionID">
<span<?php echo $sections->SectionID->viewAttributes() ?>>
<?php echo $sections->SectionID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sections->Section->Visible) { // Section ?>
	<tr id="r_Section">
		<td class="<?php echo $sections_view->TableLeftColumnClass ?>"><span id="elh_sections_Section"><?php echo $sections->Section->caption() ?></span></td>
		<td data-name="Section"<?php echo $sections->Section->cellAttributes() ?>>
<span id="el_sections_Section">
<span<?php echo $sections->Section->viewAttributes() ?>>
<?php echo $sections->Section->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sections->SectionEn->Visible) { // SectionEn ?>
	<tr id="r_SectionEn">
		<td class="<?php echo $sections_view->TableLeftColumnClass ?>"><span id="elh_sections_SectionEn"><?php echo $sections->SectionEn->caption() ?></span></td>
		<td data-name="SectionEn"<?php echo $sections->SectionEn->cellAttributes() ?>>
<span id="el_sections_SectionEn">
<span<?php echo $sections->SectionEn->viewAttributes() ?>>
<?php echo $sections->SectionEn->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sections->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $sections_view->TableLeftColumnClass ?>"><span id="elh_sections_Notes"><?php echo $sections->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $sections->Notes->cellAttributes() ?>>
<span id="el_sections_Notes">
<span<?php echo $sections->Notes->viewAttributes() ?>>
<?php echo $sections->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sections->Activated->Visible) { // Activated ?>
	<tr id="r_Activated">
		<td class="<?php echo $sections_view->TableLeftColumnClass ?>"><span id="elh_sections_Activated"><?php echo $sections->Activated->caption() ?></span></td>
		<td data-name="Activated"<?php echo $sections->Activated->cellAttributes() ?>>
<span id="el_sections_Activated">
<span<?php echo $sections->Activated->viewAttributes() ?>>
<?php if (ConvertToBool($sections->Activated->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $sections->Activated->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $sections->Activated->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$sections_view->IsModal) { ?>
<?php if (!$sections->isExport()) { ?>
<?php if (!isset($sections_view->Pager)) $sections_view->Pager = new PrevNextPager($sections_view->StartRec, $sections_view->DisplayRecs, $sections_view->TotalRecs, $sections_view->AutoHidePager) ?>
<?php if ($sections_view->Pager->RecordCount > 0 && $sections_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sections_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sections_view->pageUrl() ?>start=<?php echo $sections_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sections_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sections_view->pageUrl() ?>start=<?php echo $sections_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sections_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sections_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sections_view->pageUrl() ?>start=<?php echo $sections_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sections_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sections_view->pageUrl() ?>start=<?php echo $sections_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sections_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$sections_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sections->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sections_view->terminate();
?>
