<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$notifications_search = new notifications_search();

// Run the page
$notifications_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$notifications_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($notifications_search->IsModal) { ?>
var fnotificationssearch = currentAdvancedSearchForm = new ew.Form("fnotificationssearch", "search");
<?php } else { ?>
var fnotificationssearch = currentForm = new ew.Form("fnotificationssearch", "search");
<?php } ?>

// Form_CustomValidate event
fnotificationssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnotificationssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search
// Validate function for search

fnotificationssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_NotificationDate");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($notifications->NotificationDate->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_CaseID");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($notifications->CaseID->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $notifications_search->showPageHeader(); ?>
<?php
$notifications_search->showMessage();
?>
<form name="fnotificationssearch" id="fnotificationssearch" class="<?php echo $notifications_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($notifications_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $notifications_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="notifications">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$notifications_search->IsModal ?>">
<?php if (!$notifications_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($notifications_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_notificationssearch" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($notifications->NotificationID->Visible) { // NotificationID ?>
<?php if ($notifications_search->IsMobileOrModal) { ?>
	<div id="r_NotificationID" class="form-group row">
		<label class="<?php echo $notifications_search->LeftColumnClass ?>"><span id="elh_notifications_NotificationID"><?php echo $notifications->NotificationID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_NotificationID" id="z_NotificationID" value="="></span>
		</label>
		<div class="<?php echo $notifications_search->RightColumnClass ?>"><div<?php echo $notifications->NotificationID->cellAttributes() ?>>
			<span id="el_notifications_NotificationID">
<input type="text" data-table="notifications" data-field="x_NotificationID" name="x_NotificationID" id="x_NotificationID" placeholder="<?php echo HtmlEncode($notifications->NotificationID->getPlaceHolder()) ?>" value="<?php echo $notifications->NotificationID->EditValue ?>"<?php echo $notifications->NotificationID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_NotificationID">
		<td class="<?php echo $notifications_search->TableLeftColumnClass ?>"><span id="elh_notifications_NotificationID"><?php echo $notifications->NotificationID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_NotificationID" id="z_NotificationID" value="="></span></td>
		<td<?php echo $notifications->NotificationID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notifications_NotificationID">
<input type="text" data-table="notifications" data-field="x_NotificationID" name="x_NotificationID" id="x_NotificationID" placeholder="<?php echo HtmlEncode($notifications->NotificationID->getPlaceHolder()) ?>" value="<?php echo $notifications->NotificationID->EditValue ?>"<?php echo $notifications->NotificationID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notifications->CaseNumber->Visible) { // CaseNumber ?>
<?php if ($notifications_search->IsMobileOrModal) { ?>
	<div id="r_CaseNumber" class="form-group row">
		<label for="x_CaseNumber" class="<?php echo $notifications_search->LeftColumnClass ?>"><span id="elh_notifications_CaseNumber"><?php echo $notifications->CaseNumber->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CaseNumber" id="z_CaseNumber" value="LIKE"></span>
		</label>
		<div class="<?php echo $notifications_search->RightColumnClass ?>"><div<?php echo $notifications->CaseNumber->cellAttributes() ?>>
			<span id="el_notifications_CaseNumber">
<input type="text" data-table="notifications" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($notifications->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $notifications->CaseNumber->EditValue ?>"<?php echo $notifications->CaseNumber->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseNumber">
		<td class="<?php echo $notifications_search->TableLeftColumnClass ?>"><span id="elh_notifications_CaseNumber"><?php echo $notifications->CaseNumber->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CaseNumber" id="z_CaseNumber" value="LIKE"></span></td>
		<td<?php echo $notifications->CaseNumber->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notifications_CaseNumber">
<input type="text" data-table="notifications" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($notifications->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $notifications->CaseNumber->EditValue ?>"<?php echo $notifications->CaseNumber->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notifications->FileNumber->Visible) { // FileNumber ?>
<?php if ($notifications_search->IsMobileOrModal) { ?>
	<div id="r_FileNumber" class="form-group row">
		<label for="x_FileNumber" class="<?php echo $notifications_search->LeftColumnClass ?>"><span id="elh_notifications_FileNumber"><?php echo $notifications->FileNumber->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileNumber" id="z_FileNumber" value="LIKE"></span>
		</label>
		<div class="<?php echo $notifications_search->RightColumnClass ?>"><div<?php echo $notifications->FileNumber->cellAttributes() ?>>
			<span id="el_notifications_FileNumber">
<input type="text" data-table="notifications" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($notifications->FileNumber->getPlaceHolder()) ?>" value="<?php echo $notifications->FileNumber->EditValue ?>"<?php echo $notifications->FileNumber->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_FileNumber">
		<td class="<?php echo $notifications_search->TableLeftColumnClass ?>"><span id="elh_notifications_FileNumber"><?php echo $notifications->FileNumber->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileNumber" id="z_FileNumber" value="LIKE"></span></td>
		<td<?php echo $notifications->FileNumber->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notifications_FileNumber">
<input type="text" data-table="notifications" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($notifications->FileNumber->getPlaceHolder()) ?>" value="<?php echo $notifications->FileNumber->EditValue ?>"<?php echo $notifications->FileNumber->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notifications->Notification->Visible) { // Notification ?>
<?php if ($notifications_search->IsMobileOrModal) { ?>
	<div id="r_Notification" class="form-group row">
		<label for="x_Notification" class="<?php echo $notifications_search->LeftColumnClass ?>"><span id="elh_notifications_Notification"><?php echo $notifications->Notification->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notification" id="z_Notification" value="LIKE"></span>
		</label>
		<div class="<?php echo $notifications_search->RightColumnClass ?>"><div<?php echo $notifications->Notification->cellAttributes() ?>>
			<span id="el_notifications_Notification">
<input type="text" data-table="notifications" data-field="x_Notification" name="x_Notification" id="x_Notification" size="35" maxlength="200" placeholder="<?php echo HtmlEncode($notifications->Notification->getPlaceHolder()) ?>" value="<?php echo $notifications->Notification->EditValue ?>"<?php echo $notifications->Notification->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notification">
		<td class="<?php echo $notifications_search->TableLeftColumnClass ?>"><span id="elh_notifications_Notification"><?php echo $notifications->Notification->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notification" id="z_Notification" value="LIKE"></span></td>
		<td<?php echo $notifications->Notification->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notifications_Notification">
<input type="text" data-table="notifications" data-field="x_Notification" name="x_Notification" id="x_Notification" size="35" maxlength="200" placeholder="<?php echo HtmlEncode($notifications->Notification->getPlaceHolder()) ?>" value="<?php echo $notifications->Notification->EditValue ?>"<?php echo $notifications->Notification->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notifications->NotificationDate->Visible) { // NotificationDate ?>
<?php if ($notifications_search->IsMobileOrModal) { ?>
	<div id="r_NotificationDate" class="form-group row">
		<label for="x_NotificationDate" class="<?php echo $notifications_search->LeftColumnClass ?>"><span id="elh_notifications_NotificationDate"><?php echo $notifications->NotificationDate->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_NotificationDate" id="z_NotificationDate" value="="></span>
		</label>
		<div class="<?php echo $notifications_search->RightColumnClass ?>"><div<?php echo $notifications->NotificationDate->cellAttributes() ?>>
			<span id="el_notifications_NotificationDate">
<input type="text" data-table="notifications" data-field="x_NotificationDate" data-format="7" name="x_NotificationDate" id="x_NotificationDate" placeholder="<?php echo HtmlEncode($notifications->NotificationDate->getPlaceHolder()) ?>" value="<?php echo $notifications->NotificationDate->EditValue ?>"<?php echo $notifications->NotificationDate->editAttributes() ?>>
<?php if (!$notifications->NotificationDate->ReadOnly && !$notifications->NotificationDate->Disabled && !isset($notifications->NotificationDate->EditAttrs["readonly"]) && !isset($notifications->NotificationDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnotificationssearch", "x_NotificationDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_NotificationDate">
		<td class="<?php echo $notifications_search->TableLeftColumnClass ?>"><span id="elh_notifications_NotificationDate"><?php echo $notifications->NotificationDate->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_NotificationDate" id="z_NotificationDate" value="="></span></td>
		<td<?php echo $notifications->NotificationDate->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notifications_NotificationDate">
<input type="text" data-table="notifications" data-field="x_NotificationDate" data-format="7" name="x_NotificationDate" id="x_NotificationDate" placeholder="<?php echo HtmlEncode($notifications->NotificationDate->getPlaceHolder()) ?>" value="<?php echo $notifications->NotificationDate->EditValue ?>"<?php echo $notifications->NotificationDate->editAttributes() ?>>
<?php if (!$notifications->NotificationDate->ReadOnly && !$notifications->NotificationDate->Disabled && !isset($notifications->NotificationDate->EditAttrs["readonly"]) && !isset($notifications->NotificationDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnotificationssearch", "x_NotificationDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notifications->Notes->Visible) { // Notes ?>
<?php if ($notifications_search->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label class="<?php echo $notifications_search->LeftColumnClass ?>"><span id="elh_notifications_Notes"><?php echo $notifications->Notes->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span>
		</label>
		<div class="<?php echo $notifications_search->RightColumnClass ?>"><div<?php echo $notifications->Notes->cellAttributes() ?>>
			<span id="el_notifications_Notes">
<input type="text" data-table="notifications" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($notifications->Notes->getPlaceHolder()) ?>" value="<?php echo $notifications->Notes->EditValue ?>"<?php echo $notifications->Notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $notifications_search->TableLeftColumnClass ?>"><span id="elh_notifications_Notes"><?php echo $notifications->Notes->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span></td>
		<td<?php echo $notifications->Notes->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notifications_Notes">
<input type="text" data-table="notifications" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($notifications->Notes->getPlaceHolder()) ?>" value="<?php echo $notifications->Notes->EditValue ?>"<?php echo $notifications->Notes->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notifications->CaseID->Visible) { // CaseID ?>
<?php if ($notifications_search->IsMobileOrModal) { ?>
	<div id="r_CaseID" class="form-group row">
		<label for="x_CaseID" class="<?php echo $notifications_search->LeftColumnClass ?>"><span id="elh_notifications_CaseID"><?php echo $notifications->CaseID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseID" id="z_CaseID" value="="></span>
		</label>
		<div class="<?php echo $notifications_search->RightColumnClass ?>"><div<?php echo $notifications->CaseID->cellAttributes() ?>>
			<span id="el_notifications_CaseID">
<input type="text" data-table="notifications" data-field="x_CaseID" name="x_CaseID" id="x_CaseID" size="30" placeholder="<?php echo HtmlEncode($notifications->CaseID->getPlaceHolder()) ?>" value="<?php echo $notifications->CaseID->EditValue ?>"<?php echo $notifications->CaseID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseID">
		<td class="<?php echo $notifications_search->TableLeftColumnClass ?>"><span id="elh_notifications_CaseID"><?php echo $notifications->CaseID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseID" id="z_CaseID" value="="></span></td>
		<td<?php echo $notifications->CaseID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notifications_CaseID">
<input type="text" data-table="notifications" data-field="x_CaseID" name="x_CaseID" id="x_CaseID" size="30" placeholder="<?php echo HtmlEncode($notifications->CaseID->getPlaceHolder()) ?>" value="<?php echo $notifications->CaseID->EditValue ?>"<?php echo $notifications->CaseID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notifications_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$notifications_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $notifications_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$notifications_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$notifications_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$notifications_search->terminate();
?>
