<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$notices_search = new notices_search();

// Run the page
$notices_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$notices_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($notices_search->IsModal) { ?>
var fnoticessearch = currentAdvancedSearchForm = new ew.Form("fnoticessearch", "search");
<?php } else { ?>
var fnoticessearch = currentForm = new ew.Form("fnoticessearch", "search");
<?php } ?>

// Form_CustomValidate event
fnoticessearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnoticessearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fnoticessearch.lists["x_CaseID"] = <?php echo $notices_search->CaseID->Lookup->toClientList() ?>;
fnoticessearch.lists["x_CaseID"].options = <?php echo JsonEncode($notices_search->CaseID->lookupOptions()) ?>;
fnoticessearch.autoSuggests["x_CaseID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fnoticessearch.lists["x_LawyerID"] = <?php echo $notices_search->LawyerID->Lookup->toClientList() ?>;
fnoticessearch.lists["x_LawyerID"].options = <?php echo JsonEncode($notices_search->LawyerID->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fnoticessearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_NoticeDate");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($notices->NoticeDate->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $notices_search->showPageHeader(); ?>
<?php
$notices_search->showMessage();
?>
<form name="fnoticessearch" id="fnoticessearch" class="<?php echo $notices_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($notices_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $notices_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="notices">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$notices_search->IsModal ?>">
<?php if (!$notices_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($notices_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_noticessearch" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($notices->NoticeID->Visible) { // NoticeID ?>
<?php if ($notices_search->IsMobileOrModal) { ?>
	<div id="r_NoticeID" class="form-group row">
		<label class="<?php echo $notices_search->LeftColumnClass ?>"><span id="elh_notices_NoticeID"><?php echo $notices->NoticeID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_NoticeID" id="z_NoticeID" value="="></span>
		</label>
		<div class="<?php echo $notices_search->RightColumnClass ?>"><div<?php echo $notices->NoticeID->cellAttributes() ?>>
			<span id="el_notices_NoticeID">
<input type="text" data-table="notices" data-field="x_NoticeID" name="x_NoticeID" id="x_NoticeID" placeholder="<?php echo HtmlEncode($notices->NoticeID->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeID->EditValue ?>"<?php echo $notices->NoticeID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_NoticeID">
		<td class="<?php echo $notices_search->TableLeftColumnClass ?>"><span id="elh_notices_NoticeID"><?php echo $notices->NoticeID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_NoticeID" id="z_NoticeID" value="="></span></td>
		<td<?php echo $notices->NoticeID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notices_NoticeID">
<input type="text" data-table="notices" data-field="x_NoticeID" name="x_NoticeID" id="x_NoticeID" placeholder="<?php echo HtmlEncode($notices->NoticeID->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeID->EditValue ?>"<?php echo $notices->NoticeID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices->CaseID->Visible) { // CaseID ?>
<?php if ($notices_search->IsMobileOrModal) { ?>
	<div id="r_CaseID" class="form-group row">
		<label class="<?php echo $notices_search->LeftColumnClass ?>"><span id="elh_notices_CaseID"><?php echo $notices->CaseID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseID" id="z_CaseID" value="="></span>
		</label>
		<div class="<?php echo $notices_search->RightColumnClass ?>"><div<?php echo $notices->CaseID->cellAttributes() ?>>
			<span id="el_notices_CaseID">
<?php
$wrkonchange = "" . trim(@$notices->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$notices->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CaseID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CaseID" id="sv_x_CaseID" value="<?php echo RemoveHtml($notices->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>"<?php echo $notices->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($notices->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CaseID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($notices->CaseID->ReadOnly || $notices->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="notices" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $notices->CaseID->displayValueSeparatorAttribute() ?>" name="x_CaseID" id="x_CaseID" value="<?php echo HtmlEncode($notices->CaseID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fnoticessearch.createAutoSuggest({"id":"x_CaseID","forceSelect":false});
</script>
<?php echo $notices->CaseID->Lookup->getParamTag("p_x_CaseID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseID">
		<td class="<?php echo $notices_search->TableLeftColumnClass ?>"><span id="elh_notices_CaseID"><?php echo $notices->CaseID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseID" id="z_CaseID" value="="></span></td>
		<td<?php echo $notices->CaseID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notices_CaseID">
<?php
$wrkonchange = "" . trim(@$notices->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$notices->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CaseID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CaseID" id="sv_x_CaseID" value="<?php echo RemoveHtml($notices->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($notices->CaseID->getPlaceHolder()) ?>"<?php echo $notices->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($notices->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CaseID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($notices->CaseID->ReadOnly || $notices->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="notices" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $notices->CaseID->displayValueSeparatorAttribute() ?>" name="x_CaseID" id="x_CaseID" value="<?php echo HtmlEncode($notices->CaseID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fnoticessearch.createAutoSuggest({"id":"x_CaseID","forceSelect":false});
</script>
<?php echo $notices->CaseID->Lookup->getParamTag("p_x_CaseID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices->Notice->Visible) { // Notice ?>
<?php if ($notices_search->IsMobileOrModal) { ?>
	<div id="r_Notice" class="form-group row">
		<label for="x_Notice" class="<?php echo $notices_search->LeftColumnClass ?>"><span id="elh_notices_Notice"><?php echo $notices->Notice->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notice" id="z_Notice" value="LIKE"></span>
		</label>
		<div class="<?php echo $notices_search->RightColumnClass ?>"><div<?php echo $notices->Notice->cellAttributes() ?>>
			<span id="el_notices_Notice">
<input type="text" data-table="notices" data-field="x_Notice" name="x_Notice" id="x_Notice" size="35" maxlength="200" placeholder="<?php echo HtmlEncode($notices->Notice->getPlaceHolder()) ?>" value="<?php echo $notices->Notice->EditValue ?>"<?php echo $notices->Notice->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notice">
		<td class="<?php echo $notices_search->TableLeftColumnClass ?>"><span id="elh_notices_Notice"><?php echo $notices->Notice->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notice" id="z_Notice" value="LIKE"></span></td>
		<td<?php echo $notices->Notice->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notices_Notice">
<input type="text" data-table="notices" data-field="x_Notice" name="x_Notice" id="x_Notice" size="35" maxlength="200" placeholder="<?php echo HtmlEncode($notices->Notice->getPlaceHolder()) ?>" value="<?php echo $notices->Notice->EditValue ?>"<?php echo $notices->Notice->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices->NoticeDate->Visible) { // NoticeDate ?>
<?php if ($notices_search->IsMobileOrModal) { ?>
	<div id="r_NoticeDate" class="form-group row">
		<label for="x_NoticeDate" class="<?php echo $notices_search->LeftColumnClass ?>"><span id="elh_notices_NoticeDate"><?php echo $notices->NoticeDate->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_NoticeDate" id="z_NoticeDate" value="="></span>
		</label>
		<div class="<?php echo $notices_search->RightColumnClass ?>"><div<?php echo $notices->NoticeDate->cellAttributes() ?>>
			<span id="el_notices_NoticeDate">
<input type="text" data-table="notices" data-field="x_NoticeDate" data-format="7" name="x_NoticeDate" id="x_NoticeDate" placeholder="<?php echo HtmlEncode($notices->NoticeDate->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeDate->EditValue ?>"<?php echo $notices->NoticeDate->editAttributes() ?>>
<?php if (!$notices->NoticeDate->ReadOnly && !$notices->NoticeDate->Disabled && !isset($notices->NoticeDate->EditAttrs["readonly"]) && !isset($notices->NoticeDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnoticessearch", "x_NoticeDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_NoticeDate">
		<td class="<?php echo $notices_search->TableLeftColumnClass ?>"><span id="elh_notices_NoticeDate"><?php echo $notices->NoticeDate->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_NoticeDate" id="z_NoticeDate" value="="></span></td>
		<td<?php echo $notices->NoticeDate->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notices_NoticeDate">
<input type="text" data-table="notices" data-field="x_NoticeDate" data-format="7" name="x_NoticeDate" id="x_NoticeDate" placeholder="<?php echo HtmlEncode($notices->NoticeDate->getPlaceHolder()) ?>" value="<?php echo $notices->NoticeDate->EditValue ?>"<?php echo $notices->NoticeDate->editAttributes() ?>>
<?php if (!$notices->NoticeDate->ReadOnly && !$notices->NoticeDate->Disabled && !isset($notices->NoticeDate->EditAttrs["readonly"]) && !isset($notices->NoticeDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnoticessearch", "x_NoticeDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices->Notes->Visible) { // Notes ?>
<?php if ($notices_search->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label class="<?php echo $notices_search->LeftColumnClass ?>"><span id="elh_notices_Notes"><?php echo $notices->Notes->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span>
		</label>
		<div class="<?php echo $notices_search->RightColumnClass ?>"><div<?php echo $notices->Notes->cellAttributes() ?>>
			<span id="el_notices_Notes">
<input type="text" data-table="notices" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($notices->Notes->getPlaceHolder()) ?>" value="<?php echo $notices->Notes->EditValue ?>"<?php echo $notices->Notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $notices_search->TableLeftColumnClass ?>"><span id="elh_notices_Notes"><?php echo $notices->Notes->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span></td>
		<td<?php echo $notices->Notes->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notices_Notes">
<input type="text" data-table="notices" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($notices->Notes->getPlaceHolder()) ?>" value="<?php echo $notices->Notes->EditValue ?>"<?php echo $notices->Notes->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices->LawyerID->Visible) { // LawyerID ?>
<?php if ($notices_search->IsMobileOrModal) { ?>
	<div id="r_LawyerID" class="form-group row">
		<label for="x_LawyerID" class="<?php echo $notices_search->LeftColumnClass ?>"><span id="elh_notices_LawyerID"><?php echo $notices->LawyerID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LawyerID" id="z_LawyerID" value="="></span>
		</label>
		<div class="<?php echo $notices_search->RightColumnClass ?>"><div<?php echo $notices->LawyerID->cellAttributes() ?>>
			<span id="el_notices_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="notices" data-field="x_LawyerID" data-value-separator="<?php echo $notices->LawyerID->displayValueSeparatorAttribute() ?>" id="x_LawyerID" name="x_LawyerID"<?php echo $notices->LawyerID->editAttributes() ?>>
		<?php echo $notices->LawyerID->selectOptionListHtml("x_LawyerID") ?>
	</select>
</div>
<?php echo $notices->LawyerID->Lookup->getParamTag("p_x_LawyerID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_LawyerID">
		<td class="<?php echo $notices_search->TableLeftColumnClass ?>"><span id="elh_notices_LawyerID"><?php echo $notices->LawyerID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LawyerID" id="z_LawyerID" value="="></span></td>
		<td<?php echo $notices->LawyerID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_notices_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="notices" data-field="x_LawyerID" data-value-separator="<?php echo $notices->LawyerID->displayValueSeparatorAttribute() ?>" id="x_LawyerID" name="x_LawyerID"<?php echo $notices->LawyerID->editAttributes() ?>>
		<?php echo $notices->LawyerID->selectOptionListHtml("x_LawyerID") ?>
	</select>
</div>
<?php echo $notices->LawyerID->Lookup->getParamTag("p_x_LawyerID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($notices_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$notices_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $notices_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$notices_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$notices_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$notices_search->terminate();
?>
