<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$notices_list = new notices_list();

// Run the page
$notices_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$notices_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$notices->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fnoticeslist = currentForm = new ew.Form("fnoticeslist", "list");
fnoticeslist.formKeyCountName = '<?php echo $notices_list->FormKeyCountName ?>';

// Form_CustomValidate event
fnoticeslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnoticeslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fnoticeslist.lists["x_CaseID"] = <?php echo $notices_list->CaseID->Lookup->toClientList() ?>;
fnoticeslist.lists["x_CaseID"].options = <?php echo JsonEncode($notices_list->CaseID->lookupOptions()) ?>;
fnoticeslist.autoSuggests["x_CaseID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fnoticeslistsrch = currentSearchForm = new ew.Form("fnoticeslistsrch");

// Filters
fnoticeslistsrch.filterList = <?php echo $notices_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$notices->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($notices_list->TotalRecs > 0 && $notices_list->ExportOptions->visible()) { ?>
<?php $notices_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($notices_list->ImportOptions->visible()) { ?>
<?php $notices_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($notices_list->SearchOptions->visible()) { ?>
<?php $notices_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($notices_list->FilterOptions->visible()) { ?>
<?php $notices_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$notices->isExport() || EXPORT_MASTER_RECORD && $notices->isExport("print")) { ?>
<?php
if ($notices_list->DbMasterFilter <> "" && $notices->getCurrentMasterTable() == "cases") {
	if ($notices_list->MasterRecordExists) {
		include_once "casesmaster.php";
	}
}
?>
<?php } ?>
<?php
$notices_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$notices->isExport() && !$notices->CurrentAction) { ?>
<form name="fnoticeslistsrch" id="fnoticeslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($notices_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fnoticeslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="notices">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($notices_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($notices_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $notices_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($notices_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($notices_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($notices_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($notices_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $notices_list->showPageHeader(); ?>
<?php
$notices_list->showMessage();
?>
<?php if ($notices_list->TotalRecs > 0 || $notices->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($notices_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> notices">
<?php if (!$notices->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$notices->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($notices_list->Pager)) $notices_list->Pager = new PrevNextPager($notices_list->StartRec, $notices_list->DisplayRecs, $notices_list->TotalRecs, $notices_list->AutoHidePager) ?>
<?php if ($notices_list->Pager->RecordCount > 0 && $notices_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($notices_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $notices_list->pageUrl() ?>start=<?php echo $notices_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($notices_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $notices_list->pageUrl() ?>start=<?php echo $notices_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $notices_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($notices_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $notices_list->pageUrl() ?>start=<?php echo $notices_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($notices_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $notices_list->pageUrl() ?>start=<?php echo $notices_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $notices_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($notices_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $notices_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $notices_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $notices_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($notices_list->TotalRecs > 0 && (!$notices_list->AutoHidePageSizeSelector || $notices_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="notices">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($notices_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($notices_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($notices_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($notices_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($notices_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($notices_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($notices_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($notices_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($notices_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($notices->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $notices_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fnoticeslist" id="fnoticeslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($notices_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $notices_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="notices">
<?php if ($notices->getCurrentMasterTable() == "cases" && $notices->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="cases">
<input type="hidden" name="fk_CaseID" value="<?php echo $notices->CaseID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_notices" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($notices_list->TotalRecs > 0 || $notices->isGridEdit()) { ?>
<table id="tbl_noticeslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$notices_list->RowType = ROWTYPE_HEADER;

// Render list options
$notices_list->renderListOptions();

// Render list options (header, left)
$notices_list->ListOptions->render("header", "left");
?>
<?php if ($notices->CaseID->Visible) { // CaseID ?>
	<?php if ($notices->sortUrl($notices->CaseID) == "") { ?>
		<th data-name="CaseID" class="<?php echo $notices->CaseID->headerCellClass() ?>"><div id="elh_notices_CaseID" class="notices_CaseID"><div class="ew-table-header-caption"><?php echo $notices->CaseID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseID" class="<?php echo $notices->CaseID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $notices->SortUrl($notices->CaseID) ?>',2);"><div id="elh_notices_CaseID" class="notices_CaseID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notices->CaseID->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($notices->CaseID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notices->CaseID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->Notice->Visible) { // Notice ?>
	<?php if ($notices->sortUrl($notices->Notice) == "") { ?>
		<th data-name="Notice" class="<?php echo $notices->Notice->headerCellClass() ?>"><div id="elh_notices_Notice" class="notices_Notice"><div class="ew-table-header-caption"><?php echo $notices->Notice->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notice" class="<?php echo $notices->Notice->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $notices->SortUrl($notices->Notice) ?>',2);"><div id="elh_notices_Notice" class="notices_Notice">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notices->Notice->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($notices->Notice->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notices->Notice->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->NoticeDate->Visible) { // NoticeDate ?>
	<?php if ($notices->sortUrl($notices->NoticeDate) == "") { ?>
		<th data-name="NoticeDate" class="<?php echo $notices->NoticeDate->headerCellClass() ?>"><div id="elh_notices_NoticeDate" class="notices_NoticeDate"><div class="ew-table-header-caption"><?php echo $notices->NoticeDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NoticeDate" class="<?php echo $notices->NoticeDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $notices->SortUrl($notices->NoticeDate) ?>',2);"><div id="elh_notices_NoticeDate" class="notices_NoticeDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notices->NoticeDate->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($notices->NoticeDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notices->NoticeDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->NoticeTime->Visible) { // NoticeTime ?>
	<?php if ($notices->sortUrl($notices->NoticeTime) == "") { ?>
		<th data-name="NoticeTime" class="<?php echo $notices->NoticeTime->headerCellClass() ?>"><div id="elh_notices_NoticeTime" class="notices_NoticeTime"><div class="ew-table-header-caption"><?php echo $notices->NoticeTime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NoticeTime" class="<?php echo $notices->NoticeTime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $notices->SortUrl($notices->NoticeTime) ?>',2);"><div id="elh_notices_NoticeTime" class="notices_NoticeTime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notices->NoticeTime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($notices->NoticeTime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notices->NoticeTime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notices->PostMan->Visible) { // PostMan ?>
	<?php if ($notices->sortUrl($notices->PostMan) == "") { ?>
		<th data-name="PostMan" class="<?php echo $notices->PostMan->headerCellClass() ?>"><div id="elh_notices_PostMan" class="notices_PostMan"><div class="ew-table-header-caption"><?php echo $notices->PostMan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PostMan" class="<?php echo $notices->PostMan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $notices->SortUrl($notices->PostMan) ?>',2);"><div id="elh_notices_PostMan" class="notices_PostMan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notices->PostMan->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($notices->PostMan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notices->PostMan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$notices_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($notices->ExportAll && $notices->isExport()) {
	$notices_list->StopRec = $notices_list->TotalRecs;
} else {

	// Set the last record to display
	if ($notices_list->TotalRecs > $notices_list->StartRec + $notices_list->DisplayRecs - 1)
		$notices_list->StopRec = $notices_list->StartRec + $notices_list->DisplayRecs - 1;
	else
		$notices_list->StopRec = $notices_list->TotalRecs;
}
$notices_list->RecCnt = $notices_list->StartRec - 1;
if ($notices_list->Recordset && !$notices_list->Recordset->EOF) {
	$notices_list->Recordset->moveFirst();
	$selectLimit = $notices_list->UseSelectLimit;
	if (!$selectLimit && $notices_list->StartRec > 1)
		$notices_list->Recordset->move($notices_list->StartRec - 1);
} elseif (!$notices->AllowAddDeleteRow && $notices_list->StopRec == 0) {
	$notices_list->StopRec = $notices->GridAddRowCount;
}

// Initialize aggregate
$notices->RowType = ROWTYPE_AGGREGATEINIT;
$notices->resetAttributes();
$notices_list->renderRow();
while ($notices_list->RecCnt < $notices_list->StopRec) {
	$notices_list->RecCnt++;
	if ($notices_list->RecCnt >= $notices_list->StartRec) {
		$notices_list->RowCnt++;

		// Set up key count
		$notices_list->KeyCount = $notices_list->RowIndex;

		// Init row class and style
		$notices->resetAttributes();
		$notices->CssClass = "";
		if ($notices->isGridAdd()) {
		} else {
			$notices_list->loadRowValues($notices_list->Recordset); // Load row values
		}
		$notices->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$notices->RowAttrs = array_merge($notices->RowAttrs, array('data-rowindex'=>$notices_list->RowCnt, 'id'=>'r' . $notices_list->RowCnt . '_notices', 'data-rowtype'=>$notices->RowType));

		// Render row
		$notices_list->renderRow();

		// Render list options
		$notices_list->renderListOptions();
?>
	<tr<?php echo $notices->rowAttributes() ?>>
<?php

// Render list options (body, left)
$notices_list->ListOptions->render("body", "left", $notices_list->RowCnt);
?>
	<?php if ($notices->CaseID->Visible) { // CaseID ?>
		<td data-name="CaseID"<?php echo $notices->CaseID->cellAttributes() ?>>
<span id="el<?php echo $notices_list->RowCnt ?>_notices_CaseID" class="notices_CaseID">
<span<?php echo $notices->CaseID->viewAttributes() ?>>
<?php echo $notices->CaseID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($notices->Notice->Visible) { // Notice ?>
		<td data-name="Notice"<?php echo $notices->Notice->cellAttributes() ?>>
<span id="el<?php echo $notices_list->RowCnt ?>_notices_Notice" class="notices_Notice">
<span<?php echo $notices->Notice->viewAttributes() ?>>
<?php echo $notices->Notice->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($notices->NoticeDate->Visible) { // NoticeDate ?>
		<td data-name="NoticeDate"<?php echo $notices->NoticeDate->cellAttributes() ?>>
<span id="el<?php echo $notices_list->RowCnt ?>_notices_NoticeDate" class="notices_NoticeDate">
<span<?php echo $notices->NoticeDate->viewAttributes() ?>>
<?php echo $notices->NoticeDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($notices->NoticeTime->Visible) { // NoticeTime ?>
		<td data-name="NoticeTime"<?php echo $notices->NoticeTime->cellAttributes() ?>>
<span id="el<?php echo $notices_list->RowCnt ?>_notices_NoticeTime" class="notices_NoticeTime">
<span<?php echo $notices->NoticeTime->viewAttributes() ?>>
<?php echo $notices->NoticeTime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($notices->PostMan->Visible) { // PostMan ?>
		<td data-name="PostMan"<?php echo $notices->PostMan->cellAttributes() ?>>
<span id="el<?php echo $notices_list->RowCnt ?>_notices_PostMan" class="notices_PostMan">
<span<?php echo $notices->PostMan->viewAttributes() ?>>
<?php echo $notices->PostMan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$notices_list->ListOptions->render("body", "right", $notices_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$notices->isGridAdd())
		$notices_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$notices->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($notices_list->Recordset)
	$notices_list->Recordset->Close();
?>
<?php if (!$notices->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$notices->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($notices_list->Pager)) $notices_list->Pager = new PrevNextPager($notices_list->StartRec, $notices_list->DisplayRecs, $notices_list->TotalRecs, $notices_list->AutoHidePager) ?>
<?php if ($notices_list->Pager->RecordCount > 0 && $notices_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($notices_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $notices_list->pageUrl() ?>start=<?php echo $notices_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($notices_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $notices_list->pageUrl() ?>start=<?php echo $notices_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $notices_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($notices_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $notices_list->pageUrl() ?>start=<?php echo $notices_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($notices_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $notices_list->pageUrl() ?>start=<?php echo $notices_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $notices_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($notices_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $notices_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $notices_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $notices_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($notices_list->TotalRecs > 0 && (!$notices_list->AutoHidePageSizeSelector || $notices_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="notices">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($notices_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($notices_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($notices_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($notices_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($notices_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($notices_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($notices_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($notices_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($notices_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($notices->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $notices_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($notices_list->TotalRecs == 0 && !$notices->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $notices_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$notices_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$notices->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$notices->isExport()) { ?>
<script>
ew.scrollableTable("gmp_notices", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$notices_list->terminate();
?>
