<?php
namespace PHPMaker2019\project_germanos;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($litigantcontact_grid))
	$litigantcontact_grid = new litigantcontact_grid();

// Run the page
$litigantcontact_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$litigantcontact_grid->Page_Render();
?>
<?php if (!$litigantcontact->isExport()) { ?>
<script>

// Form object
var flitigantcontactgrid = new ew.Form("flitigantcontactgrid", "grid");
flitigantcontactgrid.formKeyCountName = '<?php echo $litigantcontact_grid->FormKeyCountName ?>';

// Validate form
flitigantcontactgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($litigantcontact_grid->LitigantID->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigantcontact->LitigantID->caption(), $litigantcontact->LitigantID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigantcontact_grid->ContactTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_ContactTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigantcontact->ContactTypeID->caption(), $litigantcontact->ContactTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigantcontact_grid->Contact->Required) { ?>
			elm = this.getElements("x" + infix + "_Contact");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigantcontact->Contact->caption(), $litigantcontact->Contact->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigantcontact_grid->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigantcontact->Notes->caption(), $litigantcontact->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigantcontact_grid->Primary->Required) { ?>
			elm = this.getElements("x" + infix + "_Primary[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigantcontact->Primary->caption(), $litigantcontact->Primary->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
flitigantcontactgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "LitigantID", false)) return false;
	if (ew.valueChanged(fobj, infix, "ContactTypeID", false)) return false;
	if (ew.valueChanged(fobj, infix, "Contact", false)) return false;
	if (ew.valueChanged(fobj, infix, "Notes", false)) return false;
	if (ew.valueChanged(fobj, infix, "Primary[]", true)) return false;
	return true;
}

// Form_CustomValidate event
flitigantcontactgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flitigantcontactgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flitigantcontactgrid.lists["x_LitigantID"] = <?php echo $litigantcontact_grid->LitigantID->Lookup->toClientList() ?>;
flitigantcontactgrid.lists["x_LitigantID"].options = <?php echo JsonEncode($litigantcontact_grid->LitigantID->lookupOptions()) ?>;
flitigantcontactgrid.lists["x_ContactTypeID"] = <?php echo $litigantcontact_grid->ContactTypeID->Lookup->toClientList() ?>;
flitigantcontactgrid.lists["x_ContactTypeID"].options = <?php echo JsonEncode($litigantcontact_grid->ContactTypeID->lookupOptions()) ?>;
flitigantcontactgrid.lists["x_Primary[]"] = <?php echo $litigantcontact_grid->Primary->Lookup->toClientList() ?>;
flitigantcontactgrid.lists["x_Primary[]"].options = <?php echo JsonEncode($litigantcontact_grid->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$litigantcontact_grid->renderOtherOptions();
?>
<?php $litigantcontact_grid->showPageHeader(); ?>
<?php
$litigantcontact_grid->showMessage();
?>
<?php if ($litigantcontact_grid->TotalRecs > 0 || $litigantcontact->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($litigantcontact_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> litigantcontact">
<?php if ($litigantcontact_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $litigantcontact_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="flitigantcontactgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_litigantcontact" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_litigantcontactgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$litigantcontact_grid->RowType = ROWTYPE_HEADER;

// Render list options
$litigantcontact_grid->renderListOptions();

// Render list options (header, left)
$litigantcontact_grid->ListOptions->render("header", "left");
?>
<?php if ($litigantcontact->LitigantID->Visible) { // LitigantID ?>
	<?php if ($litigantcontact->sortUrl($litigantcontact->LitigantID) == "") { ?>
		<th data-name="LitigantID" class="<?php echo $litigantcontact->LitigantID->headerCellClass() ?>"><div id="elh_litigantcontact_LitigantID" class="litigantcontact_LitigantID"><div class="ew-table-header-caption"><?php echo $litigantcontact->LitigantID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantID" class="<?php echo $litigantcontact->LitigantID->headerCellClass() ?>"><div><div id="elh_litigantcontact_LitigantID" class="litigantcontact_LitigantID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantcontact->LitigantID->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigantcontact->LitigantID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantcontact->LitigantID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantcontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($litigantcontact->sortUrl($litigantcontact->ContactTypeID) == "") { ?>
		<th data-name="ContactTypeID" class="<?php echo $litigantcontact->ContactTypeID->headerCellClass() ?>"><div id="elh_litigantcontact_ContactTypeID" class="litigantcontact_ContactTypeID"><div class="ew-table-header-caption"><?php echo $litigantcontact->ContactTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ContactTypeID" class="<?php echo $litigantcontact->ContactTypeID->headerCellClass() ?>"><div><div id="elh_litigantcontact_ContactTypeID" class="litigantcontact_ContactTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantcontact->ContactTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigantcontact->ContactTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantcontact->ContactTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantcontact->Contact->Visible) { // Contact ?>
	<?php if ($litigantcontact->sortUrl($litigantcontact->Contact) == "") { ?>
		<th data-name="Contact" class="<?php echo $litigantcontact->Contact->headerCellClass() ?>"><div id="elh_litigantcontact_Contact" class="litigantcontact_Contact"><div class="ew-table-header-caption"><?php echo $litigantcontact->Contact->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Contact" class="<?php echo $litigantcontact->Contact->headerCellClass() ?>"><div><div id="elh_litigantcontact_Contact" class="litigantcontact_Contact">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantcontact->Contact->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigantcontact->Contact->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantcontact->Contact->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantcontact->Notes->Visible) { // Notes ?>
	<?php if ($litigantcontact->sortUrl($litigantcontact->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $litigantcontact->Notes->headerCellClass() ?>"><div id="elh_litigantcontact_Notes" class="litigantcontact_Notes"><div class="ew-table-header-caption"><?php echo $litigantcontact->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $litigantcontact->Notes->headerCellClass() ?>"><div><div id="elh_litigantcontact_Notes" class="litigantcontact_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantcontact->Notes->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigantcontact->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantcontact->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantcontact->Primary->Visible) { // Primary ?>
	<?php if ($litigantcontact->sortUrl($litigantcontact->Primary) == "") { ?>
		<th data-name="Primary" class="<?php echo $litigantcontact->Primary->headerCellClass() ?>"><div id="elh_litigantcontact_Primary" class="litigantcontact_Primary"><div class="ew-table-header-caption"><?php echo $litigantcontact->Primary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primary" class="<?php echo $litigantcontact->Primary->headerCellClass() ?>"><div><div id="elh_litigantcontact_Primary" class="litigantcontact_Primary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantcontact->Primary->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigantcontact->Primary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantcontact->Primary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$litigantcontact_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$litigantcontact_grid->StartRec = 1;
$litigantcontact_grid->StopRec = $litigantcontact_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $litigantcontact_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($litigantcontact_grid->FormKeyCountName) && ($litigantcontact->isGridAdd() || $litigantcontact->isGridEdit() || $litigantcontact->isConfirm())) {
		$litigantcontact_grid->KeyCount = $CurrentForm->getValue($litigantcontact_grid->FormKeyCountName);
		$litigantcontact_grid->StopRec = $litigantcontact_grid->StartRec + $litigantcontact_grid->KeyCount - 1;
	}
}
$litigantcontact_grid->RecCnt = $litigantcontact_grid->StartRec - 1;
if ($litigantcontact_grid->Recordset && !$litigantcontact_grid->Recordset->EOF) {
	$litigantcontact_grid->Recordset->moveFirst();
	$selectLimit = $litigantcontact_grid->UseSelectLimit;
	if (!$selectLimit && $litigantcontact_grid->StartRec > 1)
		$litigantcontact_grid->Recordset->move($litigantcontact_grid->StartRec - 1);
} elseif (!$litigantcontact->AllowAddDeleteRow && $litigantcontact_grid->StopRec == 0) {
	$litigantcontact_grid->StopRec = $litigantcontact->GridAddRowCount;
}

// Initialize aggregate
$litigantcontact->RowType = ROWTYPE_AGGREGATEINIT;
$litigantcontact->resetAttributes();
$litigantcontact_grid->renderRow();
if ($litigantcontact->isGridAdd())
	$litigantcontact_grid->RowIndex = 0;
if ($litigantcontact->isGridEdit())
	$litigantcontact_grid->RowIndex = 0;
while ($litigantcontact_grid->RecCnt < $litigantcontact_grid->StopRec) {
	$litigantcontact_grid->RecCnt++;
	if ($litigantcontact_grid->RecCnt >= $litigantcontact_grid->StartRec) {
		$litigantcontact_grid->RowCnt++;
		if ($litigantcontact->isGridAdd() || $litigantcontact->isGridEdit() || $litigantcontact->isConfirm()) {
			$litigantcontact_grid->RowIndex++;
			$CurrentForm->Index = $litigantcontact_grid->RowIndex;
			if ($CurrentForm->hasValue($litigantcontact_grid->FormActionName) && $litigantcontact_grid->EventCancelled)
				$litigantcontact_grid->RowAction = strval($CurrentForm->getValue($litigantcontact_grid->FormActionName));
			elseif ($litigantcontact->isGridAdd())
				$litigantcontact_grid->RowAction = "insert";
			else
				$litigantcontact_grid->RowAction = "";
		}

		// Set up key count
		$litigantcontact_grid->KeyCount = $litigantcontact_grid->RowIndex;

		// Init row class and style
		$litigantcontact->resetAttributes();
		$litigantcontact->CssClass = "";
		if ($litigantcontact->isGridAdd()) {
			if ($litigantcontact->CurrentMode == "copy") {
				$litigantcontact_grid->loadRowValues($litigantcontact_grid->Recordset); // Load row values
				$litigantcontact_grid->setRecordKey($litigantcontact_grid->RowOldKey, $litigantcontact_grid->Recordset); // Set old record key
			} else {
				$litigantcontact_grid->loadRowValues(); // Load default values
				$litigantcontact_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$litigantcontact_grid->loadRowValues($litigantcontact_grid->Recordset); // Load row values
		}
		$litigantcontact->RowType = ROWTYPE_VIEW; // Render view
		if ($litigantcontact->isGridAdd()) // Grid add
			$litigantcontact->RowType = ROWTYPE_ADD; // Render add
		if ($litigantcontact->isGridAdd() && $litigantcontact->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$litigantcontact_grid->restoreCurrentRowFormValues($litigantcontact_grid->RowIndex); // Restore form values
		if ($litigantcontact->isGridEdit()) { // Grid edit
			if ($litigantcontact->EventCancelled)
				$litigantcontact_grid->restoreCurrentRowFormValues($litigantcontact_grid->RowIndex); // Restore form values
			if ($litigantcontact_grid->RowAction == "insert")
				$litigantcontact->RowType = ROWTYPE_ADD; // Render add
			else
				$litigantcontact->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($litigantcontact->isGridEdit() && ($litigantcontact->RowType == ROWTYPE_EDIT || $litigantcontact->RowType == ROWTYPE_ADD) && $litigantcontact->EventCancelled) // Update failed
			$litigantcontact_grid->restoreCurrentRowFormValues($litigantcontact_grid->RowIndex); // Restore form values
		if ($litigantcontact->RowType == ROWTYPE_EDIT) // Edit row
			$litigantcontact_grid->EditRowCnt++;
		if ($litigantcontact->isConfirm()) // Confirm row
			$litigantcontact_grid->restoreCurrentRowFormValues($litigantcontact_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$litigantcontact->RowAttrs = array_merge($litigantcontact->RowAttrs, array('data-rowindex'=>$litigantcontact_grid->RowCnt, 'id'=>'r' . $litigantcontact_grid->RowCnt . '_litigantcontact', 'data-rowtype'=>$litigantcontact->RowType));

		// Render row
		$litigantcontact_grid->renderRow();

		// Render list options
		$litigantcontact_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($litigantcontact_grid->RowAction <> "delete" && $litigantcontact_grid->RowAction <> "insertdelete" && !($litigantcontact_grid->RowAction == "insert" && $litigantcontact->isConfirm() && $litigantcontact_grid->emptyRow())) {
?>
	<tr<?php echo $litigantcontact->rowAttributes() ?>>
<?php

// Render list options (body, left)
$litigantcontact_grid->ListOptions->render("body", "left", $litigantcontact_grid->RowCnt);
?>
	<?php if ($litigantcontact->LitigantID->Visible) { // LitigantID ?>
		<td data-name="LitigantID"<?php echo $litigantcontact->LitigantID->cellAttributes() ?>>
<?php if ($litigantcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($litigantcontact->LitigantID->getSessionValue() <> "") { ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_LitigantID" class="form-group litigantcontact_LitigantID">
<span<?php echo $litigantcontact->LitigantID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($litigantcontact->LitigantID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($litigantcontact->LitigantID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_LitigantID" class="form-group litigantcontact_LitigantID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="litigantcontact" data-field="x_LitigantID" data-value-separator="<?php echo $litigantcontact->LitigantID->displayValueSeparatorAttribute() ?>" id="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID"<?php echo $litigantcontact->LitigantID->editAttributes() ?>>
		<?php echo $litigantcontact->LitigantID->selectOptionListHtml("x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID") ?>
	</select>
</div>
<?php echo $litigantcontact->LitigantID->Lookup->getParamTag("p_x" . $litigantcontact_grid->RowIndex . "_LitigantID") ?>
</span>
<?php } ?>
<input type="hidden" data-table="litigantcontact" data-field="x_LitigantID" name="o<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" id="o<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($litigantcontact->LitigantID->OldValue) ?>">
<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($litigantcontact->LitigantID->getSessionValue() <> "") { ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_LitigantID" class="form-group litigantcontact_LitigantID">
<span<?php echo $litigantcontact->LitigantID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($litigantcontact->LitigantID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($litigantcontact->LitigantID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_LitigantID" class="form-group litigantcontact_LitigantID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="litigantcontact" data-field="x_LitigantID" data-value-separator="<?php echo $litigantcontact->LitigantID->displayValueSeparatorAttribute() ?>" id="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID"<?php echo $litigantcontact->LitigantID->editAttributes() ?>>
		<?php echo $litigantcontact->LitigantID->selectOptionListHtml("x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID") ?>
	</select>
</div>
<?php echo $litigantcontact->LitigantID->Lookup->getParamTag("p_x" . $litigantcontact_grid->RowIndex . "_LitigantID") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_LitigantID" class="litigantcontact_LitigantID">
<span<?php echo $litigantcontact->LitigantID->viewAttributes() ?>>
<?php echo $litigantcontact->LitigantID->getViewValue() ?></span>
</span>
<?php if (!$litigantcontact->isConfirm()) { ?>
<input type="hidden" data-table="litigantcontact" data-field="x_LitigantID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" id="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($litigantcontact->LitigantID->FormValue) ?>">
<input type="hidden" data-table="litigantcontact" data-field="x_LitigantID" name="o<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" id="o<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($litigantcontact->LitigantID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="litigantcontact" data-field="x_LitigantID" name="flitigantcontactgrid$x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" id="flitigantcontactgrid$x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($litigantcontact->LitigantID->FormValue) ?>">
<input type="hidden" data-table="litigantcontact" data-field="x_LitigantID" name="flitigantcontactgrid$o<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" id="flitigantcontactgrid$o<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($litigantcontact->LitigantID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="litigantcontact" data-field="x_ContactID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactID" id="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($litigantcontact->ContactID->CurrentValue) ?>">
<input type="hidden" data-table="litigantcontact" data-field="x_ContactID" name="o<?php echo $litigantcontact_grid->RowIndex ?>_ContactID" id="o<?php echo $litigantcontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($litigantcontact->ContactID->OldValue) ?>">
<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_EDIT || $litigantcontact->CurrentMode == "edit") { ?>
<input type="hidden" data-table="litigantcontact" data-field="x_ContactID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactID" id="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($litigantcontact->ContactID->CurrentValue) ?>">
<?php } ?>
	<?php if ($litigantcontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<td data-name="ContactTypeID"<?php echo $litigantcontact->ContactTypeID->cellAttributes() ?>>
<?php if ($litigantcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_ContactTypeID" class="form-group litigantcontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="litigantcontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $litigantcontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID"<?php echo $litigantcontact->ContactTypeID->editAttributes() ?>>
		<?php echo $litigantcontact->ContactTypeID->selectOptionListHtml("x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $litigantcontact->ContactTypeID->Lookup->getParamTag("p_x" . $litigantcontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<input type="hidden" data-table="litigantcontact" data-field="x_ContactTypeID" name="o<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($litigantcontact->ContactTypeID->OldValue) ?>">
<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_ContactTypeID" class="form-group litigantcontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="litigantcontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $litigantcontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID"<?php echo $litigantcontact->ContactTypeID->editAttributes() ?>>
		<?php echo $litigantcontact->ContactTypeID->selectOptionListHtml("x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $litigantcontact->ContactTypeID->Lookup->getParamTag("p_x" . $litigantcontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_ContactTypeID" class="litigantcontact_ContactTypeID">
<span<?php echo $litigantcontact->ContactTypeID->viewAttributes() ?>>
<?php echo $litigantcontact->ContactTypeID->getViewValue() ?></span>
</span>
<?php if (!$litigantcontact->isConfirm()) { ?>
<input type="hidden" data-table="litigantcontact" data-field="x_ContactTypeID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" id="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($litigantcontact->ContactTypeID->FormValue) ?>">
<input type="hidden" data-table="litigantcontact" data-field="x_ContactTypeID" name="o<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($litigantcontact->ContactTypeID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="litigantcontact" data-field="x_ContactTypeID" name="flitigantcontactgrid$x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" id="flitigantcontactgrid$x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($litigantcontact->ContactTypeID->FormValue) ?>">
<input type="hidden" data-table="litigantcontact" data-field="x_ContactTypeID" name="flitigantcontactgrid$o<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" id="flitigantcontactgrid$o<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($litigantcontact->ContactTypeID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($litigantcontact->Contact->Visible) { // Contact ?>
		<td data-name="Contact"<?php echo $litigantcontact->Contact->cellAttributes() ?>>
<?php if ($litigantcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_Contact" class="form-group litigantcontact_Contact">
<input type="text" data-table="litigantcontact" data-field="x_Contact" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigantcontact->Contact->getPlaceHolder()) ?>" value="<?php echo $litigantcontact->Contact->EditValue ?>"<?php echo $litigantcontact->Contact->editAttributes() ?>>
</span>
<input type="hidden" data-table="litigantcontact" data-field="x_Contact" name="o<?php echo $litigantcontact_grid->RowIndex ?>_Contact" id="o<?php echo $litigantcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($litigantcontact->Contact->OldValue) ?>">
<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_Contact" class="form-group litigantcontact_Contact">
<input type="text" data-table="litigantcontact" data-field="x_Contact" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigantcontact->Contact->getPlaceHolder()) ?>" value="<?php echo $litigantcontact->Contact->EditValue ?>"<?php echo $litigantcontact->Contact->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_Contact" class="litigantcontact_Contact">
<span<?php echo $litigantcontact->Contact->viewAttributes() ?>>
<?php echo $litigantcontact->Contact->getViewValue() ?></span>
</span>
<?php if (!$litigantcontact->isConfirm()) { ?>
<input type="hidden" data-table="litigantcontact" data-field="x_Contact" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($litigantcontact->Contact->FormValue) ?>">
<input type="hidden" data-table="litigantcontact" data-field="x_Contact" name="o<?php echo $litigantcontact_grid->RowIndex ?>_Contact" id="o<?php echo $litigantcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($litigantcontact->Contact->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="litigantcontact" data-field="x_Contact" name="flitigantcontactgrid$x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" id="flitigantcontactgrid$x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($litigantcontact->Contact->FormValue) ?>">
<input type="hidden" data-table="litigantcontact" data-field="x_Contact" name="flitigantcontactgrid$o<?php echo $litigantcontact_grid->RowIndex ?>_Contact" id="flitigantcontactgrid$o<?php echo $litigantcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($litigantcontact->Contact->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($litigantcontact->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $litigantcontact->Notes->cellAttributes() ?>>
<?php if ($litigantcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_Notes" class="form-group litigantcontact_Notes">
<input type="text" data-table="litigantcontact" data-field="x_Notes" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($litigantcontact->Notes->getPlaceHolder()) ?>" value="<?php echo $litigantcontact->Notes->EditValue ?>"<?php echo $litigantcontact->Notes->editAttributes() ?>>
</span>
<input type="hidden" data-table="litigantcontact" data-field="x_Notes" name="o<?php echo $litigantcontact_grid->RowIndex ?>_Notes" id="o<?php echo $litigantcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($litigantcontact->Notes->OldValue) ?>">
<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_Notes" class="form-group litigantcontact_Notes">
<input type="text" data-table="litigantcontact" data-field="x_Notes" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($litigantcontact->Notes->getPlaceHolder()) ?>" value="<?php echo $litigantcontact->Notes->EditValue ?>"<?php echo $litigantcontact->Notes->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_Notes" class="litigantcontact_Notes">
<span<?php echo $litigantcontact->Notes->viewAttributes() ?>>
<?php echo $litigantcontact->Notes->getViewValue() ?></span>
</span>
<?php if (!$litigantcontact->isConfirm()) { ?>
<input type="hidden" data-table="litigantcontact" data-field="x_Notes" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($litigantcontact->Notes->FormValue) ?>">
<input type="hidden" data-table="litigantcontact" data-field="x_Notes" name="o<?php echo $litigantcontact_grid->RowIndex ?>_Notes" id="o<?php echo $litigantcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($litigantcontact->Notes->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="litigantcontact" data-field="x_Notes" name="flitigantcontactgrid$x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" id="flitigantcontactgrid$x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($litigantcontact->Notes->FormValue) ?>">
<input type="hidden" data-table="litigantcontact" data-field="x_Notes" name="flitigantcontactgrid$o<?php echo $litigantcontact_grid->RowIndex ?>_Notes" id="flitigantcontactgrid$o<?php echo $litigantcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($litigantcontact->Notes->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($litigantcontact->Primary->Visible) { // Primary ?>
		<td data-name="Primary"<?php echo $litigantcontact->Primary->cellAttributes() ?>>
<?php if ($litigantcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_Primary" class="form-group litigantcontact_Primary">
<?php
$selwrk = (ConvertToBool($litigantcontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="litigantcontact" data-field="x_Primary" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $litigantcontact->Primary->editAttributes() ?>>
</span>
<input type="hidden" data-table="litigantcontact" data-field="x_Primary" name="o<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($litigantcontact->Primary->OldValue) ?>">
<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_Primary" class="form-group litigantcontact_Primary">
<?php
$selwrk = (ConvertToBool($litigantcontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="litigantcontact" data-field="x_Primary" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $litigantcontact->Primary->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($litigantcontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $litigantcontact_grid->RowCnt ?>_litigantcontact_Primary" class="litigantcontact_Primary">
<span<?php echo $litigantcontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($litigantcontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $litigantcontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $litigantcontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
<?php if (!$litigantcontact->isConfirm()) { ?>
<input type="hidden" data-table="litigantcontact" data-field="x_Primary" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Primary" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($litigantcontact->Primary->FormValue) ?>">
<input type="hidden" data-table="litigantcontact" data-field="x_Primary" name="o<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($litigantcontact->Primary->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="litigantcontact" data-field="x_Primary" name="flitigantcontactgrid$x<?php echo $litigantcontact_grid->RowIndex ?>_Primary" id="flitigantcontactgrid$x<?php echo $litigantcontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($litigantcontact->Primary->FormValue) ?>">
<input type="hidden" data-table="litigantcontact" data-field="x_Primary" name="flitigantcontactgrid$o<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" id="flitigantcontactgrid$o<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($litigantcontact->Primary->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$litigantcontact_grid->ListOptions->render("body", "right", $litigantcontact_grid->RowCnt);
?>
	</tr>
<?php if ($litigantcontact->RowType == ROWTYPE_ADD || $litigantcontact->RowType == ROWTYPE_EDIT) { ?>
<script>
flitigantcontactgrid.updateLists(<?php echo $litigantcontact_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$litigantcontact->isGridAdd() || $litigantcontact->CurrentMode == "copy")
		if (!$litigantcontact_grid->Recordset->EOF)
			$litigantcontact_grid->Recordset->moveNext();
}
?>
<?php
	if ($litigantcontact->CurrentMode == "add" || $litigantcontact->CurrentMode == "copy" || $litigantcontact->CurrentMode == "edit") {
		$litigantcontact_grid->RowIndex = '$rowindex$';
		$litigantcontact_grid->loadRowValues();

		// Set row properties
		$litigantcontact->resetAttributes();
		$litigantcontact->RowAttrs = array_merge($litigantcontact->RowAttrs, array('data-rowindex'=>$litigantcontact_grid->RowIndex, 'id'=>'r0_litigantcontact', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($litigantcontact->RowAttrs["class"], "ew-template");
		$litigantcontact->RowType = ROWTYPE_ADD;

		// Render row
		$litigantcontact_grid->renderRow();

		// Render list options
		$litigantcontact_grid->renderListOptions();
		$litigantcontact_grid->StartRowCnt = 0;
?>
	<tr<?php echo $litigantcontact->rowAttributes() ?>>
<?php

// Render list options (body, left)
$litigantcontact_grid->ListOptions->render("body", "left", $litigantcontact_grid->RowIndex);
?>
	<?php if ($litigantcontact->LitigantID->Visible) { // LitigantID ?>
		<td data-name="LitigantID">
<?php if (!$litigantcontact->isConfirm()) { ?>
<?php if ($litigantcontact->LitigantID->getSessionValue() <> "") { ?>
<span id="el$rowindex$_litigantcontact_LitigantID" class="form-group litigantcontact_LitigantID">
<span<?php echo $litigantcontact->LitigantID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($litigantcontact->LitigantID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($litigantcontact->LitigantID->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_litigantcontact_LitigantID" class="form-group litigantcontact_LitigantID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="litigantcontact" data-field="x_LitigantID" data-value-separator="<?php echo $litigantcontact->LitigantID->displayValueSeparatorAttribute() ?>" id="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID"<?php echo $litigantcontact->LitigantID->editAttributes() ?>>
		<?php echo $litigantcontact->LitigantID->selectOptionListHtml("x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID") ?>
	</select>
</div>
<?php echo $litigantcontact->LitigantID->Lookup->getParamTag("p_x" . $litigantcontact_grid->RowIndex . "_LitigantID") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_litigantcontact_LitigantID" class="form-group litigantcontact_LitigantID">
<span<?php echo $litigantcontact->LitigantID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($litigantcontact->LitigantID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="litigantcontact" data-field="x_LitigantID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" id="x<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($litigantcontact->LitigantID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="litigantcontact" data-field="x_LitigantID" name="o<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" id="o<?php echo $litigantcontact_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($litigantcontact->LitigantID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($litigantcontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<td data-name="ContactTypeID">
<?php if (!$litigantcontact->isConfirm()) { ?>
<span id="el$rowindex$_litigantcontact_ContactTypeID" class="form-group litigantcontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="litigantcontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $litigantcontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID"<?php echo $litigantcontact->ContactTypeID->editAttributes() ?>>
		<?php echo $litigantcontact->ContactTypeID->selectOptionListHtml("x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $litigantcontact->ContactTypeID->Lookup->getParamTag("p_x" . $litigantcontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_litigantcontact_ContactTypeID" class="form-group litigantcontact_ContactTypeID">
<span<?php echo $litigantcontact->ContactTypeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($litigantcontact->ContactTypeID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="litigantcontact" data-field="x_ContactTypeID" name="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" id="x<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($litigantcontact->ContactTypeID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="litigantcontact" data-field="x_ContactTypeID" name="o<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $litigantcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($litigantcontact->ContactTypeID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($litigantcontact->Contact->Visible) { // Contact ?>
		<td data-name="Contact">
<?php if (!$litigantcontact->isConfirm()) { ?>
<span id="el$rowindex$_litigantcontact_Contact" class="form-group litigantcontact_Contact">
<input type="text" data-table="litigantcontact" data-field="x_Contact" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigantcontact->Contact->getPlaceHolder()) ?>" value="<?php echo $litigantcontact->Contact->EditValue ?>"<?php echo $litigantcontact->Contact->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_litigantcontact_Contact" class="form-group litigantcontact_Contact">
<span<?php echo $litigantcontact->Contact->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($litigantcontact->Contact->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="litigantcontact" data-field="x_Contact" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($litigantcontact->Contact->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="litigantcontact" data-field="x_Contact" name="o<?php echo $litigantcontact_grid->RowIndex ?>_Contact" id="o<?php echo $litigantcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($litigantcontact->Contact->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($litigantcontact->Notes->Visible) { // Notes ?>
		<td data-name="Notes">
<?php if (!$litigantcontact->isConfirm()) { ?>
<span id="el$rowindex$_litigantcontact_Notes" class="form-group litigantcontact_Notes">
<input type="text" data-table="litigantcontact" data-field="x_Notes" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($litigantcontact->Notes->getPlaceHolder()) ?>" value="<?php echo $litigantcontact->Notes->EditValue ?>"<?php echo $litigantcontact->Notes->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_litigantcontact_Notes" class="form-group litigantcontact_Notes">
<span<?php echo $litigantcontact->Notes->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($litigantcontact->Notes->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="litigantcontact" data-field="x_Notes" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($litigantcontact->Notes->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="litigantcontact" data-field="x_Notes" name="o<?php echo $litigantcontact_grid->RowIndex ?>_Notes" id="o<?php echo $litigantcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($litigantcontact->Notes->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($litigantcontact->Primary->Visible) { // Primary ?>
		<td data-name="Primary">
<?php if (!$litigantcontact->isConfirm()) { ?>
<span id="el$rowindex$_litigantcontact_Primary" class="form-group litigantcontact_Primary">
<?php
$selwrk = (ConvertToBool($litigantcontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="litigantcontact" data-field="x_Primary" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $litigantcontact->Primary->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_litigantcontact_Primary" class="form-group litigantcontact_Primary">
<span<?php echo $litigantcontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($litigantcontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $litigantcontact->Primary->ViewValue ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $litigantcontact->Primary->ViewValue ?>" disabled>
<?php } ?>
</span>
</span>
<input type="hidden" data-table="litigantcontact" data-field="x_Primary" name="x<?php echo $litigantcontact_grid->RowIndex ?>_Primary" id="x<?php echo $litigantcontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($litigantcontact->Primary->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="litigantcontact" data-field="x_Primary" name="o<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $litigantcontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($litigantcontact->Primary->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$litigantcontact_grid->ListOptions->render("body", "right", $litigantcontact_grid->RowIndex);
?>
<script>
flitigantcontactgrid.updateLists(<?php echo $litigantcontact_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($litigantcontact->CurrentMode == "add" || $litigantcontact->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $litigantcontact_grid->FormKeyCountName ?>" id="<?php echo $litigantcontact_grid->FormKeyCountName ?>" value="<?php echo $litigantcontact_grid->KeyCount ?>">
<?php echo $litigantcontact_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($litigantcontact->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $litigantcontact_grid->FormKeyCountName ?>" id="<?php echo $litigantcontact_grid->FormKeyCountName ?>" value="<?php echo $litigantcontact_grid->KeyCount ?>">
<?php echo $litigantcontact_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($litigantcontact->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="flitigantcontactgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($litigantcontact_grid->Recordset)
	$litigantcontact_grid->Recordset->Close();
?>
</div>
<?php if ($litigantcontact_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $litigantcontact_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($litigantcontact_grid->TotalRecs == 0 && !$litigantcontact->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $litigantcontact_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$litigantcontact_grid->terminate();
?>
<?php if (!$litigantcontact->isExport()) { ?>
<script>
ew.scrollableTable("gmp_litigantcontact", "", "");
</script>
<?php } ?>
