<?php
namespace PHPMaker2019\project_germanos;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($lawyeraddress_grid))
	$lawyeraddress_grid = new lawyeraddress_grid();

// Run the page
$lawyeraddress_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawyeraddress_grid->Page_Render();
?>
<?php if (!$lawyeraddress->isExport()) { ?>
<script>

// Form object
var flawyeraddressgrid = new ew.Form("flawyeraddressgrid", "grid");
flawyeraddressgrid.formKeyCountName = '<?php echo $lawyeraddress_grid->FormKeyCountName ?>';

// Validate form
flawyeraddressgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($lawyeraddress_grid->LawyerID->Required) { ?>
			elm = this.getElements("x" + infix + "_LawyerID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyeraddress->LawyerID->caption(), $lawyeraddress->LawyerID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyeraddress_grid->AddressTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_AddressTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyeraddress->AddressTypeID->caption(), $lawyeraddress->AddressTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyeraddress_grid->Address->Required) { ?>
			elm = this.getElements("x" + infix + "_Address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyeraddress->Address->caption(), $lawyeraddress->Address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyeraddress_grid->City->Required) { ?>
			elm = this.getElements("x" + infix + "_City");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyeraddress->City->caption(), $lawyeraddress->City->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyeraddress_grid->Region->Required) { ?>
			elm = this.getElements("x" + infix + "_Region");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyeraddress->Region->caption(), $lawyeraddress->Region->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyeraddress_grid->PostalCode->Required) { ?>
			elm = this.getElements("x" + infix + "_PostalCode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyeraddress->PostalCode->caption(), $lawyeraddress->PostalCode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyeraddress_grid->Country->Required) { ?>
			elm = this.getElements("x" + infix + "_Country");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyeraddress->Country->caption(), $lawyeraddress->Country->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyeraddress_grid->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyeraddress->Notes->caption(), $lawyeraddress->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyeraddress_grid->Primary->Required) { ?>
			elm = this.getElements("x" + infix + "_Primary[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyeraddress->Primary->caption(), $lawyeraddress->Primary->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
flawyeraddressgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "LawyerID", false)) return false;
	if (ew.valueChanged(fobj, infix, "AddressTypeID", false)) return false;
	if (ew.valueChanged(fobj, infix, "Address", false)) return false;
	if (ew.valueChanged(fobj, infix, "City", false)) return false;
	if (ew.valueChanged(fobj, infix, "Region", false)) return false;
	if (ew.valueChanged(fobj, infix, "PostalCode", false)) return false;
	if (ew.valueChanged(fobj, infix, "Country", false)) return false;
	if (ew.valueChanged(fobj, infix, "Notes", false)) return false;
	if (ew.valueChanged(fobj, infix, "Primary[]", true)) return false;
	return true;
}

// Form_CustomValidate event
flawyeraddressgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyeraddressgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawyeraddressgrid.lists["x_LawyerID"] = <?php echo $lawyeraddress_grid->LawyerID->Lookup->toClientList() ?>;
flawyeraddressgrid.lists["x_LawyerID"].options = <?php echo JsonEncode($lawyeraddress_grid->LawyerID->lookupOptions()) ?>;
flawyeraddressgrid.lists["x_AddressTypeID"] = <?php echo $lawyeraddress_grid->AddressTypeID->Lookup->toClientList() ?>;
flawyeraddressgrid.lists["x_AddressTypeID"].options = <?php echo JsonEncode($lawyeraddress_grid->AddressTypeID->lookupOptions()) ?>;
flawyeraddressgrid.lists["x_Primary[]"] = <?php echo $lawyeraddress_grid->Primary->Lookup->toClientList() ?>;
flawyeraddressgrid.lists["x_Primary[]"].options = <?php echo JsonEncode($lawyeraddress_grid->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$lawyeraddress_grid->renderOtherOptions();
?>
<?php $lawyeraddress_grid->showPageHeader(); ?>
<?php
$lawyeraddress_grid->showMessage();
?>
<?php if ($lawyeraddress_grid->TotalRecs > 0 || $lawyeraddress->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($lawyeraddress_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> lawyeraddress">
<?php if ($lawyeraddress_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $lawyeraddress_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="flawyeraddressgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_lawyeraddress" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_lawyeraddressgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$lawyeraddress_grid->RowType = ROWTYPE_HEADER;

// Render list options
$lawyeraddress_grid->renderListOptions();

// Render list options (header, left)
$lawyeraddress_grid->ListOptions->render("header", "left");
?>
<?php if ($lawyeraddress->LawyerID->Visible) { // LawyerID ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->LawyerID) == "") { ?>
		<th data-name="LawyerID" class="<?php echo $lawyeraddress->LawyerID->headerCellClass() ?>"><div id="elh_lawyeraddress_LawyerID" class="lawyeraddress_LawyerID"><div class="ew-table-header-caption"><?php echo $lawyeraddress->LawyerID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LawyerID" class="<?php echo $lawyeraddress->LawyerID->headerCellClass() ?>"><div><div id="elh_lawyeraddress_LawyerID" class="lawyeraddress_LawyerID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->LawyerID->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->LawyerID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->LawyerID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->AddressTypeID->Visible) { // AddressTypeID ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->AddressTypeID) == "") { ?>
		<th data-name="AddressTypeID" class="<?php echo $lawyeraddress->AddressTypeID->headerCellClass() ?>"><div id="elh_lawyeraddress_AddressTypeID" class="lawyeraddress_AddressTypeID"><div class="ew-table-header-caption"><?php echo $lawyeraddress->AddressTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AddressTypeID" class="<?php echo $lawyeraddress->AddressTypeID->headerCellClass() ?>"><div><div id="elh_lawyeraddress_AddressTypeID" class="lawyeraddress_AddressTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->AddressTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->AddressTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->AddressTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->Address->Visible) { // Address ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->Address) == "") { ?>
		<th data-name="Address" class="<?php echo $lawyeraddress->Address->headerCellClass() ?>"><div id="elh_lawyeraddress_Address" class="lawyeraddress_Address"><div class="ew-table-header-caption"><?php echo $lawyeraddress->Address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Address" class="<?php echo $lawyeraddress->Address->headerCellClass() ?>"><div><div id="elh_lawyeraddress_Address" class="lawyeraddress_Address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->Address->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->Address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->Address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->City->Visible) { // City ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->City) == "") { ?>
		<th data-name="City" class="<?php echo $lawyeraddress->City->headerCellClass() ?>"><div id="elh_lawyeraddress_City" class="lawyeraddress_City"><div class="ew-table-header-caption"><?php echo $lawyeraddress->City->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="City" class="<?php echo $lawyeraddress->City->headerCellClass() ?>"><div><div id="elh_lawyeraddress_City" class="lawyeraddress_City">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->City->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->City->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->City->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->Region->Visible) { // Region ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->Region) == "") { ?>
		<th data-name="Region" class="<?php echo $lawyeraddress->Region->headerCellClass() ?>"><div id="elh_lawyeraddress_Region" class="lawyeraddress_Region"><div class="ew-table-header-caption"><?php echo $lawyeraddress->Region->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Region" class="<?php echo $lawyeraddress->Region->headerCellClass() ?>"><div><div id="elh_lawyeraddress_Region" class="lawyeraddress_Region">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->Region->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->Region->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->Region->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->PostalCode->Visible) { // PostalCode ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->PostalCode) == "") { ?>
		<th data-name="PostalCode" class="<?php echo $lawyeraddress->PostalCode->headerCellClass() ?>"><div id="elh_lawyeraddress_PostalCode" class="lawyeraddress_PostalCode"><div class="ew-table-header-caption"><?php echo $lawyeraddress->PostalCode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PostalCode" class="<?php echo $lawyeraddress->PostalCode->headerCellClass() ?>"><div><div id="elh_lawyeraddress_PostalCode" class="lawyeraddress_PostalCode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->PostalCode->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->PostalCode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->PostalCode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->Country->Visible) { // Country ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->Country) == "") { ?>
		<th data-name="Country" class="<?php echo $lawyeraddress->Country->headerCellClass() ?>"><div id="elh_lawyeraddress_Country" class="lawyeraddress_Country"><div class="ew-table-header-caption"><?php echo $lawyeraddress->Country->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Country" class="<?php echo $lawyeraddress->Country->headerCellClass() ?>"><div><div id="elh_lawyeraddress_Country" class="lawyeraddress_Country">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->Country->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->Country->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->Country->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->Notes->Visible) { // Notes ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $lawyeraddress->Notes->headerCellClass() ?>"><div id="elh_lawyeraddress_Notes" class="lawyeraddress_Notes"><div class="ew-table-header-caption"><?php echo $lawyeraddress->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $lawyeraddress->Notes->headerCellClass() ?>"><div><div id="elh_lawyeraddress_Notes" class="lawyeraddress_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->Notes->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->Primary->Visible) { // Primary ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->Primary) == "") { ?>
		<th data-name="Primary" class="<?php echo $lawyeraddress->Primary->headerCellClass() ?>"><div id="elh_lawyeraddress_Primary" class="lawyeraddress_Primary"><div class="ew-table-header-caption"><?php echo $lawyeraddress->Primary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primary" class="<?php echo $lawyeraddress->Primary->headerCellClass() ?>"><div><div id="elh_lawyeraddress_Primary" class="lawyeraddress_Primary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->Primary->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->Primary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->Primary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$lawyeraddress_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$lawyeraddress_grid->StartRec = 1;
$lawyeraddress_grid->StopRec = $lawyeraddress_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $lawyeraddress_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($lawyeraddress_grid->FormKeyCountName) && ($lawyeraddress->isGridAdd() || $lawyeraddress->isGridEdit() || $lawyeraddress->isConfirm())) {
		$lawyeraddress_grid->KeyCount = $CurrentForm->getValue($lawyeraddress_grid->FormKeyCountName);
		$lawyeraddress_grid->StopRec = $lawyeraddress_grid->StartRec + $lawyeraddress_grid->KeyCount - 1;
	}
}
$lawyeraddress_grid->RecCnt = $lawyeraddress_grid->StartRec - 1;
if ($lawyeraddress_grid->Recordset && !$lawyeraddress_grid->Recordset->EOF) {
	$lawyeraddress_grid->Recordset->moveFirst();
	$selectLimit = $lawyeraddress_grid->UseSelectLimit;
	if (!$selectLimit && $lawyeraddress_grid->StartRec > 1)
		$lawyeraddress_grid->Recordset->move($lawyeraddress_grid->StartRec - 1);
} elseif (!$lawyeraddress->AllowAddDeleteRow && $lawyeraddress_grid->StopRec == 0) {
	$lawyeraddress_grid->StopRec = $lawyeraddress->GridAddRowCount;
}

// Initialize aggregate
$lawyeraddress->RowType = ROWTYPE_AGGREGATEINIT;
$lawyeraddress->resetAttributes();
$lawyeraddress_grid->renderRow();
if ($lawyeraddress->isGridAdd())
	$lawyeraddress_grid->RowIndex = 0;
if ($lawyeraddress->isGridEdit())
	$lawyeraddress_grid->RowIndex = 0;
while ($lawyeraddress_grid->RecCnt < $lawyeraddress_grid->StopRec) {
	$lawyeraddress_grid->RecCnt++;
	if ($lawyeraddress_grid->RecCnt >= $lawyeraddress_grid->StartRec) {
		$lawyeraddress_grid->RowCnt++;
		if ($lawyeraddress->isGridAdd() || $lawyeraddress->isGridEdit() || $lawyeraddress->isConfirm()) {
			$lawyeraddress_grid->RowIndex++;
			$CurrentForm->Index = $lawyeraddress_grid->RowIndex;
			if ($CurrentForm->hasValue($lawyeraddress_grid->FormActionName) && $lawyeraddress_grid->EventCancelled)
				$lawyeraddress_grid->RowAction = strval($CurrentForm->getValue($lawyeraddress_grid->FormActionName));
			elseif ($lawyeraddress->isGridAdd())
				$lawyeraddress_grid->RowAction = "insert";
			else
				$lawyeraddress_grid->RowAction = "";
		}

		// Set up key count
		$lawyeraddress_grid->KeyCount = $lawyeraddress_grid->RowIndex;

		// Init row class and style
		$lawyeraddress->resetAttributes();
		$lawyeraddress->CssClass = "";
		if ($lawyeraddress->isGridAdd()) {
			if ($lawyeraddress->CurrentMode == "copy") {
				$lawyeraddress_grid->loadRowValues($lawyeraddress_grid->Recordset); // Load row values
				$lawyeraddress_grid->setRecordKey($lawyeraddress_grid->RowOldKey, $lawyeraddress_grid->Recordset); // Set old record key
			} else {
				$lawyeraddress_grid->loadRowValues(); // Load default values
				$lawyeraddress_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$lawyeraddress_grid->loadRowValues($lawyeraddress_grid->Recordset); // Load row values
		}
		$lawyeraddress->RowType = ROWTYPE_VIEW; // Render view
		if ($lawyeraddress->isGridAdd()) // Grid add
			$lawyeraddress->RowType = ROWTYPE_ADD; // Render add
		if ($lawyeraddress->isGridAdd() && $lawyeraddress->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$lawyeraddress_grid->restoreCurrentRowFormValues($lawyeraddress_grid->RowIndex); // Restore form values
		if ($lawyeraddress->isGridEdit()) { // Grid edit
			if ($lawyeraddress->EventCancelled)
				$lawyeraddress_grid->restoreCurrentRowFormValues($lawyeraddress_grid->RowIndex); // Restore form values
			if ($lawyeraddress_grid->RowAction == "insert")
				$lawyeraddress->RowType = ROWTYPE_ADD; // Render add
			else
				$lawyeraddress->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($lawyeraddress->isGridEdit() && ($lawyeraddress->RowType == ROWTYPE_EDIT || $lawyeraddress->RowType == ROWTYPE_ADD) && $lawyeraddress->EventCancelled) // Update failed
			$lawyeraddress_grid->restoreCurrentRowFormValues($lawyeraddress_grid->RowIndex); // Restore form values
		if ($lawyeraddress->RowType == ROWTYPE_EDIT) // Edit row
			$lawyeraddress_grid->EditRowCnt++;
		if ($lawyeraddress->isConfirm()) // Confirm row
			$lawyeraddress_grid->restoreCurrentRowFormValues($lawyeraddress_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$lawyeraddress->RowAttrs = array_merge($lawyeraddress->RowAttrs, array('data-rowindex'=>$lawyeraddress_grid->RowCnt, 'id'=>'r' . $lawyeraddress_grid->RowCnt . '_lawyeraddress', 'data-rowtype'=>$lawyeraddress->RowType));

		// Render row
		$lawyeraddress_grid->renderRow();

		// Render list options
		$lawyeraddress_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($lawyeraddress_grid->RowAction <> "delete" && $lawyeraddress_grid->RowAction <> "insertdelete" && !($lawyeraddress_grid->RowAction == "insert" && $lawyeraddress->isConfirm() && $lawyeraddress_grid->emptyRow())) {
?>
	<tr<?php echo $lawyeraddress->rowAttributes() ?>>
<?php

// Render list options (body, left)
$lawyeraddress_grid->ListOptions->render("body", "left", $lawyeraddress_grid->RowCnt);
?>
	<?php if ($lawyeraddress->LawyerID->Visible) { // LawyerID ?>
		<td data-name="LawyerID"<?php echo $lawyeraddress->LawyerID->cellAttributes() ?>>
<?php if ($lawyeraddress->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($lawyeraddress->LawyerID->getSessionValue() <> "") { ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_LawyerID" class="form-group lawyeraddress_LawyerID">
<span<?php echo $lawyeraddress->LawyerID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyeraddress->LawyerID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyeraddress->LawyerID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_LawyerID" class="form-group lawyeraddress_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyeraddress" data-field="x_LawyerID" data-value-separator="<?php echo $lawyeraddress->LawyerID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID"<?php echo $lawyeraddress->LawyerID->editAttributes() ?>>
		<?php echo $lawyeraddress->LawyerID->selectOptionListHtml("x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID") ?>
	</select>
</div>
<?php echo $lawyeraddress->LawyerID->Lookup->getParamTag("p_x" . $lawyeraddress_grid->RowIndex . "_LawyerID") ?>
</span>
<?php } ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_LawyerID" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyeraddress->LawyerID->OldValue) ?>">
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($lawyeraddress->LawyerID->getSessionValue() <> "") { ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_LawyerID" class="form-group lawyeraddress_LawyerID">
<span<?php echo $lawyeraddress->LawyerID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyeraddress->LawyerID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyeraddress->LawyerID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_LawyerID" class="form-group lawyeraddress_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyeraddress" data-field="x_LawyerID" data-value-separator="<?php echo $lawyeraddress->LawyerID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID"<?php echo $lawyeraddress->LawyerID->editAttributes() ?>>
		<?php echo $lawyeraddress->LawyerID->selectOptionListHtml("x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID") ?>
	</select>
</div>
<?php echo $lawyeraddress->LawyerID->Lookup->getParamTag("p_x" . $lawyeraddress_grid->RowIndex . "_LawyerID") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_LawyerID" class="lawyeraddress_LawyerID">
<span<?php echo $lawyeraddress->LawyerID->viewAttributes() ?>>
<?php echo $lawyeraddress->LawyerID->getViewValue() ?></span>
</span>
<?php if (!$lawyeraddress->isConfirm()) { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_LawyerID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyeraddress->LawyerID->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_LawyerID" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyeraddress->LawyerID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_LawyerID" name="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" id="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyeraddress->LawyerID->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_LawyerID" name="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" id="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyeraddress->LawyerID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_AddressID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressID" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressID" value="<?php echo HtmlEncode($lawyeraddress->AddressID->CurrentValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_AddressID" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_AddressID" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_AddressID" value="<?php echo HtmlEncode($lawyeraddress->AddressID->OldValue) ?>">
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_EDIT || $lawyeraddress->CurrentMode == "edit") { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_AddressID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressID" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressID" value="<?php echo HtmlEncode($lawyeraddress->AddressID->CurrentValue) ?>">
<?php } ?>
	<?php if ($lawyeraddress->AddressTypeID->Visible) { // AddressTypeID ?>
		<td data-name="AddressTypeID"<?php echo $lawyeraddress->AddressTypeID->cellAttributes() ?>>
<?php if ($lawyeraddress->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_AddressTypeID" class="form-group lawyeraddress_AddressTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyeraddress" data-field="x_AddressTypeID" data-value-separator="<?php echo $lawyeraddress->AddressTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID"<?php echo $lawyeraddress->AddressTypeID->editAttributes() ?>>
		<?php echo $lawyeraddress->AddressTypeID->selectOptionListHtml("x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID") ?>
	</select>
</div>
<?php echo $lawyeraddress->AddressTypeID->Lookup->getParamTag("p_x" . $lawyeraddress_grid->RowIndex . "_AddressTypeID") ?>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_AddressTypeID" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" value="<?php echo HtmlEncode($lawyeraddress->AddressTypeID->OldValue) ?>">
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_AddressTypeID" class="form-group lawyeraddress_AddressTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyeraddress" data-field="x_AddressTypeID" data-value-separator="<?php echo $lawyeraddress->AddressTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID"<?php echo $lawyeraddress->AddressTypeID->editAttributes() ?>>
		<?php echo $lawyeraddress->AddressTypeID->selectOptionListHtml("x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID") ?>
	</select>
</div>
<?php echo $lawyeraddress->AddressTypeID->Lookup->getParamTag("p_x" . $lawyeraddress_grid->RowIndex . "_AddressTypeID") ?>
</span>
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_AddressTypeID" class="lawyeraddress_AddressTypeID">
<span<?php echo $lawyeraddress->AddressTypeID->viewAttributes() ?>>
<?php echo $lawyeraddress->AddressTypeID->getViewValue() ?></span>
</span>
<?php if (!$lawyeraddress->isConfirm()) { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_AddressTypeID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" value="<?php echo HtmlEncode($lawyeraddress->AddressTypeID->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_AddressTypeID" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" value="<?php echo HtmlEncode($lawyeraddress->AddressTypeID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_AddressTypeID" name="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" id="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" value="<?php echo HtmlEncode($lawyeraddress->AddressTypeID->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_AddressTypeID" name="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" id="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" value="<?php echo HtmlEncode($lawyeraddress->AddressTypeID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Address->Visible) { // Address ?>
		<td data-name="Address"<?php echo $lawyeraddress->Address->cellAttributes() ?>>
<?php if ($lawyeraddress->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Address" class="form-group lawyeraddress_Address">
<input type="text" data-table="lawyeraddress" data-field="x_Address" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($lawyeraddress->Address->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Address->EditValue ?>"<?php echo $lawyeraddress->Address->editAttributes() ?>>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_Address" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Address" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Address" value="<?php echo HtmlEncode($lawyeraddress->Address->OldValue) ?>">
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Address" class="form-group lawyeraddress_Address">
<input type="text" data-table="lawyeraddress" data-field="x_Address" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($lawyeraddress->Address->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Address->EditValue ?>"<?php echo $lawyeraddress->Address->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Address" class="lawyeraddress_Address">
<span<?php echo $lawyeraddress->Address->viewAttributes() ?>>
<?php echo $lawyeraddress->Address->getViewValue() ?></span>
</span>
<?php if (!$lawyeraddress->isConfirm()) { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Address" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" value="<?php echo HtmlEncode($lawyeraddress->Address->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_Address" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Address" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Address" value="<?php echo HtmlEncode($lawyeraddress->Address->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Address" name="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" id="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" value="<?php echo HtmlEncode($lawyeraddress->Address->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_Address" name="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_Address" id="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_Address" value="<?php echo HtmlEncode($lawyeraddress->Address->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->City->Visible) { // City ?>
		<td data-name="City"<?php echo $lawyeraddress->City->cellAttributes() ?>>
<?php if ($lawyeraddress->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_City" class="form-group lawyeraddress_City">
<input type="text" data-table="lawyeraddress" data-field="x_City" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_City" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_City" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($lawyeraddress->City->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->City->EditValue ?>"<?php echo $lawyeraddress->City->editAttributes() ?>>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_City" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_City" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_City" value="<?php echo HtmlEncode($lawyeraddress->City->OldValue) ?>">
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_City" class="form-group lawyeraddress_City">
<input type="text" data-table="lawyeraddress" data-field="x_City" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_City" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_City" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($lawyeraddress->City->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->City->EditValue ?>"<?php echo $lawyeraddress->City->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_City" class="lawyeraddress_City">
<span<?php echo $lawyeraddress->City->viewAttributes() ?>>
<?php echo $lawyeraddress->City->getViewValue() ?></span>
</span>
<?php if (!$lawyeraddress->isConfirm()) { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_City" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_City" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_City" value="<?php echo HtmlEncode($lawyeraddress->City->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_City" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_City" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_City" value="<?php echo HtmlEncode($lawyeraddress->City->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_City" name="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_City" id="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_City" value="<?php echo HtmlEncode($lawyeraddress->City->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_City" name="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_City" id="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_City" value="<?php echo HtmlEncode($lawyeraddress->City->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Region->Visible) { // Region ?>
		<td data-name="Region"<?php echo $lawyeraddress->Region->cellAttributes() ?>>
<?php if ($lawyeraddress->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Region" class="form-group lawyeraddress_Region">
<input type="text" data-table="lawyeraddress" data-field="x_Region" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($lawyeraddress->Region->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Region->EditValue ?>"<?php echo $lawyeraddress->Region->editAttributes() ?>>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_Region" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Region" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Region" value="<?php echo HtmlEncode($lawyeraddress->Region->OldValue) ?>">
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Region" class="form-group lawyeraddress_Region">
<input type="text" data-table="lawyeraddress" data-field="x_Region" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($lawyeraddress->Region->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Region->EditValue ?>"<?php echo $lawyeraddress->Region->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Region" class="lawyeraddress_Region">
<span<?php echo $lawyeraddress->Region->viewAttributes() ?>>
<?php echo $lawyeraddress->Region->getViewValue() ?></span>
</span>
<?php if (!$lawyeraddress->isConfirm()) { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Region" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" value="<?php echo HtmlEncode($lawyeraddress->Region->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_Region" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Region" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Region" value="<?php echo HtmlEncode($lawyeraddress->Region->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Region" name="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" id="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" value="<?php echo HtmlEncode($lawyeraddress->Region->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_Region" name="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_Region" id="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_Region" value="<?php echo HtmlEncode($lawyeraddress->Region->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->PostalCode->Visible) { // PostalCode ?>
		<td data-name="PostalCode"<?php echo $lawyeraddress->PostalCode->cellAttributes() ?>>
<?php if ($lawyeraddress->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_PostalCode" class="form-group lawyeraddress_PostalCode">
<input type="text" data-table="lawyeraddress" data-field="x_PostalCode" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($lawyeraddress->PostalCode->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->PostalCode->EditValue ?>"<?php echo $lawyeraddress->PostalCode->editAttributes() ?>>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_PostalCode" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" value="<?php echo HtmlEncode($lawyeraddress->PostalCode->OldValue) ?>">
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_PostalCode" class="form-group lawyeraddress_PostalCode">
<input type="text" data-table="lawyeraddress" data-field="x_PostalCode" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($lawyeraddress->PostalCode->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->PostalCode->EditValue ?>"<?php echo $lawyeraddress->PostalCode->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_PostalCode" class="lawyeraddress_PostalCode">
<span<?php echo $lawyeraddress->PostalCode->viewAttributes() ?>>
<?php echo $lawyeraddress->PostalCode->getViewValue() ?></span>
</span>
<?php if (!$lawyeraddress->isConfirm()) { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_PostalCode" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" value="<?php echo HtmlEncode($lawyeraddress->PostalCode->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_PostalCode" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" value="<?php echo HtmlEncode($lawyeraddress->PostalCode->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_PostalCode" name="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" id="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" value="<?php echo HtmlEncode($lawyeraddress->PostalCode->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_PostalCode" name="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" id="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" value="<?php echo HtmlEncode($lawyeraddress->PostalCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Country->Visible) { // Country ?>
		<td data-name="Country"<?php echo $lawyeraddress->Country->cellAttributes() ?>>
<?php if ($lawyeraddress->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Country" class="form-group lawyeraddress_Country">
<input type="text" data-table="lawyeraddress" data-field="x_Country" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($lawyeraddress->Country->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Country->EditValue ?>"<?php echo $lawyeraddress->Country->editAttributes() ?>>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_Country" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Country" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Country" value="<?php echo HtmlEncode($lawyeraddress->Country->OldValue) ?>">
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Country" class="form-group lawyeraddress_Country">
<input type="text" data-table="lawyeraddress" data-field="x_Country" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($lawyeraddress->Country->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Country->EditValue ?>"<?php echo $lawyeraddress->Country->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Country" class="lawyeraddress_Country">
<span<?php echo $lawyeraddress->Country->viewAttributes() ?>>
<?php echo $lawyeraddress->Country->getViewValue() ?></span>
</span>
<?php if (!$lawyeraddress->isConfirm()) { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Country" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" value="<?php echo HtmlEncode($lawyeraddress->Country->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_Country" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Country" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Country" value="<?php echo HtmlEncode($lawyeraddress->Country->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Country" name="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" id="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" value="<?php echo HtmlEncode($lawyeraddress->Country->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_Country" name="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_Country" id="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_Country" value="<?php echo HtmlEncode($lawyeraddress->Country->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $lawyeraddress->Notes->cellAttributes() ?>>
<?php if ($lawyeraddress->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Notes" class="form-group lawyeraddress_Notes">
<input type="text" data-table="lawyeraddress" data-field="x_Notes" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lawyeraddress->Notes->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Notes->EditValue ?>"<?php echo $lawyeraddress->Notes->editAttributes() ?>>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_Notes" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyeraddress->Notes->OldValue) ?>">
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Notes" class="form-group lawyeraddress_Notes">
<input type="text" data-table="lawyeraddress" data-field="x_Notes" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lawyeraddress->Notes->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Notes->EditValue ?>"<?php echo $lawyeraddress->Notes->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Notes" class="lawyeraddress_Notes">
<span<?php echo $lawyeraddress->Notes->viewAttributes() ?>>
<?php echo $lawyeraddress->Notes->getViewValue() ?></span>
</span>
<?php if (!$lawyeraddress->isConfirm()) { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Notes" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyeraddress->Notes->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_Notes" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyeraddress->Notes->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Notes" name="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" id="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyeraddress->Notes->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_Notes" name="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" id="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyeraddress->Notes->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Primary->Visible) { // Primary ?>
		<td data-name="Primary"<?php echo $lawyeraddress->Primary->cellAttributes() ?>>
<?php if ($lawyeraddress->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Primary" class="form-group lawyeraddress_Primary">
<?php
$selwrk = (ConvertToBool($lawyeraddress->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="lawyeraddress" data-field="x_Primary" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $lawyeraddress->Primary->editAttributes() ?>>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_Primary" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($lawyeraddress->Primary->OldValue) ?>">
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Primary" class="form-group lawyeraddress_Primary">
<?php
$selwrk = (ConvertToBool($lawyeraddress->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="lawyeraddress" data-field="x_Primary" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $lawyeraddress->Primary->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($lawyeraddress->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyeraddress_grid->RowCnt ?>_lawyeraddress_Primary" class="lawyeraddress_Primary">
<span<?php echo $lawyeraddress->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($lawyeraddress->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $lawyeraddress->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $lawyeraddress->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
<?php if (!$lawyeraddress->isConfirm()) { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Primary" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($lawyeraddress->Primary->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_Primary" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($lawyeraddress->Primary->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Primary" name="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary" id="flawyeraddressgrid$x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($lawyeraddress->Primary->FormValue) ?>">
<input type="hidden" data-table="lawyeraddress" data-field="x_Primary" name="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" id="flawyeraddressgrid$o<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($lawyeraddress->Primary->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$lawyeraddress_grid->ListOptions->render("body", "right", $lawyeraddress_grid->RowCnt);
?>
	</tr>
<?php if ($lawyeraddress->RowType == ROWTYPE_ADD || $lawyeraddress->RowType == ROWTYPE_EDIT) { ?>
<script>
flawyeraddressgrid.updateLists(<?php echo $lawyeraddress_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$lawyeraddress->isGridAdd() || $lawyeraddress->CurrentMode == "copy")
		if (!$lawyeraddress_grid->Recordset->EOF)
			$lawyeraddress_grid->Recordset->moveNext();
}
?>
<?php
	if ($lawyeraddress->CurrentMode == "add" || $lawyeraddress->CurrentMode == "copy" || $lawyeraddress->CurrentMode == "edit") {
		$lawyeraddress_grid->RowIndex = '$rowindex$';
		$lawyeraddress_grid->loadRowValues();

		// Set row properties
		$lawyeraddress->resetAttributes();
		$lawyeraddress->RowAttrs = array_merge($lawyeraddress->RowAttrs, array('data-rowindex'=>$lawyeraddress_grid->RowIndex, 'id'=>'r0_lawyeraddress', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($lawyeraddress->RowAttrs["class"], "ew-template");
		$lawyeraddress->RowType = ROWTYPE_ADD;

		// Render row
		$lawyeraddress_grid->renderRow();

		// Render list options
		$lawyeraddress_grid->renderListOptions();
		$lawyeraddress_grid->StartRowCnt = 0;
?>
	<tr<?php echo $lawyeraddress->rowAttributes() ?>>
<?php

// Render list options (body, left)
$lawyeraddress_grid->ListOptions->render("body", "left", $lawyeraddress_grid->RowIndex);
?>
	<?php if ($lawyeraddress->LawyerID->Visible) { // LawyerID ?>
		<td data-name="LawyerID">
<?php if (!$lawyeraddress->isConfirm()) { ?>
<?php if ($lawyeraddress->LawyerID->getSessionValue() <> "") { ?>
<span id="el$rowindex$_lawyeraddress_LawyerID" class="form-group lawyeraddress_LawyerID">
<span<?php echo $lawyeraddress->LawyerID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyeraddress->LawyerID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyeraddress->LawyerID->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_lawyeraddress_LawyerID" class="form-group lawyeraddress_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyeraddress" data-field="x_LawyerID" data-value-separator="<?php echo $lawyeraddress->LawyerID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID"<?php echo $lawyeraddress->LawyerID->editAttributes() ?>>
		<?php echo $lawyeraddress->LawyerID->selectOptionListHtml("x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID") ?>
	</select>
</div>
<?php echo $lawyeraddress->LawyerID->Lookup->getParamTag("p_x" . $lawyeraddress_grid->RowIndex . "_LawyerID") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_lawyeraddress_LawyerID" class="form-group lawyeraddress_LawyerID">
<span<?php echo $lawyeraddress->LawyerID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyeraddress->LawyerID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_LawyerID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyeraddress->LawyerID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_LawyerID" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyeraddress->LawyerID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyeraddress->AddressTypeID->Visible) { // AddressTypeID ?>
		<td data-name="AddressTypeID">
<?php if (!$lawyeraddress->isConfirm()) { ?>
<span id="el$rowindex$_lawyeraddress_AddressTypeID" class="form-group lawyeraddress_AddressTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyeraddress" data-field="x_AddressTypeID" data-value-separator="<?php echo $lawyeraddress->AddressTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID"<?php echo $lawyeraddress->AddressTypeID->editAttributes() ?>>
		<?php echo $lawyeraddress->AddressTypeID->selectOptionListHtml("x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID") ?>
	</select>
</div>
<?php echo $lawyeraddress->AddressTypeID->Lookup->getParamTag("p_x" . $lawyeraddress_grid->RowIndex . "_AddressTypeID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyeraddress_AddressTypeID" class="form-group lawyeraddress_AddressTypeID">
<span<?php echo $lawyeraddress->AddressTypeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyeraddress->AddressTypeID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_AddressTypeID" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" value="<?php echo HtmlEncode($lawyeraddress->AddressTypeID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_AddressTypeID" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_AddressTypeID" value="<?php echo HtmlEncode($lawyeraddress->AddressTypeID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Address->Visible) { // Address ?>
		<td data-name="Address">
<?php if (!$lawyeraddress->isConfirm()) { ?>
<span id="el$rowindex$_lawyeraddress_Address" class="form-group lawyeraddress_Address">
<input type="text" data-table="lawyeraddress" data-field="x_Address" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($lawyeraddress->Address->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Address->EditValue ?>"<?php echo $lawyeraddress->Address->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyeraddress_Address" class="form-group lawyeraddress_Address">
<span<?php echo $lawyeraddress->Address->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyeraddress->Address->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_Address" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Address" value="<?php echo HtmlEncode($lawyeraddress->Address->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Address" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Address" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Address" value="<?php echo HtmlEncode($lawyeraddress->Address->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyeraddress->City->Visible) { // City ?>
		<td data-name="City">
<?php if (!$lawyeraddress->isConfirm()) { ?>
<span id="el$rowindex$_lawyeraddress_City" class="form-group lawyeraddress_City">
<input type="text" data-table="lawyeraddress" data-field="x_City" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_City" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_City" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($lawyeraddress->City->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->City->EditValue ?>"<?php echo $lawyeraddress->City->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyeraddress_City" class="form-group lawyeraddress_City">
<span<?php echo $lawyeraddress->City->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyeraddress->City->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_City" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_City" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_City" value="<?php echo HtmlEncode($lawyeraddress->City->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_City" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_City" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_City" value="<?php echo HtmlEncode($lawyeraddress->City->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Region->Visible) { // Region ?>
		<td data-name="Region">
<?php if (!$lawyeraddress->isConfirm()) { ?>
<span id="el$rowindex$_lawyeraddress_Region" class="form-group lawyeraddress_Region">
<input type="text" data-table="lawyeraddress" data-field="x_Region" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($lawyeraddress->Region->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Region->EditValue ?>"<?php echo $lawyeraddress->Region->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyeraddress_Region" class="form-group lawyeraddress_Region">
<span<?php echo $lawyeraddress->Region->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyeraddress->Region->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_Region" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Region" value="<?php echo HtmlEncode($lawyeraddress->Region->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Region" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Region" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Region" value="<?php echo HtmlEncode($lawyeraddress->Region->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyeraddress->PostalCode->Visible) { // PostalCode ?>
		<td data-name="PostalCode">
<?php if (!$lawyeraddress->isConfirm()) { ?>
<span id="el$rowindex$_lawyeraddress_PostalCode" class="form-group lawyeraddress_PostalCode">
<input type="text" data-table="lawyeraddress" data-field="x_PostalCode" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($lawyeraddress->PostalCode->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->PostalCode->EditValue ?>"<?php echo $lawyeraddress->PostalCode->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyeraddress_PostalCode" class="form-group lawyeraddress_PostalCode">
<span<?php echo $lawyeraddress->PostalCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyeraddress->PostalCode->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_PostalCode" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" value="<?php echo HtmlEncode($lawyeraddress->PostalCode->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_PostalCode" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_PostalCode" value="<?php echo HtmlEncode($lawyeraddress->PostalCode->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Country->Visible) { // Country ?>
		<td data-name="Country">
<?php if (!$lawyeraddress->isConfirm()) { ?>
<span id="el$rowindex$_lawyeraddress_Country" class="form-group lawyeraddress_Country">
<input type="text" data-table="lawyeraddress" data-field="x_Country" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($lawyeraddress->Country->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Country->EditValue ?>"<?php echo $lawyeraddress->Country->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyeraddress_Country" class="form-group lawyeraddress_Country">
<span<?php echo $lawyeraddress->Country->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyeraddress->Country->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_Country" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Country" value="<?php echo HtmlEncode($lawyeraddress->Country->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Country" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Country" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Country" value="<?php echo HtmlEncode($lawyeraddress->Country->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Notes->Visible) { // Notes ?>
		<td data-name="Notes">
<?php if (!$lawyeraddress->isConfirm()) { ?>
<span id="el$rowindex$_lawyeraddress_Notes" class="form-group lawyeraddress_Notes">
<input type="text" data-table="lawyeraddress" data-field="x_Notes" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lawyeraddress->Notes->getPlaceHolder()) ?>" value="<?php echo $lawyeraddress->Notes->EditValue ?>"<?php echo $lawyeraddress->Notes->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyeraddress_Notes" class="form-group lawyeraddress_Notes">
<span<?php echo $lawyeraddress->Notes->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyeraddress->Notes->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_Notes" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyeraddress->Notes->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Notes" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyeraddress->Notes->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Primary->Visible) { // Primary ?>
		<td data-name="Primary">
<?php if (!$lawyeraddress->isConfirm()) { ?>
<span id="el$rowindex$_lawyeraddress_Primary" class="form-group lawyeraddress_Primary">
<?php
$selwrk = (ConvertToBool($lawyeraddress->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="lawyeraddress" data-field="x_Primary" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $lawyeraddress->Primary->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyeraddress_Primary" class="form-group lawyeraddress_Primary">
<span<?php echo $lawyeraddress->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($lawyeraddress->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $lawyeraddress->Primary->ViewValue ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $lawyeraddress->Primary->ViewValue ?>" disabled>
<?php } ?>
</span>
</span>
<input type="hidden" data-table="lawyeraddress" data-field="x_Primary" name="x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary" id="x<?php echo $lawyeraddress_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($lawyeraddress->Primary->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyeraddress" data-field="x_Primary" name="o<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" id="o<?php echo $lawyeraddress_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($lawyeraddress->Primary->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$lawyeraddress_grid->ListOptions->render("body", "right", $lawyeraddress_grid->RowIndex);
?>
<script>
flawyeraddressgrid.updateLists(<?php echo $lawyeraddress_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($lawyeraddress->CurrentMode == "add" || $lawyeraddress->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $lawyeraddress_grid->FormKeyCountName ?>" id="<?php echo $lawyeraddress_grid->FormKeyCountName ?>" value="<?php echo $lawyeraddress_grid->KeyCount ?>">
<?php echo $lawyeraddress_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($lawyeraddress->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $lawyeraddress_grid->FormKeyCountName ?>" id="<?php echo $lawyeraddress_grid->FormKeyCountName ?>" value="<?php echo $lawyeraddress_grid->KeyCount ?>">
<?php echo $lawyeraddress_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($lawyeraddress->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="flawyeraddressgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($lawyeraddress_grid->Recordset)
	$lawyeraddress_grid->Recordset->Close();
?>
</div>
<?php if ($lawyeraddress_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $lawyeraddress_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($lawyeraddress_grid->TotalRecs == 0 && !$lawyeraddress->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $lawyeraddress_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$lawyeraddress_grid->terminate();
?>
<?php if (!$lawyeraddress->isExport()) { ?>
<script>
ew.scrollableTable("gmp_lawyeraddress", "", "");
</script>
<?php } ?>
