<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$lawfirm_view = new lawfirm_view();

// Run the page
$lawfirm_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawfirm_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$lawfirm->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var flawfirmview = currentForm = new ew.Form("flawfirmview", "view");

// Form_CustomValidate event
flawfirmview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawfirmview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawfirmview.lists["x_Activated[]"] = <?php echo $lawfirm_view->Activated->Lookup->toClientList() ?>;
flawfirmview.lists["x_Activated[]"].options = <?php echo JsonEncode($lawfirm_view->Activated->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$lawfirm->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $lawfirm_view->ExportOptions->render("body") ?>
<?php $lawfirm_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $lawfirm_view->showPageHeader(); ?>
<?php
$lawfirm_view->showMessage();
?>
<?php if (!$lawfirm_view->IsModal) { ?>
<?php if (!$lawfirm->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($lawfirm_view->Pager)) $lawfirm_view->Pager = new PrevNextPager($lawfirm_view->StartRec, $lawfirm_view->DisplayRecs, $lawfirm_view->TotalRecs, $lawfirm_view->AutoHidePager) ?>
<?php if ($lawfirm_view->Pager->RecordCount > 0 && $lawfirm_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawfirm_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawfirm_view->pageUrl() ?>start=<?php echo $lawfirm_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawfirm_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawfirm_view->pageUrl() ?>start=<?php echo $lawfirm_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawfirm_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawfirm_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawfirm_view->pageUrl() ?>start=<?php echo $lawfirm_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawfirm_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawfirm_view->pageUrl() ?>start=<?php echo $lawfirm_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawfirm_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="flawfirmview" id="flawfirmview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($lawfirm_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $lawfirm_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="lawfirm">
<input type="hidden" name="modal" value="<?php echo (int)$lawfirm_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($lawfirm->LawFirmID->Visible) { // LawFirmID ?>
	<tr id="r_LawFirmID">
		<td class="<?php echo $lawfirm_view->TableLeftColumnClass ?>"><span id="elh_lawfirm_LawFirmID"><?php echo $lawfirm->LawFirmID->caption() ?></span></td>
		<td data-name="LawFirmID"<?php echo $lawfirm->LawFirmID->cellAttributes() ?>>
<span id="el_lawfirm_LawFirmID">
<span<?php echo $lawfirm->LawFirmID->viewAttributes() ?>>
<?php echo $lawfirm->LawFirmID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawfirm->LawFirm->Visible) { // LawFirm ?>
	<tr id="r_LawFirm">
		<td class="<?php echo $lawfirm_view->TableLeftColumnClass ?>"><span id="elh_lawfirm_LawFirm"><?php echo $lawfirm->LawFirm->caption() ?></span></td>
		<td data-name="LawFirm"<?php echo $lawfirm->LawFirm->cellAttributes() ?>>
<span id="el_lawfirm_LawFirm">
<span<?php echo $lawfirm->LawFirm->viewAttributes() ?>>
<?php echo $lawfirm->LawFirm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawfirm->LawFirmEn->Visible) { // LawFirmEn ?>
	<tr id="r_LawFirmEn">
		<td class="<?php echo $lawfirm_view->TableLeftColumnClass ?>"><span id="elh_lawfirm_LawFirmEn"><?php echo $lawfirm->LawFirmEn->caption() ?></span></td>
		<td data-name="LawFirmEn"<?php echo $lawfirm->LawFirmEn->cellAttributes() ?>>
<span id="el_lawfirm_LawFirmEn">
<span<?php echo $lawfirm->LawFirmEn->viewAttributes() ?>>
<?php echo $lawfirm->LawFirmEn->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawfirm->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $lawfirm_view->TableLeftColumnClass ?>"><span id="elh_lawfirm_Notes"><?php echo $lawfirm->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $lawfirm->Notes->cellAttributes() ?>>
<span id="el_lawfirm_Notes">
<span<?php echo $lawfirm->Notes->viewAttributes() ?>>
<?php echo $lawfirm->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawfirm->Activated->Visible) { // Activated ?>
	<tr id="r_Activated">
		<td class="<?php echo $lawfirm_view->TableLeftColumnClass ?>"><span id="elh_lawfirm_Activated"><?php echo $lawfirm->Activated->caption() ?></span></td>
		<td data-name="Activated"<?php echo $lawfirm->Activated->cellAttributes() ?>>
<span id="el_lawfirm_Activated">
<span<?php echo $lawfirm->Activated->viewAttributes() ?>>
<?php if (ConvertToBool($lawfirm->Activated->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $lawfirm->Activated->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $lawfirm->Activated->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$lawfirm_view->IsModal) { ?>
<?php if (!$lawfirm->isExport()) { ?>
<?php if (!isset($lawfirm_view->Pager)) $lawfirm_view->Pager = new PrevNextPager($lawfirm_view->StartRec, $lawfirm_view->DisplayRecs, $lawfirm_view->TotalRecs, $lawfirm_view->AutoHidePager) ?>
<?php if ($lawfirm_view->Pager->RecordCount > 0 && $lawfirm_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawfirm_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawfirm_view->pageUrl() ?>start=<?php echo $lawfirm_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawfirm_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawfirm_view->pageUrl() ?>start=<?php echo $lawfirm_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawfirm_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawfirm_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawfirm_view->pageUrl() ?>start=<?php echo $lawfirm_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawfirm_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawfirm_view->pageUrl() ?>start=<?php echo $lawfirm_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawfirm_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$lawfirm_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$lawfirm->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$lawfirm_view->terminate();
?>
