<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$judgecontact_preview = new judgecontact_preview();

// Run the page
$judgecontact_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$judgecontact_preview->Page_Render();
?>
<?php $judgecontact_preview->showPageHeader(); ?>
<div class="card ew-grid judgecontact"><!-- .card -->
<?php if ($judgecontact_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$judgecontact_preview->renderListOptions();

// Render list options (header, left)
$judgecontact_preview->ListOptions->render("header", "left");
?>
<?php if ($judgecontact->JudgeID->Visible) { // JudgeID ?>
	<?php if ($judgecontact->SortUrl($judgecontact->JudgeID) == "") { ?>
		<th class="<?php echo $judgecontact->JudgeID->headerCellClass() ?>"><?php echo $judgecontact->JudgeID->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $judgecontact->JudgeID->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $judgecontact->JudgeID->Name ?>" data-sort-order="<?php echo $judgecontact_preview->SortField == $judgecontact->JudgeID->Name && $judgecontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $judgecontact->JudgeID->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($judgecontact_preview->SortField == $judgecontact->JudgeID->Name) { ?><?php if ($judgecontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($judgecontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judgecontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($judgecontact->SortUrl($judgecontact->ContactTypeID) == "") { ?>
		<th class="<?php echo $judgecontact->ContactTypeID->headerCellClass() ?>"><?php echo $judgecontact->ContactTypeID->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $judgecontact->ContactTypeID->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $judgecontact->ContactTypeID->Name ?>" data-sort-order="<?php echo $judgecontact_preview->SortField == $judgecontact->ContactTypeID->Name && $judgecontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $judgecontact->ContactTypeID->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($judgecontact_preview->SortField == $judgecontact->ContactTypeID->Name) { ?><?php if ($judgecontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($judgecontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judgecontact->Contact->Visible) { // Contact ?>
	<?php if ($judgecontact->SortUrl($judgecontact->Contact) == "") { ?>
		<th class="<?php echo $judgecontact->Contact->headerCellClass() ?>"><?php echo $judgecontact->Contact->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $judgecontact->Contact->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $judgecontact->Contact->Name ?>" data-sort-order="<?php echo $judgecontact_preview->SortField == $judgecontact->Contact->Name && $judgecontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $judgecontact->Contact->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($judgecontact_preview->SortField == $judgecontact->Contact->Name) { ?><?php if ($judgecontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($judgecontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judgecontact->Notes->Visible) { // Notes ?>
	<?php if ($judgecontact->SortUrl($judgecontact->Notes) == "") { ?>
		<th class="<?php echo $judgecontact->Notes->headerCellClass() ?>"><?php echo $judgecontact->Notes->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $judgecontact->Notes->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $judgecontact->Notes->Name ?>" data-sort-order="<?php echo $judgecontact_preview->SortField == $judgecontact->Notes->Name && $judgecontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $judgecontact->Notes->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($judgecontact_preview->SortField == $judgecontact->Notes->Name) { ?><?php if ($judgecontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($judgecontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judgecontact->Primary->Visible) { // Primary ?>
	<?php if ($judgecontact->SortUrl($judgecontact->Primary) == "") { ?>
		<th class="<?php echo $judgecontact->Primary->headerCellClass() ?>"><?php echo $judgecontact->Primary->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $judgecontact->Primary->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $judgecontact->Primary->Name ?>" data-sort-order="<?php echo $judgecontact_preview->SortField == $judgecontact->Primary->Name && $judgecontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $judgecontact->Primary->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($judgecontact_preview->SortField == $judgecontact->Primary->Name) { ?><?php if ($judgecontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($judgecontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$judgecontact_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$judgecontact_preview->RecCount = 0;
$judgecontact_preview->RowCnt = 0;
while ($judgecontact_preview->Recordset && !$judgecontact_preview->Recordset->EOF) {

	// Init row class and style
	$judgecontact_preview->RecCount++;
	$judgecontact_preview->RowCnt++;
	$judgecontact_preview->CssStyle = "";
	$judgecontact_preview->loadListRowValues($judgecontact_preview->Recordset);

	// Render row
	$judgecontact_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$judgecontact_preview->resetAttributes();
	$judgecontact_preview->renderListRow();

	// Render list options
	$judgecontact_preview->renderListOptions();
?>
	<tr<?php echo $judgecontact_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$judgecontact_preview->ListOptions->render("body", "left", $judgecontact_preview->RowCnt);
?>
<?php if ($judgecontact->JudgeID->Visible) { // JudgeID ?>
		<!-- JudgeID -->
		<td<?php echo $judgecontact->JudgeID->cellAttributes() ?>>
<span<?php echo $judgecontact->JudgeID->viewAttributes() ?>>
<?php echo $judgecontact->JudgeID->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($judgecontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<!-- ContactTypeID -->
		<td<?php echo $judgecontact->ContactTypeID->cellAttributes() ?>>
<span<?php echo $judgecontact->ContactTypeID->viewAttributes() ?>>
<?php echo $judgecontact->ContactTypeID->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($judgecontact->Contact->Visible) { // Contact ?>
		<!-- Contact -->
		<td<?php echo $judgecontact->Contact->cellAttributes() ?>>
<span<?php echo $judgecontact->Contact->viewAttributes() ?>>
<?php echo $judgecontact->Contact->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($judgecontact->Notes->Visible) { // Notes ?>
		<!-- Notes -->
		<td<?php echo $judgecontact->Notes->cellAttributes() ?>>
<span<?php echo $judgecontact->Notes->viewAttributes() ?>>
<?php echo $judgecontact->Notes->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($judgecontact->Primary->Visible) { // Primary ?>
		<!-- Primary -->
		<td<?php echo $judgecontact->Primary->cellAttributes() ?>>
<span<?php echo $judgecontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($judgecontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $judgecontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $judgecontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$judgecontact_preview->ListOptions->render("body", "right", $judgecontact_preview->RowCnt);
?>
	</tr>
<?php
	$judgecontact_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($judgecontact_preview->TotalRecs > 0) { ?>
<?php if (!isset($judgecontact_preview->Pager)) $judgecontact_preview->Pager = new PrevNextPager($judgecontact_preview->StartRec, $judgecontact_preview->DisplayRecs, $judgecontact_preview->TotalRecs) ?>
<?php if ($judgecontact_preview->Pager->RecordCount > 0 && $judgecontact_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($judgecontact_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $judgecontact_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($judgecontact_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $judgecontact_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($judgecontact_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $judgecontact_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($judgecontact_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $judgecontact_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $judgecontact_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $judgecontact_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $judgecontact_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($judgecontact_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$judgecontact_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($judgecontact_preview->Recordset)
	$judgecontact_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$judgecontact_preview->terminate();
?>
