<?php
namespace PHPMaker2019\project_germanos;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($hearings_grid))
	$hearings_grid = new hearings_grid();

// Run the page
$hearings_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$hearings_grid->Page_Render();
?>
<?php if (!$hearings->isExport()) { ?>
<script>

// Form object
var fhearingsgrid = new ew.Form("fhearingsgrid", "grid");
fhearingsgrid.formKeyCountName = '<?php echo $hearings_grid->FormKeyCountName ?>';

// Validate form
fhearingsgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($hearings_grid->CaseID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->CaseID->caption(), $hearings->CaseID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($hearings_grid->HearingDate->Required) { ?>
			elm = this.getElements("x" + infix + "_HearingDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->HearingDate->caption(), $hearings->HearingDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_HearingDate");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($hearings->HearingDate->errorMessage()) ?>");
		<?php if ($hearings_grid->HearingTime->Required) { ?>
			elm = this.getElements("x" + infix + "_HearingTime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->HearingTime->caption(), $hearings->HearingTime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_HearingTime");
			if (elm && !ew.checkTime(elm.value))
				return this.onError(elm, "<?php echo JsEncode($hearings->HearingTime->errorMessage()) ?>");
		<?php if ($hearings_grid->NextHearingDate->Required) { ?>
			elm = this.getElements("x" + infix + "_NextHearingDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->NextHearingDate->caption(), $hearings->NextHearingDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_NextHearingDate");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($hearings->NextHearingDate->errorMessage()) ?>");
		<?php if ($hearings_grid->NextHearingTime->Required) { ?>
			elm = this.getElements("x" + infix + "_NextHearingTime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->NextHearingTime->caption(), $hearings->NextHearingTime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_NextHearingTime");
			if (elm && !ew.checkTime(elm.value))
				return this.onError(elm, "<?php echo JsEncode($hearings->NextHearingTime->errorMessage()) ?>");
		<?php if ($hearings_grid->Hearing->Required) { ?>
			elm = this.getElements("x" + infix + "_Hearing");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->Hearing->caption(), $hearings->Hearing->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($hearings_grid->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->Notes->caption(), $hearings->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($hearings_grid->LawyerID->Required) { ?>
			elm = this.getElements("x" + infix + "_LawyerID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->LawyerID->caption(), $hearings->LawyerID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($hearings_grid->JudgeID->Required) { ?>
			elm = this.getElements("x" + infix + "_JudgeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->JudgeID->caption(), $hearings->JudgeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($hearings_grid->CaseNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->CaseNumber->caption(), $hearings->CaseNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($hearings_grid->CourtID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->CourtID->caption(), $hearings->CourtID->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fhearingsgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "CaseID", false)) return false;
	if (ew.valueChanged(fobj, infix, "HearingDate", false)) return false;
	if (ew.valueChanged(fobj, infix, "HearingTime", false)) return false;
	if (ew.valueChanged(fobj, infix, "NextHearingDate", false)) return false;
	if (ew.valueChanged(fobj, infix, "NextHearingTime", false)) return false;
	if (ew.valueChanged(fobj, infix, "Hearing", false)) return false;
	if (ew.valueChanged(fobj, infix, "Notes", false)) return false;
	if (ew.valueChanged(fobj, infix, "LawyerID", false)) return false;
	if (ew.valueChanged(fobj, infix, "JudgeID", false)) return false;
	if (ew.valueChanged(fobj, infix, "CaseNumber", false)) return false;
	if (ew.valueChanged(fobj, infix, "CourtID", false)) return false;
	return true;
}

// Form_CustomValidate event
fhearingsgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fhearingsgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fhearingsgrid.lists["x_CaseID"] = <?php echo $hearings_grid->CaseID->Lookup->toClientList() ?>;
fhearingsgrid.lists["x_CaseID"].options = <?php echo JsonEncode($hearings_grid->CaseID->lookupOptions()) ?>;
fhearingsgrid.autoSuggests["x_CaseID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fhearingsgrid.lists["x_LawyerID"] = <?php echo $hearings_grid->LawyerID->Lookup->toClientList() ?>;
fhearingsgrid.lists["x_LawyerID"].options = <?php echo JsonEncode($hearings_grid->LawyerID->lookupOptions()) ?>;
fhearingsgrid.lists["x_JudgeID"] = <?php echo $hearings_grid->JudgeID->Lookup->toClientList() ?>;
fhearingsgrid.lists["x_JudgeID"].options = <?php echo JsonEncode($hearings_grid->JudgeID->lookupOptions()) ?>;
fhearingsgrid.lists["x_CourtID"] = <?php echo $hearings_grid->CourtID->Lookup->toClientList() ?>;
fhearingsgrid.lists["x_CourtID"].options = <?php echo JsonEncode($hearings_grid->CourtID->lookupOptions()) ?>;
fhearingsgrid.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$hearings_grid->renderOtherOptions();
?>
<?php $hearings_grid->showPageHeader(); ?>
<?php
$hearings_grid->showMessage();
?>
<?php if ($hearings_grid->TotalRecs > 0 || $hearings->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($hearings_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> hearings">
<?php if ($hearings_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $hearings_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fhearingsgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_hearings" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_hearingsgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$hearings_grid->RowType = ROWTYPE_HEADER;

// Render list options
$hearings_grid->renderListOptions();

// Render list options (header, left)
$hearings_grid->ListOptions->render("header", "left");
?>
<?php if ($hearings->CaseID->Visible) { // CaseID ?>
	<?php if ($hearings->sortUrl($hearings->CaseID) == "") { ?>
		<th data-name="CaseID" class="<?php echo $hearings->CaseID->headerCellClass() ?>" style="min-width: 200px;"><div id="elh_hearings_CaseID" class="hearings_CaseID"><div class="ew-table-header-caption"><?php echo $hearings->CaseID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseID" class="<?php echo $hearings->CaseID->headerCellClass() ?>" style="min-width: 200px;"><div><div id="elh_hearings_CaseID" class="hearings_CaseID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->CaseID->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->CaseID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->CaseID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->HearingDate->Visible) { // HearingDate ?>
	<?php if ($hearings->sortUrl($hearings->HearingDate) == "") { ?>
		<th data-name="HearingDate" class="<?php echo $hearings->HearingDate->headerCellClass() ?>"><div id="elh_hearings_HearingDate" class="hearings_HearingDate"><div class="ew-table-header-caption"><?php echo $hearings->HearingDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="HearingDate" class="<?php echo $hearings->HearingDate->headerCellClass() ?>"><div><div id="elh_hearings_HearingDate" class="hearings_HearingDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->HearingDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->HearingDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->HearingDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->HearingTime->Visible) { // HearingTime ?>
	<?php if ($hearings->sortUrl($hearings->HearingTime) == "") { ?>
		<th data-name="HearingTime" class="<?php echo $hearings->HearingTime->headerCellClass() ?>"><div id="elh_hearings_HearingTime" class="hearings_HearingTime"><div class="ew-table-header-caption"><?php echo $hearings->HearingTime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="HearingTime" class="<?php echo $hearings->HearingTime->headerCellClass() ?>"><div><div id="elh_hearings_HearingTime" class="hearings_HearingTime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->HearingTime->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->HearingTime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->HearingTime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->NextHearingDate->Visible) { // NextHearingDate ?>
	<?php if ($hearings->sortUrl($hearings->NextHearingDate) == "") { ?>
		<th data-name="NextHearingDate" class="<?php echo $hearings->NextHearingDate->headerCellClass() ?>"><div id="elh_hearings_NextHearingDate" class="hearings_NextHearingDate"><div class="ew-table-header-caption"><?php echo $hearings->NextHearingDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NextHearingDate" class="<?php echo $hearings->NextHearingDate->headerCellClass() ?>"><div><div id="elh_hearings_NextHearingDate" class="hearings_NextHearingDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->NextHearingDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->NextHearingDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->NextHearingDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->NextHearingTime->Visible) { // NextHearingTime ?>
	<?php if ($hearings->sortUrl($hearings->NextHearingTime) == "") { ?>
		<th data-name="NextHearingTime" class="<?php echo $hearings->NextHearingTime->headerCellClass() ?>"><div id="elh_hearings_NextHearingTime" class="hearings_NextHearingTime"><div class="ew-table-header-caption"><?php echo $hearings->NextHearingTime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NextHearingTime" class="<?php echo $hearings->NextHearingTime->headerCellClass() ?>"><div><div id="elh_hearings_NextHearingTime" class="hearings_NextHearingTime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->NextHearingTime->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->NextHearingTime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->NextHearingTime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->Hearing->Visible) { // Hearing ?>
	<?php if ($hearings->sortUrl($hearings->Hearing) == "") { ?>
		<th data-name="Hearing" class="<?php echo $hearings->Hearing->headerCellClass() ?>" style="min-width: 100px;"><div id="elh_hearings_Hearing" class="hearings_Hearing"><div class="ew-table-header-caption"><?php echo $hearings->Hearing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Hearing" class="<?php echo $hearings->Hearing->headerCellClass() ?>" style="min-width: 100px;"><div><div id="elh_hearings_Hearing" class="hearings_Hearing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->Hearing->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->Hearing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->Hearing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->Notes->Visible) { // Notes ?>
	<?php if ($hearings->sortUrl($hearings->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $hearings->Notes->headerCellClass() ?>" style="min-width: 200px;"><div id="elh_hearings_Notes" class="hearings_Notes"><div class="ew-table-header-caption"><?php echo $hearings->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $hearings->Notes->headerCellClass() ?>" style="min-width: 200px;"><div><div id="elh_hearings_Notes" class="hearings_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->Notes->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->LawyerID->Visible) { // LawyerID ?>
	<?php if ($hearings->sortUrl($hearings->LawyerID) == "") { ?>
		<th data-name="LawyerID" class="<?php echo $hearings->LawyerID->headerCellClass() ?>"><div id="elh_hearings_LawyerID" class="hearings_LawyerID"><div class="ew-table-header-caption"><?php echo $hearings->LawyerID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LawyerID" class="<?php echo $hearings->LawyerID->headerCellClass() ?>"><div><div id="elh_hearings_LawyerID" class="hearings_LawyerID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->LawyerID->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->LawyerID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->LawyerID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->JudgeID->Visible) { // JudgeID ?>
	<?php if ($hearings->sortUrl($hearings->JudgeID) == "") { ?>
		<th data-name="JudgeID" class="<?php echo $hearings->JudgeID->headerCellClass() ?>"><div id="elh_hearings_JudgeID" class="hearings_JudgeID"><div class="ew-table-header-caption"><?php echo $hearings->JudgeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JudgeID" class="<?php echo $hearings->JudgeID->headerCellClass() ?>"><div><div id="elh_hearings_JudgeID" class="hearings_JudgeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->JudgeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->JudgeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->JudgeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($hearings->sortUrl($hearings->CaseNumber) == "") { ?>
		<th data-name="CaseNumber" class="<?php echo $hearings->CaseNumber->headerCellClass() ?>"><div id="elh_hearings_CaseNumber" class="hearings_CaseNumber"><div class="ew-table-header-caption"><?php echo $hearings->CaseNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseNumber" class="<?php echo $hearings->CaseNumber->headerCellClass() ?>"><div><div id="elh_hearings_CaseNumber" class="hearings_CaseNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->CaseNumber->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->CaseNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->CaseNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->CourtID->Visible) { // CourtID ?>
	<?php if ($hearings->sortUrl($hearings->CourtID) == "") { ?>
		<th data-name="CourtID" class="<?php echo $hearings->CourtID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_hearings_CourtID" class="hearings_CourtID"><div class="ew-table-header-caption"><?php echo $hearings->CourtID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtID" class="<?php echo $hearings->CourtID->headerCellClass() ?>" style="white-space: nowrap;"><div><div id="elh_hearings_CourtID" class="hearings_CourtID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->CourtID->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->CourtID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->CourtID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$hearings_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$hearings_grid->StartRec = 1;
$hearings_grid->StopRec = $hearings_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $hearings_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($hearings_grid->FormKeyCountName) && ($hearings->isGridAdd() || $hearings->isGridEdit() || $hearings->isConfirm())) {
		$hearings_grid->KeyCount = $CurrentForm->getValue($hearings_grid->FormKeyCountName);
		$hearings_grid->StopRec = $hearings_grid->StartRec + $hearings_grid->KeyCount - 1;
	}
}
$hearings_grid->RecCnt = $hearings_grid->StartRec - 1;
if ($hearings_grid->Recordset && !$hearings_grid->Recordset->EOF) {
	$hearings_grid->Recordset->moveFirst();
	$selectLimit = $hearings_grid->UseSelectLimit;
	if (!$selectLimit && $hearings_grid->StartRec > 1)
		$hearings_grid->Recordset->move($hearings_grid->StartRec - 1);
} elseif (!$hearings->AllowAddDeleteRow && $hearings_grid->StopRec == 0) {
	$hearings_grid->StopRec = $hearings->GridAddRowCount;
}

// Initialize aggregate
$hearings->RowType = ROWTYPE_AGGREGATEINIT;
$hearings->resetAttributes();
$hearings_grid->renderRow();
if ($hearings->isGridAdd())
	$hearings_grid->RowIndex = 0;
if ($hearings->isGridEdit())
	$hearings_grid->RowIndex = 0;
while ($hearings_grid->RecCnt < $hearings_grid->StopRec) {
	$hearings_grid->RecCnt++;
	if ($hearings_grid->RecCnt >= $hearings_grid->StartRec) {
		$hearings_grid->RowCnt++;
		if ($hearings->isGridAdd() || $hearings->isGridEdit() || $hearings->isConfirm()) {
			$hearings_grid->RowIndex++;
			$CurrentForm->Index = $hearings_grid->RowIndex;
			if ($CurrentForm->hasValue($hearings_grid->FormActionName) && $hearings_grid->EventCancelled)
				$hearings_grid->RowAction = strval($CurrentForm->getValue($hearings_grid->FormActionName));
			elseif ($hearings->isGridAdd())
				$hearings_grid->RowAction = "insert";
			else
				$hearings_grid->RowAction = "";
		}

		// Set up key count
		$hearings_grid->KeyCount = $hearings_grid->RowIndex;

		// Init row class and style
		$hearings->resetAttributes();
		$hearings->CssClass = "";
		if ($hearings->isGridAdd()) {
			if ($hearings->CurrentMode == "copy") {
				$hearings_grid->loadRowValues($hearings_grid->Recordset); // Load row values
				$hearings_grid->setRecordKey($hearings_grid->RowOldKey, $hearings_grid->Recordset); // Set old record key
			} else {
				$hearings_grid->loadRowValues(); // Load default values
				$hearings_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$hearings_grid->loadRowValues($hearings_grid->Recordset); // Load row values
		}
		$hearings->RowType = ROWTYPE_VIEW; // Render view
		if ($hearings->isGridAdd()) // Grid add
			$hearings->RowType = ROWTYPE_ADD; // Render add
		if ($hearings->isGridAdd() && $hearings->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$hearings_grid->restoreCurrentRowFormValues($hearings_grid->RowIndex); // Restore form values
		if ($hearings->isGridEdit()) { // Grid edit
			if ($hearings->EventCancelled)
				$hearings_grid->restoreCurrentRowFormValues($hearings_grid->RowIndex); // Restore form values
			if ($hearings_grid->RowAction == "insert")
				$hearings->RowType = ROWTYPE_ADD; // Render add
			else
				$hearings->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($hearings->isGridEdit() && ($hearings->RowType == ROWTYPE_EDIT || $hearings->RowType == ROWTYPE_ADD) && $hearings->EventCancelled) // Update failed
			$hearings_grid->restoreCurrentRowFormValues($hearings_grid->RowIndex); // Restore form values
		if ($hearings->RowType == ROWTYPE_EDIT) // Edit row
			$hearings_grid->EditRowCnt++;
		if ($hearings->isConfirm()) // Confirm row
			$hearings_grid->restoreCurrentRowFormValues($hearings_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$hearings->RowAttrs = array_merge($hearings->RowAttrs, array('data-rowindex'=>$hearings_grid->RowCnt, 'id'=>'r' . $hearings_grid->RowCnt . '_hearings', 'data-rowtype'=>$hearings->RowType));

		// Render row
		$hearings_grid->renderRow();

		// Render list options
		$hearings_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($hearings_grid->RowAction <> "delete" && $hearings_grid->RowAction <> "insertdelete" && !($hearings_grid->RowAction == "insert" && $hearings->isConfirm() && $hearings_grid->emptyRow())) {
?>
	<tr<?php echo $hearings->rowAttributes() ?>>
<?php

// Render list options (body, left)
$hearings_grid->ListOptions->render("body", "left", $hearings_grid->RowCnt);
?>
	<?php if ($hearings->CaseID->Visible) { // CaseID ?>
		<td data-name="CaseID"<?php echo $hearings->CaseID->cellAttributes() ?>>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($hearings->CaseID->getSessionValue() <> "") { ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_CaseID" class="form-group hearings_CaseID">
<span<?php echo $hearings->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $hearings_grid->RowIndex ?>_CaseID" name="x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_CaseID" class="form-group hearings_CaseID">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$hearings->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$hearings->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $hearings_grid->RowIndex ?>_CaseID" class="text-nowrap" style="z-index: <?php echo (9000 - $hearings_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $hearings_grid->RowIndex ?>_CaseID" id="sv_x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo RemoveHtml($hearings->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($hearings->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($hearings->CaseID->getPlaceHolder()) ?>"<?php echo $hearings->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($hearings->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CaseID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($hearings->CaseID->ReadOnly || $hearings->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "cases") && !$hearings->CaseID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_CaseID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->CaseID->caption() ?>" data-title="<?php echo $hearings->CaseID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CaseID',url:'casesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="hearings" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $hearings->CaseID->displayValueSeparatorAttribute() ?>" name="x<?php echo $hearings_grid->RowIndex ?>_CaseID" id="x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fhearingsgrid.createAutoSuggest({"id":"x<?php echo $hearings_grid->RowIndex ?>_CaseID","forceSelect":true});
</script>
<?php echo $hearings->CaseID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_CaseID") ?>
</span>
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_CaseID" name="o<?php echo $hearings_grid->RowIndex ?>_CaseID" id="o<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($hearings->CaseID->getSessionValue() <> "") { ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_CaseID" class="form-group hearings_CaseID">
<span<?php echo $hearings->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $hearings_grid->RowIndex ?>_CaseID" name="x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_CaseID" class="form-group hearings_CaseID">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$hearings->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$hearings->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $hearings_grid->RowIndex ?>_CaseID" class="text-nowrap" style="z-index: <?php echo (9000 - $hearings_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $hearings_grid->RowIndex ?>_CaseID" id="sv_x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo RemoveHtml($hearings->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($hearings->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($hearings->CaseID->getPlaceHolder()) ?>"<?php echo $hearings->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($hearings->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CaseID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($hearings->CaseID->ReadOnly || $hearings->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "cases") && !$hearings->CaseID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_CaseID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->CaseID->caption() ?>" data-title="<?php echo $hearings->CaseID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CaseID',url:'casesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="hearings" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $hearings->CaseID->displayValueSeparatorAttribute() ?>" name="x<?php echo $hearings_grid->RowIndex ?>_CaseID" id="x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fhearingsgrid.createAutoSuggest({"id":"x<?php echo $hearings_grid->RowIndex ?>_CaseID","forceSelect":true});
</script>
<?php echo $hearings->CaseID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_CaseID") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_CaseID" class="hearings_CaseID">
<span<?php echo $hearings->CaseID->viewAttributes() ?>>
<?php echo $hearings->CaseID->getViewValue() ?></span>
</span>
<?php if (!$hearings->isConfirm()) { ?>
<input type="hidden" data-table="hearings" data-field="x_CaseID" name="x<?php echo $hearings_grid->RowIndex ?>_CaseID" id="x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_CaseID" name="o<?php echo $hearings_grid->RowIndex ?>_CaseID" id="o<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_CaseID" name="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_CaseID" id="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_CaseID" name="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_CaseID" id="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="hearings" data-field="x_HearingID" name="x<?php echo $hearings_grid->RowIndex ?>_HearingID" id="x<?php echo $hearings_grid->RowIndex ?>_HearingID" value="<?php echo HtmlEncode($hearings->HearingID->CurrentValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_HearingID" name="o<?php echo $hearings_grid->RowIndex ?>_HearingID" id="o<?php echo $hearings_grid->RowIndex ?>_HearingID" value="<?php echo HtmlEncode($hearings->HearingID->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT || $hearings->CurrentMode == "edit") { ?>
<input type="hidden" data-table="hearings" data-field="x_HearingID" name="x<?php echo $hearings_grid->RowIndex ?>_HearingID" id="x<?php echo $hearings_grid->RowIndex ?>_HearingID" value="<?php echo HtmlEncode($hearings->HearingID->CurrentValue) ?>">
<?php } ?>
	<?php if ($hearings->HearingDate->Visible) { // HearingDate ?>
		<td data-name="HearingDate"<?php echo $hearings->HearingDate->cellAttributes() ?>>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_HearingDate" class="form-group hearings_HearingDate">
<input type="text" data-table="hearings" data-field="x_HearingDate" data-format="7" name="x<?php echo $hearings_grid->RowIndex ?>_HearingDate" id="x<?php echo $hearings_grid->RowIndex ?>_HearingDate" placeholder="<?php echo HtmlEncode($hearings->HearingDate->getPlaceHolder()) ?>" value="<?php echo $hearings->HearingDate->EditValue ?>"<?php echo $hearings->HearingDate->editAttributes() ?>>
<?php if (!$hearings->HearingDate->ReadOnly && !$hearings->HearingDate->Disabled && !isset($hearings->HearingDate->EditAttrs["readonly"]) && !isset($hearings->HearingDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_HearingDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="hearings" data-field="x_HearingDate" name="o<?php echo $hearings_grid->RowIndex ?>_HearingDate" id="o<?php echo $hearings_grid->RowIndex ?>_HearingDate" value="<?php echo HtmlEncode($hearings->HearingDate->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_HearingDate" class="form-group hearings_HearingDate">
<input type="text" data-table="hearings" data-field="x_HearingDate" data-format="7" name="x<?php echo $hearings_grid->RowIndex ?>_HearingDate" id="x<?php echo $hearings_grid->RowIndex ?>_HearingDate" placeholder="<?php echo HtmlEncode($hearings->HearingDate->getPlaceHolder()) ?>" value="<?php echo $hearings->HearingDate->EditValue ?>"<?php echo $hearings->HearingDate->editAttributes() ?>>
<?php if (!$hearings->HearingDate->ReadOnly && !$hearings->HearingDate->Disabled && !isset($hearings->HearingDate->EditAttrs["readonly"]) && !isset($hearings->HearingDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_HearingDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_HearingDate" class="hearings_HearingDate">
<span<?php echo $hearings->HearingDate->viewAttributes() ?>>
<?php echo $hearings->HearingDate->getViewValue() ?></span>
</span>
<?php if (!$hearings->isConfirm()) { ?>
<input type="hidden" data-table="hearings" data-field="x_HearingDate" name="x<?php echo $hearings_grid->RowIndex ?>_HearingDate" id="x<?php echo $hearings_grid->RowIndex ?>_HearingDate" value="<?php echo HtmlEncode($hearings->HearingDate->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_HearingDate" name="o<?php echo $hearings_grid->RowIndex ?>_HearingDate" id="o<?php echo $hearings_grid->RowIndex ?>_HearingDate" value="<?php echo HtmlEncode($hearings->HearingDate->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_HearingDate" name="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_HearingDate" id="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_HearingDate" value="<?php echo HtmlEncode($hearings->HearingDate->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_HearingDate" name="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_HearingDate" id="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_HearingDate" value="<?php echo HtmlEncode($hearings->HearingDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($hearings->HearingTime->Visible) { // HearingTime ?>
		<td data-name="HearingTime"<?php echo $hearings->HearingTime->cellAttributes() ?>>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_HearingTime" class="form-group hearings_HearingTime">
<input type="text" data-table="hearings" data-field="x_HearingTime" name="x<?php echo $hearings_grid->RowIndex ?>_HearingTime" id="x<?php echo $hearings_grid->RowIndex ?>_HearingTime" placeholder="<?php echo HtmlEncode($hearings->HearingTime->getPlaceHolder()) ?>" value="<?php echo $hearings->HearingTime->EditValue ?>"<?php echo $hearings->HearingTime->editAttributes() ?>>
<?php if (!$hearings->HearingTime->ReadOnly && !$hearings->HearingTime->Disabled && !isset($hearings->HearingTime->EditAttrs["readonly"]) && !isset($hearings->HearingTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_HearingTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<input type="hidden" data-table="hearings" data-field="x_HearingTime" name="o<?php echo $hearings_grid->RowIndex ?>_HearingTime" id="o<?php echo $hearings_grid->RowIndex ?>_HearingTime" value="<?php echo HtmlEncode($hearings->HearingTime->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_HearingTime" class="form-group hearings_HearingTime">
<input type="text" data-table="hearings" data-field="x_HearingTime" name="x<?php echo $hearings_grid->RowIndex ?>_HearingTime" id="x<?php echo $hearings_grid->RowIndex ?>_HearingTime" placeholder="<?php echo HtmlEncode($hearings->HearingTime->getPlaceHolder()) ?>" value="<?php echo $hearings->HearingTime->EditValue ?>"<?php echo $hearings->HearingTime->editAttributes() ?>>
<?php if (!$hearings->HearingTime->ReadOnly && !$hearings->HearingTime->Disabled && !isset($hearings->HearingTime->EditAttrs["readonly"]) && !isset($hearings->HearingTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_HearingTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_HearingTime" class="hearings_HearingTime">
<span<?php echo $hearings->HearingTime->viewAttributes() ?>>
<?php echo $hearings->HearingTime->getViewValue() ?></span>
</span>
<?php if (!$hearings->isConfirm()) { ?>
<input type="hidden" data-table="hearings" data-field="x_HearingTime" name="x<?php echo $hearings_grid->RowIndex ?>_HearingTime" id="x<?php echo $hearings_grid->RowIndex ?>_HearingTime" value="<?php echo HtmlEncode($hearings->HearingTime->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_HearingTime" name="o<?php echo $hearings_grid->RowIndex ?>_HearingTime" id="o<?php echo $hearings_grid->RowIndex ?>_HearingTime" value="<?php echo HtmlEncode($hearings->HearingTime->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_HearingTime" name="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_HearingTime" id="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_HearingTime" value="<?php echo HtmlEncode($hearings->HearingTime->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_HearingTime" name="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_HearingTime" id="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_HearingTime" value="<?php echo HtmlEncode($hearings->HearingTime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($hearings->NextHearingDate->Visible) { // NextHearingDate ?>
		<td data-name="NextHearingDate"<?php echo $hearings->NextHearingDate->cellAttributes() ?>>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_NextHearingDate" class="form-group hearings_NextHearingDate">
<input type="text" data-table="hearings" data-field="x_NextHearingDate" data-format="7" name="x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" id="x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" placeholder="<?php echo HtmlEncode($hearings->NextHearingDate->getPlaceHolder()) ?>" value="<?php echo $hearings->NextHearingDate->EditValue ?>"<?php echo $hearings->NextHearingDate->editAttributes() ?>>
<?php if (!$hearings->NextHearingDate->ReadOnly && !$hearings->NextHearingDate->Disabled && !isset($hearings->NextHearingDate->EditAttrs["readonly"]) && !isset($hearings->NextHearingDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="hearings" data-field="x_NextHearingDate" name="o<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" id="o<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" value="<?php echo HtmlEncode($hearings->NextHearingDate->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_NextHearingDate" class="form-group hearings_NextHearingDate">
<input type="text" data-table="hearings" data-field="x_NextHearingDate" data-format="7" name="x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" id="x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" placeholder="<?php echo HtmlEncode($hearings->NextHearingDate->getPlaceHolder()) ?>" value="<?php echo $hearings->NextHearingDate->EditValue ?>"<?php echo $hearings->NextHearingDate->editAttributes() ?>>
<?php if (!$hearings->NextHearingDate->ReadOnly && !$hearings->NextHearingDate->Disabled && !isset($hearings->NextHearingDate->EditAttrs["readonly"]) && !isset($hearings->NextHearingDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_NextHearingDate" class="hearings_NextHearingDate">
<span<?php echo $hearings->NextHearingDate->viewAttributes() ?>>
<?php echo $hearings->NextHearingDate->getViewValue() ?></span>
</span>
<?php if (!$hearings->isConfirm()) { ?>
<input type="hidden" data-table="hearings" data-field="x_NextHearingDate" name="x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" id="x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" value="<?php echo HtmlEncode($hearings->NextHearingDate->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_NextHearingDate" name="o<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" id="o<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" value="<?php echo HtmlEncode($hearings->NextHearingDate->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_NextHearingDate" name="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" id="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" value="<?php echo HtmlEncode($hearings->NextHearingDate->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_NextHearingDate" name="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" id="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" value="<?php echo HtmlEncode($hearings->NextHearingDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($hearings->NextHearingTime->Visible) { // NextHearingTime ?>
		<td data-name="NextHearingTime"<?php echo $hearings->NextHearingTime->cellAttributes() ?>>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_NextHearingTime" class="form-group hearings_NextHearingTime">
<input type="text" data-table="hearings" data-field="x_NextHearingTime" name="x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" id="x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" placeholder="<?php echo HtmlEncode($hearings->NextHearingTime->getPlaceHolder()) ?>" value="<?php echo $hearings->NextHearingTime->EditValue ?>"<?php echo $hearings->NextHearingTime->editAttributes() ?>>
<?php if (!$hearings->NextHearingTime->ReadOnly && !$hearings->NextHearingTime->Disabled && !isset($hearings->NextHearingTime->EditAttrs["readonly"]) && !isset($hearings->NextHearingTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<input type="hidden" data-table="hearings" data-field="x_NextHearingTime" name="o<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" id="o<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" value="<?php echo HtmlEncode($hearings->NextHearingTime->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_NextHearingTime" class="form-group hearings_NextHearingTime">
<input type="text" data-table="hearings" data-field="x_NextHearingTime" name="x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" id="x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" placeholder="<?php echo HtmlEncode($hearings->NextHearingTime->getPlaceHolder()) ?>" value="<?php echo $hearings->NextHearingTime->EditValue ?>"<?php echo $hearings->NextHearingTime->editAttributes() ?>>
<?php if (!$hearings->NextHearingTime->ReadOnly && !$hearings->NextHearingTime->Disabled && !isset($hearings->NextHearingTime->EditAttrs["readonly"]) && !isset($hearings->NextHearingTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_NextHearingTime" class="hearings_NextHearingTime">
<span<?php echo $hearings->NextHearingTime->viewAttributes() ?>>
<?php echo $hearings->NextHearingTime->getViewValue() ?></span>
</span>
<?php if (!$hearings->isConfirm()) { ?>
<input type="hidden" data-table="hearings" data-field="x_NextHearingTime" name="x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" id="x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" value="<?php echo HtmlEncode($hearings->NextHearingTime->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_NextHearingTime" name="o<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" id="o<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" value="<?php echo HtmlEncode($hearings->NextHearingTime->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_NextHearingTime" name="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" id="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" value="<?php echo HtmlEncode($hearings->NextHearingTime->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_NextHearingTime" name="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" id="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" value="<?php echo HtmlEncode($hearings->NextHearingTime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($hearings->Hearing->Visible) { // Hearing ?>
		<td data-name="Hearing"<?php echo $hearings->Hearing->cellAttributes() ?>>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_Hearing" class="form-group hearings_Hearing">
<textarea data-table="hearings" data-field="x_Hearing" name="x<?php echo $hearings_grid->RowIndex ?>_Hearing" id="x<?php echo $hearings_grid->RowIndex ?>_Hearing" cols="35" rows="2" placeholder="<?php echo HtmlEncode($hearings->Hearing->getPlaceHolder()) ?>"<?php echo $hearings->Hearing->editAttributes() ?>><?php echo $hearings->Hearing->EditValue ?></textarea>
</span>
<input type="hidden" data-table="hearings" data-field="x_Hearing" name="o<?php echo $hearings_grid->RowIndex ?>_Hearing" id="o<?php echo $hearings_grid->RowIndex ?>_Hearing" value="<?php echo HtmlEncode($hearings->Hearing->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_Hearing" class="form-group hearings_Hearing">
<textarea data-table="hearings" data-field="x_Hearing" name="x<?php echo $hearings_grid->RowIndex ?>_Hearing" id="x<?php echo $hearings_grid->RowIndex ?>_Hearing" cols="35" rows="2" placeholder="<?php echo HtmlEncode($hearings->Hearing->getPlaceHolder()) ?>"<?php echo $hearings->Hearing->editAttributes() ?>><?php echo $hearings->Hearing->EditValue ?></textarea>
</span>
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_Hearing" class="hearings_Hearing">
<span<?php echo $hearings->Hearing->viewAttributes() ?>>
<?php echo $hearings->Hearing->getViewValue() ?></span>
</span>
<?php if (!$hearings->isConfirm()) { ?>
<input type="hidden" data-table="hearings" data-field="x_Hearing" name="x<?php echo $hearings_grid->RowIndex ?>_Hearing" id="x<?php echo $hearings_grid->RowIndex ?>_Hearing" value="<?php echo HtmlEncode($hearings->Hearing->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_Hearing" name="o<?php echo $hearings_grid->RowIndex ?>_Hearing" id="o<?php echo $hearings_grid->RowIndex ?>_Hearing" value="<?php echo HtmlEncode($hearings->Hearing->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_Hearing" name="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_Hearing" id="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_Hearing" value="<?php echo HtmlEncode($hearings->Hearing->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_Hearing" name="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_Hearing" id="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_Hearing" value="<?php echo HtmlEncode($hearings->Hearing->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($hearings->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $hearings->Notes->cellAttributes() ?>>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_Notes" class="form-group hearings_Notes">
<?php AppendClass($hearings->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="hearings" data-field="x_Notes" name="x<?php echo $hearings_grid->RowIndex ?>_Notes" id="x<?php echo $hearings_grid->RowIndex ?>_Notes" cols="35" rows="3" placeholder="<?php echo HtmlEncode($hearings->Notes->getPlaceHolder()) ?>"<?php echo $hearings->Notes->editAttributes() ?>><?php echo $hearings->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_Notes", 35, 3, <?php echo ($hearings->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<input type="hidden" data-table="hearings" data-field="x_Notes" name="o<?php echo $hearings_grid->RowIndex ?>_Notes" id="o<?php echo $hearings_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($hearings->Notes->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_Notes" class="form-group hearings_Notes">
<?php AppendClass($hearings->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="hearings" data-field="x_Notes" name="x<?php echo $hearings_grid->RowIndex ?>_Notes" id="x<?php echo $hearings_grid->RowIndex ?>_Notes" cols="35" rows="3" placeholder="<?php echo HtmlEncode($hearings->Notes->getPlaceHolder()) ?>"<?php echo $hearings->Notes->editAttributes() ?>><?php echo $hearings->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_Notes", 35, 3, <?php echo ($hearings->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_Notes" class="hearings_Notes">
<span<?php echo $hearings->Notes->viewAttributes() ?>>
<?php echo $hearings->Notes->getViewValue() ?></span>
</span>
<?php if (!$hearings->isConfirm()) { ?>
<input type="hidden" data-table="hearings" data-field="x_Notes" name="x<?php echo $hearings_grid->RowIndex ?>_Notes" id="x<?php echo $hearings_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($hearings->Notes->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_Notes" name="o<?php echo $hearings_grid->RowIndex ?>_Notes" id="o<?php echo $hearings_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($hearings->Notes->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_Notes" name="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_Notes" id="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($hearings->Notes->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_Notes" name="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_Notes" id="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($hearings->Notes->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($hearings->LawyerID->Visible) { // LawyerID ?>
		<td data-name="LawyerID"<?php echo $hearings->LawyerID->cellAttributes() ?>>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_LawyerID" class="form-group hearings_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hearings" data-field="x_LawyerID" data-value-separator="<?php echo $hearings->LawyerID->displayValueSeparatorAttribute() ?>" id="x<?php echo $hearings_grid->RowIndex ?>_LawyerID" name="x<?php echo $hearings_grid->RowIndex ?>_LawyerID"<?php echo $hearings->LawyerID->editAttributes() ?>>
		<?php echo $hearings->LawyerID->selectOptionListHtml("x<?php echo $hearings_grid->RowIndex ?>_LawyerID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "lawyers") && !$hearings->LawyerID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_LawyerID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->LawyerID->caption() ?>" data-title="<?php echo $hearings->LawyerID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_LawyerID',url:'lawyersaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $hearings->LawyerID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_LawyerID") ?>
</span>
<input type="hidden" data-table="hearings" data-field="x_LawyerID" name="o<?php echo $hearings_grid->RowIndex ?>_LawyerID" id="o<?php echo $hearings_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($hearings->LawyerID->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_LawyerID" class="form-group hearings_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hearings" data-field="x_LawyerID" data-value-separator="<?php echo $hearings->LawyerID->displayValueSeparatorAttribute() ?>" id="x<?php echo $hearings_grid->RowIndex ?>_LawyerID" name="x<?php echo $hearings_grid->RowIndex ?>_LawyerID"<?php echo $hearings->LawyerID->editAttributes() ?>>
		<?php echo $hearings->LawyerID->selectOptionListHtml("x<?php echo $hearings_grid->RowIndex ?>_LawyerID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "lawyers") && !$hearings->LawyerID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_LawyerID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->LawyerID->caption() ?>" data-title="<?php echo $hearings->LawyerID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_LawyerID',url:'lawyersaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $hearings->LawyerID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_LawyerID") ?>
</span>
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_LawyerID" class="hearings_LawyerID">
<span<?php echo $hearings->LawyerID->viewAttributes() ?>>
<?php echo $hearings->LawyerID->getViewValue() ?></span>
</span>
<?php if (!$hearings->isConfirm()) { ?>
<input type="hidden" data-table="hearings" data-field="x_LawyerID" name="x<?php echo $hearings_grid->RowIndex ?>_LawyerID" id="x<?php echo $hearings_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($hearings->LawyerID->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_LawyerID" name="o<?php echo $hearings_grid->RowIndex ?>_LawyerID" id="o<?php echo $hearings_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($hearings->LawyerID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_LawyerID" name="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_LawyerID" id="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($hearings->LawyerID->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_LawyerID" name="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_LawyerID" id="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($hearings->LawyerID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($hearings->JudgeID->Visible) { // JudgeID ?>
		<td data-name="JudgeID"<?php echo $hearings->JudgeID->cellAttributes() ?>>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_JudgeID" class="form-group hearings_JudgeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hearings" data-field="x_JudgeID" data-value-separator="<?php echo $hearings->JudgeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $hearings_grid->RowIndex ?>_JudgeID" name="x<?php echo $hearings_grid->RowIndex ?>_JudgeID"<?php echo $hearings->JudgeID->editAttributes() ?>>
		<?php echo $hearings->JudgeID->selectOptionListHtml("x<?php echo $hearings_grid->RowIndex ?>_JudgeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "judges") && !$hearings->JudgeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_JudgeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->JudgeID->caption() ?>" data-title="<?php echo $hearings->JudgeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_JudgeID',url:'judgesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $hearings->JudgeID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_JudgeID") ?>
</span>
<input type="hidden" data-table="hearings" data-field="x_JudgeID" name="o<?php echo $hearings_grid->RowIndex ?>_JudgeID" id="o<?php echo $hearings_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($hearings->JudgeID->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_JudgeID" class="form-group hearings_JudgeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hearings" data-field="x_JudgeID" data-value-separator="<?php echo $hearings->JudgeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $hearings_grid->RowIndex ?>_JudgeID" name="x<?php echo $hearings_grid->RowIndex ?>_JudgeID"<?php echo $hearings->JudgeID->editAttributes() ?>>
		<?php echo $hearings->JudgeID->selectOptionListHtml("x<?php echo $hearings_grid->RowIndex ?>_JudgeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "judges") && !$hearings->JudgeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_JudgeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->JudgeID->caption() ?>" data-title="<?php echo $hearings->JudgeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_JudgeID',url:'judgesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $hearings->JudgeID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_JudgeID") ?>
</span>
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_JudgeID" class="hearings_JudgeID">
<span<?php echo $hearings->JudgeID->viewAttributes() ?>>
<?php echo $hearings->JudgeID->getViewValue() ?></span>
</span>
<?php if (!$hearings->isConfirm()) { ?>
<input type="hidden" data-table="hearings" data-field="x_JudgeID" name="x<?php echo $hearings_grid->RowIndex ?>_JudgeID" id="x<?php echo $hearings_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($hearings->JudgeID->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_JudgeID" name="o<?php echo $hearings_grid->RowIndex ?>_JudgeID" id="o<?php echo $hearings_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($hearings->JudgeID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_JudgeID" name="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_JudgeID" id="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($hearings->JudgeID->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_JudgeID" name="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_JudgeID" id="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($hearings->JudgeID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($hearings->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber"<?php echo $hearings->CaseNumber->cellAttributes() ?>>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_CaseNumber" class="form-group hearings_CaseNumber">
<input type="text" data-table="hearings" data-field="x_CaseNumber" name="x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" id="x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($hearings->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $hearings->CaseNumber->EditValue ?>"<?php echo $hearings->CaseNumber->editAttributes() ?>>
</span>
<input type="hidden" data-table="hearings" data-field="x_CaseNumber" name="o<?php echo $hearings_grid->RowIndex ?>_CaseNumber" id="o<?php echo $hearings_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($hearings->CaseNumber->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_CaseNumber" class="form-group hearings_CaseNumber">
<input type="hidden" data-table="hearings" data-field="x_CaseNumber" name="x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" id="x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($hearings->CaseNumber->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_CaseNumber" class="hearings_CaseNumber">
<span<?php echo $hearings->CaseNumber->viewAttributes() ?>>
<?php echo $hearings->CaseNumber->getViewValue() ?></span>
</span>
<?php if (!$hearings->isConfirm()) { ?>
<input type="hidden" data-table="hearings" data-field="x_CaseNumber" name="x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" id="x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($hearings->CaseNumber->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_CaseNumber" name="o<?php echo $hearings_grid->RowIndex ?>_CaseNumber" id="o<?php echo $hearings_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($hearings->CaseNumber->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_CaseNumber" name="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" id="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($hearings->CaseNumber->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_CaseNumber" name="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_CaseNumber" id="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($hearings->CaseNumber->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($hearings->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID"<?php echo $hearings->CourtID->cellAttributes() ?>>
<?php if ($hearings->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_CourtID" class="form-group hearings_CourtID">
<?php
$wrkonchange = "" . trim(@$hearings->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$hearings->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $hearings_grid->RowIndex ?>_CourtID" class="text-nowrap" style="z-index: <?php echo (9000 - $hearings_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $hearings_grid->RowIndex ?>_CourtID" id="sv_x<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo RemoveHtml($hearings->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($hearings->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($hearings->CourtID->getPlaceHolder()) ?>"<?php echo $hearings->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($hearings->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($hearings->CourtID->ReadOnly || $hearings->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$hearings->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->CourtID->caption() ?>" data-title="<?php echo $hearings->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="hearings" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $hearings->CourtID->displayValueSeparatorAttribute() ?>" name="x<?php echo $hearings_grid->RowIndex ?>_CourtID" id="x<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fhearingsgrid.createAutoSuggest({"id":"x<?php echo $hearings_grid->RowIndex ?>_CourtID","forceSelect":true});
</script>
<?php echo $hearings->CourtID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_CourtID") ?>
</span>
<input type="hidden" data-table="hearings" data-field="x_CourtID" name="o<?php echo $hearings_grid->RowIndex ?>_CourtID" id="o<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->OldValue) ?>">
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_CourtID" class="form-group hearings_CourtID">
<?php
$wrkonchange = "" . trim(@$hearings->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$hearings->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $hearings_grid->RowIndex ?>_CourtID" class="text-nowrap" style="z-index: <?php echo (9000 - $hearings_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $hearings_grid->RowIndex ?>_CourtID" id="sv_x<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo RemoveHtml($hearings->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($hearings->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($hearings->CourtID->getPlaceHolder()) ?>"<?php echo $hearings->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($hearings->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($hearings->CourtID->ReadOnly || $hearings->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$hearings->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->CourtID->caption() ?>" data-title="<?php echo $hearings->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="hearings" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $hearings->CourtID->displayValueSeparatorAttribute() ?>" name="x<?php echo $hearings_grid->RowIndex ?>_CourtID" id="x<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fhearingsgrid.createAutoSuggest({"id":"x<?php echo $hearings_grid->RowIndex ?>_CourtID","forceSelect":true});
</script>
<?php echo $hearings->CourtID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_CourtID") ?>
</span>
<?php } ?>
<?php if ($hearings->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $hearings_grid->RowCnt ?>_hearings_CourtID" class="hearings_CourtID">
<span<?php echo $hearings->CourtID->viewAttributes() ?>>
<?php echo $hearings->CourtID->getViewValue() ?></span>
</span>
<?php if (!$hearings->isConfirm()) { ?>
<input type="hidden" data-table="hearings" data-field="x_CourtID" name="x<?php echo $hearings_grid->RowIndex ?>_CourtID" id="x<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_CourtID" name="o<?php echo $hearings_grid->RowIndex ?>_CourtID" id="o<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_CourtID" name="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_CourtID" id="fhearingsgrid$x<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->FormValue) ?>">
<input type="hidden" data-table="hearings" data-field="x_CourtID" name="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_CourtID" id="fhearingsgrid$o<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$hearings_grid->ListOptions->render("body", "right", $hearings_grid->RowCnt);
?>
	</tr>
<?php if ($hearings->RowType == ROWTYPE_ADD || $hearings->RowType == ROWTYPE_EDIT) { ?>
<script>
fhearingsgrid.updateLists(<?php echo $hearings_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$hearings->isGridAdd() || $hearings->CurrentMode == "copy")
		if (!$hearings_grid->Recordset->EOF)
			$hearings_grid->Recordset->moveNext();
}
?>
<?php
	if ($hearings->CurrentMode == "add" || $hearings->CurrentMode == "copy" || $hearings->CurrentMode == "edit") {
		$hearings_grid->RowIndex = '$rowindex$';
		$hearings_grid->loadRowValues();

		// Set row properties
		$hearings->resetAttributes();
		$hearings->RowAttrs = array_merge($hearings->RowAttrs, array('data-rowindex'=>$hearings_grid->RowIndex, 'id'=>'r0_hearings', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($hearings->RowAttrs["class"], "ew-template");
		$hearings->RowType = ROWTYPE_ADD;

		// Render row
		$hearings_grid->renderRow();

		// Render list options
		$hearings_grid->renderListOptions();
		$hearings_grid->StartRowCnt = 0;
?>
	<tr<?php echo $hearings->rowAttributes() ?>>
<?php

// Render list options (body, left)
$hearings_grid->ListOptions->render("body", "left", $hearings_grid->RowIndex);
?>
	<?php if ($hearings->CaseID->Visible) { // CaseID ?>
		<td data-name="CaseID">
<?php if (!$hearings->isConfirm()) { ?>
<?php if ($hearings->CaseID->getSessionValue() <> "") { ?>
<span id="el$rowindex$_hearings_CaseID" class="form-group hearings_CaseID">
<span<?php echo $hearings->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $hearings_grid->RowIndex ?>_CaseID" name="x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_hearings_CaseID" class="form-group hearings_CaseID">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$hearings->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$hearings->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $hearings_grid->RowIndex ?>_CaseID" class="text-nowrap" style="z-index: <?php echo (9000 - $hearings_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $hearings_grid->RowIndex ?>_CaseID" id="sv_x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo RemoveHtml($hearings->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($hearings->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($hearings->CaseID->getPlaceHolder()) ?>"<?php echo $hearings->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($hearings->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CaseID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($hearings->CaseID->ReadOnly || $hearings->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "cases") && !$hearings->CaseID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_CaseID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->CaseID->caption() ?>" data-title="<?php echo $hearings->CaseID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CaseID',url:'casesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="hearings" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $hearings->CaseID->displayValueSeparatorAttribute() ?>" name="x<?php echo $hearings_grid->RowIndex ?>_CaseID" id="x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fhearingsgrid.createAutoSuggest({"id":"x<?php echo $hearings_grid->RowIndex ?>_CaseID","forceSelect":true});
</script>
<?php echo $hearings->CaseID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_CaseID") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_hearings_CaseID" class="form-group hearings_CaseID">
<span<?php echo $hearings->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="hearings" data-field="x_CaseID" name="x<?php echo $hearings_grid->RowIndex ?>_CaseID" id="x<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_CaseID" name="o<?php echo $hearings_grid->RowIndex ?>_CaseID" id="o<?php echo $hearings_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($hearings->HearingDate->Visible) { // HearingDate ?>
		<td data-name="HearingDate">
<?php if (!$hearings->isConfirm()) { ?>
<span id="el$rowindex$_hearings_HearingDate" class="form-group hearings_HearingDate">
<input type="text" data-table="hearings" data-field="x_HearingDate" data-format="7" name="x<?php echo $hearings_grid->RowIndex ?>_HearingDate" id="x<?php echo $hearings_grid->RowIndex ?>_HearingDate" placeholder="<?php echo HtmlEncode($hearings->HearingDate->getPlaceHolder()) ?>" value="<?php echo $hearings->HearingDate->EditValue ?>"<?php echo $hearings->HearingDate->editAttributes() ?>>
<?php if (!$hearings->HearingDate->ReadOnly && !$hearings->HearingDate->Disabled && !isset($hearings->HearingDate->EditAttrs["readonly"]) && !isset($hearings->HearingDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_HearingDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_hearings_HearingDate" class="form-group hearings_HearingDate">
<span<?php echo $hearings->HearingDate->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->HearingDate->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="hearings" data-field="x_HearingDate" name="x<?php echo $hearings_grid->RowIndex ?>_HearingDate" id="x<?php echo $hearings_grid->RowIndex ?>_HearingDate" value="<?php echo HtmlEncode($hearings->HearingDate->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_HearingDate" name="o<?php echo $hearings_grid->RowIndex ?>_HearingDate" id="o<?php echo $hearings_grid->RowIndex ?>_HearingDate" value="<?php echo HtmlEncode($hearings->HearingDate->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($hearings->HearingTime->Visible) { // HearingTime ?>
		<td data-name="HearingTime">
<?php if (!$hearings->isConfirm()) { ?>
<span id="el$rowindex$_hearings_HearingTime" class="form-group hearings_HearingTime">
<input type="text" data-table="hearings" data-field="x_HearingTime" name="x<?php echo $hearings_grid->RowIndex ?>_HearingTime" id="x<?php echo $hearings_grid->RowIndex ?>_HearingTime" placeholder="<?php echo HtmlEncode($hearings->HearingTime->getPlaceHolder()) ?>" value="<?php echo $hearings->HearingTime->EditValue ?>"<?php echo $hearings->HearingTime->editAttributes() ?>>
<?php if (!$hearings->HearingTime->ReadOnly && !$hearings->HearingTime->Disabled && !isset($hearings->HearingTime->EditAttrs["readonly"]) && !isset($hearings->HearingTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_HearingTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_hearings_HearingTime" class="form-group hearings_HearingTime">
<span<?php echo $hearings->HearingTime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->HearingTime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="hearings" data-field="x_HearingTime" name="x<?php echo $hearings_grid->RowIndex ?>_HearingTime" id="x<?php echo $hearings_grid->RowIndex ?>_HearingTime" value="<?php echo HtmlEncode($hearings->HearingTime->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_HearingTime" name="o<?php echo $hearings_grid->RowIndex ?>_HearingTime" id="o<?php echo $hearings_grid->RowIndex ?>_HearingTime" value="<?php echo HtmlEncode($hearings->HearingTime->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($hearings->NextHearingDate->Visible) { // NextHearingDate ?>
		<td data-name="NextHearingDate">
<?php if (!$hearings->isConfirm()) { ?>
<span id="el$rowindex$_hearings_NextHearingDate" class="form-group hearings_NextHearingDate">
<input type="text" data-table="hearings" data-field="x_NextHearingDate" data-format="7" name="x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" id="x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" placeholder="<?php echo HtmlEncode($hearings->NextHearingDate->getPlaceHolder()) ?>" value="<?php echo $hearings->NextHearingDate->EditValue ?>"<?php echo $hearings->NextHearingDate->editAttributes() ?>>
<?php if (!$hearings->NextHearingDate->ReadOnly && !$hearings->NextHearingDate->Disabled && !isset($hearings->NextHearingDate->EditAttrs["readonly"]) && !isset($hearings->NextHearingDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_hearings_NextHearingDate" class="form-group hearings_NextHearingDate">
<span<?php echo $hearings->NextHearingDate->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->NextHearingDate->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="hearings" data-field="x_NextHearingDate" name="x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" id="x<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" value="<?php echo HtmlEncode($hearings->NextHearingDate->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_NextHearingDate" name="o<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" id="o<?php echo $hearings_grid->RowIndex ?>_NextHearingDate" value="<?php echo HtmlEncode($hearings->NextHearingDate->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($hearings->NextHearingTime->Visible) { // NextHearingTime ?>
		<td data-name="NextHearingTime">
<?php if (!$hearings->isConfirm()) { ?>
<span id="el$rowindex$_hearings_NextHearingTime" class="form-group hearings_NextHearingTime">
<input type="text" data-table="hearings" data-field="x_NextHearingTime" name="x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" id="x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" placeholder="<?php echo HtmlEncode($hearings->NextHearingTime->getPlaceHolder()) ?>" value="<?php echo $hearings->NextHearingTime->EditValue ?>"<?php echo $hearings->NextHearingTime->editAttributes() ?>>
<?php if (!$hearings->NextHearingTime->ReadOnly && !$hearings->NextHearingTime->Disabled && !isset($hearings->NextHearingTime->EditAttrs["readonly"]) && !isset($hearings->NextHearingTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_hearings_NextHearingTime" class="form-group hearings_NextHearingTime">
<span<?php echo $hearings->NextHearingTime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->NextHearingTime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="hearings" data-field="x_NextHearingTime" name="x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" id="x<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" value="<?php echo HtmlEncode($hearings->NextHearingTime->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_NextHearingTime" name="o<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" id="o<?php echo $hearings_grid->RowIndex ?>_NextHearingTime" value="<?php echo HtmlEncode($hearings->NextHearingTime->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($hearings->Hearing->Visible) { // Hearing ?>
		<td data-name="Hearing">
<?php if (!$hearings->isConfirm()) { ?>
<span id="el$rowindex$_hearings_Hearing" class="form-group hearings_Hearing">
<textarea data-table="hearings" data-field="x_Hearing" name="x<?php echo $hearings_grid->RowIndex ?>_Hearing" id="x<?php echo $hearings_grid->RowIndex ?>_Hearing" cols="35" rows="2" placeholder="<?php echo HtmlEncode($hearings->Hearing->getPlaceHolder()) ?>"<?php echo $hearings->Hearing->editAttributes() ?>><?php echo $hearings->Hearing->EditValue ?></textarea>
</span>
<?php } else { ?>
<span id="el$rowindex$_hearings_Hearing" class="form-group hearings_Hearing">
<span<?php echo $hearings->Hearing->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->Hearing->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="hearings" data-field="x_Hearing" name="x<?php echo $hearings_grid->RowIndex ?>_Hearing" id="x<?php echo $hearings_grid->RowIndex ?>_Hearing" value="<?php echo HtmlEncode($hearings->Hearing->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_Hearing" name="o<?php echo $hearings_grid->RowIndex ?>_Hearing" id="o<?php echo $hearings_grid->RowIndex ?>_Hearing" value="<?php echo HtmlEncode($hearings->Hearing->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($hearings->Notes->Visible) { // Notes ?>
		<td data-name="Notes">
<?php if (!$hearings->isConfirm()) { ?>
<span id="el$rowindex$_hearings_Notes" class="form-group hearings_Notes">
<?php AppendClass($hearings->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="hearings" data-field="x_Notes" name="x<?php echo $hearings_grid->RowIndex ?>_Notes" id="x<?php echo $hearings_grid->RowIndex ?>_Notes" cols="35" rows="3" placeholder="<?php echo HtmlEncode($hearings->Notes->getPlaceHolder()) ?>"<?php echo $hearings->Notes->editAttributes() ?>><?php echo $hearings->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fhearingsgrid", "x<?php echo $hearings_grid->RowIndex ?>_Notes", 35, 3, <?php echo ($hearings->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php } else { ?>
<span id="el$rowindex$_hearings_Notes" class="form-group hearings_Notes">
<span<?php echo $hearings->Notes->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->Notes->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="hearings" data-field="x_Notes" name="x<?php echo $hearings_grid->RowIndex ?>_Notes" id="x<?php echo $hearings_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($hearings->Notes->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_Notes" name="o<?php echo $hearings_grid->RowIndex ?>_Notes" id="o<?php echo $hearings_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($hearings->Notes->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($hearings->LawyerID->Visible) { // LawyerID ?>
		<td data-name="LawyerID">
<?php if (!$hearings->isConfirm()) { ?>
<span id="el$rowindex$_hearings_LawyerID" class="form-group hearings_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hearings" data-field="x_LawyerID" data-value-separator="<?php echo $hearings->LawyerID->displayValueSeparatorAttribute() ?>" id="x<?php echo $hearings_grid->RowIndex ?>_LawyerID" name="x<?php echo $hearings_grid->RowIndex ?>_LawyerID"<?php echo $hearings->LawyerID->editAttributes() ?>>
		<?php echo $hearings->LawyerID->selectOptionListHtml("x<?php echo $hearings_grid->RowIndex ?>_LawyerID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "lawyers") && !$hearings->LawyerID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_LawyerID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->LawyerID->caption() ?>" data-title="<?php echo $hearings->LawyerID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_LawyerID',url:'lawyersaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $hearings->LawyerID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_LawyerID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_hearings_LawyerID" class="form-group hearings_LawyerID">
<span<?php echo $hearings->LawyerID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->LawyerID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="hearings" data-field="x_LawyerID" name="x<?php echo $hearings_grid->RowIndex ?>_LawyerID" id="x<?php echo $hearings_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($hearings->LawyerID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_LawyerID" name="o<?php echo $hearings_grid->RowIndex ?>_LawyerID" id="o<?php echo $hearings_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($hearings->LawyerID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($hearings->JudgeID->Visible) { // JudgeID ?>
		<td data-name="JudgeID">
<?php if (!$hearings->isConfirm()) { ?>
<span id="el$rowindex$_hearings_JudgeID" class="form-group hearings_JudgeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hearings" data-field="x_JudgeID" data-value-separator="<?php echo $hearings->JudgeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $hearings_grid->RowIndex ?>_JudgeID" name="x<?php echo $hearings_grid->RowIndex ?>_JudgeID"<?php echo $hearings->JudgeID->editAttributes() ?>>
		<?php echo $hearings->JudgeID->selectOptionListHtml("x<?php echo $hearings_grid->RowIndex ?>_JudgeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "judges") && !$hearings->JudgeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_JudgeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->JudgeID->caption() ?>" data-title="<?php echo $hearings->JudgeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_JudgeID',url:'judgesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $hearings->JudgeID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_JudgeID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_hearings_JudgeID" class="form-group hearings_JudgeID">
<span<?php echo $hearings->JudgeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->JudgeID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="hearings" data-field="x_JudgeID" name="x<?php echo $hearings_grid->RowIndex ?>_JudgeID" id="x<?php echo $hearings_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($hearings->JudgeID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_JudgeID" name="o<?php echo $hearings_grid->RowIndex ?>_JudgeID" id="o<?php echo $hearings_grid->RowIndex ?>_JudgeID" value="<?php echo HtmlEncode($hearings->JudgeID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($hearings->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber">
<?php if (!$hearings->isConfirm()) { ?>
<span id="el$rowindex$_hearings_CaseNumber" class="form-group hearings_CaseNumber">
<input type="text" data-table="hearings" data-field="x_CaseNumber" name="x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" id="x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($hearings->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $hearings->CaseNumber->EditValue ?>"<?php echo $hearings->CaseNumber->editAttributes() ?>>
</span>
<?php } else { ?>
<input type="hidden" data-table="hearings" data-field="x_CaseNumber" name="x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" id="x<?php echo $hearings_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($hearings->CaseNumber->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_CaseNumber" name="o<?php echo $hearings_grid->RowIndex ?>_CaseNumber" id="o<?php echo $hearings_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($hearings->CaseNumber->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($hearings->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID">
<?php if (!$hearings->isConfirm()) { ?>
<span id="el$rowindex$_hearings_CourtID" class="form-group hearings_CourtID">
<?php
$wrkonchange = "" . trim(@$hearings->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$hearings->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $hearings_grid->RowIndex ?>_CourtID" class="text-nowrap" style="z-index: <?php echo (9000 - $hearings_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $hearings_grid->RowIndex ?>_CourtID" id="sv_x<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo RemoveHtml($hearings->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($hearings->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($hearings->CourtID->getPlaceHolder()) ?>"<?php echo $hearings->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($hearings->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($hearings->CourtID->ReadOnly || $hearings->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$hearings->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $hearings_grid->RowIndex ?>_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->CourtID->caption() ?>" data-title="<?php echo $hearings->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $hearings_grid->RowIndex ?>_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="hearings" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $hearings->CourtID->displayValueSeparatorAttribute() ?>" name="x<?php echo $hearings_grid->RowIndex ?>_CourtID" id="x<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fhearingsgrid.createAutoSuggest({"id":"x<?php echo $hearings_grid->RowIndex ?>_CourtID","forceSelect":true});
</script>
<?php echo $hearings->CourtID->Lookup->getParamTag("p_x" . $hearings_grid->RowIndex . "_CourtID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_hearings_CourtID" class="form-group hearings_CourtID">
<span<?php echo $hearings->CourtID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->CourtID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="hearings" data-field="x_CourtID" name="x<?php echo $hearings_grid->RowIndex ?>_CourtID" id="x<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="hearings" data-field="x_CourtID" name="o<?php echo $hearings_grid->RowIndex ?>_CourtID" id="o<?php echo $hearings_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$hearings_grid->ListOptions->render("body", "right", $hearings_grid->RowIndex);
?>
<script>
fhearingsgrid.updateLists(<?php echo $hearings_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($hearings->CurrentMode == "add" || $hearings->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $hearings_grid->FormKeyCountName ?>" id="<?php echo $hearings_grid->FormKeyCountName ?>" value="<?php echo $hearings_grid->KeyCount ?>">
<?php echo $hearings_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($hearings->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $hearings_grid->FormKeyCountName ?>" id="<?php echo $hearings_grid->FormKeyCountName ?>" value="<?php echo $hearings_grid->KeyCount ?>">
<?php echo $hearings_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($hearings->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fhearingsgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($hearings_grid->Recordset)
	$hearings_grid->Recordset->Close();
?>
</div>
<?php if ($hearings_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $hearings_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($hearings_grid->TotalRecs == 0 && !$hearings->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $hearings_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$hearings_grid->terminate();
?>
<?php if (!$hearings->isExport()) { ?>
<script>
ew.scrollableTable("gmp_hearings", "1250px", "");
</script>
<?php } ?>
