<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$hearings_add = new hearings_add();

// Run the page
$hearings_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$hearings_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fhearingsadd = currentForm = new ew.Form("fhearingsadd", "add");

// Validate form
fhearingsadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($hearings_add->CaseID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->CaseID->caption(), $hearings->CaseID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($hearings_add->HearingDate->Required) { ?>
			elm = this.getElements("x" + infix + "_HearingDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->HearingDate->caption(), $hearings->HearingDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_HearingDate");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($hearings->HearingDate->errorMessage()) ?>");
		<?php if ($hearings_add->HearingTime->Required) { ?>
			elm = this.getElements("x" + infix + "_HearingTime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->HearingTime->caption(), $hearings->HearingTime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_HearingTime");
			if (elm && !ew.checkTime(elm.value))
				return this.onError(elm, "<?php echo JsEncode($hearings->HearingTime->errorMessage()) ?>");
		<?php if ($hearings_add->NextHearingDate->Required) { ?>
			elm = this.getElements("x" + infix + "_NextHearingDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->NextHearingDate->caption(), $hearings->NextHearingDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_NextHearingDate");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($hearings->NextHearingDate->errorMessage()) ?>");
		<?php if ($hearings_add->NextHearingTime->Required) { ?>
			elm = this.getElements("x" + infix + "_NextHearingTime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->NextHearingTime->caption(), $hearings->NextHearingTime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_NextHearingTime");
			if (elm && !ew.checkTime(elm.value))
				return this.onError(elm, "<?php echo JsEncode($hearings->NextHearingTime->errorMessage()) ?>");
		<?php if ($hearings_add->Hearing->Required) { ?>
			elm = this.getElements("x" + infix + "_Hearing");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->Hearing->caption(), $hearings->Hearing->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($hearings_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->Notes->caption(), $hearings->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($hearings_add->LawyerID->Required) { ?>
			elm = this.getElements("x" + infix + "_LawyerID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->LawyerID->caption(), $hearings->LawyerID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($hearings_add->JudgeID->Required) { ?>
			elm = this.getElements("x" + infix + "_JudgeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->JudgeID->caption(), $hearings->JudgeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($hearings_add->CourtID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $hearings->CourtID->caption(), $hearings->CourtID->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fhearingsadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fhearingsadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fhearingsadd.lists["x_CaseID"] = <?php echo $hearings_add->CaseID->Lookup->toClientList() ?>;
fhearingsadd.lists["x_CaseID"].options = <?php echo JsonEncode($hearings_add->CaseID->lookupOptions()) ?>;
fhearingsadd.autoSuggests["x_CaseID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fhearingsadd.lists["x_LawyerID"] = <?php echo $hearings_add->LawyerID->Lookup->toClientList() ?>;
fhearingsadd.lists["x_LawyerID"].options = <?php echo JsonEncode($hearings_add->LawyerID->lookupOptions()) ?>;
fhearingsadd.lists["x_JudgeID"] = <?php echo $hearings_add->JudgeID->Lookup->toClientList() ?>;
fhearingsadd.lists["x_JudgeID"].options = <?php echo JsonEncode($hearings_add->JudgeID->lookupOptions()) ?>;
fhearingsadd.lists["x_CourtID"] = <?php echo $hearings_add->CourtID->Lookup->toClientList() ?>;
fhearingsadd.lists["x_CourtID"].options = <?php echo JsonEncode($hearings_add->CourtID->lookupOptions()) ?>;
fhearingsadd.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $hearings_add->showPageHeader(); ?>
<?php
$hearings_add->showMessage();
?>
<form name="fhearingsadd" id="fhearingsadd" class="<?php echo $hearings_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($hearings_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $hearings_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="hearings">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$hearings_add->IsModal ?>">
<?php if ($hearings->getCurrentMasterTable() == "cases") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="cases">
<input type="hidden" name="fk_CaseID" value="<?php echo $hearings->CaseID->getSessionValue() ?>">
<?php } ?>
<?php if (!$hearings_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_hearingsadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($hearings->CaseID->Visible) { // CaseID ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
	<div id="r_CaseID" class="form-group row">
		<label id="elh_hearings_CaseID" class="<?php echo $hearings_add->LeftColumnClass ?>"><?php echo $hearings->CaseID->caption() ?><?php echo ($hearings->CaseID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $hearings_add->RightColumnClass ?>"><div<?php echo $hearings->CaseID->cellAttributes() ?>>
<?php if ($hearings->CaseID->getSessionValue() <> "") { ?>
<span id="el_hearings_CaseID">
<span<?php echo $hearings->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_CaseID" name="x_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_hearings_CaseID">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$hearings->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$hearings->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CaseID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CaseID" id="sv_x_CaseID" value="<?php echo RemoveHtml($hearings->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($hearings->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($hearings->CaseID->getPlaceHolder()) ?>"<?php echo $hearings->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($hearings->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CaseID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($hearings->CaseID->ReadOnly || $hearings->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "cases") && !$hearings->CaseID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->CaseID->caption() ?>" data-title="<?php echo $hearings->CaseID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseID',url:'casesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="hearings" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $hearings->CaseID->displayValueSeparatorAttribute() ?>" name="x_CaseID" id="x_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fhearingsadd.createAutoSuggest({"id":"x_CaseID","forceSelect":true});
</script>
<?php echo $hearings->CaseID->Lookup->getParamTag("p_x_CaseID") ?>
</span>
<?php } ?>
<?php echo $hearings->CaseID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseID">
		<td class="<?php echo $hearings_add->TableLeftColumnClass ?>"><span id="elh_hearings_CaseID"><?php echo $hearings->CaseID->caption() ?><?php echo ($hearings->CaseID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $hearings->CaseID->cellAttributes() ?>>
<?php if ($hearings->CaseID->getSessionValue() <> "") { ?>
<span id="el_hearings_CaseID">
<span<?php echo $hearings->CaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($hearings->CaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_CaseID" name="x_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_hearings_CaseID">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$hearings->CaseID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$hearings->CaseID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CaseID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CaseID" id="sv_x_CaseID" value="<?php echo RemoveHtml($hearings->CaseID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($hearings->CaseID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($hearings->CaseID->getPlaceHolder()) ?>"<?php echo $hearings->CaseID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($hearings->CaseID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CaseID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($hearings->CaseID->ReadOnly || $hearings->CaseID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "cases") && !$hearings->CaseID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->CaseID->caption() ?>" data-title="<?php echo $hearings->CaseID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseID',url:'casesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="hearings" data-field="x_CaseID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $hearings->CaseID->displayValueSeparatorAttribute() ?>" name="x_CaseID" id="x_CaseID" value="<?php echo HtmlEncode($hearings->CaseID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fhearingsadd.createAutoSuggest({"id":"x_CaseID","forceSelect":true});
</script>
<?php echo $hearings->CaseID->Lookup->getParamTag("p_x_CaseID") ?>
</span>
<?php } ?>
<?php echo $hearings->CaseID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($hearings->HearingDate->Visible) { // HearingDate ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
	<div id="r_HearingDate" class="form-group row">
		<label id="elh_hearings_HearingDate" for="x_HearingDate" class="<?php echo $hearings_add->LeftColumnClass ?>"><?php echo $hearings->HearingDate->caption() ?><?php echo ($hearings->HearingDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $hearings_add->RightColumnClass ?>"><div<?php echo $hearings->HearingDate->cellAttributes() ?>>
<span id="el_hearings_HearingDate">
<input type="text" data-table="hearings" data-field="x_HearingDate" data-format="7" name="x_HearingDate" id="x_HearingDate" placeholder="<?php echo HtmlEncode($hearings->HearingDate->getPlaceHolder()) ?>" value="<?php echo $hearings->HearingDate->EditValue ?>"<?php echo $hearings->HearingDate->editAttributes() ?>>
<?php if (!$hearings->HearingDate->ReadOnly && !$hearings->HearingDate->Disabled && !isset($hearings->HearingDate->EditAttrs["readonly"]) && !isset($hearings->HearingDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fhearingsadd", "x_HearingDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $hearings->HearingDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_HearingDate">
		<td class="<?php echo $hearings_add->TableLeftColumnClass ?>"><span id="elh_hearings_HearingDate"><?php echo $hearings->HearingDate->caption() ?><?php echo ($hearings->HearingDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $hearings->HearingDate->cellAttributes() ?>>
<span id="el_hearings_HearingDate">
<input type="text" data-table="hearings" data-field="x_HearingDate" data-format="7" name="x_HearingDate" id="x_HearingDate" placeholder="<?php echo HtmlEncode($hearings->HearingDate->getPlaceHolder()) ?>" value="<?php echo $hearings->HearingDate->EditValue ?>"<?php echo $hearings->HearingDate->editAttributes() ?>>
<?php if (!$hearings->HearingDate->ReadOnly && !$hearings->HearingDate->Disabled && !isset($hearings->HearingDate->EditAttrs["readonly"]) && !isset($hearings->HearingDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fhearingsadd", "x_HearingDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $hearings->HearingDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($hearings->HearingTime->Visible) { // HearingTime ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
	<div id="r_HearingTime" class="form-group row">
		<label id="elh_hearings_HearingTime" for="x_HearingTime" class="<?php echo $hearings_add->LeftColumnClass ?>"><?php echo $hearings->HearingTime->caption() ?><?php echo ($hearings->HearingTime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $hearings_add->RightColumnClass ?>"><div<?php echo $hearings->HearingTime->cellAttributes() ?>>
<span id="el_hearings_HearingTime">
<input type="text" data-table="hearings" data-field="x_HearingTime" name="x_HearingTime" id="x_HearingTime" placeholder="<?php echo HtmlEncode($hearings->HearingTime->getPlaceHolder()) ?>" value="<?php echo $hearings->HearingTime->EditValue ?>"<?php echo $hearings->HearingTime->editAttributes() ?>>
<?php if (!$hearings->HearingTime->ReadOnly && !$hearings->HearingTime->Disabled && !isset($hearings->HearingTime->EditAttrs["readonly"]) && !isset($hearings->HearingTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fhearingsadd", "x_HearingTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php echo $hearings->HearingTime->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_HearingTime">
		<td class="<?php echo $hearings_add->TableLeftColumnClass ?>"><span id="elh_hearings_HearingTime"><?php echo $hearings->HearingTime->caption() ?><?php echo ($hearings->HearingTime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $hearings->HearingTime->cellAttributes() ?>>
<span id="el_hearings_HearingTime">
<input type="text" data-table="hearings" data-field="x_HearingTime" name="x_HearingTime" id="x_HearingTime" placeholder="<?php echo HtmlEncode($hearings->HearingTime->getPlaceHolder()) ?>" value="<?php echo $hearings->HearingTime->EditValue ?>"<?php echo $hearings->HearingTime->editAttributes() ?>>
<?php if (!$hearings->HearingTime->ReadOnly && !$hearings->HearingTime->Disabled && !isset($hearings->HearingTime->EditAttrs["readonly"]) && !isset($hearings->HearingTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fhearingsadd", "x_HearingTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php echo $hearings->HearingTime->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($hearings->NextHearingDate->Visible) { // NextHearingDate ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
	<div id="r_NextHearingDate" class="form-group row">
		<label id="elh_hearings_NextHearingDate" for="x_NextHearingDate" class="<?php echo $hearings_add->LeftColumnClass ?>"><?php echo $hearings->NextHearingDate->caption() ?><?php echo ($hearings->NextHearingDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $hearings_add->RightColumnClass ?>"><div<?php echo $hearings->NextHearingDate->cellAttributes() ?>>
<span id="el_hearings_NextHearingDate">
<input type="text" data-table="hearings" data-field="x_NextHearingDate" data-format="7" name="x_NextHearingDate" id="x_NextHearingDate" placeholder="<?php echo HtmlEncode($hearings->NextHearingDate->getPlaceHolder()) ?>" value="<?php echo $hearings->NextHearingDate->EditValue ?>"<?php echo $hearings->NextHearingDate->editAttributes() ?>>
<?php if (!$hearings->NextHearingDate->ReadOnly && !$hearings->NextHearingDate->Disabled && !isset($hearings->NextHearingDate->EditAttrs["readonly"]) && !isset($hearings->NextHearingDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fhearingsadd", "x_NextHearingDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $hearings->NextHearingDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_NextHearingDate">
		<td class="<?php echo $hearings_add->TableLeftColumnClass ?>"><span id="elh_hearings_NextHearingDate"><?php echo $hearings->NextHearingDate->caption() ?><?php echo ($hearings->NextHearingDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $hearings->NextHearingDate->cellAttributes() ?>>
<span id="el_hearings_NextHearingDate">
<input type="text" data-table="hearings" data-field="x_NextHearingDate" data-format="7" name="x_NextHearingDate" id="x_NextHearingDate" placeholder="<?php echo HtmlEncode($hearings->NextHearingDate->getPlaceHolder()) ?>" value="<?php echo $hearings->NextHearingDate->EditValue ?>"<?php echo $hearings->NextHearingDate->editAttributes() ?>>
<?php if (!$hearings->NextHearingDate->ReadOnly && !$hearings->NextHearingDate->Disabled && !isset($hearings->NextHearingDate->EditAttrs["readonly"]) && !isset($hearings->NextHearingDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fhearingsadd", "x_NextHearingDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $hearings->NextHearingDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($hearings->NextHearingTime->Visible) { // NextHearingTime ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
	<div id="r_NextHearingTime" class="form-group row">
		<label id="elh_hearings_NextHearingTime" for="x_NextHearingTime" class="<?php echo $hearings_add->LeftColumnClass ?>"><?php echo $hearings->NextHearingTime->caption() ?><?php echo ($hearings->NextHearingTime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $hearings_add->RightColumnClass ?>"><div<?php echo $hearings->NextHearingTime->cellAttributes() ?>>
<span id="el_hearings_NextHearingTime">
<input type="text" data-table="hearings" data-field="x_NextHearingTime" name="x_NextHearingTime" id="x_NextHearingTime" placeholder="<?php echo HtmlEncode($hearings->NextHearingTime->getPlaceHolder()) ?>" value="<?php echo $hearings->NextHearingTime->EditValue ?>"<?php echo $hearings->NextHearingTime->editAttributes() ?>>
<?php if (!$hearings->NextHearingTime->ReadOnly && !$hearings->NextHearingTime->Disabled && !isset($hearings->NextHearingTime->EditAttrs["readonly"]) && !isset($hearings->NextHearingTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fhearingsadd", "x_NextHearingTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php echo $hearings->NextHearingTime->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_NextHearingTime">
		<td class="<?php echo $hearings_add->TableLeftColumnClass ?>"><span id="elh_hearings_NextHearingTime"><?php echo $hearings->NextHearingTime->caption() ?><?php echo ($hearings->NextHearingTime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $hearings->NextHearingTime->cellAttributes() ?>>
<span id="el_hearings_NextHearingTime">
<input type="text" data-table="hearings" data-field="x_NextHearingTime" name="x_NextHearingTime" id="x_NextHearingTime" placeholder="<?php echo HtmlEncode($hearings->NextHearingTime->getPlaceHolder()) ?>" value="<?php echo $hearings->NextHearingTime->EditValue ?>"<?php echo $hearings->NextHearingTime->editAttributes() ?>>
<?php if (!$hearings->NextHearingTime->ReadOnly && !$hearings->NextHearingTime->Disabled && !isset($hearings->NextHearingTime->EditAttrs["readonly"]) && !isset($hearings->NextHearingTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fhearingsadd", "x_NextHearingTime", {"timeFormat":"H:i:s","step":15});</script><?php } ?>
</span>
<?php echo $hearings->NextHearingTime->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($hearings->Hearing->Visible) { // Hearing ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
	<div id="r_Hearing" class="form-group row">
		<label id="elh_hearings_Hearing" for="x_Hearing" class="<?php echo $hearings_add->LeftColumnClass ?>"><?php echo $hearings->Hearing->caption() ?><?php echo ($hearings->Hearing->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $hearings_add->RightColumnClass ?>"><div<?php echo $hearings->Hearing->cellAttributes() ?>>
<span id="el_hearings_Hearing">
<textarea data-table="hearings" data-field="x_Hearing" name="x_Hearing" id="x_Hearing" cols="35" rows="2" placeholder="<?php echo HtmlEncode($hearings->Hearing->getPlaceHolder()) ?>"<?php echo $hearings->Hearing->editAttributes() ?>><?php echo $hearings->Hearing->EditValue ?></textarea>
</span>
<?php echo $hearings->Hearing->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Hearing">
		<td class="<?php echo $hearings_add->TableLeftColumnClass ?>"><span id="elh_hearings_Hearing"><?php echo $hearings->Hearing->caption() ?><?php echo ($hearings->Hearing->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $hearings->Hearing->cellAttributes() ?>>
<span id="el_hearings_Hearing">
<textarea data-table="hearings" data-field="x_Hearing" name="x_Hearing" id="x_Hearing" cols="35" rows="2" placeholder="<?php echo HtmlEncode($hearings->Hearing->getPlaceHolder()) ?>"<?php echo $hearings->Hearing->editAttributes() ?>><?php echo $hearings->Hearing->EditValue ?></textarea>
</span>
<?php echo $hearings->Hearing->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($hearings->Notes->Visible) { // Notes ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_hearings_Notes" class="<?php echo $hearings_add->LeftColumnClass ?>"><?php echo $hearings->Notes->caption() ?><?php echo ($hearings->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $hearings_add->RightColumnClass ?>"><div<?php echo $hearings->Notes->cellAttributes() ?>>
<span id="el_hearings_Notes">
<?php AppendClass($hearings->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="hearings" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="3" placeholder="<?php echo HtmlEncode($hearings->Notes->getPlaceHolder()) ?>"<?php echo $hearings->Notes->editAttributes() ?>><?php echo $hearings->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fhearingsadd", "x_Notes", 35, 3, <?php echo ($hearings->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $hearings->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $hearings_add->TableLeftColumnClass ?>"><span id="elh_hearings_Notes"><?php echo $hearings->Notes->caption() ?><?php echo ($hearings->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $hearings->Notes->cellAttributes() ?>>
<span id="el_hearings_Notes">
<?php AppendClass($hearings->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="hearings" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="3" placeholder="<?php echo HtmlEncode($hearings->Notes->getPlaceHolder()) ?>"<?php echo $hearings->Notes->editAttributes() ?>><?php echo $hearings->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fhearingsadd", "x_Notes", 35, 3, <?php echo ($hearings->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $hearings->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($hearings->LawyerID->Visible) { // LawyerID ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
	<div id="r_LawyerID" class="form-group row">
		<label id="elh_hearings_LawyerID" for="x_LawyerID" class="<?php echo $hearings_add->LeftColumnClass ?>"><?php echo $hearings->LawyerID->caption() ?><?php echo ($hearings->LawyerID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $hearings_add->RightColumnClass ?>"><div<?php echo $hearings->LawyerID->cellAttributes() ?>>
<span id="el_hearings_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hearings" data-field="x_LawyerID" data-value-separator="<?php echo $hearings->LawyerID->displayValueSeparatorAttribute() ?>" id="x_LawyerID" name="x_LawyerID"<?php echo $hearings->LawyerID->editAttributes() ?>>
		<?php echo $hearings->LawyerID->selectOptionListHtml("x_LawyerID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "lawyers") && !$hearings->LawyerID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LawyerID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->LawyerID->caption() ?>" data-title="<?php echo $hearings->LawyerID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LawyerID',url:'lawyersaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $hearings->LawyerID->Lookup->getParamTag("p_x_LawyerID") ?>
</span>
<?php echo $hearings->LawyerID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LawyerID">
		<td class="<?php echo $hearings_add->TableLeftColumnClass ?>"><span id="elh_hearings_LawyerID"><?php echo $hearings->LawyerID->caption() ?><?php echo ($hearings->LawyerID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $hearings->LawyerID->cellAttributes() ?>>
<span id="el_hearings_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hearings" data-field="x_LawyerID" data-value-separator="<?php echo $hearings->LawyerID->displayValueSeparatorAttribute() ?>" id="x_LawyerID" name="x_LawyerID"<?php echo $hearings->LawyerID->editAttributes() ?>>
		<?php echo $hearings->LawyerID->selectOptionListHtml("x_LawyerID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "lawyers") && !$hearings->LawyerID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LawyerID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->LawyerID->caption() ?>" data-title="<?php echo $hearings->LawyerID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LawyerID',url:'lawyersaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $hearings->LawyerID->Lookup->getParamTag("p_x_LawyerID") ?>
</span>
<?php echo $hearings->LawyerID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($hearings->JudgeID->Visible) { // JudgeID ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
	<div id="r_JudgeID" class="form-group row">
		<label id="elh_hearings_JudgeID" for="x_JudgeID" class="<?php echo $hearings_add->LeftColumnClass ?>"><?php echo $hearings->JudgeID->caption() ?><?php echo ($hearings->JudgeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $hearings_add->RightColumnClass ?>"><div<?php echo $hearings->JudgeID->cellAttributes() ?>>
<span id="el_hearings_JudgeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hearings" data-field="x_JudgeID" data-value-separator="<?php echo $hearings->JudgeID->displayValueSeparatorAttribute() ?>" id="x_JudgeID" name="x_JudgeID"<?php echo $hearings->JudgeID->editAttributes() ?>>
		<?php echo $hearings->JudgeID->selectOptionListHtml("x_JudgeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "judges") && !$hearings->JudgeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_JudgeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->JudgeID->caption() ?>" data-title="<?php echo $hearings->JudgeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_JudgeID',url:'judgesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $hearings->JudgeID->Lookup->getParamTag("p_x_JudgeID") ?>
</span>
<?php echo $hearings->JudgeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_JudgeID">
		<td class="<?php echo $hearings_add->TableLeftColumnClass ?>"><span id="elh_hearings_JudgeID"><?php echo $hearings->JudgeID->caption() ?><?php echo ($hearings->JudgeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $hearings->JudgeID->cellAttributes() ?>>
<span id="el_hearings_JudgeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="hearings" data-field="x_JudgeID" data-value-separator="<?php echo $hearings->JudgeID->displayValueSeparatorAttribute() ?>" id="x_JudgeID" name="x_JudgeID"<?php echo $hearings->JudgeID->editAttributes() ?>>
		<?php echo $hearings->JudgeID->selectOptionListHtml("x_JudgeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "judges") && !$hearings->JudgeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_JudgeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->JudgeID->caption() ?>" data-title="<?php echo $hearings->JudgeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_JudgeID',url:'judgesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $hearings->JudgeID->Lookup->getParamTag("p_x_JudgeID") ?>
</span>
<?php echo $hearings->JudgeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($hearings->CourtID->Visible) { // CourtID ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
	<div id="r_CourtID" class="form-group row">
		<label id="elh_hearings_CourtID" class="<?php echo $hearings_add->LeftColumnClass ?>"><?php echo $hearings->CourtID->caption() ?><?php echo ($hearings->CourtID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $hearings_add->RightColumnClass ?>"><div<?php echo $hearings->CourtID->cellAttributes() ?>>
<span id="el_hearings_CourtID">
<?php
$wrkonchange = "" . trim(@$hearings->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$hearings->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8770">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($hearings->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($hearings->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($hearings->CourtID->getPlaceHolder()) ?>"<?php echo $hearings->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($hearings->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($hearings->CourtID->ReadOnly || $hearings->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$hearings->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->CourtID->caption() ?>" data-title="<?php echo $hearings->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="hearings" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $hearings->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fhearingsadd.createAutoSuggest({"id":"x_CourtID","forceSelect":true});
</script>
<?php echo $hearings->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</span>
<?php echo $hearings->CourtID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtID">
		<td class="<?php echo $hearings_add->TableLeftColumnClass ?>"><span id="elh_hearings_CourtID"><?php echo $hearings->CourtID->caption() ?><?php echo ($hearings->CourtID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $hearings->CourtID->cellAttributes() ?>>
<span id="el_hearings_CourtID">
<?php
$wrkonchange = "" . trim(@$hearings->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$hearings->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8770">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($hearings->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($hearings->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($hearings->CourtID->getPlaceHolder()) ?>"<?php echo $hearings->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($hearings->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($hearings->CourtID->ReadOnly || $hearings->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$hearings->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $hearings->CourtID->caption() ?>" data-title="<?php echo $hearings->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="hearings" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $hearings->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($hearings->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fhearingsadd.createAutoSuggest({"id":"x_CourtID","forceSelect":true});
</script>
<?php echo $hearings->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</span>
<?php echo $hearings->CourtID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($hearings_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$hearings_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $hearings_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $hearings_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$hearings_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$hearings_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$hearings_add->terminate();
?>
