<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$files_list = new files_list();

// Run the page
$files_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$files_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$files->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ffileslist = currentForm = new ew.Form("ffileslist", "list");
ffileslist.formKeyCountName = '<?php echo $files_list->FormKeyCountName ?>';

// Form_CustomValidate event
ffileslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ffileslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var ffileslistsrch = currentSearchForm = new ew.Form("ffileslistsrch");

// Filters
ffileslistsrch.filterList = <?php echo $files_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$files->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($files_list->TotalRecs > 0 && $files_list->ExportOptions->visible()) { ?>
<?php $files_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($files_list->ImportOptions->visible()) { ?>
<?php $files_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($files_list->SearchOptions->visible()) { ?>
<?php $files_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($files_list->FilterOptions->visible()) { ?>
<?php $files_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$files_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$files->isExport() && !$files->CurrentAction) { ?>
<form name="ffileslistsrch" id="ffileslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($files_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="ffileslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="files">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($files_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($files_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $files_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($files_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($files_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($files_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($files_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $files_list->showPageHeader(); ?>
<?php
$files_list->showMessage();
?>
<?php if ($files_list->TotalRecs > 0 || $files->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($files_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> files">
<?php if (!$files->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$files->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($files_list->Pager)) $files_list->Pager = new PrevNextPager($files_list->StartRec, $files_list->DisplayRecs, $files_list->TotalRecs, $files_list->AutoHidePager) ?>
<?php if ($files_list->Pager->RecordCount > 0 && $files_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($files_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $files_list->pageUrl() ?>start=<?php echo $files_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($files_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $files_list->pageUrl() ?>start=<?php echo $files_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $files_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($files_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $files_list->pageUrl() ?>start=<?php echo $files_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($files_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $files_list->pageUrl() ?>start=<?php echo $files_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $files_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($files_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $files_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $files_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $files_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($files_list->TotalRecs > 0 && (!$files_list->AutoHidePageSizeSelector || $files_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="files">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($files_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($files_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($files_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($files_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($files_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($files_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($files_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($files_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($files_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($files->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $files_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ffileslist" id="ffileslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($files_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $files_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="files">
<div id="gmp_files" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($files_list->TotalRecs > 0 || $files->isGridEdit()) { ?>
<table id="tbl_fileslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$files_list->RowType = ROWTYPE_HEADER;

// Render list options
$files_list->renderListOptions();

// Render list options (header, left)
$files_list->ListOptions->render("header", "left");
?>
<?php if ($files->FileID->Visible) { // FileID ?>
	<?php if ($files->sortUrl($files->FileID) == "") { ?>
		<th data-name="FileID" class="<?php echo $files->FileID->headerCellClass() ?>"><div id="elh_files_FileID" class="files_FileID"><div class="ew-table-header-caption"><?php echo $files->FileID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FileID" class="<?php echo $files->FileID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $files->SortUrl($files->FileID) ?>',2);"><div id="elh_files_FileID" class="files_FileID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $files->FileID->caption() ?></span><span class="ew-table-header-sort"><?php if ($files->FileID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($files->FileID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($files->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($files->sortUrl($files->CaseNumber) == "") { ?>
		<th data-name="CaseNumber" class="<?php echo $files->CaseNumber->headerCellClass() ?>"><div id="elh_files_CaseNumber" class="files_CaseNumber"><div class="ew-table-header-caption"><?php echo $files->CaseNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseNumber" class="<?php echo $files->CaseNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $files->SortUrl($files->CaseNumber) ?>',2);"><div id="elh_files_CaseNumber" class="files_CaseNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $files->CaseNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($files->CaseNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($files->CaseNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($files->FileNumber->Visible) { // FileNumber ?>
	<?php if ($files->sortUrl($files->FileNumber) == "") { ?>
		<th data-name="FileNumber" class="<?php echo $files->FileNumber->headerCellClass() ?>"><div id="elh_files_FileNumber" class="files_FileNumber"><div class="ew-table-header-caption"><?php echo $files->FileNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FileNumber" class="<?php echo $files->FileNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $files->SortUrl($files->FileNumber) ?>',2);"><div id="elh_files_FileNumber" class="files_FileNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $files->FileNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($files->FileNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($files->FileNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($files->EnvelopeNumber->Visible) { // EnvelopeNumber ?>
	<?php if ($files->sortUrl($files->EnvelopeNumber) == "") { ?>
		<th data-name="EnvelopeNumber" class="<?php echo $files->EnvelopeNumber->headerCellClass() ?>"><div id="elh_files_EnvelopeNumber" class="files_EnvelopeNumber"><div class="ew-table-header-caption"><?php echo $files->EnvelopeNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="EnvelopeNumber" class="<?php echo $files->EnvelopeNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $files->SortUrl($files->EnvelopeNumber) ?>',2);"><div id="elh_files_EnvelopeNumber" class="files_EnvelopeNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $files->EnvelopeNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($files->EnvelopeNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($files->EnvelopeNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($files->FileLocation->Visible) { // FileLocation ?>
	<?php if ($files->sortUrl($files->FileLocation) == "") { ?>
		<th data-name="FileLocation" class="<?php echo $files->FileLocation->headerCellClass() ?>"><div id="elh_files_FileLocation" class="files_FileLocation"><div class="ew-table-header-caption"><?php echo $files->FileLocation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FileLocation" class="<?php echo $files->FileLocation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $files->SortUrl($files->FileLocation) ?>',2);"><div id="elh_files_FileLocation" class="files_FileLocation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $files->FileLocation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($files->FileLocation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($files->FileLocation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($files->_Case->Visible) { // Case ?>
	<?php if ($files->sortUrl($files->_Case) == "") { ?>
		<th data-name="_Case" class="<?php echo $files->_Case->headerCellClass() ?>"><div id="elh_files__Case" class="files__Case"><div class="ew-table-header-caption"><?php echo $files->_Case->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_Case" class="<?php echo $files->_Case->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $files->SortUrl($files->_Case) ?>',2);"><div id="elh_files__Case" class="files__Case">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $files->_Case->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($files->_Case->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($files->_Case->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($files->CaseType->Visible) { // CaseType ?>
	<?php if ($files->sortUrl($files->CaseType) == "") { ?>
		<th data-name="CaseType" class="<?php echo $files->CaseType->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_files_CaseType" class="files_CaseType"><div class="ew-table-header-caption"><?php echo $files->CaseType->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseType" class="<?php echo $files->CaseType->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $files->SortUrl($files->CaseType) ?>',2);"><div id="elh_files_CaseType" class="files_CaseType">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $files->CaseType->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($files->CaseType->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($files->CaseType->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($files->ClientName->Visible) { // ClientName ?>
	<?php if ($files->sortUrl($files->ClientName) == "") { ?>
		<th data-name="ClientName" class="<?php echo $files->ClientName->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_files_ClientName" class="files_ClientName"><div class="ew-table-header-caption"><?php echo $files->ClientName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientName" class="<?php echo $files->ClientName->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $files->SortUrl($files->ClientName) ?>',2);"><div id="elh_files_ClientName" class="files_ClientName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $files->ClientName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($files->ClientName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($files->ClientName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($files->LitigantName->Visible) { // LitigantName ?>
	<?php if ($files->sortUrl($files->LitigantName) == "") { ?>
		<th data-name="LitigantName" class="<?php echo $files->LitigantName->headerCellClass() ?>" style="min-width: 300px;"><div id="elh_files_LitigantName" class="files_LitigantName"><div class="ew-table-header-caption"><?php echo $files->LitigantName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantName" class="<?php echo $files->LitigantName->headerCellClass() ?>" style="min-width: 300px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $files->SortUrl($files->LitigantName) ?>',2);"><div id="elh_files_LitigantName" class="files_LitigantName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $files->LitigantName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($files->LitigantName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($files->LitigantName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($files->CourtName->Visible) { // CourtName ?>
	<?php if ($files->sortUrl($files->CourtName) == "") { ?>
		<th data-name="CourtName" class="<?php echo $files->CourtName->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_files_CourtName" class="files_CourtName"><div class="ew-table-header-caption"><?php echo $files->CourtName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtName" class="<?php echo $files->CourtName->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $files->SortUrl($files->CourtName) ?>',2);"><div id="elh_files_CourtName" class="files_CourtName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $files->CourtName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($files->CourtName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($files->CourtName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($files->JudgeName->Visible) { // JudgeName ?>
	<?php if ($files->sortUrl($files->JudgeName) == "") { ?>
		<th data-name="JudgeName" class="<?php echo $files->JudgeName->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_files_JudgeName" class="files_JudgeName"><div class="ew-table-header-caption"><?php echo $files->JudgeName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JudgeName" class="<?php echo $files->JudgeName->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $files->SortUrl($files->JudgeName) ?>',2);"><div id="elh_files_JudgeName" class="files_JudgeName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $files->JudgeName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($files->JudgeName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($files->JudgeName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$files_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($files->ExportAll && $files->isExport()) {
	$files_list->StopRec = $files_list->TotalRecs;
} else {

	// Set the last record to display
	if ($files_list->TotalRecs > $files_list->StartRec + $files_list->DisplayRecs - 1)
		$files_list->StopRec = $files_list->StartRec + $files_list->DisplayRecs - 1;
	else
		$files_list->StopRec = $files_list->TotalRecs;
}
$files_list->RecCnt = $files_list->StartRec - 1;
if ($files_list->Recordset && !$files_list->Recordset->EOF) {
	$files_list->Recordset->moveFirst();
	$selectLimit = $files_list->UseSelectLimit;
	if (!$selectLimit && $files_list->StartRec > 1)
		$files_list->Recordset->move($files_list->StartRec - 1);
} elseif (!$files->AllowAddDeleteRow && $files_list->StopRec == 0) {
	$files_list->StopRec = $files->GridAddRowCount;
}

// Initialize aggregate
$files->RowType = ROWTYPE_AGGREGATEINIT;
$files->resetAttributes();
$files_list->renderRow();
while ($files_list->RecCnt < $files_list->StopRec) {
	$files_list->RecCnt++;
	if ($files_list->RecCnt >= $files_list->StartRec) {
		$files_list->RowCnt++;

		// Set up key count
		$files_list->KeyCount = $files_list->RowIndex;

		// Init row class and style
		$files->resetAttributes();
		$files->CssClass = "";
		if ($files->isGridAdd()) {
		} else {
			$files_list->loadRowValues($files_list->Recordset); // Load row values
		}
		$files->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$files->RowAttrs = array_merge($files->RowAttrs, array('data-rowindex'=>$files_list->RowCnt, 'id'=>'r' . $files_list->RowCnt . '_files', 'data-rowtype'=>$files->RowType));

		// Render row
		$files_list->renderRow();

		// Render list options
		$files_list->renderListOptions();
?>
	<tr<?php echo $files->rowAttributes() ?>>
<?php

// Render list options (body, left)
$files_list->ListOptions->render("body", "left", $files_list->RowCnt);
?>
	<?php if ($files->FileID->Visible) { // FileID ?>
		<td data-name="FileID"<?php echo $files->FileID->cellAttributes() ?>>
<span id="el<?php echo $files_list->RowCnt ?>_files_FileID" class="files_FileID">
<span<?php echo $files->FileID->viewAttributes() ?>>
<?php echo $files->FileID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($files->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber"<?php echo $files->CaseNumber->cellAttributes() ?>>
<span id="el<?php echo $files_list->RowCnt ?>_files_CaseNumber" class="files_CaseNumber">
<span<?php echo $files->CaseNumber->viewAttributes() ?>>
<?php echo $files->CaseNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($files->FileNumber->Visible) { // FileNumber ?>
		<td data-name="FileNumber"<?php echo $files->FileNumber->cellAttributes() ?>>
<span id="el<?php echo $files_list->RowCnt ?>_files_FileNumber" class="files_FileNumber">
<span<?php echo $files->FileNumber->viewAttributes() ?>>
<?php echo $files->FileNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($files->EnvelopeNumber->Visible) { // EnvelopeNumber ?>
		<td data-name="EnvelopeNumber"<?php echo $files->EnvelopeNumber->cellAttributes() ?>>
<span id="el<?php echo $files_list->RowCnt ?>_files_EnvelopeNumber" class="files_EnvelopeNumber">
<span<?php echo $files->EnvelopeNumber->viewAttributes() ?>>
<?php echo $files->EnvelopeNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($files->FileLocation->Visible) { // FileLocation ?>
		<td data-name="FileLocation"<?php echo $files->FileLocation->cellAttributes() ?>>
<span id="el<?php echo $files_list->RowCnt ?>_files_FileLocation" class="files_FileLocation">
<span<?php echo $files->FileLocation->viewAttributes() ?>>
<?php echo $files->FileLocation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($files->_Case->Visible) { // Case ?>
		<td data-name="_Case"<?php echo $files->_Case->cellAttributes() ?>>
<span id="el<?php echo $files_list->RowCnt ?>_files__Case" class="files__Case">
<span<?php echo $files->_Case->viewAttributes() ?>>
<?php echo $files->_Case->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($files->CaseType->Visible) { // CaseType ?>
		<td data-name="CaseType"<?php echo $files->CaseType->cellAttributes() ?>>
<span id="el<?php echo $files_list->RowCnt ?>_files_CaseType" class="files_CaseType">
<span<?php echo $files->CaseType->viewAttributes() ?>>
<?php echo $files->CaseType->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($files->ClientName->Visible) { // ClientName ?>
		<td data-name="ClientName"<?php echo $files->ClientName->cellAttributes() ?>>
<span id="el<?php echo $files_list->RowCnt ?>_files_ClientName" class="files_ClientName">
<span<?php echo $files->ClientName->viewAttributes() ?>>
<?php echo $files->ClientName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($files->LitigantName->Visible) { // LitigantName ?>
		<td data-name="LitigantName"<?php echo $files->LitigantName->cellAttributes() ?>>
<span id="el<?php echo $files_list->RowCnt ?>_files_LitigantName" class="files_LitigantName">
<span<?php echo $files->LitigantName->viewAttributes() ?>>
<?php echo $files->LitigantName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($files->CourtName->Visible) { // CourtName ?>
		<td data-name="CourtName"<?php echo $files->CourtName->cellAttributes() ?>>
<span id="el<?php echo $files_list->RowCnt ?>_files_CourtName" class="files_CourtName">
<span<?php echo $files->CourtName->viewAttributes() ?>>
<?php echo $files->CourtName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($files->JudgeName->Visible) { // JudgeName ?>
		<td data-name="JudgeName"<?php echo $files->JudgeName->cellAttributes() ?>>
<span id="el<?php echo $files_list->RowCnt ?>_files_JudgeName" class="files_JudgeName">
<span<?php echo $files->JudgeName->viewAttributes() ?>>
<?php echo $files->JudgeName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$files_list->ListOptions->render("body", "right", $files_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$files->isGridAdd())
		$files_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$files->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($files_list->Recordset)
	$files_list->Recordset->Close();
?>
<?php if (!$files->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$files->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($files_list->Pager)) $files_list->Pager = new PrevNextPager($files_list->StartRec, $files_list->DisplayRecs, $files_list->TotalRecs, $files_list->AutoHidePager) ?>
<?php if ($files_list->Pager->RecordCount > 0 && $files_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($files_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $files_list->pageUrl() ?>start=<?php echo $files_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($files_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $files_list->pageUrl() ?>start=<?php echo $files_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $files_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($files_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $files_list->pageUrl() ?>start=<?php echo $files_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($files_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $files_list->pageUrl() ?>start=<?php echo $files_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $files_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($files_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $files_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $files_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $files_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($files_list->TotalRecs > 0 && (!$files_list->AutoHidePageSizeSelector || $files_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="files">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($files_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($files_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($files_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($files_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($files_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($files_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($files_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($files_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($files_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($files->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $files_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($files_list->TotalRecs == 0 && !$files->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $files_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$files_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$files->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$files->isExport()) { ?>
<script>
ew.scrollableTable("gmp_files", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$files_list->terminate();
?>
