<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courtsv_list = new courtsv_list();

// Run the page
$courtsv_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courtsv_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$courtsv->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcourtsvlist = currentForm = new ew.Form("fcourtsvlist", "list");
fcourtsvlist.formKeyCountName = '<?php echo $courtsv_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcourtsvlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtsvlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtsvlist.lists["x_ChambersActivated[]"] = <?php echo $courtsv_list->ChambersActivated->Lookup->toClientList() ?>;
fcourtsvlist.lists["x_ChambersActivated[]"].options = <?php echo JsonEncode($courtsv_list->ChambersActivated->options(FALSE, TRUE)) ?>;
fcourtsvlist.lists["x_SectionsActivated[]"] = <?php echo $courtsv_list->SectionsActivated->Lookup->toClientList() ?>;
fcourtsvlist.lists["x_SectionsActivated[]"].options = <?php echo JsonEncode($courtsv_list->SectionsActivated->options(FALSE, TRUE)) ?>;
fcourtsvlist.lists["x_CourtTypeID"] = <?php echo $courtsv_list->CourtTypeID->Lookup->toClientList() ?>;
fcourtsvlist.lists["x_CourtTypeID"].options = <?php echo JsonEncode($courtsv_list->CourtTypeID->lookupOptions()) ?>;
fcourtsvlist.lists["x_ChamberID"] = <?php echo $courtsv_list->ChamberID->Lookup->toClientList() ?>;
fcourtsvlist.lists["x_ChamberID"].options = <?php echo JsonEncode($courtsv_list->ChamberID->lookupOptions()) ?>;
fcourtsvlist.lists["x_CourtLocationID"] = <?php echo $courtsv_list->CourtLocationID->Lookup->toClientList() ?>;
fcourtsvlist.lists["x_CourtLocationID"].options = <?php echo JsonEncode($courtsv_list->CourtLocationID->lookupOptions()) ?>;
fcourtsvlist.lists["x_GovernorateID"] = <?php echo $courtsv_list->GovernorateID->Lookup->toClientList() ?>;
fcourtsvlist.lists["x_GovernorateID"].options = <?php echo JsonEncode($courtsv_list->GovernorateID->lookupOptions()) ?>;
fcourtsvlist.lists["x_SectionID"] = <?php echo $courtsv_list->SectionID->Lookup->toClientList() ?>;
fcourtsvlist.lists["x_SectionID"].options = <?php echo JsonEncode($courtsv_list->SectionID->lookupOptions()) ?>;
fcourtsvlist.lists["x_Activated[]"] = <?php echo $courtsv_list->Activated->Lookup->toClientList() ?>;
fcourtsvlist.lists["x_Activated[]"].options = <?php echo JsonEncode($courtsv_list->Activated->options(FALSE, TRUE)) ?>;

// Form object for search
var fcourtsvlistsrch = currentSearchForm = new ew.Form("fcourtsvlistsrch");

// Validate function for search
fcourtsvlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fcourtsvlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtsvlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtsvlistsrch.lists["x_ChambersActivated[]"] = <?php echo $courtsv_list->ChambersActivated->Lookup->toClientList() ?>;
fcourtsvlistsrch.lists["x_ChambersActivated[]"].options = <?php echo JsonEncode($courtsv_list->ChambersActivated->options(FALSE, TRUE)) ?>;
fcourtsvlistsrch.lists["x_SectionsActivated[]"] = <?php echo $courtsv_list->SectionsActivated->Lookup->toClientList() ?>;
fcourtsvlistsrch.lists["x_SectionsActivated[]"].options = <?php echo JsonEncode($courtsv_list->SectionsActivated->options(FALSE, TRUE)) ?>;
fcourtsvlistsrch.lists["x_Activated[]"] = <?php echo $courtsv_list->Activated->Lookup->toClientList() ?>;
fcourtsvlistsrch.lists["x_Activated[]"].options = <?php echo JsonEncode($courtsv_list->Activated->options(FALSE, TRUE)) ?>;

// Filters
fcourtsvlistsrch.filterList = <?php echo $courtsv_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FF00FF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$courtsv->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($courtsv_list->TotalRecs > 0 && $courtsv_list->ExportOptions->visible()) { ?>
<?php $courtsv_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($courtsv_list->ImportOptions->visible()) { ?>
<?php $courtsv_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($courtsv_list->SearchOptions->visible()) { ?>
<?php $courtsv_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($courtsv_list->FilterOptions->visible()) { ?>
<?php $courtsv_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$courtsv_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$courtsv->isExport() && !$courtsv->CurrentAction) { ?>
<form name="fcourtsvlistsrch" id="fcourtsvlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($courtsv_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fcourtsvlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="courtsv">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$courtsv_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$courtsv->RowType = ROWTYPE_SEARCH;

// Render row
$courtsv->resetAttributes();
$courtsv_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($courtsv->ChambersActivated->Visible) { // ChambersActivated ?>
	<div id="xsc_ChambersActivated" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $courtsv->ChambersActivated->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ChambersActivated" id="z_ChambersActivated" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($courtsv->ChambersActivated->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="courtsv" data-field="x_ChambersActivated" name="x_ChambersActivated[]" id="x_ChambersActivated[]" value="1"<?php echo $selwrk ?><?php echo $courtsv->ChambersActivated->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($courtsv->SectionsActivated->Visible) { // SectionsActivated ?>
	<div id="xsc_SectionsActivated" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $courtsv->SectionsActivated->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_SectionsActivated" id="z_SectionsActivated" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($courtsv->SectionsActivated->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="courtsv" data-field="x_SectionsActivated" name="x_SectionsActivated[]" id="x_SectionsActivated[]" value="1"<?php echo $selwrk ?><?php echo $courtsv->SectionsActivated->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($courtsv->Activated->Visible) { // Activated ?>
	<div id="xsc_Activated" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $courtsv->Activated->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Activated" id="z_Activated" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($courtsv->Activated->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="courtsv" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $courtsv->Activated->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($courtsv_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($courtsv_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $courtsv_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($courtsv_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($courtsv_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($courtsv_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($courtsv_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $courtsv_list->showPageHeader(); ?>
<?php
$courtsv_list->showMessage();
?>
<?php if ($courtsv_list->TotalRecs > 0 || $courtsv->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($courtsv_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> courtsv">
<?php if (!$courtsv->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$courtsv->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($courtsv_list->Pager)) $courtsv_list->Pager = new PrevNextPager($courtsv_list->StartRec, $courtsv_list->DisplayRecs, $courtsv_list->TotalRecs, $courtsv_list->AutoHidePager) ?>
<?php if ($courtsv_list->Pager->RecordCount > 0 && $courtsv_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($courtsv_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $courtsv_list->pageUrl() ?>start=<?php echo $courtsv_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($courtsv_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $courtsv_list->pageUrl() ?>start=<?php echo $courtsv_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $courtsv_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($courtsv_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $courtsv_list->pageUrl() ?>start=<?php echo $courtsv_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($courtsv_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $courtsv_list->pageUrl() ?>start=<?php echo $courtsv_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $courtsv_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($courtsv_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $courtsv_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $courtsv_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $courtsv_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($courtsv_list->TotalRecs > 0 && (!$courtsv_list->AutoHidePageSizeSelector || $courtsv_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="courtsv">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($courtsv_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($courtsv_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($courtsv_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($courtsv_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($courtsv_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($courtsv_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($courtsv_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($courtsv_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($courtsv_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($courtsv->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $courtsv_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcourtsvlist" id="fcourtsvlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($courtsv_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courtsv_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courtsv">
<div id="gmp_courtsv" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($courtsv_list->TotalRecs > 0 || $courtsv->isGridEdit()) { ?>
<table id="tbl_courtsvlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$courtsv_list->RowType = ROWTYPE_HEADER;

// Render list options
$courtsv_list->renderListOptions();

// Render list options (header, left)
$courtsv_list->ListOptions->render("header", "left");
?>
<?php if ($courtsv->courttypeCourtTypeID->Visible) { // courttypeCourtTypeID ?>
	<?php if ($courtsv->sortUrl($courtsv->courttypeCourtTypeID) == "") { ?>
		<th data-name="courttypeCourtTypeID" class="<?php echo $courtsv->courttypeCourtTypeID->headerCellClass() ?>"><div id="elh_courtsv_courttypeCourtTypeID" class="courtsv_courttypeCourtTypeID"><div class="ew-table-header-caption"><?php echo $courtsv->courttypeCourtTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="courttypeCourtTypeID" class="<?php echo $courtsv->courttypeCourtTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->courttypeCourtTypeID) ?>',2);"><div id="elh_courtsv_courttypeCourtTypeID" class="courtsv_courttypeCourtTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->courttypeCourtTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->courttypeCourtTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->courttypeCourtTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->CourtType->Visible) { // CourtType ?>
	<?php if ($courtsv->sortUrl($courtsv->CourtType) == "") { ?>
		<th data-name="CourtType" class="<?php echo $courtsv->CourtType->headerCellClass() ?>"><div id="elh_courtsv_CourtType" class="courtsv_CourtType"><div class="ew-table-header-caption"><?php echo $courtsv->CourtType->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtType" class="<?php echo $courtsv->CourtType->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->CourtType) ?>',2);"><div id="elh_courtsv_CourtType" class="courtsv_CourtType">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->CourtType->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->CourtType->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->CourtType->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->CourtTypeEn->Visible) { // CourtTypeEn ?>
	<?php if ($courtsv->sortUrl($courtsv->CourtTypeEn) == "") { ?>
		<th data-name="CourtTypeEn" class="<?php echo $courtsv->CourtTypeEn->headerCellClass() ?>"><div id="elh_courtsv_CourtTypeEn" class="courtsv_CourtTypeEn"><div class="ew-table-header-caption"><?php echo $courtsv->CourtTypeEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtTypeEn" class="<?php echo $courtsv->CourtTypeEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->CourtTypeEn) ?>',2);"><div id="elh_courtsv_CourtTypeEn" class="courtsv_CourtTypeEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->CourtTypeEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->CourtTypeEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->CourtTypeEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->CourtTypeNotes->Visible) { // CourtTypeNotes ?>
	<?php if ($courtsv->sortUrl($courtsv->CourtTypeNotes) == "") { ?>
		<th data-name="CourtTypeNotes" class="<?php echo $courtsv->CourtTypeNotes->headerCellClass() ?>"><div id="elh_courtsv_CourtTypeNotes" class="courtsv_CourtTypeNotes"><div class="ew-table-header-caption"><?php echo $courtsv->CourtTypeNotes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtTypeNotes" class="<?php echo $courtsv->CourtTypeNotes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->CourtTypeNotes) ?>',2);"><div id="elh_courtsv_CourtTypeNotes" class="courtsv_CourtTypeNotes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->CourtTypeNotes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->CourtTypeNotes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->CourtTypeNotes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->courtLocationCourtLocationID->Visible) { // courtLocationCourtLocationID ?>
	<?php if ($courtsv->sortUrl($courtsv->courtLocationCourtLocationID) == "") { ?>
		<th data-name="courtLocationCourtLocationID" class="<?php echo $courtsv->courtLocationCourtLocationID->headerCellClass() ?>"><div id="elh_courtsv_courtLocationCourtLocationID" class="courtsv_courtLocationCourtLocationID"><div class="ew-table-header-caption"><?php echo $courtsv->courtLocationCourtLocationID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="courtLocationCourtLocationID" class="<?php echo $courtsv->courtLocationCourtLocationID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->courtLocationCourtLocationID) ?>',2);"><div id="elh_courtsv_courtLocationCourtLocationID" class="courtsv_courtLocationCourtLocationID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->courtLocationCourtLocationID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->courtLocationCourtLocationID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->courtLocationCourtLocationID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->CourtLocation->Visible) { // CourtLocation ?>
	<?php if ($courtsv->sortUrl($courtsv->CourtLocation) == "") { ?>
		<th data-name="CourtLocation" class="<?php echo $courtsv->CourtLocation->headerCellClass() ?>"><div id="elh_courtsv_CourtLocation" class="courtsv_CourtLocation"><div class="ew-table-header-caption"><?php echo $courtsv->CourtLocation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtLocation" class="<?php echo $courtsv->CourtLocation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->CourtLocation) ?>',2);"><div id="elh_courtsv_CourtLocation" class="courtsv_CourtLocation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->CourtLocation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->CourtLocation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->CourtLocation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->CourtLocationEn->Visible) { // CourtLocationEn ?>
	<?php if ($courtsv->sortUrl($courtsv->CourtLocationEn) == "") { ?>
		<th data-name="CourtLocationEn" class="<?php echo $courtsv->CourtLocationEn->headerCellClass() ?>"><div id="elh_courtsv_CourtLocationEn" class="courtsv_CourtLocationEn"><div class="ew-table-header-caption"><?php echo $courtsv->CourtLocationEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtLocationEn" class="<?php echo $courtsv->CourtLocationEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->CourtLocationEn) ?>',2);"><div id="elh_courtsv_CourtLocationEn" class="courtsv_CourtLocationEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->CourtLocationEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->CourtLocationEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->CourtLocationEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->CourtLocationGovernorateID->Visible) { // CourtLocationGovernorateID ?>
	<?php if ($courtsv->sortUrl($courtsv->CourtLocationGovernorateID) == "") { ?>
		<th data-name="CourtLocationGovernorateID" class="<?php echo $courtsv->CourtLocationGovernorateID->headerCellClass() ?>"><div id="elh_courtsv_CourtLocationGovernorateID" class="courtsv_CourtLocationGovernorateID"><div class="ew-table-header-caption"><?php echo $courtsv->CourtLocationGovernorateID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtLocationGovernorateID" class="<?php echo $courtsv->CourtLocationGovernorateID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->CourtLocationGovernorateID) ?>',2);"><div id="elh_courtsv_CourtLocationGovernorateID" class="courtsv_CourtLocationGovernorateID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->CourtLocationGovernorateID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->CourtLocationGovernorateID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->CourtLocationGovernorateID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->CourtLocationNotes->Visible) { // CourtLocationNotes ?>
	<?php if ($courtsv->sortUrl($courtsv->CourtLocationNotes) == "") { ?>
		<th data-name="CourtLocationNotes" class="<?php echo $courtsv->CourtLocationNotes->headerCellClass() ?>"><div id="elh_courtsv_CourtLocationNotes" class="courtsv_CourtLocationNotes"><div class="ew-table-header-caption"><?php echo $courtsv->CourtLocationNotes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtLocationNotes" class="<?php echo $courtsv->CourtLocationNotes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->CourtLocationNotes) ?>',2);"><div id="elh_courtsv_CourtLocationNotes" class="courtsv_CourtLocationNotes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->CourtLocationNotes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->CourtLocationNotes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->CourtLocationNotes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->governoratesGovernorateID->Visible) { // governoratesGovernorateID ?>
	<?php if ($courtsv->sortUrl($courtsv->governoratesGovernorateID) == "") { ?>
		<th data-name="governoratesGovernorateID" class="<?php echo $courtsv->governoratesGovernorateID->headerCellClass() ?>"><div id="elh_courtsv_governoratesGovernorateID" class="courtsv_governoratesGovernorateID"><div class="ew-table-header-caption"><?php echo $courtsv->governoratesGovernorateID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="governoratesGovernorateID" class="<?php echo $courtsv->governoratesGovernorateID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->governoratesGovernorateID) ?>',2);"><div id="elh_courtsv_governoratesGovernorateID" class="courtsv_governoratesGovernorateID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->governoratesGovernorateID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->governoratesGovernorateID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->governoratesGovernorateID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->Governorate->Visible) { // Governorate ?>
	<?php if ($courtsv->sortUrl($courtsv->Governorate) == "") { ?>
		<th data-name="Governorate" class="<?php echo $courtsv->Governorate->headerCellClass() ?>"><div id="elh_courtsv_Governorate" class="courtsv_Governorate"><div class="ew-table-header-caption"><?php echo $courtsv->Governorate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Governorate" class="<?php echo $courtsv->Governorate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->Governorate) ?>',2);"><div id="elh_courtsv_Governorate" class="courtsv_Governorate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->Governorate->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->Governorate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->Governorate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->GovernorateEn->Visible) { // GovernorateEn ?>
	<?php if ($courtsv->sortUrl($courtsv->GovernorateEn) == "") { ?>
		<th data-name="GovernorateEn" class="<?php echo $courtsv->GovernorateEn->headerCellClass() ?>"><div id="elh_courtsv_GovernorateEn" class="courtsv_GovernorateEn"><div class="ew-table-header-caption"><?php echo $courtsv->GovernorateEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="GovernorateEn" class="<?php echo $courtsv->GovernorateEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->GovernorateEn) ?>',2);"><div id="elh_courtsv_GovernorateEn" class="courtsv_GovernorateEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->GovernorateEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->GovernorateEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->GovernorateEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->GovernoratesNotes->Visible) { // GovernoratesNotes ?>
	<?php if ($courtsv->sortUrl($courtsv->GovernoratesNotes) == "") { ?>
		<th data-name="GovernoratesNotes" class="<?php echo $courtsv->GovernoratesNotes->headerCellClass() ?>"><div id="elh_courtsv_GovernoratesNotes" class="courtsv_GovernoratesNotes"><div class="ew-table-header-caption"><?php echo $courtsv->GovernoratesNotes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="GovernoratesNotes" class="<?php echo $courtsv->GovernoratesNotes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->GovernoratesNotes) ?>',2);"><div id="elh_courtsv_GovernoratesNotes" class="courtsv_GovernoratesNotes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->GovernoratesNotes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->GovernoratesNotes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->GovernoratesNotes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->ChambersChamberID->Visible) { // ChambersChamberID ?>
	<?php if ($courtsv->sortUrl($courtsv->ChambersChamberID) == "") { ?>
		<th data-name="ChambersChamberID" class="<?php echo $courtsv->ChambersChamberID->headerCellClass() ?>"><div id="elh_courtsv_ChambersChamberID" class="courtsv_ChambersChamberID"><div class="ew-table-header-caption"><?php echo $courtsv->ChambersChamberID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ChambersChamberID" class="<?php echo $courtsv->ChambersChamberID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->ChambersChamberID) ?>',2);"><div id="elh_courtsv_ChambersChamberID" class="courtsv_ChambersChamberID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->ChambersChamberID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->ChambersChamberID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->ChambersChamberID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->Chamber->Visible) { // Chamber ?>
	<?php if ($courtsv->sortUrl($courtsv->Chamber) == "") { ?>
		<th data-name="Chamber" class="<?php echo $courtsv->Chamber->headerCellClass() ?>"><div id="elh_courtsv_Chamber" class="courtsv_Chamber"><div class="ew-table-header-caption"><?php echo $courtsv->Chamber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Chamber" class="<?php echo $courtsv->Chamber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->Chamber) ?>',2);"><div id="elh_courtsv_Chamber" class="courtsv_Chamber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->Chamber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->Chamber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->Chamber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->ChamberEn->Visible) { // ChamberEn ?>
	<?php if ($courtsv->sortUrl($courtsv->ChamberEn) == "") { ?>
		<th data-name="ChamberEn" class="<?php echo $courtsv->ChamberEn->headerCellClass() ?>"><div id="elh_courtsv_ChamberEn" class="courtsv_ChamberEn"><div class="ew-table-header-caption"><?php echo $courtsv->ChamberEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ChamberEn" class="<?php echo $courtsv->ChamberEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->ChamberEn) ?>',2);"><div id="elh_courtsv_ChamberEn" class="courtsv_ChamberEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->ChamberEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->ChamberEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->ChamberEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->ChambersActivated->Visible) { // ChambersActivated ?>
	<?php if ($courtsv->sortUrl($courtsv->ChambersActivated) == "") { ?>
		<th data-name="ChambersActivated" class="<?php echo $courtsv->ChambersActivated->headerCellClass() ?>"><div id="elh_courtsv_ChambersActivated" class="courtsv_ChambersActivated"><div class="ew-table-header-caption"><?php echo $courtsv->ChambersActivated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ChambersActivated" class="<?php echo $courtsv->ChambersActivated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->ChambersActivated) ?>',2);"><div id="elh_courtsv_ChambersActivated" class="courtsv_ChambersActivated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->ChambersActivated->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->ChambersActivated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->ChambersActivated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->sectionsSectionID->Visible) { // sectionsSectionID ?>
	<?php if ($courtsv->sortUrl($courtsv->sectionsSectionID) == "") { ?>
		<th data-name="sectionsSectionID" class="<?php echo $courtsv->sectionsSectionID->headerCellClass() ?>"><div id="elh_courtsv_sectionsSectionID" class="courtsv_sectionsSectionID"><div class="ew-table-header-caption"><?php echo $courtsv->sectionsSectionID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sectionsSectionID" class="<?php echo $courtsv->sectionsSectionID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->sectionsSectionID) ?>',2);"><div id="elh_courtsv_sectionsSectionID" class="courtsv_sectionsSectionID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->sectionsSectionID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->sectionsSectionID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->sectionsSectionID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->Section->Visible) { // Section ?>
	<?php if ($courtsv->sortUrl($courtsv->Section) == "") { ?>
		<th data-name="Section" class="<?php echo $courtsv->Section->headerCellClass() ?>"><div id="elh_courtsv_Section" class="courtsv_Section"><div class="ew-table-header-caption"><?php echo $courtsv->Section->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Section" class="<?php echo $courtsv->Section->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->Section) ?>',2);"><div id="elh_courtsv_Section" class="courtsv_Section">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->Section->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->Section->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->Section->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->SectionEn->Visible) { // SectionEn ?>
	<?php if ($courtsv->sortUrl($courtsv->SectionEn) == "") { ?>
		<th data-name="SectionEn" class="<?php echo $courtsv->SectionEn->headerCellClass() ?>"><div id="elh_courtsv_SectionEn" class="courtsv_SectionEn"><div class="ew-table-header-caption"><?php echo $courtsv->SectionEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SectionEn" class="<?php echo $courtsv->SectionEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->SectionEn) ?>',2);"><div id="elh_courtsv_SectionEn" class="courtsv_SectionEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->SectionEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->SectionEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->SectionEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->SectionsActivated->Visible) { // SectionsActivated ?>
	<?php if ($courtsv->sortUrl($courtsv->SectionsActivated) == "") { ?>
		<th data-name="SectionsActivated" class="<?php echo $courtsv->SectionsActivated->headerCellClass() ?>"><div id="elh_courtsv_SectionsActivated" class="courtsv_SectionsActivated"><div class="ew-table-header-caption"><?php echo $courtsv->SectionsActivated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SectionsActivated" class="<?php echo $courtsv->SectionsActivated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->SectionsActivated) ?>',2);"><div id="elh_courtsv_SectionsActivated" class="courtsv_SectionsActivated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->SectionsActivated->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->SectionsActivated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->SectionsActivated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->CourtID->Visible) { // CourtID ?>
	<?php if ($courtsv->sortUrl($courtsv->CourtID) == "") { ?>
		<th data-name="CourtID" class="<?php echo $courtsv->CourtID->headerCellClass() ?>"><div id="elh_courtsv_CourtID" class="courtsv_CourtID"><div class="ew-table-header-caption"><?php echo $courtsv->CourtID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtID" class="<?php echo $courtsv->CourtID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->CourtID) ?>',2);"><div id="elh_courtsv_CourtID" class="courtsv_CourtID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->CourtID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->CourtID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->CourtID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->Court->Visible) { // Court ?>
	<?php if ($courtsv->sortUrl($courtsv->Court) == "") { ?>
		<th data-name="Court" class="<?php echo $courtsv->Court->headerCellClass() ?>"><div id="elh_courtsv_Court" class="courtsv_Court"><div class="ew-table-header-caption"><?php echo $courtsv->Court->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Court" class="<?php echo $courtsv->Court->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->Court) ?>',2);"><div id="elh_courtsv_Court" class="courtsv_Court">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->Court->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->Court->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->Court->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->CourtEn->Visible) { // CourtEn ?>
	<?php if ($courtsv->sortUrl($courtsv->CourtEn) == "") { ?>
		<th data-name="CourtEn" class="<?php echo $courtsv->CourtEn->headerCellClass() ?>"><div id="elh_courtsv_CourtEn" class="courtsv_CourtEn"><div class="ew-table-header-caption"><?php echo $courtsv->CourtEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtEn" class="<?php echo $courtsv->CourtEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->CourtEn) ?>',2);"><div id="elh_courtsv_CourtEn" class="courtsv_CourtEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->CourtEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtsv->CourtEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->CourtEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->CourtTypeID->Visible) { // CourtTypeID ?>
	<?php if ($courtsv->sortUrl($courtsv->CourtTypeID) == "") { ?>
		<th data-name="CourtTypeID" class="<?php echo $courtsv->CourtTypeID->headerCellClass() ?>"><div id="elh_courtsv_CourtTypeID" class="courtsv_CourtTypeID"><div class="ew-table-header-caption"><?php echo $courtsv->CourtTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtTypeID" class="<?php echo $courtsv->CourtTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->CourtTypeID) ?>',2);"><div id="elh_courtsv_CourtTypeID" class="courtsv_CourtTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->CourtTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->CourtTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->CourtTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->ChamberID->Visible) { // ChamberID ?>
	<?php if ($courtsv->sortUrl($courtsv->ChamberID) == "") { ?>
		<th data-name="ChamberID" class="<?php echo $courtsv->ChamberID->headerCellClass() ?>"><div id="elh_courtsv_ChamberID" class="courtsv_ChamberID"><div class="ew-table-header-caption"><?php echo $courtsv->ChamberID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ChamberID" class="<?php echo $courtsv->ChamberID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->ChamberID) ?>',2);"><div id="elh_courtsv_ChamberID" class="courtsv_ChamberID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->ChamberID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->ChamberID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->ChamberID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->CourtLocationID->Visible) { // CourtLocationID ?>
	<?php if ($courtsv->sortUrl($courtsv->CourtLocationID) == "") { ?>
		<th data-name="CourtLocationID" class="<?php echo $courtsv->CourtLocationID->headerCellClass() ?>"><div id="elh_courtsv_CourtLocationID" class="courtsv_CourtLocationID"><div class="ew-table-header-caption"><?php echo $courtsv->CourtLocationID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtLocationID" class="<?php echo $courtsv->CourtLocationID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->CourtLocationID) ?>',2);"><div id="elh_courtsv_CourtLocationID" class="courtsv_CourtLocationID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->CourtLocationID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->CourtLocationID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->CourtLocationID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->GovernorateID->Visible) { // GovernorateID ?>
	<?php if ($courtsv->sortUrl($courtsv->GovernorateID) == "") { ?>
		<th data-name="GovernorateID" class="<?php echo $courtsv->GovernorateID->headerCellClass() ?>"><div id="elh_courtsv_GovernorateID" class="courtsv_GovernorateID"><div class="ew-table-header-caption"><?php echo $courtsv->GovernorateID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="GovernorateID" class="<?php echo $courtsv->GovernorateID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->GovernorateID) ?>',2);"><div id="elh_courtsv_GovernorateID" class="courtsv_GovernorateID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->GovernorateID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->GovernorateID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->GovernorateID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->SectionID->Visible) { // SectionID ?>
	<?php if ($courtsv->sortUrl($courtsv->SectionID) == "") { ?>
		<th data-name="SectionID" class="<?php echo $courtsv->SectionID->headerCellClass() ?>"><div id="elh_courtsv_SectionID" class="courtsv_SectionID"><div class="ew-table-header-caption"><?php echo $courtsv->SectionID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SectionID" class="<?php echo $courtsv->SectionID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->SectionID) ?>',2);"><div id="elh_courtsv_SectionID" class="courtsv_SectionID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->SectionID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->SectionID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->SectionID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->AddressID->Visible) { // AddressID ?>
	<?php if ($courtsv->sortUrl($courtsv->AddressID) == "") { ?>
		<th data-name="AddressID" class="<?php echo $courtsv->AddressID->headerCellClass() ?>"><div id="elh_courtsv_AddressID" class="courtsv_AddressID"><div class="ew-table-header-caption"><?php echo $courtsv->AddressID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AddressID" class="<?php echo $courtsv->AddressID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->AddressID) ?>',2);"><div id="elh_courtsv_AddressID" class="courtsv_AddressID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->AddressID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->AddressID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->AddressID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->ContactID->Visible) { // ContactID ?>
	<?php if ($courtsv->sortUrl($courtsv->ContactID) == "") { ?>
		<th data-name="ContactID" class="<?php echo $courtsv->ContactID->headerCellClass() ?>"><div id="elh_courtsv_ContactID" class="courtsv_ContactID"><div class="ew-table-header-caption"><?php echo $courtsv->ContactID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ContactID" class="<?php echo $courtsv->ContactID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->ContactID) ?>',2);"><div id="elh_courtsv_ContactID" class="courtsv_ContactID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->ContactID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->ContactID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->ContactID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtsv->Activated->Visible) { // Activated ?>
	<?php if ($courtsv->sortUrl($courtsv->Activated) == "") { ?>
		<th data-name="Activated" class="<?php echo $courtsv->Activated->headerCellClass() ?>"><div id="elh_courtsv_Activated" class="courtsv_Activated"><div class="ew-table-header-caption"><?php echo $courtsv->Activated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Activated" class="<?php echo $courtsv->Activated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtsv->SortUrl($courtsv->Activated) ?>',2);"><div id="elh_courtsv_Activated" class="courtsv_Activated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtsv->Activated->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtsv->Activated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtsv->Activated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$courtsv_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($courtsv->ExportAll && $courtsv->isExport()) {
	$courtsv_list->StopRec = $courtsv_list->TotalRecs;
} else {

	// Set the last record to display
	if ($courtsv_list->TotalRecs > $courtsv_list->StartRec + $courtsv_list->DisplayRecs - 1)
		$courtsv_list->StopRec = $courtsv_list->StartRec + $courtsv_list->DisplayRecs - 1;
	else
		$courtsv_list->StopRec = $courtsv_list->TotalRecs;
}
$courtsv_list->RecCnt = $courtsv_list->StartRec - 1;
if ($courtsv_list->Recordset && !$courtsv_list->Recordset->EOF) {
	$courtsv_list->Recordset->moveFirst();
	$selectLimit = $courtsv_list->UseSelectLimit;
	if (!$selectLimit && $courtsv_list->StartRec > 1)
		$courtsv_list->Recordset->move($courtsv_list->StartRec - 1);
} elseif (!$courtsv->AllowAddDeleteRow && $courtsv_list->StopRec == 0) {
	$courtsv_list->StopRec = $courtsv->GridAddRowCount;
}

// Initialize aggregate
$courtsv->RowType = ROWTYPE_AGGREGATEINIT;
$courtsv->resetAttributes();
$courtsv_list->renderRow();
while ($courtsv_list->RecCnt < $courtsv_list->StopRec) {
	$courtsv_list->RecCnt++;
	if ($courtsv_list->RecCnt >= $courtsv_list->StartRec) {
		$courtsv_list->RowCnt++;

		// Set up key count
		$courtsv_list->KeyCount = $courtsv_list->RowIndex;

		// Init row class and style
		$courtsv->resetAttributes();
		$courtsv->CssClass = "";
		if ($courtsv->isGridAdd()) {
		} else {
			$courtsv_list->loadRowValues($courtsv_list->Recordset); // Load row values
		}
		$courtsv->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$courtsv->RowAttrs = array_merge($courtsv->RowAttrs, array('data-rowindex'=>$courtsv_list->RowCnt, 'id'=>'r' . $courtsv_list->RowCnt . '_courtsv', 'data-rowtype'=>$courtsv->RowType));

		// Render row
		$courtsv_list->renderRow();

		// Render list options
		$courtsv_list->renderListOptions();
?>
	<tr<?php echo $courtsv->rowAttributes() ?>>
<?php

// Render list options (body, left)
$courtsv_list->ListOptions->render("body", "left", $courtsv_list->RowCnt);
?>
	<?php if ($courtsv->courttypeCourtTypeID->Visible) { // courttypeCourtTypeID ?>
		<td data-name="courttypeCourtTypeID"<?php echo $courtsv->courttypeCourtTypeID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_courttypeCourtTypeID" class="courtsv_courttypeCourtTypeID">
<span<?php echo $courtsv->courttypeCourtTypeID->viewAttributes() ?>>
<?php echo $courtsv->courttypeCourtTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->CourtType->Visible) { // CourtType ?>
		<td data-name="CourtType"<?php echo $courtsv->CourtType->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_CourtType" class="courtsv_CourtType">
<span<?php echo $courtsv->CourtType->viewAttributes() ?>>
<?php echo $courtsv->CourtType->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->CourtTypeEn->Visible) { // CourtTypeEn ?>
		<td data-name="CourtTypeEn"<?php echo $courtsv->CourtTypeEn->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_CourtTypeEn" class="courtsv_CourtTypeEn">
<span<?php echo $courtsv->CourtTypeEn->viewAttributes() ?>>
<?php echo $courtsv->CourtTypeEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->CourtTypeNotes->Visible) { // CourtTypeNotes ?>
		<td data-name="CourtTypeNotes"<?php echo $courtsv->CourtTypeNotes->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_CourtTypeNotes" class="courtsv_CourtTypeNotes">
<span<?php echo $courtsv->CourtTypeNotes->viewAttributes() ?>>
<?php echo $courtsv->CourtTypeNotes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->courtLocationCourtLocationID->Visible) { // courtLocationCourtLocationID ?>
		<td data-name="courtLocationCourtLocationID"<?php echo $courtsv->courtLocationCourtLocationID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_courtLocationCourtLocationID" class="courtsv_courtLocationCourtLocationID">
<span<?php echo $courtsv->courtLocationCourtLocationID->viewAttributes() ?>>
<?php echo $courtsv->courtLocationCourtLocationID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->CourtLocation->Visible) { // CourtLocation ?>
		<td data-name="CourtLocation"<?php echo $courtsv->CourtLocation->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_CourtLocation" class="courtsv_CourtLocation">
<span<?php echo $courtsv->CourtLocation->viewAttributes() ?>>
<?php echo $courtsv->CourtLocation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->CourtLocationEn->Visible) { // CourtLocationEn ?>
		<td data-name="CourtLocationEn"<?php echo $courtsv->CourtLocationEn->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_CourtLocationEn" class="courtsv_CourtLocationEn">
<span<?php echo $courtsv->CourtLocationEn->viewAttributes() ?>>
<?php echo $courtsv->CourtLocationEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->CourtLocationGovernorateID->Visible) { // CourtLocationGovernorateID ?>
		<td data-name="CourtLocationGovernorateID"<?php echo $courtsv->CourtLocationGovernorateID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_CourtLocationGovernorateID" class="courtsv_CourtLocationGovernorateID">
<span<?php echo $courtsv->CourtLocationGovernorateID->viewAttributes() ?>>
<?php echo $courtsv->CourtLocationGovernorateID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->CourtLocationNotes->Visible) { // CourtLocationNotes ?>
		<td data-name="CourtLocationNotes"<?php echo $courtsv->CourtLocationNotes->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_CourtLocationNotes" class="courtsv_CourtLocationNotes">
<span<?php echo $courtsv->CourtLocationNotes->viewAttributes() ?>>
<?php echo $courtsv->CourtLocationNotes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->governoratesGovernorateID->Visible) { // governoratesGovernorateID ?>
		<td data-name="governoratesGovernorateID"<?php echo $courtsv->governoratesGovernorateID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_governoratesGovernorateID" class="courtsv_governoratesGovernorateID">
<span<?php echo $courtsv->governoratesGovernorateID->viewAttributes() ?>>
<?php echo $courtsv->governoratesGovernorateID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->Governorate->Visible) { // Governorate ?>
		<td data-name="Governorate"<?php echo $courtsv->Governorate->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_Governorate" class="courtsv_Governorate">
<span<?php echo $courtsv->Governorate->viewAttributes() ?>>
<?php echo $courtsv->Governorate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->GovernorateEn->Visible) { // GovernorateEn ?>
		<td data-name="GovernorateEn"<?php echo $courtsv->GovernorateEn->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_GovernorateEn" class="courtsv_GovernorateEn">
<span<?php echo $courtsv->GovernorateEn->viewAttributes() ?>>
<?php echo $courtsv->GovernorateEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->GovernoratesNotes->Visible) { // GovernoratesNotes ?>
		<td data-name="GovernoratesNotes"<?php echo $courtsv->GovernoratesNotes->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_GovernoratesNotes" class="courtsv_GovernoratesNotes">
<span<?php echo $courtsv->GovernoratesNotes->viewAttributes() ?>>
<?php echo $courtsv->GovernoratesNotes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->ChambersChamberID->Visible) { // ChambersChamberID ?>
		<td data-name="ChambersChamberID"<?php echo $courtsv->ChambersChamberID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_ChambersChamberID" class="courtsv_ChambersChamberID">
<span<?php echo $courtsv->ChambersChamberID->viewAttributes() ?>>
<?php echo $courtsv->ChambersChamberID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->Chamber->Visible) { // Chamber ?>
		<td data-name="Chamber"<?php echo $courtsv->Chamber->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_Chamber" class="courtsv_Chamber">
<span<?php echo $courtsv->Chamber->viewAttributes() ?>>
<?php echo $courtsv->Chamber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->ChamberEn->Visible) { // ChamberEn ?>
		<td data-name="ChamberEn"<?php echo $courtsv->ChamberEn->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_ChamberEn" class="courtsv_ChamberEn">
<span<?php echo $courtsv->ChamberEn->viewAttributes() ?>>
<?php echo $courtsv->ChamberEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->ChambersActivated->Visible) { // ChambersActivated ?>
		<td data-name="ChambersActivated"<?php echo $courtsv->ChambersActivated->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_ChambersActivated" class="courtsv_ChambersActivated">
<span<?php echo $courtsv->ChambersActivated->viewAttributes() ?>>
<?php if (ConvertToBool($courtsv->ChambersActivated->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $courtsv->ChambersActivated->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $courtsv->ChambersActivated->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->sectionsSectionID->Visible) { // sectionsSectionID ?>
		<td data-name="sectionsSectionID"<?php echo $courtsv->sectionsSectionID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_sectionsSectionID" class="courtsv_sectionsSectionID">
<span<?php echo $courtsv->sectionsSectionID->viewAttributes() ?>>
<?php echo $courtsv->sectionsSectionID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->Section->Visible) { // Section ?>
		<td data-name="Section"<?php echo $courtsv->Section->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_Section" class="courtsv_Section">
<span<?php echo $courtsv->Section->viewAttributes() ?>>
<?php echo $courtsv->Section->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->SectionEn->Visible) { // SectionEn ?>
		<td data-name="SectionEn"<?php echo $courtsv->SectionEn->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_SectionEn" class="courtsv_SectionEn">
<span<?php echo $courtsv->SectionEn->viewAttributes() ?>>
<?php echo $courtsv->SectionEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->SectionsActivated->Visible) { // SectionsActivated ?>
		<td data-name="SectionsActivated"<?php echo $courtsv->SectionsActivated->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_SectionsActivated" class="courtsv_SectionsActivated">
<span<?php echo $courtsv->SectionsActivated->viewAttributes() ?>>
<?php if (ConvertToBool($courtsv->SectionsActivated->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $courtsv->SectionsActivated->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $courtsv->SectionsActivated->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID"<?php echo $courtsv->CourtID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_CourtID" class="courtsv_CourtID">
<span<?php echo $courtsv->CourtID->viewAttributes() ?>>
<?php echo $courtsv->CourtID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->Court->Visible) { // Court ?>
		<td data-name="Court"<?php echo $courtsv->Court->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_Court" class="courtsv_Court">
<span<?php echo $courtsv->Court->viewAttributes() ?>>
<?php echo $courtsv->Court->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->CourtEn->Visible) { // CourtEn ?>
		<td data-name="CourtEn"<?php echo $courtsv->CourtEn->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_CourtEn" class="courtsv_CourtEn">
<span<?php echo $courtsv->CourtEn->viewAttributes() ?>>
<?php echo $courtsv->CourtEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->CourtTypeID->Visible) { // CourtTypeID ?>
		<td data-name="CourtTypeID"<?php echo $courtsv->CourtTypeID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_CourtTypeID" class="courtsv_CourtTypeID">
<span<?php echo $courtsv->CourtTypeID->viewAttributes() ?>>
<?php echo $courtsv->CourtTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->ChamberID->Visible) { // ChamberID ?>
		<td data-name="ChamberID"<?php echo $courtsv->ChamberID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_ChamberID" class="courtsv_ChamberID">
<span<?php echo $courtsv->ChamberID->viewAttributes() ?>>
<?php echo $courtsv->ChamberID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->CourtLocationID->Visible) { // CourtLocationID ?>
		<td data-name="CourtLocationID"<?php echo $courtsv->CourtLocationID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_CourtLocationID" class="courtsv_CourtLocationID">
<span<?php echo $courtsv->CourtLocationID->viewAttributes() ?>>
<?php echo $courtsv->CourtLocationID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->GovernorateID->Visible) { // GovernorateID ?>
		<td data-name="GovernorateID"<?php echo $courtsv->GovernorateID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_GovernorateID" class="courtsv_GovernorateID">
<span<?php echo $courtsv->GovernorateID->viewAttributes() ?>>
<?php echo $courtsv->GovernorateID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->SectionID->Visible) { // SectionID ?>
		<td data-name="SectionID"<?php echo $courtsv->SectionID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_SectionID" class="courtsv_SectionID">
<span<?php echo $courtsv->SectionID->viewAttributes() ?>>
<?php echo $courtsv->SectionID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->AddressID->Visible) { // AddressID ?>
		<td data-name="AddressID"<?php echo $courtsv->AddressID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_AddressID" class="courtsv_AddressID">
<span<?php echo $courtsv->AddressID->viewAttributes() ?>>
<?php echo $courtsv->AddressID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->ContactID->Visible) { // ContactID ?>
		<td data-name="ContactID"<?php echo $courtsv->ContactID->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_ContactID" class="courtsv_ContactID">
<span<?php echo $courtsv->ContactID->viewAttributes() ?>>
<?php echo $courtsv->ContactID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtsv->Activated->Visible) { // Activated ?>
		<td data-name="Activated"<?php echo $courtsv->Activated->cellAttributes() ?>>
<span id="el<?php echo $courtsv_list->RowCnt ?>_courtsv_Activated" class="courtsv_Activated">
<span<?php echo $courtsv->Activated->viewAttributes() ?>>
<?php if (ConvertToBool($courtsv->Activated->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $courtsv->Activated->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $courtsv->Activated->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$courtsv_list->ListOptions->render("body", "right", $courtsv_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$courtsv->isGridAdd())
		$courtsv_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$courtsv->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($courtsv_list->Recordset)
	$courtsv_list->Recordset->Close();
?>
<?php if (!$courtsv->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$courtsv->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($courtsv_list->Pager)) $courtsv_list->Pager = new PrevNextPager($courtsv_list->StartRec, $courtsv_list->DisplayRecs, $courtsv_list->TotalRecs, $courtsv_list->AutoHidePager) ?>
<?php if ($courtsv_list->Pager->RecordCount > 0 && $courtsv_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($courtsv_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $courtsv_list->pageUrl() ?>start=<?php echo $courtsv_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($courtsv_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $courtsv_list->pageUrl() ?>start=<?php echo $courtsv_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $courtsv_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($courtsv_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $courtsv_list->pageUrl() ?>start=<?php echo $courtsv_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($courtsv_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $courtsv_list->pageUrl() ?>start=<?php echo $courtsv_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $courtsv_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($courtsv_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $courtsv_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $courtsv_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $courtsv_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($courtsv_list->TotalRecs > 0 && (!$courtsv_list->AutoHidePageSizeSelector || $courtsv_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="courtsv">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($courtsv_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($courtsv_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($courtsv_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($courtsv_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($courtsv_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($courtsv_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($courtsv_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($courtsv_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($courtsv_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($courtsv->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $courtsv_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($courtsv_list->TotalRecs == 0 && !$courtsv->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $courtsv_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$courtsv_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$courtsv->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$courtsv->isExport()) { ?>
<script>
ew.scrollableTable("gmp_courtsv", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$courtsv_list->terminate();
?>
