<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courts_view = new courts_view();

// Run the page
$courts_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courts_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$courts->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcourtsview = currentForm = new ew.Form("fcourtsview", "view");

// Form_CustomValidate event
fcourtsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtsview.lists["x_CourtTypeID"] = <?php echo $courts_view->CourtTypeID->Lookup->toClientList() ?>;
fcourtsview.lists["x_CourtTypeID"].options = <?php echo JsonEncode($courts_view->CourtTypeID->lookupOptions()) ?>;
fcourtsview.lists["x_ChamberID"] = <?php echo $courts_view->ChamberID->Lookup->toClientList() ?>;
fcourtsview.lists["x_ChamberID"].options = <?php echo JsonEncode($courts_view->ChamberID->lookupOptions()) ?>;
fcourtsview.lists["x_CourtLocationID"] = <?php echo $courts_view->CourtLocationID->Lookup->toClientList() ?>;
fcourtsview.lists["x_CourtLocationID"].options = <?php echo JsonEncode($courts_view->CourtLocationID->lookupOptions()) ?>;
fcourtsview.lists["x_GovernorateID"] = <?php echo $courts_view->GovernorateID->Lookup->toClientList() ?>;
fcourtsview.lists["x_GovernorateID"].options = <?php echo JsonEncode($courts_view->GovernorateID->lookupOptions()) ?>;
fcourtsview.lists["x_SectionID"] = <?php echo $courts_view->SectionID->Lookup->toClientList() ?>;
fcourtsview.lists["x_SectionID"].options = <?php echo JsonEncode($courts_view->SectionID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$courts->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $courts_view->ExportOptions->render("body") ?>
<?php $courts_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $courts_view->showPageHeader(); ?>
<?php
$courts_view->showMessage();
?>
<?php if (!$courts_view->IsModal) { ?>
<?php if (!$courts->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($courts_view->Pager)) $courts_view->Pager = new PrevNextPager($courts_view->StartRec, $courts_view->DisplayRecs, $courts_view->TotalRecs, $courts_view->AutoHidePager) ?>
<?php if ($courts_view->Pager->RecordCount > 0 && $courts_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($courts_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $courts_view->pageUrl() ?>start=<?php echo $courts_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($courts_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $courts_view->pageUrl() ?>start=<?php echo $courts_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $courts_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($courts_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $courts_view->pageUrl() ?>start=<?php echo $courts_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($courts_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $courts_view->pageUrl() ?>start=<?php echo $courts_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $courts_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fcourtsview" id="fcourtsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($courts_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courts_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courts">
<input type="hidden" name="modal" value="<?php echo (int)$courts_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($courts->CourtID->Visible) { // CourtID ?>
	<tr id="r_CourtID">
		<td class="<?php echo $courts_view->TableLeftColumnClass ?>"><span id="elh_courts_CourtID"><?php echo $courts->CourtID->caption() ?></span></td>
		<td data-name="CourtID"<?php echo $courts->CourtID->cellAttributes() ?>>
<span id="el_courts_CourtID">
<span<?php echo $courts->CourtID->viewAttributes() ?>>
<?php echo $courts->CourtID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courts->Court->Visible) { // Court ?>
	<tr id="r_Court">
		<td class="<?php echo $courts_view->TableLeftColumnClass ?>"><span id="elh_courts_Court"><?php echo $courts->Court->caption() ?></span></td>
		<td data-name="Court"<?php echo $courts->Court->cellAttributes() ?>>
<span id="el_courts_Court">
<span<?php echo $courts->Court->viewAttributes() ?>>
<?php echo $courts->Court->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courts->CourtTypeID->Visible) { // CourtTypeID ?>
	<tr id="r_CourtTypeID">
		<td class="<?php echo $courts_view->TableLeftColumnClass ?>"><span id="elh_courts_CourtTypeID"><?php echo $courts->CourtTypeID->caption() ?></span></td>
		<td data-name="CourtTypeID"<?php echo $courts->CourtTypeID->cellAttributes() ?>>
<span id="el_courts_CourtTypeID">
<span<?php echo $courts->CourtTypeID->viewAttributes() ?>>
<?php echo $courts->CourtTypeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courts->ChamberID->Visible) { // ChamberID ?>
	<tr id="r_ChamberID">
		<td class="<?php echo $courts_view->TableLeftColumnClass ?>"><span id="elh_courts_ChamberID"><?php echo $courts->ChamberID->caption() ?></span></td>
		<td data-name="ChamberID"<?php echo $courts->ChamberID->cellAttributes() ?>>
<span id="el_courts_ChamberID">
<span<?php echo $courts->ChamberID->viewAttributes() ?>>
<?php echo $courts->ChamberID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courts->CourtLocationID->Visible) { // CourtLocationID ?>
	<tr id="r_CourtLocationID">
		<td class="<?php echo $courts_view->TableLeftColumnClass ?>"><span id="elh_courts_CourtLocationID"><?php echo $courts->CourtLocationID->caption() ?></span></td>
		<td data-name="CourtLocationID"<?php echo $courts->CourtLocationID->cellAttributes() ?>>
<span id="el_courts_CourtLocationID">
<span<?php echo $courts->CourtLocationID->viewAttributes() ?>>
<?php echo $courts->CourtLocationID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courts->GovernorateID->Visible) { // GovernorateID ?>
	<tr id="r_GovernorateID">
		<td class="<?php echo $courts_view->TableLeftColumnClass ?>"><span id="elh_courts_GovernorateID"><?php echo $courts->GovernorateID->caption() ?></span></td>
		<td data-name="GovernorateID"<?php echo $courts->GovernorateID->cellAttributes() ?>>
<span id="el_courts_GovernorateID">
<span<?php echo $courts->GovernorateID->viewAttributes() ?>>
<?php echo $courts->GovernorateID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courts->SectionID->Visible) { // SectionID ?>
	<tr id="r_SectionID">
		<td class="<?php echo $courts_view->TableLeftColumnClass ?>"><span id="elh_courts_SectionID"><?php echo $courts->SectionID->caption() ?></span></td>
		<td data-name="SectionID"<?php echo $courts->SectionID->cellAttributes() ?>>
<span id="el_courts_SectionID">
<span<?php echo $courts->SectionID->viewAttributes() ?>>
<?php echo $courts->SectionID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courts->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $courts_view->TableLeftColumnClass ?>"><span id="elh_courts_Notes"><?php echo $courts->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $courts->Notes->cellAttributes() ?>>
<span id="el_courts_Notes">
<span<?php echo $courts->Notes->viewAttributes() ?>>
<?php echo $courts->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$courts_view->IsModal) { ?>
<?php if (!$courts->isExport()) { ?>
<?php if (!isset($courts_view->Pager)) $courts_view->Pager = new PrevNextPager($courts_view->StartRec, $courts_view->DisplayRecs, $courts_view->TotalRecs, $courts_view->AutoHidePager) ?>
<?php if ($courts_view->Pager->RecordCount > 0 && $courts_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($courts_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $courts_view->pageUrl() ?>start=<?php echo $courts_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($courts_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $courts_view->pageUrl() ?>start=<?php echo $courts_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $courts_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($courts_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $courts_view->pageUrl() ?>start=<?php echo $courts_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($courts_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $courts_view->pageUrl() ?>start=<?php echo $courts_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $courts_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
<?php if ($courts->getCurrentDetailTable() <> "") { ?>
<?php
	$courts_view->DetailPages->ValidKeys = explode(",", $courts->getCurrentDetailTable());
	$firstActiveDetailTable = $courts_view->DetailPages->activePageIndex();
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav-tabs" id="courts_view_details"><!-- tabs -->
	<ul class="<?php echo $courts_view->DetailPages->navStyle() ?>"><!-- .nav -->
<?php
	if (in_array("courtaddress", explode(",", $courts->getCurrentDetailTable())) && $courtaddress->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "courtaddress") {
			$firstActiveDetailTable = "courtaddress";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $courts_view->DetailPages->pageStyle("courtaddress") ?>" href="#tab_courtaddress" data-toggle="tab"><?php echo $Language->TablePhrase("courtaddress", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $courts_view->courtaddress_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("courtcontact", explode(",", $courts->getCurrentDetailTable())) && $courtcontact->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "courtcontact") {
			$firstActiveDetailTable = "courtcontact";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $courts_view->DetailPages->pageStyle("courtcontact") ?>" href="#tab_courtcontact" data-toggle="tab"><?php echo $Language->TablePhrase("courtcontact", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $courts_view->courtcontact_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
	</ul><!-- /.nav -->
	<div class="tab-content"><!-- .tab-content -->
<?php
	if (in_array("courtaddress", explode(",", $courts->getCurrentDetailTable())) && $courtaddress->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "courtaddress")
			$firstActiveDetailTable = "courtaddress";
?>
		<div class="tab-pane<?php echo $courts_view->DetailPages->pageStyle("courtaddress") ?>" id="tab_courtaddress"><!-- page* -->
<?php include_once "courtaddressgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("courtcontact", explode(",", $courts->getCurrentDetailTable())) && $courtcontact->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "courtcontact")
			$firstActiveDetailTable = "courtcontact";
?>
		<div class="tab-pane<?php echo $courts_view->DetailPages->pageStyle("courtcontact") ?>" id="tab_courtcontact"><!-- page* -->
<?php include_once "courtcontactgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
	</div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
</form>
<?php
$courts_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$courts->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$courts_view->terminate();
?>
