<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courts_addopt = new courts_addopt();

// Run the page
$courts_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courts_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fcourtsaddopt = currentForm = new ew.Form("fcourtsaddopt", "addopt");

// Validate form
fcourtsaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($courts_addopt->Court->Required) { ?>
			elm = this.getElements("x" + infix + "_Court");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->Court->caption(), $courts->Court->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_addopt->CourtTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->CourtTypeID->caption(), $courts->CourtTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_addopt->ChamberID->Required) { ?>
			elm = this.getElements("x" + infix + "_ChamberID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->ChamberID->caption(), $courts->ChamberID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_addopt->CourtLocationID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtLocationID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->CourtLocationID->caption(), $courts->CourtLocationID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_addopt->GovernorateID->Required) { ?>
			elm = this.getElements("x" + infix + "_GovernorateID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->GovernorateID->caption(), $courts->GovernorateID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_addopt->SectionID->Required) { ?>
			elm = this.getElements("x" + infix + "_SectionID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->SectionID->caption(), $courts->SectionID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courts_addopt->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courts->Notes->caption(), $courts->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcourtsaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtsaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtsaddopt.lists["x_CourtTypeID"] = <?php echo $courts_addopt->CourtTypeID->Lookup->toClientList() ?>;
fcourtsaddopt.lists["x_CourtTypeID"].options = <?php echo JsonEncode($courts_addopt->CourtTypeID->lookupOptions()) ?>;
fcourtsaddopt.lists["x_ChamberID"] = <?php echo $courts_addopt->ChamberID->Lookup->toClientList() ?>;
fcourtsaddopt.lists["x_ChamberID"].options = <?php echo JsonEncode($courts_addopt->ChamberID->lookupOptions()) ?>;
fcourtsaddopt.lists["x_CourtLocationID"] = <?php echo $courts_addopt->CourtLocationID->Lookup->toClientList() ?>;
fcourtsaddopt.lists["x_CourtLocationID"].options = <?php echo JsonEncode($courts_addopt->CourtLocationID->lookupOptions()) ?>;
fcourtsaddopt.lists["x_GovernorateID"] = <?php echo $courts_addopt->GovernorateID->Lookup->toClientList() ?>;
fcourtsaddopt.lists["x_GovernorateID"].options = <?php echo JsonEncode($courts_addopt->GovernorateID->lookupOptions()) ?>;
fcourtsaddopt.lists["x_SectionID"] = <?php echo $courts_addopt->SectionID->Lookup->toClientList() ?>;
fcourtsaddopt.lists["x_SectionID"].options = <?php echo JsonEncode($courts_addopt->SectionID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $courts_addopt->showPageHeader(); ?>
<?php
$courts_addopt->showMessage();
?>
<form name="fcourtsaddopt" id="fcourtsaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($courts_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courts_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $courts_addopt->TableVar ?>">
<?php if ($courts->Court->Visible) { // Court ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Court"><?php echo $courts->Court->caption() ?><?php echo ($courts->Court->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="courts" data-field="x_Court" name="x_Court" id="x_Court" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courts->Court->getPlaceHolder()) ?>" value="<?php echo $courts->Court->EditValue ?>"<?php echo $courts->Court->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($courts->CourtTypeID->Visible) { // CourtTypeID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_CourtTypeID"><?php echo $courts->CourtTypeID->caption() ?><?php echo ($courts->CourtTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_CourtTypeID" data-value-separator="<?php echo $courts->CourtTypeID->displayValueSeparatorAttribute() ?>" id="x_CourtTypeID" name="x_CourtTypeID"<?php echo $courts->CourtTypeID->editAttributes() ?>>
		<?php echo $courts->CourtTypeID->selectOptionListHtml("x_CourtTypeID") ?>
	</select>
</div>
<?php echo $courts->CourtTypeID->Lookup->getParamTag("p_x_CourtTypeID") ?>
</div>
	</div>
<?php } ?>
<?php if ($courts->ChamberID->Visible) { // ChamberID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_ChamberID"><?php echo $courts->ChamberID->caption() ?><?php echo ($courts->ChamberID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_ChamberID" data-value-separator="<?php echo $courts->ChamberID->displayValueSeparatorAttribute() ?>" id="x_ChamberID" name="x_ChamberID"<?php echo $courts->ChamberID->editAttributes() ?>>
		<?php echo $courts->ChamberID->selectOptionListHtml("x_ChamberID") ?>
	</select>
</div>
<?php echo $courts->ChamberID->Lookup->getParamTag("p_x_ChamberID") ?>
</div>
	</div>
<?php } ?>
<?php if ($courts->CourtLocationID->Visible) { // CourtLocationID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_CourtLocationID"><?php echo $courts->CourtLocationID->caption() ?><?php echo ($courts->CourtLocationID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_CourtLocationID" data-value-separator="<?php echo $courts->CourtLocationID->displayValueSeparatorAttribute() ?>" id="x_CourtLocationID" name="x_CourtLocationID"<?php echo $courts->CourtLocationID->editAttributes() ?>>
		<?php echo $courts->CourtLocationID->selectOptionListHtml("x_CourtLocationID") ?>
	</select>
</div>
<?php echo $courts->CourtLocationID->Lookup->getParamTag("p_x_CourtLocationID") ?>
</div>
	</div>
<?php } ?>
<?php if ($courts->GovernorateID->Visible) { // GovernorateID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_GovernorateID"><?php echo $courts->GovernorateID->caption() ?><?php echo ($courts->GovernorateID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_GovernorateID" data-value-separator="<?php echo $courts->GovernorateID->displayValueSeparatorAttribute() ?>" id="x_GovernorateID" name="x_GovernorateID"<?php echo $courts->GovernorateID->editAttributes() ?>>
		<?php echo $courts->GovernorateID->selectOptionListHtml("x_GovernorateID") ?>
	</select>
</div>
<?php echo $courts->GovernorateID->Lookup->getParamTag("p_x_GovernorateID") ?>
</div>
	</div>
<?php } ?>
<?php if ($courts->SectionID->Visible) { // SectionID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_SectionID"><?php echo $courts->SectionID->caption() ?><?php echo ($courts->SectionID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_SectionID" data-value-separator="<?php echo $courts->SectionID->displayValueSeparatorAttribute() ?>" id="x_SectionID" name="x_SectionID"<?php echo $courts->SectionID->editAttributes() ?>>
		<?php echo $courts->SectionID->selectOptionListHtml("x_SectionID") ?>
	</select>
</div>
<?php echo $courts->SectionID->Lookup->getParamTag("p_x_SectionID") ?>
</div>
	</div>
<?php } ?>
<?php if ($courts->Notes->Visible) { // Notes ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Notes"><?php echo $courts->Notes->caption() ?><?php echo ($courts->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="courts" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($courts->Notes->getPlaceHolder()) ?>"<?php echo $courts->Notes->editAttributes() ?>><?php echo $courts->Notes->EditValue ?></textarea>
</div>
	</div>
<?php } ?>
</form>
<?php
$courts_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$courts_addopt->terminate();
?>
