<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courtcontact_view = new courtcontact_view();

// Run the page
$courtcontact_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courtcontact_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$courtcontact->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcourtcontactview = currentForm = new ew.Form("fcourtcontactview", "view");

// Form_CustomValidate event
fcourtcontactview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtcontactview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtcontactview.lists["x_CourtID"] = <?php echo $courtcontact_view->CourtID->Lookup->toClientList() ?>;
fcourtcontactview.lists["x_CourtID"].options = <?php echo JsonEncode($courtcontact_view->CourtID->lookupOptions()) ?>;
fcourtcontactview.lists["x_ContactTypeID"] = <?php echo $courtcontact_view->ContactTypeID->Lookup->toClientList() ?>;
fcourtcontactview.lists["x_ContactTypeID"].options = <?php echo JsonEncode($courtcontact_view->ContactTypeID->lookupOptions()) ?>;
fcourtcontactview.lists["x_Primary[]"] = <?php echo $courtcontact_view->Primary->Lookup->toClientList() ?>;
fcourtcontactview.lists["x_Primary[]"].options = <?php echo JsonEncode($courtcontact_view->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$courtcontact->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $courtcontact_view->ExportOptions->render("body") ?>
<?php $courtcontact_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $courtcontact_view->showPageHeader(); ?>
<?php
$courtcontact_view->showMessage();
?>
<?php if (!$courtcontact_view->IsModal) { ?>
<?php if (!$courtcontact->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($courtcontact_view->Pager)) $courtcontact_view->Pager = new PrevNextPager($courtcontact_view->StartRec, $courtcontact_view->DisplayRecs, $courtcontact_view->TotalRecs, $courtcontact_view->AutoHidePager) ?>
<?php if ($courtcontact_view->Pager->RecordCount > 0 && $courtcontact_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($courtcontact_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $courtcontact_view->pageUrl() ?>start=<?php echo $courtcontact_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($courtcontact_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $courtcontact_view->pageUrl() ?>start=<?php echo $courtcontact_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $courtcontact_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($courtcontact_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $courtcontact_view->pageUrl() ?>start=<?php echo $courtcontact_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($courtcontact_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $courtcontact_view->pageUrl() ?>start=<?php echo $courtcontact_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $courtcontact_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fcourtcontactview" id="fcourtcontactview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($courtcontact_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courtcontact_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courtcontact">
<input type="hidden" name="modal" value="<?php echo (int)$courtcontact_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($courtcontact->CourtID->Visible) { // CourtID ?>
	<tr id="r_CourtID">
		<td class="<?php echo $courtcontact_view->TableLeftColumnClass ?>"><span id="elh_courtcontact_CourtID"><?php echo $courtcontact->CourtID->caption() ?></span></td>
		<td data-name="CourtID"<?php echo $courtcontact->CourtID->cellAttributes() ?>>
<span id="el_courtcontact_CourtID">
<span<?php echo $courtcontact->CourtID->viewAttributes() ?>>
<?php echo $courtcontact->CourtID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courtcontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<tr id="r_ContactTypeID">
		<td class="<?php echo $courtcontact_view->TableLeftColumnClass ?>"><span id="elh_courtcontact_ContactTypeID"><?php echo $courtcontact->ContactTypeID->caption() ?></span></td>
		<td data-name="ContactTypeID"<?php echo $courtcontact->ContactTypeID->cellAttributes() ?>>
<span id="el_courtcontact_ContactTypeID">
<span<?php echo $courtcontact->ContactTypeID->viewAttributes() ?>>
<?php echo $courtcontact->ContactTypeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courtcontact->Contact->Visible) { // Contact ?>
	<tr id="r_Contact">
		<td class="<?php echo $courtcontact_view->TableLeftColumnClass ?>"><span id="elh_courtcontact_Contact"><?php echo $courtcontact->Contact->caption() ?></span></td>
		<td data-name="Contact"<?php echo $courtcontact->Contact->cellAttributes() ?>>
<span id="el_courtcontact_Contact">
<span<?php echo $courtcontact->Contact->viewAttributes() ?>>
<?php echo $courtcontact->Contact->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courtcontact->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $courtcontact_view->TableLeftColumnClass ?>"><span id="elh_courtcontact_Notes"><?php echo $courtcontact->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $courtcontact->Notes->cellAttributes() ?>>
<span id="el_courtcontact_Notes">
<span<?php echo $courtcontact->Notes->viewAttributes() ?>>
<?php echo $courtcontact->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($courtcontact->Primary->Visible) { // Primary ?>
	<tr id="r_Primary">
		<td class="<?php echo $courtcontact_view->TableLeftColumnClass ?>"><span id="elh_courtcontact_Primary"><?php echo $courtcontact->Primary->caption() ?></span></td>
		<td data-name="Primary"<?php echo $courtcontact->Primary->cellAttributes() ?>>
<span id="el_courtcontact_Primary">
<span<?php echo $courtcontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($courtcontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $courtcontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $courtcontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$courtcontact_view->IsModal) { ?>
<?php if (!$courtcontact->isExport()) { ?>
<?php if (!isset($courtcontact_view->Pager)) $courtcontact_view->Pager = new PrevNextPager($courtcontact_view->StartRec, $courtcontact_view->DisplayRecs, $courtcontact_view->TotalRecs, $courtcontact_view->AutoHidePager) ?>
<?php if ($courtcontact_view->Pager->RecordCount > 0 && $courtcontact_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($courtcontact_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $courtcontact_view->pageUrl() ?>start=<?php echo $courtcontact_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($courtcontact_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $courtcontact_view->pageUrl() ?>start=<?php echo $courtcontact_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $courtcontact_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($courtcontact_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $courtcontact_view->pageUrl() ?>start=<?php echo $courtcontact_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($courtcontact_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $courtcontact_view->pageUrl() ?>start=<?php echo $courtcontact_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $courtcontact_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$courtcontact_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$courtcontact->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$courtcontact_view->terminate();
?>
