<?php
namespace PHPMaker2019\project_germanos;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($courtcontact_grid))
	$courtcontact_grid = new courtcontact_grid();

// Run the page
$courtcontact_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courtcontact_grid->Page_Render();
?>
<?php if (!$courtcontact->isExport()) { ?>
<script>

// Form object
var fcourtcontactgrid = new ew.Form("fcourtcontactgrid", "grid");
fcourtcontactgrid.formKeyCountName = '<?php echo $courtcontact_grid->FormKeyCountName ?>';

// Validate form
fcourtcontactgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($courtcontact_grid->CourtID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courtcontact->CourtID->caption(), $courtcontact->CourtID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courtcontact_grid->ContactTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_ContactTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courtcontact->ContactTypeID->caption(), $courtcontact->ContactTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courtcontact_grid->Contact->Required) { ?>
			elm = this.getElements("x" + infix + "_Contact");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courtcontact->Contact->caption(), $courtcontact->Contact->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courtcontact_grid->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courtcontact->Notes->caption(), $courtcontact->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courtcontact_grid->Primary->Required) { ?>
			elm = this.getElements("x" + infix + "_Primary[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courtcontact->Primary->caption(), $courtcontact->Primary->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fcourtcontactgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "CourtID", false)) return false;
	if (ew.valueChanged(fobj, infix, "ContactTypeID", false)) return false;
	if (ew.valueChanged(fobj, infix, "Contact", false)) return false;
	if (ew.valueChanged(fobj, infix, "Notes", false)) return false;
	if (ew.valueChanged(fobj, infix, "Primary[]", true)) return false;
	return true;
}

// Form_CustomValidate event
fcourtcontactgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtcontactgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtcontactgrid.lists["x_CourtID"] = <?php echo $courtcontact_grid->CourtID->Lookup->toClientList() ?>;
fcourtcontactgrid.lists["x_CourtID"].options = <?php echo JsonEncode($courtcontact_grid->CourtID->lookupOptions()) ?>;
fcourtcontactgrid.lists["x_ContactTypeID"] = <?php echo $courtcontact_grid->ContactTypeID->Lookup->toClientList() ?>;
fcourtcontactgrid.lists["x_ContactTypeID"].options = <?php echo JsonEncode($courtcontact_grid->ContactTypeID->lookupOptions()) ?>;
fcourtcontactgrid.lists["x_Primary[]"] = <?php echo $courtcontact_grid->Primary->Lookup->toClientList() ?>;
fcourtcontactgrid.lists["x_Primary[]"].options = <?php echo JsonEncode($courtcontact_grid->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$courtcontact_grid->renderOtherOptions();
?>
<?php $courtcontact_grid->showPageHeader(); ?>
<?php
$courtcontact_grid->showMessage();
?>
<?php if ($courtcontact_grid->TotalRecs > 0 || $courtcontact->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($courtcontact_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> courtcontact">
<?php if ($courtcontact_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $courtcontact_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fcourtcontactgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_courtcontact" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_courtcontactgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$courtcontact_grid->RowType = ROWTYPE_HEADER;

// Render list options
$courtcontact_grid->renderListOptions();

// Render list options (header, left)
$courtcontact_grid->ListOptions->render("header", "left");
?>
<?php if ($courtcontact->CourtID->Visible) { // CourtID ?>
	<?php if ($courtcontact->sortUrl($courtcontact->CourtID) == "") { ?>
		<th data-name="CourtID" class="<?php echo $courtcontact->CourtID->headerCellClass() ?>"><div id="elh_courtcontact_CourtID" class="courtcontact_CourtID"><div class="ew-table-header-caption"><?php echo $courtcontact->CourtID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtID" class="<?php echo $courtcontact->CourtID->headerCellClass() ?>"><div><div id="elh_courtcontact_CourtID" class="courtcontact_CourtID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtcontact->CourtID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtcontact->CourtID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtcontact->CourtID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($courtcontact->sortUrl($courtcontact->ContactTypeID) == "") { ?>
		<th data-name="ContactTypeID" class="<?php echo $courtcontact->ContactTypeID->headerCellClass() ?>"><div id="elh_courtcontact_ContactTypeID" class="courtcontact_ContactTypeID"><div class="ew-table-header-caption"><?php echo $courtcontact->ContactTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ContactTypeID" class="<?php echo $courtcontact->ContactTypeID->headerCellClass() ?>"><div><div id="elh_courtcontact_ContactTypeID" class="courtcontact_ContactTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtcontact->ContactTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtcontact->ContactTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtcontact->ContactTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->Contact->Visible) { // Contact ?>
	<?php if ($courtcontact->sortUrl($courtcontact->Contact) == "") { ?>
		<th data-name="Contact" class="<?php echo $courtcontact->Contact->headerCellClass() ?>"><div id="elh_courtcontact_Contact" class="courtcontact_Contact"><div class="ew-table-header-caption"><?php echo $courtcontact->Contact->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Contact" class="<?php echo $courtcontact->Contact->headerCellClass() ?>"><div><div id="elh_courtcontact_Contact" class="courtcontact_Contact">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtcontact->Contact->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtcontact->Contact->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtcontact->Contact->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->Notes->Visible) { // Notes ?>
	<?php if ($courtcontact->sortUrl($courtcontact->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $courtcontact->Notes->headerCellClass() ?>"><div id="elh_courtcontact_Notes" class="courtcontact_Notes"><div class="ew-table-header-caption"><?php echo $courtcontact->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $courtcontact->Notes->headerCellClass() ?>"><div><div id="elh_courtcontact_Notes" class="courtcontact_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtcontact->Notes->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtcontact->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtcontact->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->Primary->Visible) { // Primary ?>
	<?php if ($courtcontact->sortUrl($courtcontact->Primary) == "") { ?>
		<th data-name="Primary" class="<?php echo $courtcontact->Primary->headerCellClass() ?>"><div id="elh_courtcontact_Primary" class="courtcontact_Primary"><div class="ew-table-header-caption"><?php echo $courtcontact->Primary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primary" class="<?php echo $courtcontact->Primary->headerCellClass() ?>"><div><div id="elh_courtcontact_Primary" class="courtcontact_Primary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtcontact->Primary->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtcontact->Primary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtcontact->Primary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$courtcontact_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$courtcontact_grid->StartRec = 1;
$courtcontact_grid->StopRec = $courtcontact_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $courtcontact_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($courtcontact_grid->FormKeyCountName) && ($courtcontact->isGridAdd() || $courtcontact->isGridEdit() || $courtcontact->isConfirm())) {
		$courtcontact_grid->KeyCount = $CurrentForm->getValue($courtcontact_grid->FormKeyCountName);
		$courtcontact_grid->StopRec = $courtcontact_grid->StartRec + $courtcontact_grid->KeyCount - 1;
	}
}
$courtcontact_grid->RecCnt = $courtcontact_grid->StartRec - 1;
if ($courtcontact_grid->Recordset && !$courtcontact_grid->Recordset->EOF) {
	$courtcontact_grid->Recordset->moveFirst();
	$selectLimit = $courtcontact_grid->UseSelectLimit;
	if (!$selectLimit && $courtcontact_grid->StartRec > 1)
		$courtcontact_grid->Recordset->move($courtcontact_grid->StartRec - 1);
} elseif (!$courtcontact->AllowAddDeleteRow && $courtcontact_grid->StopRec == 0) {
	$courtcontact_grid->StopRec = $courtcontact->GridAddRowCount;
}

// Initialize aggregate
$courtcontact->RowType = ROWTYPE_AGGREGATEINIT;
$courtcontact->resetAttributes();
$courtcontact_grid->renderRow();
if ($courtcontact->isGridAdd())
	$courtcontact_grid->RowIndex = 0;
if ($courtcontact->isGridEdit())
	$courtcontact_grid->RowIndex = 0;
while ($courtcontact_grid->RecCnt < $courtcontact_grid->StopRec) {
	$courtcontact_grid->RecCnt++;
	if ($courtcontact_grid->RecCnt >= $courtcontact_grid->StartRec) {
		$courtcontact_grid->RowCnt++;
		if ($courtcontact->isGridAdd() || $courtcontact->isGridEdit() || $courtcontact->isConfirm()) {
			$courtcontact_grid->RowIndex++;
			$CurrentForm->Index = $courtcontact_grid->RowIndex;
			if ($CurrentForm->hasValue($courtcontact_grid->FormActionName) && $courtcontact_grid->EventCancelled)
				$courtcontact_grid->RowAction = strval($CurrentForm->getValue($courtcontact_grid->FormActionName));
			elseif ($courtcontact->isGridAdd())
				$courtcontact_grid->RowAction = "insert";
			else
				$courtcontact_grid->RowAction = "";
		}

		// Set up key count
		$courtcontact_grid->KeyCount = $courtcontact_grid->RowIndex;

		// Init row class and style
		$courtcontact->resetAttributes();
		$courtcontact->CssClass = "";
		if ($courtcontact->isGridAdd()) {
			if ($courtcontact->CurrentMode == "copy") {
				$courtcontact_grid->loadRowValues($courtcontact_grid->Recordset); // Load row values
				$courtcontact_grid->setRecordKey($courtcontact_grid->RowOldKey, $courtcontact_grid->Recordset); // Set old record key
			} else {
				$courtcontact_grid->loadRowValues(); // Load default values
				$courtcontact_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$courtcontact_grid->loadRowValues($courtcontact_grid->Recordset); // Load row values
		}
		$courtcontact->RowType = ROWTYPE_VIEW; // Render view
		if ($courtcontact->isGridAdd()) // Grid add
			$courtcontact->RowType = ROWTYPE_ADD; // Render add
		if ($courtcontact->isGridAdd() && $courtcontact->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$courtcontact_grid->restoreCurrentRowFormValues($courtcontact_grid->RowIndex); // Restore form values
		if ($courtcontact->isGridEdit()) { // Grid edit
			if ($courtcontact->EventCancelled)
				$courtcontact_grid->restoreCurrentRowFormValues($courtcontact_grid->RowIndex); // Restore form values
			if ($courtcontact_grid->RowAction == "insert")
				$courtcontact->RowType = ROWTYPE_ADD; // Render add
			else
				$courtcontact->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($courtcontact->isGridEdit() && ($courtcontact->RowType == ROWTYPE_EDIT || $courtcontact->RowType == ROWTYPE_ADD) && $courtcontact->EventCancelled) // Update failed
			$courtcontact_grid->restoreCurrentRowFormValues($courtcontact_grid->RowIndex); // Restore form values
		if ($courtcontact->RowType == ROWTYPE_EDIT) // Edit row
			$courtcontact_grid->EditRowCnt++;
		if ($courtcontact->isConfirm()) // Confirm row
			$courtcontact_grid->restoreCurrentRowFormValues($courtcontact_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$courtcontact->RowAttrs = array_merge($courtcontact->RowAttrs, array('data-rowindex'=>$courtcontact_grid->RowCnt, 'id'=>'r' . $courtcontact_grid->RowCnt . '_courtcontact', 'data-rowtype'=>$courtcontact->RowType));

		// Render row
		$courtcontact_grid->renderRow();

		// Render list options
		$courtcontact_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($courtcontact_grid->RowAction <> "delete" && $courtcontact_grid->RowAction <> "insertdelete" && !($courtcontact_grid->RowAction == "insert" && $courtcontact->isConfirm() && $courtcontact_grid->emptyRow())) {
?>
	<tr<?php echo $courtcontact->rowAttributes() ?>>
<?php

// Render list options (body, left)
$courtcontact_grid->ListOptions->render("body", "left", $courtcontact_grid->RowCnt);
?>
	<?php if ($courtcontact->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID"<?php echo $courtcontact->CourtID->cellAttributes() ?>>
<?php if ($courtcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($courtcontact->CourtID->getSessionValue() <> "") { ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_CourtID" class="form-group courtcontact_CourtID">
<span<?php echo $courtcontact->CourtID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($courtcontact->CourtID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" name="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($courtcontact->CourtID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_CourtID" class="form-group courtcontact_CourtID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courtcontact" data-field="x_CourtID" data-value-separator="<?php echo $courtcontact->CourtID->displayValueSeparatorAttribute() ?>" id="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" name="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID"<?php echo $courtcontact->CourtID->editAttributes() ?>>
		<?php echo $courtcontact->CourtID->selectOptionListHtml("x<?php echo $courtcontact_grid->RowIndex ?>_CourtID") ?>
	</select>
</div>
<?php echo $courtcontact->CourtID->Lookup->getParamTag("p_x" . $courtcontact_grid->RowIndex . "_CourtID") ?>
</span>
<?php } ?>
<input type="hidden" data-table="courtcontact" data-field="x_CourtID" name="o<?php echo $courtcontact_grid->RowIndex ?>_CourtID" id="o<?php echo $courtcontact_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($courtcontact->CourtID->OldValue) ?>">
<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($courtcontact->CourtID->getSessionValue() <> "") { ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_CourtID" class="form-group courtcontact_CourtID">
<span<?php echo $courtcontact->CourtID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($courtcontact->CourtID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" name="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($courtcontact->CourtID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_CourtID" class="form-group courtcontact_CourtID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courtcontact" data-field="x_CourtID" data-value-separator="<?php echo $courtcontact->CourtID->displayValueSeparatorAttribute() ?>" id="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" name="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID"<?php echo $courtcontact->CourtID->editAttributes() ?>>
		<?php echo $courtcontact->CourtID->selectOptionListHtml("x<?php echo $courtcontact_grid->RowIndex ?>_CourtID") ?>
	</select>
</div>
<?php echo $courtcontact->CourtID->Lookup->getParamTag("p_x" . $courtcontact_grid->RowIndex . "_CourtID") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_CourtID" class="courtcontact_CourtID">
<span<?php echo $courtcontact->CourtID->viewAttributes() ?>>
<?php echo $courtcontact->CourtID->getViewValue() ?></span>
</span>
<?php if (!$courtcontact->isConfirm()) { ?>
<input type="hidden" data-table="courtcontact" data-field="x_CourtID" name="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" id="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($courtcontact->CourtID->FormValue) ?>">
<input type="hidden" data-table="courtcontact" data-field="x_CourtID" name="o<?php echo $courtcontact_grid->RowIndex ?>_CourtID" id="o<?php echo $courtcontact_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($courtcontact->CourtID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="courtcontact" data-field="x_CourtID" name="fcourtcontactgrid$x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" id="fcourtcontactgrid$x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($courtcontact->CourtID->FormValue) ?>">
<input type="hidden" data-table="courtcontact" data-field="x_CourtID" name="fcourtcontactgrid$o<?php echo $courtcontact_grid->RowIndex ?>_CourtID" id="fcourtcontactgrid$o<?php echo $courtcontact_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($courtcontact->CourtID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="courtcontact" data-field="x_ContactID" name="x<?php echo $courtcontact_grid->RowIndex ?>_ContactID" id="x<?php echo $courtcontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($courtcontact->ContactID->CurrentValue) ?>">
<input type="hidden" data-table="courtcontact" data-field="x_ContactID" name="o<?php echo $courtcontact_grid->RowIndex ?>_ContactID" id="o<?php echo $courtcontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($courtcontact->ContactID->OldValue) ?>">
<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_EDIT || $courtcontact->CurrentMode == "edit") { ?>
<input type="hidden" data-table="courtcontact" data-field="x_ContactID" name="x<?php echo $courtcontact_grid->RowIndex ?>_ContactID" id="x<?php echo $courtcontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($courtcontact->ContactID->CurrentValue) ?>">
<?php } ?>
	<?php if ($courtcontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<td data-name="ContactTypeID"<?php echo $courtcontact->ContactTypeID->cellAttributes() ?>>
<?php if ($courtcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_ContactTypeID" class="form-group courtcontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courtcontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $courtcontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID"<?php echo $courtcontact->ContactTypeID->editAttributes() ?>>
		<?php echo $courtcontact->ContactTypeID->selectOptionListHtml("x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $courtcontact->ContactTypeID->Lookup->getParamTag("p_x" . $courtcontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<input type="hidden" data-table="courtcontact" data-field="x_ContactTypeID" name="o<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($courtcontact->ContactTypeID->OldValue) ?>">
<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_ContactTypeID" class="form-group courtcontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courtcontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $courtcontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID"<?php echo $courtcontact->ContactTypeID->editAttributes() ?>>
		<?php echo $courtcontact->ContactTypeID->selectOptionListHtml("x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $courtcontact->ContactTypeID->Lookup->getParamTag("p_x" . $courtcontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_ContactTypeID" class="courtcontact_ContactTypeID">
<span<?php echo $courtcontact->ContactTypeID->viewAttributes() ?>>
<?php echo $courtcontact->ContactTypeID->getViewValue() ?></span>
</span>
<?php if (!$courtcontact->isConfirm()) { ?>
<input type="hidden" data-table="courtcontact" data-field="x_ContactTypeID" name="x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" id="x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($courtcontact->ContactTypeID->FormValue) ?>">
<input type="hidden" data-table="courtcontact" data-field="x_ContactTypeID" name="o<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($courtcontact->ContactTypeID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="courtcontact" data-field="x_ContactTypeID" name="fcourtcontactgrid$x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" id="fcourtcontactgrid$x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($courtcontact->ContactTypeID->FormValue) ?>">
<input type="hidden" data-table="courtcontact" data-field="x_ContactTypeID" name="fcourtcontactgrid$o<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" id="fcourtcontactgrid$o<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($courtcontact->ContactTypeID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($courtcontact->Contact->Visible) { // Contact ?>
		<td data-name="Contact"<?php echo $courtcontact->Contact->cellAttributes() ?>>
<?php if ($courtcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_Contact" class="form-group courtcontact_Contact">
<input type="text" data-table="courtcontact" data-field="x_Contact" name="x<?php echo $courtcontact_grid->RowIndex ?>_Contact" id="x<?php echo $courtcontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($courtcontact->Contact->getPlaceHolder()) ?>" value="<?php echo $courtcontact->Contact->EditValue ?>"<?php echo $courtcontact->Contact->editAttributes() ?>>
</span>
<input type="hidden" data-table="courtcontact" data-field="x_Contact" name="o<?php echo $courtcontact_grid->RowIndex ?>_Contact" id="o<?php echo $courtcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($courtcontact->Contact->OldValue) ?>">
<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_Contact" class="form-group courtcontact_Contact">
<input type="text" data-table="courtcontact" data-field="x_Contact" name="x<?php echo $courtcontact_grid->RowIndex ?>_Contact" id="x<?php echo $courtcontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($courtcontact->Contact->getPlaceHolder()) ?>" value="<?php echo $courtcontact->Contact->EditValue ?>"<?php echo $courtcontact->Contact->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_Contact" class="courtcontact_Contact">
<span<?php echo $courtcontact->Contact->viewAttributes() ?>>
<?php echo $courtcontact->Contact->getViewValue() ?></span>
</span>
<?php if (!$courtcontact->isConfirm()) { ?>
<input type="hidden" data-table="courtcontact" data-field="x_Contact" name="x<?php echo $courtcontact_grid->RowIndex ?>_Contact" id="x<?php echo $courtcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($courtcontact->Contact->FormValue) ?>">
<input type="hidden" data-table="courtcontact" data-field="x_Contact" name="o<?php echo $courtcontact_grid->RowIndex ?>_Contact" id="o<?php echo $courtcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($courtcontact->Contact->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="courtcontact" data-field="x_Contact" name="fcourtcontactgrid$x<?php echo $courtcontact_grid->RowIndex ?>_Contact" id="fcourtcontactgrid$x<?php echo $courtcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($courtcontact->Contact->FormValue) ?>">
<input type="hidden" data-table="courtcontact" data-field="x_Contact" name="fcourtcontactgrid$o<?php echo $courtcontact_grid->RowIndex ?>_Contact" id="fcourtcontactgrid$o<?php echo $courtcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($courtcontact->Contact->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($courtcontact->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $courtcontact->Notes->cellAttributes() ?>>
<?php if ($courtcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_Notes" class="form-group courtcontact_Notes">
<input type="text" data-table="courtcontact" data-field="x_Notes" name="x<?php echo $courtcontact_grid->RowIndex ?>_Notes" id="x<?php echo $courtcontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courtcontact->Notes->getPlaceHolder()) ?>" value="<?php echo $courtcontact->Notes->EditValue ?>"<?php echo $courtcontact->Notes->editAttributes() ?>>
</span>
<input type="hidden" data-table="courtcontact" data-field="x_Notes" name="o<?php echo $courtcontact_grid->RowIndex ?>_Notes" id="o<?php echo $courtcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($courtcontact->Notes->OldValue) ?>">
<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_Notes" class="form-group courtcontact_Notes">
<input type="text" data-table="courtcontact" data-field="x_Notes" name="x<?php echo $courtcontact_grid->RowIndex ?>_Notes" id="x<?php echo $courtcontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courtcontact->Notes->getPlaceHolder()) ?>" value="<?php echo $courtcontact->Notes->EditValue ?>"<?php echo $courtcontact->Notes->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_Notes" class="courtcontact_Notes">
<span<?php echo $courtcontact->Notes->viewAttributes() ?>>
<?php echo $courtcontact->Notes->getViewValue() ?></span>
</span>
<?php if (!$courtcontact->isConfirm()) { ?>
<input type="hidden" data-table="courtcontact" data-field="x_Notes" name="x<?php echo $courtcontact_grid->RowIndex ?>_Notes" id="x<?php echo $courtcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($courtcontact->Notes->FormValue) ?>">
<input type="hidden" data-table="courtcontact" data-field="x_Notes" name="o<?php echo $courtcontact_grid->RowIndex ?>_Notes" id="o<?php echo $courtcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($courtcontact->Notes->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="courtcontact" data-field="x_Notes" name="fcourtcontactgrid$x<?php echo $courtcontact_grid->RowIndex ?>_Notes" id="fcourtcontactgrid$x<?php echo $courtcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($courtcontact->Notes->FormValue) ?>">
<input type="hidden" data-table="courtcontact" data-field="x_Notes" name="fcourtcontactgrid$o<?php echo $courtcontact_grid->RowIndex ?>_Notes" id="fcourtcontactgrid$o<?php echo $courtcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($courtcontact->Notes->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($courtcontact->Primary->Visible) { // Primary ?>
		<td data-name="Primary"<?php echo $courtcontact->Primary->cellAttributes() ?>>
<?php if ($courtcontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_Primary" class="form-group courtcontact_Primary">
<?php
$selwrk = (ConvertToBool($courtcontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="courtcontact" data-field="x_Primary" name="x<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $courtcontact->Primary->editAttributes() ?>>
</span>
<input type="hidden" data-table="courtcontact" data-field="x_Primary" name="o<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($courtcontact->Primary->OldValue) ?>">
<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_Primary" class="form-group courtcontact_Primary">
<?php
$selwrk = (ConvertToBool($courtcontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="courtcontact" data-field="x_Primary" name="x<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $courtcontact->Primary->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($courtcontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $courtcontact_grid->RowCnt ?>_courtcontact_Primary" class="courtcontact_Primary">
<span<?php echo $courtcontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($courtcontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $courtcontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $courtcontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
<?php if (!$courtcontact->isConfirm()) { ?>
<input type="hidden" data-table="courtcontact" data-field="x_Primary" name="x<?php echo $courtcontact_grid->RowIndex ?>_Primary" id="x<?php echo $courtcontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($courtcontact->Primary->FormValue) ?>">
<input type="hidden" data-table="courtcontact" data-field="x_Primary" name="o<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($courtcontact->Primary->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="courtcontact" data-field="x_Primary" name="fcourtcontactgrid$x<?php echo $courtcontact_grid->RowIndex ?>_Primary" id="fcourtcontactgrid$x<?php echo $courtcontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($courtcontact->Primary->FormValue) ?>">
<input type="hidden" data-table="courtcontact" data-field="x_Primary" name="fcourtcontactgrid$o<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" id="fcourtcontactgrid$o<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($courtcontact->Primary->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$courtcontact_grid->ListOptions->render("body", "right", $courtcontact_grid->RowCnt);
?>
	</tr>
<?php if ($courtcontact->RowType == ROWTYPE_ADD || $courtcontact->RowType == ROWTYPE_EDIT) { ?>
<script>
fcourtcontactgrid.updateLists(<?php echo $courtcontact_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$courtcontact->isGridAdd() || $courtcontact->CurrentMode == "copy")
		if (!$courtcontact_grid->Recordset->EOF)
			$courtcontact_grid->Recordset->moveNext();
}
?>
<?php
	if ($courtcontact->CurrentMode == "add" || $courtcontact->CurrentMode == "copy" || $courtcontact->CurrentMode == "edit") {
		$courtcontact_grid->RowIndex = '$rowindex$';
		$courtcontact_grid->loadRowValues();

		// Set row properties
		$courtcontact->resetAttributes();
		$courtcontact->RowAttrs = array_merge($courtcontact->RowAttrs, array('data-rowindex'=>$courtcontact_grid->RowIndex, 'id'=>'r0_courtcontact', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($courtcontact->RowAttrs["class"], "ew-template");
		$courtcontact->RowType = ROWTYPE_ADD;

		// Render row
		$courtcontact_grid->renderRow();

		// Render list options
		$courtcontact_grid->renderListOptions();
		$courtcontact_grid->StartRowCnt = 0;
?>
	<tr<?php echo $courtcontact->rowAttributes() ?>>
<?php

// Render list options (body, left)
$courtcontact_grid->ListOptions->render("body", "left", $courtcontact_grid->RowIndex);
?>
	<?php if ($courtcontact->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID">
<?php if (!$courtcontact->isConfirm()) { ?>
<?php if ($courtcontact->CourtID->getSessionValue() <> "") { ?>
<span id="el$rowindex$_courtcontact_CourtID" class="form-group courtcontact_CourtID">
<span<?php echo $courtcontact->CourtID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($courtcontact->CourtID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" name="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($courtcontact->CourtID->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_courtcontact_CourtID" class="form-group courtcontact_CourtID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courtcontact" data-field="x_CourtID" data-value-separator="<?php echo $courtcontact->CourtID->displayValueSeparatorAttribute() ?>" id="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" name="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID"<?php echo $courtcontact->CourtID->editAttributes() ?>>
		<?php echo $courtcontact->CourtID->selectOptionListHtml("x<?php echo $courtcontact_grid->RowIndex ?>_CourtID") ?>
	</select>
</div>
<?php echo $courtcontact->CourtID->Lookup->getParamTag("p_x" . $courtcontact_grid->RowIndex . "_CourtID") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_courtcontact_CourtID" class="form-group courtcontact_CourtID">
<span<?php echo $courtcontact->CourtID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($courtcontact->CourtID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="courtcontact" data-field="x_CourtID" name="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" id="x<?php echo $courtcontact_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($courtcontact->CourtID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="courtcontact" data-field="x_CourtID" name="o<?php echo $courtcontact_grid->RowIndex ?>_CourtID" id="o<?php echo $courtcontact_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($courtcontact->CourtID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($courtcontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<td data-name="ContactTypeID">
<?php if (!$courtcontact->isConfirm()) { ?>
<span id="el$rowindex$_courtcontact_ContactTypeID" class="form-group courtcontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courtcontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $courtcontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID"<?php echo $courtcontact->ContactTypeID->editAttributes() ?>>
		<?php echo $courtcontact->ContactTypeID->selectOptionListHtml("x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $courtcontact->ContactTypeID->Lookup->getParamTag("p_x" . $courtcontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_courtcontact_ContactTypeID" class="form-group courtcontact_ContactTypeID">
<span<?php echo $courtcontact->ContactTypeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($courtcontact->ContactTypeID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="courtcontact" data-field="x_ContactTypeID" name="x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" id="x<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($courtcontact->ContactTypeID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="courtcontact" data-field="x_ContactTypeID" name="o<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $courtcontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($courtcontact->ContactTypeID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($courtcontact->Contact->Visible) { // Contact ?>
		<td data-name="Contact">
<?php if (!$courtcontact->isConfirm()) { ?>
<span id="el$rowindex$_courtcontact_Contact" class="form-group courtcontact_Contact">
<input type="text" data-table="courtcontact" data-field="x_Contact" name="x<?php echo $courtcontact_grid->RowIndex ?>_Contact" id="x<?php echo $courtcontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($courtcontact->Contact->getPlaceHolder()) ?>" value="<?php echo $courtcontact->Contact->EditValue ?>"<?php echo $courtcontact->Contact->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_courtcontact_Contact" class="form-group courtcontact_Contact">
<span<?php echo $courtcontact->Contact->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($courtcontact->Contact->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="courtcontact" data-field="x_Contact" name="x<?php echo $courtcontact_grid->RowIndex ?>_Contact" id="x<?php echo $courtcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($courtcontact->Contact->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="courtcontact" data-field="x_Contact" name="o<?php echo $courtcontact_grid->RowIndex ?>_Contact" id="o<?php echo $courtcontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($courtcontact->Contact->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($courtcontact->Notes->Visible) { // Notes ?>
		<td data-name="Notes">
<?php if (!$courtcontact->isConfirm()) { ?>
<span id="el$rowindex$_courtcontact_Notes" class="form-group courtcontact_Notes">
<input type="text" data-table="courtcontact" data-field="x_Notes" name="x<?php echo $courtcontact_grid->RowIndex ?>_Notes" id="x<?php echo $courtcontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courtcontact->Notes->getPlaceHolder()) ?>" value="<?php echo $courtcontact->Notes->EditValue ?>"<?php echo $courtcontact->Notes->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_courtcontact_Notes" class="form-group courtcontact_Notes">
<span<?php echo $courtcontact->Notes->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($courtcontact->Notes->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="courtcontact" data-field="x_Notes" name="x<?php echo $courtcontact_grid->RowIndex ?>_Notes" id="x<?php echo $courtcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($courtcontact->Notes->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="courtcontact" data-field="x_Notes" name="o<?php echo $courtcontact_grid->RowIndex ?>_Notes" id="o<?php echo $courtcontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($courtcontact->Notes->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($courtcontact->Primary->Visible) { // Primary ?>
		<td data-name="Primary">
<?php if (!$courtcontact->isConfirm()) { ?>
<span id="el$rowindex$_courtcontact_Primary" class="form-group courtcontact_Primary">
<?php
$selwrk = (ConvertToBool($courtcontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="courtcontact" data-field="x_Primary" name="x<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $courtcontact->Primary->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_courtcontact_Primary" class="form-group courtcontact_Primary">
<span<?php echo $courtcontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($courtcontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $courtcontact->Primary->ViewValue ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $courtcontact->Primary->ViewValue ?>" disabled>
<?php } ?>
</span>
</span>
<input type="hidden" data-table="courtcontact" data-field="x_Primary" name="x<?php echo $courtcontact_grid->RowIndex ?>_Primary" id="x<?php echo $courtcontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($courtcontact->Primary->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="courtcontact" data-field="x_Primary" name="o<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $courtcontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($courtcontact->Primary->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$courtcontact_grid->ListOptions->render("body", "right", $courtcontact_grid->RowIndex);
?>
<script>
fcourtcontactgrid.updateLists(<?php echo $courtcontact_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($courtcontact->CurrentMode == "add" || $courtcontact->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $courtcontact_grid->FormKeyCountName ?>" id="<?php echo $courtcontact_grid->FormKeyCountName ?>" value="<?php echo $courtcontact_grid->KeyCount ?>">
<?php echo $courtcontact_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($courtcontact->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $courtcontact_grid->FormKeyCountName ?>" id="<?php echo $courtcontact_grid->FormKeyCountName ?>" value="<?php echo $courtcontact_grid->KeyCount ?>">
<?php echo $courtcontact_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($courtcontact->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fcourtcontactgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($courtcontact_grid->Recordset)
	$courtcontact_grid->Recordset->Close();
?>
</div>
<?php if ($courtcontact_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $courtcontact_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($courtcontact_grid->TotalRecs == 0 && !$courtcontact->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $courtcontact_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$courtcontact_grid->terminate();
?>
<?php if (!$courtcontact->isExport()) { ?>
<script>
ew.scrollableTable("gmp_courtcontact", "", "");
</script>
<?php } ?>
