<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$contacts_delete = new contacts_delete();

// Run the page
$contacts_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$contacts_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fcontactsdelete = currentForm = new ew.Form("fcontactsdelete", "delete");

// Form_CustomValidate event
fcontactsdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcontactsdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcontactsdelete.lists["x_ContactTypeID"] = <?php echo $contacts_delete->ContactTypeID->Lookup->toClientList() ?>;
fcontactsdelete.lists["x_ContactTypeID"].options = <?php echo JsonEncode($contacts_delete->ContactTypeID->lookupOptions()) ?>;
fcontactsdelete.lists["x_Primary[]"] = <?php echo $contacts_delete->Primary->Lookup->toClientList() ?>;
fcontactsdelete.lists["x_Primary[]"].options = <?php echo JsonEncode($contacts_delete->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $contacts_delete->showPageHeader(); ?>
<?php
$contacts_delete->showMessage();
?>
<form name="fcontactsdelete" id="fcontactsdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($contacts_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $contacts_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="contacts">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($contacts_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($contacts->ContactTypeID->Visible) { // ContactTypeID ?>
		<th class="<?php echo $contacts->ContactTypeID->headerCellClass() ?>"><span id="elh_contacts_ContactTypeID" class="contacts_ContactTypeID"><?php echo $contacts->ContactTypeID->caption() ?></span></th>
<?php } ?>
<?php if ($contacts->Contact->Visible) { // Contact ?>
		<th class="<?php echo $contacts->Contact->headerCellClass() ?>"><span id="elh_contacts_Contact" class="contacts_Contact"><?php echo $contacts->Contact->caption() ?></span></th>
<?php } ?>
<?php if ($contacts->Notes->Visible) { // Notes ?>
		<th class="<?php echo $contacts->Notes->headerCellClass() ?>"><span id="elh_contacts_Notes" class="contacts_Notes"><?php echo $contacts->Notes->caption() ?></span></th>
<?php } ?>
<?php if ($contacts->Primary->Visible) { // Primary ?>
		<th class="<?php echo $contacts->Primary->headerCellClass() ?>"><span id="elh_contacts_Primary" class="contacts_Primary"><?php echo $contacts->Primary->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$contacts_delete->RecCnt = 0;
$i = 0;
while (!$contacts_delete->Recordset->EOF) {
	$contacts_delete->RecCnt++;
	$contacts_delete->RowCnt++;

	// Set row properties
	$contacts->resetAttributes();
	$contacts->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$contacts_delete->loadRowValues($contacts_delete->Recordset);

	// Render row
	$contacts_delete->renderRow();
?>
	<tr<?php echo $contacts->rowAttributes() ?>>
<?php if ($contacts->ContactTypeID->Visible) { // ContactTypeID ?>
		<td<?php echo $contacts->ContactTypeID->cellAttributes() ?>>
<span id="el<?php echo $contacts_delete->RowCnt ?>_contacts_ContactTypeID" class="contacts_ContactTypeID">
<span<?php echo $contacts->ContactTypeID->viewAttributes() ?>>
<?php echo $contacts->ContactTypeID->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($contacts->Contact->Visible) { // Contact ?>
		<td<?php echo $contacts->Contact->cellAttributes() ?>>
<span id="el<?php echo $contacts_delete->RowCnt ?>_contacts_Contact" class="contacts_Contact">
<span<?php echo $contacts->Contact->viewAttributes() ?>>
<?php echo $contacts->Contact->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($contacts->Notes->Visible) { // Notes ?>
		<td<?php echo $contacts->Notes->cellAttributes() ?>>
<span id="el<?php echo $contacts_delete->RowCnt ?>_contacts_Notes" class="contacts_Notes">
<span<?php echo $contacts->Notes->viewAttributes() ?>>
<?php echo $contacts->Notes->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($contacts->Primary->Visible) { // Primary ?>
		<td<?php echo $contacts->Primary->cellAttributes() ?>>
<span id="el<?php echo $contacts_delete->RowCnt ?>_contacts_Primary" class="contacts_Primary">
<span<?php echo $contacts->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($contacts->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $contacts->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $contacts->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$contacts_delete->Recordset->moveNext();
}
$contacts_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $contacts_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$contacts_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$contacts_delete->terminate();
?>
