<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$complaints_preview = new complaints_preview();

// Run the page
$complaints_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$complaints_preview->Page_Render();
?>
<?php $complaints_preview->showPageHeader(); ?>
<div class="card ew-grid complaints"><!-- .card -->
<?php if ($complaints_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$complaints_preview->renderListOptions();

// Render list options (header, left)
$complaints_preview->ListOptions->render("header", "left");
?>
<?php if ($complaints->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($complaints->SortUrl($complaints->CaseNumber) == "") { ?>
		<th class="<?php echo $complaints->CaseNumber->headerCellClass() ?>"><?php echo $complaints->CaseNumber->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $complaints->CaseNumber->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $complaints->CaseNumber->Name ?>" data-sort-order="<?php echo $complaints_preview->SortField == $complaints->CaseNumber->Name && $complaints_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $complaints->CaseNumber->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($complaints_preview->SortField == $complaints->CaseNumber->Name) { ?><?php if ($complaints_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($complaints_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($complaints->ComplaintDate->Visible) { // ComplaintDate ?>
	<?php if ($complaints->SortUrl($complaints->ComplaintDate) == "") { ?>
		<th class="<?php echo $complaints->ComplaintDate->headerCellClass() ?>"><?php echo $complaints->ComplaintDate->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $complaints->ComplaintDate->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $complaints->ComplaintDate->Name ?>" data-sort-order="<?php echo $complaints_preview->SortField == $complaints->ComplaintDate->Name && $complaints_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $complaints->ComplaintDate->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($complaints_preview->SortField == $complaints->ComplaintDate->Name) { ?><?php if ($complaints_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($complaints_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($complaints->Complaint->Visible) { // Complaint ?>
	<?php if ($complaints->SortUrl($complaints->Complaint) == "") { ?>
		<th class="<?php echo $complaints->Complaint->headerCellClass() ?>"><?php echo $complaints->Complaint->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $complaints->Complaint->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $complaints->Complaint->Name ?>" data-sort-order="<?php echo $complaints_preview->SortField == $complaints->Complaint->Name && $complaints_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $complaints->Complaint->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($complaints_preview->SortField == $complaints->Complaint->Name) { ?><?php if ($complaints_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($complaints_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$complaints_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$complaints_preview->RecCount = 0;
$complaints_preview->RowCnt = 0;
while ($complaints_preview->Recordset && !$complaints_preview->Recordset->EOF) {

	// Init row class and style
	$complaints_preview->RecCount++;
	$complaints_preview->RowCnt++;
	$complaints_preview->CssStyle = "";
	$complaints_preview->loadListRowValues($complaints_preview->Recordset);

	// Render row
	$complaints_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$complaints_preview->resetAttributes();
	$complaints_preview->renderListRow();

	// Render list options
	$complaints_preview->renderListOptions();
?>
	<tr<?php echo $complaints_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$complaints_preview->ListOptions->render("body", "left", $complaints_preview->RowCnt);
?>
<?php if ($complaints->CaseNumber->Visible) { // CaseNumber ?>
		<!-- CaseNumber -->
		<td<?php echo $complaints->CaseNumber->cellAttributes() ?>>
<span<?php echo $complaints->CaseNumber->viewAttributes() ?>>
<?php echo $complaints->CaseNumber->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($complaints->ComplaintDate->Visible) { // ComplaintDate ?>
		<!-- ComplaintDate -->
		<td<?php echo $complaints->ComplaintDate->cellAttributes() ?>>
<span<?php echo $complaints->ComplaintDate->viewAttributes() ?>>
<?php echo $complaints->ComplaintDate->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($complaints->Complaint->Visible) { // Complaint ?>
		<!-- Complaint -->
		<td<?php echo $complaints->Complaint->cellAttributes() ?>>
<span<?php echo $complaints->Complaint->viewAttributes() ?>>
<?php echo $complaints->Complaint->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$complaints_preview->ListOptions->render("body", "right", $complaints_preview->RowCnt);
?>
	</tr>
<?php
	$complaints_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($complaints_preview->TotalRecs > 0) { ?>
<?php if (!isset($complaints_preview->Pager)) $complaints_preview->Pager = new PrevNextPager($complaints_preview->StartRec, $complaints_preview->DisplayRecs, $complaints_preview->TotalRecs) ?>
<?php if ($complaints_preview->Pager->RecordCount > 0 && $complaints_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($complaints_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $complaints_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($complaints_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $complaints_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($complaints_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $complaints_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($complaints_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $complaints_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $complaints_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $complaints_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $complaints_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($complaints_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$complaints_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($complaints_preview->Recordset)
	$complaints_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$complaints_preview->terminate();
?>
