<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$complaints_list = new complaints_list();

// Run the page
$complaints_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$complaints_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$complaints->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcomplaintslist = currentForm = new ew.Form("fcomplaintslist", "list");
fcomplaintslist.formKeyCountName = '<?php echo $complaints_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcomplaintslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcomplaintslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fcomplaintslistsrch = currentSearchForm = new ew.Form("fcomplaintslistsrch");

// Validate function for search
fcomplaintslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fcomplaintslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcomplaintslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fcomplaintslistsrch.filterList = <?php echo $complaints_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$complaints->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($complaints_list->TotalRecs > 0 && $complaints_list->ExportOptions->visible()) { ?>
<?php $complaints_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($complaints_list->ImportOptions->visible()) { ?>
<?php $complaints_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($complaints_list->SearchOptions->visible()) { ?>
<?php $complaints_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($complaints_list->FilterOptions->visible()) { ?>
<?php $complaints_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$complaints->isExport() || EXPORT_MASTER_RECORD && $complaints->isExport("print")) { ?>
<?php
if ($complaints_list->DbMasterFilter <> "" && $complaints->getCurrentMasterTable() == "cases") {
	if ($complaints_list->MasterRecordExists) {
		include_once "casesmaster.php";
	}
}
?>
<?php } ?>
<?php
$complaints_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$complaints->isExport() && !$complaints->CurrentAction) { ?>
<form name="fcomplaintslistsrch" id="fcomplaintslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($complaints_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fcomplaintslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="complaints">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$complaints_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$complaints->RowType = ROWTYPE_SEARCH;

// Render row
$complaints->resetAttributes();
$complaints_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($complaints->CaseNumber->Visible) { // CaseNumber ?>
	<div id="xsc_CaseNumber" class="ew-cell form-group">
		<label for="x_CaseNumber" class="ew-search-caption ew-label"><?php echo $complaints->CaseNumber->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CaseNumber" id="z_CaseNumber" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="complaints" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($complaints->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $complaints->CaseNumber->EditValue ?>"<?php echo $complaints->CaseNumber->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($complaints_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($complaints_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $complaints_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($complaints_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($complaints_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($complaints_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($complaints_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $complaints_list->showPageHeader(); ?>
<?php
$complaints_list->showMessage();
?>
<?php if ($complaints_list->TotalRecs > 0 || $complaints->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($complaints_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> complaints">
<?php if (!$complaints->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$complaints->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($complaints_list->Pager)) $complaints_list->Pager = new PrevNextPager($complaints_list->StartRec, $complaints_list->DisplayRecs, $complaints_list->TotalRecs, $complaints_list->AutoHidePager) ?>
<?php if ($complaints_list->Pager->RecordCount > 0 && $complaints_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($complaints_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $complaints_list->pageUrl() ?>start=<?php echo $complaints_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($complaints_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $complaints_list->pageUrl() ?>start=<?php echo $complaints_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $complaints_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($complaints_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $complaints_list->pageUrl() ?>start=<?php echo $complaints_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($complaints_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $complaints_list->pageUrl() ?>start=<?php echo $complaints_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $complaints_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($complaints_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $complaints_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $complaints_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $complaints_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($complaints_list->TotalRecs > 0 && (!$complaints_list->AutoHidePageSizeSelector || $complaints_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="complaints">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($complaints_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($complaints_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($complaints_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($complaints_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($complaints_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($complaints_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($complaints_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($complaints_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($complaints_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($complaints->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $complaints_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcomplaintslist" id="fcomplaintslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($complaints_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $complaints_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="complaints">
<?php if ($complaints->getCurrentMasterTable() == "cases" && $complaints->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="cases">
<input type="hidden" name="fk_CaseID" value="<?php echo $complaints->CaseID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_complaints" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($complaints_list->TotalRecs > 0 || $complaints->isGridEdit()) { ?>
<table id="tbl_complaintslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$complaints_list->RowType = ROWTYPE_HEADER;

// Render list options
$complaints_list->renderListOptions();

// Render list options (header, left)
$complaints_list->ListOptions->render("header", "left");
?>
<?php if ($complaints->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($complaints->sortUrl($complaints->CaseNumber) == "") { ?>
		<th data-name="CaseNumber" class="<?php echo $complaints->CaseNumber->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_complaints_CaseNumber" class="complaints_CaseNumber"><div class="ew-table-header-caption"><?php echo $complaints->CaseNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseNumber" class="<?php echo $complaints->CaseNumber->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $complaints->SortUrl($complaints->CaseNumber) ?>',2);"><div id="elh_complaints_CaseNumber" class="complaints_CaseNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $complaints->CaseNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($complaints->CaseNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($complaints->CaseNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($complaints->ComplaintDate->Visible) { // ComplaintDate ?>
	<?php if ($complaints->sortUrl($complaints->ComplaintDate) == "") { ?>
		<th data-name="ComplaintDate" class="<?php echo $complaints->ComplaintDate->headerCellClass() ?>"><div id="elh_complaints_ComplaintDate" class="complaints_ComplaintDate"><div class="ew-table-header-caption"><?php echo $complaints->ComplaintDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ComplaintDate" class="<?php echo $complaints->ComplaintDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $complaints->SortUrl($complaints->ComplaintDate) ?>',2);"><div id="elh_complaints_ComplaintDate" class="complaints_ComplaintDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $complaints->ComplaintDate->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($complaints->ComplaintDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($complaints->ComplaintDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($complaints->Complaint->Visible) { // Complaint ?>
	<?php if ($complaints->sortUrl($complaints->Complaint) == "") { ?>
		<th data-name="Complaint" class="<?php echo $complaints->Complaint->headerCellClass() ?>"><div id="elh_complaints_Complaint" class="complaints_Complaint"><div class="ew-table-header-caption"><?php echo $complaints->Complaint->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Complaint" class="<?php echo $complaints->Complaint->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $complaints->SortUrl($complaints->Complaint) ?>',2);"><div id="elh_complaints_Complaint" class="complaints_Complaint">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $complaints->Complaint->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($complaints->Complaint->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($complaints->Complaint->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$complaints_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($complaints->ExportAll && $complaints->isExport()) {
	$complaints_list->StopRec = $complaints_list->TotalRecs;
} else {

	// Set the last record to display
	if ($complaints_list->TotalRecs > $complaints_list->StartRec + $complaints_list->DisplayRecs - 1)
		$complaints_list->StopRec = $complaints_list->StartRec + $complaints_list->DisplayRecs - 1;
	else
		$complaints_list->StopRec = $complaints_list->TotalRecs;
}
$complaints_list->RecCnt = $complaints_list->StartRec - 1;
if ($complaints_list->Recordset && !$complaints_list->Recordset->EOF) {
	$complaints_list->Recordset->moveFirst();
	$selectLimit = $complaints_list->UseSelectLimit;
	if (!$selectLimit && $complaints_list->StartRec > 1)
		$complaints_list->Recordset->move($complaints_list->StartRec - 1);
} elseif (!$complaints->AllowAddDeleteRow && $complaints_list->StopRec == 0) {
	$complaints_list->StopRec = $complaints->GridAddRowCount;
}

// Initialize aggregate
$complaints->RowType = ROWTYPE_AGGREGATEINIT;
$complaints->resetAttributes();
$complaints_list->renderRow();
while ($complaints_list->RecCnt < $complaints_list->StopRec) {
	$complaints_list->RecCnt++;
	if ($complaints_list->RecCnt >= $complaints_list->StartRec) {
		$complaints_list->RowCnt++;

		// Set up key count
		$complaints_list->KeyCount = $complaints_list->RowIndex;

		// Init row class and style
		$complaints->resetAttributes();
		$complaints->CssClass = "";
		if ($complaints->isGridAdd()) {
		} else {
			$complaints_list->loadRowValues($complaints_list->Recordset); // Load row values
		}
		$complaints->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$complaints->RowAttrs = array_merge($complaints->RowAttrs, array('data-rowindex'=>$complaints_list->RowCnt, 'id'=>'r' . $complaints_list->RowCnt . '_complaints', 'data-rowtype'=>$complaints->RowType));

		// Render row
		$complaints_list->renderRow();

		// Render list options
		$complaints_list->renderListOptions();
?>
	<tr<?php echo $complaints->rowAttributes() ?>>
<?php

// Render list options (body, left)
$complaints_list->ListOptions->render("body", "left", $complaints_list->RowCnt);
?>
	<?php if ($complaints->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber"<?php echo $complaints->CaseNumber->cellAttributes() ?>>
<span id="el<?php echo $complaints_list->RowCnt ?>_complaints_CaseNumber" class="complaints_CaseNumber">
<span<?php echo $complaints->CaseNumber->viewAttributes() ?>>
<?php echo $complaints->CaseNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($complaints->ComplaintDate->Visible) { // ComplaintDate ?>
		<td data-name="ComplaintDate"<?php echo $complaints->ComplaintDate->cellAttributes() ?>>
<span id="el<?php echo $complaints_list->RowCnt ?>_complaints_ComplaintDate" class="complaints_ComplaintDate">
<span<?php echo $complaints->ComplaintDate->viewAttributes() ?>>
<?php echo $complaints->ComplaintDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($complaints->Complaint->Visible) { // Complaint ?>
		<td data-name="Complaint"<?php echo $complaints->Complaint->cellAttributes() ?>>
<span id="el<?php echo $complaints_list->RowCnt ?>_complaints_Complaint" class="complaints_Complaint">
<span<?php echo $complaints->Complaint->viewAttributes() ?>>
<?php echo $complaints->Complaint->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$complaints_list->ListOptions->render("body", "right", $complaints_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$complaints->isGridAdd())
		$complaints_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$complaints->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($complaints_list->Recordset)
	$complaints_list->Recordset->Close();
?>
<?php if (!$complaints->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$complaints->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($complaints_list->Pager)) $complaints_list->Pager = new PrevNextPager($complaints_list->StartRec, $complaints_list->DisplayRecs, $complaints_list->TotalRecs, $complaints_list->AutoHidePager) ?>
<?php if ($complaints_list->Pager->RecordCount > 0 && $complaints_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($complaints_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $complaints_list->pageUrl() ?>start=<?php echo $complaints_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($complaints_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $complaints_list->pageUrl() ?>start=<?php echo $complaints_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $complaints_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($complaints_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $complaints_list->pageUrl() ?>start=<?php echo $complaints_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($complaints_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $complaints_list->pageUrl() ?>start=<?php echo $complaints_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $complaints_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($complaints_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $complaints_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $complaints_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $complaints_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($complaints_list->TotalRecs > 0 && (!$complaints_list->AutoHidePageSizeSelector || $complaints_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="complaints">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($complaints_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($complaints_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($complaints_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($complaints_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($complaints_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($complaints_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($complaints_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($complaints_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($complaints_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($complaints->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $complaints_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($complaints_list->TotalRecs == 0 && !$complaints->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $complaints_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$complaints_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$complaints->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$complaints->isExport()) { ?>
<script>
ew.scrollableTable("gmp_complaints", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$complaints_list->terminate();
?>
