<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$clients_edit = new clients_edit();

// Run the page
$clients_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$clients_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fclientsedit = currentForm = new ew.Form("fclientsedit", "edit");

// Validate form
fclientsedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($clients_edit->ClientID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->ClientID->caption(), $clients->ClientID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->ClientTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->ClientTypeID->caption(), $clients->ClientTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->ClientGroupID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientGroupID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->ClientGroupID->caption(), $clients->ClientGroupID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->TitleID->Required) { ?>
			elm = this.getElements("x" + infix + "_TitleID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->TitleID->caption(), $clients->TitleID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->FirstName->Required) { ?>
			elm = this.getElements("x" + infix + "_FirstName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->FirstName->caption(), $clients->FirstName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->MiddleName->Required) { ?>
			elm = this.getElements("x" + infix + "_MiddleName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->MiddleName->caption(), $clients->MiddleName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->LastName->Required) { ?>
			elm = this.getElements("x" + infix + "_LastName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->LastName->caption(), $clients->LastName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->PartnersName->Required) { ?>
			elm = this.getElements("x" + infix + "_PartnersName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->PartnersName->caption(), $clients->PartnersName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->CompanyName->Required) { ?>
			elm = this.getElements("x" + infix + "_CompanyName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->CompanyName->caption(), $clients->CompanyName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->ContactPerson->Required) { ?>
			elm = this.getElements("x" + infix + "_ContactPerson");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->ContactPerson->caption(), $clients->ContactPerson->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->WorkNature->Required) { ?>
			elm = this.getElements("x" + infix + "_WorkNature");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->WorkNature->caption(), $clients->WorkNature->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->JobTitle->Required) { ?>
			elm = this.getElements("x" + infix + "_JobTitle");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->JobTitle->caption(), $clients->JobTitle->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->Photo->Required) { ?>
			felm = this.getElements("x" + infix + "_Photo");
			elm = this.getElements("fn_x" + infix + "_Photo");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $clients->Photo->caption(), $clients->Photo->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->BirthDate->Required) { ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->BirthDate->caption(), $clients->BirthDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($clients->BirthDate->errorMessage()) ?>");
		<?php if ($clients_edit->Gender->Required) { ?>
			elm = this.getElements("x" + infix + "_Gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->Gender->caption(), $clients->Gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients_edit->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients->Notes->caption(), $clients->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fclientsedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclientsedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclientsedit.lists["x_ClientTypeID"] = <?php echo $clients_edit->ClientTypeID->Lookup->toClientList() ?>;
fclientsedit.lists["x_ClientTypeID"].options = <?php echo JsonEncode($clients_edit->ClientTypeID->lookupOptions()) ?>;
fclientsedit.lists["x_ClientGroupID"] = <?php echo $clients_edit->ClientGroupID->Lookup->toClientList() ?>;
fclientsedit.lists["x_ClientGroupID"].options = <?php echo JsonEncode($clients_edit->ClientGroupID->lookupOptions()) ?>;
fclientsedit.autoSuggests["x_ClientGroupID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclientsedit.lists["x_TitleID"] = <?php echo $clients_edit->TitleID->Lookup->toClientList() ?>;
fclientsedit.lists["x_TitleID"].options = <?php echo JsonEncode($clients_edit->TitleID->lookupOptions()) ?>;
fclientsedit.lists["x_Gender"] = <?php echo $clients_edit->Gender->Lookup->toClientList() ?>;
fclientsedit.lists["x_Gender"].options = <?php echo JsonEncode($clients_edit->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $clients_edit->showPageHeader(); ?>
<?php
$clients_edit->showMessage();
?>
<?php if (!$clients_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($clients_edit->Pager)) $clients_edit->Pager = new PrevNextPager($clients_edit->StartRec, $clients_edit->DisplayRecs, $clients_edit->TotalRecs, $clients_edit->AutoHidePager) ?>
<?php if ($clients_edit->Pager->RecordCount > 0 && $clients_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($clients_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $clients_edit->pageUrl() ?>start=<?php echo $clients_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($clients_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $clients_edit->pageUrl() ?>start=<?php echo $clients_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $clients_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($clients_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $clients_edit->pageUrl() ?>start=<?php echo $clients_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($clients_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $clients_edit->pageUrl() ?>start=<?php echo $clients_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $clients_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="fclientsedit" id="fclientsedit" class="<?php echo $clients_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($clients_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $clients_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="clients">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$clients_edit->IsModal ?>">
<?php if (!$clients_edit->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
<div class="ew-edit-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_clientsedit" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($clients->ClientTypeID->Visible) { // ClientTypeID ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_ClientTypeID" class="form-group row">
		<label id="elh_clients_ClientTypeID" for="x_ClientTypeID" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->ClientTypeID->caption() ?><?php echo ($clients->ClientTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->ClientTypeID->cellAttributes() ?>>
<span id="el_clients_ClientTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="clients" data-field="x_ClientTypeID" data-value-separator="<?php echo $clients->ClientTypeID->displayValueSeparatorAttribute() ?>" id="x_ClientTypeID" name="x_ClientTypeID"<?php echo $clients->ClientTypeID->editAttributes() ?>>
		<?php echo $clients->ClientTypeID->selectOptionListHtml("x_ClientTypeID") ?>
	</select>
</div>
<?php echo $clients->ClientTypeID->Lookup->getParamTag("p_x_ClientTypeID") ?>
</span>
<?php echo $clients->ClientTypeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientTypeID">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_ClientTypeID"><?php echo $clients->ClientTypeID->caption() ?><?php echo ($clients->ClientTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->ClientTypeID->cellAttributes() ?>>
<span id="el_clients_ClientTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="clients" data-field="x_ClientTypeID" data-value-separator="<?php echo $clients->ClientTypeID->displayValueSeparatorAttribute() ?>" id="x_ClientTypeID" name="x_ClientTypeID"<?php echo $clients->ClientTypeID->editAttributes() ?>>
		<?php echo $clients->ClientTypeID->selectOptionListHtml("x_ClientTypeID") ?>
	</select>
</div>
<?php echo $clients->ClientTypeID->Lookup->getParamTag("p_x_ClientTypeID") ?>
</span>
<?php echo $clients->ClientTypeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->ClientGroupID->Visible) { // ClientGroupID ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_ClientGroupID" class="form-group row">
		<label id="elh_clients_ClientGroupID" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->ClientGroupID->caption() ?><?php echo ($clients->ClientGroupID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->ClientGroupID->cellAttributes() ?>>
<span id="el_clients_ClientGroupID">
<?php
$wrkonchange = "" . trim(@$clients->ClientGroupID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$clients->ClientGroupID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientGroupID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientGroupID" id="sv_x_ClientGroupID" value="<?php echo RemoveHtml($clients->ClientGroupID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($clients->ClientGroupID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($clients->ClientGroupID->getPlaceHolder()) ?>"<?php echo $clients->ClientGroupID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($clients->ClientGroupID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientGroupID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($clients->ClientGroupID->ReadOnly || $clients->ClientGroupID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "clients") && !$clients->ClientGroupID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientGroupID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $clients->ClientGroupID->caption() ?>" data-title="<?php echo $clients->ClientGroupID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientGroupID',url:'clientsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="clients" data-field="x_ClientGroupID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $clients->ClientGroupID->displayValueSeparatorAttribute() ?>" name="x_ClientGroupID" id="x_ClientGroupID" value="<?php echo HtmlEncode($clients->ClientGroupID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclientsedit.createAutoSuggest({"id":"x_ClientGroupID","forceSelect":true});
</script>
<?php echo $clients->ClientGroupID->Lookup->getParamTag("p_x_ClientGroupID") ?>
</span>
<?php echo $clients->ClientGroupID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientGroupID">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_ClientGroupID"><?php echo $clients->ClientGroupID->caption() ?><?php echo ($clients->ClientGroupID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->ClientGroupID->cellAttributes() ?>>
<span id="el_clients_ClientGroupID">
<?php
$wrkonchange = "" . trim(@$clients->ClientGroupID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$clients->ClientGroupID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientGroupID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientGroupID" id="sv_x_ClientGroupID" value="<?php echo RemoveHtml($clients->ClientGroupID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($clients->ClientGroupID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($clients->ClientGroupID->getPlaceHolder()) ?>"<?php echo $clients->ClientGroupID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($clients->ClientGroupID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientGroupID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($clients->ClientGroupID->ReadOnly || $clients->ClientGroupID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "clients") && !$clients->ClientGroupID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientGroupID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $clients->ClientGroupID->caption() ?>" data-title="<?php echo $clients->ClientGroupID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientGroupID',url:'clientsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="clients" data-field="x_ClientGroupID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $clients->ClientGroupID->displayValueSeparatorAttribute() ?>" name="x_ClientGroupID" id="x_ClientGroupID" value="<?php echo HtmlEncode($clients->ClientGroupID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclientsedit.createAutoSuggest({"id":"x_ClientGroupID","forceSelect":true});
</script>
<?php echo $clients->ClientGroupID->Lookup->getParamTag("p_x_ClientGroupID") ?>
</span>
<?php echo $clients->ClientGroupID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->TitleID->Visible) { // TitleID ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_TitleID" class="form-group row">
		<label id="elh_clients_TitleID" for="x_TitleID" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->TitleID->caption() ?><?php echo ($clients->TitleID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->TitleID->cellAttributes() ?>>
<span id="el_clients_TitleID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="clients" data-field="x_TitleID" data-value-separator="<?php echo $clients->TitleID->displayValueSeparatorAttribute() ?>" id="x_TitleID" name="x_TitleID"<?php echo $clients->TitleID->editAttributes() ?>>
		<?php echo $clients->TitleID->selectOptionListHtml("x_TitleID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "titles") && !$clients->TitleID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_TitleID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $clients->TitleID->caption() ?>" data-title="<?php echo $clients->TitleID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_TitleID',url:'titlesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $clients->TitleID->Lookup->getParamTag("p_x_TitleID") ?>
</span>
<?php echo $clients->TitleID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_TitleID">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_TitleID"><?php echo $clients->TitleID->caption() ?><?php echo ($clients->TitleID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->TitleID->cellAttributes() ?>>
<span id="el_clients_TitleID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="clients" data-field="x_TitleID" data-value-separator="<?php echo $clients->TitleID->displayValueSeparatorAttribute() ?>" id="x_TitleID" name="x_TitleID"<?php echo $clients->TitleID->editAttributes() ?>>
		<?php echo $clients->TitleID->selectOptionListHtml("x_TitleID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "titles") && !$clients->TitleID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_TitleID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $clients->TitleID->caption() ?>" data-title="<?php echo $clients->TitleID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_TitleID',url:'titlesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $clients->TitleID->Lookup->getParamTag("p_x_TitleID") ?>
</span>
<?php echo $clients->TitleID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->FirstName->Visible) { // FirstName ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_FirstName" class="form-group row">
		<label id="elh_clients_FirstName" for="x_FirstName" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->FirstName->caption() ?><?php echo ($clients->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->FirstName->cellAttributes() ?>>
<span id="el_clients_FirstName">
<input type="text" data-table="clients" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->FirstName->getPlaceHolder()) ?>" value="<?php echo $clients->FirstName->EditValue ?>"<?php echo $clients->FirstName->editAttributes() ?>>
</span>
<?php echo $clients->FirstName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_FirstName">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_FirstName"><?php echo $clients->FirstName->caption() ?><?php echo ($clients->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->FirstName->cellAttributes() ?>>
<span id="el_clients_FirstName">
<input type="text" data-table="clients" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->FirstName->getPlaceHolder()) ?>" value="<?php echo $clients->FirstName->EditValue ?>"<?php echo $clients->FirstName->editAttributes() ?>>
</span>
<?php echo $clients->FirstName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->MiddleName->Visible) { // MiddleName ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_MiddleName" class="form-group row">
		<label id="elh_clients_MiddleName" for="x_MiddleName" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->MiddleName->caption() ?><?php echo ($clients->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->MiddleName->cellAttributes() ?>>
<span id="el_clients_MiddleName">
<input type="text" data-table="clients" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($clients->MiddleName->getPlaceHolder()) ?>" value="<?php echo $clients->MiddleName->EditValue ?>"<?php echo $clients->MiddleName->editAttributes() ?>>
</span>
<?php echo $clients->MiddleName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_MiddleName"><?php echo $clients->MiddleName->caption() ?><?php echo ($clients->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->MiddleName->cellAttributes() ?>>
<span id="el_clients_MiddleName">
<input type="text" data-table="clients" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($clients->MiddleName->getPlaceHolder()) ?>" value="<?php echo $clients->MiddleName->EditValue ?>"<?php echo $clients->MiddleName->editAttributes() ?>>
</span>
<?php echo $clients->MiddleName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->LastName->Visible) { // LastName ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_LastName" class="form-group row">
		<label id="elh_clients_LastName" for="x_LastName" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->LastName->caption() ?><?php echo ($clients->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->LastName->cellAttributes() ?>>
<span id="el_clients_LastName">
<input type="text" data-table="clients" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->LastName->getPlaceHolder()) ?>" value="<?php echo $clients->LastName->EditValue ?>"<?php echo $clients->LastName->editAttributes() ?>>
</span>
<?php echo $clients->LastName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LastName">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_LastName"><?php echo $clients->LastName->caption() ?><?php echo ($clients->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->LastName->cellAttributes() ?>>
<span id="el_clients_LastName">
<input type="text" data-table="clients" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->LastName->getPlaceHolder()) ?>" value="<?php echo $clients->LastName->EditValue ?>"<?php echo $clients->LastName->editAttributes() ?>>
</span>
<?php echo $clients->LastName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->PartnersName->Visible) { // PartnersName ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_PartnersName" class="form-group row">
		<label id="elh_clients_PartnersName" for="x_PartnersName" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->PartnersName->caption() ?><?php echo ($clients->PartnersName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->PartnersName->cellAttributes() ?>>
<span id="el_clients_PartnersName">
<input type="text" data-table="clients" data-field="x_PartnersName" name="x_PartnersName" id="x_PartnersName" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($clients->PartnersName->getPlaceHolder()) ?>" value="<?php echo $clients->PartnersName->EditValue ?>"<?php echo $clients->PartnersName->editAttributes() ?>>
</span>
<?php echo $clients->PartnersName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_PartnersName">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_PartnersName"><?php echo $clients->PartnersName->caption() ?><?php echo ($clients->PartnersName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->PartnersName->cellAttributes() ?>>
<span id="el_clients_PartnersName">
<input type="text" data-table="clients" data-field="x_PartnersName" name="x_PartnersName" id="x_PartnersName" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($clients->PartnersName->getPlaceHolder()) ?>" value="<?php echo $clients->PartnersName->EditValue ?>"<?php echo $clients->PartnersName->editAttributes() ?>>
</span>
<?php echo $clients->PartnersName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->CompanyName->Visible) { // CompanyName ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_CompanyName" class="form-group row">
		<label id="elh_clients_CompanyName" for="x_CompanyName" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->CompanyName->caption() ?><?php echo ($clients->CompanyName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->CompanyName->cellAttributes() ?>>
<span id="el_clients_CompanyName">
<input type="text" data-table="clients" data-field="x_CompanyName" name="x_CompanyName" id="x_CompanyName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->CompanyName->getPlaceHolder()) ?>" value="<?php echo $clients->CompanyName->EditValue ?>"<?php echo $clients->CompanyName->editAttributes() ?>>
</span>
<?php echo $clients->CompanyName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CompanyName">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_CompanyName"><?php echo $clients->CompanyName->caption() ?><?php echo ($clients->CompanyName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->CompanyName->cellAttributes() ?>>
<span id="el_clients_CompanyName">
<input type="text" data-table="clients" data-field="x_CompanyName" name="x_CompanyName" id="x_CompanyName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->CompanyName->getPlaceHolder()) ?>" value="<?php echo $clients->CompanyName->EditValue ?>"<?php echo $clients->CompanyName->editAttributes() ?>>
</span>
<?php echo $clients->CompanyName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->ContactPerson->Visible) { // ContactPerson ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_ContactPerson" class="form-group row">
		<label id="elh_clients_ContactPerson" for="x_ContactPerson" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->ContactPerson->caption() ?><?php echo ($clients->ContactPerson->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->ContactPerson->cellAttributes() ?>>
<span id="el_clients_ContactPerson">
<input type="text" data-table="clients" data-field="x_ContactPerson" name="x_ContactPerson" id="x_ContactPerson" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->ContactPerson->getPlaceHolder()) ?>" value="<?php echo $clients->ContactPerson->EditValue ?>"<?php echo $clients->ContactPerson->editAttributes() ?>>
</span>
<?php echo $clients->ContactPerson->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ContactPerson">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_ContactPerson"><?php echo $clients->ContactPerson->caption() ?><?php echo ($clients->ContactPerson->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->ContactPerson->cellAttributes() ?>>
<span id="el_clients_ContactPerson">
<input type="text" data-table="clients" data-field="x_ContactPerson" name="x_ContactPerson" id="x_ContactPerson" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->ContactPerson->getPlaceHolder()) ?>" value="<?php echo $clients->ContactPerson->EditValue ?>"<?php echo $clients->ContactPerson->editAttributes() ?>>
</span>
<?php echo $clients->ContactPerson->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->WorkNature->Visible) { // WorkNature ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_WorkNature" class="form-group row">
		<label id="elh_clients_WorkNature" for="x_WorkNature" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->WorkNature->caption() ?><?php echo ($clients->WorkNature->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->WorkNature->cellAttributes() ?>>
<span id="el_clients_WorkNature">
<input type="text" data-table="clients" data-field="x_WorkNature" name="x_WorkNature" id="x_WorkNature" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->WorkNature->getPlaceHolder()) ?>" value="<?php echo $clients->WorkNature->EditValue ?>"<?php echo $clients->WorkNature->editAttributes() ?>>
</span>
<?php echo $clients->WorkNature->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_WorkNature">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_WorkNature"><?php echo $clients->WorkNature->caption() ?><?php echo ($clients->WorkNature->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->WorkNature->cellAttributes() ?>>
<span id="el_clients_WorkNature">
<input type="text" data-table="clients" data-field="x_WorkNature" name="x_WorkNature" id="x_WorkNature" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->WorkNature->getPlaceHolder()) ?>" value="<?php echo $clients->WorkNature->EditValue ?>"<?php echo $clients->WorkNature->editAttributes() ?>>
</span>
<?php echo $clients->WorkNature->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->JobTitle->Visible) { // JobTitle ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_JobTitle" class="form-group row">
		<label id="elh_clients_JobTitle" for="x_JobTitle" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->JobTitle->caption() ?><?php echo ($clients->JobTitle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->JobTitle->cellAttributes() ?>>
<span id="el_clients_JobTitle">
<input type="text" data-table="clients" data-field="x_JobTitle" name="x_JobTitle" id="x_JobTitle" size="30" maxlength="25" placeholder="<?php echo HtmlEncode($clients->JobTitle->getPlaceHolder()) ?>" value="<?php echo $clients->JobTitle->EditValue ?>"<?php echo $clients->JobTitle->editAttributes() ?>>
</span>
<?php echo $clients->JobTitle->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_JobTitle">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_JobTitle"><?php echo $clients->JobTitle->caption() ?><?php echo ($clients->JobTitle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->JobTitle->cellAttributes() ?>>
<span id="el_clients_JobTitle">
<input type="text" data-table="clients" data-field="x_JobTitle" name="x_JobTitle" id="x_JobTitle" size="30" maxlength="25" placeholder="<?php echo HtmlEncode($clients->JobTitle->getPlaceHolder()) ?>" value="<?php echo $clients->JobTitle->EditValue ?>"<?php echo $clients->JobTitle->editAttributes() ?>>
</span>
<?php echo $clients->JobTitle->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->Photo->Visible) { // Photo ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_Photo" class="form-group row">
		<label id="elh_clients_Photo" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->Photo->caption() ?><?php echo ($clients->Photo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->Photo->cellAttributes() ?>>
<span id="el_clients_Photo">
<div id="fd_x_Photo">
<span title="<?php echo $clients->Photo->title() ? $clients->Photo->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($clients->Photo->ReadOnly || $clients->Photo->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="clients" data-field="x_Photo" name="x_Photo" id="x_Photo"<?php echo $clients->Photo->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_Photo" id= "fn_x_Photo" value="<?php echo $clients->Photo->Upload->FileName ?>">
<?php if (Post("fa_x_Photo") == "0") { ?>
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="1">
<?php } ?>
<input type="hidden" name="fs_x_Photo" id= "fs_x_Photo" value="255">
<input type="hidden" name="fx_x_Photo" id= "fx_x_Photo" value="<?php echo $clients->Photo->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_Photo" id= "fm_x_Photo" value="<?php echo $clients->Photo->UploadMaxFileSize ?>">
</div>
<table id="ft_x_Photo" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $clients->Photo->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Photo">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_Photo"><?php echo $clients->Photo->caption() ?><?php echo ($clients->Photo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->Photo->cellAttributes() ?>>
<span id="el_clients_Photo">
<div id="fd_x_Photo">
<span title="<?php echo $clients->Photo->title() ? $clients->Photo->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($clients->Photo->ReadOnly || $clients->Photo->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="clients" data-field="x_Photo" name="x_Photo" id="x_Photo"<?php echo $clients->Photo->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_Photo" id= "fn_x_Photo" value="<?php echo $clients->Photo->Upload->FileName ?>">
<?php if (Post("fa_x_Photo") == "0") { ?>
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="1">
<?php } ?>
<input type="hidden" name="fs_x_Photo" id= "fs_x_Photo" value="255">
<input type="hidden" name="fx_x_Photo" id= "fx_x_Photo" value="<?php echo $clients->Photo->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_Photo" id= "fm_x_Photo" value="<?php echo $clients->Photo->UploadMaxFileSize ?>">
</div>
<table id="ft_x_Photo" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $clients->Photo->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->BirthDate->Visible) { // BirthDate ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_BirthDate" class="form-group row">
		<label id="elh_clients_BirthDate" for="x_BirthDate" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->BirthDate->caption() ?><?php echo ($clients->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->BirthDate->cellAttributes() ?>>
<span id="el_clients_BirthDate">
<input type="text" data-table="clients" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($clients->BirthDate->getPlaceHolder()) ?>" value="<?php echo $clients->BirthDate->EditValue ?>"<?php echo $clients->BirthDate->editAttributes() ?>>
<?php if (!$clients->BirthDate->ReadOnly && !$clients->BirthDate->Disabled && !isset($clients->BirthDate->EditAttrs["readonly"]) && !isset($clients->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclientsedit", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $clients->BirthDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_BirthDate">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_BirthDate"><?php echo $clients->BirthDate->caption() ?><?php echo ($clients->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->BirthDate->cellAttributes() ?>>
<span id="el_clients_BirthDate">
<input type="text" data-table="clients" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($clients->BirthDate->getPlaceHolder()) ?>" value="<?php echo $clients->BirthDate->EditValue ?>"<?php echo $clients->BirthDate->editAttributes() ?>>
<?php if (!$clients->BirthDate->ReadOnly && !$clients->BirthDate->Disabled && !isset($clients->BirthDate->EditAttrs["readonly"]) && !isset($clients->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclientsedit", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $clients->BirthDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->Gender->Visible) { // Gender ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_Gender" class="form-group row">
		<label id="elh_clients_Gender" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->Gender->caption() ?><?php echo ($clients->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->Gender->cellAttributes() ?>>
<span id="el_clients_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="clients" data-field="x_Gender" data-value-separator="<?php echo $clients->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $clients->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $clients->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php echo $clients->Gender->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Gender">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_Gender"><?php echo $clients->Gender->caption() ?><?php echo ($clients->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->Gender->cellAttributes() ?>>
<span id="el_clients_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="clients" data-field="x_Gender" data-value-separator="<?php echo $clients->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $clients->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $clients->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php echo $clients->Gender->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->Notes->Visible) { // Notes ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_clients_Notes" class="<?php echo $clients_edit->LeftColumnClass ?>"><?php echo $clients->Notes->caption() ?><?php echo ($clients->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients_edit->RightColumnClass ?>"><div<?php echo $clients->Notes->cellAttributes() ?>>
<span id="el_clients_Notes">
<?php AppendClass($clients->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="clients" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($clients->Notes->getPlaceHolder()) ?>"<?php echo $clients->Notes->editAttributes() ?>><?php echo $clients->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fclientsedit", "x_Notes", 35, 4, <?php echo ($clients->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $clients->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $clients_edit->TableLeftColumnClass ?>"><span id="elh_clients_Notes"><?php echo $clients->Notes->caption() ?><?php echo ($clients->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients->Notes->cellAttributes() ?>>
<span id="el_clients_Notes">
<?php AppendClass($clients->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="clients" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($clients->Notes->getPlaceHolder()) ?>"<?php echo $clients->Notes->editAttributes() ?>><?php echo $clients->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fclientsedit", "x_Notes", 35, 4, <?php echo ($clients->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $clients->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients_edit->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<span id="el_clients_ClientID">
<input type="hidden" data-table="clients" data-field="x_ClientID" name="x_ClientID" id="x_ClientID" value="<?php echo HtmlEncode($clients->ClientID->CurrentValue) ?>">
</span>
<?php if ($clients->getCurrentDetailTable() <> "") { ?>
<?php
	$clients_edit->DetailPages->ValidKeys = explode(",", $clients->getCurrentDetailTable());
	$firstActiveDetailTable = $clients_edit->DetailPages->activePageIndex();
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav-tabs" id="clients_edit_details"><!-- tabs -->
	<ul class="<?php echo $clients_edit->DetailPages->navStyle() ?>"><!-- .nav -->
<?php
	if (in_array("cases", explode(",", $clients->getCurrentDetailTable())) && $cases->DetailEdit) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "cases") {
			$firstActiveDetailTable = "cases";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $clients_edit->DetailPages->pageStyle("cases") ?>" href="#tab_cases" data-toggle="tab"><?php echo $Language->TablePhrase("cases", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("clientadditinalinfo", explode(",", $clients->getCurrentDetailTable())) && $clientadditinalinfo->DetailEdit) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientadditinalinfo") {
			$firstActiveDetailTable = "clientadditinalinfo";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $clients_edit->DetailPages->pageStyle("clientadditinalinfo") ?>" href="#tab_clientadditinalinfo" data-toggle="tab"><?php echo $Language->TablePhrase("clientadditinalinfo", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("clientaddress", explode(",", $clients->getCurrentDetailTable())) && $clientaddress->DetailEdit) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientaddress") {
			$firstActiveDetailTable = "clientaddress";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $clients_edit->DetailPages->pageStyle("clientaddress") ?>" href="#tab_clientaddress" data-toggle="tab"><?php echo $Language->TablePhrase("clientaddress", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("clientcontact", explode(",", $clients->getCurrentDetailTable())) && $clientcontact->DetailEdit) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientcontact") {
			$firstActiveDetailTable = "clientcontact";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $clients_edit->DetailPages->pageStyle("clientcontact") ?>" href="#tab_clientcontact" data-toggle="tab"><?php echo $Language->TablePhrase("clientcontact", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("clientpartners", explode(",", $clients->getCurrentDetailTable())) && $clientpartners->DetailEdit) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientpartners") {
			$firstActiveDetailTable = "clientpartners";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $clients_edit->DetailPages->pageStyle("clientpartners") ?>" href="#tab_clientpartners" data-toggle="tab"><?php echo $Language->TablePhrase("clientpartners", "TblCaption") ?></a></li>
<?php
	}
?>
	</ul><!-- /.nav -->
	<div class="tab-content"><!-- .tab-content -->
<?php
	if (in_array("cases", explode(",", $clients->getCurrentDetailTable())) && $cases->DetailEdit) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "cases")
			$firstActiveDetailTable = "cases";
?>
		<div class="tab-pane<?php echo $clients_edit->DetailPages->pageStyle("cases") ?>" id="tab_cases"><!-- page* -->
<?php include_once "casesgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("clientadditinalinfo", explode(",", $clients->getCurrentDetailTable())) && $clientadditinalinfo->DetailEdit) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientadditinalinfo")
			$firstActiveDetailTable = "clientadditinalinfo";
?>
		<div class="tab-pane<?php echo $clients_edit->DetailPages->pageStyle("clientadditinalinfo") ?>" id="tab_clientadditinalinfo"><!-- page* -->
<?php include_once "clientadditinalinfogrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("clientaddress", explode(",", $clients->getCurrentDetailTable())) && $clientaddress->DetailEdit) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientaddress")
			$firstActiveDetailTable = "clientaddress";
?>
		<div class="tab-pane<?php echo $clients_edit->DetailPages->pageStyle("clientaddress") ?>" id="tab_clientaddress"><!-- page* -->
<?php include_once "clientaddressgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("clientcontact", explode(",", $clients->getCurrentDetailTable())) && $clientcontact->DetailEdit) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientcontact")
			$firstActiveDetailTable = "clientcontact";
?>
		<div class="tab-pane<?php echo $clients_edit->DetailPages->pageStyle("clientcontact") ?>" id="tab_clientcontact"><!-- page* -->
<?php include_once "clientcontactgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("clientpartners", explode(",", $clients->getCurrentDetailTable())) && $clientpartners->DetailEdit) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "clientpartners")
			$firstActiveDetailTable = "clientpartners";
?>
		<div class="tab-pane<?php echo $clients_edit->DetailPages->pageStyle("clientpartners") ?>" id="tab_clientpartners"><!-- page* -->
<?php include_once "clientpartnersgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
	</div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
<?php if (!$clients_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $clients_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $clients_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$clients_edit->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
<?php if (!$clients_edit->IsModal) { ?>
<?php if (!isset($clients_edit->Pager)) $clients_edit->Pager = new PrevNextPager($clients_edit->StartRec, $clients_edit->DisplayRecs, $clients_edit->TotalRecs, $clients_edit->AutoHidePager) ?>
<?php if ($clients_edit->Pager->RecordCount > 0 && $clients_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($clients_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $clients_edit->pageUrl() ?>start=<?php echo $clients_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($clients_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $clients_edit->pageUrl() ?>start=<?php echo $clients_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $clients_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($clients_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $clients_edit->pageUrl() ?>start=<?php echo $clients_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($clients_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $clients_edit->pageUrl() ?>start=<?php echo $clients_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $clients_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$clients_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$clients_edit->terminate();
?>
