<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$clients2_add = new clients2_add();

// Run the page
$clients2_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$clients2_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fclients2add = currentForm = new ew.Form("fclients2add", "add");

// Validate form
fclients2add.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($clients2_add->ClientTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->ClientTypeID->caption(), $clients2->ClientTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->ClientGroupID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientGroupID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->ClientGroupID->caption(), $clients2->ClientGroupID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->WorkNature->Required) { ?>
			elm = this.getElements("x" + infix + "_WorkNature");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->WorkNature->caption(), $clients2->WorkNature->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->CompanyName->Required) { ?>
			elm = this.getElements("x" + infix + "_CompanyName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->CompanyName->caption(), $clients2->CompanyName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->TitleID->Required) { ?>
			elm = this.getElements("x" + infix + "_TitleID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->TitleID->caption(), $clients2->TitleID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->FirstName->Required) { ?>
			elm = this.getElements("x" + infix + "_FirstName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->FirstName->caption(), $clients2->FirstName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->MiddleName->Required) { ?>
			elm = this.getElements("x" + infix + "_MiddleName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->MiddleName->caption(), $clients2->MiddleName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->LastName->Required) { ?>
			elm = this.getElements("x" + infix + "_LastName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->LastName->caption(), $clients2->LastName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->PartnersName->Required) { ?>
			elm = this.getElements("x" + infix + "_PartnersName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->PartnersName->caption(), $clients2->PartnersName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->ContactPerson->Required) { ?>
			elm = this.getElements("x" + infix + "_ContactPerson");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->ContactPerson->caption(), $clients2->ContactPerson->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->JobTitle->Required) { ?>
			elm = this.getElements("x" + infix + "_JobTitle");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->JobTitle->caption(), $clients2->JobTitle->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->Photo->Required) { ?>
			felm = this.getElements("x" + infix + "_Photo");
			elm = this.getElements("fn_x" + infix + "_Photo");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $clients2->Photo->caption(), $clients2->Photo->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->BirthDate->Required) { ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->BirthDate->caption(), $clients2->BirthDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($clients2->BirthDate->errorMessage()) ?>");
		<?php if ($clients2_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->Notes->caption(), $clients2->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($clients2_add->Gender->Required) { ?>
			elm = this.getElements("x" + infix + "_Gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $clients2->Gender->caption(), $clients2->Gender->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fclients2add.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclients2add.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclients2add.lists["x_ClientTypeID"] = <?php echo $clients2_add->ClientTypeID->Lookup->toClientList() ?>;
fclients2add.lists["x_ClientTypeID"].options = <?php echo JsonEncode($clients2_add->ClientTypeID->lookupOptions()) ?>;
fclients2add.lists["x_ClientGroupID"] = <?php echo $clients2_add->ClientGroupID->Lookup->toClientList() ?>;
fclients2add.lists["x_ClientGroupID"].options = <?php echo JsonEncode($clients2_add->ClientGroupID->lookupOptions()) ?>;
fclients2add.autoSuggests["x_ClientGroupID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclients2add.lists["x_TitleID"] = <?php echo $clients2_add->TitleID->Lookup->toClientList() ?>;
fclients2add.lists["x_TitleID"].options = <?php echo JsonEncode($clients2_add->TitleID->lookupOptions()) ?>;
fclients2add.lists["x_Gender"] = <?php echo $clients2_add->Gender->Lookup->toClientList() ?>;
fclients2add.lists["x_Gender"].options = <?php echo JsonEncode($clients2_add->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $clients2_add->showPageHeader(); ?>
<?php
$clients2_add->showMessage();
?>
<form name="fclients2add" id="fclients2add" class="<?php echo $clients2_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($clients2_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $clients2_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="clients2">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$clients2_add->IsModal ?>">
<?php if (!$clients2_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_clients2add" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($clients2->ClientTypeID->Visible) { // ClientTypeID ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_ClientTypeID" class="form-group row">
		<label id="elh_clients2_ClientTypeID" for="x_ClientTypeID" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->ClientTypeID->caption() ?><?php echo ($clients2->ClientTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->ClientTypeID->cellAttributes() ?>>
<span id="el_clients2_ClientTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="clients2" data-field="x_ClientTypeID" data-value-separator="<?php echo $clients2->ClientTypeID->displayValueSeparatorAttribute() ?>" id="x_ClientTypeID" name="x_ClientTypeID"<?php echo $clients2->ClientTypeID->editAttributes() ?>>
		<?php echo $clients2->ClientTypeID->selectOptionListHtml("x_ClientTypeID") ?>
	</select>
</div>
<?php echo $clients2->ClientTypeID->Lookup->getParamTag("p_x_ClientTypeID") ?>
</span>
<?php echo $clients2->ClientTypeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientTypeID">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_ClientTypeID"><?php echo $clients2->ClientTypeID->caption() ?><?php echo ($clients2->ClientTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->ClientTypeID->cellAttributes() ?>>
<span id="el_clients2_ClientTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="clients2" data-field="x_ClientTypeID" data-value-separator="<?php echo $clients2->ClientTypeID->displayValueSeparatorAttribute() ?>" id="x_ClientTypeID" name="x_ClientTypeID"<?php echo $clients2->ClientTypeID->editAttributes() ?>>
		<?php echo $clients2->ClientTypeID->selectOptionListHtml("x_ClientTypeID") ?>
	</select>
</div>
<?php echo $clients2->ClientTypeID->Lookup->getParamTag("p_x_ClientTypeID") ?>
</span>
<?php echo $clients2->ClientTypeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->ClientGroupID->Visible) { // ClientGroupID ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_ClientGroupID" class="form-group row">
		<label id="elh_clients2_ClientGroupID" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->ClientGroupID->caption() ?><?php echo ($clients2->ClientGroupID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->ClientGroupID->cellAttributes() ?>>
<span id="el_clients2_ClientGroupID">
<?php
$wrkonchange = "" . trim(@$clients2->ClientGroupID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$clients2->ClientGroupID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientGroupID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientGroupID" id="sv_x_ClientGroupID" value="<?php echo RemoveHtml($clients2->ClientGroupID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($clients2->ClientGroupID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($clients2->ClientGroupID->getPlaceHolder()) ?>"<?php echo $clients2->ClientGroupID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($clients2->ClientGroupID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientGroupID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($clients2->ClientGroupID->ReadOnly || $clients2->ClientGroupID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "clients") && !$clients2->ClientGroupID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientGroupID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $clients2->ClientGroupID->caption() ?>" data-title="<?php echo $clients2->ClientGroupID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientGroupID',url:'clientsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="clients2" data-field="x_ClientGroupID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $clients2->ClientGroupID->displayValueSeparatorAttribute() ?>" name="x_ClientGroupID" id="x_ClientGroupID" value="<?php echo HtmlEncode($clients2->ClientGroupID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclients2add.createAutoSuggest({"id":"x_ClientGroupID","forceSelect":true});
</script>
<?php echo $clients2->ClientGroupID->Lookup->getParamTag("p_x_ClientGroupID") ?>
</span>
<?php echo $clients2->ClientGroupID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientGroupID">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_ClientGroupID"><?php echo $clients2->ClientGroupID->caption() ?><?php echo ($clients2->ClientGroupID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->ClientGroupID->cellAttributes() ?>>
<span id="el_clients2_ClientGroupID">
<?php
$wrkonchange = "" . trim(@$clients2->ClientGroupID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$clients2->ClientGroupID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientGroupID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientGroupID" id="sv_x_ClientGroupID" value="<?php echo RemoveHtml($clients2->ClientGroupID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($clients2->ClientGroupID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($clients2->ClientGroupID->getPlaceHolder()) ?>"<?php echo $clients2->ClientGroupID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($clients2->ClientGroupID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientGroupID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($clients2->ClientGroupID->ReadOnly || $clients2->ClientGroupID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "clients") && !$clients2->ClientGroupID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientGroupID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $clients2->ClientGroupID->caption() ?>" data-title="<?php echo $clients2->ClientGroupID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientGroupID',url:'clientsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="clients2" data-field="x_ClientGroupID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $clients2->ClientGroupID->displayValueSeparatorAttribute() ?>" name="x_ClientGroupID" id="x_ClientGroupID" value="<?php echo HtmlEncode($clients2->ClientGroupID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclients2add.createAutoSuggest({"id":"x_ClientGroupID","forceSelect":true});
</script>
<?php echo $clients2->ClientGroupID->Lookup->getParamTag("p_x_ClientGroupID") ?>
</span>
<?php echo $clients2->ClientGroupID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->WorkNature->Visible) { // WorkNature ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_WorkNature" class="form-group row">
		<label id="elh_clients2_WorkNature" for="x_WorkNature" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->WorkNature->caption() ?><?php echo ($clients2->WorkNature->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->WorkNature->cellAttributes() ?>>
<span id="el_clients2_WorkNature">
<input type="text" data-table="clients2" data-field="x_WorkNature" name="x_WorkNature" id="x_WorkNature" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients2->WorkNature->getPlaceHolder()) ?>" value="<?php echo $clients2->WorkNature->EditValue ?>"<?php echo $clients2->WorkNature->editAttributes() ?>>
</span>
<?php echo $clients2->WorkNature->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_WorkNature">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_WorkNature"><?php echo $clients2->WorkNature->caption() ?><?php echo ($clients2->WorkNature->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->WorkNature->cellAttributes() ?>>
<span id="el_clients2_WorkNature">
<input type="text" data-table="clients2" data-field="x_WorkNature" name="x_WorkNature" id="x_WorkNature" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients2->WorkNature->getPlaceHolder()) ?>" value="<?php echo $clients2->WorkNature->EditValue ?>"<?php echo $clients2->WorkNature->editAttributes() ?>>
</span>
<?php echo $clients2->WorkNature->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->CompanyName->Visible) { // CompanyName ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_CompanyName" class="form-group row">
		<label id="elh_clients2_CompanyName" for="x_CompanyName" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->CompanyName->caption() ?><?php echo ($clients2->CompanyName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->CompanyName->cellAttributes() ?>>
<span id="el_clients2_CompanyName">
<input type="text" data-table="clients2" data-field="x_CompanyName" name="x_CompanyName" id="x_CompanyName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients2->CompanyName->getPlaceHolder()) ?>" value="<?php echo $clients2->CompanyName->EditValue ?>"<?php echo $clients2->CompanyName->editAttributes() ?>>
</span>
<?php echo $clients2->CompanyName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CompanyName">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_CompanyName"><?php echo $clients2->CompanyName->caption() ?><?php echo ($clients2->CompanyName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->CompanyName->cellAttributes() ?>>
<span id="el_clients2_CompanyName">
<input type="text" data-table="clients2" data-field="x_CompanyName" name="x_CompanyName" id="x_CompanyName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients2->CompanyName->getPlaceHolder()) ?>" value="<?php echo $clients2->CompanyName->EditValue ?>"<?php echo $clients2->CompanyName->editAttributes() ?>>
</span>
<?php echo $clients2->CompanyName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->TitleID->Visible) { // TitleID ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_TitleID" class="form-group row">
		<label id="elh_clients2_TitleID" for="x_TitleID" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->TitleID->caption() ?><?php echo ($clients2->TitleID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->TitleID->cellAttributes() ?>>
<span id="el_clients2_TitleID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="clients2" data-field="x_TitleID" data-value-separator="<?php echo $clients2->TitleID->displayValueSeparatorAttribute() ?>" id="x_TitleID" name="x_TitleID"<?php echo $clients2->TitleID->editAttributes() ?>>
		<?php echo $clients2->TitleID->selectOptionListHtml("x_TitleID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "titles") && !$clients2->TitleID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_TitleID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $clients2->TitleID->caption() ?>" data-title="<?php echo $clients2->TitleID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_TitleID',url:'titlesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $clients2->TitleID->Lookup->getParamTag("p_x_TitleID") ?>
</span>
<?php echo $clients2->TitleID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_TitleID">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_TitleID"><?php echo $clients2->TitleID->caption() ?><?php echo ($clients2->TitleID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->TitleID->cellAttributes() ?>>
<span id="el_clients2_TitleID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="clients2" data-field="x_TitleID" data-value-separator="<?php echo $clients2->TitleID->displayValueSeparatorAttribute() ?>" id="x_TitleID" name="x_TitleID"<?php echo $clients2->TitleID->editAttributes() ?>>
		<?php echo $clients2->TitleID->selectOptionListHtml("x_TitleID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "titles") && !$clients2->TitleID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_TitleID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $clients2->TitleID->caption() ?>" data-title="<?php echo $clients2->TitleID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_TitleID',url:'titlesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $clients2->TitleID->Lookup->getParamTag("p_x_TitleID") ?>
</span>
<?php echo $clients2->TitleID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->FirstName->Visible) { // FirstName ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_FirstName" class="form-group row">
		<label id="elh_clients2_FirstName" for="x_FirstName" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->FirstName->caption() ?><?php echo ($clients2->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->FirstName->cellAttributes() ?>>
<span id="el_clients2_FirstName">
<input type="text" data-table="clients2" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients2->FirstName->getPlaceHolder()) ?>" value="<?php echo $clients2->FirstName->EditValue ?>"<?php echo $clients2->FirstName->editAttributes() ?>>
</span>
<?php echo $clients2->FirstName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_FirstName">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_FirstName"><?php echo $clients2->FirstName->caption() ?><?php echo ($clients2->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->FirstName->cellAttributes() ?>>
<span id="el_clients2_FirstName">
<input type="text" data-table="clients2" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients2->FirstName->getPlaceHolder()) ?>" value="<?php echo $clients2->FirstName->EditValue ?>"<?php echo $clients2->FirstName->editAttributes() ?>>
</span>
<?php echo $clients2->FirstName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->MiddleName->Visible) { // MiddleName ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_MiddleName" class="form-group row">
		<label id="elh_clients2_MiddleName" for="x_MiddleName" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->MiddleName->caption() ?><?php echo ($clients2->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->MiddleName->cellAttributes() ?>>
<span id="el_clients2_MiddleName">
<input type="text" data-table="clients2" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($clients2->MiddleName->getPlaceHolder()) ?>" value="<?php echo $clients2->MiddleName->EditValue ?>"<?php echo $clients2->MiddleName->editAttributes() ?>>
</span>
<?php echo $clients2->MiddleName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_MiddleName"><?php echo $clients2->MiddleName->caption() ?><?php echo ($clients2->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->MiddleName->cellAttributes() ?>>
<span id="el_clients2_MiddleName">
<input type="text" data-table="clients2" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($clients2->MiddleName->getPlaceHolder()) ?>" value="<?php echo $clients2->MiddleName->EditValue ?>"<?php echo $clients2->MiddleName->editAttributes() ?>>
</span>
<?php echo $clients2->MiddleName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->LastName->Visible) { // LastName ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_LastName" class="form-group row">
		<label id="elh_clients2_LastName" for="x_LastName" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->LastName->caption() ?><?php echo ($clients2->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->LastName->cellAttributes() ?>>
<span id="el_clients2_LastName">
<input type="text" data-table="clients2" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients2->LastName->getPlaceHolder()) ?>" value="<?php echo $clients2->LastName->EditValue ?>"<?php echo $clients2->LastName->editAttributes() ?>>
</span>
<?php echo $clients2->LastName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LastName">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_LastName"><?php echo $clients2->LastName->caption() ?><?php echo ($clients2->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->LastName->cellAttributes() ?>>
<span id="el_clients2_LastName">
<input type="text" data-table="clients2" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients2->LastName->getPlaceHolder()) ?>" value="<?php echo $clients2->LastName->EditValue ?>"<?php echo $clients2->LastName->editAttributes() ?>>
</span>
<?php echo $clients2->LastName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->PartnersName->Visible) { // PartnersName ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_PartnersName" class="form-group row">
		<label id="elh_clients2_PartnersName" for="x_PartnersName" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->PartnersName->caption() ?><?php echo ($clients2->PartnersName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->PartnersName->cellAttributes() ?>>
<span id="el_clients2_PartnersName">
<input type="text" data-table="clients2" data-field="x_PartnersName" name="x_PartnersName" id="x_PartnersName" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($clients2->PartnersName->getPlaceHolder()) ?>" value="<?php echo $clients2->PartnersName->EditValue ?>"<?php echo $clients2->PartnersName->editAttributes() ?>>
</span>
<?php echo $clients2->PartnersName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_PartnersName">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_PartnersName"><?php echo $clients2->PartnersName->caption() ?><?php echo ($clients2->PartnersName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->PartnersName->cellAttributes() ?>>
<span id="el_clients2_PartnersName">
<input type="text" data-table="clients2" data-field="x_PartnersName" name="x_PartnersName" id="x_PartnersName" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($clients2->PartnersName->getPlaceHolder()) ?>" value="<?php echo $clients2->PartnersName->EditValue ?>"<?php echo $clients2->PartnersName->editAttributes() ?>>
</span>
<?php echo $clients2->PartnersName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->ContactPerson->Visible) { // ContactPerson ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_ContactPerson" class="form-group row">
		<label id="elh_clients2_ContactPerson" for="x_ContactPerson" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->ContactPerson->caption() ?><?php echo ($clients2->ContactPerson->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->ContactPerson->cellAttributes() ?>>
<span id="el_clients2_ContactPerson">
<input type="text" data-table="clients2" data-field="x_ContactPerson" name="x_ContactPerson" id="x_ContactPerson" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients2->ContactPerson->getPlaceHolder()) ?>" value="<?php echo $clients2->ContactPerson->EditValue ?>"<?php echo $clients2->ContactPerson->editAttributes() ?>>
</span>
<?php echo $clients2->ContactPerson->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ContactPerson">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_ContactPerson"><?php echo $clients2->ContactPerson->caption() ?><?php echo ($clients2->ContactPerson->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->ContactPerson->cellAttributes() ?>>
<span id="el_clients2_ContactPerson">
<input type="text" data-table="clients2" data-field="x_ContactPerson" name="x_ContactPerson" id="x_ContactPerson" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients2->ContactPerson->getPlaceHolder()) ?>" value="<?php echo $clients2->ContactPerson->EditValue ?>"<?php echo $clients2->ContactPerson->editAttributes() ?>>
</span>
<?php echo $clients2->ContactPerson->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->JobTitle->Visible) { // JobTitle ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_JobTitle" class="form-group row">
		<label id="elh_clients2_JobTitle" for="x_JobTitle" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->JobTitle->caption() ?><?php echo ($clients2->JobTitle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->JobTitle->cellAttributes() ?>>
<span id="el_clients2_JobTitle">
<input type="text" data-table="clients2" data-field="x_JobTitle" name="x_JobTitle" id="x_JobTitle" size="30" maxlength="25" placeholder="<?php echo HtmlEncode($clients2->JobTitle->getPlaceHolder()) ?>" value="<?php echo $clients2->JobTitle->EditValue ?>"<?php echo $clients2->JobTitle->editAttributes() ?>>
</span>
<?php echo $clients2->JobTitle->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_JobTitle">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_JobTitle"><?php echo $clients2->JobTitle->caption() ?><?php echo ($clients2->JobTitle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->JobTitle->cellAttributes() ?>>
<span id="el_clients2_JobTitle">
<input type="text" data-table="clients2" data-field="x_JobTitle" name="x_JobTitle" id="x_JobTitle" size="30" maxlength="25" placeholder="<?php echo HtmlEncode($clients2->JobTitle->getPlaceHolder()) ?>" value="<?php echo $clients2->JobTitle->EditValue ?>"<?php echo $clients2->JobTitle->editAttributes() ?>>
</span>
<?php echo $clients2->JobTitle->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->Photo->Visible) { // Photo ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_Photo" class="form-group row">
		<label id="elh_clients2_Photo" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->Photo->caption() ?><?php echo ($clients2->Photo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->Photo->cellAttributes() ?>>
<span id="el_clients2_Photo">
<div id="fd_x_Photo">
<span title="<?php echo $clients2->Photo->title() ? $clients2->Photo->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($clients2->Photo->ReadOnly || $clients2->Photo->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="clients2" data-field="x_Photo" name="x_Photo" id="x_Photo"<?php echo $clients2->Photo->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_Photo" id= "fn_x_Photo" value="<?php echo $clients2->Photo->Upload->FileName ?>">
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="0">
<input type="hidden" name="fs_x_Photo" id= "fs_x_Photo" value="255">
<input type="hidden" name="fx_x_Photo" id= "fx_x_Photo" value="<?php echo $clients2->Photo->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_Photo" id= "fm_x_Photo" value="<?php echo $clients2->Photo->UploadMaxFileSize ?>">
</div>
<table id="ft_x_Photo" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $clients2->Photo->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Photo">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_Photo"><?php echo $clients2->Photo->caption() ?><?php echo ($clients2->Photo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->Photo->cellAttributes() ?>>
<span id="el_clients2_Photo">
<div id="fd_x_Photo">
<span title="<?php echo $clients2->Photo->title() ? $clients2->Photo->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($clients2->Photo->ReadOnly || $clients2->Photo->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="clients2" data-field="x_Photo" name="x_Photo" id="x_Photo"<?php echo $clients2->Photo->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_Photo" id= "fn_x_Photo" value="<?php echo $clients2->Photo->Upload->FileName ?>">
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="0">
<input type="hidden" name="fs_x_Photo" id= "fs_x_Photo" value="255">
<input type="hidden" name="fx_x_Photo" id= "fx_x_Photo" value="<?php echo $clients2->Photo->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_Photo" id= "fm_x_Photo" value="<?php echo $clients2->Photo->UploadMaxFileSize ?>">
</div>
<table id="ft_x_Photo" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $clients2->Photo->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->BirthDate->Visible) { // BirthDate ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_BirthDate" class="form-group row">
		<label id="elh_clients2_BirthDate" for="x_BirthDate" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->BirthDate->caption() ?><?php echo ($clients2->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->BirthDate->cellAttributes() ?>>
<span id="el_clients2_BirthDate">
<input type="text" data-table="clients2" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($clients2->BirthDate->getPlaceHolder()) ?>" value="<?php echo $clients2->BirthDate->EditValue ?>"<?php echo $clients2->BirthDate->editAttributes() ?>>
<?php if (!$clients2->BirthDate->ReadOnly && !$clients2->BirthDate->Disabled && !isset($clients2->BirthDate->EditAttrs["readonly"]) && !isset($clients2->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclients2add", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $clients2->BirthDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_BirthDate">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_BirthDate"><?php echo $clients2->BirthDate->caption() ?><?php echo ($clients2->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->BirthDate->cellAttributes() ?>>
<span id="el_clients2_BirthDate">
<input type="text" data-table="clients2" data-field="x_BirthDate" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($clients2->BirthDate->getPlaceHolder()) ?>" value="<?php echo $clients2->BirthDate->EditValue ?>"<?php echo $clients2->BirthDate->editAttributes() ?>>
<?php if (!$clients2->BirthDate->ReadOnly && !$clients2->BirthDate->Disabled && !isset($clients2->BirthDate->EditAttrs["readonly"]) && !isset($clients2->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclients2add", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $clients2->BirthDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->Notes->Visible) { // Notes ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_clients2_Notes" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->Notes->caption() ?><?php echo ($clients2->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->Notes->cellAttributes() ?>>
<span id="el_clients2_Notes">
<?php AppendClass($clients2->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="clients2" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($clients2->Notes->getPlaceHolder()) ?>"<?php echo $clients2->Notes->editAttributes() ?>><?php echo $clients2->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fclients2add", "x_Notes", 35, 4, <?php echo ($clients2->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $clients2->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_Notes"><?php echo $clients2->Notes->caption() ?><?php echo ($clients2->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->Notes->cellAttributes() ?>>
<span id="el_clients2_Notes">
<?php AppendClass($clients2->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="clients2" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($clients2->Notes->getPlaceHolder()) ?>"<?php echo $clients2->Notes->editAttributes() ?>><?php echo $clients2->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fclients2add", "x_Notes", 35, 4, <?php echo ($clients2->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $clients2->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2->Gender->Visible) { // Gender ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
	<div id="r_Gender" class="form-group row">
		<label id="elh_clients2_Gender" class="<?php echo $clients2_add->LeftColumnClass ?>"><?php echo $clients2->Gender->caption() ?><?php echo ($clients2->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $clients2_add->RightColumnClass ?>"><div<?php echo $clients2->Gender->cellAttributes() ?>>
<span id="el_clients2_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="clients2" data-field="x_Gender" data-value-separator="<?php echo $clients2->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $clients2->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $clients2->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php echo $clients2->Gender->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Gender">
		<td class="<?php echo $clients2_add->TableLeftColumnClass ?>"><span id="elh_clients2_Gender"><?php echo $clients2->Gender->caption() ?><?php echo ($clients2->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $clients2->Gender->cellAttributes() ?>>
<span id="el_clients2_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="clients2" data-field="x_Gender" data-value-separator="<?php echo $clients2->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $clients2->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $clients2->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php echo $clients2->Gender->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients2_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$clients2_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $clients2_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $clients2_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$clients2_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$clients2_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$clients2_add->terminate();
?>
