<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class index
{

	// Page ID
	public $PageID = "index";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Page object name
	public $PageObjName = "index";

	// Page headings
	public $Heading = "";
	public $Subheading = "";

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'index');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &GetConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$Breadcrumb;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
		}

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();
		$Breadcrumb = new Breadcrumb();

		// If session expired, show session expired message
		if (Get("expired") == "1")
			$this->setFailureMessage($Language->phrase("SessionExpired"));
		if (!$Security->isLoggedIn())
			$Security->autoLogin();
		$Security->loadUserLevel(); // Load User Level
		if ($Security->allowList(CurrentProjectID() . 'cases'))
			$this->terminate("caseslist.php"); // Exit and go to default page
		if ($Security->allowList(CurrentProjectID() . 'address'))
			$this->terminate("addresslist.php");
		if ($Security->allowList(CurrentProjectID() . 'addresstype'))
			$this->terminate("addresstypelist.php");
		if ($Security->allowList(CurrentProjectID() . 'attachments'))
			$this->terminate("attachmentslist.php");
		if ($Security->allowList(CurrentProjectID() . 'attachmentsource'))
			$this->terminate("attachmentsourcelist.php");
		if ($Security->allowList(CurrentProjectID() . 'audittrail'))
			$this->terminate("audittraillist.php");
		if ($Security->allowList(CurrentProjectID() . 'branches'))
			$this->terminate("brancheslist.php");
		if ($Security->allowList(CurrentProjectID() . 'casestatus'))
			$this->terminate("casestatuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'casetypes'))
			$this->terminate("casetypeslist.php");
		if ($Security->allowList(CurrentProjectID() . 'chambers'))
			$this->terminate("chamberslist.php");
		if ($Security->allowList(CurrentProjectID() . 'cityzenshipstatus'))
			$this->terminate("cityzenshipstatuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'clientadditinalinfo'))
			$this->terminate("clientadditinalinfolist.php");
		if ($Security->allowList(CurrentProjectID() . 'clientpartners'))
			$this->terminate("clientpartnerslist.php");
		if ($Security->allowList(CurrentProjectID() . 'clients'))
			$this->terminate("clientslist.php");
		if ($Security->allowList(CurrentProjectID() . 'contacts'))
			$this->terminate("contactslist.php");
		if ($Security->allowList(CurrentProjectID() . 'contacttype'))
			$this->terminate("contacttypelist.php");
		if ($Security->allowList(CurrentProjectID() . 'courtgender'))
			$this->terminate("courtgenderlist.php");
		if ($Security->allowList(CurrentProjectID() . 'courtlocation'))
			$this->terminate("courtlocationlist.php");
		if ($Security->allowList(CurrentProjectID() . 'courts'))
			$this->terminate("courtslist.php");
		if ($Security->allowList(CurrentProjectID() . 'courtsort'))
			$this->terminate("courtsortlist.php");
		if ($Security->allowList(CurrentProjectID() . 'courttype'))
			$this->terminate("courttypelist.php");
		if ($Security->allowList(CurrentProjectID() . 'employeehr'))
			$this->terminate("employeehrlist.php");
		if ($Security->allowList(CurrentProjectID() . 'employeeperson'))
			$this->terminate("employeepersonlist.php");
		if ($Security->allowList(CurrentProjectID() . 'employees'))
			$this->terminate("employeeslist.php");
		if ($Security->allowList(CurrentProjectID() . 'employeetype'))
			$this->terminate("employeetypelist.php");
		if ($Security->allowList(CurrentProjectID() . 'governorates'))
			$this->terminate("governorateslist.php");
		if ($Security->allowList(CurrentProjectID() . 'hearings'))
			$this->terminate("hearingslist.php");
		if ($Security->allowList(CurrentProjectID() . 'isocountries'))
			$this->terminate("isocountrieslist.php");
		if ($Security->allowList(CurrentProjectID() . 'judges'))
			$this->terminate("judgeslist.php");
		if ($Security->allowList(CurrentProjectID() . 'judgetype'))
			$this->terminate("judgetypelist.php");
		if ($Security->allowList(CurrentProjectID() . 'lawfirm'))
			$this->terminate("lawfirmlist.php");
		if ($Security->allowList(CurrentProjectID() . 'lawyers'))
			$this->terminate("lawyerslist.php");
		if ($Security->allowList(CurrentProjectID() . 'lawyertype'))
			$this->terminate("lawyertypelist.php");
		if ($Security->allowList(CurrentProjectID() . 'litigants'))
			$this->terminate("litigantslist.php");
		if ($Security->allowList(CurrentProjectID() . 'maritalstatus'))
			$this->terminate("maritalstatuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'notices'))
			$this->terminate("noticeslist.php");
		if ($Security->allowList(CurrentProjectID() . 'notifications'))
			$this->terminate("notificationslist.php");
		if ($Security->allowList(CurrentProjectID() . 'partiesstatus'))
			$this->terminate("partiesstatuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'referredby'))
			$this->terminate("referredbylist.php");
		if ($Security->allowList(CurrentProjectID() . 'sections'))
			$this->terminate("sectionslist.php");
		if ($Security->allowList(CurrentProjectID() . 'titles'))
			$this->terminate("titleslist.php");
		if ($Security->allowList(CurrentProjectID() . 'tmp_error'))
			$this->terminate("tmp_errorlist.php");
		if ($Security->allowList(CurrentProjectID() . 'userlevelpermissions'))
			$this->terminate("userlevelpermissionslist.php");
		if ($Security->allowList(CurrentProjectID() . 'userlevels'))
			$this->terminate("userlevelslist.php");
		if ($Security->allowList(CurrentProjectID() . 'users'))
			$this->terminate("userslist.php");
		if ($Security->allowList(CurrentProjectID() . 'users_access'))
			$this->terminate("users_accesslist.php");
		if ($Security->allowList(CurrentProjectID() . 'clientaddress'))
			$this->terminate("clientaddresslist.php");
		if ($Security->allowList(CurrentProjectID() . 'clientcontact'))
			$this->terminate("clientcontactlist.php");
		if ($Security->allowList(CurrentProjectID() . 'courtaddress'))
			$this->terminate("courtaddresslist.php");
		if ($Security->allowList(CurrentProjectID() . 'courtcontact'))
			$this->terminate("courtcontactlist.php");
		if ($Security->allowList(CurrentProjectID() . 'employeeaddress'))
			$this->terminate("employeeaddresslist.php");
		if ($Security->allowList(CurrentProjectID() . 'employeecontact'))
			$this->terminate("employeecontactlist.php");
		if ($Security->allowList(CurrentProjectID() . 'judgeaddress'))
			$this->terminate("judgeaddresslist.php");
		if ($Security->allowList(CurrentProjectID() . 'judgecontact'))
			$this->terminate("judgecontactlist.php");
		if ($Security->allowList(CurrentProjectID() . 'lawyeraddress'))
			$this->terminate("lawyeraddresslist.php");
		if ($Security->allowList(CurrentProjectID() . 'lawyercontact'))
			$this->terminate("lawyercontactlist.php");
		if ($Security->allowList(CurrentProjectID() . 'litigantaddress'))
			$this->terminate("litigantaddresslist.php");
		if ($Security->allowList(CurrentProjectID() . 'litigantcontact'))
			$this->terminate("litigantcontactlist.php");
		if ($Security->allowList(CurrentProjectID() . 'partiestype'))
			$this->terminate("partiestypelist.php");
		if ($Security->allowList(CurrentProjectID() . 'courtsv'))
			$this->terminate("courtsvlist.php");
		if ($Security->allowList(CurrentProjectID() . 'courtgenderv'))
			$this->terminate("courtgendervlist.php");
		if ($Security->allowList(CurrentProjectID() . 'courtlocationv'))
			$this->terminate("courtlocationvlist.php");
		if ($Security->allowList(CurrentProjectID() . 'agenda'))
			$this->terminate("agendalist.php");
		if ($Security->allowList(CurrentProjectID() . 'calendaragenda.php'))
			$this->terminate("./calendaragenda.php");
		if ($Security->allowList(CurrentProjectID() . 'calendarmonth.php'))
			$this->terminate("./calendarmonth.php");
		if ($Security->allowList(CurrentProjectID() . 'calendarweek.php'))
			$this->terminate("./calendarweek.php");
		if ($Security->allowList(CurrentProjectID() . 'employeesaccess'))
			$this->terminate("employeesaccesslist.php");
		if ($Security->allowList(CurrentProjectID() . 'casesort'))
			$this->terminate("casesortlist.php");
		if ($Security->allowList(CurrentProjectID() . 'Courts Report'))
			$this->terminate("Courts_Reportreport.php");
		if ($Security->allowList(CurrentProjectID() . 'files'))
			$this->terminate("fileslist.php");
		if ($Security->allowList(CurrentProjectID() . 'cases2'))
			$this->terminate("cases2list.php");
		if ($Security->allowList(CurrentProjectID() . 'cases report'))
			$this->terminate("_cases_reportlist.php");
		if ($Security->allowList(CurrentProjectID() . 'Cases Report1'))
			$this->terminate("Cases_Report1report.php");
		if ($Security->allowList(CurrentProjectID() . 'complaints'))
			$this->terminate("complaintslist.php");
		if ($Security->allowList(CurrentProjectID() . 'caseslookupv'))
			$this->terminate("caseslookupvlist.php");
		if ($Security->allowList(CurrentProjectID() . 'clients2'))
			$this->terminate("clients2list.php");
		if ($Security->allowList(CurrentProjectID() . 'envelopes'))
			$this->terminate("envelopeslist.php");
		if ($Security->isLoggedIn()) {
			$this->setFailureMessage(DeniedMessage() . "<br><br><a href=\"logout.php\">" . $Language->phrase("BackToLogin") . "</a>");
		} else {
			$this->terminate("login.php"); // Exit and go to login page
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'
	function Message_Showing(&$msg, $type) {

		// Example:
		//if ($type == 'success') $msg = "your success message";

	}
}
?>
