<?php
namespace PHPMaker2019\project_germanos;

/**
 * Table class for hearings
 */
class hearings extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $HearingID;
	public $CaseID;
	public $HearingEn;
	public $HearingDate;
	public $HearingTime;
	public $NextHearingDate;
	public $NextHearingTime;
	public $Hearing;
	public $Notes;
	public $LawyerID;
	public $JudgeID;
	public $LawyerName;
	public $JudgeName;
	public $_UserID;
	public $CreatedBy;
	public $CreatedDate;
	public $UpdatedBy;
	public $UpdatedDate;
	public $ClientID;
	public $LitigantID;
	public $FileNumber;
	public $CaseNumber;
	public $CourtID;
	public $CourtTypeID;
	public $CourtGenderID;
	public $_Case;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'hearings';
		$this->TableName = 'hearings';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`hearings`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = TRUE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "AND";

		// HearingID
		$this->HearingID = new DbField('hearings', 'hearings', 'x_HearingID', 'HearingID', '`HearingID`', '`HearingID`', 3, -1, FALSE, '`HearingID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->HearingID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->HearingID->IsPrimaryKey = TRUE; // Primary key field
		$this->HearingID->Sortable = TRUE; // Allow sort
		$this->HearingID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['HearingID'] = &$this->HearingID;

		// CaseID
		$this->CaseID = new DbField('hearings', 'hearings', 'x_CaseID', 'CaseID', '`CaseID`', '`CaseID`', 3, -1, FALSE, '`EV__CaseID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseID->IsForeignKey = TRUE; // Foreign key field
		$this->CaseID->Nullable = FALSE; // NOT NULL field
		$this->CaseID->Required = TRUE; // Required field
		$this->CaseID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->CaseID->Lookup = new Lookup('CaseID', 'cases', FALSE, 'CaseID', ["Case","FileNumber",null,""], [], [], [], [], ["JudgeID","ClientID","LitigantID","FileNumber","CaseNumber","CourtID","CourtTypeID","CourtGenderID","Case"], ["x_JudgeID","x_ClientID","x_LitigantID","x_FileNumber","x_CaseNumber","x_CourtID","x_CourtTypeID","x_CourtGenderID","x__Case"], '', '');
				break;
			case "en":
				$this->CaseID->Lookup = new Lookup('CaseID', 'cases', FALSE, 'CaseID', ["CaseEn","FileNumber",null,""], [], [], [], [], ["JudgeID","ClientID","LitigantID","FileNumber","CaseNumber","CourtID","CourtTypeID","CourtGenderID","Case"], ["x_JudgeID","x_ClientID","x_LitigantID","x_FileNumber","x_CaseNumber","x_CourtID","x_CourtTypeID","x_CourtGenderID","x__Case"], '', '');
				break;
			case "fr":
				$this->CaseID->Lookup = new Lookup('CaseID', 'cases', FALSE, 'CaseID', ["CaseEn","FileNumber",null,""], [], [], [], [], ["JudgeID","ClientID","LitigantID","FileNumber","CaseNumber","CourtID","CourtTypeID","CourtGenderID","Case"], ["x_JudgeID","x_ClientID","x_LitigantID","x_FileNumber","x_CaseNumber","x_CourtID","x_CourtTypeID","x_CourtGenderID","x__Case"], '', '');
				break;
			default:
				$this->CaseID->Lookup = new Lookup('CaseID', 'cases', FALSE, 'CaseID', ["Case","FileNumber","",""], [], [], [], [], ["JudgeID","ClientID","LitigantID","FileNumber","CaseNumber","CourtID","CourtTypeID","CourtGenderID","Case"], ["x_JudgeID","x_ClientID","x_LitigantID","x_FileNumber","x_CaseNumber","x_CourtID","x_CourtTypeID","x_CourtGenderID","x__Case"], '', '');
				break;
		}
		$this->CaseID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CaseID'] = &$this->CaseID;

		// HearingEn
		$this->HearingEn = new DbField('hearings', 'hearings', 'x_HearingEn', 'HearingEn', '`HearingEn`', '`HearingEn`', 200, -1, FALSE, '`HearingEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->HearingEn->Sortable = FALSE; // Allow sort
		$this->fields['HearingEn'] = &$this->HearingEn;

		// HearingDate
		$this->HearingDate = new DbField('hearings', 'hearings', 'x_HearingDate', 'HearingDate', '`HearingDate`', CastDateFieldForLike('`HearingDate`', 7, "DB"), 133, 7, FALSE, '`HearingDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->HearingDate->Sortable = TRUE; // Allow sort
		$this->HearingDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['HearingDate'] = &$this->HearingDate;

		// HearingTime
		$this->HearingTime = new DbField('hearings', 'hearings', 'x_HearingTime', 'HearingTime', '`HearingTime`', CastDateFieldForLike('`HearingTime`', 4, "DB"), 134, 4, FALSE, '`HearingTime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->HearingTime->Sortable = TRUE; // Allow sort
		$this->HearingTime->DefaultErrorMessage = str_replace("%s", $GLOBALS["TIME_SEPARATOR"], $Language->phrase("IncorrectTime"));
		$this->fields['HearingTime'] = &$this->HearingTime;

		// NextHearingDate
		$this->NextHearingDate = new DbField('hearings', 'hearings', 'x_NextHearingDate', 'NextHearingDate', '`NextHearingDate`', CastDateFieldForLike('`NextHearingDate`', 7, "DB"), 135, 7, FALSE, '`NextHearingDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NextHearingDate->Sortable = TRUE; // Allow sort
		$this->NextHearingDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['NextHearingDate'] = &$this->NextHearingDate;

		// NextHearingTime
		$this->NextHearingTime = new DbField('hearings', 'hearings', 'x_NextHearingTime', 'NextHearingTime', '`NextHearingTime`', CastDateFieldForLike('`NextHearingTime`', 4, "DB"), 134, 4, FALSE, '`NextHearingTime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NextHearingTime->Sortable = TRUE; // Allow sort
		$this->NextHearingTime->DefaultErrorMessage = str_replace("%s", $GLOBALS["TIME_SEPARATOR"], $Language->phrase("IncorrectTime"));
		$this->fields['NextHearingTime'] = &$this->NextHearingTime;

		// Hearing
		$this->Hearing = new DbField('hearings', 'hearings', 'x_Hearing', 'Hearing', '`Hearing`', '`Hearing`', 200, -1, FALSE, '`Hearing`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Hearing->Nullable = FALSE; // NOT NULL field
		$this->Hearing->Required = TRUE; // Required field
		$this->Hearing->Sortable = TRUE; // Allow sort
		$this->fields['Hearing'] = &$this->Hearing;

		// Notes
		$this->Notes = new DbField('hearings', 'hearings', 'x_Notes', 'Notes', '`Notes`', '`Notes`', 201, -1, FALSE, '`Notes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Notes->Sortable = TRUE; // Allow sort
		$this->fields['Notes'] = &$this->Notes;

		// LawyerID
		$this->LawyerID = new DbField('hearings', 'hearings', 'x_LawyerID', 'LawyerID', '`LawyerID`', '`LawyerID`', 3, -1, FALSE, '`LawyerID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->LawyerID->Sortable = TRUE; // Allow sort
		$this->LawyerID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->LawyerID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->LawyerID->Lookup = new Lookup('LawyerID', 'lawyers', FALSE, 'LawyerID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->LawyerID->Lookup = new Lookup('LawyerID', 'lawyers', FALSE, 'LawyerID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->LawyerID->Lookup = new Lookup('LawyerID', 'lawyers', FALSE, 'LawyerID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->LawyerID->Lookup = new Lookup('LawyerID', 'lawyers', FALSE, 'LawyerID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->LawyerID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['LawyerID'] = &$this->LawyerID;

		// JudgeID
		$this->JudgeID = new DbField('hearings', 'hearings', 'x_JudgeID', 'JudgeID', '`JudgeID`', '`JudgeID`', 3, -1, FALSE, '`JudgeID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->JudgeID->Sortable = TRUE; // Allow sort
		$this->JudgeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->JudgeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', FALSE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', FALSE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', FALSE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', FALSE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->JudgeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['JudgeID'] = &$this->JudgeID;

		// LawyerName
		$this->LawyerName = new DbField('hearings', 'hearings', 'x_LawyerName', 'LawyerName', '`LawyerName`', '`LawyerName`', 200, -1, FALSE, '`LawyerName`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->LawyerName->Sortable = FALSE; // Allow sort
		$this->fields['LawyerName'] = &$this->LawyerName;

		// JudgeName
		$this->JudgeName = new DbField('hearings', 'hearings', 'x_JudgeName', 'JudgeName', '`JudgeName`', '`JudgeName`', 200, -1, FALSE, '`JudgeName`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JudgeName->Sortable = FALSE; // Allow sort
		$this->fields['JudgeName'] = &$this->JudgeName;

		// UserID
		$this->_UserID = new DbField('hearings', 'hearings', 'x__UserID', 'UserID', '`UserID`', '`UserID`', 3, -1, FALSE, '`UserID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_UserID->Sortable = FALSE; // Allow sort
		$this->_UserID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['UserID'] = &$this->_UserID;

		// CreatedBy
		$this->CreatedBy = new DbField('hearings', 'hearings', 'x_CreatedBy', 'CreatedBy', '`CreatedBy`', '`CreatedBy`', 200, -1, FALSE, '`CreatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedBy->Sortable = FALSE; // Allow sort
		$this->fields['CreatedBy'] = &$this->CreatedBy;

		// CreatedDate
		$this->CreatedDate = new DbField('hearings', 'hearings', 'x_CreatedDate', 'CreatedDate', '`CreatedDate`', CastDateFieldForLike('`CreatedDate`', 0, "DB"), 135, 0, FALSE, '`CreatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedDate->Sortable = FALSE; // Allow sort
		$this->CreatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['CreatedDate'] = &$this->CreatedDate;

		// UpdatedBy
		$this->UpdatedBy = new DbField('hearings', 'hearings', 'x_UpdatedBy', 'UpdatedBy', '`UpdatedBy`', '`UpdatedBy`', 200, -1, FALSE, '`UpdatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedBy->Sortable = FALSE; // Allow sort
		$this->fields['UpdatedBy'] = &$this->UpdatedBy;

		// UpdatedDate
		$this->UpdatedDate = new DbField('hearings', 'hearings', 'x_UpdatedDate', 'UpdatedDate', '`UpdatedDate`', CastDateFieldForLike('`UpdatedDate`', 0, "DB"), 135, 0, FALSE, '`UpdatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedDate->Sortable = FALSE; // Allow sort
		$this->UpdatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['UpdatedDate'] = &$this->UpdatedDate;

		// ClientID
		$this->ClientID = new DbField('hearings', 'hearings', 'x_ClientID', 'ClientID', '`ClientID`', '`ClientID`', 3, -1, FALSE, '`ClientID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->ClientID->Sortable = FALSE; // Allow sort
		$this->ClientID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ClientID'] = &$this->ClientID;

		// LitigantID
		$this->LitigantID = new DbField('hearings', 'hearings', 'x_LitigantID', 'LitigantID', '`LitigantID`', '`LitigantID`', 3, -1, FALSE, '`LitigantID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->LitigantID->Sortable = FALSE; // Allow sort
		$this->LitigantID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['LitigantID'] = &$this->LitigantID;

		// FileNumber
		$this->FileNumber = new DbField('hearings', 'hearings', 'x_FileNumber', 'FileNumber', '`FileNumber`', '`FileNumber`', 200, -1, FALSE, '`FileNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->FileNumber->Sortable = FALSE; // Allow sort
		$this->fields['FileNumber'] = &$this->FileNumber;

		// CaseNumber
		$this->CaseNumber = new DbField('hearings', 'hearings', 'x_CaseNumber', 'CaseNumber', '`CaseNumber`', '`CaseNumber`', 200, -1, FALSE, '`CaseNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->CaseNumber->Sortable = TRUE; // Allow sort
		$this->fields['CaseNumber'] = &$this->CaseNumber;

		// CourtID
		$this->CourtID = new DbField('hearings', 'hearings', 'x_CourtID', 'CourtID', '`CourtID`', '`CourtID`', 3, -1, FALSE, '`EV__CourtID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtID'] = &$this->CourtID;

		// CourtTypeID
		$this->CourtTypeID = new DbField('hearings', 'hearings', 'x_CourtTypeID', 'CourtTypeID', '`CourtTypeID`', '`CourtTypeID`', 3, -1, FALSE, '`CourtTypeID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->CourtTypeID->Sortable = FALSE; // Allow sort
		$this->CourtTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtTypeID'] = &$this->CourtTypeID;

		// CourtGenderID
		$this->CourtGenderID = new DbField('hearings', 'hearings', 'x_CourtGenderID', 'CourtGenderID', '`CourtGenderID`', '`CourtGenderID`', 3, -1, FALSE, '`CourtGenderID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->CourtGenderID->Sortable = FALSE; // Allow sort
		$this->CourtGenderID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtGenderID'] = &$this->CourtGenderID;

		// Case
		$this->_Case = new DbField('hearings', 'hearings', 'x__Case', 'Case', '`Case`', '`Case`', 200, -1, FALSE, '`Case`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->_Case->Sortable = FALSE; // Allow sort
		$this->fields['Case'] = &$this->_Case;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "cases") {
			if ($this->CaseID->getSessionValue() <> "")
				$masterFilter .= "`CaseID`=" . QuotedValue($this->CaseID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "cases") {
			if ($this->CaseID->getSessionValue() <> "")
				$detailFilter .= "`CaseID`=" . QuotedValue($this->CaseID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_cases()
	{
		return "`CaseID`=@CaseID@";
	}

	// Detail filter
	public function sqlDetailFilter_cases()
	{
		return "`CaseID`=@CaseID@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`hearings`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		global $CurrentLanguage;
		switch ($CurrentLanguage) {
			case "ar":
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT CONCAT(COALESCE(`Case`, ''),'" . ValueSeparator(1, $this->CaseID) . "',COALESCE(`FileNumber`,'')) FROM `cases` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseID` = `hearings`.`CaseID` LIMIT 1) AS `EV__CaseID`, (SELECT DISTINCT `Court` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `hearings`.`CourtID` LIMIT 1) AS `EV__CourtID` FROM `hearings`" .
					") `TMP_TABLE`";
				break;
			case "en":
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT CONCAT(COALESCE(`CaseEn`, ''),'" . ValueSeparator(1, $this->CaseID) . "',COALESCE(`FileNumber`,'')) FROM `cases` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseID` = `hearings`.`CaseID` LIMIT 1) AS `EV__CaseID`, (SELECT DISTINCT `Court` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `hearings`.`CourtID` LIMIT 1) AS `EV__CourtID` FROM `hearings`" .
					") `TMP_TABLE`";
				break;
			case "fr":
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT CONCAT(COALESCE(`CaseEn`, ''),'" . ValueSeparator(1, $this->CaseID) . "',COALESCE(`FileNumber`,'')) FROM `cases` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseID` = `hearings`.`CaseID` LIMIT 1) AS `EV__CaseID`, (SELECT DISTINCT `Court` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `hearings`.`CourtID` LIMIT 1) AS `EV__CourtID` FROM `hearings`" .
					") `TMP_TABLE`";
				break;
			default:
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT CONCAT(COALESCE(`Case`, ''),'" . ValueSeparator(1, $this->CaseID) . "',COALESCE(`FileNumber`,'')) FROM `cases` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseID` = `hearings`.`CaseID` LIMIT 1) AS `EV__CaseID`, (SELECT DISTINCT `Court` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `hearings`.`CourtID` LIMIT 1) AS `EV__CourtID` FROM `hearings`" .
					") `TMP_TABLE`";
				break;
		}
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->CaseID->AdvancedSearch->SearchValue <> "" ||
			$this->CaseID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CaseID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CaseID->VirtualExpression . " "))
			return TRUE;
		if ($this->CourtID->AdvancedSearch->SearchValue <> "" ||
			$this->CourtID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CourtID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CourtID->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->HearingID->setDbValue($conn->insert_ID());
			$rs['HearingID'] = $this->HearingID->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'HearingID';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('HearingID', $rs))
				AddFilter($where, QuotedName('HearingID', $this->Dbid) . '=' . QuotedValue($rs['HearingID'], $this->HearingID->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->HearingID->DbValue = $row['HearingID'];
		$this->CaseID->DbValue = $row['CaseID'];
		$this->HearingEn->DbValue = $row['HearingEn'];
		$this->HearingDate->DbValue = $row['HearingDate'];
		$this->HearingTime->DbValue = $row['HearingTime'];
		$this->NextHearingDate->DbValue = $row['NextHearingDate'];
		$this->NextHearingTime->DbValue = $row['NextHearingTime'];
		$this->Hearing->DbValue = $row['Hearing'];
		$this->Notes->DbValue = $row['Notes'];
		$this->LawyerID->DbValue = $row['LawyerID'];
		$this->JudgeID->DbValue = $row['JudgeID'];
		$this->LawyerName->DbValue = $row['LawyerName'];
		$this->JudgeName->DbValue = $row['JudgeName'];
		$this->_UserID->DbValue = $row['UserID'];
		$this->CreatedBy->DbValue = $row['CreatedBy'];
		$this->CreatedDate->DbValue = $row['CreatedDate'];
		$this->UpdatedBy->DbValue = $row['UpdatedBy'];
		$this->UpdatedDate->DbValue = $row['UpdatedDate'];
		$this->ClientID->DbValue = $row['ClientID'];
		$this->LitigantID->DbValue = $row['LitigantID'];
		$this->FileNumber->DbValue = $row['FileNumber'];
		$this->CaseNumber->DbValue = $row['CaseNumber'];
		$this->CourtID->DbValue = $row['CourtID'];
		$this->CourtTypeID->DbValue = $row['CourtTypeID'];
		$this->CourtGenderID->DbValue = $row['CourtGenderID'];
		$this->_Case->DbValue = $row['Case'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`HearingID` = @HearingID@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('HearingID', $row) ? $row['HearingID'] : NULL) : $this->HearingID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@HearingID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "hearingslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "hearingsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "hearingsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "hearingsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "hearingslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("hearingsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("hearingsview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "hearingsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "hearingsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("hearingsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("hearingsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("hearingsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "cases" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_CaseID=" . urlencode($this->CaseID->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "HearingID:" . JsonEncode($this->HearingID->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->HearingID->CurrentValue != NULL) {
			$url .= "HearingID=" . urlencode($this->HearingID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("HearingID") !== NULL)
				$arKeys[] = Param("HearingID");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->HearingID->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->HearingID->setDbValue($rs->fields('HearingID'));
		$this->CaseID->setDbValue($rs->fields('CaseID'));
		$this->HearingEn->setDbValue($rs->fields('HearingEn'));
		$this->HearingDate->setDbValue($rs->fields('HearingDate'));
		$this->HearingTime->setDbValue($rs->fields('HearingTime'));
		$this->NextHearingDate->setDbValue($rs->fields('NextHearingDate'));
		$this->NextHearingTime->setDbValue($rs->fields('NextHearingTime'));
		$this->Hearing->setDbValue($rs->fields('Hearing'));
		$this->Notes->setDbValue($rs->fields('Notes'));
		$this->LawyerID->setDbValue($rs->fields('LawyerID'));
		$this->JudgeID->setDbValue($rs->fields('JudgeID'));
		$this->LawyerName->setDbValue($rs->fields('LawyerName'));
		$this->JudgeName->setDbValue($rs->fields('JudgeName'));
		$this->_UserID->setDbValue($rs->fields('UserID'));
		$this->CreatedBy->setDbValue($rs->fields('CreatedBy'));
		$this->CreatedDate->setDbValue($rs->fields('CreatedDate'));
		$this->UpdatedBy->setDbValue($rs->fields('UpdatedBy'));
		$this->UpdatedDate->setDbValue($rs->fields('UpdatedDate'));
		$this->ClientID->setDbValue($rs->fields('ClientID'));
		$this->LitigantID->setDbValue($rs->fields('LitigantID'));
		$this->FileNumber->setDbValue($rs->fields('FileNumber'));
		$this->CaseNumber->setDbValue($rs->fields('CaseNumber'));
		$this->CourtID->setDbValue($rs->fields('CourtID'));
		$this->CourtTypeID->setDbValue($rs->fields('CourtTypeID'));
		$this->CourtGenderID->setDbValue($rs->fields('CourtGenderID'));
		$this->_Case->setDbValue($rs->fields('Case'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// HearingID
		// CaseID

		$this->CaseID->CellCssStyle = "min-width: 200px;";

		// HearingEn
		$this->HearingEn->CellCssStyle = "white-space: nowrap;";

		// HearingDate
		// HearingTime
		// NextHearingDate
		// NextHearingTime
		// Hearing

		$this->Hearing->CellCssStyle = "min-width: 100px;";

		// Notes
		$this->Notes->CellCssStyle = "min-width: 200px;";

		// LawyerID
		// JudgeID
		// LawyerName

		$this->LawyerName->CellCssStyle = "white-space: nowrap;";

		// JudgeName
		$this->JudgeName->CellCssStyle = "white-space: nowrap;";

		// UserID
		$this->_UserID->CellCssStyle = "white-space: nowrap;";

		// CreatedBy
		$this->CreatedBy->CellCssStyle = "white-space: nowrap;";

		// CreatedDate
		$this->CreatedDate->CellCssStyle = "white-space: nowrap;";

		// UpdatedBy
		$this->UpdatedBy->CellCssStyle = "white-space: nowrap;";

		// UpdatedDate
		$this->UpdatedDate->CellCssStyle = "white-space: nowrap;";

		// ClientID
		$this->ClientID->CellCssStyle = "white-space: nowrap;";

		// LitigantID
		$this->LitigantID->CellCssStyle = "white-space: nowrap;";

		// FileNumber
		$this->FileNumber->CellCssStyle = "white-space: nowrap;";

		// CaseNumber
		// CourtID

		$this->CourtID->CellCssStyle = "white-space: nowrap;";

		// CourtTypeID
		$this->CourtTypeID->CellCssStyle = "white-space: nowrap;";

		// CourtGenderID
		$this->CourtGenderID->CellCssStyle = "white-space: nowrap;";

		// Case
		$this->_Case->CellCssStyle = "white-space: nowrap;";

		// HearingID
		$this->HearingID->ViewValue = $this->HearingID->CurrentValue;
		$this->HearingID->ViewCustomAttributes = "";

		// CaseID
		if ($this->CaseID->VirtualValue <> "") {
			$this->CaseID->ViewValue = $this->CaseID->VirtualValue;
		} else {
			$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
		$curVal = strval($this->CaseID->CurrentValue);
		if ($curVal <> "") {
			$this->CaseID->ViewValue = $this->CaseID->lookupCacheOption($curVal);
			if ($this->CaseID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CaseID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CaseID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->CaseID->ViewValue = $this->CaseID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
				}
			}
		} else {
			$this->CaseID->ViewValue = NULL;
		}
		}
		$this->CaseID->ViewCustomAttributes = "";

		// HearingEn
		$this->HearingEn->ViewValue = $this->HearingEn->CurrentValue;
		$this->HearingEn->ViewCustomAttributes = "";

		// HearingDate
		$this->HearingDate->ViewValue = $this->HearingDate->CurrentValue;
		$this->HearingDate->ViewValue = FormatDateTime($this->HearingDate->ViewValue, 7);
		$this->HearingDate->ViewCustomAttributes = "";

		// HearingTime
		$this->HearingTime->ViewValue = $this->HearingTime->CurrentValue;
		$this->HearingTime->ViewValue = FormatDateTime($this->HearingTime->ViewValue, 4);
		$this->HearingTime->ViewCustomAttributes = "";

		// NextHearingDate
		$this->NextHearingDate->ViewValue = $this->NextHearingDate->CurrentValue;
		$this->NextHearingDate->ViewValue = FormatDateTime($this->NextHearingDate->ViewValue, 7);
		$this->NextHearingDate->ViewCustomAttributes = "";

		// NextHearingTime
		$this->NextHearingTime->ViewValue = $this->NextHearingTime->CurrentValue;
		$this->NextHearingTime->ViewValue = FormatDateTime($this->NextHearingTime->ViewValue, 4);
		$this->NextHearingTime->ViewCustomAttributes = "";

		// Hearing
		$this->Hearing->ViewValue = $this->Hearing->CurrentValue;
		$this->Hearing->ViewCustomAttributes = "";

		// Notes
		$this->Notes->ViewValue = $this->Notes->CurrentValue;
		$this->Notes->ViewCustomAttributes = "";

		// LawyerID
		$curVal = strval($this->LawyerID->CurrentValue);
		if ($curVal <> "") {
			$this->LawyerID->ViewValue = $this->LawyerID->lookupCacheOption($curVal);
			if ($this->LawyerID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`LawyerID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->LawyerID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->LawyerID->ViewValue = $this->LawyerID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->LawyerID->ViewValue = $this->LawyerID->CurrentValue;
				}
			}
		} else {
			$this->LawyerID->ViewValue = NULL;
		}
		$this->LawyerID->ViewCustomAttributes = "";

		// JudgeID
		$curVal = strval($this->JudgeID->CurrentValue);
		if ($curVal <> "") {
			$this->JudgeID->ViewValue = $this->JudgeID->lookupCacheOption($curVal);
			if ($this->JudgeID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`JudgeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->JudgeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->JudgeID->ViewValue = $this->JudgeID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->JudgeID->ViewValue = $this->JudgeID->CurrentValue;
				}
			}
		} else {
			$this->JudgeID->ViewValue = NULL;
		}
		$this->JudgeID->ViewCustomAttributes = "";

		// LawyerName
		$this->LawyerName->ViewValue = $this->LawyerName->CurrentValue;
		$this->LawyerName->ViewCustomAttributes = "";

		// JudgeName
		$this->JudgeName->ViewValue = $this->JudgeName->CurrentValue;
		$this->JudgeName->ViewCustomAttributes = "";

		// UserID
		$this->_UserID->ViewValue = $this->_UserID->CurrentValue;
		$this->_UserID->ViewValue = FormatNumber($this->_UserID->ViewValue, 0, -2, -2, -2);
		$this->_UserID->ViewCustomAttributes = "";

		// CreatedBy
		$this->CreatedBy->ViewValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->ViewCustomAttributes = "";

		// CreatedDate
		$this->CreatedDate->ViewValue = $this->CreatedDate->CurrentValue;
		$this->CreatedDate->ViewValue = FormatDateTime($this->CreatedDate->ViewValue, 0);
		$this->CreatedDate->ViewCustomAttributes = "";

		// UpdatedBy
		$this->UpdatedBy->ViewValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->ViewCustomAttributes = "";

		// UpdatedDate
		$this->UpdatedDate->ViewValue = $this->UpdatedDate->CurrentValue;
		$this->UpdatedDate->ViewValue = FormatDateTime($this->UpdatedDate->ViewValue, 0);
		$this->UpdatedDate->ViewCustomAttributes = "";

		// ClientID
		$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
		$this->ClientID->ViewValue = FormatNumber($this->ClientID->ViewValue, 0, -2, -2, -2);
		$this->ClientID->ViewCustomAttributes = "";

		// LitigantID
		$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
		$this->LitigantID->ViewValue = FormatNumber($this->LitigantID->ViewValue, 0, -2, -2, -2);
		$this->LitigantID->ViewCustomAttributes = "";

		// FileNumber
		$this->FileNumber->ViewValue = $this->FileNumber->CurrentValue;
		$this->FileNumber->ViewCustomAttributes = "";

		// CaseNumber
		$this->CaseNumber->ViewValue = $this->CaseNumber->CurrentValue;
		$this->CaseNumber->ViewCustomAttributes = "";

		// CourtID
		if ($this->CourtID->VirtualValue <> "") {
			$this->CourtID->ViewValue = $this->CourtID->VirtualValue;
		} else {
			$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
		$curVal = strval($this->CourtID->CurrentValue);
		if ($curVal <> "") {
			$this->CourtID->ViewValue = $this->CourtID->lookupCacheOption($curVal);
			if ($this->CourtID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CourtID->ViewValue = $this->CourtID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
				}
			}
		} else {
			$this->CourtID->ViewValue = NULL;
		}
		}
		$this->CourtID->ViewCustomAttributes = "";

		// CourtTypeID
		$this->CourtTypeID->ViewValue = $this->CourtTypeID->CurrentValue;
		$this->CourtTypeID->ViewValue = FormatNumber($this->CourtTypeID->ViewValue, 0, -2, -2, -2);
		$this->CourtTypeID->ViewCustomAttributes = "";

		// CourtGenderID
		$this->CourtGenderID->ViewValue = $this->CourtGenderID->CurrentValue;
		$this->CourtGenderID->ViewValue = FormatNumber($this->CourtGenderID->ViewValue, 0, -2, -2, -2);
		$this->CourtGenderID->ViewCustomAttributes = "";

		// Case
		$this->_Case->ViewValue = $this->_Case->CurrentValue;
		$this->_Case->ViewCustomAttributes = "";

		// HearingID
		$this->HearingID->LinkCustomAttributes = "";
		$this->HearingID->HrefValue = "";
		$this->HearingID->TooltipValue = "";

		// CaseID
		$this->CaseID->LinkCustomAttributes = "";
		$this->CaseID->HrefValue = "";
		$this->CaseID->TooltipValue = "";

		// HearingEn
		$this->HearingEn->LinkCustomAttributes = "";
		$this->HearingEn->HrefValue = "";
		$this->HearingEn->TooltipValue = "";

		// HearingDate
		$this->HearingDate->LinkCustomAttributes = "";
		$this->HearingDate->HrefValue = "";
		$this->HearingDate->TooltipValue = "";

		// HearingTime
		$this->HearingTime->LinkCustomAttributes = "";
		$this->HearingTime->HrefValue = "";
		$this->HearingTime->TooltipValue = "";

		// NextHearingDate
		$this->NextHearingDate->LinkCustomAttributes = "";
		$this->NextHearingDate->HrefValue = "";
		$this->NextHearingDate->TooltipValue = "";

		// NextHearingTime
		$this->NextHearingTime->LinkCustomAttributes = "";
		$this->NextHearingTime->HrefValue = "";
		$this->NextHearingTime->TooltipValue = "";

		// Hearing
		$this->Hearing->LinkCustomAttributes = "";
		$this->Hearing->HrefValue = "";
		$this->Hearing->TooltipValue = "";

		// Notes
		$this->Notes->LinkCustomAttributes = "";
		$this->Notes->HrefValue = "";
		$this->Notes->TooltipValue = "";

		// LawyerID
		$this->LawyerID->LinkCustomAttributes = "";
		$this->LawyerID->HrefValue = "";
		$this->LawyerID->TooltipValue = "";

		// JudgeID
		$this->JudgeID->LinkCustomAttributes = "";
		$this->JudgeID->HrefValue = "";
		$this->JudgeID->TooltipValue = "";

		// LawyerName
		$this->LawyerName->LinkCustomAttributes = "";
		$this->LawyerName->HrefValue = "";
		$this->LawyerName->TooltipValue = "";

		// JudgeName
		$this->JudgeName->LinkCustomAttributes = "";
		$this->JudgeName->HrefValue = "";
		$this->JudgeName->TooltipValue = "";

		// UserID
		$this->_UserID->LinkCustomAttributes = "";
		$this->_UserID->HrefValue = "";
		$this->_UserID->TooltipValue = "";

		// CreatedBy
		$this->CreatedBy->LinkCustomAttributes = "";
		$this->CreatedBy->HrefValue = "";
		$this->CreatedBy->TooltipValue = "";

		// CreatedDate
		$this->CreatedDate->LinkCustomAttributes = "";
		$this->CreatedDate->HrefValue = "";
		$this->CreatedDate->TooltipValue = "";

		// UpdatedBy
		$this->UpdatedBy->LinkCustomAttributes = "";
		$this->UpdatedBy->HrefValue = "";
		$this->UpdatedBy->TooltipValue = "";

		// UpdatedDate
		$this->UpdatedDate->LinkCustomAttributes = "";
		$this->UpdatedDate->HrefValue = "";
		$this->UpdatedDate->TooltipValue = "";

		// ClientID
		$this->ClientID->LinkCustomAttributes = "";
		$this->ClientID->HrefValue = "";
		$this->ClientID->TooltipValue = "";

		// LitigantID
		$this->LitigantID->LinkCustomAttributes = "";
		$this->LitigantID->HrefValue = "";
		$this->LitigantID->TooltipValue = "";

		// FileNumber
		$this->FileNumber->LinkCustomAttributes = "";
		$this->FileNumber->HrefValue = "";
		$this->FileNumber->TooltipValue = "";

		// CaseNumber
		$this->CaseNumber->LinkCustomAttributes = "";
		$this->CaseNumber->HrefValue = "";
		$this->CaseNumber->TooltipValue = "";

		// CourtID
		$this->CourtID->LinkCustomAttributes = "";
		$this->CourtID->HrefValue = "";
		$this->CourtID->TooltipValue = "";

		// CourtTypeID
		$this->CourtTypeID->LinkCustomAttributes = "";
		$this->CourtTypeID->HrefValue = "";
		$this->CourtTypeID->TooltipValue = "";

		// CourtGenderID
		$this->CourtGenderID->LinkCustomAttributes = "";
		$this->CourtGenderID->HrefValue = "";
		$this->CourtGenderID->TooltipValue = "";

		// Case
		$this->_Case->LinkCustomAttributes = "";
		$this->_Case->HrefValue = "";
		$this->_Case->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// HearingID
		$this->HearingID->EditAttrs["class"] = "form-control";
		$this->HearingID->EditCustomAttributes = "";

		// CaseID
		$this->CaseID->EditAttrs["class"] = "form-control";
		$this->CaseID->EditCustomAttributes = "";
		if ($this->CaseID->getSessionValue() <> "") {
			$this->CaseID->CurrentValue = $this->CaseID->getSessionValue();
		if ($this->CaseID->VirtualValue <> "") {
			$this->CaseID->ViewValue = $this->CaseID->VirtualValue;
		} else {
			$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
		$curVal = strval($this->CaseID->CurrentValue);
		if ($curVal <> "") {
			$this->CaseID->ViewValue = $this->CaseID->lookupCacheOption($curVal);
			if ($this->CaseID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CaseID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CaseID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->CaseID->ViewValue = $this->CaseID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
				}
			}
		} else {
			$this->CaseID->ViewValue = NULL;
		}
		}
		$this->CaseID->ViewCustomAttributes = "";
		} else {
		$this->CaseID->EditValue = $this->CaseID->CurrentValue;
		$this->CaseID->PlaceHolder = RemoveHtml($this->CaseID->caption());
		}

		// HearingEn
		$this->HearingEn->EditAttrs["class"] = "form-control";
		$this->HearingEn->EditCustomAttributes = "";
		$this->HearingEn->EditValue = $this->HearingEn->CurrentValue;
		$this->HearingEn->PlaceHolder = RemoveHtml($this->HearingEn->caption());

		// HearingDate
		$this->HearingDate->EditAttrs["class"] = "form-control";
		$this->HearingDate->EditCustomAttributes = "";
		$this->HearingDate->EditValue = FormatDateTime($this->HearingDate->CurrentValue, 7);
		$this->HearingDate->PlaceHolder = RemoveHtml($this->HearingDate->caption());

		// HearingTime
		$this->HearingTime->EditAttrs["class"] = "form-control";
		$this->HearingTime->EditCustomAttributes = "";
		$this->HearingTime->EditValue = $this->HearingTime->CurrentValue;
		$this->HearingTime->PlaceHolder = RemoveHtml($this->HearingTime->caption());

		// NextHearingDate
		$this->NextHearingDate->EditAttrs["class"] = "form-control";
		$this->NextHearingDate->EditCustomAttributes = "";
		$this->NextHearingDate->EditValue = FormatDateTime($this->NextHearingDate->CurrentValue, 7);
		$this->NextHearingDate->PlaceHolder = RemoveHtml($this->NextHearingDate->caption());

		// NextHearingTime
		$this->NextHearingTime->EditAttrs["class"] = "form-control";
		$this->NextHearingTime->EditCustomAttributes = "";
		$this->NextHearingTime->EditValue = $this->NextHearingTime->CurrentValue;
		$this->NextHearingTime->PlaceHolder = RemoveHtml($this->NextHearingTime->caption());

		// Hearing
		$this->Hearing->EditAttrs["class"] = "form-control";
		$this->Hearing->EditCustomAttributes = "";
		$this->Hearing->EditValue = $this->Hearing->CurrentValue;
		$this->Hearing->PlaceHolder = RemoveHtml($this->Hearing->caption());

		// Notes
		$this->Notes->EditAttrs["class"] = "form-control";
		$this->Notes->EditCustomAttributes = "";
		$this->Notes->EditValue = $this->Notes->CurrentValue;
		$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

		// LawyerID
		$this->LawyerID->EditAttrs["class"] = "form-control";
		$this->LawyerID->EditCustomAttributes = "";

		// JudgeID
		$this->JudgeID->EditAttrs["class"] = "form-control";
		$this->JudgeID->EditCustomAttributes = "";

		// LawyerName
		$this->LawyerName->EditAttrs["class"] = "form-control";
		$this->LawyerName->EditCustomAttributes = "";
		$this->LawyerName->EditValue = $this->LawyerName->CurrentValue;
		$this->LawyerName->PlaceHolder = RemoveHtml($this->LawyerName->caption());

		// JudgeName
		$this->JudgeName->EditAttrs["class"] = "form-control";
		$this->JudgeName->EditCustomAttributes = "";
		$this->JudgeName->EditValue = $this->JudgeName->CurrentValue;
		$this->JudgeName->PlaceHolder = RemoveHtml($this->JudgeName->caption());

		// UserID
		$this->_UserID->EditAttrs["class"] = "form-control";
		$this->_UserID->EditCustomAttributes = "";
		$this->_UserID->EditValue = $this->_UserID->CurrentValue;
		$this->_UserID->PlaceHolder = RemoveHtml($this->_UserID->caption());

		// CreatedBy
		$this->CreatedBy->EditAttrs["class"] = "form-control";
		$this->CreatedBy->EditCustomAttributes = "";
		$this->CreatedBy->EditValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->PlaceHolder = RemoveHtml($this->CreatedBy->caption());

		// CreatedDate
		$this->CreatedDate->EditAttrs["class"] = "form-control";
		$this->CreatedDate->EditCustomAttributes = "";
		$this->CreatedDate->EditValue = FormatDateTime($this->CreatedDate->CurrentValue, 8);
		$this->CreatedDate->PlaceHolder = RemoveHtml($this->CreatedDate->caption());

		// UpdatedBy
		$this->UpdatedBy->EditAttrs["class"] = "form-control";
		$this->UpdatedBy->EditCustomAttributes = "";
		$this->UpdatedBy->EditValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->PlaceHolder = RemoveHtml($this->UpdatedBy->caption());

		// UpdatedDate
		$this->UpdatedDate->EditAttrs["class"] = "form-control";
		$this->UpdatedDate->EditCustomAttributes = "";
		$this->UpdatedDate->EditValue = FormatDateTime($this->UpdatedDate->CurrentValue, 8);
		$this->UpdatedDate->PlaceHolder = RemoveHtml($this->UpdatedDate->caption());

		// ClientID
		$this->ClientID->EditAttrs["class"] = "form-control";
		$this->ClientID->EditCustomAttributes = "";

		// LitigantID
		$this->LitigantID->EditAttrs["class"] = "form-control";
		$this->LitigantID->EditCustomAttributes = "";

		// FileNumber
		$this->FileNumber->EditAttrs["class"] = "form-control";
		$this->FileNumber->EditCustomAttributes = "";

		// CaseNumber
		$this->CaseNumber->EditAttrs["class"] = "form-control";
		$this->CaseNumber->EditCustomAttributes = "";

		// CourtID
		$this->CourtID->EditAttrs["class"] = "form-control";
		$this->CourtID->EditCustomAttributes = "";
		$this->CourtID->EditValue = $this->CourtID->CurrentValue;
		$this->CourtID->PlaceHolder = RemoveHtml($this->CourtID->caption());

		// CourtTypeID
		$this->CourtTypeID->EditAttrs["class"] = "form-control";
		$this->CourtTypeID->EditCustomAttributes = "";

		// CourtGenderID
		$this->CourtGenderID->EditAttrs["class"] = "form-control";
		$this->CourtGenderID->EditCustomAttributes = "";

		// Case
		$this->_Case->EditAttrs["class"] = "form-control";
		$this->_Case->EditCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->HearingID);
					$doc->exportCaption($this->CaseID);
					$doc->exportCaption($this->HearingDate);
					$doc->exportCaption($this->HearingTime);
					$doc->exportCaption($this->NextHearingDate);
					$doc->exportCaption($this->NextHearingTime);
					$doc->exportCaption($this->Hearing);
					$doc->exportCaption($this->Notes);
					$doc->exportCaption($this->LawyerID);
					$doc->exportCaption($this->JudgeID);
					$doc->exportCaption($this->FileNumber);
					$doc->exportCaption($this->CaseNumber);
					$doc->exportCaption($this->CourtID);
				} else {
					$doc->exportCaption($this->HearingID);
					$doc->exportCaption($this->CaseID);
					$doc->exportCaption($this->HearingDate);
					$doc->exportCaption($this->HearingTime);
					$doc->exportCaption($this->NextHearingDate);
					$doc->exportCaption($this->NextHearingTime);
					$doc->exportCaption($this->Hearing);
					$doc->exportCaption($this->Notes);
					$doc->exportCaption($this->LawyerID);
					$doc->exportCaption($this->JudgeID);
					$doc->exportCaption($this->FileNumber);
					$doc->exportCaption($this->CaseNumber);
					$doc->exportCaption($this->CourtID);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->HearingID);
						$doc->exportField($this->CaseID);
						$doc->exportField($this->HearingDate);
						$doc->exportField($this->HearingTime);
						$doc->exportField($this->NextHearingDate);
						$doc->exportField($this->NextHearingTime);
						$doc->exportField($this->Hearing);
						$doc->exportField($this->Notes);
						$doc->exportField($this->LawyerID);
						$doc->exportField($this->JudgeID);
						$doc->exportField($this->FileNumber);
						$doc->exportField($this->CaseNumber);
						$doc->exportField($this->CourtID);
					} else {
						$doc->exportField($this->HearingID);
						$doc->exportField($this->CaseID);
						$doc->exportField($this->HearingDate);
						$doc->exportField($this->HearingTime);
						$doc->exportField($this->NextHearingDate);
						$doc->exportField($this->NextHearingTime);
						$doc->exportField($this->Hearing);
						$doc->exportField($this->Notes);
						$doc->exportField($this->LawyerID);
						$doc->exportField($this->JudgeID);
						$doc->exportField($this->FileNumber);
						$doc->exportField($this->CaseNumber);
						$doc->exportField($this->CourtID);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		if (!$validRequest)
			return FALSE;

		// Load lookup parameters
		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'hearings';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'hearings';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['HearingID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'hearings';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['HearingID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'hearings';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['HearingID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
