<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class courts_edit extends courts
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'courts';

	// Page object name
	public $PageObjName = "courts_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (courts)
		if (!isset($GLOBALS["courts"]) || get_class($GLOBALS["courts"]) == PROJECT_NAMESPACE . "courts") {
			$GLOBALS["courts"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["courts"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'courts');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $courts;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($courts);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "courtsview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['CourtID'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->CourtID->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $DisplayRecs = 1;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $RecCnt;
	public $DetailPages; // Detail pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("courtslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Update last accessed time
		if ($UserProfile->isValidUser(CurrentUserName(), session_id())) {
		} else {
			Write($Language->phrase("UserProfileCorrupted"));
			$this->terminate();
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->CourtID->setVisibility();
		$this->Court->setVisibility();
		$this->CourtEn->Visible = FALSE;
		$this->CourtTypeID->setVisibility();
		$this->ChamberID->setVisibility();
		$this->CourtLocationID->setVisibility();
		$this->GovernorateID->setVisibility();
		$this->SectionID->setVisibility();
		$this->AddressID->Visible = FALSE;
		$this->ContactID->Visible = FALSE;
		$this->Activated->setVisibility();
		$this->Notes->setVisibility();
		$this->_UserID->Visible = FALSE;
		$this->CreatedBy->Visible = FALSE;
		$this->CreatedDate->Visible = FALSE;
		$this->UpdatedBy->Visible = FALSE;
		$this->UpdatedDate->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up detail page object
		$this->setupDetailPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->CourtTypeID);
		$this->setupLookupOptions($this->ChamberID);
		$this->setupLookupOptions($this->CourtLocationID);
		$this->setupLookupOptions($this->GovernorateID);
		$this->setupLookupOptions($this->SectionID);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";

		// Load record by position
		$loadByPosition = FALSE;
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_CourtID")) {
				$this->CourtID->setFormValue($CurrentForm->getValue("x_CourtID"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("CourtID") !== NULL) {
				$this->CourtID->setQueryStringValue(Get("CourtID"));
				$loadByQuery = TRUE;
			} else {
				$this->CourtID->CurrentValue = NULL;
			}
			if (!$loadByQuery)
				$loadByPosition = TRUE;
		}

		// Load recordset
		$this->StartRec = 1; // Initialize start position
		if ($rs = $this->loadRecordset()) // Load records
			$this->TotalRecs = $rs->RecordCount(); // Get record count
		if ($this->TotalRecs <= 0) { // No record found
			if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$this->terminate("courtslist.php"); // Return to list page
		} elseif ($loadByPosition) { // Load record by position
			$this->setupStartRec(); // Set up start record position

			// Point to current record
			if ($this->StartRec <= $this->TotalRecs) {
				$rs->move($this->StartRec - 1);
				$loaded = TRUE;
			}
		} else { // Match key values
			if ($this->CourtID->CurrentValue != NULL) {
				while (!$rs->EOF) {
					if (SameString($this->CourtID->CurrentValue, $rs->fields('CourtID'))) {
						$this->setStartRecordNumber($this->StartRec); // Save record position
						$loaded = TRUE;
						break;
					} else {
						$this->StartRec++;
						$rs->moveNext();
					}
				}
			}
		}

		// Load current row values
		if ($loaded)
			$this->loadRowValues($rs);

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values

			// Set up detail parameters
			$this->setupDetailParms();
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) {
					if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
					$this->terminate("courtslist.php"); // Return to list page
				} else {
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "update": // Update
				if ($this->getCurrentDetailTable() <> "") // Master/detail edit
					$returnUrl = $this->getViewUrl(TABLE_SHOW_DETAIL . "=" . $this->getCurrentDetailTable()); // Master/Detail view page
				else
					$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "courtslist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'CourtID' first before field var 'x_CourtID'
		$val = $CurrentForm->hasValue("CourtID") ? $CurrentForm->getValue("CourtID") : $CurrentForm->getValue("x_CourtID");
		if (!$this->CourtID->IsDetailKey)
			$this->CourtID->setFormValue($val);

		// Check field name 'Court' first before field var 'x_Court'
		$val = $CurrentForm->hasValue("Court") ? $CurrentForm->getValue("Court") : $CurrentForm->getValue("x_Court");
		if (!$this->Court->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Court->Visible = FALSE; // Disable update for API request
			else
				$this->Court->setFormValue($val);
		}

		// Check field name 'CourtTypeID' first before field var 'x_CourtTypeID'
		$val = $CurrentForm->hasValue("CourtTypeID") ? $CurrentForm->getValue("CourtTypeID") : $CurrentForm->getValue("x_CourtTypeID");
		if (!$this->CourtTypeID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CourtTypeID->Visible = FALSE; // Disable update for API request
			else
				$this->CourtTypeID->setFormValue($val);
		}

		// Check field name 'ChamberID' first before field var 'x_ChamberID'
		$val = $CurrentForm->hasValue("ChamberID") ? $CurrentForm->getValue("ChamberID") : $CurrentForm->getValue("x_ChamberID");
		if (!$this->ChamberID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ChamberID->Visible = FALSE; // Disable update for API request
			else
				$this->ChamberID->setFormValue($val);
		}

		// Check field name 'CourtLocationID' first before field var 'x_CourtLocationID'
		$val = $CurrentForm->hasValue("CourtLocationID") ? $CurrentForm->getValue("CourtLocationID") : $CurrentForm->getValue("x_CourtLocationID");
		if (!$this->CourtLocationID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CourtLocationID->Visible = FALSE; // Disable update for API request
			else
				$this->CourtLocationID->setFormValue($val);
		}

		// Check field name 'GovernorateID' first before field var 'x_GovernorateID'
		$val = $CurrentForm->hasValue("GovernorateID") ? $CurrentForm->getValue("GovernorateID") : $CurrentForm->getValue("x_GovernorateID");
		if (!$this->GovernorateID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->GovernorateID->Visible = FALSE; // Disable update for API request
			else
				$this->GovernorateID->setFormValue($val);
		}

		// Check field name 'SectionID' first before field var 'x_SectionID'
		$val = $CurrentForm->hasValue("SectionID") ? $CurrentForm->getValue("SectionID") : $CurrentForm->getValue("x_SectionID");
		if (!$this->SectionID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->SectionID->Visible = FALSE; // Disable update for API request
			else
				$this->SectionID->setFormValue($val);
		}

		// Check field name 'Activated' first before field var 'x_Activated'
		$val = $CurrentForm->hasValue("Activated") ? $CurrentForm->getValue("Activated") : $CurrentForm->getValue("x_Activated");
		if (!$this->Activated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Activated->Visible = FALSE; // Disable update for API request
			else
				$this->Activated->setFormValue($val);
		}

		// Check field name 'Notes' first before field var 'x_Notes'
		$val = $CurrentForm->hasValue("Notes") ? $CurrentForm->getValue("Notes") : $CurrentForm->getValue("x_Notes");
		if (!$this->Notes->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Notes->Visible = FALSE; // Disable update for API request
			else
				$this->Notes->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->CourtID->CurrentValue = $this->CourtID->FormValue;
		$this->Court->CurrentValue = $this->Court->FormValue;
		$this->CourtTypeID->CurrentValue = $this->CourtTypeID->FormValue;
		$this->ChamberID->CurrentValue = $this->ChamberID->FormValue;
		$this->CourtLocationID->CurrentValue = $this->CourtLocationID->FormValue;
		$this->GovernorateID->CurrentValue = $this->GovernorateID->FormValue;
		$this->SectionID->CurrentValue = $this->SectionID->FormValue;
		$this->Activated->CurrentValue = $this->Activated->FormValue;
		$this->Notes->CurrentValue = $this->Notes->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->CourtID->setDbValue($row['CourtID']);
		$this->Court->setDbValue($row['Court']);
		$this->CourtEn->setDbValue($row['CourtEn']);
		$this->CourtTypeID->setDbValue($row['CourtTypeID']);
		if (array_key_exists('EV__CourtTypeID', $rs->fields)) {
			$this->CourtTypeID->VirtualValue = $rs->fields('EV__CourtTypeID'); // Set up virtual field value
		} else {
			$this->CourtTypeID->VirtualValue = ""; // Clear value
		}
		$this->ChamberID->setDbValue($row['ChamberID']);
		if (array_key_exists('EV__ChamberID', $rs->fields)) {
			$this->ChamberID->VirtualValue = $rs->fields('EV__ChamberID'); // Set up virtual field value
		} else {
			$this->ChamberID->VirtualValue = ""; // Clear value
		}
		$this->CourtLocationID->setDbValue($row['CourtLocationID']);
		if (array_key_exists('EV__CourtLocationID', $rs->fields)) {
			$this->CourtLocationID->VirtualValue = $rs->fields('EV__CourtLocationID'); // Set up virtual field value
		} else {
			$this->CourtLocationID->VirtualValue = ""; // Clear value
		}
		$this->GovernorateID->setDbValue($row['GovernorateID']);
		$this->SectionID->setDbValue($row['SectionID']);
		if (array_key_exists('EV__SectionID', $rs->fields)) {
			$this->SectionID->VirtualValue = $rs->fields('EV__SectionID'); // Set up virtual field value
		} else {
			$this->SectionID->VirtualValue = ""; // Clear value
		}
		$this->AddressID->setDbValue($row['AddressID']);
		$this->ContactID->setDbValue($row['ContactID']);
		$this->Activated->setDbValue($row['Activated']);
		$this->Notes->setDbValue($row['Notes']);
		$this->_UserID->setDbValue($row['UserID']);
		$this->CreatedBy->setDbValue($row['CreatedBy']);
		$this->CreatedDate->setDbValue($row['CreatedDate']);
		$this->UpdatedBy->setDbValue($row['UpdatedBy']);
		$this->UpdatedDate->setDbValue($row['UpdatedDate']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['CourtID'] = NULL;
		$row['Court'] = NULL;
		$row['CourtEn'] = NULL;
		$row['CourtTypeID'] = NULL;
		$row['ChamberID'] = NULL;
		$row['CourtLocationID'] = NULL;
		$row['GovernorateID'] = NULL;
		$row['SectionID'] = NULL;
		$row['AddressID'] = NULL;
		$row['ContactID'] = NULL;
		$row['Activated'] = NULL;
		$row['Notes'] = NULL;
		$row['UserID'] = NULL;
		$row['CreatedBy'] = NULL;
		$row['CreatedDate'] = NULL;
		$row['UpdatedBy'] = NULL;
		$row['UpdatedDate'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("CourtID")) <> "")
			$this->CourtID->CurrentValue = $this->getKey("CourtID"); // CourtID
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// CourtID
		// Court
		// CourtEn
		// CourtTypeID
		// ChamberID
		// CourtLocationID
		// GovernorateID
		// SectionID
		// AddressID
		// ContactID
		// Activated
		// Notes
		// UserID
		// CreatedBy
		// CreatedDate
		// UpdatedBy
		// UpdatedDate

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// CourtID
			$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
			$this->CourtID->ViewCustomAttributes = "";

			// Court
			$this->Court->ViewValue = $this->Court->CurrentValue;
			$this->Court->ViewCustomAttributes = "";

			// CourtEn
			$this->CourtEn->ViewValue = $this->CourtEn->CurrentValue;
			$this->CourtEn->ViewCustomAttributes = "";

			// CourtTypeID
			if ($this->CourtTypeID->VirtualValue <> "") {
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->VirtualValue;
			} else {
			$curVal = strval($this->CourtTypeID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->lookupCacheOption($curVal);
				if ($this->CourtTypeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtTypeID->ViewValue = $this->CourtTypeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtTypeID->ViewValue = $this->CourtTypeID->CurrentValue;
					}
				}
			} else {
				$this->CourtTypeID->ViewValue = NULL;
			}
			}
			$this->CourtTypeID->ViewCustomAttributes = "";

			// ChamberID
			if ($this->ChamberID->VirtualValue <> "") {
				$this->ChamberID->ViewValue = $this->ChamberID->VirtualValue;
			} else {
			$curVal = strval($this->ChamberID->CurrentValue);
			if ($curVal <> "") {
				$this->ChamberID->ViewValue = $this->ChamberID->lookupCacheOption($curVal);
				if ($this->ChamberID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ChamberID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ChamberID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ChamberID->ViewValue = $this->ChamberID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ChamberID->ViewValue = $this->ChamberID->CurrentValue;
					}
				}
			} else {
				$this->ChamberID->ViewValue = NULL;
			}
			}
			$this->ChamberID->ViewCustomAttributes = "";

			// CourtLocationID
			if ($this->CourtLocationID->VirtualValue <> "") {
				$this->CourtLocationID->ViewValue = $this->CourtLocationID->VirtualValue;
			} else {
			$curVal = strval($this->CourtLocationID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtLocationID->ViewValue = $this->CourtLocationID->lookupCacheOption($curVal);
				if ($this->CourtLocationID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtLocationID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtLocationID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtLocationID->ViewValue = $this->CourtLocationID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtLocationID->ViewValue = $this->CourtLocationID->CurrentValue;
					}
				}
			} else {
				$this->CourtLocationID->ViewValue = NULL;
			}
			}
			$this->CourtLocationID->ViewCustomAttributes = "";

			// GovernorateID
			$curVal = strval($this->GovernorateID->CurrentValue);
			if ($curVal <> "") {
				$this->GovernorateID->ViewValue = $this->GovernorateID->lookupCacheOption($curVal);
				if ($this->GovernorateID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`GovernorateID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->GovernorateID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->GovernorateID->ViewValue = $this->GovernorateID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->GovernorateID->ViewValue = $this->GovernorateID->CurrentValue;
					}
				}
			} else {
				$this->GovernorateID->ViewValue = NULL;
			}
			$this->GovernorateID->ViewCustomAttributes = "";

			// SectionID
			if ($this->SectionID->VirtualValue <> "") {
				$this->SectionID->ViewValue = $this->SectionID->VirtualValue;
			} else {
			$curVal = strval($this->SectionID->CurrentValue);
			if ($curVal <> "") {
				$this->SectionID->ViewValue = $this->SectionID->lookupCacheOption($curVal);
				if ($this->SectionID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`SectionID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->SectionID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->SectionID->ViewValue = $this->SectionID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->SectionID->ViewValue = $this->SectionID->CurrentValue;
					}
				}
			} else {
				$this->SectionID->ViewValue = NULL;
			}
			}
			$this->SectionID->ViewCustomAttributes = "";

			// Activated
			if (ConvertToBool($this->Activated->CurrentValue)) {
				$this->Activated->ViewValue = $this->Activated->tagCaption(1) <> "" ? $this->Activated->tagCaption(1) : "Y";
			} else {
				$this->Activated->ViewValue = $this->Activated->tagCaption(2) <> "" ? $this->Activated->tagCaption(2) : "N";
			}
			$this->Activated->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// CourtID
			$this->CourtID->LinkCustomAttributes = "";
			$this->CourtID->HrefValue = "";
			$this->CourtID->TooltipValue = "";

			// Court
			$this->Court->LinkCustomAttributes = "";
			$this->Court->HrefValue = "";
			$this->Court->TooltipValue = "";

			// CourtTypeID
			$this->CourtTypeID->LinkCustomAttributes = "";
			$this->CourtTypeID->HrefValue = "";
			$this->CourtTypeID->TooltipValue = "";

			// ChamberID
			$this->ChamberID->LinkCustomAttributes = "";
			$this->ChamberID->HrefValue = "";
			$this->ChamberID->TooltipValue = "";

			// CourtLocationID
			$this->CourtLocationID->LinkCustomAttributes = "";
			$this->CourtLocationID->HrefValue = "";
			$this->CourtLocationID->TooltipValue = "";

			// GovernorateID
			$this->GovernorateID->LinkCustomAttributes = "";
			$this->GovernorateID->HrefValue = "";
			$this->GovernorateID->TooltipValue = "";

			// SectionID
			$this->SectionID->LinkCustomAttributes = "";
			$this->SectionID->HrefValue = "";
			$this->SectionID->TooltipValue = "";

			// Activated
			$this->Activated->LinkCustomAttributes = "";
			$this->Activated->HrefValue = "";
			$this->Activated->TooltipValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
			$this->Notes->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// CourtID
			$this->CourtID->EditAttrs["class"] = "form-control";
			$this->CourtID->EditCustomAttributes = "";

			// Court
			$this->Court->EditAttrs["class"] = "form-control";
			$this->Court->EditCustomAttributes = "";
			$this->Court->EditValue = HtmlEncode($this->Court->CurrentValue);
			$this->Court->PlaceHolder = RemoveHtml($this->Court->caption());

			// CourtTypeID
			$this->CourtTypeID->EditAttrs["class"] = "form-control";
			$this->CourtTypeID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CourtTypeID->CurrentValue));
			if ($curVal <> "")
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->lookupCacheOption($curVal);
			else
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->Lookup !== NULL && is_array($this->CourtTypeID->Lookup->Options) ? $curVal : NULL;
			if ($this->CourtTypeID->ViewValue !== NULL) { // Load from cache
				$this->CourtTypeID->EditValue = array_values($this->CourtTypeID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CourtTypeID`" . SearchString("=", $this->CourtTypeID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CourtTypeID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CourtTypeID->EditValue = $arwrk;
			}

			// ChamberID
			$this->ChamberID->EditAttrs["class"] = "form-control";
			$this->ChamberID->EditCustomAttributes = "";
			$curVal = trim(strval($this->ChamberID->CurrentValue));
			if ($curVal <> "")
				$this->ChamberID->ViewValue = $this->ChamberID->lookupCacheOption($curVal);
			else
				$this->ChamberID->ViewValue = $this->ChamberID->Lookup !== NULL && is_array($this->ChamberID->Lookup->Options) ? $curVal : NULL;
			if ($this->ChamberID->ViewValue !== NULL) { // Load from cache
				$this->ChamberID->EditValue = array_values($this->ChamberID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`ChamberID`" . SearchString("=", $this->ChamberID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->ChamberID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ChamberID->EditValue = $arwrk;
			}

			// CourtLocationID
			$this->CourtLocationID->EditAttrs["class"] = "form-control";
			$this->CourtLocationID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CourtLocationID->CurrentValue));
			if ($curVal <> "")
				$this->CourtLocationID->ViewValue = $this->CourtLocationID->lookupCacheOption($curVal);
			else
				$this->CourtLocationID->ViewValue = $this->CourtLocationID->Lookup !== NULL && is_array($this->CourtLocationID->Lookup->Options) ? $curVal : NULL;
			if ($this->CourtLocationID->ViewValue !== NULL) { // Load from cache
				$this->CourtLocationID->EditValue = array_values($this->CourtLocationID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CourtLocationID`" . SearchString("=", $this->CourtLocationID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CourtLocationID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CourtLocationID->EditValue = $arwrk;
			}

			// GovernorateID
			$this->GovernorateID->EditAttrs["class"] = "form-control";
			$this->GovernorateID->EditCustomAttributes = "";
			$curVal = trim(strval($this->GovernorateID->CurrentValue));
			if ($curVal <> "")
				$this->GovernorateID->ViewValue = $this->GovernorateID->lookupCacheOption($curVal);
			else
				$this->GovernorateID->ViewValue = $this->GovernorateID->Lookup !== NULL && is_array($this->GovernorateID->Lookup->Options) ? $curVal : NULL;
			if ($this->GovernorateID->ViewValue !== NULL) { // Load from cache
				$this->GovernorateID->EditValue = array_values($this->GovernorateID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`GovernorateID`" . SearchString("=", $this->GovernorateID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->GovernorateID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->GovernorateID->EditValue = $arwrk;
			}

			// SectionID
			$this->SectionID->EditAttrs["class"] = "form-control";
			$this->SectionID->EditCustomAttributes = "";
			$curVal = trim(strval($this->SectionID->CurrentValue));
			if ($curVal <> "")
				$this->SectionID->ViewValue = $this->SectionID->lookupCacheOption($curVal);
			else
				$this->SectionID->ViewValue = $this->SectionID->Lookup !== NULL && is_array($this->SectionID->Lookup->Options) ? $curVal : NULL;
			if ($this->SectionID->ViewValue !== NULL) { // Load from cache
				$this->SectionID->EditValue = array_values($this->SectionID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`SectionID`" . SearchString("=", $this->SectionID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->SectionID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->SectionID->EditValue = $arwrk;
			}

			// Activated
			$this->Activated->EditCustomAttributes = "";
			$this->Activated->EditValue = $this->Activated->options(FALSE);

			// Notes
			$this->Notes->EditAttrs["class"] = "form-control";
			$this->Notes->EditCustomAttributes = "";
			$this->Notes->EditValue = HtmlEncode($this->Notes->CurrentValue);
			$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

			// Edit refer script
			// CourtID

			$this->CourtID->LinkCustomAttributes = "";
			$this->CourtID->HrefValue = "";

			// Court
			$this->Court->LinkCustomAttributes = "";
			$this->Court->HrefValue = "";

			// CourtTypeID
			$this->CourtTypeID->LinkCustomAttributes = "";
			$this->CourtTypeID->HrefValue = "";

			// ChamberID
			$this->ChamberID->LinkCustomAttributes = "";
			$this->ChamberID->HrefValue = "";

			// CourtLocationID
			$this->CourtLocationID->LinkCustomAttributes = "";
			$this->CourtLocationID->HrefValue = "";

			// GovernorateID
			$this->GovernorateID->LinkCustomAttributes = "";
			$this->GovernorateID->HrefValue = "";

			// SectionID
			$this->SectionID->LinkCustomAttributes = "";
			$this->SectionID->HrefValue = "";

			// Activated
			$this->Activated->LinkCustomAttributes = "";
			$this->Activated->HrefValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->CourtID->Required) {
			if (!$this->CourtID->IsDetailKey && $this->CourtID->FormValue != NULL && $this->CourtID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtID->caption(), $this->CourtID->RequiredErrorMessage));
			}
		}
		if ($this->Court->Required) {
			if (!$this->Court->IsDetailKey && $this->Court->FormValue != NULL && $this->Court->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Court->caption(), $this->Court->RequiredErrorMessage));
			}
		}
		if ($this->CourtEn->Required) {
			if (!$this->CourtEn->IsDetailKey && $this->CourtEn->FormValue != NULL && $this->CourtEn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtEn->caption(), $this->CourtEn->RequiredErrorMessage));
			}
		}
		if ($this->CourtTypeID->Required) {
			if (!$this->CourtTypeID->IsDetailKey && $this->CourtTypeID->FormValue != NULL && $this->CourtTypeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtTypeID->caption(), $this->CourtTypeID->RequiredErrorMessage));
			}
		}
		if ($this->ChamberID->Required) {
			if (!$this->ChamberID->IsDetailKey && $this->ChamberID->FormValue != NULL && $this->ChamberID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ChamberID->caption(), $this->ChamberID->RequiredErrorMessage));
			}
		}
		if ($this->CourtLocationID->Required) {
			if (!$this->CourtLocationID->IsDetailKey && $this->CourtLocationID->FormValue != NULL && $this->CourtLocationID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtLocationID->caption(), $this->CourtLocationID->RequiredErrorMessage));
			}
		}
		if ($this->GovernorateID->Required) {
			if (!$this->GovernorateID->IsDetailKey && $this->GovernorateID->FormValue != NULL && $this->GovernorateID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->GovernorateID->caption(), $this->GovernorateID->RequiredErrorMessage));
			}
		}
		if ($this->SectionID->Required) {
			if (!$this->SectionID->IsDetailKey && $this->SectionID->FormValue != NULL && $this->SectionID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SectionID->caption(), $this->SectionID->RequiredErrorMessage));
			}
		}
		if ($this->AddressID->Required) {
			if (!$this->AddressID->IsDetailKey && $this->AddressID->FormValue != NULL && $this->AddressID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->AddressID->caption(), $this->AddressID->RequiredErrorMessage));
			}
		}
		if ($this->ContactID->Required) {
			if (!$this->ContactID->IsDetailKey && $this->ContactID->FormValue != NULL && $this->ContactID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ContactID->caption(), $this->ContactID->RequiredErrorMessage));
			}
		}
		if ($this->Activated->Required) {
			if ($this->Activated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Activated->caption(), $this->Activated->RequiredErrorMessage));
			}
		}
		if ($this->Notes->Required) {
			if (!$this->Notes->IsDetailKey && $this->Notes->FormValue != NULL && $this->Notes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Notes->caption(), $this->Notes->RequiredErrorMessage));
			}
		}
		if ($this->_UserID->Required) {
			if (!$this->_UserID->IsDetailKey && $this->_UserID->FormValue != NULL && $this->_UserID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_UserID->caption(), $this->_UserID->RequiredErrorMessage));
			}
		}
		if ($this->CreatedBy->Required) {
			if (!$this->CreatedBy->IsDetailKey && $this->CreatedBy->FormValue != NULL && $this->CreatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedBy->caption(), $this->CreatedBy->RequiredErrorMessage));
			}
		}
		if ($this->CreatedDate->Required) {
			if (!$this->CreatedDate->IsDetailKey && $this->CreatedDate->FormValue != NULL && $this->CreatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedDate->caption(), $this->CreatedDate->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedBy->Required) {
			if (!$this->UpdatedBy->IsDetailKey && $this->UpdatedBy->FormValue != NULL && $this->UpdatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedBy->caption(), $this->UpdatedBy->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedDate->Required) {
			if (!$this->UpdatedDate->IsDetailKey && $this->UpdatedDate->FormValue != NULL && $this->UpdatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedDate->caption(), $this->UpdatedDate->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("courtaddress", $detailTblVar) && $GLOBALS["courtaddress"]->DetailEdit) {
			if (!isset($GLOBALS["courtaddress_grid"]))
				$GLOBALS["courtaddress_grid"] = new courtaddress_grid(); // Get detail page object
			$GLOBALS["courtaddress_grid"]->validateGridForm();
		}
		if (in_array("courtcontact", $detailTblVar) && $GLOBALS["courtcontact"]->DetailEdit) {
			if (!isset($GLOBALS["courtcontact_grid"]))
				$GLOBALS["courtcontact_grid"] = new courtcontact_grid(); // Get detail page object
			$GLOBALS["courtcontact_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Begin transaction
			if ($this->getCurrentDetailTable() <> "")
				$conn->beginTrans();

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// Court
			$this->Court->setDbValueDef($rsnew, $this->Court->CurrentValue, "", $this->Court->ReadOnly);

			// CourtTypeID
			$this->CourtTypeID->setDbValueDef($rsnew, $this->CourtTypeID->CurrentValue, 0, $this->CourtTypeID->ReadOnly);

			// ChamberID
			$this->ChamberID->setDbValueDef($rsnew, $this->ChamberID->CurrentValue, NULL, $this->ChamberID->ReadOnly);

			// CourtLocationID
			$this->CourtLocationID->setDbValueDef($rsnew, $this->CourtLocationID->CurrentValue, NULL, $this->CourtLocationID->ReadOnly);

			// GovernorateID
			$this->GovernorateID->setDbValueDef($rsnew, $this->GovernorateID->CurrentValue, NULL, $this->GovernorateID->ReadOnly);

			// SectionID
			$this->SectionID->setDbValueDef($rsnew, $this->SectionID->CurrentValue, NULL, $this->SectionID->ReadOnly);

			// Activated
			$tmpBool = $this->Activated->CurrentValue;
			if ($tmpBool <> "Y" && $tmpBool <> "N")
				$tmpBool = !empty($tmpBool) ? "Y" : "N";
			$this->Activated->setDbValueDef($rsnew, $tmpBool, "N", $this->Activated->ReadOnly);

			// Notes
			$this->Notes->setDbValueDef($rsnew, $this->Notes->CurrentValue, NULL, $this->Notes->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}

				// Update detail records
				$detailTblVar = explode(",", $this->getCurrentDetailTable());
				if ($editRow) {
					if (in_array("courtaddress", $detailTblVar) && $GLOBALS["courtaddress"]->DetailEdit) {
						if (!isset($GLOBALS["courtaddress_grid"]))
							$GLOBALS["courtaddress_grid"] = new courtaddress_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "courtaddress"); // Load user level of detail table
						$editRow = $GLOBALS["courtaddress_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}
				if ($editRow) {
					if (in_array("courtcontact", $detailTblVar) && $GLOBALS["courtcontact"]->DetailEdit) {
						if (!isset($GLOBALS["courtcontact_grid"]))
							$GLOBALS["courtcontact_grid"] = new courtcontact_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "courtcontact"); // Load user level of detail table
						$editRow = $GLOBALS["courtcontact_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}

				// Commit/Rollback transaction
				if ($this->getCurrentDetailTable() <> "") {
					if ($editRow) {
						$conn->commitTrans(); // Commit transaction
					} else {
						$conn->rollbackTrans(); // Rollback transaction
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		if (Get(TABLE_SHOW_DETAIL) !== NULL) {
			$detailTblVar = Get(TABLE_SHOW_DETAIL);
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar <> "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("courtaddress", $detailTblVar)) {
				if (!isset($GLOBALS["courtaddress_grid"]))
					$GLOBALS["courtaddress_grid"] = new courtaddress_grid();
				if ($GLOBALS["courtaddress_grid"]->DetailEdit) {
					$GLOBALS["courtaddress_grid"]->CurrentMode = "edit";
					$GLOBALS["courtaddress_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["courtaddress_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["courtaddress_grid"]->setStartRecordNumber(1);
					$GLOBALS["courtaddress_grid"]->CourtID->IsDetailKey = TRUE;
					$GLOBALS["courtaddress_grid"]->CourtID->CurrentValue = $this->CourtID->CurrentValue;
					$GLOBALS["courtaddress_grid"]->CourtID->setSessionValue($GLOBALS["courtaddress_grid"]->CourtID->CurrentValue);
				}
			}
			if (in_array("courtcontact", $detailTblVar)) {
				if (!isset($GLOBALS["courtcontact_grid"]))
					$GLOBALS["courtcontact_grid"] = new courtcontact_grid();
				if ($GLOBALS["courtcontact_grid"]->DetailEdit) {
					$GLOBALS["courtcontact_grid"]->CurrentMode = "edit";
					$GLOBALS["courtcontact_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["courtcontact_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["courtcontact_grid"]->setStartRecordNumber(1);
					$GLOBALS["courtcontact_grid"]->CourtID->IsDetailKey = TRUE;
					$GLOBALS["courtcontact_grid"]->CourtID->CurrentValue = $this->CourtID->CurrentValue;
					$GLOBALS["courtcontact_grid"]->CourtID->setSessionValue($GLOBALS["courtcontact_grid"]->CourtID->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("courtslist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Set up detail pages
	protected function setupDetailPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add('courtaddress');
		$pages->add('courtcontact');
		$this->DetailPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_CourtTypeID":
							break;
						case "x_ChamberID":
							break;
						case "x_CourtLocationID":
							break;
						case "x_GovernorateID":
							break;
						case "x_SectionID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
