<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class courts_addopt extends courts
{

	// Page ID
	public $PageID = "addopt";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'courts';

	// Page object name
	public $PageObjName = "courts_addopt";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (courts)
		if (!isset($GLOBALS["courts"]) || get_class($GLOBALS["courts"]) == PROJECT_NAMESPACE . "courts") {
			$GLOBALS["courts"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["courts"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'addopt');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'courts');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $courts;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($courts);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['CourtID'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->CourtID->Visible = FALSE;
	}

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("courtslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Update last accessed time
		if ($UserProfile->isValidUser(CurrentUserName(), session_id())) {
		} else {
			Write($Language->phrase("UserProfileCorrupted"));
			$this->terminate();
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->CourtID->Visible = FALSE;
		$this->Court->setVisibility();
		$this->CourtEn->Visible = FALSE;
		$this->CourtTypeID->setVisibility();
		$this->ChamberID->setVisibility();
		$this->CourtLocationID->setVisibility();
		$this->GovernorateID->setVisibility();
		$this->SectionID->setVisibility();
		$this->AddressID->Visible = FALSE;
		$this->ContactID->Visible = FALSE;
		$this->Activated->Visible = FALSE;
		$this->Notes->setVisibility();
		$this->_UserID->Visible = FALSE;
		$this->CreatedBy->Visible = FALSE;
		$this->CreatedDate->Visible = FALSE;
		$this->UpdatedBy->Visible = FALSE;
		$this->UpdatedDate->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->CourtTypeID);
		$this->setupLookupOptions($this->ChamberID);
		$this->setupLookupOptions($this->CourtLocationID);
		$this->setupLookupOptions($this->GovernorateID);
		$this->setupLookupOptions($this->SectionID);
		set_error_handler(PROJECT_NAMESPACE . "ErrorHandler");

		// Set up Breadcrumb
		//$this->setupBreadcrumb(); // Not used

		$this->loadRowValues(); // Load default values

		// Render row
		$this->RowType = ROWTYPE_ADD; // Render add type
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->CourtID->CurrentValue = NULL;
		$this->CourtID->OldValue = $this->CourtID->CurrentValue;
		$this->Court->CurrentValue = NULL;
		$this->Court->OldValue = $this->Court->CurrentValue;
		$this->CourtEn->CurrentValue = NULL;
		$this->CourtEn->OldValue = $this->CourtEn->CurrentValue;
		$this->CourtTypeID->CurrentValue = NULL;
		$this->CourtTypeID->OldValue = $this->CourtTypeID->CurrentValue;
		$this->ChamberID->CurrentValue = NULL;
		$this->ChamberID->OldValue = $this->ChamberID->CurrentValue;
		$this->CourtLocationID->CurrentValue = NULL;
		$this->CourtLocationID->OldValue = $this->CourtLocationID->CurrentValue;
		$this->GovernorateID->CurrentValue = NULL;
		$this->GovernorateID->OldValue = $this->GovernorateID->CurrentValue;
		$this->SectionID->CurrentValue = NULL;
		$this->SectionID->OldValue = $this->SectionID->CurrentValue;
		$this->AddressID->CurrentValue = NULL;
		$this->AddressID->OldValue = $this->AddressID->CurrentValue;
		$this->ContactID->CurrentValue = NULL;
		$this->ContactID->OldValue = $this->ContactID->CurrentValue;
		$this->Activated->CurrentValue = "Y";
		$this->Notes->CurrentValue = NULL;
		$this->Notes->OldValue = $this->Notes->CurrentValue;
		$this->_UserID->CurrentValue = NULL;
		$this->_UserID->OldValue = $this->_UserID->CurrentValue;
		$this->CreatedBy->CurrentValue = NULL;
		$this->CreatedBy->OldValue = $this->CreatedBy->CurrentValue;
		$this->CreatedDate->CurrentValue = NULL;
		$this->CreatedDate->OldValue = $this->CreatedDate->CurrentValue;
		$this->UpdatedBy->CurrentValue = NULL;
		$this->UpdatedBy->OldValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedDate->CurrentValue = NULL;
		$this->UpdatedDate->OldValue = $this->UpdatedDate->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Court' first before field var 'x_Court'
		$val = $CurrentForm->hasValue("Court") ? $CurrentForm->getValue("Court") : $CurrentForm->getValue("x_Court");
		if (!$this->Court->IsDetailKey) {
			$this->Court->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'CourtTypeID' first before field var 'x_CourtTypeID'
		$val = $CurrentForm->hasValue("CourtTypeID") ? $CurrentForm->getValue("CourtTypeID") : $CurrentForm->getValue("x_CourtTypeID");
		if (!$this->CourtTypeID->IsDetailKey) {
			$this->CourtTypeID->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'ChamberID' first before field var 'x_ChamberID'
		$val = $CurrentForm->hasValue("ChamberID") ? $CurrentForm->getValue("ChamberID") : $CurrentForm->getValue("x_ChamberID");
		if (!$this->ChamberID->IsDetailKey) {
			$this->ChamberID->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'CourtLocationID' first before field var 'x_CourtLocationID'
		$val = $CurrentForm->hasValue("CourtLocationID") ? $CurrentForm->getValue("CourtLocationID") : $CurrentForm->getValue("x_CourtLocationID");
		if (!$this->CourtLocationID->IsDetailKey) {
			$this->CourtLocationID->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'GovernorateID' first before field var 'x_GovernorateID'
		$val = $CurrentForm->hasValue("GovernorateID") ? $CurrentForm->getValue("GovernorateID") : $CurrentForm->getValue("x_GovernorateID");
		if (!$this->GovernorateID->IsDetailKey) {
			$this->GovernorateID->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'SectionID' first before field var 'x_SectionID'
		$val = $CurrentForm->hasValue("SectionID") ? $CurrentForm->getValue("SectionID") : $CurrentForm->getValue("x_SectionID");
		if (!$this->SectionID->IsDetailKey) {
			$this->SectionID->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'Notes' first before field var 'x_Notes'
		$val = $CurrentForm->hasValue("Notes") ? $CurrentForm->getValue("Notes") : $CurrentForm->getValue("x_Notes");
		if (!$this->Notes->IsDetailKey) {
			$this->Notes->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'CourtID' first before field var 'x_CourtID'
		$val = $CurrentForm->hasValue("CourtID") ? $CurrentForm->getValue("CourtID") : $CurrentForm->getValue("x_CourtID");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Court->CurrentValue = ConvertToUtf8($this->Court->FormValue);
		$this->CourtTypeID->CurrentValue = ConvertToUtf8($this->CourtTypeID->FormValue);
		$this->ChamberID->CurrentValue = ConvertToUtf8($this->ChamberID->FormValue);
		$this->CourtLocationID->CurrentValue = ConvertToUtf8($this->CourtLocationID->FormValue);
		$this->GovernorateID->CurrentValue = ConvertToUtf8($this->GovernorateID->FormValue);
		$this->SectionID->CurrentValue = ConvertToUtf8($this->SectionID->FormValue);
		$this->Notes->CurrentValue = ConvertToUtf8($this->Notes->FormValue);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->CourtID->setDbValue($row['CourtID']);
		$this->Court->setDbValue($row['Court']);
		$this->CourtEn->setDbValue($row['CourtEn']);
		$this->CourtTypeID->setDbValue($row['CourtTypeID']);
		if (array_key_exists('EV__CourtTypeID', $rs->fields)) {
			$this->CourtTypeID->VirtualValue = $rs->fields('EV__CourtTypeID'); // Set up virtual field value
		} else {
			$this->CourtTypeID->VirtualValue = ""; // Clear value
		}
		$this->ChamberID->setDbValue($row['ChamberID']);
		if (array_key_exists('EV__ChamberID', $rs->fields)) {
			$this->ChamberID->VirtualValue = $rs->fields('EV__ChamberID'); // Set up virtual field value
		} else {
			$this->ChamberID->VirtualValue = ""; // Clear value
		}
		$this->CourtLocationID->setDbValue($row['CourtLocationID']);
		if (array_key_exists('EV__CourtLocationID', $rs->fields)) {
			$this->CourtLocationID->VirtualValue = $rs->fields('EV__CourtLocationID'); // Set up virtual field value
		} else {
			$this->CourtLocationID->VirtualValue = ""; // Clear value
		}
		$this->GovernorateID->setDbValue($row['GovernorateID']);
		$this->SectionID->setDbValue($row['SectionID']);
		if (array_key_exists('EV__SectionID', $rs->fields)) {
			$this->SectionID->VirtualValue = $rs->fields('EV__SectionID'); // Set up virtual field value
		} else {
			$this->SectionID->VirtualValue = ""; // Clear value
		}
		$this->AddressID->setDbValue($row['AddressID']);
		$this->ContactID->setDbValue($row['ContactID']);
		$this->Activated->setDbValue($row['Activated']);
		$this->Notes->setDbValue($row['Notes']);
		$this->_UserID->setDbValue($row['UserID']);
		$this->CreatedBy->setDbValue($row['CreatedBy']);
		$this->CreatedDate->setDbValue($row['CreatedDate']);
		$this->UpdatedBy->setDbValue($row['UpdatedBy']);
		$this->UpdatedDate->setDbValue($row['UpdatedDate']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['CourtID'] = $this->CourtID->CurrentValue;
		$row['Court'] = $this->Court->CurrentValue;
		$row['CourtEn'] = $this->CourtEn->CurrentValue;
		$row['CourtTypeID'] = $this->CourtTypeID->CurrentValue;
		$row['ChamberID'] = $this->ChamberID->CurrentValue;
		$row['CourtLocationID'] = $this->CourtLocationID->CurrentValue;
		$row['GovernorateID'] = $this->GovernorateID->CurrentValue;
		$row['SectionID'] = $this->SectionID->CurrentValue;
		$row['AddressID'] = $this->AddressID->CurrentValue;
		$row['ContactID'] = $this->ContactID->CurrentValue;
		$row['Activated'] = $this->Activated->CurrentValue;
		$row['Notes'] = $this->Notes->CurrentValue;
		$row['UserID'] = $this->_UserID->CurrentValue;
		$row['CreatedBy'] = $this->CreatedBy->CurrentValue;
		$row['CreatedDate'] = $this->CreatedDate->CurrentValue;
		$row['UpdatedBy'] = $this->UpdatedBy->CurrentValue;
		$row['UpdatedDate'] = $this->UpdatedDate->CurrentValue;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// CourtID
		// Court
		// CourtEn
		// CourtTypeID
		// ChamberID
		// CourtLocationID
		// GovernorateID
		// SectionID
		// AddressID
		// ContactID
		// Activated
		// Notes
		// UserID
		// CreatedBy
		// CreatedDate
		// UpdatedBy
		// UpdatedDate

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// CourtID
			$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
			$this->CourtID->ViewCustomAttributes = "";

			// Court
			$this->Court->ViewValue = $this->Court->CurrentValue;
			$this->Court->ViewCustomAttributes = "";

			// CourtEn
			$this->CourtEn->ViewValue = $this->CourtEn->CurrentValue;
			$this->CourtEn->ViewCustomAttributes = "";

			// CourtTypeID
			if ($this->CourtTypeID->VirtualValue <> "") {
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->VirtualValue;
			} else {
			$curVal = strval($this->CourtTypeID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->lookupCacheOption($curVal);
				if ($this->CourtTypeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtTypeID->ViewValue = $this->CourtTypeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtTypeID->ViewValue = $this->CourtTypeID->CurrentValue;
					}
				}
			} else {
				$this->CourtTypeID->ViewValue = NULL;
			}
			}
			$this->CourtTypeID->ViewCustomAttributes = "";

			// ChamberID
			if ($this->ChamberID->VirtualValue <> "") {
				$this->ChamberID->ViewValue = $this->ChamberID->VirtualValue;
			} else {
			$curVal = strval($this->ChamberID->CurrentValue);
			if ($curVal <> "") {
				$this->ChamberID->ViewValue = $this->ChamberID->lookupCacheOption($curVal);
				if ($this->ChamberID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ChamberID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ChamberID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ChamberID->ViewValue = $this->ChamberID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ChamberID->ViewValue = $this->ChamberID->CurrentValue;
					}
				}
			} else {
				$this->ChamberID->ViewValue = NULL;
			}
			}
			$this->ChamberID->ViewCustomAttributes = "";

			// CourtLocationID
			if ($this->CourtLocationID->VirtualValue <> "") {
				$this->CourtLocationID->ViewValue = $this->CourtLocationID->VirtualValue;
			} else {
			$curVal = strval($this->CourtLocationID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtLocationID->ViewValue = $this->CourtLocationID->lookupCacheOption($curVal);
				if ($this->CourtLocationID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtLocationID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtLocationID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtLocationID->ViewValue = $this->CourtLocationID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtLocationID->ViewValue = $this->CourtLocationID->CurrentValue;
					}
				}
			} else {
				$this->CourtLocationID->ViewValue = NULL;
			}
			}
			$this->CourtLocationID->ViewCustomAttributes = "";

			// GovernorateID
			$curVal = strval($this->GovernorateID->CurrentValue);
			if ($curVal <> "") {
				$this->GovernorateID->ViewValue = $this->GovernorateID->lookupCacheOption($curVal);
				if ($this->GovernorateID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`GovernorateID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->GovernorateID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->GovernorateID->ViewValue = $this->GovernorateID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->GovernorateID->ViewValue = $this->GovernorateID->CurrentValue;
					}
				}
			} else {
				$this->GovernorateID->ViewValue = NULL;
			}
			$this->GovernorateID->ViewCustomAttributes = "";

			// SectionID
			if ($this->SectionID->VirtualValue <> "") {
				$this->SectionID->ViewValue = $this->SectionID->VirtualValue;
			} else {
			$curVal = strval($this->SectionID->CurrentValue);
			if ($curVal <> "") {
				$this->SectionID->ViewValue = $this->SectionID->lookupCacheOption($curVal);
				if ($this->SectionID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`SectionID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->SectionID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->SectionID->ViewValue = $this->SectionID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->SectionID->ViewValue = $this->SectionID->CurrentValue;
					}
				}
			} else {
				$this->SectionID->ViewValue = NULL;
			}
			}
			$this->SectionID->ViewCustomAttributes = "";

			// Activated
			if (ConvertToBool($this->Activated->CurrentValue)) {
				$this->Activated->ViewValue = $this->Activated->tagCaption(1) <> "" ? $this->Activated->tagCaption(1) : "Y";
			} else {
				$this->Activated->ViewValue = $this->Activated->tagCaption(2) <> "" ? $this->Activated->tagCaption(2) : "N";
			}
			$this->Activated->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// Court
			$this->Court->LinkCustomAttributes = "";
			$this->Court->HrefValue = "";
			$this->Court->TooltipValue = "";

			// CourtTypeID
			$this->CourtTypeID->LinkCustomAttributes = "";
			$this->CourtTypeID->HrefValue = "";
			$this->CourtTypeID->TooltipValue = "";

			// ChamberID
			$this->ChamberID->LinkCustomAttributes = "";
			$this->ChamberID->HrefValue = "";
			$this->ChamberID->TooltipValue = "";

			// CourtLocationID
			$this->CourtLocationID->LinkCustomAttributes = "";
			$this->CourtLocationID->HrefValue = "";
			$this->CourtLocationID->TooltipValue = "";

			// GovernorateID
			$this->GovernorateID->LinkCustomAttributes = "";
			$this->GovernorateID->HrefValue = "";
			$this->GovernorateID->TooltipValue = "";

			// SectionID
			$this->SectionID->LinkCustomAttributes = "";
			$this->SectionID->HrefValue = "";
			$this->SectionID->TooltipValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
			$this->Notes->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// Court
			$this->Court->EditAttrs["class"] = "form-control";
			$this->Court->EditCustomAttributes = "";
			$this->Court->EditValue = HtmlEncode($this->Court->CurrentValue);
			$this->Court->PlaceHolder = RemoveHtml($this->Court->caption());

			// CourtTypeID
			$this->CourtTypeID->EditAttrs["class"] = "form-control";
			$this->CourtTypeID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CourtTypeID->CurrentValue));
			if ($curVal <> "")
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->lookupCacheOption($curVal);
			else
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->Lookup !== NULL && is_array($this->CourtTypeID->Lookup->Options) ? $curVal : NULL;
			if ($this->CourtTypeID->ViewValue !== NULL) { // Load from cache
				$this->CourtTypeID->EditValue = array_values($this->CourtTypeID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CourtTypeID`" . SearchString("=", $this->CourtTypeID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CourtTypeID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CourtTypeID->EditValue = $arwrk;
			}

			// ChamberID
			$this->ChamberID->EditAttrs["class"] = "form-control";
			$this->ChamberID->EditCustomAttributes = "";
			$curVal = trim(strval($this->ChamberID->CurrentValue));
			if ($curVal <> "")
				$this->ChamberID->ViewValue = $this->ChamberID->lookupCacheOption($curVal);
			else
				$this->ChamberID->ViewValue = $this->ChamberID->Lookup !== NULL && is_array($this->ChamberID->Lookup->Options) ? $curVal : NULL;
			if ($this->ChamberID->ViewValue !== NULL) { // Load from cache
				$this->ChamberID->EditValue = array_values($this->ChamberID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`ChamberID`" . SearchString("=", $this->ChamberID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->ChamberID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ChamberID->EditValue = $arwrk;
			}

			// CourtLocationID
			$this->CourtLocationID->EditAttrs["class"] = "form-control";
			$this->CourtLocationID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CourtLocationID->CurrentValue));
			if ($curVal <> "")
				$this->CourtLocationID->ViewValue = $this->CourtLocationID->lookupCacheOption($curVal);
			else
				$this->CourtLocationID->ViewValue = $this->CourtLocationID->Lookup !== NULL && is_array($this->CourtLocationID->Lookup->Options) ? $curVal : NULL;
			if ($this->CourtLocationID->ViewValue !== NULL) { // Load from cache
				$this->CourtLocationID->EditValue = array_values($this->CourtLocationID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CourtLocationID`" . SearchString("=", $this->CourtLocationID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CourtLocationID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CourtLocationID->EditValue = $arwrk;
			}

			// GovernorateID
			$this->GovernorateID->EditAttrs["class"] = "form-control";
			$this->GovernorateID->EditCustomAttributes = "";
			$curVal = trim(strval($this->GovernorateID->CurrentValue));
			if ($curVal <> "")
				$this->GovernorateID->ViewValue = $this->GovernorateID->lookupCacheOption($curVal);
			else
				$this->GovernorateID->ViewValue = $this->GovernorateID->Lookup !== NULL && is_array($this->GovernorateID->Lookup->Options) ? $curVal : NULL;
			if ($this->GovernorateID->ViewValue !== NULL) { // Load from cache
				$this->GovernorateID->EditValue = array_values($this->GovernorateID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`GovernorateID`" . SearchString("=", $this->GovernorateID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->GovernorateID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->GovernorateID->EditValue = $arwrk;
			}

			// SectionID
			$this->SectionID->EditAttrs["class"] = "form-control";
			$this->SectionID->EditCustomAttributes = "";
			$curVal = trim(strval($this->SectionID->CurrentValue));
			if ($curVal <> "")
				$this->SectionID->ViewValue = $this->SectionID->lookupCacheOption($curVal);
			else
				$this->SectionID->ViewValue = $this->SectionID->Lookup !== NULL && is_array($this->SectionID->Lookup->Options) ? $curVal : NULL;
			if ($this->SectionID->ViewValue !== NULL) { // Load from cache
				$this->SectionID->EditValue = array_values($this->SectionID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`SectionID`" . SearchString("=", $this->SectionID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->SectionID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->SectionID->EditValue = $arwrk;
			}

			// Notes
			$this->Notes->EditAttrs["class"] = "form-control";
			$this->Notes->EditCustomAttributes = "";
			$this->Notes->EditValue = HtmlEncode($this->Notes->CurrentValue);
			$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

			// Add refer script
			// Court

			$this->Court->LinkCustomAttributes = "";
			$this->Court->HrefValue = "";

			// CourtTypeID
			$this->CourtTypeID->LinkCustomAttributes = "";
			$this->CourtTypeID->HrefValue = "";

			// ChamberID
			$this->ChamberID->LinkCustomAttributes = "";
			$this->ChamberID->HrefValue = "";

			// CourtLocationID
			$this->CourtLocationID->LinkCustomAttributes = "";
			$this->CourtLocationID->HrefValue = "";

			// GovernorateID
			$this->GovernorateID->LinkCustomAttributes = "";
			$this->GovernorateID->HrefValue = "";

			// SectionID
			$this->SectionID->LinkCustomAttributes = "";
			$this->SectionID->HrefValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->CourtID->Required) {
			if (!$this->CourtID->IsDetailKey && $this->CourtID->FormValue != NULL && $this->CourtID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtID->caption(), $this->CourtID->RequiredErrorMessage));
			}
		}
		if ($this->Court->Required) {
			if (!$this->Court->IsDetailKey && $this->Court->FormValue != NULL && $this->Court->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Court->caption(), $this->Court->RequiredErrorMessage));
			}
		}
		if ($this->CourtEn->Required) {
			if (!$this->CourtEn->IsDetailKey && $this->CourtEn->FormValue != NULL && $this->CourtEn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtEn->caption(), $this->CourtEn->RequiredErrorMessage));
			}
		}
		if ($this->CourtTypeID->Required) {
			if (!$this->CourtTypeID->IsDetailKey && $this->CourtTypeID->FormValue != NULL && $this->CourtTypeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtTypeID->caption(), $this->CourtTypeID->RequiredErrorMessage));
			}
		}
		if ($this->ChamberID->Required) {
			if (!$this->ChamberID->IsDetailKey && $this->ChamberID->FormValue != NULL && $this->ChamberID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ChamberID->caption(), $this->ChamberID->RequiredErrorMessage));
			}
		}
		if ($this->CourtLocationID->Required) {
			if (!$this->CourtLocationID->IsDetailKey && $this->CourtLocationID->FormValue != NULL && $this->CourtLocationID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtLocationID->caption(), $this->CourtLocationID->RequiredErrorMessage));
			}
		}
		if ($this->GovernorateID->Required) {
			if (!$this->GovernorateID->IsDetailKey && $this->GovernorateID->FormValue != NULL && $this->GovernorateID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->GovernorateID->caption(), $this->GovernorateID->RequiredErrorMessage));
			}
		}
		if ($this->SectionID->Required) {
			if (!$this->SectionID->IsDetailKey && $this->SectionID->FormValue != NULL && $this->SectionID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SectionID->caption(), $this->SectionID->RequiredErrorMessage));
			}
		}
		if ($this->AddressID->Required) {
			if (!$this->AddressID->IsDetailKey && $this->AddressID->FormValue != NULL && $this->AddressID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->AddressID->caption(), $this->AddressID->RequiredErrorMessage));
			}
		}
		if ($this->ContactID->Required) {
			if (!$this->ContactID->IsDetailKey && $this->ContactID->FormValue != NULL && $this->ContactID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ContactID->caption(), $this->ContactID->RequiredErrorMessage));
			}
		}
		if ($this->Activated->Required) {
			if ($this->Activated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Activated->caption(), $this->Activated->RequiredErrorMessage));
			}
		}
		if ($this->Notes->Required) {
			if (!$this->Notes->IsDetailKey && $this->Notes->FormValue != NULL && $this->Notes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Notes->caption(), $this->Notes->RequiredErrorMessage));
			}
		}
		if ($this->_UserID->Required) {
			if (!$this->_UserID->IsDetailKey && $this->_UserID->FormValue != NULL && $this->_UserID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_UserID->caption(), $this->_UserID->RequiredErrorMessage));
			}
		}
		if ($this->CreatedBy->Required) {
			if (!$this->CreatedBy->IsDetailKey && $this->CreatedBy->FormValue != NULL && $this->CreatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedBy->caption(), $this->CreatedBy->RequiredErrorMessage));
			}
		}
		if ($this->CreatedDate->Required) {
			if (!$this->CreatedDate->IsDetailKey && $this->CreatedDate->FormValue != NULL && $this->CreatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedDate->caption(), $this->CreatedDate->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedBy->Required) {
			if (!$this->UpdatedBy->IsDetailKey && $this->UpdatedBy->FormValue != NULL && $this->UpdatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedBy->caption(), $this->UpdatedBy->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedDate->Required) {
			if (!$this->UpdatedDate->IsDetailKey && $this->UpdatedDate->FormValue != NULL && $this->UpdatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedDate->caption(), $this->UpdatedDate->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// Court
		$this->Court->setDbValueDef($rsnew, $this->Court->CurrentValue, "", FALSE);

		// CourtTypeID
		$this->CourtTypeID->setDbValueDef($rsnew, $this->CourtTypeID->CurrentValue, 0, FALSE);

		// ChamberID
		$this->ChamberID->setDbValueDef($rsnew, $this->ChamberID->CurrentValue, NULL, FALSE);

		// CourtLocationID
		$this->CourtLocationID->setDbValueDef($rsnew, $this->CourtLocationID->CurrentValue, NULL, FALSE);

		// GovernorateID
		$this->GovernorateID->setDbValueDef($rsnew, $this->GovernorateID->CurrentValue, NULL, FALSE);

		// SectionID
		$this->SectionID->setDbValueDef($rsnew, $this->SectionID->CurrentValue, NULL, FALSE);

		// Notes
		$this->Notes->setDbValueDef($rsnew, $this->Notes->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("courtslist.php"), "", $this->TableVar, TRUE);
		$pageId = "addopt";
		$Breadcrumb->add("addopt", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_CourtTypeID":
							break;
						case "x_ChamberID":
							break;
						case "x_CourtLocationID":
							break;
						case "x_GovernorateID":
							break;
						case "x_SectionID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
