<?php
namespace PHPMaker2019\project_germanos;

/**
 * Table class for cases
 */
class cases extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $CaseID;
	public $ClientID;
	public $LitigantID;
	public $CaseTypeID;
	public $CourtID;
	public $CaseNumber;
	public $FileNumber;
	public $EnvelopeNumber;
	public $ClientStatusID;
	public $LitigantStatusID;
	public $CourtTypeID;
	public $CourtGenderID;
	public $JudgeID;
	public $Notes;
	public $FileLocation;
	public $_Case;
	public $CaseEn;
	public $CaseSortID;
	public $CaseRegisteredDate;
	public $CaseStatusID;
	public $ParentCaseID;
	public $FileNumber2;
	public $_UserID;
	public $CreatedBy;
	public $CreatedDate;
	public $UpdatedBy;
	public $UpdatedDate;
	public $CaseTypeConv;
	public $CaseConv;
	public $ClientStatusConv;
	public $LitigantStatusConv;
	public $ClientNameConv;
	public $LitigantNameConv;
	public $ClientNameConvFiles;
	public $LitigantNameConvFiles;
	public $CaseTypeConvFiles;
	public $CourtConvFiles;
	public $FileNumberConvFiles;
	public $CaseNumberConvFiles;
	public $NotesConvFiles;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'cases';
		$this->TableName = 'cases';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`cases`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = TRUE; // Allow detail add
		$this->DetailEdit = TRUE; // Allow detail edit
		$this->DetailView = TRUE; // Allow detail view
		$this->ShowMultipleDetails = TRUE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "AND";

		// CaseID
		$this->CaseID = new DbField('cases', 'cases', 'x_CaseID', 'CaseID', '`CaseID`', '`CaseID`', 3, -1, FALSE, '`CaseID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->CaseID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->CaseID->IsPrimaryKey = TRUE; // Primary key field
		$this->CaseID->IsForeignKey = TRUE; // Foreign key field
		$this->CaseID->Sortable = TRUE; // Allow sort
		$this->CaseID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CaseID'] = &$this->CaseID;

		// ClientID
		$this->ClientID = new DbField('cases', 'cases', 'x_ClientID', 'ClientID', '`ClientID`', '`ClientID`', 3, -1, FALSE, '`EV__ClientID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->ClientID->IsForeignKey = TRUE; // Foreign key field
		$this->ClientID->Required = TRUE; // Required field
		$this->ClientID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstNameEn","MiddleNameEn","LastNameEn",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstNameEn","MiddleNameEn","LastNameEn",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->ClientID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ClientID'] = &$this->ClientID;

		// LitigantID
		$this->LitigantID = new DbField('cases', 'cases', 'x_LitigantID', 'LitigantID', '`LitigantID`', '`LitigantID`', 3, -1, FALSE, '`EV__LitigantID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->LitigantID->IsForeignKey = TRUE; // Foreign key field
		$this->LitigantID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstNameEn","MiddleNameEn","LastNameEn",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstNameEn","MiddleNameEn","LastNameEn",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->LitigantID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['LitigantID'] = &$this->LitigantID;

		// CaseTypeID
		$this->CaseTypeID = new DbField('cases', 'cases', 'x_CaseTypeID', 'CaseTypeID', '`CaseTypeID`', '`CaseTypeID`', 3, -1, FALSE, '`EV__CaseTypeID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CaseTypeID->Nullable = FALSE; // NOT NULL field
		$this->CaseTypeID->Required = TRUE; // Required field
		$this->CaseTypeID->Sortable = TRUE; // Allow sort
		$this->CaseTypeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CaseTypeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseType",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseTypeEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseTypeEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseType","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CaseTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CaseTypeID'] = &$this->CaseTypeID;

		// CourtID
		$this->CourtID = new DbField('cases', 'cases', 'x_CourtID', 'CourtID', '`CourtID`', '`CourtID`', 3, -1, FALSE, '`EV__CourtID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["CourtEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["CourtEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtID'] = &$this->CourtID;

		// CaseNumber
		$this->CaseNumber = new DbField('cases', 'cases', 'x_CaseNumber', 'CaseNumber', '`CaseNumber`', '`CaseNumber`', 200, -1, FALSE, '`CaseNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseNumber->Sortable = TRUE; // Allow sort
		$this->fields['CaseNumber'] = &$this->CaseNumber;

		// FileNumber
		$this->FileNumber = new DbField('cases', 'cases', 'x_FileNumber', 'FileNumber', '`FileNumber`', '`FileNumber`', 200, -1, FALSE, '`FileNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->FileNumber->Nullable = FALSE; // NOT NULL field
		$this->FileNumber->Required = TRUE; // Required field
		$this->FileNumber->Sortable = TRUE; // Allow sort
		$this->fields['FileNumber'] = &$this->FileNumber;

		// EnvelopeNumber
		$this->EnvelopeNumber = new DbField('cases', 'cases', 'x_EnvelopeNumber', 'EnvelopeNumber', '`EnvelopeNumber`', '`EnvelopeNumber`', 3, -1, FALSE, '`EnvelopeNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->EnvelopeNumber->Sortable = TRUE; // Allow sort
		$this->fields['EnvelopeNumber'] = &$this->EnvelopeNumber;

		// ClientStatusID
		$this->ClientStatusID = new DbField('cases', 'cases', 'x_ClientStatusID', 'ClientStatusID', '`ClientStatusID`', '`ClientStatusID`', 3, -1, FALSE, '`EV__ClientStatusID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->ClientStatusID->Nullable = FALSE; // NOT NULL field
		$this->ClientStatusID->Required = TRUE; // Required field
		$this->ClientStatusID->Sortable = TRUE; // Allow sort
		$this->ClientStatusID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ClientStatusID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatusEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatusEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->ClientStatusID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ClientStatusID'] = &$this->ClientStatusID;

		// LitigantStatusID
		$this->LitigantStatusID = new DbField('cases', 'cases', 'x_LitigantStatusID', 'LitigantStatusID', '`LitigantStatusID`', '`LitigantStatusID`', 3, -1, FALSE, '`EV__LitigantStatusID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->LitigantStatusID->Nullable = FALSE; // NOT NULL field
		$this->LitigantStatusID->Sortable = TRUE; // Allow sort
		$this->LitigantStatusID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->LitigantStatusID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatusEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatusEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->LitigantStatusID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['LitigantStatusID'] = &$this->LitigantStatusID;

		// CourtTypeID
		$this->CourtTypeID = new DbField('cases', 'cases', 'x_CourtTypeID', 'CourtTypeID', '`CourtTypeID`', '`CourtTypeID`', 3, -1, FALSE, '`EV__CourtTypeID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CourtTypeID->Sortable = FALSE; // Allow sort
		$this->CourtTypeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CourtTypeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtType",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtTypeEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtTypeEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtType","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtTypeID'] = &$this->CourtTypeID;

		// CourtGenderID
		$this->CourtGenderID = new DbField('cases', 'cases', 'x_CourtGenderID', 'CourtGenderID', '`CourtGenderID`', '`CourtGenderID`', 3, -1, FALSE, '`EV__CourtGenderID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CourtGenderID->Sortable = FALSE; // Allow sort
		$this->CourtGenderID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CourtGenderID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtGenderID->Lookup = new Lookup('CourtGenderID', 'courtgender', TRUE, 'CourtGenderID', ["CourtGender",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtGenderID->Lookup = new Lookup('CourtGenderID', 'courtgender', TRUE, 'CourtGenderID', ["CourtGenderEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtGenderID->Lookup = new Lookup('CourtGenderID', 'courtgender', TRUE, 'CourtGenderID', ["CourtGenderEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtGenderID->Lookup = new Lookup('CourtGenderID', 'courtgender', TRUE, 'CourtGenderID', ["CourtGender","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtGenderID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtGenderID'] = &$this->CourtGenderID;

		// JudgeID
		$this->JudgeID = new DbField('cases', 'cases', 'x_JudgeID', 'JudgeID', '`JudgeID`', '`JudgeID`', 3, -1, FALSE, '`EV__JudgeID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->JudgeID->Sortable = TRUE; // Allow sort
		$this->JudgeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->JudgeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstNameEn","MiddleNameEn","LastNameEn",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstNameEn","MiddleNameEn","LastNameEn",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->JudgeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['JudgeID'] = &$this->JudgeID;

		// Notes
		$this->Notes = new DbField('cases', 'cases', 'x_Notes', 'Notes', '`Notes`', '`Notes`', 201, -1, FALSE, '`Notes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Notes->Sortable = TRUE; // Allow sort
		$this->fields['Notes'] = &$this->Notes;

		// FileLocation
		$this->FileLocation = new DbField('cases', 'cases', 'x_FileLocation', 'FileLocation', '`FileLocation`', '`FileLocation`', 200, -1, FALSE, '`FileLocation`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->FileLocation->Sortable = TRUE; // Allow sort
		$this->fields['FileLocation'] = &$this->FileLocation;

		// Case
		$this->_Case = new DbField('cases', 'cases', 'x__Case', 'Case', '`Case`', '`Case`', 200, -1, FALSE, '`Case`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_Case->Sortable = TRUE; // Allow sort
		$this->fields['Case'] = &$this->_Case;

		// CaseEn
		$this->CaseEn = new DbField('cases', 'cases', 'x_CaseEn', 'CaseEn', '`CaseEn`', '`CaseEn`', 200, -1, FALSE, '`CaseEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseEn->Sortable = FALSE; // Allow sort
		$this->fields['CaseEn'] = &$this->CaseEn;

		// CaseSortID
		$this->CaseSortID = new DbField('cases', 'cases', 'x_CaseSortID', 'CaseSortID', '`CaseSortID`', '`CaseSortID`', 3, -1, FALSE, '`EV__CaseSortID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CaseSortID->Nullable = FALSE; // NOT NULL field
		$this->CaseSortID->Sortable = TRUE; // Allow sort
		$this->CaseSortID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CaseSortID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSort",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSortEn",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSortEn",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSort","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CaseSortID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CaseSortID'] = &$this->CaseSortID;

		// CaseRegisteredDate
		$this->CaseRegisteredDate = new DbField('cases', 'cases', 'x_CaseRegisteredDate', 'CaseRegisteredDate', '`CaseRegisteredDate`', CastDateFieldForLike('`CaseRegisteredDate`', 7, "DB"), 133, 7, FALSE, '`CaseRegisteredDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseRegisteredDate->Sortable = TRUE; // Allow sort
		$this->CaseRegisteredDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['CaseRegisteredDate'] = &$this->CaseRegisteredDate;

		// CaseStatusID
		$this->CaseStatusID = new DbField('cases', 'cases', 'x_CaseStatusID', 'CaseStatusID', '`CaseStatusID`', '`CaseStatusID`', 3, -1, FALSE, '`EV__CaseStatusID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CaseStatusID->Nullable = FALSE; // NOT NULL field
		$this->CaseStatusID->Required = TRUE; // Required field
		$this->CaseStatusID->Sortable = TRUE; // Allow sort
		$this->CaseStatusID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CaseStatusID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatus",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatusEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatusEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatus","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CaseStatusID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CaseStatusID'] = &$this->CaseStatusID;

		// ParentCaseID
		$this->ParentCaseID = new DbField('cases', 'cases', 'x_ParentCaseID', 'ParentCaseID', '`ParentCaseID`', '`ParentCaseID`', 3, -1, FALSE, '`ParentCaseID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ParentCaseID->Sortable = TRUE; // Allow sort
		$this->ParentCaseID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ParentCaseID'] = &$this->ParentCaseID;

		// FileNumber2
		$this->FileNumber2 = new DbField('cases', 'cases', 'x_FileNumber2', 'FileNumber2', 'cast(`FileNumber` as signed)', 'cast(`FileNumber` as signed)', 20, -1, FALSE, 'cast(`FileNumber` as signed)', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->FileNumber2->IsCustom = TRUE; // Custom field
		$this->FileNumber2->Sortable = TRUE; // Allow sort
		$this->FileNumber2->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['FileNumber2'] = &$this->FileNumber2;

		// UserID
		$this->_UserID = new DbField('cases', 'cases', 'x__UserID', 'UserID', '`UserID`', '`UserID`', 3, -1, FALSE, '`UserID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_UserID->Sortable = FALSE; // Allow sort
		$this->_UserID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['UserID'] = &$this->_UserID;

		// CreatedBy
		$this->CreatedBy = new DbField('cases', 'cases', 'x_CreatedBy', 'CreatedBy', '`CreatedBy`', '`CreatedBy`', 200, -1, FALSE, '`CreatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->CreatedBy->Sortable = FALSE; // Allow sort
		$this->fields['CreatedBy'] = &$this->CreatedBy;

		// CreatedDate
		$this->CreatedDate = new DbField('cases', 'cases', 'x_CreatedDate', 'CreatedDate', '`CreatedDate`', CastDateFieldForLike('`CreatedDate`', 0, "DB"), 135, 0, FALSE, '`CreatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->CreatedDate->Sortable = FALSE; // Allow sort
		$this->CreatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['CreatedDate'] = &$this->CreatedDate;

		// UpdatedBy
		$this->UpdatedBy = new DbField('cases', 'cases', 'x_UpdatedBy', 'UpdatedBy', '`UpdatedBy`', '`UpdatedBy`', 200, -1, FALSE, '`UpdatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->UpdatedBy->Sortable = FALSE; // Allow sort
		$this->fields['UpdatedBy'] = &$this->UpdatedBy;

		// UpdatedDate
		$this->UpdatedDate = new DbField('cases', 'cases', 'x_UpdatedDate', 'UpdatedDate', '`UpdatedDate`', CastDateFieldForLike('`UpdatedDate`', 0, "DB"), 135, 0, FALSE, '`UpdatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->UpdatedDate->Sortable = FALSE; // Allow sort
		$this->UpdatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['UpdatedDate'] = &$this->UpdatedDate;

		// CaseTypeConv
		$this->CaseTypeConv = new DbField('cases', 'cases', 'x_CaseTypeConv', 'CaseTypeConv', '`CaseTypeConv`', '`CaseTypeConv`', 200, -1, FALSE, '`CaseTypeConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseTypeConv->Sortable = FALSE; // Allow sort
		$this->fields['CaseTypeConv'] = &$this->CaseTypeConv;

		// CaseConv
		$this->CaseConv = new DbField('cases', 'cases', 'x_CaseConv', 'CaseConv', '`CaseConv`', '`CaseConv`', 200, -1, FALSE, '`CaseConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseConv->Sortable = FALSE; // Allow sort
		$this->fields['CaseConv'] = &$this->CaseConv;

		// ClientStatusConv
		$this->ClientStatusConv = new DbField('cases', 'cases', 'x_ClientStatusConv', 'ClientStatusConv', '`ClientStatusConv`', '`ClientStatusConv`', 200, -1, FALSE, '`ClientStatusConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ClientStatusConv->Sortable = FALSE; // Allow sort
		$this->fields['ClientStatusConv'] = &$this->ClientStatusConv;

		// LitigantStatusConv
		$this->LitigantStatusConv = new DbField('cases', 'cases', 'x_LitigantStatusConv', 'LitigantStatusConv', '`LitigantStatusConv`', '`LitigantStatusConv`', 200, -1, FALSE, '`LitigantStatusConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->LitigantStatusConv->Sortable = FALSE; // Allow sort
		$this->fields['LitigantStatusConv'] = &$this->LitigantStatusConv;

		// ClientNameConv
		$this->ClientNameConv = new DbField('cases', 'cases', 'x_ClientNameConv', 'ClientNameConv', '`ClientNameConv`', '`ClientNameConv`', 200, -1, FALSE, '`ClientNameConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ClientNameConv->Sortable = FALSE; // Allow sort
		$this->fields['ClientNameConv'] = &$this->ClientNameConv;

		// LitigantNameConv
		$this->LitigantNameConv = new DbField('cases', 'cases', 'x_LitigantNameConv', 'LitigantNameConv', '`LitigantNameConv`', '`LitigantNameConv`', 200, -1, FALSE, '`LitigantNameConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->LitigantNameConv->Sortable = FALSE; // Allow sort
		$this->fields['LitigantNameConv'] = &$this->LitigantNameConv;

		// ClientNameConvFiles
		$this->ClientNameConvFiles = new DbField('cases', 'cases', 'x_ClientNameConvFiles', 'ClientNameConvFiles', '`ClientNameConvFiles`', '`ClientNameConvFiles`', 200, -1, FALSE, '`ClientNameConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ClientNameConvFiles->Sortable = FALSE; // Allow sort
		$this->fields['ClientNameConvFiles'] = &$this->ClientNameConvFiles;

		// LitigantNameConvFiles
		$this->LitigantNameConvFiles = new DbField('cases', 'cases', 'x_LitigantNameConvFiles', 'LitigantNameConvFiles', '`LitigantNameConvFiles`', '`LitigantNameConvFiles`', 200, -1, FALSE, '`LitigantNameConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->LitigantNameConvFiles->Sortable = FALSE; // Allow sort
		$this->fields['LitigantNameConvFiles'] = &$this->LitigantNameConvFiles;

		// CaseTypeConvFiles
		$this->CaseTypeConvFiles = new DbField('cases', 'cases', 'x_CaseTypeConvFiles', 'CaseTypeConvFiles', '`CaseTypeConvFiles`', '`CaseTypeConvFiles`', 200, -1, FALSE, '`CaseTypeConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseTypeConvFiles->Sortable = FALSE; // Allow sort
		$this->fields['CaseTypeConvFiles'] = &$this->CaseTypeConvFiles;

		// CourtConvFiles
		$this->CourtConvFiles = new DbField('cases', 'cases', 'x_CourtConvFiles', 'CourtConvFiles', '`CourtConvFiles`', '`CourtConvFiles`', 200, -1, FALSE, '`CourtConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtConvFiles->Sortable = FALSE; // Allow sort
		$this->fields['CourtConvFiles'] = &$this->CourtConvFiles;

		// FileNumberConvFiles
		$this->FileNumberConvFiles = new DbField('cases', 'cases', 'x_FileNumberConvFiles', 'FileNumberConvFiles', '`FileNumberConvFiles`', '`FileNumberConvFiles`', 200, -1, FALSE, '`FileNumberConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->FileNumberConvFiles->Sortable = FALSE; // Allow sort
		$this->fields['FileNumberConvFiles'] = &$this->FileNumberConvFiles;

		// CaseNumberConvFiles
		$this->CaseNumberConvFiles = new DbField('cases', 'cases', 'x_CaseNumberConvFiles', 'CaseNumberConvFiles', '`CaseNumberConvFiles`', '`CaseNumberConvFiles`', 200, -1, FALSE, '`CaseNumberConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseNumberConvFiles->Sortable = FALSE; // Allow sort
		$this->fields['CaseNumberConvFiles'] = &$this->CaseNumberConvFiles;

		// NotesConvFiles
		$this->NotesConvFiles = new DbField('cases', 'cases', 'x_NotesConvFiles', 'NotesConvFiles', '`NotesConvFiles`', '`NotesConvFiles`', 200, -1, FALSE, '`NotesConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NotesConvFiles->Sortable = FALSE; // Allow sort
		$this->fields['NotesConvFiles'] = &$this->NotesConvFiles;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "clients") {
			if ($this->ClientID->getSessionValue() <> "")
				$masterFilter .= "`ClientID`=" . QuotedValue($this->ClientID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "litigants") {
			if ($this->LitigantID->getSessionValue() <> "")
				$masterFilter .= "`LitigantID`=" . QuotedValue($this->LitigantID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "clients") {
			if ($this->ClientID->getSessionValue() <> "")
				$detailFilter .= "`ClientID`=" . QuotedValue($this->ClientID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "litigants") {
			if ($this->LitigantID->getSessionValue() <> "")
				$detailFilter .= "`LitigantID`=" . QuotedValue($this->LitigantID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_clients()
	{
		return "`ClientID`=@ClientID@";
	}

	// Detail filter
	public function sqlDetailFilter_clients()
	{
		return "`ClientID`=@ClientID@";
	}

	// Master filter
	public function sqlMasterFilter_litigants()
	{
		return "`LitigantID`=@LitigantID@";
	}

	// Detail filter
	public function sqlDetailFilter_litigants()
	{
		return "`LitigantID`=@LitigantID@";
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "hearings") {
			$detailUrl = $GLOBALS["hearings"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_CaseID=" . urlencode($this->CaseID->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "notices") {
			$detailUrl = $GLOBALS["notices"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_CaseID=" . urlencode($this->CaseID->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "complaints") {
			$detailUrl = $GLOBALS["complaints"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_CaseID=" . urlencode($this->CaseID->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "notifications") {
			$detailUrl = $GLOBALS["notifications"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_CaseID=" . urlencode($this->CaseID->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "attachments") {
			$detailUrl = $GLOBALS["attachments"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_CaseID=" . urlencode($this->CaseID->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "caseslist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`cases`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, cast(`FileNumber` as signed) AS `FileNumber2` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		global $CurrentLanguage;
		switch ($CurrentLanguage) {
			case "ar":
				$select = "SELECT * FROM (" .
					"SELECT *, cast(`FileNumber` as signed) AS `FileNumber2`, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->ClientID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->ClientID) . "',COALESCE(`LastName`,'')) FROM `clients` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ClientID` = `cases`.`ClientID` LIMIT 1) AS `EV__ClientID`, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->LitigantID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->LitigantID) . "',COALESCE(`LastName`,'')) FROM `litigants` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`LitigantID` = `cases`.`LitigantID` LIMIT 1) AS `EV__LitigantID`, (SELECT DISTINCT `CaseType` FROM `casetypes` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseTypeID` = `cases`.`CaseTypeID` LIMIT 1) AS `EV__CaseTypeID`, (SELECT DISTINCT `Court` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `cases`.`CourtID` LIMIT 1) AS `EV__CourtID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `cases`.`ClientStatusID` LIMIT 1) AS `EV__ClientStatusID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `cases`.`LitigantStatusID` LIMIT 1) AS `EV__LitigantStatusID`, (SELECT DISTINCT `CourtType` FROM `courttype` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtTypeID` = `cases`.`CourtTypeID` LIMIT 1) AS `EV__CourtTypeID`, (SELECT DISTINCT `CourtGender` FROM `courtgender` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtGenderID` = `cases`.`CourtGenderID` LIMIT 1) AS `EV__CourtGenderID`, (SELECT DISTINCT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->JudgeID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->JudgeID) . "',COALESCE(`LastName`,'')) FROM `judges` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`JudgeID` = `cases`.`JudgeID` LIMIT 1) AS `EV__JudgeID`, (SELECT DISTINCT `CaseSort` FROM `casesort` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseSortID` = `cases`.`CaseSortID` LIMIT 1) AS `EV__CaseSortID`, (SELECT DISTINCT `CaseStatus` FROM `casestatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseStatusID` = `cases`.`CaseStatusID` LIMIT 1) AS `EV__CaseStatusID` FROM `cases`" .
					") `TMP_TABLE`";
				break;
			case "en":
				$select = "SELECT * FROM (" .
					"SELECT *, cast(`FileNumber` as signed) AS `FileNumber2`, (SELECT CONCAT(COALESCE(`FirstNameEn`, ''),'" . ValueSeparator(1, $this->ClientID) . "',COALESCE(`MiddleNameEn`,''),'" . ValueSeparator(2, $this->ClientID) . "',COALESCE(`LastNameEn`,'')) FROM `clients` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ClientID` = `cases`.`ClientID` LIMIT 1) AS `EV__ClientID`, (SELECT CONCAT(COALESCE(`FirstNameEn`, ''),'" . ValueSeparator(1, $this->LitigantID) . "',COALESCE(`MiddleNameEn`,''),'" . ValueSeparator(2, $this->LitigantID) . "',COALESCE(`LastNameEn`,'')) FROM `litigants` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`LitigantID` = `cases`.`LitigantID` LIMIT 1) AS `EV__LitigantID`, (SELECT DISTINCT `CaseTypeEn` FROM `casetypes` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseTypeID` = `cases`.`CaseTypeID` LIMIT 1) AS `EV__CaseTypeID`, (SELECT DISTINCT `CourtEn` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `cases`.`CourtID` LIMIT 1) AS `EV__CourtID`, (SELECT DISTINCT `PartiesStatusEn` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `cases`.`ClientStatusID` LIMIT 1) AS `EV__ClientStatusID`, (SELECT DISTINCT `PartiesStatusEn` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `cases`.`LitigantStatusID` LIMIT 1) AS `EV__LitigantStatusID`, (SELECT DISTINCT `CourtTypeEn` FROM `courttype` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtTypeID` = `cases`.`CourtTypeID` LIMIT 1) AS `EV__CourtTypeID`, (SELECT DISTINCT `CourtGenderEn` FROM `courtgender` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtGenderID` = `cases`.`CourtGenderID` LIMIT 1) AS `EV__CourtGenderID`, (SELECT DISTINCT CONCAT(COALESCE(`FirstNameEn`, ''),'" . ValueSeparator(1, $this->JudgeID) . "',COALESCE(`MiddleNameEn`,''),'" . ValueSeparator(2, $this->JudgeID) . "',COALESCE(`LastNameEn`,'')) FROM `judges` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`JudgeID` = `cases`.`JudgeID` LIMIT 1) AS `EV__JudgeID`, (SELECT DISTINCT `CaseSortEn` FROM `casesort` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseSortID` = `cases`.`CaseSortID` LIMIT 1) AS `EV__CaseSortID`, (SELECT DISTINCT `CaseStatusEn` FROM `casestatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseStatusID` = `cases`.`CaseStatusID` LIMIT 1) AS `EV__CaseStatusID` FROM `cases`" .
					") `TMP_TABLE`";
				break;
			case "fr":
				$select = "SELECT * FROM (" .
					"SELECT *, cast(`FileNumber` as signed) AS `FileNumber2`, (SELECT CONCAT(COALESCE(`FirstNameEn`, ''),'" . ValueSeparator(1, $this->ClientID) . "',COALESCE(`MiddleNameEn`,''),'" . ValueSeparator(2, $this->ClientID) . "',COALESCE(`LastNameEn`,'')) FROM `clients` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ClientID` = `cases`.`ClientID` LIMIT 1) AS `EV__ClientID`, (SELECT CONCAT(COALESCE(`FirstNameEn`, ''),'" . ValueSeparator(1, $this->LitigantID) . "',COALESCE(`MiddleNameEn`,''),'" . ValueSeparator(2, $this->LitigantID) . "',COALESCE(`LastNameEn`,'')) FROM `litigants` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`LitigantID` = `cases`.`LitigantID` LIMIT 1) AS `EV__LitigantID`, (SELECT DISTINCT `CaseTypeEn` FROM `casetypes` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseTypeID` = `cases`.`CaseTypeID` LIMIT 1) AS `EV__CaseTypeID`, (SELECT DISTINCT `CourtEn` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `cases`.`CourtID` LIMIT 1) AS `EV__CourtID`, (SELECT DISTINCT `PartiesStatusEn` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `cases`.`ClientStatusID` LIMIT 1) AS `EV__ClientStatusID`, (SELECT DISTINCT `PartiesStatusEn` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `cases`.`LitigantStatusID` LIMIT 1) AS `EV__LitigantStatusID`, (SELECT DISTINCT `CourtTypeEn` FROM `courttype` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtTypeID` = `cases`.`CourtTypeID` LIMIT 1) AS `EV__CourtTypeID`, (SELECT DISTINCT `CourtGenderEn` FROM `courtgender` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtGenderID` = `cases`.`CourtGenderID` LIMIT 1) AS `EV__CourtGenderID`, (SELECT DISTINCT CONCAT(COALESCE(`FirstNameEn`, ''),'" . ValueSeparator(1, $this->JudgeID) . "',COALESCE(`MiddleNameEn`,''),'" . ValueSeparator(2, $this->JudgeID) . "',COALESCE(`LastNameEn`,'')) FROM `judges` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`JudgeID` = `cases`.`JudgeID` LIMIT 1) AS `EV__JudgeID`, (SELECT DISTINCT `CaseSortEn` FROM `casesort` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseSortID` = `cases`.`CaseSortID` LIMIT 1) AS `EV__CaseSortID`, (SELECT DISTINCT `CaseStatusEn` FROM `casestatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseStatusID` = `cases`.`CaseStatusID` LIMIT 1) AS `EV__CaseStatusID` FROM `cases`" .
					") `TMP_TABLE`";
				break;
			default:
				$select = "SELECT * FROM (" .
					"SELECT *, cast(`FileNumber` as signed) AS `FileNumber2`, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->ClientID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->ClientID) . "',COALESCE(`LastName`,'')) FROM `clients` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ClientID` = `cases`.`ClientID` LIMIT 1) AS `EV__ClientID`, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->LitigantID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->LitigantID) . "',COALESCE(`LastName`,'')) FROM `litigants` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`LitigantID` = `cases`.`LitigantID` LIMIT 1) AS `EV__LitigantID`, (SELECT DISTINCT `CaseType` FROM `casetypes` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseTypeID` = `cases`.`CaseTypeID` LIMIT 1) AS `EV__CaseTypeID`, (SELECT DISTINCT `Court` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `cases`.`CourtID` LIMIT 1) AS `EV__CourtID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `cases`.`ClientStatusID` LIMIT 1) AS `EV__ClientStatusID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `cases`.`LitigantStatusID` LIMIT 1) AS `EV__LitigantStatusID`, (SELECT DISTINCT `CourtType` FROM `courttype` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtTypeID` = `cases`.`CourtTypeID` LIMIT 1) AS `EV__CourtTypeID`, (SELECT DISTINCT `CourtGender` FROM `courtgender` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtGenderID` = `cases`.`CourtGenderID` LIMIT 1) AS `EV__CourtGenderID`, (SELECT DISTINCT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->JudgeID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->JudgeID) . "',COALESCE(`LastName`,'')) FROM `judges` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`JudgeID` = `cases`.`JudgeID` LIMIT 1) AS `EV__JudgeID`, (SELECT DISTINCT `CaseSort` FROM `casesort` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseSortID` = `cases`.`CaseSortID` LIMIT 1) AS `EV__CaseSortID`, (SELECT DISTINCT `CaseStatus` FROM `casestatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseStatusID` = `cases`.`CaseStatusID` LIMIT 1) AS `EV__CaseStatusID` FROM `cases`" .
					") `TMP_TABLE`";
				break;
		}
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->ClientID->AdvancedSearch->SearchValue <> "" ||
			$this->ClientID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->ClientID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->ClientID->VirtualExpression . " "))
			return TRUE;
		if ($this->LitigantID->AdvancedSearch->SearchValue <> "" ||
			$this->LitigantID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->LitigantID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->LitigantID->VirtualExpression . " "))
			return TRUE;
		if ($this->CaseTypeID->AdvancedSearch->SearchValue <> "" ||
			$this->CaseTypeID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CaseTypeID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CaseTypeID->VirtualExpression . " "))
			return TRUE;
		if ($this->CourtID->AdvancedSearch->SearchValue <> "" ||
			$this->CourtID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CourtID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CourtID->VirtualExpression . " "))
			return TRUE;
		if ($this->ClientStatusID->AdvancedSearch->SearchValue <> "" ||
			$this->ClientStatusID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->ClientStatusID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->ClientStatusID->VirtualExpression . " "))
			return TRUE;
		if ($this->LitigantStatusID->AdvancedSearch->SearchValue <> "" ||
			$this->LitigantStatusID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->LitigantStatusID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->LitigantStatusID->VirtualExpression . " "))
			return TRUE;
		if ($this->CourtTypeID->AdvancedSearch->SearchValue <> "" ||
			$this->CourtTypeID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CourtTypeID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CourtTypeID->VirtualExpression . " "))
			return TRUE;
		if ($this->CourtGenderID->AdvancedSearch->SearchValue <> "" ||
			$this->CourtGenderID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CourtGenderID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CourtGenderID->VirtualExpression . " "))
			return TRUE;
		if ($this->JudgeID->AdvancedSearch->SearchValue <> "" ||
			$this->JudgeID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->JudgeID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->JudgeID->VirtualExpression . " "))
			return TRUE;
		if ($this->CaseSortID->AdvancedSearch->SearchValue <> "" ||
			$this->CaseSortID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CaseSortID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CaseSortID->VirtualExpression . " "))
			return TRUE;
		if ($this->CaseStatusID->AdvancedSearch->SearchValue <> "" ||
			$this->CaseStatusID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CaseStatusID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CaseStatusID->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->CaseID->setDbValue($conn->insert_ID());
			$rs['CaseID'] = $this->CaseID->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'CaseID';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('CaseID', $rs))
				AddFilter($where, QuotedName('CaseID', $this->Dbid) . '=' . QuotedValue($rs['CaseID'], $this->CaseID->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();

		// Cascade delete detail table 'hearings'
		if (!isset($GLOBALS["hearings"]))
			$GLOBALS["hearings"] = new hearings();
		$rscascade = $GLOBALS["hearings"]->loadRs("`CaseID` = " . QuotedValue($rs['CaseID'], DATATYPE_NUMBER, "DB")); 
		$dtlrows = ($rscascade) ? $rscascade->getRows() : array();

		// Call Row Deleting event
		foreach ($dtlrows as $dtlrow) {
			$success = $GLOBALS["hearings"]->Row_Deleting($dtlrow);
			if (!$success)
				break;
		}
		if ($success) {
			foreach ($dtlrows as $dtlrow) {
				$success = $GLOBALS["hearings"]->delete($dtlrow); // Delete
				if (!$success)
					break;
			}
		}

		// Call Row Deleted event
		if ($success) {
			foreach ($dtlrows as $dtlrow)
				$GLOBALS["hearings"]->Row_Deleted($dtlrow);
		}

		// Cascade delete detail table 'notices'
		if (!isset($GLOBALS["notices"]))
			$GLOBALS["notices"] = new notices();
		$rscascade = $GLOBALS["notices"]->loadRs("`CaseID` = " . QuotedValue($rs['CaseID'], DATATYPE_NUMBER, "DB")); 
		$dtlrows = ($rscascade) ? $rscascade->getRows() : array();

		// Call Row Deleting event
		foreach ($dtlrows as $dtlrow) {
			$success = $GLOBALS["notices"]->Row_Deleting($dtlrow);
			if (!$success)
				break;
		}
		if ($success) {
			foreach ($dtlrows as $dtlrow) {
				$success = $GLOBALS["notices"]->delete($dtlrow); // Delete
				if (!$success)
					break;
			}
		}

		// Call Row Deleted event
		if ($success) {
			foreach ($dtlrows as $dtlrow)
				$GLOBALS["notices"]->Row_Deleted($dtlrow);
		}

		// Cascade delete detail table 'complaints'
		if (!isset($GLOBALS["complaints"]))
			$GLOBALS["complaints"] = new complaints();
		$rscascade = $GLOBALS["complaints"]->loadRs("`CaseID` = " . QuotedValue($rs['CaseID'], DATATYPE_NUMBER, "DB")); 
		$dtlrows = ($rscascade) ? $rscascade->getRows() : array();

		// Call Row Deleting event
		foreach ($dtlrows as $dtlrow) {
			$success = $GLOBALS["complaints"]->Row_Deleting($dtlrow);
			if (!$success)
				break;
		}
		if ($success) {
			foreach ($dtlrows as $dtlrow) {
				$success = $GLOBALS["complaints"]->delete($dtlrow); // Delete
				if (!$success)
					break;
			}
		}

		// Call Row Deleted event
		if ($success) {
			foreach ($dtlrows as $dtlrow)
				$GLOBALS["complaints"]->Row_Deleted($dtlrow);
		}

		// Cascade delete detail table 'notifications'
		if (!isset($GLOBALS["notifications"]))
			$GLOBALS["notifications"] = new notifications();
		$rscascade = $GLOBALS["notifications"]->loadRs("`CaseID` = " . QuotedValue($rs['CaseID'], DATATYPE_NUMBER, "DB")); 
		$dtlrows = ($rscascade) ? $rscascade->getRows() : array();

		// Call Row Deleting event
		foreach ($dtlrows as $dtlrow) {
			$success = $GLOBALS["notifications"]->Row_Deleting($dtlrow);
			if (!$success)
				break;
		}
		if ($success) {
			foreach ($dtlrows as $dtlrow) {
				$success = $GLOBALS["notifications"]->delete($dtlrow); // Delete
				if (!$success)
					break;
			}
		}

		// Call Row Deleted event
		if ($success) {
			foreach ($dtlrows as $dtlrow)
				$GLOBALS["notifications"]->Row_Deleted($dtlrow);
		}

		// Cascade delete detail table 'attachments'
		if (!isset($GLOBALS["attachments"]))
			$GLOBALS["attachments"] = new attachments();
		$rscascade = $GLOBALS["attachments"]->loadRs("`CaseID` = " . QuotedValue($rs['CaseID'], DATATYPE_NUMBER, "DB")); 
		$dtlrows = ($rscascade) ? $rscascade->getRows() : array();

		// Call Row Deleting event
		foreach ($dtlrows as $dtlrow) {
			$success = $GLOBALS["attachments"]->Row_Deleting($dtlrow);
			if (!$success)
				break;
		}
		if ($success) {
			foreach ($dtlrows as $dtlrow) {
				$success = $GLOBALS["attachments"]->delete($dtlrow); // Delete
				if (!$success)
					break;
			}
		}

		// Call Row Deleted event
		if ($success) {
			foreach ($dtlrows as $dtlrow)
				$GLOBALS["attachments"]->Row_Deleted($dtlrow);
		}
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->CaseID->DbValue = $row['CaseID'];
		$this->ClientID->DbValue = $row['ClientID'];
		$this->LitigantID->DbValue = $row['LitigantID'];
		$this->CaseTypeID->DbValue = $row['CaseTypeID'];
		$this->CourtID->DbValue = $row['CourtID'];
		$this->CaseNumber->DbValue = $row['CaseNumber'];
		$this->FileNumber->DbValue = $row['FileNumber'];
		$this->EnvelopeNumber->DbValue = $row['EnvelopeNumber'];
		$this->ClientStatusID->DbValue = $row['ClientStatusID'];
		$this->LitigantStatusID->DbValue = $row['LitigantStatusID'];
		$this->CourtTypeID->DbValue = $row['CourtTypeID'];
		$this->CourtGenderID->DbValue = $row['CourtGenderID'];
		$this->JudgeID->DbValue = $row['JudgeID'];
		$this->Notes->DbValue = $row['Notes'];
		$this->FileLocation->DbValue = $row['FileLocation'];
		$this->_Case->DbValue = $row['Case'];
		$this->CaseEn->DbValue = $row['CaseEn'];
		$this->CaseSortID->DbValue = $row['CaseSortID'];
		$this->CaseRegisteredDate->DbValue = $row['CaseRegisteredDate'];
		$this->CaseStatusID->DbValue = $row['CaseStatusID'];
		$this->ParentCaseID->DbValue = $row['ParentCaseID'];
		$this->FileNumber2->DbValue = $row['FileNumber2'];
		$this->_UserID->DbValue = $row['UserID'];
		$this->CreatedBy->DbValue = $row['CreatedBy'];
		$this->CreatedDate->DbValue = $row['CreatedDate'];
		$this->UpdatedBy->DbValue = $row['UpdatedBy'];
		$this->UpdatedDate->DbValue = $row['UpdatedDate'];
		$this->CaseTypeConv->DbValue = $row['CaseTypeConv'];
		$this->CaseConv->DbValue = $row['CaseConv'];
		$this->ClientStatusConv->DbValue = $row['ClientStatusConv'];
		$this->LitigantStatusConv->DbValue = $row['LitigantStatusConv'];
		$this->ClientNameConv->DbValue = $row['ClientNameConv'];
		$this->LitigantNameConv->DbValue = $row['LitigantNameConv'];
		$this->ClientNameConvFiles->DbValue = $row['ClientNameConvFiles'];
		$this->LitigantNameConvFiles->DbValue = $row['LitigantNameConvFiles'];
		$this->CaseTypeConvFiles->DbValue = $row['CaseTypeConvFiles'];
		$this->CourtConvFiles->DbValue = $row['CourtConvFiles'];
		$this->FileNumberConvFiles->DbValue = $row['FileNumberConvFiles'];
		$this->CaseNumberConvFiles->DbValue = $row['CaseNumberConvFiles'];
		$this->NotesConvFiles->DbValue = $row['NotesConvFiles'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`CaseID` = @CaseID@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('CaseID', $row) ? $row['CaseID'] : NULL) : $this->CaseID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@CaseID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "caseslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "casesview.php")
			return $Language->phrase("View");
		elseif ($pageName == "casesedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "casesadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "caseslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("casesview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("casesview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "casesadd.php?" . $this->getUrlParm($parm);
		else
			$url = "casesadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("casesedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("casesedit.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("casesadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("casesadd.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("casesdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "clients" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_ClientID=" . urlencode($this->ClientID->CurrentValue);
		}
		if ($this->getCurrentMasterTable() == "litigants" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_LitigantID=" . urlencode($this->LitigantID->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "CaseID:" . JsonEncode($this->CaseID->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->CaseID->CurrentValue != NULL) {
			$url .= "CaseID=" . urlencode($this->CaseID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("CaseID") !== NULL)
				$arKeys[] = Param("CaseID");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->CaseID->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->CaseID->setDbValue($rs->fields('CaseID'));
		$this->ClientID->setDbValue($rs->fields('ClientID'));
		$this->LitigantID->setDbValue($rs->fields('LitigantID'));
		$this->CaseTypeID->setDbValue($rs->fields('CaseTypeID'));
		$this->CourtID->setDbValue($rs->fields('CourtID'));
		$this->CaseNumber->setDbValue($rs->fields('CaseNumber'));
		$this->FileNumber->setDbValue($rs->fields('FileNumber'));
		$this->EnvelopeNumber->setDbValue($rs->fields('EnvelopeNumber'));
		$this->ClientStatusID->setDbValue($rs->fields('ClientStatusID'));
		$this->LitigantStatusID->setDbValue($rs->fields('LitigantStatusID'));
		$this->CourtTypeID->setDbValue($rs->fields('CourtTypeID'));
		$this->CourtGenderID->setDbValue($rs->fields('CourtGenderID'));
		$this->JudgeID->setDbValue($rs->fields('JudgeID'));
		$this->Notes->setDbValue($rs->fields('Notes'));
		$this->FileLocation->setDbValue($rs->fields('FileLocation'));
		$this->_Case->setDbValue($rs->fields('Case'));
		$this->CaseEn->setDbValue($rs->fields('CaseEn'));
		$this->CaseSortID->setDbValue($rs->fields('CaseSortID'));
		$this->CaseRegisteredDate->setDbValue($rs->fields('CaseRegisteredDate'));
		$this->CaseStatusID->setDbValue($rs->fields('CaseStatusID'));
		$this->ParentCaseID->setDbValue($rs->fields('ParentCaseID'));
		$this->FileNumber2->setDbValue($rs->fields('FileNumber2'));
		$this->_UserID->setDbValue($rs->fields('UserID'));
		$this->CreatedBy->setDbValue($rs->fields('CreatedBy'));
		$this->CreatedDate->setDbValue($rs->fields('CreatedDate'));
		$this->UpdatedBy->setDbValue($rs->fields('UpdatedBy'));
		$this->UpdatedDate->setDbValue($rs->fields('UpdatedDate'));
		$this->CaseTypeConv->setDbValue($rs->fields('CaseTypeConv'));
		$this->CaseConv->setDbValue($rs->fields('CaseConv'));
		$this->ClientStatusConv->setDbValue($rs->fields('ClientStatusConv'));
		$this->LitigantStatusConv->setDbValue($rs->fields('LitigantStatusConv'));
		$this->ClientNameConv->setDbValue($rs->fields('ClientNameConv'));
		$this->LitigantNameConv->setDbValue($rs->fields('LitigantNameConv'));
		$this->ClientNameConvFiles->setDbValue($rs->fields('ClientNameConvFiles'));
		$this->LitigantNameConvFiles->setDbValue($rs->fields('LitigantNameConvFiles'));
		$this->CaseTypeConvFiles->setDbValue($rs->fields('CaseTypeConvFiles'));
		$this->CourtConvFiles->setDbValue($rs->fields('CourtConvFiles'));
		$this->FileNumberConvFiles->setDbValue($rs->fields('FileNumberConvFiles'));
		$this->CaseNumberConvFiles->setDbValue($rs->fields('CaseNumberConvFiles'));
		$this->NotesConvFiles->setDbValue($rs->fields('NotesConvFiles'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// CaseID
		// ClientID

		$this->ClientID->CellCssStyle = "min-width: 150px;";

		// LitigantID
		$this->LitigantID->CellCssStyle = "width: 250px; white-space: nowrap;";

		// CaseTypeID
		$this->CaseTypeID->CellCssStyle = "min-width: 120px;";

		// CourtID
		$this->CourtID->CellCssStyle = "width: 200px; white-space: nowrap;";

		// CaseNumber
		// FileNumber
		// EnvelopeNumber
		// ClientStatusID
		// LitigantStatusID
		// CourtTypeID

		$this->CourtTypeID->CellCssStyle = "white-space: nowrap;";

		// CourtGenderID
		$this->CourtGenderID->CellCssStyle = "white-space: nowrap;";

		// JudgeID
		$this->JudgeID->CellCssStyle = "min-width: 150px;";

		// Notes
		$this->Notes->CellCssStyle = "min-width: 450px;";

		// FileLocation
		// Case

		$this->_Case->CellCssStyle = "min-width: 180px;";

		// CaseEn
		$this->CaseEn->CellCssStyle = "white-space: nowrap;";

		// CaseSortID
		// CaseRegisteredDate
		// CaseStatusID
		// ParentCaseID
		// FileNumber2

		$this->FileNumber2->CellCssStyle = "white-space: nowrap;";

		// UserID
		$this->_UserID->CellCssStyle = "white-space: nowrap;";

		// CreatedBy
		$this->CreatedBy->CellCssStyle = "white-space: nowrap;";

		// CreatedDate
		$this->CreatedDate->CellCssStyle = "white-space: nowrap;";

		// UpdatedBy
		$this->UpdatedBy->CellCssStyle = "white-space: nowrap;";

		// UpdatedDate
		$this->UpdatedDate->CellCssStyle = "white-space: nowrap;";

		// CaseTypeConv
		$this->CaseTypeConv->CellCssStyle = "white-space: nowrap;";

		// CaseConv
		$this->CaseConv->CellCssStyle = "white-space: nowrap;";

		// ClientStatusConv
		$this->ClientStatusConv->CellCssStyle = "white-space: nowrap;";

		// LitigantStatusConv
		$this->LitigantStatusConv->CellCssStyle = "white-space: nowrap;";

		// ClientNameConv
		$this->ClientNameConv->CellCssStyle = "white-space: nowrap;";

		// LitigantNameConv
		$this->LitigantNameConv->CellCssStyle = "white-space: nowrap;";

		// ClientNameConvFiles
		$this->ClientNameConvFiles->CellCssStyle = "white-space: nowrap;";

		// LitigantNameConvFiles
		$this->LitigantNameConvFiles->CellCssStyle = "white-space: nowrap;";

		// CaseTypeConvFiles
		$this->CaseTypeConvFiles->CellCssStyle = "white-space: nowrap;";

		// CourtConvFiles
		$this->CourtConvFiles->CellCssStyle = "white-space: nowrap;";

		// FileNumberConvFiles
		$this->FileNumberConvFiles->CellCssStyle = "white-space: nowrap;";

		// CaseNumberConvFiles
		$this->CaseNumberConvFiles->CellCssStyle = "white-space: nowrap;";

		// NotesConvFiles
		$this->NotesConvFiles->CellCssStyle = "white-space: nowrap;";

		// CaseID
		$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
		$this->CaseID->ViewCustomAttributes = "";

		// ClientID
		if ($this->ClientID->VirtualValue <> "") {
			$this->ClientID->ViewValue = $this->ClientID->VirtualValue;
		} else {
			$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
		$curVal = strval($this->ClientID->CurrentValue);
		if ($curVal <> "") {
			$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
			if ($this->ClientID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
				}
			}
		} else {
			$this->ClientID->ViewValue = NULL;
		}
		}
		$this->ClientID->CssStyle = "font-weight: bold;";
		$this->ClientID->ViewCustomAttributes = "";

		// LitigantID
		if ($this->LitigantID->VirtualValue <> "") {
			$this->LitigantID->ViewValue = $this->LitigantID->VirtualValue;
		} else {
			$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
		$curVal = strval($this->LitigantID->CurrentValue);
		if ($curVal <> "") {
			$this->LitigantID->ViewValue = $this->LitigantID->lookupCacheOption($curVal);
			if ($this->LitigantID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->LitigantID->ViewValue = $this->LitigantID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
				}
			}
		} else {
			$this->LitigantID->ViewValue = NULL;
		}
		}
		$this->LitigantID->CssStyle = "font-weight: bold;";
		$this->LitigantID->ViewCustomAttributes = "";

		// CaseTypeID
		if ($this->CaseTypeID->VirtualValue <> "") {
			$this->CaseTypeID->ViewValue = $this->CaseTypeID->VirtualValue;
		} else {
		$curVal = strval($this->CaseTypeID->CurrentValue);
		if ($curVal <> "") {
			$this->CaseTypeID->ViewValue = $this->CaseTypeID->lookupCacheOption($curVal);
			if ($this->CaseTypeID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CaseTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CaseTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CaseTypeID->ViewValue = $this->CaseTypeID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CaseTypeID->ViewValue = $this->CaseTypeID->CurrentValue;
				}
			}
		} else {
			$this->CaseTypeID->ViewValue = NULL;
		}
		}
		$this->CaseTypeID->CssStyle = "font-style: italic;";
		$this->CaseTypeID->ViewCustomAttributes = "";

		// CourtID
		if ($this->CourtID->VirtualValue <> "") {
			$this->CourtID->ViewValue = $this->CourtID->VirtualValue;
		} else {
			$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
		$curVal = strval($this->CourtID->CurrentValue);
		if ($curVal <> "") {
			$this->CourtID->ViewValue = $this->CourtID->lookupCacheOption($curVal);
			if ($this->CourtID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CourtID->ViewValue = $this->CourtID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
				}
			}
		} else {
			$this->CourtID->ViewValue = NULL;
		}
		}
		$this->CourtID->ViewCustomAttributes = "";

		// CaseNumber
		$this->CaseNumber->ViewValue = $this->CaseNumber->CurrentValue;
		$this->CaseNumber->ViewCustomAttributes = "";

		// FileNumber
		$this->FileNumber->ViewValue = $this->FileNumber->CurrentValue;
		$this->FileNumber->ViewCustomAttributes = "";

		// EnvelopeNumber
		$this->EnvelopeNumber->ViewValue = $this->EnvelopeNumber->CurrentValue;
		$this->EnvelopeNumber->ViewCustomAttributes = "";

		// ClientStatusID
		if ($this->ClientStatusID->VirtualValue <> "") {
			$this->ClientStatusID->ViewValue = $this->ClientStatusID->VirtualValue;
		} else {
		$curVal = strval($this->ClientStatusID->CurrentValue);
		if ($curVal <> "") {
			$this->ClientStatusID->ViewValue = $this->ClientStatusID->lookupCacheOption($curVal);
			if ($this->ClientStatusID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ClientStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->ClientStatusID->ViewValue = $this->ClientStatusID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ClientStatusID->ViewValue = $this->ClientStatusID->CurrentValue;
				}
			}
		} else {
			$this->ClientStatusID->ViewValue = NULL;
		}
		}
		$this->ClientStatusID->CssStyle = "font-style: italic;";
		$this->ClientStatusID->ViewCustomAttributes = "";

		// LitigantStatusID
		if ($this->LitigantStatusID->VirtualValue <> "") {
			$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->VirtualValue;
		} else {
		$curVal = strval($this->LitigantStatusID->CurrentValue);
		if ($curVal <> "") {
			$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->lookupCacheOption($curVal);
			if ($this->LitigantStatusID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->LitigantStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->CurrentValue;
				}
			}
		} else {
			$this->LitigantStatusID->ViewValue = NULL;
		}
		}
		$this->LitigantStatusID->CssStyle = "font-style: italic;";
		$this->LitigantStatusID->ViewCustomAttributes = "";

		// CourtTypeID
		if ($this->CourtTypeID->VirtualValue <> "") {
			$this->CourtTypeID->ViewValue = $this->CourtTypeID->VirtualValue;
		} else {
		$curVal = strval($this->CourtTypeID->CurrentValue);
		if ($curVal <> "") {
			$this->CourtTypeID->ViewValue = $this->CourtTypeID->lookupCacheOption($curVal);
			if ($this->CourtTypeID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CourtTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CourtTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CourtTypeID->ViewValue = $this->CourtTypeID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CourtTypeID->ViewValue = $this->CourtTypeID->CurrentValue;
				}
			}
		} else {
			$this->CourtTypeID->ViewValue = NULL;
		}
		}
		$this->CourtTypeID->CssStyle = "font-style: italic;";
		$this->CourtTypeID->ViewCustomAttributes = "";

		// CourtGenderID
		if ($this->CourtGenderID->VirtualValue <> "") {
			$this->CourtGenderID->ViewValue = $this->CourtGenderID->VirtualValue;
		} else {
		$curVal = strval($this->CourtGenderID->CurrentValue);
		if ($curVal <> "") {
			$this->CourtGenderID->ViewValue = $this->CourtGenderID->lookupCacheOption($curVal);
			if ($this->CourtGenderID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CourtGenderID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CourtGenderID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CourtGenderID->ViewValue = $this->CourtGenderID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CourtGenderID->ViewValue = $this->CourtGenderID->CurrentValue;
				}
			}
		} else {
			$this->CourtGenderID->ViewValue = NULL;
		}
		}
		$this->CourtGenderID->CssStyle = "font-style: italic;";
		$this->CourtGenderID->ViewCustomAttributes = "";

		// JudgeID
		if ($this->JudgeID->VirtualValue <> "") {
			$this->JudgeID->ViewValue = $this->JudgeID->VirtualValue;
		} else {
		$curVal = strval($this->JudgeID->CurrentValue);
		if ($curVal <> "") {
			$this->JudgeID->ViewValue = $this->JudgeID->lookupCacheOption($curVal);
			if ($this->JudgeID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`JudgeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->JudgeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->JudgeID->ViewValue = $this->JudgeID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->JudgeID->ViewValue = $this->JudgeID->CurrentValue;
				}
			}
		} else {
			$this->JudgeID->ViewValue = NULL;
		}
		}
		$this->JudgeID->ViewCustomAttributes = "";

		// Notes
		$this->Notes->ViewValue = $this->Notes->CurrentValue;
		$this->Notes->ViewCustomAttributes = "";

		// FileLocation
		$this->FileLocation->ViewValue = $this->FileLocation->CurrentValue;
		$this->FileLocation->ViewCustomAttributes = "";

		// Case
		$this->_Case->ViewValue = $this->_Case->CurrentValue;
		$this->_Case->ViewCustomAttributes = "";

		// CaseEn
		$this->CaseEn->ViewValue = $this->CaseEn->CurrentValue;
		$this->CaseEn->ViewCustomAttributes = "";

		// CaseSortID
		if ($this->CaseSortID->VirtualValue <> "") {
			$this->CaseSortID->ViewValue = $this->CaseSortID->VirtualValue;
		} else {
		$curVal = strval($this->CaseSortID->CurrentValue);
		if ($curVal <> "") {
			$this->CaseSortID->ViewValue = $this->CaseSortID->lookupCacheOption($curVal);
			if ($this->CaseSortID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CaseSortID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CaseSortID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CaseSortID->ViewValue = $this->CaseSortID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CaseSortID->ViewValue = $this->CaseSortID->CurrentValue;
				}
			}
		} else {
			$this->CaseSortID->ViewValue = NULL;
		}
		}
		$this->CaseSortID->ViewCustomAttributes = "";

		// CaseRegisteredDate
		$this->CaseRegisteredDate->ViewValue = $this->CaseRegisteredDate->CurrentValue;
		$this->CaseRegisteredDate->ViewValue = FormatDateTime($this->CaseRegisteredDate->ViewValue, 7);
		$this->CaseRegisteredDate->ViewCustomAttributes = "";

		// CaseStatusID
		if ($this->CaseStatusID->VirtualValue <> "") {
			$this->CaseStatusID->ViewValue = $this->CaseStatusID->VirtualValue;
		} else {
		$curVal = strval($this->CaseStatusID->CurrentValue);
		if ($curVal <> "") {
			$this->CaseStatusID->ViewValue = $this->CaseStatusID->lookupCacheOption($curVal);
			if ($this->CaseStatusID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CaseStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CaseStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CaseStatusID->ViewValue = $this->CaseStatusID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CaseStatusID->ViewValue = $this->CaseStatusID->CurrentValue;
				}
			}
		} else {
			$this->CaseStatusID->ViewValue = NULL;
		}
		}
		$this->CaseStatusID->CssStyle = "font-style: italic;";
		$this->CaseStatusID->ViewCustomAttributes = "";

		// ParentCaseID
		$this->ParentCaseID->ViewValue = $this->ParentCaseID->CurrentValue;
		$this->ParentCaseID->ViewValue = FormatNumber($this->ParentCaseID->ViewValue, 0, -2, -2, -2);
		$this->ParentCaseID->ViewCustomAttributes = "";

		// FileNumber2
		$this->FileNumber2->ViewValue = $this->FileNumber2->CurrentValue;
		$this->FileNumber2->ViewValue = FormatNumber($this->FileNumber2->ViewValue, 0, -2, -2, -2);
		$this->FileNumber2->ViewCustomAttributes = "";

		// UserID
		$this->_UserID->ViewValue = $this->_UserID->CurrentValue;
		$this->_UserID->ViewValue = FormatNumber($this->_UserID->ViewValue, 0, -2, -2, -2);
		$this->_UserID->ViewCustomAttributes = "";

		// CreatedBy
		$this->CreatedBy->ViewValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->ViewCustomAttributes = "";

		// CreatedDate
		$this->CreatedDate->ViewValue = $this->CreatedDate->CurrentValue;
		$this->CreatedDate->ViewValue = FormatDateTime($this->CreatedDate->ViewValue, 0);
		$this->CreatedDate->ViewCustomAttributes = "";

		// UpdatedBy
		$this->UpdatedBy->ViewValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->ViewCustomAttributes = "";

		// UpdatedDate
		$this->UpdatedDate->ViewValue = $this->UpdatedDate->CurrentValue;
		$this->UpdatedDate->ViewValue = FormatDateTime($this->UpdatedDate->ViewValue, 0);
		$this->UpdatedDate->ViewCustomAttributes = "";

		// CaseTypeConv
		$this->CaseTypeConv->ViewValue = $this->CaseTypeConv->CurrentValue;
		$this->CaseTypeConv->ViewCustomAttributes = "";

		// CaseConv
		$this->CaseConv->ViewValue = $this->CaseConv->CurrentValue;
		$this->CaseConv->ViewCustomAttributes = "";

		// ClientStatusConv
		$this->ClientStatusConv->ViewValue = $this->ClientStatusConv->CurrentValue;
		$this->ClientStatusConv->ViewCustomAttributes = "";

		// LitigantStatusConv
		$this->LitigantStatusConv->ViewValue = $this->LitigantStatusConv->CurrentValue;
		$this->LitigantStatusConv->ViewCustomAttributes = "";

		// ClientNameConv
		$this->ClientNameConv->ViewValue = $this->ClientNameConv->CurrentValue;
		$this->ClientNameConv->ViewCustomAttributes = "";

		// LitigantNameConv
		$this->LitigantNameConv->ViewValue = $this->LitigantNameConv->CurrentValue;
		$this->LitigantNameConv->ViewCustomAttributes = "";

		// ClientNameConvFiles
		$this->ClientNameConvFiles->ViewValue = $this->ClientNameConvFiles->CurrentValue;
		$this->ClientNameConvFiles->ViewCustomAttributes = "";

		// LitigantNameConvFiles
		$this->LitigantNameConvFiles->ViewValue = $this->LitigantNameConvFiles->CurrentValue;
		$this->LitigantNameConvFiles->ViewCustomAttributes = "";

		// CaseTypeConvFiles
		$this->CaseTypeConvFiles->ViewValue = $this->CaseTypeConvFiles->CurrentValue;
		$this->CaseTypeConvFiles->ViewCustomAttributes = "";

		// CourtConvFiles
		$this->CourtConvFiles->ViewValue = $this->CourtConvFiles->CurrentValue;
		$this->CourtConvFiles->ViewCustomAttributes = "";

		// FileNumberConvFiles
		$this->FileNumberConvFiles->ViewValue = $this->FileNumberConvFiles->CurrentValue;
		$this->FileNumberConvFiles->ViewCustomAttributes = "";

		// CaseNumberConvFiles
		$this->CaseNumberConvFiles->ViewValue = $this->CaseNumberConvFiles->CurrentValue;
		$this->CaseNumberConvFiles->ViewCustomAttributes = "";

		// NotesConvFiles
		$this->NotesConvFiles->ViewValue = $this->NotesConvFiles->CurrentValue;
		$this->NotesConvFiles->ViewCustomAttributes = "";

		// CaseID
		$this->CaseID->LinkCustomAttributes = "";
		$this->CaseID->HrefValue = "";
		$this->CaseID->TooltipValue = "";

		// ClientID
		$this->ClientID->LinkCustomAttributes = "";
		if (!EmptyValue($this->ClientID->CurrentValue)) {
			$this->ClientID->HrefValue = "/home/clientsview.php?showdetail=clientaddress,clientcontact,cases&ClientID=" . $this->ClientID->CurrentValue; // Add prefix/suffix
			$this->ClientID->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->ClientID->HrefValue = FullUrl($this->ClientID->HrefValue, "href");
		} else {
			$this->ClientID->HrefValue = "";
		}
		$this->ClientID->TooltipValue = "";

		// LitigantID
		$this->LitigantID->LinkCustomAttributes = "";
		if (!EmptyValue($this->LitigantID->CurrentValue)) {
			$this->LitigantID->HrefValue = "/home/litigantsview.php?showdetail=litigantaddress,litigantcontact,cases&LitigantID=" . $this->LitigantID->CurrentValue; // Add prefix/suffix
			$this->LitigantID->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->LitigantID->HrefValue = FullUrl($this->LitigantID->HrefValue, "href");
		} else {
			$this->LitigantID->HrefValue = "";
		}
		$this->LitigantID->TooltipValue = "";

		// CaseTypeID
		$this->CaseTypeID->LinkCustomAttributes = "";
		$this->CaseTypeID->HrefValue = "";
		$this->CaseTypeID->TooltipValue = "";

		// CourtID
		$this->CourtID->LinkCustomAttributes = "";
		if (!EmptyValue($this->CourtID->CurrentValue)) {
			$this->CourtID->HrefValue = "/home/courtsview.php?showdetail=courtaddress,courtcontact&CourtID=" . $this->CourtID->CurrentValue; // Add prefix/suffix
			$this->CourtID->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->CourtID->HrefValue = FullUrl($this->CourtID->HrefValue, "href");
		} else {
			$this->CourtID->HrefValue = "";
		}
		$this->CourtID->TooltipValue = "";

		// CaseNumber
		$this->CaseNumber->LinkCustomAttributes = "";
		$this->CaseNumber->HrefValue = "";
		$this->CaseNumber->TooltipValue = "";

		// FileNumber
		$this->FileNumber->LinkCustomAttributes = "";
		$this->FileNumber->HrefValue = "";
		$this->FileNumber->TooltipValue = "";

		// EnvelopeNumber
		$this->EnvelopeNumber->LinkCustomAttributes = "";
		$this->EnvelopeNumber->HrefValue = "";
		$this->EnvelopeNumber->TooltipValue = "";

		// ClientStatusID
		$this->ClientStatusID->LinkCustomAttributes = "";
		$this->ClientStatusID->HrefValue = "";
		$this->ClientStatusID->TooltipValue = "";

		// LitigantStatusID
		$this->LitigantStatusID->LinkCustomAttributes = "";
		$this->LitigantStatusID->HrefValue = "";
		$this->LitigantStatusID->TooltipValue = "";

		// CourtTypeID
		$this->CourtTypeID->LinkCustomAttributes = "";
		$this->CourtTypeID->HrefValue = "";
		$this->CourtTypeID->TooltipValue = "";

		// CourtGenderID
		$this->CourtGenderID->LinkCustomAttributes = "";
		$this->CourtGenderID->HrefValue = "";
		$this->CourtGenderID->TooltipValue = "";

		// JudgeID
		$this->JudgeID->LinkCustomAttributes = "";
		if (!EmptyValue($this->JudgeID->CurrentValue)) {
			$this->JudgeID->HrefValue = "/home/judgesview.php?showdetail=judgecontact,judgeaddress&JudgeID=" . $this->JudgeID->CurrentValue; // Add prefix/suffix
			$this->JudgeID->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->JudgeID->HrefValue = FullUrl($this->JudgeID->HrefValue, "href");
		} else {
			$this->JudgeID->HrefValue = "";
		}
		$this->JudgeID->TooltipValue = "";

		// Notes
		$this->Notes->LinkCustomAttributes = "";
		$this->Notes->HrefValue = "";
		$this->Notes->TooltipValue = "";

		// FileLocation
		$this->FileLocation->LinkCustomAttributes = "";
		$this->FileLocation->HrefValue = "";
		$this->FileLocation->TooltipValue = "";

		// Case
		$this->_Case->LinkCustomAttributes = "";
		$this->_Case->HrefValue = "";
		$this->_Case->TooltipValue = "";

		// CaseEn
		$this->CaseEn->LinkCustomAttributes = "";
		$this->CaseEn->HrefValue = "";
		$this->CaseEn->TooltipValue = "";

		// CaseSortID
		$this->CaseSortID->LinkCustomAttributes = "";
		$this->CaseSortID->HrefValue = "";
		$this->CaseSortID->TooltipValue = "";

		// CaseRegisteredDate
		$this->CaseRegisteredDate->LinkCustomAttributes = "";
		$this->CaseRegisteredDate->HrefValue = "";
		$this->CaseRegisteredDate->TooltipValue = "";

		// CaseStatusID
		$this->CaseStatusID->LinkCustomAttributes = "";
		$this->CaseStatusID->HrefValue = "";
		$this->CaseStatusID->TooltipValue = "";

		// ParentCaseID
		$this->ParentCaseID->LinkCustomAttributes = "";
		$this->ParentCaseID->HrefValue = "";
		$this->ParentCaseID->TooltipValue = "";

		// FileNumber2
		$this->FileNumber2->LinkCustomAttributes = "";
		$this->FileNumber2->HrefValue = "";
		$this->FileNumber2->TooltipValue = "";

		// UserID
		$this->_UserID->LinkCustomAttributes = "";
		$this->_UserID->HrefValue = "";
		$this->_UserID->TooltipValue = "";

		// CreatedBy
		$this->CreatedBy->LinkCustomAttributes = "";
		$this->CreatedBy->HrefValue = "";
		$this->CreatedBy->TooltipValue = "";

		// CreatedDate
		$this->CreatedDate->LinkCustomAttributes = "";
		$this->CreatedDate->HrefValue = "";
		$this->CreatedDate->TooltipValue = "";

		// UpdatedBy
		$this->UpdatedBy->LinkCustomAttributes = "";
		$this->UpdatedBy->HrefValue = "";
		$this->UpdatedBy->TooltipValue = "";

		// UpdatedDate
		$this->UpdatedDate->LinkCustomAttributes = "";
		$this->UpdatedDate->HrefValue = "";
		$this->UpdatedDate->TooltipValue = "";

		// CaseTypeConv
		$this->CaseTypeConv->LinkCustomAttributes = "";
		$this->CaseTypeConv->HrefValue = "";
		$this->CaseTypeConv->TooltipValue = "";

		// CaseConv
		$this->CaseConv->LinkCustomAttributes = "";
		$this->CaseConv->HrefValue = "";
		$this->CaseConv->TooltipValue = "";

		// ClientStatusConv
		$this->ClientStatusConv->LinkCustomAttributes = "";
		$this->ClientStatusConv->HrefValue = "";
		$this->ClientStatusConv->TooltipValue = "";

		// LitigantStatusConv
		$this->LitigantStatusConv->LinkCustomAttributes = "";
		$this->LitigantStatusConv->HrefValue = "";
		$this->LitigantStatusConv->TooltipValue = "";

		// ClientNameConv
		$this->ClientNameConv->LinkCustomAttributes = "";
		$this->ClientNameConv->HrefValue = "";
		$this->ClientNameConv->TooltipValue = "";

		// LitigantNameConv
		$this->LitigantNameConv->LinkCustomAttributes = "";
		$this->LitigantNameConv->HrefValue = "";
		$this->LitigantNameConv->TooltipValue = "";

		// ClientNameConvFiles
		$this->ClientNameConvFiles->LinkCustomAttributes = "";
		$this->ClientNameConvFiles->HrefValue = "";
		$this->ClientNameConvFiles->TooltipValue = "";

		// LitigantNameConvFiles
		$this->LitigantNameConvFiles->LinkCustomAttributes = "";
		$this->LitigantNameConvFiles->HrefValue = "";
		$this->LitigantNameConvFiles->TooltipValue = "";

		// CaseTypeConvFiles
		$this->CaseTypeConvFiles->LinkCustomAttributes = "";
		$this->CaseTypeConvFiles->HrefValue = "";
		$this->CaseTypeConvFiles->TooltipValue = "";

		// CourtConvFiles
		$this->CourtConvFiles->LinkCustomAttributes = "";
		$this->CourtConvFiles->HrefValue = "";
		$this->CourtConvFiles->TooltipValue = "";

		// FileNumberConvFiles
		$this->FileNumberConvFiles->LinkCustomAttributes = "";
		$this->FileNumberConvFiles->HrefValue = "";
		$this->FileNumberConvFiles->TooltipValue = "";

		// CaseNumberConvFiles
		$this->CaseNumberConvFiles->LinkCustomAttributes = "";
		$this->CaseNumberConvFiles->HrefValue = "";
		$this->CaseNumberConvFiles->TooltipValue = "";

		// NotesConvFiles
		$this->NotesConvFiles->LinkCustomAttributes = "";
		$this->NotesConvFiles->HrefValue = "";
		$this->NotesConvFiles->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// CaseID
		$this->CaseID->EditAttrs["class"] = "form-control";
		$this->CaseID->EditCustomAttributes = "";

		// ClientID
		$this->ClientID->EditAttrs["class"] = "form-control";
		$this->ClientID->EditCustomAttributes = "";
		if ($this->ClientID->getSessionValue() <> "") {
			$this->ClientID->CurrentValue = $this->ClientID->getSessionValue();
		if ($this->ClientID->VirtualValue <> "") {
			$this->ClientID->ViewValue = $this->ClientID->VirtualValue;
		} else {
			$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
		$curVal = strval($this->ClientID->CurrentValue);
		if ($curVal <> "") {
			$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
			if ($this->ClientID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
				}
			}
		} else {
			$this->ClientID->ViewValue = NULL;
		}
		}
		$this->ClientID->CssStyle = "font-weight: bold;";
		$this->ClientID->ViewCustomAttributes = "";
		} else {
		$this->ClientID->EditValue = $this->ClientID->CurrentValue;
		$this->ClientID->PlaceHolder = RemoveHtml($this->ClientID->caption());
		}

		// LitigantID
		$this->LitigantID->EditAttrs["class"] = "form-control";
		$this->LitigantID->EditCustomAttributes = "";
		if ($this->LitigantID->getSessionValue() <> "") {
			$this->LitigantID->CurrentValue = $this->LitigantID->getSessionValue();
		if ($this->LitigantID->VirtualValue <> "") {
			$this->LitigantID->ViewValue = $this->LitigantID->VirtualValue;
		} else {
			$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
		$curVal = strval($this->LitigantID->CurrentValue);
		if ($curVal <> "") {
			$this->LitigantID->ViewValue = $this->LitigantID->lookupCacheOption($curVal);
			if ($this->LitigantID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->LitigantID->ViewValue = $this->LitigantID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
				}
			}
		} else {
			$this->LitigantID->ViewValue = NULL;
		}
		}
		$this->LitigantID->CssStyle = "font-weight: bold;";
		$this->LitigantID->ViewCustomAttributes = "";
		} else {
		$this->LitigantID->EditValue = $this->LitigantID->CurrentValue;
		$this->LitigantID->PlaceHolder = RemoveHtml($this->LitigantID->caption());
		}

		// CaseTypeID
		$this->CaseTypeID->EditAttrs["class"] = "form-control";
		$this->CaseTypeID->EditCustomAttributes = "";

		// CourtID
		$this->CourtID->EditAttrs["class"] = "form-control";
		$this->CourtID->EditCustomAttributes = "";
		$this->CourtID->EditValue = $this->CourtID->CurrentValue;
		$this->CourtID->PlaceHolder = RemoveHtml($this->CourtID->caption());

		// CaseNumber
		$this->CaseNumber->EditAttrs["class"] = "form-control";
		$this->CaseNumber->EditCustomAttributes = "";
		$this->CaseNumber->EditValue = $this->CaseNumber->CurrentValue;
		$this->CaseNumber->PlaceHolder = RemoveHtml($this->CaseNumber->caption());

		// FileNumber
		$this->FileNumber->EditAttrs["class"] = "form-control";
		$this->FileNumber->EditCustomAttributes = "";
		$this->FileNumber->EditValue = $this->FileNumber->CurrentValue;
		$this->FileNumber->PlaceHolder = RemoveHtml($this->FileNumber->caption());

		// EnvelopeNumber
		$this->EnvelopeNumber->EditAttrs["class"] = "form-control";
		$this->EnvelopeNumber->EditCustomAttributes = "";
		$this->EnvelopeNumber->EditValue = $this->EnvelopeNumber->CurrentValue;
		$this->EnvelopeNumber->PlaceHolder = RemoveHtml($this->EnvelopeNumber->caption());

		// ClientStatusID
		$this->ClientStatusID->EditAttrs["class"] = "form-control";
		$this->ClientStatusID->EditCustomAttributes = "";

		// LitigantStatusID
		$this->LitigantStatusID->EditAttrs["class"] = "form-control";
		$this->LitigantStatusID->EditCustomAttributes = "";

		// CourtTypeID
		$this->CourtTypeID->EditAttrs["class"] = "form-control";
		$this->CourtTypeID->EditCustomAttributes = "";

		// CourtGenderID
		$this->CourtGenderID->EditAttrs["class"] = "form-control";
		$this->CourtGenderID->EditCustomAttributes = "";

		// JudgeID
		$this->JudgeID->EditAttrs["class"] = "form-control";
		$this->JudgeID->EditCustomAttributes = "";

		// Notes
		$this->Notes->EditAttrs["class"] = "form-control";
		$this->Notes->EditCustomAttributes = "";
		$this->Notes->EditValue = $this->Notes->CurrentValue;
		$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

		// FileLocation
		$this->FileLocation->EditAttrs["class"] = "form-control";
		$this->FileLocation->EditCustomAttributes = "";
		$this->FileLocation->EditValue = $this->FileLocation->CurrentValue;
		$this->FileLocation->PlaceHolder = RemoveHtml($this->FileLocation->caption());

		// Case
		$this->_Case->EditAttrs["class"] = "form-control";
		$this->_Case->EditCustomAttributes = "";
		$this->_Case->EditValue = $this->_Case->CurrentValue;
		$this->_Case->PlaceHolder = RemoveHtml($this->_Case->caption());

		// CaseEn
		$this->CaseEn->EditAttrs["class"] = "form-control";
		$this->CaseEn->EditCustomAttributes = "";
		$this->CaseEn->EditValue = $this->CaseEn->CurrentValue;
		$this->CaseEn->PlaceHolder = RemoveHtml($this->CaseEn->caption());

		// CaseSortID
		$this->CaseSortID->EditAttrs["class"] = "form-control";
		$this->CaseSortID->EditCustomAttributes = "";

		// CaseRegisteredDate
		$this->CaseRegisteredDate->EditAttrs["class"] = "form-control";
		$this->CaseRegisteredDate->EditCustomAttributes = "";
		$this->CaseRegisteredDate->EditValue = FormatDateTime($this->CaseRegisteredDate->CurrentValue, 7);
		$this->CaseRegisteredDate->PlaceHolder = RemoveHtml($this->CaseRegisteredDate->caption());

		// CaseStatusID
		$this->CaseStatusID->EditAttrs["class"] = "form-control";
		$this->CaseStatusID->EditCustomAttributes = "";

		// ParentCaseID
		$this->ParentCaseID->EditAttrs["class"] = "form-control";
		$this->ParentCaseID->EditCustomAttributes = "";
		$this->ParentCaseID->EditValue = $this->ParentCaseID->CurrentValue;
		$this->ParentCaseID->PlaceHolder = RemoveHtml($this->ParentCaseID->caption());

		// FileNumber2
		$this->FileNumber2->EditAttrs["class"] = "form-control";
		$this->FileNumber2->EditCustomAttributes = "";
		$this->FileNumber2->EditValue = $this->FileNumber2->CurrentValue;
		$this->FileNumber2->PlaceHolder = RemoveHtml($this->FileNumber2->caption());

		// UserID
		$this->_UserID->EditAttrs["class"] = "form-control";
		$this->_UserID->EditCustomAttributes = "";
		$this->_UserID->EditValue = $this->_UserID->CurrentValue;
		$this->_UserID->PlaceHolder = RemoveHtml($this->_UserID->caption());

		// CreatedBy
		$this->CreatedBy->EditAttrs["class"] = "form-control";
		$this->CreatedBy->EditCustomAttributes = "";

		// CreatedDate
		$this->CreatedDate->EditAttrs["class"] = "form-control";
		$this->CreatedDate->EditCustomAttributes = "";
		$this->CreatedDate->CurrentValue = FormatDateTime($this->CreatedDate->CurrentValue, 8);

		// UpdatedBy
		$this->UpdatedBy->EditAttrs["class"] = "form-control";
		$this->UpdatedBy->EditCustomAttributes = "";

		// UpdatedDate
		$this->UpdatedDate->EditAttrs["class"] = "form-control";
		$this->UpdatedDate->EditCustomAttributes = "";
		$this->UpdatedDate->CurrentValue = FormatDateTime($this->UpdatedDate->CurrentValue, 8);

		// CaseTypeConv
		$this->CaseTypeConv->EditAttrs["class"] = "form-control";
		$this->CaseTypeConv->EditCustomAttributes = "";
		$this->CaseTypeConv->EditValue = $this->CaseTypeConv->CurrentValue;
		$this->CaseTypeConv->PlaceHolder = RemoveHtml($this->CaseTypeConv->caption());

		// CaseConv
		$this->CaseConv->EditAttrs["class"] = "form-control";
		$this->CaseConv->EditCustomAttributes = "";
		$this->CaseConv->EditValue = $this->CaseConv->CurrentValue;
		$this->CaseConv->PlaceHolder = RemoveHtml($this->CaseConv->caption());

		// ClientStatusConv
		$this->ClientStatusConv->EditAttrs["class"] = "form-control";
		$this->ClientStatusConv->EditCustomAttributes = "";
		$this->ClientStatusConv->EditValue = $this->ClientStatusConv->CurrentValue;
		$this->ClientStatusConv->PlaceHolder = RemoveHtml($this->ClientStatusConv->caption());

		// LitigantStatusConv
		$this->LitigantStatusConv->EditAttrs["class"] = "form-control";
		$this->LitigantStatusConv->EditCustomAttributes = "";
		$this->LitigantStatusConv->EditValue = $this->LitigantStatusConv->CurrentValue;
		$this->LitigantStatusConv->PlaceHolder = RemoveHtml($this->LitigantStatusConv->caption());

		// ClientNameConv
		$this->ClientNameConv->EditAttrs["class"] = "form-control";
		$this->ClientNameConv->EditCustomAttributes = "";
		$this->ClientNameConv->EditValue = $this->ClientNameConv->CurrentValue;
		$this->ClientNameConv->PlaceHolder = RemoveHtml($this->ClientNameConv->caption());

		// LitigantNameConv
		$this->LitigantNameConv->EditAttrs["class"] = "form-control";
		$this->LitigantNameConv->EditCustomAttributes = "";
		$this->LitigantNameConv->EditValue = $this->LitigantNameConv->CurrentValue;
		$this->LitigantNameConv->PlaceHolder = RemoveHtml($this->LitigantNameConv->caption());

		// ClientNameConvFiles
		$this->ClientNameConvFiles->EditAttrs["class"] = "form-control";
		$this->ClientNameConvFiles->EditCustomAttributes = "";
		$this->ClientNameConvFiles->EditValue = $this->ClientNameConvFiles->CurrentValue;
		$this->ClientNameConvFiles->PlaceHolder = RemoveHtml($this->ClientNameConvFiles->caption());

		// LitigantNameConvFiles
		$this->LitigantNameConvFiles->EditAttrs["class"] = "form-control";
		$this->LitigantNameConvFiles->EditCustomAttributes = "";
		$this->LitigantNameConvFiles->EditValue = $this->LitigantNameConvFiles->CurrentValue;
		$this->LitigantNameConvFiles->PlaceHolder = RemoveHtml($this->LitigantNameConvFiles->caption());

		// CaseTypeConvFiles
		$this->CaseTypeConvFiles->EditAttrs["class"] = "form-control";
		$this->CaseTypeConvFiles->EditCustomAttributes = "";
		$this->CaseTypeConvFiles->EditValue = $this->CaseTypeConvFiles->CurrentValue;
		$this->CaseTypeConvFiles->PlaceHolder = RemoveHtml($this->CaseTypeConvFiles->caption());

		// CourtConvFiles
		$this->CourtConvFiles->EditAttrs["class"] = "form-control";
		$this->CourtConvFiles->EditCustomAttributes = "";
		$this->CourtConvFiles->EditValue = $this->CourtConvFiles->CurrentValue;
		$this->CourtConvFiles->PlaceHolder = RemoveHtml($this->CourtConvFiles->caption());

		// FileNumberConvFiles
		$this->FileNumberConvFiles->EditAttrs["class"] = "form-control";
		$this->FileNumberConvFiles->EditCustomAttributes = "";
		$this->FileNumberConvFiles->EditValue = $this->FileNumberConvFiles->CurrentValue;
		$this->FileNumberConvFiles->PlaceHolder = RemoveHtml($this->FileNumberConvFiles->caption());

		// CaseNumberConvFiles
		$this->CaseNumberConvFiles->EditAttrs["class"] = "form-control";
		$this->CaseNumberConvFiles->EditCustomAttributes = "";
		$this->CaseNumberConvFiles->EditValue = $this->CaseNumberConvFiles->CurrentValue;
		$this->CaseNumberConvFiles->PlaceHolder = RemoveHtml($this->CaseNumberConvFiles->caption());

		// NotesConvFiles
		$this->NotesConvFiles->EditAttrs["class"] = "form-control";
		$this->NotesConvFiles->EditCustomAttributes = "";
		$this->NotesConvFiles->EditValue = $this->NotesConvFiles->CurrentValue;
		$this->NotesConvFiles->PlaceHolder = RemoveHtml($this->NotesConvFiles->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->CaseID);
					$doc->exportCaption($this->ClientID);
					$doc->exportCaption($this->LitigantID);
					$doc->exportCaption($this->CaseTypeID);
					$doc->exportCaption($this->CourtID);
					$doc->exportCaption($this->CaseNumber);
					$doc->exportCaption($this->FileNumber);
					$doc->exportCaption($this->ClientStatusID);
					$doc->exportCaption($this->LitigantStatusID);
					$doc->exportCaption($this->JudgeID);
					$doc->exportCaption($this->Notes);
					$doc->exportCaption($this->FileLocation);
					$doc->exportCaption($this->_Case);
					$doc->exportCaption($this->CaseSortID);
					$doc->exportCaption($this->CaseRegisteredDate);
					$doc->exportCaption($this->CaseStatusID);
					$doc->exportCaption($this->ParentCaseID);
					$doc->exportCaption($this->ClientNameConvFiles);
					$doc->exportCaption($this->LitigantNameConvFiles);
					$doc->exportCaption($this->CaseTypeConvFiles);
				} else {
					$doc->exportCaption($this->CaseID);
					$doc->exportCaption($this->ClientID);
					$doc->exportCaption($this->LitigantID);
					$doc->exportCaption($this->CaseTypeID);
					$doc->exportCaption($this->CourtID);
					$doc->exportCaption($this->CaseNumber);
					$doc->exportCaption($this->FileNumber);
					$doc->exportCaption($this->ClientStatusID);
					$doc->exportCaption($this->LitigantStatusID);
					$doc->exportCaption($this->JudgeID);
					$doc->exportCaption($this->Notes);
					$doc->exportCaption($this->FileLocation);
					$doc->exportCaption($this->_Case);
					$doc->exportCaption($this->CaseSortID);
					$doc->exportCaption($this->CaseRegisteredDate);
					$doc->exportCaption($this->CaseStatusID);
					$doc->exportCaption($this->ParentCaseID);
					$doc->exportCaption($this->ClientNameConvFiles);
					$doc->exportCaption($this->LitigantNameConvFiles);
					$doc->exportCaption($this->CaseTypeConvFiles);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->CaseID);
						$doc->exportField($this->ClientID);
						$doc->exportField($this->LitigantID);
						$doc->exportField($this->CaseTypeID);
						$doc->exportField($this->CourtID);
						$doc->exportField($this->CaseNumber);
						$doc->exportField($this->FileNumber);
						$doc->exportField($this->ClientStatusID);
						$doc->exportField($this->LitigantStatusID);
						$doc->exportField($this->JudgeID);
						$doc->exportField($this->Notes);
						$doc->exportField($this->FileLocation);
						$doc->exportField($this->_Case);
						$doc->exportField($this->CaseSortID);
						$doc->exportField($this->CaseRegisteredDate);
						$doc->exportField($this->CaseStatusID);
						$doc->exportField($this->ParentCaseID);
						$doc->exportField($this->ClientNameConvFiles);
						$doc->exportField($this->LitigantNameConvFiles);
						$doc->exportField($this->CaseTypeConvFiles);
					} else {
						$doc->exportField($this->CaseID);
						$doc->exportField($this->ClientID);
						$doc->exportField($this->LitigantID);
						$doc->exportField($this->CaseTypeID);
						$doc->exportField($this->CourtID);
						$doc->exportField($this->CaseNumber);
						$doc->exportField($this->FileNumber);
						$doc->exportField($this->ClientStatusID);
						$doc->exportField($this->LitigantStatusID);
						$doc->exportField($this->JudgeID);
						$doc->exportField($this->Notes);
						$doc->exportField($this->FileLocation);
						$doc->exportField($this->_Case);
						$doc->exportField($this->CaseSortID);
						$doc->exportField($this->CaseRegisteredDate);
						$doc->exportField($this->CaseStatusID);
						$doc->exportField($this->ParentCaseID);
						$doc->exportField($this->ClientNameConvFiles);
						$doc->exportField($this->LitigantNameConvFiles);
						$doc->exportField($this->CaseTypeConvFiles);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		if (!$validRequest)
			return FALSE;

		// Load lookup parameters
		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'cases';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'cases';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['CaseID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'cases';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['CaseID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'cases';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['CaseID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	//echo CurrentUserName();

	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		if ($rsnew["LitigantID"] === null)
			$rsnew["LitigantID"] = "1938";
		if ($rsnew["LitigantID"] == null)
			$rsnew["LitigantID"] = "1938";
		if ($rsnew["LitigantID"] == "")
			$rsnew["LitigantID"] = "1938";

		//if ($rsnew["CaseEn"] === null) 
			$rsnew["CaseEn"] = $rsnew["Case"];

			//$rsnew["CreatedBy"] = CurrentUserName();
		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"

		/*
		if ($rsnew["LitigantID"] === null)
			$rsnew["LitigantID"] = "1938";
		if ($rsnew["LitigantID"] == null)
			$rsnew["LitigantID"] = "1938";
		if ($rsnew["LitigantID"] == "")
			$rsnew["LitigantID"] = "1938";
		*/
	//echo CurrentUserName();

	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		if ($rsnew["LitigantID"] === null)
			$rsnew["LitigantID"] = "1938";
		if ($rsnew["LitigantID"] == null)
			$rsnew["LitigantID"] = "1938";
		if ($rsnew["LitigantID"] == "")
			$rsnew["LitigantID"] = "1938";

		//if ($rsnew["CaseEn"] === null) 
			$rsnew["CaseEn"] = $rsnew["Case"];

			//$rsnew["UpdatedBy"] = CurrentUserName();
		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
