<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$chambers_addopt = new chambers_addopt();

// Run the page
$chambers_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$chambers_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fchambersaddopt = currentForm = new ew.Form("fchambersaddopt", "addopt");

// Validate form
fchambersaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($chambers_addopt->Chamber->Required) { ?>
			elm = this.getElements("x" + infix + "_Chamber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $chambers->Chamber->caption(), $chambers->Chamber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($chambers_addopt->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $chambers->Notes->caption(), $chambers->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fchambersaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fchambersaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $chambers_addopt->showPageHeader(); ?>
<?php
$chambers_addopt->showMessage();
?>
<form name="fchambersaddopt" id="fchambersaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($chambers_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $chambers_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $chambers_addopt->TableVar ?>">
<?php if ($chambers->Chamber->Visible) { // Chamber ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Chamber"><?php echo $chambers->Chamber->caption() ?><?php echo ($chambers->Chamber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="chambers" data-field="x_Chamber" name="x_Chamber" id="x_Chamber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($chambers->Chamber->getPlaceHolder()) ?>" value="<?php echo $chambers->Chamber->EditValue ?>"<?php echo $chambers->Chamber->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($chambers->Notes->Visible) { // Notes ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Notes"><?php echo $chambers->Notes->caption() ?><?php echo ($chambers->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="chambers" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($chambers->Notes->getPlaceHolder()) ?>"<?php echo $chambers->Notes->editAttributes() ?>><?php echo $chambers->Notes->EditValue ?></textarea>
</div>
	</div>
<?php } ?>
</form>
<?php
$chambers_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$chambers_addopt->terminate();
?>
