<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$branches_view = new branches_view();

// Run the page
$branches_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$branches_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$branches->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fbranchesview = currentForm = new ew.Form("fbranchesview", "view");

// Form_CustomValidate event
fbranchesview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbranchesview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbranchesview.lists["x_LawFirmID"] = <?php echo $branches_view->LawFirmID->Lookup->toClientList() ?>;
fbranchesview.lists["x_LawFirmID"].options = <?php echo JsonEncode($branches_view->LawFirmID->lookupOptions()) ?>;
fbranchesview.lists["x_Activated[]"] = <?php echo $branches_view->Activated->Lookup->toClientList() ?>;
fbranchesview.lists["x_Activated[]"].options = <?php echo JsonEncode($branches_view->Activated->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$branches->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $branches_view->ExportOptions->render("body") ?>
<?php $branches_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $branches_view->showPageHeader(); ?>
<?php
$branches_view->showMessage();
?>
<?php if (!$branches_view->IsModal) { ?>
<?php if (!$branches->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($branches_view->Pager)) $branches_view->Pager = new PrevNextPager($branches_view->StartRec, $branches_view->DisplayRecs, $branches_view->TotalRecs, $branches_view->AutoHidePager) ?>
<?php if ($branches_view->Pager->RecordCount > 0 && $branches_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($branches_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $branches_view->pageUrl() ?>start=<?php echo $branches_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($branches_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $branches_view->pageUrl() ?>start=<?php echo $branches_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $branches_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($branches_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $branches_view->pageUrl() ?>start=<?php echo $branches_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($branches_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $branches_view->pageUrl() ?>start=<?php echo $branches_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $branches_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fbranchesview" id="fbranchesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($branches_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $branches_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="branches">
<input type="hidden" name="modal" value="<?php echo (int)$branches_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($branches->BranchID->Visible) { // BranchID ?>
	<tr id="r_BranchID">
		<td class="<?php echo $branches_view->TableLeftColumnClass ?>"><span id="elh_branches_BranchID"><?php echo $branches->BranchID->caption() ?></span></td>
		<td data-name="BranchID"<?php echo $branches->BranchID->cellAttributes() ?>>
<span id="el_branches_BranchID">
<span<?php echo $branches->BranchID->viewAttributes() ?>>
<?php echo $branches->BranchID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($branches->Branch->Visible) { // Branch ?>
	<tr id="r_Branch">
		<td class="<?php echo $branches_view->TableLeftColumnClass ?>"><span id="elh_branches_Branch"><?php echo $branches->Branch->caption() ?></span></td>
		<td data-name="Branch"<?php echo $branches->Branch->cellAttributes() ?>>
<span id="el_branches_Branch">
<span<?php echo $branches->Branch->viewAttributes() ?>>
<?php echo $branches->Branch->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($branches->BranchEn->Visible) { // BranchEn ?>
	<tr id="r_BranchEn">
		<td class="<?php echo $branches_view->TableLeftColumnClass ?>"><span id="elh_branches_BranchEn"><?php echo $branches->BranchEn->caption() ?></span></td>
		<td data-name="BranchEn"<?php echo $branches->BranchEn->cellAttributes() ?>>
<span id="el_branches_BranchEn">
<span<?php echo $branches->BranchEn->viewAttributes() ?>>
<?php echo $branches->BranchEn->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($branches->LawFirmID->Visible) { // LawFirmID ?>
	<tr id="r_LawFirmID">
		<td class="<?php echo $branches_view->TableLeftColumnClass ?>"><span id="elh_branches_LawFirmID"><?php echo $branches->LawFirmID->caption() ?></span></td>
		<td data-name="LawFirmID"<?php echo $branches->LawFirmID->cellAttributes() ?>>
<span id="el_branches_LawFirmID">
<span<?php echo $branches->LawFirmID->viewAttributes() ?>>
<?php echo $branches->LawFirmID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($branches->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $branches_view->TableLeftColumnClass ?>"><span id="elh_branches_Notes"><?php echo $branches->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $branches->Notes->cellAttributes() ?>>
<span id="el_branches_Notes">
<span<?php echo $branches->Notes->viewAttributes() ?>>
<?php echo $branches->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($branches->Activated->Visible) { // Activated ?>
	<tr id="r_Activated">
		<td class="<?php echo $branches_view->TableLeftColumnClass ?>"><span id="elh_branches_Activated"><?php echo $branches->Activated->caption() ?></span></td>
		<td data-name="Activated"<?php echo $branches->Activated->cellAttributes() ?>>
<span id="el_branches_Activated">
<span<?php echo $branches->Activated->viewAttributes() ?>>
<?php if (ConvertToBool($branches->Activated->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $branches->Activated->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $branches->Activated->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$branches_view->IsModal) { ?>
<?php if (!$branches->isExport()) { ?>
<?php if (!isset($branches_view->Pager)) $branches_view->Pager = new PrevNextPager($branches_view->StartRec, $branches_view->DisplayRecs, $branches_view->TotalRecs, $branches_view->AutoHidePager) ?>
<?php if ($branches_view->Pager->RecordCount > 0 && $branches_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($branches_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $branches_view->pageUrl() ?>start=<?php echo $branches_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($branches_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $branches_view->pageUrl() ?>start=<?php echo $branches_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $branches_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($branches_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $branches_view->pageUrl() ?>start=<?php echo $branches_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($branches_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $branches_view->pageUrl() ?>start=<?php echo $branches_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $branches_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$branches_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$branches->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$branches_view->terminate();
?>
