<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$branches_addopt = new branches_addopt();

// Run the page
$branches_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$branches_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fbranchesaddopt = currentForm = new ew.Form("fbranchesaddopt", "addopt");

// Validate form
fbranchesaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($branches_addopt->Branch->Required) { ?>
			elm = this.getElements("x" + infix + "_Branch");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->Branch->caption(), $branches->Branch->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($branches_addopt->LawFirmID->Required) { ?>
			elm = this.getElements("x" + infix + "_LawFirmID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->LawFirmID->caption(), $branches->LawFirmID->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbranchesaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbranchesaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbranchesaddopt.lists["x_LawFirmID"] = <?php echo $branches_addopt->LawFirmID->Lookup->toClientList() ?>;
fbranchesaddopt.lists["x_LawFirmID"].options = <?php echo JsonEncode($branches_addopt->LawFirmID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $branches_addopt->showPageHeader(); ?>
<?php
$branches_addopt->showMessage();
?>
<form name="fbranchesaddopt" id="fbranchesaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($branches_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $branches_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $branches_addopt->TableVar ?>">
<?php if ($branches->Branch->Visible) { // Branch ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Branch"><?php echo $branches->Branch->caption() ?><?php echo ($branches->Branch->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="branches" data-field="x_Branch" name="x_Branch" id="x_Branch" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->Branch->getPlaceHolder()) ?>" value="<?php echo $branches->Branch->EditValue ?>"<?php echo $branches->Branch->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($branches->LawFirmID->Visible) { // LawFirmID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_LawFirmID"><?php echo $branches->LawFirmID->caption() ?><?php echo ($branches->LawFirmID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="branches" data-field="x_LawFirmID" data-value-separator="<?php echo $branches->LawFirmID->displayValueSeparatorAttribute() ?>" id="x_LawFirmID" name="x_LawFirmID"<?php echo $branches->LawFirmID->editAttributes() ?>>
		<?php echo $branches->LawFirmID->selectOptionListHtml("x_LawFirmID") ?>
	</select>
</div>
<?php echo $branches->LawFirmID->Lookup->getParamTag("p_x_LawFirmID") ?>
</div>
	</div>
<?php } ?>
</form>
<?php
$branches_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$branches_addopt->terminate();
?>
