<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$titles_list = new titles_list();

// Run the page
$titles_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$titles_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$titles->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ftitleslist = currentForm = new ew.Form("ftitleslist", "list");
ftitleslist.formKeyCountName = '<?php echo $titles_list->FormKeyCountName ?>';

// Form_CustomValidate event
ftitleslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftitleslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var ftitleslistsrch = currentSearchForm = new ew.Form("ftitleslistsrch");

// Filters
ftitleslistsrch.filterList = <?php echo $titles_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$titles->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($titles_list->TotalRecs > 0 && $titles_list->ExportOptions->visible()) { ?>
<?php $titles_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($titles_list->ImportOptions->visible()) { ?>
<?php $titles_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($titles_list->SearchOptions->visible()) { ?>
<?php $titles_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($titles_list->FilterOptions->visible()) { ?>
<?php $titles_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$titles_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$titles->isExport() && !$titles->CurrentAction) { ?>
<form name="ftitleslistsrch" id="ftitleslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($titles_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="ftitleslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="titles">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($titles_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($titles_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $titles_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($titles_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($titles_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($titles_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($titles_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $titles_list->showPageHeader(); ?>
<?php
$titles_list->showMessage();
?>
<?php if ($titles_list->TotalRecs > 0 || $titles->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($titles_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> titles">
<?php if (!$titles->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$titles->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($titles_list->Pager)) $titles_list->Pager = new PrevNextPager($titles_list->StartRec, $titles_list->DisplayRecs, $titles_list->TotalRecs, $titles_list->AutoHidePager) ?>
<?php if ($titles_list->Pager->RecordCount > 0 && $titles_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($titles_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $titles_list->pageUrl() ?>start=<?php echo $titles_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($titles_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $titles_list->pageUrl() ?>start=<?php echo $titles_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $titles_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($titles_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $titles_list->pageUrl() ?>start=<?php echo $titles_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($titles_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $titles_list->pageUrl() ?>start=<?php echo $titles_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $titles_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($titles_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $titles_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $titles_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $titles_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($titles_list->TotalRecs > 0 && (!$titles_list->AutoHidePageSizeSelector || $titles_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="titles">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($titles_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($titles_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($titles_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($titles_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($titles_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($titles_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($titles_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($titles_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($titles_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($titles->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $titles_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ftitleslist" id="ftitleslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($titles_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $titles_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="titles">
<div id="gmp_titles" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($titles_list->TotalRecs > 0 || $titles->isGridEdit()) { ?>
<table id="tbl_titleslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$titles_list->RowType = ROWTYPE_HEADER;

// Render list options
$titles_list->renderListOptions();

// Render list options (header, left)
$titles_list->ListOptions->render("header", "left");
?>
<?php if ($titles->Title->Visible) { // Title ?>
	<?php if ($titles->sortUrl($titles->Title) == "") { ?>
		<th data-name="Title" class="<?php echo $titles->Title->headerCellClass() ?>"><div id="elh_titles_Title" class="titles_Title"><div class="ew-table-header-caption"><?php echo $titles->Title->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Title" class="<?php echo $titles->Title->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $titles->SortUrl($titles->Title) ?>',2);"><div id="elh_titles_Title" class="titles_Title">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $titles->Title->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($titles->Title->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($titles->Title->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($titles->TitleEn->Visible) { // TitleEn ?>
	<?php if ($titles->sortUrl($titles->TitleEn) == "") { ?>
		<th data-name="TitleEn" class="<?php echo $titles->TitleEn->headerCellClass() ?>"><div id="elh_titles_TitleEn" class="titles_TitleEn"><div class="ew-table-header-caption"><?php echo $titles->TitleEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TitleEn" class="<?php echo $titles->TitleEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $titles->SortUrl($titles->TitleEn) ?>',2);"><div id="elh_titles_TitleEn" class="titles_TitleEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $titles->TitleEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($titles->TitleEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($titles->TitleEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($titles->Salutation->Visible) { // Salutation ?>
	<?php if ($titles->sortUrl($titles->Salutation) == "") { ?>
		<th data-name="Salutation" class="<?php echo $titles->Salutation->headerCellClass() ?>"><div id="elh_titles_Salutation" class="titles_Salutation"><div class="ew-table-header-caption"><?php echo $titles->Salutation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Salutation" class="<?php echo $titles->Salutation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $titles->SortUrl($titles->Salutation) ?>',2);"><div id="elh_titles_Salutation" class="titles_Salutation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $titles->Salutation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($titles->Salutation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($titles->Salutation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($titles->SalutationEn->Visible) { // SalutationEn ?>
	<?php if ($titles->sortUrl($titles->SalutationEn) == "") { ?>
		<th data-name="SalutationEn" class="<?php echo $titles->SalutationEn->headerCellClass() ?>"><div id="elh_titles_SalutationEn" class="titles_SalutationEn"><div class="ew-table-header-caption"><?php echo $titles->SalutationEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SalutationEn" class="<?php echo $titles->SalutationEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $titles->SortUrl($titles->SalutationEn) ?>',2);"><div id="elh_titles_SalutationEn" class="titles_SalutationEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $titles->SalutationEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($titles->SalutationEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($titles->SalutationEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($titles->Notes->Visible) { // Notes ?>
	<?php if ($titles->sortUrl($titles->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $titles->Notes->headerCellClass() ?>"><div id="elh_titles_Notes" class="titles_Notes"><div class="ew-table-header-caption"><?php echo $titles->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $titles->Notes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $titles->SortUrl($titles->Notes) ?>',2);"><div id="elh_titles_Notes" class="titles_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $titles->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($titles->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($titles->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$titles_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($titles->ExportAll && $titles->isExport()) {
	$titles_list->StopRec = $titles_list->TotalRecs;
} else {

	// Set the last record to display
	if ($titles_list->TotalRecs > $titles_list->StartRec + $titles_list->DisplayRecs - 1)
		$titles_list->StopRec = $titles_list->StartRec + $titles_list->DisplayRecs - 1;
	else
		$titles_list->StopRec = $titles_list->TotalRecs;
}
$titles_list->RecCnt = $titles_list->StartRec - 1;
if ($titles_list->Recordset && !$titles_list->Recordset->EOF) {
	$titles_list->Recordset->moveFirst();
	$selectLimit = $titles_list->UseSelectLimit;
	if (!$selectLimit && $titles_list->StartRec > 1)
		$titles_list->Recordset->move($titles_list->StartRec - 1);
} elseif (!$titles->AllowAddDeleteRow && $titles_list->StopRec == 0) {
	$titles_list->StopRec = $titles->GridAddRowCount;
}

// Initialize aggregate
$titles->RowType = ROWTYPE_AGGREGATEINIT;
$titles->resetAttributes();
$titles_list->renderRow();
while ($titles_list->RecCnt < $titles_list->StopRec) {
	$titles_list->RecCnt++;
	if ($titles_list->RecCnt >= $titles_list->StartRec) {
		$titles_list->RowCnt++;

		// Set up key count
		$titles_list->KeyCount = $titles_list->RowIndex;

		// Init row class and style
		$titles->resetAttributes();
		$titles->CssClass = "";
		if ($titles->isGridAdd()) {
		} else {
			$titles_list->loadRowValues($titles_list->Recordset); // Load row values
		}
		$titles->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$titles->RowAttrs = array_merge($titles->RowAttrs, array('data-rowindex'=>$titles_list->RowCnt, 'id'=>'r' . $titles_list->RowCnt . '_titles', 'data-rowtype'=>$titles->RowType));

		// Render row
		$titles_list->renderRow();

		// Render list options
		$titles_list->renderListOptions();
?>
	<tr<?php echo $titles->rowAttributes() ?>>
<?php

// Render list options (body, left)
$titles_list->ListOptions->render("body", "left", $titles_list->RowCnt);
?>
	<?php if ($titles->Title->Visible) { // Title ?>
		<td data-name="Title"<?php echo $titles->Title->cellAttributes() ?>>
<span id="el<?php echo $titles_list->RowCnt ?>_titles_Title" class="titles_Title">
<span<?php echo $titles->Title->viewAttributes() ?>>
<?php echo $titles->Title->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($titles->TitleEn->Visible) { // TitleEn ?>
		<td data-name="TitleEn"<?php echo $titles->TitleEn->cellAttributes() ?>>
<span id="el<?php echo $titles_list->RowCnt ?>_titles_TitleEn" class="titles_TitleEn">
<span<?php echo $titles->TitleEn->viewAttributes() ?>>
<?php echo $titles->TitleEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($titles->Salutation->Visible) { // Salutation ?>
		<td data-name="Salutation"<?php echo $titles->Salutation->cellAttributes() ?>>
<span id="el<?php echo $titles_list->RowCnt ?>_titles_Salutation" class="titles_Salutation">
<span<?php echo $titles->Salutation->viewAttributes() ?>>
<?php echo $titles->Salutation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($titles->SalutationEn->Visible) { // SalutationEn ?>
		<td data-name="SalutationEn"<?php echo $titles->SalutationEn->cellAttributes() ?>>
<span id="el<?php echo $titles_list->RowCnt ?>_titles_SalutationEn" class="titles_SalutationEn">
<span<?php echo $titles->SalutationEn->viewAttributes() ?>>
<?php echo $titles->SalutationEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($titles->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $titles->Notes->cellAttributes() ?>>
<span id="el<?php echo $titles_list->RowCnt ?>_titles_Notes" class="titles_Notes">
<span<?php echo $titles->Notes->viewAttributes() ?>>
<?php echo $titles->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$titles_list->ListOptions->render("body", "right", $titles_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$titles->isGridAdd())
		$titles_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$titles->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($titles_list->Recordset)
	$titles_list->Recordset->Close();
?>
<?php if (!$titles->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$titles->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($titles_list->Pager)) $titles_list->Pager = new PrevNextPager($titles_list->StartRec, $titles_list->DisplayRecs, $titles_list->TotalRecs, $titles_list->AutoHidePager) ?>
<?php if ($titles_list->Pager->RecordCount > 0 && $titles_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($titles_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $titles_list->pageUrl() ?>start=<?php echo $titles_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($titles_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $titles_list->pageUrl() ?>start=<?php echo $titles_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $titles_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($titles_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $titles_list->pageUrl() ?>start=<?php echo $titles_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($titles_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $titles_list->pageUrl() ?>start=<?php echo $titles_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $titles_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($titles_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $titles_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $titles_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $titles_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($titles_list->TotalRecs > 0 && (!$titles_list->AutoHidePageSizeSelector || $titles_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="titles">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($titles_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($titles_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($titles_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($titles_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($titles_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($titles_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($titles_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($titles_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($titles_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($titles->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $titles_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($titles_list->TotalRecs == 0 && !$titles->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $titles_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$titles_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$titles->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$titles->isExport()) { ?>
<script>
ew.scrollableTable("gmp_titles", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$titles_list->terminate();
?>
