<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sections_addopt = new sections_addopt();

// Run the page
$sections_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sections_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fsectionsaddopt = currentForm = new ew.Form("fsectionsaddopt", "addopt");

// Validate form
fsectionsaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($sections_addopt->Section->Required) { ?>
			elm = this.getElements("x" + infix + "_Section");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sections->Section->caption(), $sections->Section->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sections_addopt->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sections->Notes->caption(), $sections->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsectionsaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsectionsaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sections_addopt->showPageHeader(); ?>
<?php
$sections_addopt->showMessage();
?>
<form name="fsectionsaddopt" id="fsectionsaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($sections_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sections_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $sections_addopt->TableVar ?>">
<?php if ($sections->Section->Visible) { // Section ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Section"><?php echo $sections->Section->caption() ?><?php echo ($sections->Section->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="sections" data-field="x_Section" name="x_Section" id="x_Section" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($sections->Section->getPlaceHolder()) ?>" value="<?php echo $sections->Section->EditValue ?>"<?php echo $sections->Section->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($sections->Notes->Visible) { // Notes ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Notes"><?php echo $sections->Notes->caption() ?><?php echo ($sections->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="sections" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($sections->Notes->getPlaceHolder()) ?>"<?php echo $sections->Notes->editAttributes() ?>><?php echo $sections->Notes->EditValue ?></textarea>
</div>
	</div>
<?php } ?>
</form>
<?php
$sections_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$sections_addopt->terminate();
?>
