<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$notifications_preview = new notifications_preview();

// Run the page
$notifications_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$notifications_preview->Page_Render();
?>
<?php $notifications_preview->showPageHeader(); ?>
<div class="card ew-grid notifications"><!-- .card -->
<?php if ($notifications_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$notifications_preview->renderListOptions();

// Render list options (header, left)
$notifications_preview->ListOptions->render("header", "left");
?>
<?php if ($notifications->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($notifications->SortUrl($notifications->CaseNumber) == "") { ?>
		<th class="<?php echo $notifications->CaseNumber->headerCellClass() ?>"><?php echo $notifications->CaseNumber->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $notifications->CaseNumber->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $notifications->CaseNumber->Name ?>" data-sort-order="<?php echo $notifications_preview->SortField == $notifications->CaseNumber->Name && $notifications_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $notifications->CaseNumber->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($notifications_preview->SortField == $notifications->CaseNumber->Name) { ?><?php if ($notifications_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($notifications_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->Notification->Visible) { // Notification ?>
	<?php if ($notifications->SortUrl($notifications->Notification) == "") { ?>
		<th class="<?php echo $notifications->Notification->headerCellClass() ?>"><?php echo $notifications->Notification->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $notifications->Notification->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $notifications->Notification->Name ?>" data-sort-order="<?php echo $notifications_preview->SortField == $notifications->Notification->Name && $notifications_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $notifications->Notification->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($notifications_preview->SortField == $notifications->Notification->Name) { ?><?php if ($notifications_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($notifications_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->NotificationDate->Visible) { // NotificationDate ?>
	<?php if ($notifications->SortUrl($notifications->NotificationDate) == "") { ?>
		<th class="<?php echo $notifications->NotificationDate->headerCellClass() ?>"><?php echo $notifications->NotificationDate->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $notifications->NotificationDate->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $notifications->NotificationDate->Name ?>" data-sort-order="<?php echo $notifications_preview->SortField == $notifications->NotificationDate->Name && $notifications_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $notifications->NotificationDate->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($notifications_preview->SortField == $notifications->NotificationDate->Name) { ?><?php if ($notifications_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($notifications_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->NotificationTime->Visible) { // NotificationTime ?>
	<?php if ($notifications->SortUrl($notifications->NotificationTime) == "") { ?>
		<th class="<?php echo $notifications->NotificationTime->headerCellClass() ?>"><?php echo $notifications->NotificationTime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $notifications->NotificationTime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $notifications->NotificationTime->Name ?>" data-sort-order="<?php echo $notifications_preview->SortField == $notifications->NotificationTime->Name && $notifications_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $notifications->NotificationTime->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($notifications_preview->SortField == $notifications->NotificationTime->Name) { ?><?php if ($notifications_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($notifications_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->Notes->Visible) { // Notes ?>
	<?php if ($notifications->SortUrl($notifications->Notes) == "") { ?>
		<th class="<?php echo $notifications->Notes->headerCellClass() ?>"><?php echo $notifications->Notes->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $notifications->Notes->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $notifications->Notes->Name ?>" data-sort-order="<?php echo $notifications_preview->SortField == $notifications->Notes->Name && $notifications_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $notifications->Notes->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($notifications_preview->SortField == $notifications->Notes->Name) { ?><?php if ($notifications_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($notifications_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$notifications_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$notifications_preview->RecCount = 0;
$notifications_preview->RowCnt = 0;
while ($notifications_preview->Recordset && !$notifications_preview->Recordset->EOF) {

	// Init row class and style
	$notifications_preview->RecCount++;
	$notifications_preview->RowCnt++;
	$notifications_preview->CssStyle = "";
	$notifications_preview->loadListRowValues($notifications_preview->Recordset);

	// Render row
	$notifications_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$notifications_preview->resetAttributes();
	$notifications_preview->renderListRow();

	// Render list options
	$notifications_preview->renderListOptions();
?>
	<tr<?php echo $notifications_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$notifications_preview->ListOptions->render("body", "left", $notifications_preview->RowCnt);
?>
<?php if ($notifications->CaseNumber->Visible) { // CaseNumber ?>
		<!-- CaseNumber -->
		<td<?php echo $notifications->CaseNumber->cellAttributes() ?>>
<span<?php echo $notifications->CaseNumber->viewAttributes() ?>>
<?php echo $notifications->CaseNumber->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($notifications->Notification->Visible) { // Notification ?>
		<!-- Notification -->
		<td<?php echo $notifications->Notification->cellAttributes() ?>>
<span<?php echo $notifications->Notification->viewAttributes() ?>>
<?php echo $notifications->Notification->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($notifications->NotificationDate->Visible) { // NotificationDate ?>
		<!-- NotificationDate -->
		<td<?php echo $notifications->NotificationDate->cellAttributes() ?>>
<span<?php echo $notifications->NotificationDate->viewAttributes() ?>>
<?php echo $notifications->NotificationDate->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($notifications->NotificationTime->Visible) { // NotificationTime ?>
		<!-- NotificationTime -->
		<td<?php echo $notifications->NotificationTime->cellAttributes() ?>>
<span<?php echo $notifications->NotificationTime->viewAttributes() ?>>
<?php echo $notifications->NotificationTime->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($notifications->Notes->Visible) { // Notes ?>
		<!-- Notes -->
		<td<?php echo $notifications->Notes->cellAttributes() ?>>
<span<?php echo $notifications->Notes->viewAttributes() ?>>
<?php echo $notifications->Notes->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$notifications_preview->ListOptions->render("body", "right", $notifications_preview->RowCnt);
?>
	</tr>
<?php
	$notifications_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($notifications_preview->TotalRecs > 0) { ?>
<?php if (!isset($notifications_preview->Pager)) $notifications_preview->Pager = new PrevNextPager($notifications_preview->StartRec, $notifications_preview->DisplayRecs, $notifications_preview->TotalRecs) ?>
<?php if ($notifications_preview->Pager->RecordCount > 0 && $notifications_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($notifications_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $notifications_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($notifications_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $notifications_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($notifications_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $notifications_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($notifications_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $notifications_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $notifications_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $notifications_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $notifications_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($notifications_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$notifications_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($notifications_preview->Recordset)
	$notifications_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$notifications_preview->terminate();
?>
