<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$notifications_list = new notifications_list();

// Run the page
$notifications_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$notifications_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$notifications->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fnotificationslist = currentForm = new ew.Form("fnotificationslist", "list");
fnotificationslist.formKeyCountName = '<?php echo $notifications_list->FormKeyCountName ?>';

// Form_CustomValidate event
fnotificationslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnotificationslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fnotificationslistsrch = currentSearchForm = new ew.Form("fnotificationslistsrch");

// Validate function for search
fnotificationslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fnotificationslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnotificationslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fnotificationslistsrch.filterList = <?php echo $notifications_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$notifications->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($notifications_list->TotalRecs > 0 && $notifications_list->ExportOptions->visible()) { ?>
<?php $notifications_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($notifications_list->ImportOptions->visible()) { ?>
<?php $notifications_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($notifications_list->SearchOptions->visible()) { ?>
<?php $notifications_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($notifications_list->FilterOptions->visible()) { ?>
<?php $notifications_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$notifications->isExport() || EXPORT_MASTER_RECORD && $notifications->isExport("print")) { ?>
<?php
if ($notifications_list->DbMasterFilter <> "" && $notifications->getCurrentMasterTable() == "cases") {
	if ($notifications_list->MasterRecordExists) {
		include_once "casesmaster.php";
	}
}
?>
<?php } ?>
<?php
$notifications_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$notifications->isExport() && !$notifications->CurrentAction) { ?>
<form name="fnotificationslistsrch" id="fnotificationslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($notifications_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fnotificationslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="notifications">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$notifications_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$notifications->RowType = ROWTYPE_SEARCH;

// Render row
$notifications->resetAttributes();
$notifications_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($notifications->CaseNumber->Visible) { // CaseNumber ?>
	<div id="xsc_CaseNumber" class="ew-cell form-group">
		<label for="x_CaseNumber" class="ew-search-caption ew-label"><?php echo $notifications->CaseNumber->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CaseNumber" id="z_CaseNumber" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="notifications" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($notifications->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $notifications->CaseNumber->EditValue ?>"<?php echo $notifications->CaseNumber->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($notifications_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($notifications_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $notifications_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($notifications_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($notifications_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($notifications_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($notifications_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $notifications_list->showPageHeader(); ?>
<?php
$notifications_list->showMessage();
?>
<?php if ($notifications_list->TotalRecs > 0 || $notifications->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($notifications_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> notifications">
<?php if (!$notifications->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$notifications->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($notifications_list->Pager)) $notifications_list->Pager = new PrevNextPager($notifications_list->StartRec, $notifications_list->DisplayRecs, $notifications_list->TotalRecs, $notifications_list->AutoHidePager) ?>
<?php if ($notifications_list->Pager->RecordCount > 0 && $notifications_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($notifications_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $notifications_list->pageUrl() ?>start=<?php echo $notifications_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($notifications_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $notifications_list->pageUrl() ?>start=<?php echo $notifications_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $notifications_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($notifications_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $notifications_list->pageUrl() ?>start=<?php echo $notifications_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($notifications_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $notifications_list->pageUrl() ?>start=<?php echo $notifications_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $notifications_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($notifications_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $notifications_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $notifications_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $notifications_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($notifications_list->TotalRecs > 0 && (!$notifications_list->AutoHidePageSizeSelector || $notifications_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="notifications">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($notifications_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($notifications_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($notifications_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($notifications_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($notifications_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($notifications_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($notifications_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($notifications_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($notifications_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($notifications->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $notifications_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fnotificationslist" id="fnotificationslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($notifications_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $notifications_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="notifications">
<?php if ($notifications->getCurrentMasterTable() == "cases" && $notifications->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="cases">
<input type="hidden" name="fk_CaseID" value="<?php echo $notifications->CaseID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_notifications" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($notifications_list->TotalRecs > 0 || $notifications->isGridEdit()) { ?>
<table id="tbl_notificationslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$notifications_list->RowType = ROWTYPE_HEADER;

// Render list options
$notifications_list->renderListOptions();

// Render list options (header, left)
$notifications_list->ListOptions->render("header", "left");
?>
<?php if ($notifications->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($notifications->sortUrl($notifications->CaseNumber) == "") { ?>
		<th data-name="CaseNumber" class="<?php echo $notifications->CaseNumber->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_notifications_CaseNumber" class="notifications_CaseNumber"><div class="ew-table-header-caption"><?php echo $notifications->CaseNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseNumber" class="<?php echo $notifications->CaseNumber->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $notifications->SortUrl($notifications->CaseNumber) ?>',2);"><div id="elh_notifications_CaseNumber" class="notifications_CaseNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notifications->CaseNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($notifications->CaseNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notifications->CaseNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->Notification->Visible) { // Notification ?>
	<?php if ($notifications->sortUrl($notifications->Notification) == "") { ?>
		<th data-name="Notification" class="<?php echo $notifications->Notification->headerCellClass() ?>"><div id="elh_notifications_Notification" class="notifications_Notification"><div class="ew-table-header-caption"><?php echo $notifications->Notification->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notification" class="<?php echo $notifications->Notification->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $notifications->SortUrl($notifications->Notification) ?>',2);"><div id="elh_notifications_Notification" class="notifications_Notification">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notifications->Notification->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($notifications->Notification->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notifications->Notification->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->NotificationDate->Visible) { // NotificationDate ?>
	<?php if ($notifications->sortUrl($notifications->NotificationDate) == "") { ?>
		<th data-name="NotificationDate" class="<?php echo $notifications->NotificationDate->headerCellClass() ?>"><div id="elh_notifications_NotificationDate" class="notifications_NotificationDate"><div class="ew-table-header-caption"><?php echo $notifications->NotificationDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NotificationDate" class="<?php echo $notifications->NotificationDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $notifications->SortUrl($notifications->NotificationDate) ?>',2);"><div id="elh_notifications_NotificationDate" class="notifications_NotificationDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notifications->NotificationDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($notifications->NotificationDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notifications->NotificationDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->NotificationTime->Visible) { // NotificationTime ?>
	<?php if ($notifications->sortUrl($notifications->NotificationTime) == "") { ?>
		<th data-name="NotificationTime" class="<?php echo $notifications->NotificationTime->headerCellClass() ?>"><div id="elh_notifications_NotificationTime" class="notifications_NotificationTime"><div class="ew-table-header-caption"><?php echo $notifications->NotificationTime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NotificationTime" class="<?php echo $notifications->NotificationTime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $notifications->SortUrl($notifications->NotificationTime) ?>',2);"><div id="elh_notifications_NotificationTime" class="notifications_NotificationTime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notifications->NotificationTime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($notifications->NotificationTime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notifications->NotificationTime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->Notes->Visible) { // Notes ?>
	<?php if ($notifications->sortUrl($notifications->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $notifications->Notes->headerCellClass() ?>"><div id="elh_notifications_Notes" class="notifications_Notes"><div class="ew-table-header-caption"><?php echo $notifications->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $notifications->Notes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $notifications->SortUrl($notifications->Notes) ?>',2);"><div id="elh_notifications_Notes" class="notifications_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notifications->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($notifications->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notifications->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$notifications_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($notifications->ExportAll && $notifications->isExport()) {
	$notifications_list->StopRec = $notifications_list->TotalRecs;
} else {

	// Set the last record to display
	if ($notifications_list->TotalRecs > $notifications_list->StartRec + $notifications_list->DisplayRecs - 1)
		$notifications_list->StopRec = $notifications_list->StartRec + $notifications_list->DisplayRecs - 1;
	else
		$notifications_list->StopRec = $notifications_list->TotalRecs;
}
$notifications_list->RecCnt = $notifications_list->StartRec - 1;
if ($notifications_list->Recordset && !$notifications_list->Recordset->EOF) {
	$notifications_list->Recordset->moveFirst();
	$selectLimit = $notifications_list->UseSelectLimit;
	if (!$selectLimit && $notifications_list->StartRec > 1)
		$notifications_list->Recordset->move($notifications_list->StartRec - 1);
} elseif (!$notifications->AllowAddDeleteRow && $notifications_list->StopRec == 0) {
	$notifications_list->StopRec = $notifications->GridAddRowCount;
}

// Initialize aggregate
$notifications->RowType = ROWTYPE_AGGREGATEINIT;
$notifications->resetAttributes();
$notifications_list->renderRow();
while ($notifications_list->RecCnt < $notifications_list->StopRec) {
	$notifications_list->RecCnt++;
	if ($notifications_list->RecCnt >= $notifications_list->StartRec) {
		$notifications_list->RowCnt++;

		// Set up key count
		$notifications_list->KeyCount = $notifications_list->RowIndex;

		// Init row class and style
		$notifications->resetAttributes();
		$notifications->CssClass = "";
		if ($notifications->isGridAdd()) {
		} else {
			$notifications_list->loadRowValues($notifications_list->Recordset); // Load row values
		}
		$notifications->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$notifications->RowAttrs = array_merge($notifications->RowAttrs, array('data-rowindex'=>$notifications_list->RowCnt, 'id'=>'r' . $notifications_list->RowCnt . '_notifications', 'data-rowtype'=>$notifications->RowType));

		// Render row
		$notifications_list->renderRow();

		// Render list options
		$notifications_list->renderListOptions();
?>
	<tr<?php echo $notifications->rowAttributes() ?>>
<?php

// Render list options (body, left)
$notifications_list->ListOptions->render("body", "left", $notifications_list->RowCnt);
?>
	<?php if ($notifications->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber"<?php echo $notifications->CaseNumber->cellAttributes() ?>>
<span id="el<?php echo $notifications_list->RowCnt ?>_notifications_CaseNumber" class="notifications_CaseNumber">
<span<?php echo $notifications->CaseNumber->viewAttributes() ?>>
<?php echo $notifications->CaseNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($notifications->Notification->Visible) { // Notification ?>
		<td data-name="Notification"<?php echo $notifications->Notification->cellAttributes() ?>>
<span id="el<?php echo $notifications_list->RowCnt ?>_notifications_Notification" class="notifications_Notification">
<span<?php echo $notifications->Notification->viewAttributes() ?>>
<?php echo $notifications->Notification->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($notifications->NotificationDate->Visible) { // NotificationDate ?>
		<td data-name="NotificationDate"<?php echo $notifications->NotificationDate->cellAttributes() ?>>
<span id="el<?php echo $notifications_list->RowCnt ?>_notifications_NotificationDate" class="notifications_NotificationDate">
<span<?php echo $notifications->NotificationDate->viewAttributes() ?>>
<?php echo $notifications->NotificationDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($notifications->NotificationTime->Visible) { // NotificationTime ?>
		<td data-name="NotificationTime"<?php echo $notifications->NotificationTime->cellAttributes() ?>>
<span id="el<?php echo $notifications_list->RowCnt ?>_notifications_NotificationTime" class="notifications_NotificationTime">
<span<?php echo $notifications->NotificationTime->viewAttributes() ?>>
<?php echo $notifications->NotificationTime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($notifications->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $notifications->Notes->cellAttributes() ?>>
<span id="el<?php echo $notifications_list->RowCnt ?>_notifications_Notes" class="notifications_Notes">
<span<?php echo $notifications->Notes->viewAttributes() ?>>
<?php echo $notifications->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$notifications_list->ListOptions->render("body", "right", $notifications_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$notifications->isGridAdd())
		$notifications_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$notifications->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($notifications_list->Recordset)
	$notifications_list->Recordset->Close();
?>
<?php if (!$notifications->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$notifications->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($notifications_list->Pager)) $notifications_list->Pager = new PrevNextPager($notifications_list->StartRec, $notifications_list->DisplayRecs, $notifications_list->TotalRecs, $notifications_list->AutoHidePager) ?>
<?php if ($notifications_list->Pager->RecordCount > 0 && $notifications_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($notifications_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $notifications_list->pageUrl() ?>start=<?php echo $notifications_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($notifications_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $notifications_list->pageUrl() ?>start=<?php echo $notifications_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $notifications_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($notifications_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $notifications_list->pageUrl() ?>start=<?php echo $notifications_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($notifications_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $notifications_list->pageUrl() ?>start=<?php echo $notifications_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $notifications_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($notifications_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $notifications_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $notifications_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $notifications_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($notifications_list->TotalRecs > 0 && (!$notifications_list->AutoHidePageSizeSelector || $notifications_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="notifications">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($notifications_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($notifications_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($notifications_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($notifications_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($notifications_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($notifications_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($notifications_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($notifications_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($notifications_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($notifications->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $notifications_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($notifications_list->TotalRecs == 0 && !$notifications->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $notifications_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$notifications_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$notifications->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$notifications->isExport()) { ?>
<script>
ew.scrollableTable("gmp_notifications", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$notifications_list->terminate();
?>
