<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$litigants_list = new litigants_list();

// Run the page
$litigants_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$litigants_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$litigants->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var flitigantslist = currentForm = new ew.Form("flitigantslist", "list");
flitigantslist.formKeyCountName = '<?php echo $litigants_list->FormKeyCountName ?>';

// Form_CustomValidate event
flitigantslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flitigantslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flitigantslist.lists["x_LitigantTypeID"] = <?php echo $litigants_list->LitigantTypeID->Lookup->toClientList() ?>;
flitigantslist.lists["x_LitigantTypeID"].options = <?php echo JsonEncode($litigants_list->LitigantTypeID->lookupOptions()) ?>;
flitigantslist.lists["x_LitigantGroupID"] = <?php echo $litigants_list->LitigantGroupID->Lookup->toClientList() ?>;
flitigantslist.lists["x_LitigantGroupID"].options = <?php echo JsonEncode($litigants_list->LitigantGroupID->lookupOptions()) ?>;
flitigantslist.autoSuggests["x_LitigantGroupID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
flitigantslist.lists["x_TitleID"] = <?php echo $litigants_list->TitleID->Lookup->toClientList() ?>;
flitigantslist.lists["x_TitleID"].options = <?php echo JsonEncode($litigants_list->TitleID->lookupOptions()) ?>;
flitigantslist.lists["x_Gender"] = <?php echo $litigants_list->Gender->Lookup->toClientList() ?>;
flitigantslist.lists["x_Gender"].options = <?php echo JsonEncode($litigants_list->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
var flitigantslistsrch = currentSearchForm = new ew.Form("flitigantslistsrch");

// Validate function for search
flitigantslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
flitigantslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flitigantslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flitigantslistsrch.lists["x_Gender"] = <?php echo $litigants_list->Gender->Lookup->toClientList() ?>;
flitigantslistsrch.lists["x_Gender"].options = <?php echo JsonEncode($litigants_list->Gender->options(FALSE, TRUE)) ?>;

// Filters
flitigantslistsrch.filterList = <?php echo $litigants_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #F0F8FF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$litigants->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($litigants_list->TotalRecs > 0 && $litigants_list->ExportOptions->visible()) { ?>
<?php $litigants_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($litigants_list->ImportOptions->visible()) { ?>
<?php $litigants_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($litigants_list->SearchOptions->visible()) { ?>
<?php $litigants_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($litigants_list->FilterOptions->visible()) { ?>
<?php $litigants_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$litigants_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$litigants->isExport() && !$litigants->CurrentAction) { ?>
<form name="flitigantslistsrch" id="flitigantslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($litigants_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="flitigantslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="litigants">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$litigants_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$litigants->RowType = ROWTYPE_SEARCH;

// Render row
$litigants->resetAttributes();
$litigants_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($litigants->Gender->Visible) { // Gender ?>
	<div id="xsc_Gender" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $litigants->Gender->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Gender" id="z_Gender" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="litigants" data-field="x_Gender" data-value-separator="<?php echo $litigants->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $litigants->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $litigants->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($litigants_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($litigants_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $litigants_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($litigants_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($litigants_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($litigants_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($litigants_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $litigants_list->showPageHeader(); ?>
<?php
$litigants_list->showMessage();
?>
<?php if ($litigants_list->TotalRecs > 0 || $litigants->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($litigants_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> litigants">
<?php if (!$litigants->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$litigants->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($litigants_list->Pager)) $litigants_list->Pager = new PrevNextPager($litigants_list->StartRec, $litigants_list->DisplayRecs, $litigants_list->TotalRecs, $litigants_list->AutoHidePager) ?>
<?php if ($litigants_list->Pager->RecordCount > 0 && $litigants_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($litigants_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $litigants_list->pageUrl() ?>start=<?php echo $litigants_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($litigants_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $litigants_list->pageUrl() ?>start=<?php echo $litigants_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $litigants_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($litigants_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $litigants_list->pageUrl() ?>start=<?php echo $litigants_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($litigants_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $litigants_list->pageUrl() ?>start=<?php echo $litigants_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $litigants_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($litigants_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $litigants_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $litigants_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $litigants_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($litigants_list->TotalRecs > 0 && (!$litigants_list->AutoHidePageSizeSelector || $litigants_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="litigants">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($litigants_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($litigants_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($litigants_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($litigants_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($litigants_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($litigants_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($litigants_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($litigants_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($litigants_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($litigants->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $litigants_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="flitigantslist" id="flitigantslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($litigants_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $litigants_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="litigants">
<div id="gmp_litigants" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($litigants_list->TotalRecs > 0 || $litigants->isGridEdit()) { ?>
<table id="tbl_litigantslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$litigants_list->RowType = ROWTYPE_HEADER;

// Render list options
$litigants_list->renderListOptions();

// Render list options (header, left)
$litigants_list->ListOptions->render("header", "left");
?>
<?php if ($litigants->LitigantTypeID->Visible) { // LitigantTypeID ?>
	<?php if ($litigants->sortUrl($litigants->LitigantTypeID) == "") { ?>
		<th data-name="LitigantTypeID" class="<?php echo $litigants->LitigantTypeID->headerCellClass() ?>"><div id="elh_litigants_LitigantTypeID" class="litigants_LitigantTypeID"><div class="ew-table-header-caption"><?php echo $litigants->LitigantTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantTypeID" class="<?php echo $litigants->LitigantTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->LitigantTypeID) ?>',2);"><div id="elh_litigants_LitigantTypeID" class="litigants_LitigantTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->LitigantTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigants->LitigantTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->LitigantTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->LitigantGroupID->Visible) { // LitigantGroupID ?>
	<?php if ($litigants->sortUrl($litigants->LitigantGroupID) == "") { ?>
		<th data-name="LitigantGroupID" class="<?php echo $litigants->LitigantGroupID->headerCellClass() ?>"><div id="elh_litigants_LitigantGroupID" class="litigants_LitigantGroupID"><div class="ew-table-header-caption"><?php echo $litigants->LitigantGroupID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantGroupID" class="<?php echo $litigants->LitigantGroupID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->LitigantGroupID) ?>',2);"><div id="elh_litigants_LitigantGroupID" class="litigants_LitigantGroupID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->LitigantGroupID->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigants->LitigantGroupID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->LitigantGroupID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->WorkNature->Visible) { // WorkNature ?>
	<?php if ($litigants->sortUrl($litigants->WorkNature) == "") { ?>
		<th data-name="WorkNature" class="<?php echo $litigants->WorkNature->headerCellClass() ?>"><div id="elh_litigants_WorkNature" class="litigants_WorkNature"><div class="ew-table-header-caption"><?php echo $litigants->WorkNature->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="WorkNature" class="<?php echo $litigants->WorkNature->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->WorkNature) ?>',2);"><div id="elh_litigants_WorkNature" class="litigants_WorkNature">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->WorkNature->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigants->WorkNature->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->WorkNature->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->TitleID->Visible) { // TitleID ?>
	<?php if ($litigants->sortUrl($litigants->TitleID) == "") { ?>
		<th data-name="TitleID" class="<?php echo $litigants->TitleID->headerCellClass() ?>"><div id="elh_litigants_TitleID" class="litigants_TitleID"><div class="ew-table-header-caption"><?php echo $litigants->TitleID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TitleID" class="<?php echo $litigants->TitleID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->TitleID) ?>',2);"><div id="elh_litigants_TitleID" class="litigants_TitleID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->TitleID->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigants->TitleID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->TitleID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->FirstName->Visible) { // FirstName ?>
	<?php if ($litigants->sortUrl($litigants->FirstName) == "") { ?>
		<th data-name="FirstName" class="<?php echo $litigants->FirstName->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_litigants_FirstName" class="litigants_FirstName"><div class="ew-table-header-caption"><?php echo $litigants->FirstName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FirstName" class="<?php echo $litigants->FirstName->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->FirstName) ?>',2);"><div id="elh_litigants_FirstName" class="litigants_FirstName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->FirstName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigants->FirstName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->FirstName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->MiddleName->Visible) { // MiddleName ?>
	<?php if ($litigants->sortUrl($litigants->MiddleName) == "") { ?>
		<th data-name="MiddleName" class="<?php echo $litigants->MiddleName->headerCellClass() ?>"><div id="elh_litigants_MiddleName" class="litigants_MiddleName"><div class="ew-table-header-caption"><?php echo $litigants->MiddleName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MiddleName" class="<?php echo $litigants->MiddleName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->MiddleName) ?>',2);"><div id="elh_litigants_MiddleName" class="litigants_MiddleName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->MiddleName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigants->MiddleName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->MiddleName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->LastName->Visible) { // LastName ?>
	<?php if ($litigants->sortUrl($litigants->LastName) == "") { ?>
		<th data-name="LastName" class="<?php echo $litigants->LastName->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_litigants_LastName" class="litigants_LastName"><div class="ew-table-header-caption"><?php echo $litigants->LastName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LastName" class="<?php echo $litigants->LastName->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->LastName) ?>',2);"><div id="elh_litigants_LastName" class="litigants_LastName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->LastName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigants->LastName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->LastName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->PartnersName->Visible) { // PartnersName ?>
	<?php if ($litigants->sortUrl($litigants->PartnersName) == "") { ?>
		<th data-name="PartnersName" class="<?php echo $litigants->PartnersName->headerCellClass() ?>"><div id="elh_litigants_PartnersName" class="litigants_PartnersName"><div class="ew-table-header-caption"><?php echo $litigants->PartnersName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PartnersName" class="<?php echo $litigants->PartnersName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->PartnersName) ?>',2);"><div id="elh_litigants_PartnersName" class="litigants_PartnersName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->PartnersName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigants->PartnersName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->PartnersName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->CompanyName->Visible) { // CompanyName ?>
	<?php if ($litigants->sortUrl($litigants->CompanyName) == "") { ?>
		<th data-name="CompanyName" class="<?php echo $litigants->CompanyName->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_litigants_CompanyName" class="litigants_CompanyName"><div class="ew-table-header-caption"><?php echo $litigants->CompanyName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CompanyName" class="<?php echo $litigants->CompanyName->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->CompanyName) ?>',2);"><div id="elh_litigants_CompanyName" class="litigants_CompanyName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->CompanyName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigants->CompanyName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->CompanyName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->ContactPerson->Visible) { // ContactPerson ?>
	<?php if ($litigants->sortUrl($litigants->ContactPerson) == "") { ?>
		<th data-name="ContactPerson" class="<?php echo $litigants->ContactPerson->headerCellClass() ?>"><div id="elh_litigants_ContactPerson" class="litigants_ContactPerson"><div class="ew-table-header-caption"><?php echo $litigants->ContactPerson->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ContactPerson" class="<?php echo $litigants->ContactPerson->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->ContactPerson) ?>',2);"><div id="elh_litigants_ContactPerson" class="litigants_ContactPerson">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->ContactPerson->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigants->ContactPerson->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->ContactPerson->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->JobTitle->Visible) { // JobTitle ?>
	<?php if ($litigants->sortUrl($litigants->JobTitle) == "") { ?>
		<th data-name="JobTitle" class="<?php echo $litigants->JobTitle->headerCellClass() ?>"><div id="elh_litigants_JobTitle" class="litigants_JobTitle"><div class="ew-table-header-caption"><?php echo $litigants->JobTitle->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JobTitle" class="<?php echo $litigants->JobTitle->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->JobTitle) ?>',2);"><div id="elh_litigants_JobTitle" class="litigants_JobTitle">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->JobTitle->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigants->JobTitle->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->JobTitle->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->Photo->Visible) { // Photo ?>
	<?php if ($litigants->sortUrl($litigants->Photo) == "") { ?>
		<th data-name="Photo" class="<?php echo $litigants->Photo->headerCellClass() ?>"><div id="elh_litigants_Photo" class="litigants_Photo"><div class="ew-table-header-caption"><?php echo $litigants->Photo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Photo" class="<?php echo $litigants->Photo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->Photo) ?>',2);"><div id="elh_litigants_Photo" class="litigants_Photo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->Photo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigants->Photo->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->Photo->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->BirthDate->Visible) { // BirthDate ?>
	<?php if ($litigants->sortUrl($litigants->BirthDate) == "") { ?>
		<th data-name="BirthDate" class="<?php echo $litigants->BirthDate->headerCellClass() ?>"><div id="elh_litigants_BirthDate" class="litigants_BirthDate"><div class="ew-table-header-caption"><?php echo $litigants->BirthDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="BirthDate" class="<?php echo $litigants->BirthDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->BirthDate) ?>',2);"><div id="elh_litigants_BirthDate" class="litigants_BirthDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->BirthDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigants->BirthDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->BirthDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigants->Gender->Visible) { // Gender ?>
	<?php if ($litigants->sortUrl($litigants->Gender) == "") { ?>
		<th data-name="Gender" class="<?php echo $litigants->Gender->headerCellClass() ?>"><div id="elh_litigants_Gender" class="litigants_Gender"><div class="ew-table-header-caption"><?php echo $litigants->Gender->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Gender" class="<?php echo $litigants->Gender->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigants->SortUrl($litigants->Gender) ?>',2);"><div id="elh_litigants_Gender" class="litigants_Gender">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigants->Gender->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigants->Gender->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigants->Gender->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$litigants_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($litigants->ExportAll && $litigants->isExport()) {
	$litigants_list->StopRec = $litigants_list->TotalRecs;
} else {

	// Set the last record to display
	if ($litigants_list->TotalRecs > $litigants_list->StartRec + $litigants_list->DisplayRecs - 1)
		$litigants_list->StopRec = $litigants_list->StartRec + $litigants_list->DisplayRecs - 1;
	else
		$litigants_list->StopRec = $litigants_list->TotalRecs;
}
$litigants_list->RecCnt = $litigants_list->StartRec - 1;
if ($litigants_list->Recordset && !$litigants_list->Recordset->EOF) {
	$litigants_list->Recordset->moveFirst();
	$selectLimit = $litigants_list->UseSelectLimit;
	if (!$selectLimit && $litigants_list->StartRec > 1)
		$litigants_list->Recordset->move($litigants_list->StartRec - 1);
} elseif (!$litigants->AllowAddDeleteRow && $litigants_list->StopRec == 0) {
	$litigants_list->StopRec = $litigants->GridAddRowCount;
}

// Initialize aggregate
$litigants->RowType = ROWTYPE_AGGREGATEINIT;
$litigants->resetAttributes();
$litigants_list->renderRow();
while ($litigants_list->RecCnt < $litigants_list->StopRec) {
	$litigants_list->RecCnt++;
	if ($litigants_list->RecCnt >= $litigants_list->StartRec) {
		$litigants_list->RowCnt++;

		// Set up key count
		$litigants_list->KeyCount = $litigants_list->RowIndex;

		// Init row class and style
		$litigants->resetAttributes();
		$litigants->CssClass = "";
		if ($litigants->isGridAdd()) {
		} else {
			$litigants_list->loadRowValues($litigants_list->Recordset); // Load row values
		}
		$litigants->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$litigants->RowAttrs = array_merge($litigants->RowAttrs, array('data-rowindex'=>$litigants_list->RowCnt, 'id'=>'r' . $litigants_list->RowCnt . '_litigants', 'data-rowtype'=>$litigants->RowType));

		// Render row
		$litigants_list->renderRow();

		// Render list options
		$litigants_list->renderListOptions();
?>
	<tr<?php echo $litigants->rowAttributes() ?>>
<?php

// Render list options (body, left)
$litigants_list->ListOptions->render("body", "left", $litigants_list->RowCnt);
?>
	<?php if ($litigants->LitigantTypeID->Visible) { // LitigantTypeID ?>
		<td data-name="LitigantTypeID"<?php echo $litigants->LitigantTypeID->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_LitigantTypeID" class="litigants_LitigantTypeID">
<span<?php echo $litigants->LitigantTypeID->viewAttributes() ?>>
<?php echo $litigants->LitigantTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->LitigantGroupID->Visible) { // LitigantGroupID ?>
		<td data-name="LitigantGroupID"<?php echo $litigants->LitigantGroupID->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_LitigantGroupID" class="litigants_LitigantGroupID">
<span<?php echo $litigants->LitigantGroupID->viewAttributes() ?>>
<?php echo $litigants->LitigantGroupID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->WorkNature->Visible) { // WorkNature ?>
		<td data-name="WorkNature"<?php echo $litigants->WorkNature->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_WorkNature" class="litigants_WorkNature">
<span<?php echo $litigants->WorkNature->viewAttributes() ?>>
<?php echo $litigants->WorkNature->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->TitleID->Visible) { // TitleID ?>
		<td data-name="TitleID"<?php echo $litigants->TitleID->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_TitleID" class="litigants_TitleID">
<span<?php echo $litigants->TitleID->viewAttributes() ?>>
<?php echo $litigants->TitleID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->FirstName->Visible) { // FirstName ?>
		<td data-name="FirstName"<?php echo $litigants->FirstName->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_FirstName" class="litigants_FirstName">
<span<?php echo $litigants->FirstName->viewAttributes() ?>>
<?php echo $litigants->FirstName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->MiddleName->Visible) { // MiddleName ?>
		<td data-name="MiddleName"<?php echo $litigants->MiddleName->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_MiddleName" class="litigants_MiddleName">
<span<?php echo $litigants->MiddleName->viewAttributes() ?>>
<?php echo $litigants->MiddleName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->LastName->Visible) { // LastName ?>
		<td data-name="LastName"<?php echo $litigants->LastName->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_LastName" class="litigants_LastName">
<span<?php echo $litigants->LastName->viewAttributes() ?>>
<?php echo $litigants->LastName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->PartnersName->Visible) { // PartnersName ?>
		<td data-name="PartnersName"<?php echo $litigants->PartnersName->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_PartnersName" class="litigants_PartnersName">
<span<?php echo $litigants->PartnersName->viewAttributes() ?>>
<?php echo $litigants->PartnersName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->CompanyName->Visible) { // CompanyName ?>
		<td data-name="CompanyName"<?php echo $litigants->CompanyName->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_CompanyName" class="litigants_CompanyName">
<span<?php echo $litigants->CompanyName->viewAttributes() ?>>
<?php echo $litigants->CompanyName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->ContactPerson->Visible) { // ContactPerson ?>
		<td data-name="ContactPerson"<?php echo $litigants->ContactPerson->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_ContactPerson" class="litigants_ContactPerson">
<span<?php echo $litigants->ContactPerson->viewAttributes() ?>>
<?php echo $litigants->ContactPerson->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->JobTitle->Visible) { // JobTitle ?>
		<td data-name="JobTitle"<?php echo $litigants->JobTitle->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_JobTitle" class="litigants_JobTitle">
<span<?php echo $litigants->JobTitle->viewAttributes() ?>>
<?php echo $litigants->JobTitle->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->Photo->Visible) { // Photo ?>
		<td data-name="Photo"<?php echo $litigants->Photo->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_Photo" class="litigants_Photo">
<span>
<?php echo GetFileViewTag($litigants->Photo, $litigants->Photo->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->BirthDate->Visible) { // BirthDate ?>
		<td data-name="BirthDate"<?php echo $litigants->BirthDate->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_BirthDate" class="litigants_BirthDate">
<span<?php echo $litigants->BirthDate->viewAttributes() ?>>
<?php echo $litigants->BirthDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigants->Gender->Visible) { // Gender ?>
		<td data-name="Gender"<?php echo $litigants->Gender->cellAttributes() ?>>
<span id="el<?php echo $litigants_list->RowCnt ?>_litigants_Gender" class="litigants_Gender">
<span<?php echo $litigants->Gender->viewAttributes() ?>>
<?php echo $litigants->Gender->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$litigants_list->ListOptions->render("body", "right", $litigants_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$litigants->isGridAdd())
		$litigants_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$litigants->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($litigants_list->Recordset)
	$litigants_list->Recordset->Close();
?>
<?php if (!$litigants->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$litigants->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($litigants_list->Pager)) $litigants_list->Pager = new PrevNextPager($litigants_list->StartRec, $litigants_list->DisplayRecs, $litigants_list->TotalRecs, $litigants_list->AutoHidePager) ?>
<?php if ($litigants_list->Pager->RecordCount > 0 && $litigants_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($litigants_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $litigants_list->pageUrl() ?>start=<?php echo $litigants_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($litigants_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $litigants_list->pageUrl() ?>start=<?php echo $litigants_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $litigants_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($litigants_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $litigants_list->pageUrl() ?>start=<?php echo $litigants_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($litigants_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $litigants_list->pageUrl() ?>start=<?php echo $litigants_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $litigants_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($litigants_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $litigants_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $litigants_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $litigants_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($litigants_list->TotalRecs > 0 && (!$litigants_list->AutoHidePageSizeSelector || $litigants_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="litigants">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($litigants_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($litigants_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($litigants_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($litigants_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($litigants_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($litigants_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($litigants_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($litigants_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($litigants_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($litigants->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $litigants_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($litigants_list->TotalRecs == 0 && !$litigants->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $litigants_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$litigants_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$litigants->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$litigants->isExport()) { ?>
<script>
ew.scrollableTable("gmp_litigants", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$litigants_list->terminate();
?>
