<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$litigants_add = new litigants_add();

// Run the page
$litigants_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$litigants_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var flitigantsadd = currentForm = new ew.Form("flitigantsadd", "add");

// Validate form
flitigantsadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($litigants_add->LitigantTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->LitigantTypeID->caption(), $litigants->LitigantTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->LitigantGroupID->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantGroupID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->LitigantGroupID->caption(), $litigants->LitigantGroupID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->WorkNature->Required) { ?>
			elm = this.getElements("x" + infix + "_WorkNature");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->WorkNature->caption(), $litigants->WorkNature->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->TitleID->Required) { ?>
			elm = this.getElements("x" + infix + "_TitleID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->TitleID->caption(), $litigants->TitleID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->FirstName->Required) { ?>
			elm = this.getElements("x" + infix + "_FirstName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->FirstName->caption(), $litigants->FirstName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->MiddleName->Required) { ?>
			elm = this.getElements("x" + infix + "_MiddleName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->MiddleName->caption(), $litigants->MiddleName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->LastName->Required) { ?>
			elm = this.getElements("x" + infix + "_LastName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->LastName->caption(), $litigants->LastName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->PartnersName->Required) { ?>
			elm = this.getElements("x" + infix + "_PartnersName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->PartnersName->caption(), $litigants->PartnersName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->CompanyName->Required) { ?>
			elm = this.getElements("x" + infix + "_CompanyName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->CompanyName->caption(), $litigants->CompanyName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->ContactPerson->Required) { ?>
			elm = this.getElements("x" + infix + "_ContactPerson");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->ContactPerson->caption(), $litigants->ContactPerson->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->JobTitle->Required) { ?>
			elm = this.getElements("x" + infix + "_JobTitle");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->JobTitle->caption(), $litigants->JobTitle->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->Photo->Required) { ?>
			felm = this.getElements("x" + infix + "_Photo");
			elm = this.getElements("fn_x" + infix + "_Photo");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $litigants->Photo->caption(), $litigants->Photo->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->BirthDate->Required) { ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->BirthDate->caption(), $litigants->BirthDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_BirthDate");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($litigants->BirthDate->errorMessage()) ?>");
		<?php if ($litigants_add->Gender->Required) { ?>
			elm = this.getElements("x" + infix + "_Gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->Gender->caption(), $litigants->Gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($litigants_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $litigants->Notes->caption(), $litigants->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
flitigantsadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flitigantsadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flitigantsadd.lists["x_LitigantTypeID"] = <?php echo $litigants_add->LitigantTypeID->Lookup->toClientList() ?>;
flitigantsadd.lists["x_LitigantTypeID"].options = <?php echo JsonEncode($litigants_add->LitigantTypeID->lookupOptions()) ?>;
flitigantsadd.lists["x_LitigantGroupID"] = <?php echo $litigants_add->LitigantGroupID->Lookup->toClientList() ?>;
flitigantsadd.lists["x_LitigantGroupID"].options = <?php echo JsonEncode($litigants_add->LitigantGroupID->lookupOptions()) ?>;
flitigantsadd.autoSuggests["x_LitigantGroupID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
flitigantsadd.lists["x_TitleID"] = <?php echo $litigants_add->TitleID->Lookup->toClientList() ?>;
flitigantsadd.lists["x_TitleID"].options = <?php echo JsonEncode($litigants_add->TitleID->lookupOptions()) ?>;
flitigantsadd.lists["x_Gender"] = <?php echo $litigants_add->Gender->Lookup->toClientList() ?>;
flitigantsadd.lists["x_Gender"].options = <?php echo JsonEncode($litigants_add->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $litigants_add->showPageHeader(); ?>
<?php
$litigants_add->showMessage();
?>
<form name="flitigantsadd" id="flitigantsadd" class="<?php echo $litigants_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($litigants_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $litigants_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="litigants">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$litigants_add->IsModal ?>">
<?php if (!$litigants_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_litigantsadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($litigants->LitigantTypeID->Visible) { // LitigantTypeID ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_LitigantTypeID" class="form-group row">
		<label id="elh_litigants_LitigantTypeID" for="x_LitigantTypeID" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->LitigantTypeID->caption() ?><?php echo ($litigants->LitigantTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->LitigantTypeID->cellAttributes() ?>>
<span id="el_litigants_LitigantTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="litigants" data-field="x_LitigantTypeID" data-value-separator="<?php echo $litigants->LitigantTypeID->displayValueSeparatorAttribute() ?>" id="x_LitigantTypeID" name="x_LitigantTypeID"<?php echo $litigants->LitigantTypeID->editAttributes() ?>>
		<?php echo $litigants->LitigantTypeID->selectOptionListHtml("x_LitigantTypeID") ?>
	</select>
</div>
<?php echo $litigants->LitigantTypeID->Lookup->getParamTag("p_x_LitigantTypeID") ?>
</span>
<?php echo $litigants->LitigantTypeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LitigantTypeID">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_LitigantTypeID"><?php echo $litigants->LitigantTypeID->caption() ?><?php echo ($litigants->LitigantTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->LitigantTypeID->cellAttributes() ?>>
<span id="el_litigants_LitigantTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="litigants" data-field="x_LitigantTypeID" data-value-separator="<?php echo $litigants->LitigantTypeID->displayValueSeparatorAttribute() ?>" id="x_LitigantTypeID" name="x_LitigantTypeID"<?php echo $litigants->LitigantTypeID->editAttributes() ?>>
		<?php echo $litigants->LitigantTypeID->selectOptionListHtml("x_LitigantTypeID") ?>
	</select>
</div>
<?php echo $litigants->LitigantTypeID->Lookup->getParamTag("p_x_LitigantTypeID") ?>
</span>
<?php echo $litigants->LitigantTypeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->LitigantGroupID->Visible) { // LitigantGroupID ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_LitigantGroupID" class="form-group row">
		<label id="elh_litigants_LitigantGroupID" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->LitigantGroupID->caption() ?><?php echo ($litigants->LitigantGroupID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->LitigantGroupID->cellAttributes() ?>>
<span id="el_litigants_LitigantGroupID">
<?php
$wrkonchange = "" . trim(@$litigants->LitigantGroupID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$litigants->LitigantGroupID->EditAttrs["onchange"] = "";
?>
<span id="as_x_LitigantGroupID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_LitigantGroupID" id="sv_x_LitigantGroupID" value="<?php echo RemoveHtml($litigants->LitigantGroupID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($litigants->LitigantGroupID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($litigants->LitigantGroupID->getPlaceHolder()) ?>"<?php echo $litigants->LitigantGroupID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($litigants->LitigantGroupID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_LitigantGroupID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($litigants->LitigantGroupID->ReadOnly || $litigants->LitigantGroupID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "litigants") && !$litigants->LitigantGroupID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LitigantGroupID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $litigants->LitigantGroupID->caption() ?>" data-title="<?php echo $litigants->LitigantGroupID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LitigantGroupID',url:'litigantsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="litigants" data-field="x_LitigantGroupID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $litigants->LitigantGroupID->displayValueSeparatorAttribute() ?>" name="x_LitigantGroupID" id="x_LitigantGroupID" value="<?php echo HtmlEncode($litigants->LitigantGroupID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
flitigantsadd.createAutoSuggest({"id":"x_LitigantGroupID","forceSelect":true});
</script>
<?php echo $litigants->LitigantGroupID->Lookup->getParamTag("p_x_LitigantGroupID") ?>
</span>
<?php echo $litigants->LitigantGroupID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LitigantGroupID">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_LitigantGroupID"><?php echo $litigants->LitigantGroupID->caption() ?><?php echo ($litigants->LitigantGroupID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->LitigantGroupID->cellAttributes() ?>>
<span id="el_litigants_LitigantGroupID">
<?php
$wrkonchange = "" . trim(@$litigants->LitigantGroupID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$litigants->LitigantGroupID->EditAttrs["onchange"] = "";
?>
<span id="as_x_LitigantGroupID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_LitigantGroupID" id="sv_x_LitigantGroupID" value="<?php echo RemoveHtml($litigants->LitigantGroupID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($litigants->LitigantGroupID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($litigants->LitigantGroupID->getPlaceHolder()) ?>"<?php echo $litigants->LitigantGroupID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($litigants->LitigantGroupID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_LitigantGroupID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($litigants->LitigantGroupID->ReadOnly || $litigants->LitigantGroupID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "litigants") && !$litigants->LitigantGroupID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LitigantGroupID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $litigants->LitigantGroupID->caption() ?>" data-title="<?php echo $litigants->LitigantGroupID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LitigantGroupID',url:'litigantsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="litigants" data-field="x_LitigantGroupID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $litigants->LitigantGroupID->displayValueSeparatorAttribute() ?>" name="x_LitigantGroupID" id="x_LitigantGroupID" value="<?php echo HtmlEncode($litigants->LitigantGroupID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
flitigantsadd.createAutoSuggest({"id":"x_LitigantGroupID","forceSelect":true});
</script>
<?php echo $litigants->LitigantGroupID->Lookup->getParamTag("p_x_LitigantGroupID") ?>
</span>
<?php echo $litigants->LitigantGroupID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->WorkNature->Visible) { // WorkNature ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_WorkNature" class="form-group row">
		<label id="elh_litigants_WorkNature" for="x_WorkNature" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->WorkNature->caption() ?><?php echo ($litigants->WorkNature->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->WorkNature->cellAttributes() ?>>
<span id="el_litigants_WorkNature">
<input type="text" data-table="litigants" data-field="x_WorkNature" name="x_WorkNature" id="x_WorkNature" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigants->WorkNature->getPlaceHolder()) ?>" value="<?php echo $litigants->WorkNature->EditValue ?>"<?php echo $litigants->WorkNature->editAttributes() ?>>
</span>
<?php echo $litigants->WorkNature->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_WorkNature">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_WorkNature"><?php echo $litigants->WorkNature->caption() ?><?php echo ($litigants->WorkNature->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->WorkNature->cellAttributes() ?>>
<span id="el_litigants_WorkNature">
<input type="text" data-table="litigants" data-field="x_WorkNature" name="x_WorkNature" id="x_WorkNature" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigants->WorkNature->getPlaceHolder()) ?>" value="<?php echo $litigants->WorkNature->EditValue ?>"<?php echo $litigants->WorkNature->editAttributes() ?>>
</span>
<?php echo $litigants->WorkNature->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->TitleID->Visible) { // TitleID ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_TitleID" class="form-group row">
		<label id="elh_litigants_TitleID" for="x_TitleID" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->TitleID->caption() ?><?php echo ($litigants->TitleID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->TitleID->cellAttributes() ?>>
<span id="el_litigants_TitleID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="litigants" data-field="x_TitleID" data-value-separator="<?php echo $litigants->TitleID->displayValueSeparatorAttribute() ?>" id="x_TitleID" name="x_TitleID"<?php echo $litigants->TitleID->editAttributes() ?>>
		<?php echo $litigants->TitleID->selectOptionListHtml("x_TitleID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "titles") && !$litigants->TitleID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_TitleID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $litigants->TitleID->caption() ?>" data-title="<?php echo $litigants->TitleID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_TitleID',url:'titlesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $litigants->TitleID->Lookup->getParamTag("p_x_TitleID") ?>
</span>
<?php echo $litigants->TitleID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_TitleID">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_TitleID"><?php echo $litigants->TitleID->caption() ?><?php echo ($litigants->TitleID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->TitleID->cellAttributes() ?>>
<span id="el_litigants_TitleID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="litigants" data-field="x_TitleID" data-value-separator="<?php echo $litigants->TitleID->displayValueSeparatorAttribute() ?>" id="x_TitleID" name="x_TitleID"<?php echo $litigants->TitleID->editAttributes() ?>>
		<?php echo $litigants->TitleID->selectOptionListHtml("x_TitleID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "titles") && !$litigants->TitleID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_TitleID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $litigants->TitleID->caption() ?>" data-title="<?php echo $litigants->TitleID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_TitleID',url:'titlesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $litigants->TitleID->Lookup->getParamTag("p_x_TitleID") ?>
</span>
<?php echo $litigants->TitleID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->FirstName->Visible) { // FirstName ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_FirstName" class="form-group row">
		<label id="elh_litigants_FirstName" for="x_FirstName" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->FirstName->caption() ?><?php echo ($litigants->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->FirstName->cellAttributes() ?>>
<span id="el_litigants_FirstName">
<input type="text" data-table="litigants" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigants->FirstName->getPlaceHolder()) ?>" value="<?php echo $litigants->FirstName->EditValue ?>"<?php echo $litigants->FirstName->editAttributes() ?>>
</span>
<?php echo $litigants->FirstName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_FirstName">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_FirstName"><?php echo $litigants->FirstName->caption() ?><?php echo ($litigants->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->FirstName->cellAttributes() ?>>
<span id="el_litigants_FirstName">
<input type="text" data-table="litigants" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigants->FirstName->getPlaceHolder()) ?>" value="<?php echo $litigants->FirstName->EditValue ?>"<?php echo $litigants->FirstName->editAttributes() ?>>
</span>
<?php echo $litigants->FirstName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->MiddleName->Visible) { // MiddleName ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_MiddleName" class="form-group row">
		<label id="elh_litigants_MiddleName" for="x_MiddleName" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->MiddleName->caption() ?><?php echo ($litigants->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->MiddleName->cellAttributes() ?>>
<span id="el_litigants_MiddleName">
<input type="text" data-table="litigants" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($litigants->MiddleName->getPlaceHolder()) ?>" value="<?php echo $litigants->MiddleName->EditValue ?>"<?php echo $litigants->MiddleName->editAttributes() ?>>
</span>
<?php echo $litigants->MiddleName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_MiddleName"><?php echo $litigants->MiddleName->caption() ?><?php echo ($litigants->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->MiddleName->cellAttributes() ?>>
<span id="el_litigants_MiddleName">
<input type="text" data-table="litigants" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($litigants->MiddleName->getPlaceHolder()) ?>" value="<?php echo $litigants->MiddleName->EditValue ?>"<?php echo $litigants->MiddleName->editAttributes() ?>>
</span>
<?php echo $litigants->MiddleName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->LastName->Visible) { // LastName ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_LastName" class="form-group row">
		<label id="elh_litigants_LastName" for="x_LastName" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->LastName->caption() ?><?php echo ($litigants->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->LastName->cellAttributes() ?>>
<span id="el_litigants_LastName">
<input type="text" data-table="litigants" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigants->LastName->getPlaceHolder()) ?>" value="<?php echo $litigants->LastName->EditValue ?>"<?php echo $litigants->LastName->editAttributes() ?>>
</span>
<?php echo $litigants->LastName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LastName">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_LastName"><?php echo $litigants->LastName->caption() ?><?php echo ($litigants->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->LastName->cellAttributes() ?>>
<span id="el_litigants_LastName">
<input type="text" data-table="litigants" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigants->LastName->getPlaceHolder()) ?>" value="<?php echo $litigants->LastName->EditValue ?>"<?php echo $litigants->LastName->editAttributes() ?>>
</span>
<?php echo $litigants->LastName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->PartnersName->Visible) { // PartnersName ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_PartnersName" class="form-group row">
		<label id="elh_litigants_PartnersName" for="x_PartnersName" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->PartnersName->caption() ?><?php echo ($litigants->PartnersName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->PartnersName->cellAttributes() ?>>
<span id="el_litigants_PartnersName">
<input type="text" data-table="litigants" data-field="x_PartnersName" name="x_PartnersName" id="x_PartnersName" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($litigants->PartnersName->getPlaceHolder()) ?>" value="<?php echo $litigants->PartnersName->EditValue ?>"<?php echo $litigants->PartnersName->editAttributes() ?>>
</span>
<?php echo $litigants->PartnersName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_PartnersName">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_PartnersName"><?php echo $litigants->PartnersName->caption() ?><?php echo ($litigants->PartnersName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->PartnersName->cellAttributes() ?>>
<span id="el_litigants_PartnersName">
<input type="text" data-table="litigants" data-field="x_PartnersName" name="x_PartnersName" id="x_PartnersName" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($litigants->PartnersName->getPlaceHolder()) ?>" value="<?php echo $litigants->PartnersName->EditValue ?>"<?php echo $litigants->PartnersName->editAttributes() ?>>
</span>
<?php echo $litigants->PartnersName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->CompanyName->Visible) { // CompanyName ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_CompanyName" class="form-group row">
		<label id="elh_litigants_CompanyName" for="x_CompanyName" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->CompanyName->caption() ?><?php echo ($litigants->CompanyName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->CompanyName->cellAttributes() ?>>
<span id="el_litigants_CompanyName">
<input type="text" data-table="litigants" data-field="x_CompanyName" name="x_CompanyName" id="x_CompanyName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigants->CompanyName->getPlaceHolder()) ?>" value="<?php echo $litigants->CompanyName->EditValue ?>"<?php echo $litigants->CompanyName->editAttributes() ?>>
</span>
<?php echo $litigants->CompanyName->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CompanyName">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_CompanyName"><?php echo $litigants->CompanyName->caption() ?><?php echo ($litigants->CompanyName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->CompanyName->cellAttributes() ?>>
<span id="el_litigants_CompanyName">
<input type="text" data-table="litigants" data-field="x_CompanyName" name="x_CompanyName" id="x_CompanyName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigants->CompanyName->getPlaceHolder()) ?>" value="<?php echo $litigants->CompanyName->EditValue ?>"<?php echo $litigants->CompanyName->editAttributes() ?>>
</span>
<?php echo $litigants->CompanyName->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->ContactPerson->Visible) { // ContactPerson ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_ContactPerson" class="form-group row">
		<label id="elh_litigants_ContactPerson" for="x_ContactPerson" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->ContactPerson->caption() ?><?php echo ($litigants->ContactPerson->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->ContactPerson->cellAttributes() ?>>
<span id="el_litigants_ContactPerson">
<input type="text" data-table="litigants" data-field="x_ContactPerson" name="x_ContactPerson" id="x_ContactPerson" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigants->ContactPerson->getPlaceHolder()) ?>" value="<?php echo $litigants->ContactPerson->EditValue ?>"<?php echo $litigants->ContactPerson->editAttributes() ?>>
</span>
<?php echo $litigants->ContactPerson->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ContactPerson">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_ContactPerson"><?php echo $litigants->ContactPerson->caption() ?><?php echo ($litigants->ContactPerson->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->ContactPerson->cellAttributes() ?>>
<span id="el_litigants_ContactPerson">
<input type="text" data-table="litigants" data-field="x_ContactPerson" name="x_ContactPerson" id="x_ContactPerson" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($litigants->ContactPerson->getPlaceHolder()) ?>" value="<?php echo $litigants->ContactPerson->EditValue ?>"<?php echo $litigants->ContactPerson->editAttributes() ?>>
</span>
<?php echo $litigants->ContactPerson->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->JobTitle->Visible) { // JobTitle ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_JobTitle" class="form-group row">
		<label id="elh_litigants_JobTitle" for="x_JobTitle" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->JobTitle->caption() ?><?php echo ($litigants->JobTitle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->JobTitle->cellAttributes() ?>>
<span id="el_litigants_JobTitle">
<input type="text" data-table="litigants" data-field="x_JobTitle" name="x_JobTitle" id="x_JobTitle" size="30" maxlength="25" placeholder="<?php echo HtmlEncode($litigants->JobTitle->getPlaceHolder()) ?>" value="<?php echo $litigants->JobTitle->EditValue ?>"<?php echo $litigants->JobTitle->editAttributes() ?>>
</span>
<?php echo $litigants->JobTitle->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_JobTitle">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_JobTitle"><?php echo $litigants->JobTitle->caption() ?><?php echo ($litigants->JobTitle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->JobTitle->cellAttributes() ?>>
<span id="el_litigants_JobTitle">
<input type="text" data-table="litigants" data-field="x_JobTitle" name="x_JobTitle" id="x_JobTitle" size="30" maxlength="25" placeholder="<?php echo HtmlEncode($litigants->JobTitle->getPlaceHolder()) ?>" value="<?php echo $litigants->JobTitle->EditValue ?>"<?php echo $litigants->JobTitle->editAttributes() ?>>
</span>
<?php echo $litigants->JobTitle->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->Photo->Visible) { // Photo ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_Photo" class="form-group row">
		<label id="elh_litigants_Photo" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->Photo->caption() ?><?php echo ($litigants->Photo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->Photo->cellAttributes() ?>>
<span id="el_litigants_Photo">
<div id="fd_x_Photo">
<span title="<?php echo $litigants->Photo->title() ? $litigants->Photo->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($litigants->Photo->ReadOnly || $litigants->Photo->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="litigants" data-field="x_Photo" name="x_Photo" id="x_Photo"<?php echo $litigants->Photo->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_Photo" id= "fn_x_Photo" value="<?php echo $litigants->Photo->Upload->FileName ?>">
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="0">
<input type="hidden" name="fs_x_Photo" id= "fs_x_Photo" value="255">
<input type="hidden" name="fx_x_Photo" id= "fx_x_Photo" value="<?php echo $litigants->Photo->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_Photo" id= "fm_x_Photo" value="<?php echo $litigants->Photo->UploadMaxFileSize ?>">
</div>
<table id="ft_x_Photo" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $litigants->Photo->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Photo">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_Photo"><?php echo $litigants->Photo->caption() ?><?php echo ($litigants->Photo->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->Photo->cellAttributes() ?>>
<span id="el_litigants_Photo">
<div id="fd_x_Photo">
<span title="<?php echo $litigants->Photo->title() ? $litigants->Photo->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($litigants->Photo->ReadOnly || $litigants->Photo->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="litigants" data-field="x_Photo" name="x_Photo" id="x_Photo"<?php echo $litigants->Photo->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_Photo" id= "fn_x_Photo" value="<?php echo $litigants->Photo->Upload->FileName ?>">
<input type="hidden" name="fa_x_Photo" id= "fa_x_Photo" value="0">
<input type="hidden" name="fs_x_Photo" id= "fs_x_Photo" value="255">
<input type="hidden" name="fx_x_Photo" id= "fx_x_Photo" value="<?php echo $litigants->Photo->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_Photo" id= "fm_x_Photo" value="<?php echo $litigants->Photo->UploadMaxFileSize ?>">
</div>
<table id="ft_x_Photo" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $litigants->Photo->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->BirthDate->Visible) { // BirthDate ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_BirthDate" class="form-group row">
		<label id="elh_litigants_BirthDate" for="x_BirthDate" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->BirthDate->caption() ?><?php echo ($litigants->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->BirthDate->cellAttributes() ?>>
<span id="el_litigants_BirthDate">
<input type="text" data-table="litigants" data-field="x_BirthDate" data-format="2" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($litigants->BirthDate->getPlaceHolder()) ?>" value="<?php echo $litigants->BirthDate->EditValue ?>"<?php echo $litigants->BirthDate->editAttributes() ?>>
<?php if (!$litigants->BirthDate->ReadOnly && !$litigants->BirthDate->Disabled && !isset($litigants->BirthDate->EditAttrs["readonly"]) && !isset($litigants->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("flitigantsadd", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php echo $litigants->BirthDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_BirthDate">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_BirthDate"><?php echo $litigants->BirthDate->caption() ?><?php echo ($litigants->BirthDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->BirthDate->cellAttributes() ?>>
<span id="el_litigants_BirthDate">
<input type="text" data-table="litigants" data-field="x_BirthDate" data-format="2" name="x_BirthDate" id="x_BirthDate" placeholder="<?php echo HtmlEncode($litigants->BirthDate->getPlaceHolder()) ?>" value="<?php echo $litigants->BirthDate->EditValue ?>"<?php echo $litigants->BirthDate->editAttributes() ?>>
<?php if (!$litigants->BirthDate->ReadOnly && !$litigants->BirthDate->Disabled && !isset($litigants->BirthDate->EditAttrs["readonly"]) && !isset($litigants->BirthDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("flitigantsadd", "x_BirthDate", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php echo $litigants->BirthDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->Gender->Visible) { // Gender ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_Gender" class="form-group row">
		<label id="elh_litigants_Gender" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->Gender->caption() ?><?php echo ($litigants->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->Gender->cellAttributes() ?>>
<span id="el_litigants_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="litigants" data-field="x_Gender" data-value-separator="<?php echo $litigants->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $litigants->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $litigants->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php echo $litigants->Gender->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Gender">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_Gender"><?php echo $litigants->Gender->caption() ?><?php echo ($litigants->Gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->Gender->cellAttributes() ?>>
<span id="el_litigants_Gender">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="litigants" data-field="x_Gender" data-value-separator="<?php echo $litigants->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $litigants->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $litigants->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
<?php echo $litigants->Gender->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants->Notes->Visible) { // Notes ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_litigants_Notes" for="x_Notes" class="<?php echo $litigants_add->LeftColumnClass ?>"><?php echo $litigants->Notes->caption() ?><?php echo ($litigants->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $litigants_add->RightColumnClass ?>"><div<?php echo $litigants->Notes->cellAttributes() ?>>
<span id="el_litigants_Notes">
<textarea data-table="litigants" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($litigants->Notes->getPlaceHolder()) ?>"<?php echo $litigants->Notes->editAttributes() ?>><?php echo $litigants->Notes->EditValue ?></textarea>
</span>
<?php echo $litigants->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $litigants_add->TableLeftColumnClass ?>"><span id="elh_litigants_Notes"><?php echo $litigants->Notes->caption() ?><?php echo ($litigants->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $litigants->Notes->cellAttributes() ?>>
<span id="el_litigants_Notes">
<textarea data-table="litigants" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($litigants->Notes->getPlaceHolder()) ?>"<?php echo $litigants->Notes->editAttributes() ?>><?php echo $litigants->Notes->EditValue ?></textarea>
</span>
<?php echo $litigants->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($litigants_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if ($litigants->getCurrentDetailTable() <> "") { ?>
<?php
	$litigants_add->DetailPages->ValidKeys = explode(",", $litigants->getCurrentDetailTable());
	$firstActiveDetailTable = $litigants_add->DetailPages->activePageIndex();
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav-tabs" id="litigants_add_details"><!-- tabs -->
	<ul class="<?php echo $litigants_add->DetailPages->navStyle() ?>"><!-- .nav -->
<?php
	if (in_array("cases", explode(",", $litigants->getCurrentDetailTable())) && $cases->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "cases") {
			$firstActiveDetailTable = "cases";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $litigants_add->DetailPages->pageStyle("cases") ?>" href="#tab_cases" data-toggle="tab"><?php echo $Language->TablePhrase("cases", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("litigantcontact", explode(",", $litigants->getCurrentDetailTable())) && $litigantcontact->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "litigantcontact") {
			$firstActiveDetailTable = "litigantcontact";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $litigants_add->DetailPages->pageStyle("litigantcontact") ?>" href="#tab_litigantcontact" data-toggle="tab"><?php echo $Language->TablePhrase("litigantcontact", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("litigantaddress", explode(",", $litigants->getCurrentDetailTable())) && $litigantaddress->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "litigantaddress") {
			$firstActiveDetailTable = "litigantaddress";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $litigants_add->DetailPages->pageStyle("litigantaddress") ?>" href="#tab_litigantaddress" data-toggle="tab"><?php echo $Language->TablePhrase("litigantaddress", "TblCaption") ?></a></li>
<?php
	}
?>
	</ul><!-- /.nav -->
	<div class="tab-content"><!-- .tab-content -->
<?php
	if (in_array("cases", explode(",", $litigants->getCurrentDetailTable())) && $cases->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "cases")
			$firstActiveDetailTable = "cases";
?>
		<div class="tab-pane<?php echo $litigants_add->DetailPages->pageStyle("cases") ?>" id="tab_cases"><!-- page* -->
<?php include_once "casesgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("litigantcontact", explode(",", $litigants->getCurrentDetailTable())) && $litigantcontact->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "litigantcontact")
			$firstActiveDetailTable = "litigantcontact";
?>
		<div class="tab-pane<?php echo $litigants_add->DetailPages->pageStyle("litigantcontact") ?>" id="tab_litigantcontact"><!-- page* -->
<?php include_once "litigantcontactgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("litigantaddress", explode(",", $litigants->getCurrentDetailTable())) && $litigantaddress->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "litigantaddress")
			$firstActiveDetailTable = "litigantaddress";
?>
		<div class="tab-pane<?php echo $litigants_add->DetailPages->pageStyle("litigantaddress") ?>" id="tab_litigantaddress"><!-- page* -->
<?php include_once "litigantaddressgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
	</div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
<?php if (!$litigants_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $litigants_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $litigants_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$litigants_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$litigants_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$litigants_add->terminate();
?>
