<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$litigantaddress_list = new litigantaddress_list();

// Run the page
$litigantaddress_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$litigantaddress_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$litigantaddress->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var flitigantaddresslist = currentForm = new ew.Form("flitigantaddresslist", "list");
flitigantaddresslist.formKeyCountName = '<?php echo $litigantaddress_list->FormKeyCountName ?>';

// Form_CustomValidate event
flitigantaddresslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flitigantaddresslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flitigantaddresslist.lists["x_LitigantID"] = <?php echo $litigantaddress_list->LitigantID->Lookup->toClientList() ?>;
flitigantaddresslist.lists["x_LitigantID"].options = <?php echo JsonEncode($litigantaddress_list->LitigantID->lookupOptions()) ?>;
flitigantaddresslist.lists["x_AddressTypeID"] = <?php echo $litigantaddress_list->AddressTypeID->Lookup->toClientList() ?>;
flitigantaddresslist.lists["x_AddressTypeID"].options = <?php echo JsonEncode($litigantaddress_list->AddressTypeID->lookupOptions()) ?>;
flitigantaddresslist.lists["x_Primary[]"] = <?php echo $litigantaddress_list->Primary->Lookup->toClientList() ?>;
flitigantaddresslist.lists["x_Primary[]"].options = <?php echo JsonEncode($litigantaddress_list->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
var flitigantaddresslistsrch = currentSearchForm = new ew.Form("flitigantaddresslistsrch");

// Validate function for search
flitigantaddresslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
flitigantaddresslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flitigantaddresslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flitigantaddresslistsrch.lists["x_Primary[]"] = <?php echo $litigantaddress_list->Primary->Lookup->toClientList() ?>;
flitigantaddresslistsrch.lists["x_Primary[]"].options = <?php echo JsonEncode($litigantaddress_list->Primary->options(FALSE, TRUE)) ?>;

// Filters
flitigantaddresslistsrch.filterList = <?php echo $litigantaddress_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$litigantaddress->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($litigantaddress_list->TotalRecs > 0 && $litigantaddress_list->ExportOptions->visible()) { ?>
<?php $litigantaddress_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($litigantaddress_list->ImportOptions->visible()) { ?>
<?php $litigantaddress_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($litigantaddress_list->SearchOptions->visible()) { ?>
<?php $litigantaddress_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($litigantaddress_list->FilterOptions->visible()) { ?>
<?php $litigantaddress_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$litigantaddress->isExport() || EXPORT_MASTER_RECORD && $litigantaddress->isExport("print")) { ?>
<?php
if ($litigantaddress_list->DbMasterFilter <> "" && $litigantaddress->getCurrentMasterTable() == "litigants") {
	if ($litigantaddress_list->MasterRecordExists) {
		include_once "litigantsmaster.php";
	}
}
?>
<?php } ?>
<?php
$litigantaddress_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$litigantaddress->isExport() && !$litigantaddress->CurrentAction) { ?>
<form name="flitigantaddresslistsrch" id="flitigantaddresslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($litigantaddress_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="flitigantaddresslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="litigantaddress">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$litigantaddress_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$litigantaddress->RowType = ROWTYPE_SEARCH;

// Render row
$litigantaddress->resetAttributes();
$litigantaddress_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($litigantaddress->Primary->Visible) { // Primary ?>
	<div id="xsc_Primary" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $litigantaddress->Primary->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Primary" id="z_Primary" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($litigantaddress->Primary->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="litigantaddress" data-field="x_Primary" name="x_Primary[]" id="x_Primary[]" value="1"<?php echo $selwrk ?><?php echo $litigantaddress->Primary->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($litigantaddress_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($litigantaddress_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $litigantaddress_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($litigantaddress_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($litigantaddress_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($litigantaddress_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($litigantaddress_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $litigantaddress_list->showPageHeader(); ?>
<?php
$litigantaddress_list->showMessage();
?>
<?php if ($litigantaddress_list->TotalRecs > 0 || $litigantaddress->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($litigantaddress_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> litigantaddress">
<?php if (!$litigantaddress->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$litigantaddress->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($litigantaddress_list->Pager)) $litigantaddress_list->Pager = new PrevNextPager($litigantaddress_list->StartRec, $litigantaddress_list->DisplayRecs, $litigantaddress_list->TotalRecs, $litigantaddress_list->AutoHidePager) ?>
<?php if ($litigantaddress_list->Pager->RecordCount > 0 && $litigantaddress_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($litigantaddress_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $litigantaddress_list->pageUrl() ?>start=<?php echo $litigantaddress_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($litigantaddress_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $litigantaddress_list->pageUrl() ?>start=<?php echo $litigantaddress_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $litigantaddress_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($litigantaddress_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $litigantaddress_list->pageUrl() ?>start=<?php echo $litigantaddress_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($litigantaddress_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $litigantaddress_list->pageUrl() ?>start=<?php echo $litigantaddress_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $litigantaddress_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($litigantaddress_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $litigantaddress_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $litigantaddress_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $litigantaddress_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($litigantaddress_list->TotalRecs > 0 && (!$litigantaddress_list->AutoHidePageSizeSelector || $litigantaddress_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="litigantaddress">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($litigantaddress_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($litigantaddress_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($litigantaddress_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($litigantaddress_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($litigantaddress_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($litigantaddress_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($litigantaddress_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($litigantaddress_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($litigantaddress_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($litigantaddress->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $litigantaddress_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="flitigantaddresslist" id="flitigantaddresslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($litigantaddress_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $litigantaddress_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="litigantaddress">
<?php if ($litigantaddress->getCurrentMasterTable() == "litigants" && $litigantaddress->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="litigants">
<input type="hidden" name="fk_LitigantID" value="<?php echo $litigantaddress->LitigantID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_litigantaddress" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($litigantaddress_list->TotalRecs > 0 || $litigantaddress->isGridEdit()) { ?>
<table id="tbl_litigantaddresslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$litigantaddress_list->RowType = ROWTYPE_HEADER;

// Render list options
$litigantaddress_list->renderListOptions();

// Render list options (header, left)
$litigantaddress_list->ListOptions->render("header", "left");
?>
<?php if ($litigantaddress->LitigantID->Visible) { // LitigantID ?>
	<?php if ($litigantaddress->sortUrl($litigantaddress->LitigantID) == "") { ?>
		<th data-name="LitigantID" class="<?php echo $litigantaddress->LitigantID->headerCellClass() ?>"><div id="elh_litigantaddress_LitigantID" class="litigantaddress_LitigantID"><div class="ew-table-header-caption"><?php echo $litigantaddress->LitigantID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantID" class="<?php echo $litigantaddress->LitigantID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigantaddress->SortUrl($litigantaddress->LitigantID) ?>',2);"><div id="elh_litigantaddress_LitigantID" class="litigantaddress_LitigantID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantaddress->LitigantID->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigantaddress->LitigantID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantaddress->LitigantID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantaddress->AddressTypeID->Visible) { // AddressTypeID ?>
	<?php if ($litigantaddress->sortUrl($litigantaddress->AddressTypeID) == "") { ?>
		<th data-name="AddressTypeID" class="<?php echo $litigantaddress->AddressTypeID->headerCellClass() ?>"><div id="elh_litigantaddress_AddressTypeID" class="litigantaddress_AddressTypeID"><div class="ew-table-header-caption"><?php echo $litigantaddress->AddressTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AddressTypeID" class="<?php echo $litigantaddress->AddressTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigantaddress->SortUrl($litigantaddress->AddressTypeID) ?>',2);"><div id="elh_litigantaddress_AddressTypeID" class="litigantaddress_AddressTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantaddress->AddressTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigantaddress->AddressTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantaddress->AddressTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantaddress->Address->Visible) { // Address ?>
	<?php if ($litigantaddress->sortUrl($litigantaddress->Address) == "") { ?>
		<th data-name="Address" class="<?php echo $litigantaddress->Address->headerCellClass() ?>"><div id="elh_litigantaddress_Address" class="litigantaddress_Address"><div class="ew-table-header-caption"><?php echo $litigantaddress->Address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Address" class="<?php echo $litigantaddress->Address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigantaddress->SortUrl($litigantaddress->Address) ?>',2);"><div id="elh_litigantaddress_Address" class="litigantaddress_Address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantaddress->Address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigantaddress->Address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantaddress->Address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantaddress->City->Visible) { // City ?>
	<?php if ($litigantaddress->sortUrl($litigantaddress->City) == "") { ?>
		<th data-name="City" class="<?php echo $litigantaddress->City->headerCellClass() ?>"><div id="elh_litigantaddress_City" class="litigantaddress_City"><div class="ew-table-header-caption"><?php echo $litigantaddress->City->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="City" class="<?php echo $litigantaddress->City->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigantaddress->SortUrl($litigantaddress->City) ?>',2);"><div id="elh_litigantaddress_City" class="litigantaddress_City">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantaddress->City->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigantaddress->City->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantaddress->City->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantaddress->Region->Visible) { // Region ?>
	<?php if ($litigantaddress->sortUrl($litigantaddress->Region) == "") { ?>
		<th data-name="Region" class="<?php echo $litigantaddress->Region->headerCellClass() ?>"><div id="elh_litigantaddress_Region" class="litigantaddress_Region"><div class="ew-table-header-caption"><?php echo $litigantaddress->Region->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Region" class="<?php echo $litigantaddress->Region->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigantaddress->SortUrl($litigantaddress->Region) ?>',2);"><div id="elh_litigantaddress_Region" class="litigantaddress_Region">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantaddress->Region->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigantaddress->Region->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantaddress->Region->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantaddress->PostalCode->Visible) { // PostalCode ?>
	<?php if ($litigantaddress->sortUrl($litigantaddress->PostalCode) == "") { ?>
		<th data-name="PostalCode" class="<?php echo $litigantaddress->PostalCode->headerCellClass() ?>"><div id="elh_litigantaddress_PostalCode" class="litigantaddress_PostalCode"><div class="ew-table-header-caption"><?php echo $litigantaddress->PostalCode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PostalCode" class="<?php echo $litigantaddress->PostalCode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigantaddress->SortUrl($litigantaddress->PostalCode) ?>',2);"><div id="elh_litigantaddress_PostalCode" class="litigantaddress_PostalCode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantaddress->PostalCode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigantaddress->PostalCode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantaddress->PostalCode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantaddress->Country->Visible) { // Country ?>
	<?php if ($litigantaddress->sortUrl($litigantaddress->Country) == "") { ?>
		<th data-name="Country" class="<?php echo $litigantaddress->Country->headerCellClass() ?>"><div id="elh_litigantaddress_Country" class="litigantaddress_Country"><div class="ew-table-header-caption"><?php echo $litigantaddress->Country->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Country" class="<?php echo $litigantaddress->Country->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigantaddress->SortUrl($litigantaddress->Country) ?>',2);"><div id="elh_litigantaddress_Country" class="litigantaddress_Country">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantaddress->Country->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigantaddress->Country->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantaddress->Country->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantaddress->Notes->Visible) { // Notes ?>
	<?php if ($litigantaddress->sortUrl($litigantaddress->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $litigantaddress->Notes->headerCellClass() ?>"><div id="elh_litigantaddress_Notes" class="litigantaddress_Notes"><div class="ew-table-header-caption"><?php echo $litigantaddress->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $litigantaddress->Notes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigantaddress->SortUrl($litigantaddress->Notes) ?>',2);"><div id="elh_litigantaddress_Notes" class="litigantaddress_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantaddress->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($litigantaddress->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantaddress->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($litigantaddress->Primary->Visible) { // Primary ?>
	<?php if ($litigantaddress->sortUrl($litigantaddress->Primary) == "") { ?>
		<th data-name="Primary" class="<?php echo $litigantaddress->Primary->headerCellClass() ?>"><div id="elh_litigantaddress_Primary" class="litigantaddress_Primary"><div class="ew-table-header-caption"><?php echo $litigantaddress->Primary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primary" class="<?php echo $litigantaddress->Primary->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $litigantaddress->SortUrl($litigantaddress->Primary) ?>',2);"><div id="elh_litigantaddress_Primary" class="litigantaddress_Primary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $litigantaddress->Primary->caption() ?></span><span class="ew-table-header-sort"><?php if ($litigantaddress->Primary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($litigantaddress->Primary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$litigantaddress_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($litigantaddress->ExportAll && $litigantaddress->isExport()) {
	$litigantaddress_list->StopRec = $litigantaddress_list->TotalRecs;
} else {

	// Set the last record to display
	if ($litigantaddress_list->TotalRecs > $litigantaddress_list->StartRec + $litigantaddress_list->DisplayRecs - 1)
		$litigantaddress_list->StopRec = $litigantaddress_list->StartRec + $litigantaddress_list->DisplayRecs - 1;
	else
		$litigantaddress_list->StopRec = $litigantaddress_list->TotalRecs;
}
$litigantaddress_list->RecCnt = $litigantaddress_list->StartRec - 1;
if ($litigantaddress_list->Recordset && !$litigantaddress_list->Recordset->EOF) {
	$litigantaddress_list->Recordset->moveFirst();
	$selectLimit = $litigantaddress_list->UseSelectLimit;
	if (!$selectLimit && $litigantaddress_list->StartRec > 1)
		$litigantaddress_list->Recordset->move($litigantaddress_list->StartRec - 1);
} elseif (!$litigantaddress->AllowAddDeleteRow && $litigantaddress_list->StopRec == 0) {
	$litigantaddress_list->StopRec = $litigantaddress->GridAddRowCount;
}

// Initialize aggregate
$litigantaddress->RowType = ROWTYPE_AGGREGATEINIT;
$litigantaddress->resetAttributes();
$litigantaddress_list->renderRow();
while ($litigantaddress_list->RecCnt < $litigantaddress_list->StopRec) {
	$litigantaddress_list->RecCnt++;
	if ($litigantaddress_list->RecCnt >= $litigantaddress_list->StartRec) {
		$litigantaddress_list->RowCnt++;

		// Set up key count
		$litigantaddress_list->KeyCount = $litigantaddress_list->RowIndex;

		// Init row class and style
		$litigantaddress->resetAttributes();
		$litigantaddress->CssClass = "";
		if ($litigantaddress->isGridAdd()) {
		} else {
			$litigantaddress_list->loadRowValues($litigantaddress_list->Recordset); // Load row values
		}
		$litigantaddress->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$litigantaddress->RowAttrs = array_merge($litigantaddress->RowAttrs, array('data-rowindex'=>$litigantaddress_list->RowCnt, 'id'=>'r' . $litigantaddress_list->RowCnt . '_litigantaddress', 'data-rowtype'=>$litigantaddress->RowType));

		// Render row
		$litigantaddress_list->renderRow();

		// Render list options
		$litigantaddress_list->renderListOptions();
?>
	<tr<?php echo $litigantaddress->rowAttributes() ?>>
<?php

// Render list options (body, left)
$litigantaddress_list->ListOptions->render("body", "left", $litigantaddress_list->RowCnt);
?>
	<?php if ($litigantaddress->LitigantID->Visible) { // LitigantID ?>
		<td data-name="LitigantID"<?php echo $litigantaddress->LitigantID->cellAttributes() ?>>
<span id="el<?php echo $litigantaddress_list->RowCnt ?>_litigantaddress_LitigantID" class="litigantaddress_LitigantID">
<span<?php echo $litigantaddress->LitigantID->viewAttributes() ?>>
<?php echo $litigantaddress->LitigantID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigantaddress->AddressTypeID->Visible) { // AddressTypeID ?>
		<td data-name="AddressTypeID"<?php echo $litigantaddress->AddressTypeID->cellAttributes() ?>>
<span id="el<?php echo $litigantaddress_list->RowCnt ?>_litigantaddress_AddressTypeID" class="litigantaddress_AddressTypeID">
<span<?php echo $litigantaddress->AddressTypeID->viewAttributes() ?>>
<?php echo $litigantaddress->AddressTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigantaddress->Address->Visible) { // Address ?>
		<td data-name="Address"<?php echo $litigantaddress->Address->cellAttributes() ?>>
<span id="el<?php echo $litigantaddress_list->RowCnt ?>_litigantaddress_Address" class="litigantaddress_Address">
<span<?php echo $litigantaddress->Address->viewAttributes() ?>>
<?php echo $litigantaddress->Address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigantaddress->City->Visible) { // City ?>
		<td data-name="City"<?php echo $litigantaddress->City->cellAttributes() ?>>
<span id="el<?php echo $litigantaddress_list->RowCnt ?>_litigantaddress_City" class="litigantaddress_City">
<span<?php echo $litigantaddress->City->viewAttributes() ?>>
<?php echo $litigantaddress->City->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigantaddress->Region->Visible) { // Region ?>
		<td data-name="Region"<?php echo $litigantaddress->Region->cellAttributes() ?>>
<span id="el<?php echo $litigantaddress_list->RowCnt ?>_litigantaddress_Region" class="litigantaddress_Region">
<span<?php echo $litigantaddress->Region->viewAttributes() ?>>
<?php echo $litigantaddress->Region->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigantaddress->PostalCode->Visible) { // PostalCode ?>
		<td data-name="PostalCode"<?php echo $litigantaddress->PostalCode->cellAttributes() ?>>
<span id="el<?php echo $litigantaddress_list->RowCnt ?>_litigantaddress_PostalCode" class="litigantaddress_PostalCode">
<span<?php echo $litigantaddress->PostalCode->viewAttributes() ?>>
<?php echo $litigantaddress->PostalCode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigantaddress->Country->Visible) { // Country ?>
		<td data-name="Country"<?php echo $litigantaddress->Country->cellAttributes() ?>>
<span id="el<?php echo $litigantaddress_list->RowCnt ?>_litigantaddress_Country" class="litigantaddress_Country">
<span<?php echo $litigantaddress->Country->viewAttributes() ?>>
<?php echo $litigantaddress->Country->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigantaddress->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $litigantaddress->Notes->cellAttributes() ?>>
<span id="el<?php echo $litigantaddress_list->RowCnt ?>_litigantaddress_Notes" class="litigantaddress_Notes">
<span<?php echo $litigantaddress->Notes->viewAttributes() ?>>
<?php echo $litigantaddress->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($litigantaddress->Primary->Visible) { // Primary ?>
		<td data-name="Primary"<?php echo $litigantaddress->Primary->cellAttributes() ?>>
<span id="el<?php echo $litigantaddress_list->RowCnt ?>_litigantaddress_Primary" class="litigantaddress_Primary">
<span<?php echo $litigantaddress->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($litigantaddress->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $litigantaddress->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $litigantaddress->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$litigantaddress_list->ListOptions->render("body", "right", $litigantaddress_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$litigantaddress->isGridAdd())
		$litigantaddress_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$litigantaddress->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($litigantaddress_list->Recordset)
	$litigantaddress_list->Recordset->Close();
?>
<?php if (!$litigantaddress->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$litigantaddress->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($litigantaddress_list->Pager)) $litigantaddress_list->Pager = new PrevNextPager($litigantaddress_list->StartRec, $litigantaddress_list->DisplayRecs, $litigantaddress_list->TotalRecs, $litigantaddress_list->AutoHidePager) ?>
<?php if ($litigantaddress_list->Pager->RecordCount > 0 && $litigantaddress_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($litigantaddress_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $litigantaddress_list->pageUrl() ?>start=<?php echo $litigantaddress_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($litigantaddress_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $litigantaddress_list->pageUrl() ?>start=<?php echo $litigantaddress_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $litigantaddress_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($litigantaddress_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $litigantaddress_list->pageUrl() ?>start=<?php echo $litigantaddress_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($litigantaddress_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $litigantaddress_list->pageUrl() ?>start=<?php echo $litigantaddress_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $litigantaddress_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($litigantaddress_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $litigantaddress_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $litigantaddress_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $litigantaddress_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($litigantaddress_list->TotalRecs > 0 && (!$litigantaddress_list->AutoHidePageSizeSelector || $litigantaddress_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="litigantaddress">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($litigantaddress_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($litigantaddress_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($litigantaddress_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($litigantaddress_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($litigantaddress_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($litigantaddress_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($litigantaddress_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($litigantaddress_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($litigantaddress_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($litigantaddress->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $litigantaddress_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($litigantaddress_list->TotalRecs == 0 && !$litigantaddress->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $litigantaddress_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$litigantaddress_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$litigantaddress->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$litigantaddress->isExport()) { ?>
<script>
ew.scrollableTable("gmp_litigantaddress", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$litigantaddress_list->terminate();
?>
