<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$lawyercontact_view = new lawyercontact_view();

// Run the page
$lawyercontact_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawyercontact_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$lawyercontact->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var flawyercontactview = currentForm = new ew.Form("flawyercontactview", "view");

// Form_CustomValidate event
flawyercontactview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyercontactview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawyercontactview.lists["x_LawyerID"] = <?php echo $lawyercontact_view->LawyerID->Lookup->toClientList() ?>;
flawyercontactview.lists["x_LawyerID"].options = <?php echo JsonEncode($lawyercontact_view->LawyerID->lookupOptions()) ?>;
flawyercontactview.lists["x_ContactTypeID"] = <?php echo $lawyercontact_view->ContactTypeID->Lookup->toClientList() ?>;
flawyercontactview.lists["x_ContactTypeID"].options = <?php echo JsonEncode($lawyercontact_view->ContactTypeID->lookupOptions()) ?>;
flawyercontactview.lists["x_Primary[]"] = <?php echo $lawyercontact_view->Primary->Lookup->toClientList() ?>;
flawyercontactview.lists["x_Primary[]"].options = <?php echo JsonEncode($lawyercontact_view->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$lawyercontact->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $lawyercontact_view->ExportOptions->render("body") ?>
<?php $lawyercontact_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $lawyercontact_view->showPageHeader(); ?>
<?php
$lawyercontact_view->showMessage();
?>
<?php if (!$lawyercontact_view->IsModal) { ?>
<?php if (!$lawyercontact->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($lawyercontact_view->Pager)) $lawyercontact_view->Pager = new PrevNextPager($lawyercontact_view->StartRec, $lawyercontact_view->DisplayRecs, $lawyercontact_view->TotalRecs, $lawyercontact_view->AutoHidePager) ?>
<?php if ($lawyercontact_view->Pager->RecordCount > 0 && $lawyercontact_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawyercontact_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawyercontact_view->pageUrl() ?>start=<?php echo $lawyercontact_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawyercontact_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawyercontact_view->pageUrl() ?>start=<?php echo $lawyercontact_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawyercontact_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawyercontact_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawyercontact_view->pageUrl() ?>start=<?php echo $lawyercontact_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawyercontact_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawyercontact_view->pageUrl() ?>start=<?php echo $lawyercontact_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawyercontact_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="flawyercontactview" id="flawyercontactview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($lawyercontact_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $lawyercontact_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="lawyercontact">
<input type="hidden" name="modal" value="<?php echo (int)$lawyercontact_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($lawyercontact->LawyerID->Visible) { // LawyerID ?>
	<tr id="r_LawyerID">
		<td class="<?php echo $lawyercontact_view->TableLeftColumnClass ?>"><span id="elh_lawyercontact_LawyerID"><?php echo $lawyercontact->LawyerID->caption() ?></span></td>
		<td data-name="LawyerID"<?php echo $lawyercontact->LawyerID->cellAttributes() ?>>
<span id="el_lawyercontact_LawyerID">
<span<?php echo $lawyercontact->LawyerID->viewAttributes() ?>>
<?php echo $lawyercontact->LawyerID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyercontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<tr id="r_ContactTypeID">
		<td class="<?php echo $lawyercontact_view->TableLeftColumnClass ?>"><span id="elh_lawyercontact_ContactTypeID"><?php echo $lawyercontact->ContactTypeID->caption() ?></span></td>
		<td data-name="ContactTypeID"<?php echo $lawyercontact->ContactTypeID->cellAttributes() ?>>
<span id="el_lawyercontact_ContactTypeID">
<span<?php echo $lawyercontact->ContactTypeID->viewAttributes() ?>>
<?php echo $lawyercontact->ContactTypeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyercontact->Contact->Visible) { // Contact ?>
	<tr id="r_Contact">
		<td class="<?php echo $lawyercontact_view->TableLeftColumnClass ?>"><span id="elh_lawyercontact_Contact"><?php echo $lawyercontact->Contact->caption() ?></span></td>
		<td data-name="Contact"<?php echo $lawyercontact->Contact->cellAttributes() ?>>
<span id="el_lawyercontact_Contact">
<span<?php echo $lawyercontact->Contact->viewAttributes() ?>>
<?php echo $lawyercontact->Contact->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyercontact->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $lawyercontact_view->TableLeftColumnClass ?>"><span id="elh_lawyercontact_Notes"><?php echo $lawyercontact->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $lawyercontact->Notes->cellAttributes() ?>>
<span id="el_lawyercontact_Notes">
<span<?php echo $lawyercontact->Notes->viewAttributes() ?>>
<?php echo $lawyercontact->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyercontact->Primary->Visible) { // Primary ?>
	<tr id="r_Primary">
		<td class="<?php echo $lawyercontact_view->TableLeftColumnClass ?>"><span id="elh_lawyercontact_Primary"><?php echo $lawyercontact->Primary->caption() ?></span></td>
		<td data-name="Primary"<?php echo $lawyercontact->Primary->cellAttributes() ?>>
<span id="el_lawyercontact_Primary">
<span<?php echo $lawyercontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($lawyercontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $lawyercontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $lawyercontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$lawyercontact_view->IsModal) { ?>
<?php if (!$lawyercontact->isExport()) { ?>
<?php if (!isset($lawyercontact_view->Pager)) $lawyercontact_view->Pager = new PrevNextPager($lawyercontact_view->StartRec, $lawyercontact_view->DisplayRecs, $lawyercontact_view->TotalRecs, $lawyercontact_view->AutoHidePager) ?>
<?php if ($lawyercontact_view->Pager->RecordCount > 0 && $lawyercontact_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawyercontact_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawyercontact_view->pageUrl() ?>start=<?php echo $lawyercontact_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawyercontact_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawyercontact_view->pageUrl() ?>start=<?php echo $lawyercontact_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawyercontact_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawyercontact_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawyercontact_view->pageUrl() ?>start=<?php echo $lawyercontact_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawyercontact_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawyercontact_view->pageUrl() ?>start=<?php echo $lawyercontact_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawyercontact_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$lawyercontact_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$lawyercontact->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$lawyercontact_view->terminate();
?>
