<?php
namespace PHPMaker2019\project_germanos;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($lawyercontact_grid))
	$lawyercontact_grid = new lawyercontact_grid();

// Run the page
$lawyercontact_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawyercontact_grid->Page_Render();
?>
<?php if (!$lawyercontact->isExport()) { ?>
<script>

// Form object
var flawyercontactgrid = new ew.Form("flawyercontactgrid", "grid");
flawyercontactgrid.formKeyCountName = '<?php echo $lawyercontact_grid->FormKeyCountName ?>';

// Validate form
flawyercontactgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($lawyercontact_grid->LawyerID->Required) { ?>
			elm = this.getElements("x" + infix + "_LawyerID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyercontact->LawyerID->caption(), $lawyercontact->LawyerID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyercontact_grid->ContactTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_ContactTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyercontact->ContactTypeID->caption(), $lawyercontact->ContactTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyercontact_grid->Contact->Required) { ?>
			elm = this.getElements("x" + infix + "_Contact");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyercontact->Contact->caption(), $lawyercontact->Contact->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyercontact_grid->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyercontact->Notes->caption(), $lawyercontact->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyercontact_grid->Primary->Required) { ?>
			elm = this.getElements("x" + infix + "_Primary[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyercontact->Primary->caption(), $lawyercontact->Primary->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
flawyercontactgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "LawyerID", false)) return false;
	if (ew.valueChanged(fobj, infix, "ContactTypeID", false)) return false;
	if (ew.valueChanged(fobj, infix, "Contact", false)) return false;
	if (ew.valueChanged(fobj, infix, "Notes", false)) return false;
	if (ew.valueChanged(fobj, infix, "Primary[]", true)) return false;
	return true;
}

// Form_CustomValidate event
flawyercontactgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyercontactgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawyercontactgrid.lists["x_LawyerID"] = <?php echo $lawyercontact_grid->LawyerID->Lookup->toClientList() ?>;
flawyercontactgrid.lists["x_LawyerID"].options = <?php echo JsonEncode($lawyercontact_grid->LawyerID->lookupOptions()) ?>;
flawyercontactgrid.lists["x_ContactTypeID"] = <?php echo $lawyercontact_grid->ContactTypeID->Lookup->toClientList() ?>;
flawyercontactgrid.lists["x_ContactTypeID"].options = <?php echo JsonEncode($lawyercontact_grid->ContactTypeID->lookupOptions()) ?>;
flawyercontactgrid.lists["x_Primary[]"] = <?php echo $lawyercontact_grid->Primary->Lookup->toClientList() ?>;
flawyercontactgrid.lists["x_Primary[]"].options = <?php echo JsonEncode($lawyercontact_grid->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$lawyercontact_grid->renderOtherOptions();
?>
<?php $lawyercontact_grid->showPageHeader(); ?>
<?php
$lawyercontact_grid->showMessage();
?>
<?php if ($lawyercontact_grid->TotalRecs > 0 || $lawyercontact->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($lawyercontact_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> lawyercontact">
<?php if ($lawyercontact_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $lawyercontact_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="flawyercontactgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_lawyercontact" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_lawyercontactgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$lawyercontact_grid->RowType = ROWTYPE_HEADER;

// Render list options
$lawyercontact_grid->renderListOptions();

// Render list options (header, left)
$lawyercontact_grid->ListOptions->render("header", "left");
?>
<?php if ($lawyercontact->LawyerID->Visible) { // LawyerID ?>
	<?php if ($lawyercontact->sortUrl($lawyercontact->LawyerID) == "") { ?>
		<th data-name="LawyerID" class="<?php echo $lawyercontact->LawyerID->headerCellClass() ?>"><div id="elh_lawyercontact_LawyerID" class="lawyercontact_LawyerID"><div class="ew-table-header-caption"><?php echo $lawyercontact->LawyerID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LawyerID" class="<?php echo $lawyercontact->LawyerID->headerCellClass() ?>"><div><div id="elh_lawyercontact_LawyerID" class="lawyercontact_LawyerID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyercontact->LawyerID->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyercontact->LawyerID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyercontact->LawyerID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($lawyercontact->sortUrl($lawyercontact->ContactTypeID) == "") { ?>
		<th data-name="ContactTypeID" class="<?php echo $lawyercontact->ContactTypeID->headerCellClass() ?>"><div id="elh_lawyercontact_ContactTypeID" class="lawyercontact_ContactTypeID"><div class="ew-table-header-caption"><?php echo $lawyercontact->ContactTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ContactTypeID" class="<?php echo $lawyercontact->ContactTypeID->headerCellClass() ?>"><div><div id="elh_lawyercontact_ContactTypeID" class="lawyercontact_ContactTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyercontact->ContactTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyercontact->ContactTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyercontact->ContactTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->Contact->Visible) { // Contact ?>
	<?php if ($lawyercontact->sortUrl($lawyercontact->Contact) == "") { ?>
		<th data-name="Contact" class="<?php echo $lawyercontact->Contact->headerCellClass() ?>"><div id="elh_lawyercontact_Contact" class="lawyercontact_Contact"><div class="ew-table-header-caption"><?php echo $lawyercontact->Contact->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Contact" class="<?php echo $lawyercontact->Contact->headerCellClass() ?>"><div><div id="elh_lawyercontact_Contact" class="lawyercontact_Contact">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyercontact->Contact->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyercontact->Contact->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyercontact->Contact->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->Notes->Visible) { // Notes ?>
	<?php if ($lawyercontact->sortUrl($lawyercontact->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $lawyercontact->Notes->headerCellClass() ?>"><div id="elh_lawyercontact_Notes" class="lawyercontact_Notes"><div class="ew-table-header-caption"><?php echo $lawyercontact->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $lawyercontact->Notes->headerCellClass() ?>"><div><div id="elh_lawyercontact_Notes" class="lawyercontact_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyercontact->Notes->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyercontact->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyercontact->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->Primary->Visible) { // Primary ?>
	<?php if ($lawyercontact->sortUrl($lawyercontact->Primary) == "") { ?>
		<th data-name="Primary" class="<?php echo $lawyercontact->Primary->headerCellClass() ?>"><div id="elh_lawyercontact_Primary" class="lawyercontact_Primary"><div class="ew-table-header-caption"><?php echo $lawyercontact->Primary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primary" class="<?php echo $lawyercontact->Primary->headerCellClass() ?>"><div><div id="elh_lawyercontact_Primary" class="lawyercontact_Primary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyercontact->Primary->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyercontact->Primary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyercontact->Primary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$lawyercontact_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$lawyercontact_grid->StartRec = 1;
$lawyercontact_grid->StopRec = $lawyercontact_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $lawyercontact_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($lawyercontact_grid->FormKeyCountName) && ($lawyercontact->isGridAdd() || $lawyercontact->isGridEdit() || $lawyercontact->isConfirm())) {
		$lawyercontact_grid->KeyCount = $CurrentForm->getValue($lawyercontact_grid->FormKeyCountName);
		$lawyercontact_grid->StopRec = $lawyercontact_grid->StartRec + $lawyercontact_grid->KeyCount - 1;
	}
}
$lawyercontact_grid->RecCnt = $lawyercontact_grid->StartRec - 1;
if ($lawyercontact_grid->Recordset && !$lawyercontact_grid->Recordset->EOF) {
	$lawyercontact_grid->Recordset->moveFirst();
	$selectLimit = $lawyercontact_grid->UseSelectLimit;
	if (!$selectLimit && $lawyercontact_grid->StartRec > 1)
		$lawyercontact_grid->Recordset->move($lawyercontact_grid->StartRec - 1);
} elseif (!$lawyercontact->AllowAddDeleteRow && $lawyercontact_grid->StopRec == 0) {
	$lawyercontact_grid->StopRec = $lawyercontact->GridAddRowCount;
}

// Initialize aggregate
$lawyercontact->RowType = ROWTYPE_AGGREGATEINIT;
$lawyercontact->resetAttributes();
$lawyercontact_grid->renderRow();
if ($lawyercontact->isGridAdd())
	$lawyercontact_grid->RowIndex = 0;
if ($lawyercontact->isGridEdit())
	$lawyercontact_grid->RowIndex = 0;
while ($lawyercontact_grid->RecCnt < $lawyercontact_grid->StopRec) {
	$lawyercontact_grid->RecCnt++;
	if ($lawyercontact_grid->RecCnt >= $lawyercontact_grid->StartRec) {
		$lawyercontact_grid->RowCnt++;
		if ($lawyercontact->isGridAdd() || $lawyercontact->isGridEdit() || $lawyercontact->isConfirm()) {
			$lawyercontact_grid->RowIndex++;
			$CurrentForm->Index = $lawyercontact_grid->RowIndex;
			if ($CurrentForm->hasValue($lawyercontact_grid->FormActionName) && $lawyercontact_grid->EventCancelled)
				$lawyercontact_grid->RowAction = strval($CurrentForm->getValue($lawyercontact_grid->FormActionName));
			elseif ($lawyercontact->isGridAdd())
				$lawyercontact_grid->RowAction = "insert";
			else
				$lawyercontact_grid->RowAction = "";
		}

		// Set up key count
		$lawyercontact_grid->KeyCount = $lawyercontact_grid->RowIndex;

		// Init row class and style
		$lawyercontact->resetAttributes();
		$lawyercontact->CssClass = "";
		if ($lawyercontact->isGridAdd()) {
			if ($lawyercontact->CurrentMode == "copy") {
				$lawyercontact_grid->loadRowValues($lawyercontact_grid->Recordset); // Load row values
				$lawyercontact_grid->setRecordKey($lawyercontact_grid->RowOldKey, $lawyercontact_grid->Recordset); // Set old record key
			} else {
				$lawyercontact_grid->loadRowValues(); // Load default values
				$lawyercontact_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$lawyercontact_grid->loadRowValues($lawyercontact_grid->Recordset); // Load row values
		}
		$lawyercontact->RowType = ROWTYPE_VIEW; // Render view
		if ($lawyercontact->isGridAdd()) // Grid add
			$lawyercontact->RowType = ROWTYPE_ADD; // Render add
		if ($lawyercontact->isGridAdd() && $lawyercontact->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$lawyercontact_grid->restoreCurrentRowFormValues($lawyercontact_grid->RowIndex); // Restore form values
		if ($lawyercontact->isGridEdit()) { // Grid edit
			if ($lawyercontact->EventCancelled)
				$lawyercontact_grid->restoreCurrentRowFormValues($lawyercontact_grid->RowIndex); // Restore form values
			if ($lawyercontact_grid->RowAction == "insert")
				$lawyercontact->RowType = ROWTYPE_ADD; // Render add
			else
				$lawyercontact->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($lawyercontact->isGridEdit() && ($lawyercontact->RowType == ROWTYPE_EDIT || $lawyercontact->RowType == ROWTYPE_ADD) && $lawyercontact->EventCancelled) // Update failed
			$lawyercontact_grid->restoreCurrentRowFormValues($lawyercontact_grid->RowIndex); // Restore form values
		if ($lawyercontact->RowType == ROWTYPE_EDIT) // Edit row
			$lawyercontact_grid->EditRowCnt++;
		if ($lawyercontact->isConfirm()) // Confirm row
			$lawyercontact_grid->restoreCurrentRowFormValues($lawyercontact_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$lawyercontact->RowAttrs = array_merge($lawyercontact->RowAttrs, array('data-rowindex'=>$lawyercontact_grid->RowCnt, 'id'=>'r' . $lawyercontact_grid->RowCnt . '_lawyercontact', 'data-rowtype'=>$lawyercontact->RowType));

		// Render row
		$lawyercontact_grid->renderRow();

		// Render list options
		$lawyercontact_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($lawyercontact_grid->RowAction <> "delete" && $lawyercontact_grid->RowAction <> "insertdelete" && !($lawyercontact_grid->RowAction == "insert" && $lawyercontact->isConfirm() && $lawyercontact_grid->emptyRow())) {
?>
	<tr<?php echo $lawyercontact->rowAttributes() ?>>
<?php

// Render list options (body, left)
$lawyercontact_grid->ListOptions->render("body", "left", $lawyercontact_grid->RowCnt);
?>
	<?php if ($lawyercontact->LawyerID->Visible) { // LawyerID ?>
		<td data-name="LawyerID"<?php echo $lawyercontact->LawyerID->cellAttributes() ?>>
<?php if ($lawyercontact->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($lawyercontact->LawyerID->getSessionValue() <> "") { ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_LawyerID" class="form-group lawyercontact_LawyerID">
<span<?php echo $lawyercontact->LawyerID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyercontact->LawyerID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyercontact->LawyerID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_LawyerID" class="form-group lawyercontact_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyercontact" data-field="x_LawyerID" data-value-separator="<?php echo $lawyercontact->LawyerID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID"<?php echo $lawyercontact->LawyerID->editAttributes() ?>>
		<?php echo $lawyercontact->LawyerID->selectOptionListHtml("x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID") ?>
	</select>
</div>
<?php echo $lawyercontact->LawyerID->Lookup->getParamTag("p_x" . $lawyercontact_grid->RowIndex . "_LawyerID") ?>
</span>
<?php } ?>
<input type="hidden" data-table="lawyercontact" data-field="x_LawyerID" name="o<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" id="o<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyercontact->LawyerID->OldValue) ?>">
<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($lawyercontact->LawyerID->getSessionValue() <> "") { ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_LawyerID" class="form-group lawyercontact_LawyerID">
<span<?php echo $lawyercontact->LawyerID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyercontact->LawyerID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyercontact->LawyerID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_LawyerID" class="form-group lawyercontact_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyercontact" data-field="x_LawyerID" data-value-separator="<?php echo $lawyercontact->LawyerID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID"<?php echo $lawyercontact->LawyerID->editAttributes() ?>>
		<?php echo $lawyercontact->LawyerID->selectOptionListHtml("x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID") ?>
	</select>
</div>
<?php echo $lawyercontact->LawyerID->Lookup->getParamTag("p_x" . $lawyercontact_grid->RowIndex . "_LawyerID") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_LawyerID" class="lawyercontact_LawyerID">
<span<?php echo $lawyercontact->LawyerID->viewAttributes() ?>>
<?php echo $lawyercontact->LawyerID->getViewValue() ?></span>
</span>
<?php if (!$lawyercontact->isConfirm()) { ?>
<input type="hidden" data-table="lawyercontact" data-field="x_LawyerID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" id="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyercontact->LawyerID->FormValue) ?>">
<input type="hidden" data-table="lawyercontact" data-field="x_LawyerID" name="o<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" id="o<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyercontact->LawyerID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyercontact" data-field="x_LawyerID" name="flawyercontactgrid$x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" id="flawyercontactgrid$x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyercontact->LawyerID->FormValue) ?>">
<input type="hidden" data-table="lawyercontact" data-field="x_LawyerID" name="flawyercontactgrid$o<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" id="flawyercontactgrid$o<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyercontact->LawyerID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="lawyercontact" data-field="x_ContactID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactID" id="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($lawyercontact->ContactID->CurrentValue) ?>">
<input type="hidden" data-table="lawyercontact" data-field="x_ContactID" name="o<?php echo $lawyercontact_grid->RowIndex ?>_ContactID" id="o<?php echo $lawyercontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($lawyercontact->ContactID->OldValue) ?>">
<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_EDIT || $lawyercontact->CurrentMode == "edit") { ?>
<input type="hidden" data-table="lawyercontact" data-field="x_ContactID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactID" id="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactID" value="<?php echo HtmlEncode($lawyercontact->ContactID->CurrentValue) ?>">
<?php } ?>
	<?php if ($lawyercontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<td data-name="ContactTypeID"<?php echo $lawyercontact->ContactTypeID->cellAttributes() ?>>
<?php if ($lawyercontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_ContactTypeID" class="form-group lawyercontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyercontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $lawyercontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID"<?php echo $lawyercontact->ContactTypeID->editAttributes() ?>>
		<?php echo $lawyercontact->ContactTypeID->selectOptionListHtml("x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $lawyercontact->ContactTypeID->Lookup->getParamTag("p_x" . $lawyercontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<input type="hidden" data-table="lawyercontact" data-field="x_ContactTypeID" name="o<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($lawyercontact->ContactTypeID->OldValue) ?>">
<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_ContactTypeID" class="form-group lawyercontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyercontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $lawyercontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID"<?php echo $lawyercontact->ContactTypeID->editAttributes() ?>>
		<?php echo $lawyercontact->ContactTypeID->selectOptionListHtml("x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $lawyercontact->ContactTypeID->Lookup->getParamTag("p_x" . $lawyercontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_ContactTypeID" class="lawyercontact_ContactTypeID">
<span<?php echo $lawyercontact->ContactTypeID->viewAttributes() ?>>
<?php echo $lawyercontact->ContactTypeID->getViewValue() ?></span>
</span>
<?php if (!$lawyercontact->isConfirm()) { ?>
<input type="hidden" data-table="lawyercontact" data-field="x_ContactTypeID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" id="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($lawyercontact->ContactTypeID->FormValue) ?>">
<input type="hidden" data-table="lawyercontact" data-field="x_ContactTypeID" name="o<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($lawyercontact->ContactTypeID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyercontact" data-field="x_ContactTypeID" name="flawyercontactgrid$x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" id="flawyercontactgrid$x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($lawyercontact->ContactTypeID->FormValue) ?>">
<input type="hidden" data-table="lawyercontact" data-field="x_ContactTypeID" name="flawyercontactgrid$o<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" id="flawyercontactgrid$o<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($lawyercontact->ContactTypeID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($lawyercontact->Contact->Visible) { // Contact ?>
		<td data-name="Contact"<?php echo $lawyercontact->Contact->cellAttributes() ?>>
<?php if ($lawyercontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_Contact" class="form-group lawyercontact_Contact">
<input type="text" data-table="lawyercontact" data-field="x_Contact" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyercontact->Contact->getPlaceHolder()) ?>" value="<?php echo $lawyercontact->Contact->EditValue ?>"<?php echo $lawyercontact->Contact->editAttributes() ?>>
</span>
<input type="hidden" data-table="lawyercontact" data-field="x_Contact" name="o<?php echo $lawyercontact_grid->RowIndex ?>_Contact" id="o<?php echo $lawyercontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($lawyercontact->Contact->OldValue) ?>">
<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_Contact" class="form-group lawyercontact_Contact">
<input type="text" data-table="lawyercontact" data-field="x_Contact" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyercontact->Contact->getPlaceHolder()) ?>" value="<?php echo $lawyercontact->Contact->EditValue ?>"<?php echo $lawyercontact->Contact->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_Contact" class="lawyercontact_Contact">
<span<?php echo $lawyercontact->Contact->viewAttributes() ?>>
<?php echo $lawyercontact->Contact->getViewValue() ?></span>
</span>
<?php if (!$lawyercontact->isConfirm()) { ?>
<input type="hidden" data-table="lawyercontact" data-field="x_Contact" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($lawyercontact->Contact->FormValue) ?>">
<input type="hidden" data-table="lawyercontact" data-field="x_Contact" name="o<?php echo $lawyercontact_grid->RowIndex ?>_Contact" id="o<?php echo $lawyercontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($lawyercontact->Contact->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyercontact" data-field="x_Contact" name="flawyercontactgrid$x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" id="flawyercontactgrid$x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($lawyercontact->Contact->FormValue) ?>">
<input type="hidden" data-table="lawyercontact" data-field="x_Contact" name="flawyercontactgrid$o<?php echo $lawyercontact_grid->RowIndex ?>_Contact" id="flawyercontactgrid$o<?php echo $lawyercontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($lawyercontact->Contact->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($lawyercontact->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $lawyercontact->Notes->cellAttributes() ?>>
<?php if ($lawyercontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_Notes" class="form-group lawyercontact_Notes">
<input type="text" data-table="lawyercontact" data-field="x_Notes" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lawyercontact->Notes->getPlaceHolder()) ?>" value="<?php echo $lawyercontact->Notes->EditValue ?>"<?php echo $lawyercontact->Notes->editAttributes() ?>>
</span>
<input type="hidden" data-table="lawyercontact" data-field="x_Notes" name="o<?php echo $lawyercontact_grid->RowIndex ?>_Notes" id="o<?php echo $lawyercontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyercontact->Notes->OldValue) ?>">
<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_Notes" class="form-group lawyercontact_Notes">
<input type="text" data-table="lawyercontact" data-field="x_Notes" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lawyercontact->Notes->getPlaceHolder()) ?>" value="<?php echo $lawyercontact->Notes->EditValue ?>"<?php echo $lawyercontact->Notes->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_Notes" class="lawyercontact_Notes">
<span<?php echo $lawyercontact->Notes->viewAttributes() ?>>
<?php echo $lawyercontact->Notes->getViewValue() ?></span>
</span>
<?php if (!$lawyercontact->isConfirm()) { ?>
<input type="hidden" data-table="lawyercontact" data-field="x_Notes" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyercontact->Notes->FormValue) ?>">
<input type="hidden" data-table="lawyercontact" data-field="x_Notes" name="o<?php echo $lawyercontact_grid->RowIndex ?>_Notes" id="o<?php echo $lawyercontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyercontact->Notes->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyercontact" data-field="x_Notes" name="flawyercontactgrid$x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" id="flawyercontactgrid$x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyercontact->Notes->FormValue) ?>">
<input type="hidden" data-table="lawyercontact" data-field="x_Notes" name="flawyercontactgrid$o<?php echo $lawyercontact_grid->RowIndex ?>_Notes" id="flawyercontactgrid$o<?php echo $lawyercontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyercontact->Notes->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($lawyercontact->Primary->Visible) { // Primary ?>
		<td data-name="Primary"<?php echo $lawyercontact->Primary->cellAttributes() ?>>
<?php if ($lawyercontact->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_Primary" class="form-group lawyercontact_Primary">
<?php
$selwrk = (ConvertToBool($lawyercontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="lawyercontact" data-field="x_Primary" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $lawyercontact->Primary->editAttributes() ?>>
</span>
<input type="hidden" data-table="lawyercontact" data-field="x_Primary" name="o<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($lawyercontact->Primary->OldValue) ?>">
<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_Primary" class="form-group lawyercontact_Primary">
<?php
$selwrk = (ConvertToBool($lawyercontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="lawyercontact" data-field="x_Primary" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $lawyercontact->Primary->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($lawyercontact->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $lawyercontact_grid->RowCnt ?>_lawyercontact_Primary" class="lawyercontact_Primary">
<span<?php echo $lawyercontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($lawyercontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $lawyercontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $lawyercontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
<?php if (!$lawyercontact->isConfirm()) { ?>
<input type="hidden" data-table="lawyercontact" data-field="x_Primary" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Primary" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($lawyercontact->Primary->FormValue) ?>">
<input type="hidden" data-table="lawyercontact" data-field="x_Primary" name="o<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($lawyercontact->Primary->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="lawyercontact" data-field="x_Primary" name="flawyercontactgrid$x<?php echo $lawyercontact_grid->RowIndex ?>_Primary" id="flawyercontactgrid$x<?php echo $lawyercontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($lawyercontact->Primary->FormValue) ?>">
<input type="hidden" data-table="lawyercontact" data-field="x_Primary" name="flawyercontactgrid$o<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" id="flawyercontactgrid$o<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($lawyercontact->Primary->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$lawyercontact_grid->ListOptions->render("body", "right", $lawyercontact_grid->RowCnt);
?>
	</tr>
<?php if ($lawyercontact->RowType == ROWTYPE_ADD || $lawyercontact->RowType == ROWTYPE_EDIT) { ?>
<script>
flawyercontactgrid.updateLists(<?php echo $lawyercontact_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$lawyercontact->isGridAdd() || $lawyercontact->CurrentMode == "copy")
		if (!$lawyercontact_grid->Recordset->EOF)
			$lawyercontact_grid->Recordset->moveNext();
}
?>
<?php
	if ($lawyercontact->CurrentMode == "add" || $lawyercontact->CurrentMode == "copy" || $lawyercontact->CurrentMode == "edit") {
		$lawyercontact_grid->RowIndex = '$rowindex$';
		$lawyercontact_grid->loadRowValues();

		// Set row properties
		$lawyercontact->resetAttributes();
		$lawyercontact->RowAttrs = array_merge($lawyercontact->RowAttrs, array('data-rowindex'=>$lawyercontact_grid->RowIndex, 'id'=>'r0_lawyercontact', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($lawyercontact->RowAttrs["class"], "ew-template");
		$lawyercontact->RowType = ROWTYPE_ADD;

		// Render row
		$lawyercontact_grid->renderRow();

		// Render list options
		$lawyercontact_grid->renderListOptions();
		$lawyercontact_grid->StartRowCnt = 0;
?>
	<tr<?php echo $lawyercontact->rowAttributes() ?>>
<?php

// Render list options (body, left)
$lawyercontact_grid->ListOptions->render("body", "left", $lawyercontact_grid->RowIndex);
?>
	<?php if ($lawyercontact->LawyerID->Visible) { // LawyerID ?>
		<td data-name="LawyerID">
<?php if (!$lawyercontact->isConfirm()) { ?>
<?php if ($lawyercontact->LawyerID->getSessionValue() <> "") { ?>
<span id="el$rowindex$_lawyercontact_LawyerID" class="form-group lawyercontact_LawyerID">
<span<?php echo $lawyercontact->LawyerID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyercontact->LawyerID->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyercontact->LawyerID->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_lawyercontact_LawyerID" class="form-group lawyercontact_LawyerID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyercontact" data-field="x_LawyerID" data-value-separator="<?php echo $lawyercontact->LawyerID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID"<?php echo $lawyercontact->LawyerID->editAttributes() ?>>
		<?php echo $lawyercontact->LawyerID->selectOptionListHtml("x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID") ?>
	</select>
</div>
<?php echo $lawyercontact->LawyerID->Lookup->getParamTag("p_x" . $lawyercontact_grid->RowIndex . "_LawyerID") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_lawyercontact_LawyerID" class="form-group lawyercontact_LawyerID">
<span<?php echo $lawyercontact->LawyerID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyercontact->LawyerID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyercontact" data-field="x_LawyerID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" id="x<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyercontact->LawyerID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyercontact" data-field="x_LawyerID" name="o<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" id="o<?php echo $lawyercontact_grid->RowIndex ?>_LawyerID" value="<?php echo HtmlEncode($lawyercontact->LawyerID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyercontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<td data-name="ContactTypeID">
<?php if (!$lawyercontact->isConfirm()) { ?>
<span id="el$rowindex$_lawyercontact_ContactTypeID" class="form-group lawyercontact_ContactTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyercontact" data-field="x_ContactTypeID" data-value-separator="<?php echo $lawyercontact->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID"<?php echo $lawyercontact->ContactTypeID->editAttributes() ?>>
		<?php echo $lawyercontact->ContactTypeID->selectOptionListHtml("x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID") ?>
	</select>
</div>
<?php echo $lawyercontact->ContactTypeID->Lookup->getParamTag("p_x" . $lawyercontact_grid->RowIndex . "_ContactTypeID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyercontact_ContactTypeID" class="form-group lawyercontact_ContactTypeID">
<span<?php echo $lawyercontact->ContactTypeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyercontact->ContactTypeID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyercontact" data-field="x_ContactTypeID" name="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" id="x<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($lawyercontact->ContactTypeID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyercontact" data-field="x_ContactTypeID" name="o<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" id="o<?php echo $lawyercontact_grid->RowIndex ?>_ContactTypeID" value="<?php echo HtmlEncode($lawyercontact->ContactTypeID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyercontact->Contact->Visible) { // Contact ?>
		<td data-name="Contact">
<?php if (!$lawyercontact->isConfirm()) { ?>
<span id="el$rowindex$_lawyercontact_Contact" class="form-group lawyercontact_Contact">
<input type="text" data-table="lawyercontact" data-field="x_Contact" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyercontact->Contact->getPlaceHolder()) ?>" value="<?php echo $lawyercontact->Contact->EditValue ?>"<?php echo $lawyercontact->Contact->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyercontact_Contact" class="form-group lawyercontact_Contact">
<span<?php echo $lawyercontact->Contact->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyercontact->Contact->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyercontact" data-field="x_Contact" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($lawyercontact->Contact->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyercontact" data-field="x_Contact" name="o<?php echo $lawyercontact_grid->RowIndex ?>_Contact" id="o<?php echo $lawyercontact_grid->RowIndex ?>_Contact" value="<?php echo HtmlEncode($lawyercontact->Contact->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyercontact->Notes->Visible) { // Notes ?>
		<td data-name="Notes">
<?php if (!$lawyercontact->isConfirm()) { ?>
<span id="el$rowindex$_lawyercontact_Notes" class="form-group lawyercontact_Notes">
<input type="text" data-table="lawyercontact" data-field="x_Notes" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($lawyercontact->Notes->getPlaceHolder()) ?>" value="<?php echo $lawyercontact->Notes->EditValue ?>"<?php echo $lawyercontact->Notes->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyercontact_Notes" class="form-group lawyercontact_Notes">
<span<?php echo $lawyercontact->Notes->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($lawyercontact->Notes->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="lawyercontact" data-field="x_Notes" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyercontact->Notes->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyercontact" data-field="x_Notes" name="o<?php echo $lawyercontact_grid->RowIndex ?>_Notes" id="o<?php echo $lawyercontact_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($lawyercontact->Notes->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($lawyercontact->Primary->Visible) { // Primary ?>
		<td data-name="Primary">
<?php if (!$lawyercontact->isConfirm()) { ?>
<span id="el$rowindex$_lawyercontact_Primary" class="form-group lawyercontact_Primary">
<?php
$selwrk = (ConvertToBool($lawyercontact->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="lawyercontact" data-field="x_Primary" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" value="1"<?php echo $selwrk ?><?php echo $lawyercontact->Primary->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_lawyercontact_Primary" class="form-group lawyercontact_Primary">
<span<?php echo $lawyercontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($lawyercontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $lawyercontact->Primary->ViewValue ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $lawyercontact->Primary->ViewValue ?>" disabled>
<?php } ?>
</span>
</span>
<input type="hidden" data-table="lawyercontact" data-field="x_Primary" name="x<?php echo $lawyercontact_grid->RowIndex ?>_Primary" id="x<?php echo $lawyercontact_grid->RowIndex ?>_Primary" value="<?php echo HtmlEncode($lawyercontact->Primary->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="lawyercontact" data-field="x_Primary" name="o<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" id="o<?php echo $lawyercontact_grid->RowIndex ?>_Primary[]" value="<?php echo HtmlEncode($lawyercontact->Primary->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$lawyercontact_grid->ListOptions->render("body", "right", $lawyercontact_grid->RowIndex);
?>
<script>
flawyercontactgrid.updateLists(<?php echo $lawyercontact_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($lawyercontact->CurrentMode == "add" || $lawyercontact->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $lawyercontact_grid->FormKeyCountName ?>" id="<?php echo $lawyercontact_grid->FormKeyCountName ?>" value="<?php echo $lawyercontact_grid->KeyCount ?>">
<?php echo $lawyercontact_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($lawyercontact->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $lawyercontact_grid->FormKeyCountName ?>" id="<?php echo $lawyercontact_grid->FormKeyCountName ?>" value="<?php echo $lawyercontact_grid->KeyCount ?>">
<?php echo $lawyercontact_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($lawyercontact->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="flawyercontactgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($lawyercontact_grid->Recordset)
	$lawyercontact_grid->Recordset->Close();
?>
</div>
<?php if ($lawyercontact_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $lawyercontact_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($lawyercontact_grid->TotalRecs == 0 && !$lawyercontact->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $lawyercontact_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$lawyercontact_grid->terminate();
?>
<?php if (!$lawyercontact->isExport()) { ?>
<script>
ew.scrollableTable("gmp_lawyercontact", "", "");
</script>
<?php } ?>
