<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$lawyeraddress_list = new lawyeraddress_list();

// Run the page
$lawyeraddress_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawyeraddress_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$lawyeraddress->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var flawyeraddresslist = currentForm = new ew.Form("flawyeraddresslist", "list");
flawyeraddresslist.formKeyCountName = '<?php echo $lawyeraddress_list->FormKeyCountName ?>';

// Form_CustomValidate event
flawyeraddresslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyeraddresslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawyeraddresslist.lists["x_LawyerID"] = <?php echo $lawyeraddress_list->LawyerID->Lookup->toClientList() ?>;
flawyeraddresslist.lists["x_LawyerID"].options = <?php echo JsonEncode($lawyeraddress_list->LawyerID->lookupOptions()) ?>;
flawyeraddresslist.lists["x_AddressTypeID"] = <?php echo $lawyeraddress_list->AddressTypeID->Lookup->toClientList() ?>;
flawyeraddresslist.lists["x_AddressTypeID"].options = <?php echo JsonEncode($lawyeraddress_list->AddressTypeID->lookupOptions()) ?>;
flawyeraddresslist.lists["x_Primary[]"] = <?php echo $lawyeraddress_list->Primary->Lookup->toClientList() ?>;
flawyeraddresslist.lists["x_Primary[]"].options = <?php echo JsonEncode($lawyeraddress_list->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
var flawyeraddresslistsrch = currentSearchForm = new ew.Form("flawyeraddresslistsrch");

// Validate function for search
flawyeraddresslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
flawyeraddresslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyeraddresslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawyeraddresslistsrch.lists["x_Primary[]"] = <?php echo $lawyeraddress_list->Primary->Lookup->toClientList() ?>;
flawyeraddresslistsrch.lists["x_Primary[]"].options = <?php echo JsonEncode($lawyeraddress_list->Primary->options(FALSE, TRUE)) ?>;

// Filters
flawyeraddresslistsrch.filterList = <?php echo $lawyeraddress_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$lawyeraddress->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($lawyeraddress_list->TotalRecs > 0 && $lawyeraddress_list->ExportOptions->visible()) { ?>
<?php $lawyeraddress_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($lawyeraddress_list->ImportOptions->visible()) { ?>
<?php $lawyeraddress_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($lawyeraddress_list->SearchOptions->visible()) { ?>
<?php $lawyeraddress_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($lawyeraddress_list->FilterOptions->visible()) { ?>
<?php $lawyeraddress_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$lawyeraddress->isExport() || EXPORT_MASTER_RECORD && $lawyeraddress->isExport("print")) { ?>
<?php
if ($lawyeraddress_list->DbMasterFilter <> "" && $lawyeraddress->getCurrentMasterTable() == "lawyers") {
	if ($lawyeraddress_list->MasterRecordExists) {
		include_once "lawyersmaster.php";
	}
}
?>
<?php } ?>
<?php
$lawyeraddress_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$lawyeraddress->isExport() && !$lawyeraddress->CurrentAction) { ?>
<form name="flawyeraddresslistsrch" id="flawyeraddresslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($lawyeraddress_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="flawyeraddresslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="lawyeraddress">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$lawyeraddress_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$lawyeraddress->RowType = ROWTYPE_SEARCH;

// Render row
$lawyeraddress->resetAttributes();
$lawyeraddress_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($lawyeraddress->Primary->Visible) { // Primary ?>
	<div id="xsc_Primary" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $lawyeraddress->Primary->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Primary" id="z_Primary" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($lawyeraddress->Primary->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="lawyeraddress" data-field="x_Primary" name="x_Primary[]" id="x_Primary[]" value="1"<?php echo $selwrk ?><?php echo $lawyeraddress->Primary->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($lawyeraddress_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($lawyeraddress_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $lawyeraddress_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($lawyeraddress_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($lawyeraddress_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($lawyeraddress_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($lawyeraddress_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $lawyeraddress_list->showPageHeader(); ?>
<?php
$lawyeraddress_list->showMessage();
?>
<?php if ($lawyeraddress_list->TotalRecs > 0 || $lawyeraddress->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($lawyeraddress_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> lawyeraddress">
<?php if (!$lawyeraddress->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$lawyeraddress->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($lawyeraddress_list->Pager)) $lawyeraddress_list->Pager = new PrevNextPager($lawyeraddress_list->StartRec, $lawyeraddress_list->DisplayRecs, $lawyeraddress_list->TotalRecs, $lawyeraddress_list->AutoHidePager) ?>
<?php if ($lawyeraddress_list->Pager->RecordCount > 0 && $lawyeraddress_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawyeraddress_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawyeraddress_list->pageUrl() ?>start=<?php echo $lawyeraddress_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawyeraddress_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawyeraddress_list->pageUrl() ?>start=<?php echo $lawyeraddress_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawyeraddress_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawyeraddress_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawyeraddress_list->pageUrl() ?>start=<?php echo $lawyeraddress_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawyeraddress_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawyeraddress_list->pageUrl() ?>start=<?php echo $lawyeraddress_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawyeraddress_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($lawyeraddress_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $lawyeraddress_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $lawyeraddress_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $lawyeraddress_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($lawyeraddress_list->TotalRecs > 0 && (!$lawyeraddress_list->AutoHidePageSizeSelector || $lawyeraddress_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="lawyeraddress">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($lawyeraddress_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($lawyeraddress_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($lawyeraddress_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($lawyeraddress_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($lawyeraddress_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($lawyeraddress_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($lawyeraddress_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($lawyeraddress_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($lawyeraddress_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($lawyeraddress->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $lawyeraddress_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="flawyeraddresslist" id="flawyeraddresslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($lawyeraddress_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $lawyeraddress_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="lawyeraddress">
<?php if ($lawyeraddress->getCurrentMasterTable() == "lawyers" && $lawyeraddress->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="lawyers">
<input type="hidden" name="fk_LawyerID" value="<?php echo $lawyeraddress->LawyerID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_lawyeraddress" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($lawyeraddress_list->TotalRecs > 0 || $lawyeraddress->isGridEdit()) { ?>
<table id="tbl_lawyeraddresslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$lawyeraddress_list->RowType = ROWTYPE_HEADER;

// Render list options
$lawyeraddress_list->renderListOptions();

// Render list options (header, left)
$lawyeraddress_list->ListOptions->render("header", "left");
?>
<?php if ($lawyeraddress->LawyerID->Visible) { // LawyerID ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->LawyerID) == "") { ?>
		<th data-name="LawyerID" class="<?php echo $lawyeraddress->LawyerID->headerCellClass() ?>"><div id="elh_lawyeraddress_LawyerID" class="lawyeraddress_LawyerID"><div class="ew-table-header-caption"><?php echo $lawyeraddress->LawyerID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LawyerID" class="<?php echo $lawyeraddress->LawyerID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyeraddress->SortUrl($lawyeraddress->LawyerID) ?>',2);"><div id="elh_lawyeraddress_LawyerID" class="lawyeraddress_LawyerID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->LawyerID->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->LawyerID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->LawyerID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->AddressTypeID->Visible) { // AddressTypeID ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->AddressTypeID) == "") { ?>
		<th data-name="AddressTypeID" class="<?php echo $lawyeraddress->AddressTypeID->headerCellClass() ?>"><div id="elh_lawyeraddress_AddressTypeID" class="lawyeraddress_AddressTypeID"><div class="ew-table-header-caption"><?php echo $lawyeraddress->AddressTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AddressTypeID" class="<?php echo $lawyeraddress->AddressTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyeraddress->SortUrl($lawyeraddress->AddressTypeID) ?>',2);"><div id="elh_lawyeraddress_AddressTypeID" class="lawyeraddress_AddressTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->AddressTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->AddressTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->AddressTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->Address->Visible) { // Address ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->Address) == "") { ?>
		<th data-name="Address" class="<?php echo $lawyeraddress->Address->headerCellClass() ?>"><div id="elh_lawyeraddress_Address" class="lawyeraddress_Address"><div class="ew-table-header-caption"><?php echo $lawyeraddress->Address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Address" class="<?php echo $lawyeraddress->Address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyeraddress->SortUrl($lawyeraddress->Address) ?>',2);"><div id="elh_lawyeraddress_Address" class="lawyeraddress_Address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->Address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->Address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->Address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->City->Visible) { // City ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->City) == "") { ?>
		<th data-name="City" class="<?php echo $lawyeraddress->City->headerCellClass() ?>"><div id="elh_lawyeraddress_City" class="lawyeraddress_City"><div class="ew-table-header-caption"><?php echo $lawyeraddress->City->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="City" class="<?php echo $lawyeraddress->City->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyeraddress->SortUrl($lawyeraddress->City) ?>',2);"><div id="elh_lawyeraddress_City" class="lawyeraddress_City">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->City->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->City->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->City->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->Region->Visible) { // Region ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->Region) == "") { ?>
		<th data-name="Region" class="<?php echo $lawyeraddress->Region->headerCellClass() ?>"><div id="elh_lawyeraddress_Region" class="lawyeraddress_Region"><div class="ew-table-header-caption"><?php echo $lawyeraddress->Region->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Region" class="<?php echo $lawyeraddress->Region->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyeraddress->SortUrl($lawyeraddress->Region) ?>',2);"><div id="elh_lawyeraddress_Region" class="lawyeraddress_Region">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->Region->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->Region->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->Region->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->PostalCode->Visible) { // PostalCode ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->PostalCode) == "") { ?>
		<th data-name="PostalCode" class="<?php echo $lawyeraddress->PostalCode->headerCellClass() ?>"><div id="elh_lawyeraddress_PostalCode" class="lawyeraddress_PostalCode"><div class="ew-table-header-caption"><?php echo $lawyeraddress->PostalCode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PostalCode" class="<?php echo $lawyeraddress->PostalCode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyeraddress->SortUrl($lawyeraddress->PostalCode) ?>',2);"><div id="elh_lawyeraddress_PostalCode" class="lawyeraddress_PostalCode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->PostalCode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->PostalCode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->PostalCode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->Country->Visible) { // Country ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->Country) == "") { ?>
		<th data-name="Country" class="<?php echo $lawyeraddress->Country->headerCellClass() ?>"><div id="elh_lawyeraddress_Country" class="lawyeraddress_Country"><div class="ew-table-header-caption"><?php echo $lawyeraddress->Country->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Country" class="<?php echo $lawyeraddress->Country->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyeraddress->SortUrl($lawyeraddress->Country) ?>',2);"><div id="elh_lawyeraddress_Country" class="lawyeraddress_Country">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->Country->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->Country->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->Country->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->Notes->Visible) { // Notes ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $lawyeraddress->Notes->headerCellClass() ?>"><div id="elh_lawyeraddress_Notes" class="lawyeraddress_Notes"><div class="ew-table-header-caption"><?php echo $lawyeraddress->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $lawyeraddress->Notes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyeraddress->SortUrl($lawyeraddress->Notes) ?>',2);"><div id="elh_lawyeraddress_Notes" class="lawyeraddress_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyeraddress->Primary->Visible) { // Primary ?>
	<?php if ($lawyeraddress->sortUrl($lawyeraddress->Primary) == "") { ?>
		<th data-name="Primary" class="<?php echo $lawyeraddress->Primary->headerCellClass() ?>"><div id="elh_lawyeraddress_Primary" class="lawyeraddress_Primary"><div class="ew-table-header-caption"><?php echo $lawyeraddress->Primary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primary" class="<?php echo $lawyeraddress->Primary->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyeraddress->SortUrl($lawyeraddress->Primary) ?>',2);"><div id="elh_lawyeraddress_Primary" class="lawyeraddress_Primary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyeraddress->Primary->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyeraddress->Primary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyeraddress->Primary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$lawyeraddress_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($lawyeraddress->ExportAll && $lawyeraddress->isExport()) {
	$lawyeraddress_list->StopRec = $lawyeraddress_list->TotalRecs;
} else {

	// Set the last record to display
	if ($lawyeraddress_list->TotalRecs > $lawyeraddress_list->StartRec + $lawyeraddress_list->DisplayRecs - 1)
		$lawyeraddress_list->StopRec = $lawyeraddress_list->StartRec + $lawyeraddress_list->DisplayRecs - 1;
	else
		$lawyeraddress_list->StopRec = $lawyeraddress_list->TotalRecs;
}
$lawyeraddress_list->RecCnt = $lawyeraddress_list->StartRec - 1;
if ($lawyeraddress_list->Recordset && !$lawyeraddress_list->Recordset->EOF) {
	$lawyeraddress_list->Recordset->moveFirst();
	$selectLimit = $lawyeraddress_list->UseSelectLimit;
	if (!$selectLimit && $lawyeraddress_list->StartRec > 1)
		$lawyeraddress_list->Recordset->move($lawyeraddress_list->StartRec - 1);
} elseif (!$lawyeraddress->AllowAddDeleteRow && $lawyeraddress_list->StopRec == 0) {
	$lawyeraddress_list->StopRec = $lawyeraddress->GridAddRowCount;
}

// Initialize aggregate
$lawyeraddress->RowType = ROWTYPE_AGGREGATEINIT;
$lawyeraddress->resetAttributes();
$lawyeraddress_list->renderRow();
while ($lawyeraddress_list->RecCnt < $lawyeraddress_list->StopRec) {
	$lawyeraddress_list->RecCnt++;
	if ($lawyeraddress_list->RecCnt >= $lawyeraddress_list->StartRec) {
		$lawyeraddress_list->RowCnt++;

		// Set up key count
		$lawyeraddress_list->KeyCount = $lawyeraddress_list->RowIndex;

		// Init row class and style
		$lawyeraddress->resetAttributes();
		$lawyeraddress->CssClass = "";
		if ($lawyeraddress->isGridAdd()) {
		} else {
			$lawyeraddress_list->loadRowValues($lawyeraddress_list->Recordset); // Load row values
		}
		$lawyeraddress->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$lawyeraddress->RowAttrs = array_merge($lawyeraddress->RowAttrs, array('data-rowindex'=>$lawyeraddress_list->RowCnt, 'id'=>'r' . $lawyeraddress_list->RowCnt . '_lawyeraddress', 'data-rowtype'=>$lawyeraddress->RowType));

		// Render row
		$lawyeraddress_list->renderRow();

		// Render list options
		$lawyeraddress_list->renderListOptions();
?>
	<tr<?php echo $lawyeraddress->rowAttributes() ?>>
<?php

// Render list options (body, left)
$lawyeraddress_list->ListOptions->render("body", "left", $lawyeraddress_list->RowCnt);
?>
	<?php if ($lawyeraddress->LawyerID->Visible) { // LawyerID ?>
		<td data-name="LawyerID"<?php echo $lawyeraddress->LawyerID->cellAttributes() ?>>
<span id="el<?php echo $lawyeraddress_list->RowCnt ?>_lawyeraddress_LawyerID" class="lawyeraddress_LawyerID">
<span<?php echo $lawyeraddress->LawyerID->viewAttributes() ?>>
<?php echo $lawyeraddress->LawyerID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->AddressTypeID->Visible) { // AddressTypeID ?>
		<td data-name="AddressTypeID"<?php echo $lawyeraddress->AddressTypeID->cellAttributes() ?>>
<span id="el<?php echo $lawyeraddress_list->RowCnt ?>_lawyeraddress_AddressTypeID" class="lawyeraddress_AddressTypeID">
<span<?php echo $lawyeraddress->AddressTypeID->viewAttributes() ?>>
<?php echo $lawyeraddress->AddressTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Address->Visible) { // Address ?>
		<td data-name="Address"<?php echo $lawyeraddress->Address->cellAttributes() ?>>
<span id="el<?php echo $lawyeraddress_list->RowCnt ?>_lawyeraddress_Address" class="lawyeraddress_Address">
<span<?php echo $lawyeraddress->Address->viewAttributes() ?>>
<?php echo $lawyeraddress->Address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->City->Visible) { // City ?>
		<td data-name="City"<?php echo $lawyeraddress->City->cellAttributes() ?>>
<span id="el<?php echo $lawyeraddress_list->RowCnt ?>_lawyeraddress_City" class="lawyeraddress_City">
<span<?php echo $lawyeraddress->City->viewAttributes() ?>>
<?php echo $lawyeraddress->City->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Region->Visible) { // Region ?>
		<td data-name="Region"<?php echo $lawyeraddress->Region->cellAttributes() ?>>
<span id="el<?php echo $lawyeraddress_list->RowCnt ?>_lawyeraddress_Region" class="lawyeraddress_Region">
<span<?php echo $lawyeraddress->Region->viewAttributes() ?>>
<?php echo $lawyeraddress->Region->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->PostalCode->Visible) { // PostalCode ?>
		<td data-name="PostalCode"<?php echo $lawyeraddress->PostalCode->cellAttributes() ?>>
<span id="el<?php echo $lawyeraddress_list->RowCnt ?>_lawyeraddress_PostalCode" class="lawyeraddress_PostalCode">
<span<?php echo $lawyeraddress->PostalCode->viewAttributes() ?>>
<?php echo $lawyeraddress->PostalCode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Country->Visible) { // Country ?>
		<td data-name="Country"<?php echo $lawyeraddress->Country->cellAttributes() ?>>
<span id="el<?php echo $lawyeraddress_list->RowCnt ?>_lawyeraddress_Country" class="lawyeraddress_Country">
<span<?php echo $lawyeraddress->Country->viewAttributes() ?>>
<?php echo $lawyeraddress->Country->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $lawyeraddress->Notes->cellAttributes() ?>>
<span id="el<?php echo $lawyeraddress_list->RowCnt ?>_lawyeraddress_Notes" class="lawyeraddress_Notes">
<span<?php echo $lawyeraddress->Notes->viewAttributes() ?>>
<?php echo $lawyeraddress->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyeraddress->Primary->Visible) { // Primary ?>
		<td data-name="Primary"<?php echo $lawyeraddress->Primary->cellAttributes() ?>>
<span id="el<?php echo $lawyeraddress_list->RowCnt ?>_lawyeraddress_Primary" class="lawyeraddress_Primary">
<span<?php echo $lawyeraddress->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($lawyeraddress->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $lawyeraddress->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $lawyeraddress->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$lawyeraddress_list->ListOptions->render("body", "right", $lawyeraddress_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$lawyeraddress->isGridAdd())
		$lawyeraddress_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$lawyeraddress->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($lawyeraddress_list->Recordset)
	$lawyeraddress_list->Recordset->Close();
?>
<?php if (!$lawyeraddress->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$lawyeraddress->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($lawyeraddress_list->Pager)) $lawyeraddress_list->Pager = new PrevNextPager($lawyeraddress_list->StartRec, $lawyeraddress_list->DisplayRecs, $lawyeraddress_list->TotalRecs, $lawyeraddress_list->AutoHidePager) ?>
<?php if ($lawyeraddress_list->Pager->RecordCount > 0 && $lawyeraddress_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawyeraddress_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawyeraddress_list->pageUrl() ?>start=<?php echo $lawyeraddress_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawyeraddress_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawyeraddress_list->pageUrl() ?>start=<?php echo $lawyeraddress_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawyeraddress_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawyeraddress_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawyeraddress_list->pageUrl() ?>start=<?php echo $lawyeraddress_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawyeraddress_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawyeraddress_list->pageUrl() ?>start=<?php echo $lawyeraddress_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawyeraddress_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($lawyeraddress_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $lawyeraddress_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $lawyeraddress_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $lawyeraddress_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($lawyeraddress_list->TotalRecs > 0 && (!$lawyeraddress_list->AutoHidePageSizeSelector || $lawyeraddress_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="lawyeraddress">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($lawyeraddress_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($lawyeraddress_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($lawyeraddress_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($lawyeraddress_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($lawyeraddress_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($lawyeraddress_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($lawyeraddress_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($lawyeraddress_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($lawyeraddress_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($lawyeraddress->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $lawyeraddress_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($lawyeraddress_list->TotalRecs == 0 && !$lawyeraddress->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $lawyeraddress_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$lawyeraddress_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$lawyeraddress->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$lawyeraddress->isExport()) { ?>
<script>
ew.scrollableTable("gmp_lawyeraddress", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$lawyeraddress_list->terminate();
?>
