<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$judgetype_add = new judgetype_add();

// Run the page
$judgetype_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$judgetype_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fjudgetypeadd = currentForm = new ew.Form("fjudgetypeadd", "add");

// Validate form
fjudgetypeadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($judgetype_add->JudgeType->Required) { ?>
			elm = this.getElements("x" + infix + "_JudgeType");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judgetype->JudgeType->caption(), $judgetype->JudgeType->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judgetype_add->JudgeTypeEn->Required) { ?>
			elm = this.getElements("x" + infix + "_JudgeTypeEn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judgetype->JudgeTypeEn->caption(), $judgetype->JudgeTypeEn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($judgetype_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $judgetype->Notes->caption(), $judgetype->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fjudgetypeadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjudgetypeadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $judgetype_add->showPageHeader(); ?>
<?php
$judgetype_add->showMessage();
?>
<form name="fjudgetypeadd" id="fjudgetypeadd" class="<?php echo $judgetype_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($judgetype_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $judgetype_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="judgetype">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$judgetype_add->IsModal ?>">
<?php if (!$judgetype_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($judgetype_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_judgetypeadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($judgetype->JudgeType->Visible) { // JudgeType ?>
<?php if ($judgetype_add->IsMobileOrModal) { ?>
	<div id="r_JudgeType" class="form-group row">
		<label id="elh_judgetype_JudgeType" for="x_JudgeType" class="<?php echo $judgetype_add->LeftColumnClass ?>"><?php echo $judgetype->JudgeType->caption() ?><?php echo ($judgetype->JudgeType->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $judgetype_add->RightColumnClass ?>"><div<?php echo $judgetype->JudgeType->cellAttributes() ?>>
<span id="el_judgetype_JudgeType">
<input type="text" data-table="judgetype" data-field="x_JudgeType" name="x_JudgeType" id="x_JudgeType" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($judgetype->JudgeType->getPlaceHolder()) ?>" value="<?php echo $judgetype->JudgeType->EditValue ?>"<?php echo $judgetype->JudgeType->editAttributes() ?>>
</span>
<?php echo $judgetype->JudgeType->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_JudgeType">
		<td class="<?php echo $judgetype_add->TableLeftColumnClass ?>"><span id="elh_judgetype_JudgeType"><?php echo $judgetype->JudgeType->caption() ?><?php echo ($judgetype->JudgeType->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $judgetype->JudgeType->cellAttributes() ?>>
<span id="el_judgetype_JudgeType">
<input type="text" data-table="judgetype" data-field="x_JudgeType" name="x_JudgeType" id="x_JudgeType" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($judgetype->JudgeType->getPlaceHolder()) ?>" value="<?php echo $judgetype->JudgeType->EditValue ?>"<?php echo $judgetype->JudgeType->editAttributes() ?>>
</span>
<?php echo $judgetype->JudgeType->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($judgetype->JudgeTypeEn->Visible) { // JudgeTypeEn ?>
<?php if ($judgetype_add->IsMobileOrModal) { ?>
	<div id="r_JudgeTypeEn" class="form-group row">
		<label id="elh_judgetype_JudgeTypeEn" for="x_JudgeTypeEn" class="<?php echo $judgetype_add->LeftColumnClass ?>"><?php echo $judgetype->JudgeTypeEn->caption() ?><?php echo ($judgetype->JudgeTypeEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $judgetype_add->RightColumnClass ?>"><div<?php echo $judgetype->JudgeTypeEn->cellAttributes() ?>>
<span id="el_judgetype_JudgeTypeEn">
<input type="text" data-table="judgetype" data-field="x_JudgeTypeEn" name="x_JudgeTypeEn" id="x_JudgeTypeEn" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($judgetype->JudgeTypeEn->getPlaceHolder()) ?>" value="<?php echo $judgetype->JudgeTypeEn->EditValue ?>"<?php echo $judgetype->JudgeTypeEn->editAttributes() ?>>
</span>
<?php echo $judgetype->JudgeTypeEn->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_JudgeTypeEn">
		<td class="<?php echo $judgetype_add->TableLeftColumnClass ?>"><span id="elh_judgetype_JudgeTypeEn"><?php echo $judgetype->JudgeTypeEn->caption() ?><?php echo ($judgetype->JudgeTypeEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $judgetype->JudgeTypeEn->cellAttributes() ?>>
<span id="el_judgetype_JudgeTypeEn">
<input type="text" data-table="judgetype" data-field="x_JudgeTypeEn" name="x_JudgeTypeEn" id="x_JudgeTypeEn" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($judgetype->JudgeTypeEn->getPlaceHolder()) ?>" value="<?php echo $judgetype->JudgeTypeEn->EditValue ?>"<?php echo $judgetype->JudgeTypeEn->editAttributes() ?>>
</span>
<?php echo $judgetype->JudgeTypeEn->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($judgetype->Notes->Visible) { // Notes ?>
<?php if ($judgetype_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_judgetype_Notes" for="x_Notes" class="<?php echo $judgetype_add->LeftColumnClass ?>"><?php echo $judgetype->Notes->caption() ?><?php echo ($judgetype->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $judgetype_add->RightColumnClass ?>"><div<?php echo $judgetype->Notes->cellAttributes() ?>>
<span id="el_judgetype_Notes">
<input type="text" data-table="judgetype" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($judgetype->Notes->getPlaceHolder()) ?>" value="<?php echo $judgetype->Notes->EditValue ?>"<?php echo $judgetype->Notes->editAttributes() ?>>
</span>
<?php echo $judgetype->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $judgetype_add->TableLeftColumnClass ?>"><span id="elh_judgetype_Notes"><?php echo $judgetype->Notes->caption() ?><?php echo ($judgetype->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $judgetype->Notes->cellAttributes() ?>>
<span id="el_judgetype_Notes">
<input type="text" data-table="judgetype" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($judgetype->Notes->getPlaceHolder()) ?>" value="<?php echo $judgetype->Notes->EditValue ?>"<?php echo $judgetype->Notes->editAttributes() ?>>
</span>
<?php echo $judgetype->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($judgetype_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$judgetype_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $judgetype_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $judgetype_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$judgetype_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$judgetype_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$judgetype_add->terminate();
?>
