<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$judges_view = new judges_view();

// Run the page
$judges_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$judges_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$judges->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fjudgesview = currentForm = new ew.Form("fjudgesview", "view");

// Form_CustomValidate event
fjudgesview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjudgesview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjudgesview.lists["x_JudgeTypeID"] = <?php echo $judges_view->JudgeTypeID->Lookup->toClientList() ?>;
fjudgesview.lists["x_JudgeTypeID"].options = <?php echo JsonEncode($judges_view->JudgeTypeID->lookupOptions()) ?>;
fjudgesview.lists["x_CourtID"] = <?php echo $judges_view->CourtID->Lookup->toClientList() ?>;
fjudgesview.lists["x_CourtID"].options = <?php echo JsonEncode($judges_view->CourtID->lookupOptions()) ?>;
fjudgesview.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjudgesview.lists["x_TitleID"] = <?php echo $judges_view->TitleID->Lookup->toClientList() ?>;
fjudgesview.lists["x_TitleID"].options = <?php echo JsonEncode($judges_view->TitleID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$judges->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $judges_view->ExportOptions->render("body") ?>
<?php $judges_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $judges_view->showPageHeader(); ?>
<?php
$judges_view->showMessage();
?>
<?php if (!$judges_view->IsModal) { ?>
<?php if (!$judges->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($judges_view->Pager)) $judges_view->Pager = new PrevNextPager($judges_view->StartRec, $judges_view->DisplayRecs, $judges_view->TotalRecs, $judges_view->AutoHidePager) ?>
<?php if ($judges_view->Pager->RecordCount > 0 && $judges_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($judges_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $judges_view->pageUrl() ?>start=<?php echo $judges_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($judges_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $judges_view->pageUrl() ?>start=<?php echo $judges_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $judges_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($judges_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $judges_view->pageUrl() ?>start=<?php echo $judges_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($judges_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $judges_view->pageUrl() ?>start=<?php echo $judges_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $judges_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fjudgesview" id="fjudgesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($judges_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $judges_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="judges">
<input type="hidden" name="modal" value="<?php echo (int)$judges_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($judges->JudgeID->Visible) { // JudgeID ?>
	<tr id="r_JudgeID">
		<td class="<?php echo $judges_view->TableLeftColumnClass ?>"><span id="elh_judges_JudgeID"><?php echo $judges->JudgeID->caption() ?></span></td>
		<td data-name="JudgeID"<?php echo $judges->JudgeID->cellAttributes() ?>>
<span id="el_judges_JudgeID">
<span<?php echo $judges->JudgeID->viewAttributes() ?>>
<?php echo $judges->JudgeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($judges->JudgeTypeID->Visible) { // JudgeTypeID ?>
	<tr id="r_JudgeTypeID">
		<td class="<?php echo $judges_view->TableLeftColumnClass ?>"><span id="elh_judges_JudgeTypeID"><?php echo $judges->JudgeTypeID->caption() ?></span></td>
		<td data-name="JudgeTypeID"<?php echo $judges->JudgeTypeID->cellAttributes() ?>>
<span id="el_judges_JudgeTypeID">
<span<?php echo $judges->JudgeTypeID->viewAttributes() ?>>
<?php echo $judges->JudgeTypeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($judges->CourtID->Visible) { // CourtID ?>
	<tr id="r_CourtID">
		<td class="<?php echo $judges_view->TableLeftColumnClass ?>"><span id="elh_judges_CourtID"><?php echo $judges->CourtID->caption() ?></span></td>
		<td data-name="CourtID"<?php echo $judges->CourtID->cellAttributes() ?>>
<span id="el_judges_CourtID">
<span<?php echo $judges->CourtID->viewAttributes() ?>>
<?php echo $judges->CourtID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($judges->TitleID->Visible) { // TitleID ?>
	<tr id="r_TitleID">
		<td class="<?php echo $judges_view->TableLeftColumnClass ?>"><span id="elh_judges_TitleID"><?php echo $judges->TitleID->caption() ?></span></td>
		<td data-name="TitleID"<?php echo $judges->TitleID->cellAttributes() ?>>
<span id="el_judges_TitleID">
<span<?php echo $judges->TitleID->viewAttributes() ?>>
<?php echo $judges->TitleID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($judges->FirstName->Visible) { // FirstName ?>
	<tr id="r_FirstName">
		<td class="<?php echo $judges_view->TableLeftColumnClass ?>"><span id="elh_judges_FirstName"><?php echo $judges->FirstName->caption() ?></span></td>
		<td data-name="FirstName"<?php echo $judges->FirstName->cellAttributes() ?>>
<span id="el_judges_FirstName">
<span<?php echo $judges->FirstName->viewAttributes() ?>>
<?php echo $judges->FirstName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($judges->MiddleName->Visible) { // MiddleName ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $judges_view->TableLeftColumnClass ?>"><span id="elh_judges_MiddleName"><?php echo $judges->MiddleName->caption() ?></span></td>
		<td data-name="MiddleName"<?php echo $judges->MiddleName->cellAttributes() ?>>
<span id="el_judges_MiddleName">
<span<?php echo $judges->MiddleName->viewAttributes() ?>>
<?php echo $judges->MiddleName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($judges->LastName->Visible) { // LastName ?>
	<tr id="r_LastName">
		<td class="<?php echo $judges_view->TableLeftColumnClass ?>"><span id="elh_judges_LastName"><?php echo $judges->LastName->caption() ?></span></td>
		<td data-name="LastName"<?php echo $judges->LastName->cellAttributes() ?>>
<span id="el_judges_LastName">
<span<?php echo $judges->LastName->viewAttributes() ?>>
<?php echo $judges->LastName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($judges->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $judges_view->TableLeftColumnClass ?>"><span id="elh_judges_Notes"><?php echo $judges->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $judges->Notes->cellAttributes() ?>>
<span id="el_judges_Notes">
<span<?php echo $judges->Notes->viewAttributes() ?>>
<?php echo $judges->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$judges_view->IsModal) { ?>
<?php if (!$judges->isExport()) { ?>
<?php if (!isset($judges_view->Pager)) $judges_view->Pager = new PrevNextPager($judges_view->StartRec, $judges_view->DisplayRecs, $judges_view->TotalRecs, $judges_view->AutoHidePager) ?>
<?php if ($judges_view->Pager->RecordCount > 0 && $judges_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($judges_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $judges_view->pageUrl() ?>start=<?php echo $judges_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($judges_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $judges_view->pageUrl() ?>start=<?php echo $judges_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $judges_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($judges_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $judges_view->pageUrl() ?>start=<?php echo $judges_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($judges_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $judges_view->pageUrl() ?>start=<?php echo $judges_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $judges_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
<?php if ($judges->getCurrentDetailTable() <> "") { ?>
<?php
	$judges_view->DetailPages->ValidKeys = explode(",", $judges->getCurrentDetailTable());
	$firstActiveDetailTable = $judges_view->DetailPages->activePageIndex();
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav-tabs" id="judges_view_details"><!-- tabs -->
	<ul class="<?php echo $judges_view->DetailPages->navStyle() ?>"><!-- .nav -->
<?php
	if (in_array("judgecontact", explode(",", $judges->getCurrentDetailTable())) && $judgecontact->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "judgecontact") {
			$firstActiveDetailTable = "judgecontact";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $judges_view->DetailPages->pageStyle("judgecontact") ?>" href="#tab_judgecontact" data-toggle="tab"><?php echo $Language->TablePhrase("judgecontact", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $judges_view->judgecontact_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("judgeaddress", explode(",", $judges->getCurrentDetailTable())) && $judgeaddress->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "judgeaddress") {
			$firstActiveDetailTable = "judgeaddress";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $judges_view->DetailPages->pageStyle("judgeaddress") ?>" href="#tab_judgeaddress" data-toggle="tab"><?php echo $Language->TablePhrase("judgeaddress", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $judges_view->judgeaddress_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
	</ul><!-- /.nav -->
	<div class="tab-content"><!-- .tab-content -->
<?php
	if (in_array("judgecontact", explode(",", $judges->getCurrentDetailTable())) && $judgecontact->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "judgecontact")
			$firstActiveDetailTable = "judgecontact";
?>
		<div class="tab-pane<?php echo $judges_view->DetailPages->pageStyle("judgecontact") ?>" id="tab_judgecontact"><!-- page* -->
<?php include_once "judgecontactgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("judgeaddress", explode(",", $judges->getCurrentDetailTable())) && $judgeaddress->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "judgeaddress")
			$firstActiveDetailTable = "judgeaddress";
?>
		<div class="tab-pane<?php echo $judges_view->DetailPages->pageStyle("judgeaddress") ?>" id="tab_judgeaddress"><!-- page* -->
<?php include_once "judgeaddressgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
	</div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
</form>
<?php
$judges_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$judges->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$judges_view->terminate();
?>
