<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employees_list = new employees_list();

// Run the page
$employees_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employees_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$employees->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var femployeeslist = currentForm = new ew.Form("femployeeslist", "list");
femployeeslist.formKeyCountName = '<?php echo $employees_list->FormKeyCountName ?>';

// Form_CustomValidate event
femployeeslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
femployeeslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
femployeeslist.lists["x_Gender"] = <?php echo $employees_list->Gender->Lookup->toClientList() ?>;
femployeeslist.lists["x_Gender"].options = <?php echo JsonEncode($employees_list->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
var femployeeslistsrch = currentSearchForm = new ew.Form("femployeeslistsrch");

// Validate function for search
femployeeslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
femployeeslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
femployeeslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
femployeeslistsrch.lists["x_Gender"] = <?php echo $employees_list->Gender->Lookup->toClientList() ?>;
femployeeslistsrch.lists["x_Gender"].options = <?php echo JsonEncode($employees_list->Gender->options(FALSE, TRUE)) ?>;

// Filters
femployeeslistsrch.filterList = <?php echo $employees_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #7FFF00; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$employees->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($employees_list->TotalRecs > 0 && $employees_list->ExportOptions->visible()) { ?>
<?php $employees_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($employees_list->ImportOptions->visible()) { ?>
<?php $employees_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($employees_list->SearchOptions->visible()) { ?>
<?php $employees_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($employees_list->FilterOptions->visible()) { ?>
<?php $employees_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$employees_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$employees->isExport() && !$employees->CurrentAction) { ?>
<form name="femployeeslistsrch" id="femployeeslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($employees_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="femployeeslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="employees">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$employees_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$employees->RowType = ROWTYPE_SEARCH;

// Render row
$employees->resetAttributes();
$employees_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($employees->Gender->Visible) { // Gender ?>
	<div id="xsc_Gender" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $employees->Gender->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Gender" id="z_Gender" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="employees" data-field="x_Gender" data-value-separator="<?php echo $employees->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $employees->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $employees->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($employees_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($employees_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $employees_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($employees_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($employees_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($employees_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($employees_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $employees_list->showPageHeader(); ?>
<?php
$employees_list->showMessage();
?>
<?php if ($employees_list->TotalRecs > 0 || $employees->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($employees_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> employees">
<?php if (!$employees->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$employees->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($employees_list->Pager)) $employees_list->Pager = new PrevNextPager($employees_list->StartRec, $employees_list->DisplayRecs, $employees_list->TotalRecs, $employees_list->AutoHidePager) ?>
<?php if ($employees_list->Pager->RecordCount > 0 && $employees_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($employees_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $employees_list->pageUrl() ?>start=<?php echo $employees_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($employees_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $employees_list->pageUrl() ?>start=<?php echo $employees_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $employees_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($employees_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $employees_list->pageUrl() ?>start=<?php echo $employees_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($employees_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $employees_list->pageUrl() ?>start=<?php echo $employees_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $employees_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($employees_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $employees_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $employees_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $employees_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($employees_list->TotalRecs > 0 && (!$employees_list->AutoHidePageSizeSelector || $employees_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="employees">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($employees_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($employees_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($employees_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($employees_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($employees_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($employees_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($employees_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($employees_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($employees_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($employees->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $employees_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="femployeeslist" id="femployeeslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($employees_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $employees_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employees">
<div id="gmp_employees" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($employees_list->TotalRecs > 0 || $employees->isGridEdit()) { ?>
<table id="tbl_employeeslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$employees_list->RowType = ROWTYPE_HEADER;

// Render list options
$employees_list->renderListOptions();

// Render list options (header, left)
$employees_list->ListOptions->render("header", "left");
?>
<?php if ($employees->Username->Visible) { // Username ?>
	<?php if ($employees->sortUrl($employees->Username) == "") { ?>
		<th data-name="Username" class="<?php echo $employees->Username->headerCellClass() ?>"><div id="elh_employees_Username" class="employees_Username"><div class="ew-table-header-caption"><?php echo $employees->Username->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Username" class="<?php echo $employees->Username->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employees->SortUrl($employees->Username) ?>',2);"><div id="elh_employees_Username" class="employees_Username">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employees->Username->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employees->Username->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employees->Username->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employees->Password->Visible) { // Password ?>
	<?php if ($employees->sortUrl($employees->Password) == "") { ?>
		<th data-name="Password" class="<?php echo $employees->Password->headerCellClass() ?>"><div id="elh_employees_Password" class="employees_Password"><div class="ew-table-header-caption"><?php echo $employees->Password->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Password" class="<?php echo $employees->Password->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employees->SortUrl($employees->Password) ?>',2);"><div id="elh_employees_Password" class="employees_Password">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employees->Password->caption() ?></span><span class="ew-table-header-sort"><?php if ($employees->Password->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employees->Password->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employees->EmployeeTypeID->Visible) { // EmployeeTypeID ?>
	<?php if ($employees->sortUrl($employees->EmployeeTypeID) == "") { ?>
		<th data-name="EmployeeTypeID" class="<?php echo $employees->EmployeeTypeID->headerCellClass() ?>"><div id="elh_employees_EmployeeTypeID" class="employees_EmployeeTypeID"><div class="ew-table-header-caption"><?php echo $employees->EmployeeTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="EmployeeTypeID" class="<?php echo $employees->EmployeeTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employees->SortUrl($employees->EmployeeTypeID) ?>',2);"><div id="elh_employees_EmployeeTypeID" class="employees_EmployeeTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employees->EmployeeTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($employees->EmployeeTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employees->EmployeeTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employees->TitleID->Visible) { // TitleID ?>
	<?php if ($employees->sortUrl($employees->TitleID) == "") { ?>
		<th data-name="TitleID" class="<?php echo $employees->TitleID->headerCellClass() ?>"><div id="elh_employees_TitleID" class="employees_TitleID"><div class="ew-table-header-caption"><?php echo $employees->TitleID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TitleID" class="<?php echo $employees->TitleID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employees->SortUrl($employees->TitleID) ?>',2);"><div id="elh_employees_TitleID" class="employees_TitleID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employees->TitleID->caption() ?></span><span class="ew-table-header-sort"><?php if ($employees->TitleID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employees->TitleID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employees->FirstName->Visible) { // FirstName ?>
	<?php if ($employees->sortUrl($employees->FirstName) == "") { ?>
		<th data-name="FirstName" class="<?php echo $employees->FirstName->headerCellClass() ?>"><div id="elh_employees_FirstName" class="employees_FirstName"><div class="ew-table-header-caption"><?php echo $employees->FirstName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FirstName" class="<?php echo $employees->FirstName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employees->SortUrl($employees->FirstName) ?>',2);"><div id="elh_employees_FirstName" class="employees_FirstName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employees->FirstName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employees->FirstName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employees->FirstName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employees->MiddleName->Visible) { // MiddleName ?>
	<?php if ($employees->sortUrl($employees->MiddleName) == "") { ?>
		<th data-name="MiddleName" class="<?php echo $employees->MiddleName->headerCellClass() ?>"><div id="elh_employees_MiddleName" class="employees_MiddleName"><div class="ew-table-header-caption"><?php echo $employees->MiddleName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MiddleName" class="<?php echo $employees->MiddleName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employees->SortUrl($employees->MiddleName) ?>',2);"><div id="elh_employees_MiddleName" class="employees_MiddleName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employees->MiddleName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employees->MiddleName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employees->MiddleName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employees->LastName->Visible) { // LastName ?>
	<?php if ($employees->sortUrl($employees->LastName) == "") { ?>
		<th data-name="LastName" class="<?php echo $employees->LastName->headerCellClass() ?>"><div id="elh_employees_LastName" class="employees_LastName"><div class="ew-table-header-caption"><?php echo $employees->LastName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LastName" class="<?php echo $employees->LastName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employees->SortUrl($employees->LastName) ?>',2);"><div id="elh_employees_LastName" class="employees_LastName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employees->LastName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employees->LastName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employees->LastName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employees->Photo->Visible) { // Photo ?>
	<?php if ($employees->sortUrl($employees->Photo) == "") { ?>
		<th data-name="Photo" class="<?php echo $employees->Photo->headerCellClass() ?>"><div id="elh_employees_Photo" class="employees_Photo"><div class="ew-table-header-caption"><?php echo $employees->Photo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Photo" class="<?php echo $employees->Photo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employees->SortUrl($employees->Photo) ?>',2);"><div id="elh_employees_Photo" class="employees_Photo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employees->Photo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employees->Photo->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employees->Photo->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employees->BirthDate->Visible) { // BirthDate ?>
	<?php if ($employees->sortUrl($employees->BirthDate) == "") { ?>
		<th data-name="BirthDate" class="<?php echo $employees->BirthDate->headerCellClass() ?>"><div id="elh_employees_BirthDate" class="employees_BirthDate"><div class="ew-table-header-caption"><?php echo $employees->BirthDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="BirthDate" class="<?php echo $employees->BirthDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employees->SortUrl($employees->BirthDate) ?>',2);"><div id="elh_employees_BirthDate" class="employees_BirthDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employees->BirthDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($employees->BirthDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employees->BirthDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employees->Gender->Visible) { // Gender ?>
	<?php if ($employees->sortUrl($employees->Gender) == "") { ?>
		<th data-name="Gender" class="<?php echo $employees->Gender->headerCellClass() ?>"><div id="elh_employees_Gender" class="employees_Gender"><div class="ew-table-header-caption"><?php echo $employees->Gender->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Gender" class="<?php echo $employees->Gender->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employees->SortUrl($employees->Gender) ?>',2);"><div id="elh_employees_Gender" class="employees_Gender">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employees->Gender->caption() ?></span><span class="ew-table-header-sort"><?php if ($employees->Gender->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employees->Gender->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$employees_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($employees->ExportAll && $employees->isExport()) {
	$employees_list->StopRec = $employees_list->TotalRecs;
} else {

	// Set the last record to display
	if ($employees_list->TotalRecs > $employees_list->StartRec + $employees_list->DisplayRecs - 1)
		$employees_list->StopRec = $employees_list->StartRec + $employees_list->DisplayRecs - 1;
	else
		$employees_list->StopRec = $employees_list->TotalRecs;
}
$employees_list->RecCnt = $employees_list->StartRec - 1;
if ($employees_list->Recordset && !$employees_list->Recordset->EOF) {
	$employees_list->Recordset->moveFirst();
	$selectLimit = $employees_list->UseSelectLimit;
	if (!$selectLimit && $employees_list->StartRec > 1)
		$employees_list->Recordset->move($employees_list->StartRec - 1);
} elseif (!$employees->AllowAddDeleteRow && $employees_list->StopRec == 0) {
	$employees_list->StopRec = $employees->GridAddRowCount;
}

// Initialize aggregate
$employees->RowType = ROWTYPE_AGGREGATEINIT;
$employees->resetAttributes();
$employees_list->renderRow();
while ($employees_list->RecCnt < $employees_list->StopRec) {
	$employees_list->RecCnt++;
	if ($employees_list->RecCnt >= $employees_list->StartRec) {
		$employees_list->RowCnt++;

		// Set up key count
		$employees_list->KeyCount = $employees_list->RowIndex;

		// Init row class and style
		$employees->resetAttributes();
		$employees->CssClass = "";
		if ($employees->isGridAdd()) {
		} else {
			$employees_list->loadRowValues($employees_list->Recordset); // Load row values
		}
		$employees->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$employees->RowAttrs = array_merge($employees->RowAttrs, array('data-rowindex'=>$employees_list->RowCnt, 'id'=>'r' . $employees_list->RowCnt . '_employees', 'data-rowtype'=>$employees->RowType));

		// Render row
		$employees_list->renderRow();

		// Render list options
		$employees_list->renderListOptions();
?>
	<tr<?php echo $employees->rowAttributes() ?>>
<?php

// Render list options (body, left)
$employees_list->ListOptions->render("body", "left", $employees_list->RowCnt);
?>
	<?php if ($employees->Username->Visible) { // Username ?>
		<td data-name="Username"<?php echo $employees->Username->cellAttributes() ?>>
<span id="el<?php echo $employees_list->RowCnt ?>_employees_Username" class="employees_Username">
<span<?php echo $employees->Username->viewAttributes() ?>>
<?php echo $employees->Username->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employees->Password->Visible) { // Password ?>
		<td data-name="Password"<?php echo $employees->Password->cellAttributes() ?>>
<span id="el<?php echo $employees_list->RowCnt ?>_employees_Password" class="employees_Password">
<span<?php echo $employees->Password->viewAttributes() ?>>
<?php echo $employees->Password->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employees->EmployeeTypeID->Visible) { // EmployeeTypeID ?>
		<td data-name="EmployeeTypeID"<?php echo $employees->EmployeeTypeID->cellAttributes() ?>>
<span id="el<?php echo $employees_list->RowCnt ?>_employees_EmployeeTypeID" class="employees_EmployeeTypeID">
<span<?php echo $employees->EmployeeTypeID->viewAttributes() ?>>
<?php echo $employees->EmployeeTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employees->TitleID->Visible) { // TitleID ?>
		<td data-name="TitleID"<?php echo $employees->TitleID->cellAttributes() ?>>
<span id="el<?php echo $employees_list->RowCnt ?>_employees_TitleID" class="employees_TitleID">
<span<?php echo $employees->TitleID->viewAttributes() ?>>
<?php echo $employees->TitleID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employees->FirstName->Visible) { // FirstName ?>
		<td data-name="FirstName"<?php echo $employees->FirstName->cellAttributes() ?>>
<span id="el<?php echo $employees_list->RowCnt ?>_employees_FirstName" class="employees_FirstName">
<span<?php echo $employees->FirstName->viewAttributes() ?>>
<?php echo $employees->FirstName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employees->MiddleName->Visible) { // MiddleName ?>
		<td data-name="MiddleName"<?php echo $employees->MiddleName->cellAttributes() ?>>
<span id="el<?php echo $employees_list->RowCnt ?>_employees_MiddleName" class="employees_MiddleName">
<span<?php echo $employees->MiddleName->viewAttributes() ?>>
<?php echo $employees->MiddleName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employees->LastName->Visible) { // LastName ?>
		<td data-name="LastName"<?php echo $employees->LastName->cellAttributes() ?>>
<span id="el<?php echo $employees_list->RowCnt ?>_employees_LastName" class="employees_LastName">
<span<?php echo $employees->LastName->viewAttributes() ?>>
<?php echo $employees->LastName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employees->Photo->Visible) { // Photo ?>
		<td data-name="Photo"<?php echo $employees->Photo->cellAttributes() ?>>
<span id="el<?php echo $employees_list->RowCnt ?>_employees_Photo" class="employees_Photo">
<span>
<?php echo GetFileViewTag($employees->Photo, $employees->Photo->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($employees->BirthDate->Visible) { // BirthDate ?>
		<td data-name="BirthDate"<?php echo $employees->BirthDate->cellAttributes() ?>>
<span id="el<?php echo $employees_list->RowCnt ?>_employees_BirthDate" class="employees_BirthDate">
<span<?php echo $employees->BirthDate->viewAttributes() ?>>
<?php echo $employees->BirthDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employees->Gender->Visible) { // Gender ?>
		<td data-name="Gender"<?php echo $employees->Gender->cellAttributes() ?>>
<span id="el<?php echo $employees_list->RowCnt ?>_employees_Gender" class="employees_Gender">
<span<?php echo $employees->Gender->viewAttributes() ?>>
<?php echo $employees->Gender->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$employees_list->ListOptions->render("body", "right", $employees_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$employees->isGridAdd())
		$employees_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$employees->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($employees_list->Recordset)
	$employees_list->Recordset->Close();
?>
<?php if (!$employees->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$employees->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($employees_list->Pager)) $employees_list->Pager = new PrevNextPager($employees_list->StartRec, $employees_list->DisplayRecs, $employees_list->TotalRecs, $employees_list->AutoHidePager) ?>
<?php if ($employees_list->Pager->RecordCount > 0 && $employees_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($employees_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $employees_list->pageUrl() ?>start=<?php echo $employees_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($employees_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $employees_list->pageUrl() ?>start=<?php echo $employees_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $employees_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($employees_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $employees_list->pageUrl() ?>start=<?php echo $employees_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($employees_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $employees_list->pageUrl() ?>start=<?php echo $employees_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $employees_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($employees_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $employees_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $employees_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $employees_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($employees_list->TotalRecs > 0 && (!$employees_list->AutoHidePageSizeSelector || $employees_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="employees">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($employees_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($employees_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($employees_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($employees_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($employees_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($employees_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($employees_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($employees_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($employees_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($employees->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $employees_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($employees_list->TotalRecs == 0 && !$employees->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $employees_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$employees_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$employees->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$employees->isExport()) { ?>
<script>
ew.scrollableTable("gmp_employees", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$employees_list->terminate();
?>
