<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employees_delete = new employees_delete();

// Run the page
$employees_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employees_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var femployeesdelete = currentForm = new ew.Form("femployeesdelete", "delete");

// Form_CustomValidate event
femployeesdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
femployeesdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
femployeesdelete.lists["x_Gender"] = <?php echo $employees_delete->Gender->Lookup->toClientList() ?>;
femployeesdelete.lists["x_Gender"].options = <?php echo JsonEncode($employees_delete->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $employees_delete->showPageHeader(); ?>
<?php
$employees_delete->showMessage();
?>
<form name="femployeesdelete" id="femployeesdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($employees_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $employees_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employees">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($employees_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($employees->Username->Visible) { // Username ?>
		<th class="<?php echo $employees->Username->headerCellClass() ?>"><span id="elh_employees_Username" class="employees_Username"><?php echo $employees->Username->caption() ?></span></th>
<?php } ?>
<?php if ($employees->Password->Visible) { // Password ?>
		<th class="<?php echo $employees->Password->headerCellClass() ?>"><span id="elh_employees_Password" class="employees_Password"><?php echo $employees->Password->caption() ?></span></th>
<?php } ?>
<?php if ($employees->EmployeeTypeID->Visible) { // EmployeeTypeID ?>
		<th class="<?php echo $employees->EmployeeTypeID->headerCellClass() ?>"><span id="elh_employees_EmployeeTypeID" class="employees_EmployeeTypeID"><?php echo $employees->EmployeeTypeID->caption() ?></span></th>
<?php } ?>
<?php if ($employees->TitleID->Visible) { // TitleID ?>
		<th class="<?php echo $employees->TitleID->headerCellClass() ?>"><span id="elh_employees_TitleID" class="employees_TitleID"><?php echo $employees->TitleID->caption() ?></span></th>
<?php } ?>
<?php if ($employees->FirstName->Visible) { // FirstName ?>
		<th class="<?php echo $employees->FirstName->headerCellClass() ?>"><span id="elh_employees_FirstName" class="employees_FirstName"><?php echo $employees->FirstName->caption() ?></span></th>
<?php } ?>
<?php if ($employees->MiddleName->Visible) { // MiddleName ?>
		<th class="<?php echo $employees->MiddleName->headerCellClass() ?>"><span id="elh_employees_MiddleName" class="employees_MiddleName"><?php echo $employees->MiddleName->caption() ?></span></th>
<?php } ?>
<?php if ($employees->LastName->Visible) { // LastName ?>
		<th class="<?php echo $employees->LastName->headerCellClass() ?>"><span id="elh_employees_LastName" class="employees_LastName"><?php echo $employees->LastName->caption() ?></span></th>
<?php } ?>
<?php if ($employees->Photo->Visible) { // Photo ?>
		<th class="<?php echo $employees->Photo->headerCellClass() ?>"><span id="elh_employees_Photo" class="employees_Photo"><?php echo $employees->Photo->caption() ?></span></th>
<?php } ?>
<?php if ($employees->BirthDate->Visible) { // BirthDate ?>
		<th class="<?php echo $employees->BirthDate->headerCellClass() ?>"><span id="elh_employees_BirthDate" class="employees_BirthDate"><?php echo $employees->BirthDate->caption() ?></span></th>
<?php } ?>
<?php if ($employees->Gender->Visible) { // Gender ?>
		<th class="<?php echo $employees->Gender->headerCellClass() ?>"><span id="elh_employees_Gender" class="employees_Gender"><?php echo $employees->Gender->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$employees_delete->RecCnt = 0;
$i = 0;
while (!$employees_delete->Recordset->EOF) {
	$employees_delete->RecCnt++;
	$employees_delete->RowCnt++;

	// Set row properties
	$employees->resetAttributes();
	$employees->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$employees_delete->loadRowValues($employees_delete->Recordset);

	// Render row
	$employees_delete->renderRow();
?>
	<tr<?php echo $employees->rowAttributes() ?>>
<?php if ($employees->Username->Visible) { // Username ?>
		<td<?php echo $employees->Username->cellAttributes() ?>>
<span id="el<?php echo $employees_delete->RowCnt ?>_employees_Username" class="employees_Username">
<span<?php echo $employees->Username->viewAttributes() ?>>
<?php echo $employees->Username->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($employees->Password->Visible) { // Password ?>
		<td<?php echo $employees->Password->cellAttributes() ?>>
<span id="el<?php echo $employees_delete->RowCnt ?>_employees_Password" class="employees_Password">
<span<?php echo $employees->Password->viewAttributes() ?>>
<?php echo $employees->Password->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($employees->EmployeeTypeID->Visible) { // EmployeeTypeID ?>
		<td<?php echo $employees->EmployeeTypeID->cellAttributes() ?>>
<span id="el<?php echo $employees_delete->RowCnt ?>_employees_EmployeeTypeID" class="employees_EmployeeTypeID">
<span<?php echo $employees->EmployeeTypeID->viewAttributes() ?>>
<?php echo $employees->EmployeeTypeID->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($employees->TitleID->Visible) { // TitleID ?>
		<td<?php echo $employees->TitleID->cellAttributes() ?>>
<span id="el<?php echo $employees_delete->RowCnt ?>_employees_TitleID" class="employees_TitleID">
<span<?php echo $employees->TitleID->viewAttributes() ?>>
<?php echo $employees->TitleID->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($employees->FirstName->Visible) { // FirstName ?>
		<td<?php echo $employees->FirstName->cellAttributes() ?>>
<span id="el<?php echo $employees_delete->RowCnt ?>_employees_FirstName" class="employees_FirstName">
<span<?php echo $employees->FirstName->viewAttributes() ?>>
<?php echo $employees->FirstName->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($employees->MiddleName->Visible) { // MiddleName ?>
		<td<?php echo $employees->MiddleName->cellAttributes() ?>>
<span id="el<?php echo $employees_delete->RowCnt ?>_employees_MiddleName" class="employees_MiddleName">
<span<?php echo $employees->MiddleName->viewAttributes() ?>>
<?php echo $employees->MiddleName->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($employees->LastName->Visible) { // LastName ?>
		<td<?php echo $employees->LastName->cellAttributes() ?>>
<span id="el<?php echo $employees_delete->RowCnt ?>_employees_LastName" class="employees_LastName">
<span<?php echo $employees->LastName->viewAttributes() ?>>
<?php echo $employees->LastName->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($employees->Photo->Visible) { // Photo ?>
		<td<?php echo $employees->Photo->cellAttributes() ?>>
<span id="el<?php echo $employees_delete->RowCnt ?>_employees_Photo" class="employees_Photo">
<span>
<?php echo GetFileViewTag($employees->Photo, $employees->Photo->getViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($employees->BirthDate->Visible) { // BirthDate ?>
		<td<?php echo $employees->BirthDate->cellAttributes() ?>>
<span id="el<?php echo $employees_delete->RowCnt ?>_employees_BirthDate" class="employees_BirthDate">
<span<?php echo $employees->BirthDate->viewAttributes() ?>>
<?php echo $employees->BirthDate->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($employees->Gender->Visible) { // Gender ?>
		<td<?php echo $employees->Gender->cellAttributes() ?>>
<span id="el<?php echo $employees_delete->RowCnt ?>_employees_Gender" class="employees_Gender">
<span<?php echo $employees->Gender->viewAttributes() ?>>
<?php echo $employees->Gender->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$employees_delete->Recordset->moveNext();
}
$employees_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $employees_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$employees_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$employees_delete->terminate();
?>
