<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$employeecontact_preview = new employeecontact_preview();

// Run the page
$employeecontact_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employeecontact_preview->Page_Render();
?>
<?php $employeecontact_preview->showPageHeader(); ?>
<div class="card ew-grid employeecontact"><!-- .card -->
<?php if ($employeecontact_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$employeecontact_preview->renderListOptions();

// Render list options (header, left)
$employeecontact_preview->ListOptions->render("header", "left");
?>
<?php if ($employeecontact->EmployeeID->Visible) { // EmployeeID ?>
	<?php if ($employeecontact->SortUrl($employeecontact->EmployeeID) == "") { ?>
		<th class="<?php echo $employeecontact->EmployeeID->headerCellClass() ?>"><?php echo $employeecontact->EmployeeID->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $employeecontact->EmployeeID->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $employeecontact->EmployeeID->Name ?>" data-sort-order="<?php echo $employeecontact_preview->SortField == $employeecontact->EmployeeID->Name && $employeecontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $employeecontact->EmployeeID->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($employeecontact_preview->SortField == $employeecontact->EmployeeID->Name) { ?><?php if ($employeecontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($employeecontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeecontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($employeecontact->SortUrl($employeecontact->ContactTypeID) == "") { ?>
		<th class="<?php echo $employeecontact->ContactTypeID->headerCellClass() ?>"><?php echo $employeecontact->ContactTypeID->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $employeecontact->ContactTypeID->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $employeecontact->ContactTypeID->Name ?>" data-sort-order="<?php echo $employeecontact_preview->SortField == $employeecontact->ContactTypeID->Name && $employeecontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $employeecontact->ContactTypeID->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($employeecontact_preview->SortField == $employeecontact->ContactTypeID->Name) { ?><?php if ($employeecontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($employeecontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeecontact->Contact->Visible) { // Contact ?>
	<?php if ($employeecontact->SortUrl($employeecontact->Contact) == "") { ?>
		<th class="<?php echo $employeecontact->Contact->headerCellClass() ?>"><?php echo $employeecontact->Contact->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $employeecontact->Contact->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $employeecontact->Contact->Name ?>" data-sort-order="<?php echo $employeecontact_preview->SortField == $employeecontact->Contact->Name && $employeecontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $employeecontact->Contact->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($employeecontact_preview->SortField == $employeecontact->Contact->Name) { ?><?php if ($employeecontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($employeecontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeecontact->Notes->Visible) { // Notes ?>
	<?php if ($employeecontact->SortUrl($employeecontact->Notes) == "") { ?>
		<th class="<?php echo $employeecontact->Notes->headerCellClass() ?>"><?php echo $employeecontact->Notes->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $employeecontact->Notes->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $employeecontact->Notes->Name ?>" data-sort-order="<?php echo $employeecontact_preview->SortField == $employeecontact->Notes->Name && $employeecontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $employeecontact->Notes->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($employeecontact_preview->SortField == $employeecontact->Notes->Name) { ?><?php if ($employeecontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($employeecontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeecontact->Primary->Visible) { // Primary ?>
	<?php if ($employeecontact->SortUrl($employeecontact->Primary) == "") { ?>
		<th class="<?php echo $employeecontact->Primary->headerCellClass() ?>"><?php echo $employeecontact->Primary->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $employeecontact->Primary->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $employeecontact->Primary->Name ?>" data-sort-order="<?php echo $employeecontact_preview->SortField == $employeecontact->Primary->Name && $employeecontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $employeecontact->Primary->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($employeecontact_preview->SortField == $employeecontact->Primary->Name) { ?><?php if ($employeecontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($employeecontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$employeecontact_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$employeecontact_preview->RecCount = 0;
$employeecontact_preview->RowCnt = 0;
while ($employeecontact_preview->Recordset && !$employeecontact_preview->Recordset->EOF) {

	// Init row class and style
	$employeecontact_preview->RecCount++;
	$employeecontact_preview->RowCnt++;
	$employeecontact_preview->CssStyle = "";
	$employeecontact_preview->loadListRowValues($employeecontact_preview->Recordset);

	// Render row
	$employeecontact_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$employeecontact_preview->resetAttributes();
	$employeecontact_preview->renderListRow();

	// Render list options
	$employeecontact_preview->renderListOptions();
?>
	<tr<?php echo $employeecontact_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$employeecontact_preview->ListOptions->render("body", "left", $employeecontact_preview->RowCnt);
?>
<?php if ($employeecontact->EmployeeID->Visible) { // EmployeeID ?>
		<!-- EmployeeID -->
		<td<?php echo $employeecontact->EmployeeID->cellAttributes() ?>>
<span<?php echo $employeecontact->EmployeeID->viewAttributes() ?>>
<?php echo $employeecontact->EmployeeID->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($employeecontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<!-- ContactTypeID -->
		<td<?php echo $employeecontact->ContactTypeID->cellAttributes() ?>>
<span<?php echo $employeecontact->ContactTypeID->viewAttributes() ?>>
<?php echo $employeecontact->ContactTypeID->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($employeecontact->Contact->Visible) { // Contact ?>
		<!-- Contact -->
		<td<?php echo $employeecontact->Contact->cellAttributes() ?>>
<span<?php echo $employeecontact->Contact->viewAttributes() ?>>
<?php echo $employeecontact->Contact->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($employeecontact->Notes->Visible) { // Notes ?>
		<!-- Notes -->
		<td<?php echo $employeecontact->Notes->cellAttributes() ?>>
<span<?php echo $employeecontact->Notes->viewAttributes() ?>>
<?php echo $employeecontact->Notes->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($employeecontact->Primary->Visible) { // Primary ?>
		<!-- Primary -->
		<td<?php echo $employeecontact->Primary->cellAttributes() ?>>
<span<?php echo $employeecontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($employeecontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $employeecontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $employeecontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$employeecontact_preview->ListOptions->render("body", "right", $employeecontact_preview->RowCnt);
?>
	</tr>
<?php
	$employeecontact_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($employeecontact_preview->TotalRecs > 0) { ?>
<?php if (!isset($employeecontact_preview->Pager)) $employeecontact_preview->Pager = new PrevNextPager($employeecontact_preview->StartRec, $employeecontact_preview->DisplayRecs, $employeecontact_preview->TotalRecs) ?>
<?php if ($employeecontact_preview->Pager->RecordCount > 0 && $employeecontact_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($employeecontact_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $employeecontact_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($employeecontact_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $employeecontact_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($employeecontact_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $employeecontact_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($employeecontact_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $employeecontact_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $employeecontact_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $employeecontact_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $employeecontact_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($employeecontact_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$employeecontact_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($employeecontact_preview->Recordset)
	$employeecontact_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$employeecontact_preview->terminate();
?>
