<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courts_delete = new courts_delete();

// Run the page
$courts_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courts_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fcourtsdelete = currentForm = new ew.Form("fcourtsdelete", "delete");

// Form_CustomValidate event
fcourtsdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtsdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtsdelete.lists["x_CourtTypeID"] = <?php echo $courts_delete->CourtTypeID->Lookup->toClientList() ?>;
fcourtsdelete.lists["x_CourtTypeID"].options = <?php echo JsonEncode($courts_delete->CourtTypeID->lookupOptions()) ?>;
fcourtsdelete.lists["x_ChamberID"] = <?php echo $courts_delete->ChamberID->Lookup->toClientList() ?>;
fcourtsdelete.lists["x_ChamberID"].options = <?php echo JsonEncode($courts_delete->ChamberID->lookupOptions()) ?>;
fcourtsdelete.lists["x_CourtLocationID"] = <?php echo $courts_delete->CourtLocationID->Lookup->toClientList() ?>;
fcourtsdelete.lists["x_CourtLocationID"].options = <?php echo JsonEncode($courts_delete->CourtLocationID->lookupOptions()) ?>;
fcourtsdelete.lists["x_GovernorateID"] = <?php echo $courts_delete->GovernorateID->Lookup->toClientList() ?>;
fcourtsdelete.lists["x_GovernorateID"].options = <?php echo JsonEncode($courts_delete->GovernorateID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $courts_delete->showPageHeader(); ?>
<?php
$courts_delete->showMessage();
?>
<form name="fcourtsdelete" id="fcourtsdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($courts_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courts_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courts">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($courts_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($courts->Court->Visible) { // Court ?>
		<th class="<?php echo $courts->Court->headerCellClass() ?>"><span id="elh_courts_Court" class="courts_Court"><?php echo $courts->Court->caption() ?></span></th>
<?php } ?>
<?php if ($courts->CourtTypeID->Visible) { // CourtTypeID ?>
		<th class="<?php echo $courts->CourtTypeID->headerCellClass() ?>"><span id="elh_courts_CourtTypeID" class="courts_CourtTypeID"><?php echo $courts->CourtTypeID->caption() ?></span></th>
<?php } ?>
<?php if ($courts->ChamberID->Visible) { // ChamberID ?>
		<th class="<?php echo $courts->ChamberID->headerCellClass() ?>"><span id="elh_courts_ChamberID" class="courts_ChamberID"><?php echo $courts->ChamberID->caption() ?></span></th>
<?php } ?>
<?php if ($courts->CourtLocationID->Visible) { // CourtLocationID ?>
		<th class="<?php echo $courts->CourtLocationID->headerCellClass() ?>"><span id="elh_courts_CourtLocationID" class="courts_CourtLocationID"><?php echo $courts->CourtLocationID->caption() ?></span></th>
<?php } ?>
<?php if ($courts->GovernorateID->Visible) { // GovernorateID ?>
		<th class="<?php echo $courts->GovernorateID->headerCellClass() ?>"><span id="elh_courts_GovernorateID" class="courts_GovernorateID"><?php echo $courts->GovernorateID->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$courts_delete->RecCnt = 0;
$i = 0;
while (!$courts_delete->Recordset->EOF) {
	$courts_delete->RecCnt++;
	$courts_delete->RowCnt++;

	// Set row properties
	$courts->resetAttributes();
	$courts->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$courts_delete->loadRowValues($courts_delete->Recordset);

	// Render row
	$courts_delete->renderRow();
?>
	<tr<?php echo $courts->rowAttributes() ?>>
<?php if ($courts->Court->Visible) { // Court ?>
		<td<?php echo $courts->Court->cellAttributes() ?>>
<span id="el<?php echo $courts_delete->RowCnt ?>_courts_Court" class="courts_Court">
<span<?php echo $courts->Court->viewAttributes() ?>>
<?php echo $courts->Court->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($courts->CourtTypeID->Visible) { // CourtTypeID ?>
		<td<?php echo $courts->CourtTypeID->cellAttributes() ?>>
<span id="el<?php echo $courts_delete->RowCnt ?>_courts_CourtTypeID" class="courts_CourtTypeID">
<span<?php echo $courts->CourtTypeID->viewAttributes() ?>>
<?php echo $courts->CourtTypeID->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($courts->ChamberID->Visible) { // ChamberID ?>
		<td<?php echo $courts->ChamberID->cellAttributes() ?>>
<span id="el<?php echo $courts_delete->RowCnt ?>_courts_ChamberID" class="courts_ChamberID">
<span<?php echo $courts->ChamberID->viewAttributes() ?>>
<?php echo $courts->ChamberID->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($courts->CourtLocationID->Visible) { // CourtLocationID ?>
		<td<?php echo $courts->CourtLocationID->cellAttributes() ?>>
<span id="el<?php echo $courts_delete->RowCnt ?>_courts_CourtLocationID" class="courts_CourtLocationID">
<span<?php echo $courts->CourtLocationID->viewAttributes() ?>>
<?php echo $courts->CourtLocationID->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($courts->GovernorateID->Visible) { // GovernorateID ?>
		<td<?php echo $courts->GovernorateID->cellAttributes() ?>>
<span id="el<?php echo $courts_delete->RowCnt ?>_courts_GovernorateID" class="courts_GovernorateID">
<span<?php echo $courts->GovernorateID->viewAttributes() ?>>
<?php echo $courts->GovernorateID->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$courts_delete->Recordset->moveNext();
}
$courts_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $courts_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$courts_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$courts_delete->terminate();
?>
