<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courtgender_addopt = new courtgender_addopt();

// Run the page
$courtgender_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courtgender_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fcourtgenderaddopt = currentForm = new ew.Form("fcourtgenderaddopt", "addopt");

// Validate form
fcourtgenderaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($courtgender_addopt->CourtSortID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtSortID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courtgender->CourtSortID->caption(), $courtgender->CourtSortID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courtgender_addopt->CourtGender->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtGender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courtgender->CourtGender->caption(), $courtgender->CourtGender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($courtgender_addopt->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courtgender->Notes->caption(), $courtgender->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcourtgenderaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtgenderaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtgenderaddopt.lists["x_CourtSortID"] = <?php echo $courtgender_addopt->CourtSortID->Lookup->toClientList() ?>;
fcourtgenderaddopt.lists["x_CourtSortID"].options = <?php echo JsonEncode($courtgender_addopt->CourtSortID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $courtgender_addopt->showPageHeader(); ?>
<?php
$courtgender_addopt->showMessage();
?>
<form name="fcourtgenderaddopt" id="fcourtgenderaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($courtgender_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courtgender_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $courtgender_addopt->TableVar ?>">
<?php if ($courtgender->CourtSortID->Visible) { // CourtSortID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_CourtSortID"><?php echo $courtgender->CourtSortID->caption() ?><?php echo ($courtgender->CourtSortID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courtgender" data-field="x_CourtSortID" data-value-separator="<?php echo $courtgender->CourtSortID->displayValueSeparatorAttribute() ?>" id="x_CourtSortID" name="x_CourtSortID"<?php echo $courtgender->CourtSortID->editAttributes() ?>>
		<?php echo $courtgender->CourtSortID->selectOptionListHtml("x_CourtSortID") ?>
	</select>
</div>
<?php echo $courtgender->CourtSortID->Lookup->getParamTag("p_x_CourtSortID") ?>
</div>
	</div>
<?php } ?>
<?php if ($courtgender->CourtGender->Visible) { // CourtGender ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_CourtGender"><?php echo $courtgender->CourtGender->caption() ?><?php echo ($courtgender->CourtGender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="courtgender" data-field="x_CourtGender" name="x_CourtGender" id="x_CourtGender" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($courtgender->CourtGender->getPlaceHolder()) ?>" value="<?php echo $courtgender->CourtGender->EditValue ?>"<?php echo $courtgender->CourtGender->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($courtgender->Notes->Visible) { // Notes ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Notes"><?php echo $courtgender->Notes->caption() ?><?php echo ($courtgender->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="courtgender" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courtgender->Notes->getPlaceHolder()) ?>" value="<?php echo $courtgender->Notes->EditValue ?>"<?php echo $courtgender->Notes->editAttributes() ?>>
</div>
	</div>
<?php } ?>
</form>
<?php
$courtgender_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$courtgender_addopt->terminate();
?>
