<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$clients_search = new clients_search();

// Run the page
$clients_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$clients_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($clients_search->IsModal) { ?>
var fclientssearch = currentAdvancedSearchForm = new ew.Form("fclientssearch", "search");
<?php } else { ?>
var fclientssearch = currentForm = new ew.Form("fclientssearch", "search");
<?php } ?>

// Form_CustomValidate event
fclientssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclientssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclientssearch.lists["x_ClientTypeID"] = <?php echo $clients_search->ClientTypeID->Lookup->toClientList() ?>;
fclientssearch.lists["x_ClientTypeID"].options = <?php echo JsonEncode($clients_search->ClientTypeID->lookupOptions()) ?>;
fclientssearch.lists["x_ClientGroupID"] = <?php echo $clients_search->ClientGroupID->Lookup->toClientList() ?>;
fclientssearch.lists["x_ClientGroupID"].options = <?php echo JsonEncode($clients_search->ClientGroupID->lookupOptions()) ?>;
fclientssearch.autoSuggests["x_ClientGroupID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fclientssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $clients_search->showPageHeader(); ?>
<?php
$clients_search->showMessage();
?>
<form name="fclientssearch" id="fclientssearch" class="<?php echo $clients_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($clients_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $clients_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="clients">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$clients_search->IsModal ?>">
<?php if (!$clients_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($clients_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_clientssearch" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($clients->ClientID->Visible) { // ClientID ?>
<?php if ($clients_search->IsMobileOrModal) { ?>
	<div id="r_ClientID" class="form-group row">
		<label class="<?php echo $clients_search->LeftColumnClass ?>"><span id="elh_clients_ClientID"><?php echo $clients->ClientID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientID" id="z_ClientID" value="="></span>
		</label>
		<div class="<?php echo $clients_search->RightColumnClass ?>"><div<?php echo $clients->ClientID->cellAttributes() ?>>
			<span id="el_clients_ClientID">
<input type="text" data-table="clients" data-field="x_ClientID" name="x_ClientID" id="x_ClientID" placeholder="<?php echo HtmlEncode($clients->ClientID->getPlaceHolder()) ?>" value="<?php echo $clients->ClientID->EditValue ?>"<?php echo $clients->ClientID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientID">
		<td class="<?php echo $clients_search->TableLeftColumnClass ?>"><span id="elh_clients_ClientID"><?php echo $clients->ClientID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientID" id="z_ClientID" value="="></span></td>
		<td<?php echo $clients->ClientID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_clients_ClientID">
<input type="text" data-table="clients" data-field="x_ClientID" name="x_ClientID" id="x_ClientID" placeholder="<?php echo HtmlEncode($clients->ClientID->getPlaceHolder()) ?>" value="<?php echo $clients->ClientID->EditValue ?>"<?php echo $clients->ClientID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->ClientTypeID->Visible) { // ClientTypeID ?>
<?php if ($clients_search->IsMobileOrModal) { ?>
	<div id="r_ClientTypeID" class="form-group row">
		<label for="x_ClientTypeID" class="<?php echo $clients_search->LeftColumnClass ?>"><span id="elh_clients_ClientTypeID"><?php echo $clients->ClientTypeID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientTypeID" id="z_ClientTypeID" value="="></span>
		</label>
		<div class="<?php echo $clients_search->RightColumnClass ?>"><div<?php echo $clients->ClientTypeID->cellAttributes() ?>>
			<span id="el_clients_ClientTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="clients" data-field="x_ClientTypeID" data-value-separator="<?php echo $clients->ClientTypeID->displayValueSeparatorAttribute() ?>" id="x_ClientTypeID" name="x_ClientTypeID"<?php echo $clients->ClientTypeID->editAttributes() ?>>
		<?php echo $clients->ClientTypeID->selectOptionListHtml("x_ClientTypeID") ?>
	</select>
</div>
<?php echo $clients->ClientTypeID->Lookup->getParamTag("p_x_ClientTypeID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientTypeID">
		<td class="<?php echo $clients_search->TableLeftColumnClass ?>"><span id="elh_clients_ClientTypeID"><?php echo $clients->ClientTypeID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientTypeID" id="z_ClientTypeID" value="="></span></td>
		<td<?php echo $clients->ClientTypeID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_clients_ClientTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="clients" data-field="x_ClientTypeID" data-value-separator="<?php echo $clients->ClientTypeID->displayValueSeparatorAttribute() ?>" id="x_ClientTypeID" name="x_ClientTypeID"<?php echo $clients->ClientTypeID->editAttributes() ?>>
		<?php echo $clients->ClientTypeID->selectOptionListHtml("x_ClientTypeID") ?>
	</select>
</div>
<?php echo $clients->ClientTypeID->Lookup->getParamTag("p_x_ClientTypeID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->ClientGroupID->Visible) { // ClientGroupID ?>
<?php if ($clients_search->IsMobileOrModal) { ?>
	<div id="r_ClientGroupID" class="form-group row">
		<label class="<?php echo $clients_search->LeftColumnClass ?>"><span id="elh_clients_ClientGroupID"><?php echo $clients->ClientGroupID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientGroupID" id="z_ClientGroupID" value="="></span>
		</label>
		<div class="<?php echo $clients_search->RightColumnClass ?>"><div<?php echo $clients->ClientGroupID->cellAttributes() ?>>
			<span id="el_clients_ClientGroupID">
<?php
$wrkonchange = "" . trim(@$clients->ClientGroupID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$clients->ClientGroupID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientGroupID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientGroupID" id="sv_x_ClientGroupID" value="<?php echo RemoveHtml($clients->ClientGroupID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($clients->ClientGroupID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($clients->ClientGroupID->getPlaceHolder()) ?>"<?php echo $clients->ClientGroupID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($clients->ClientGroupID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientGroupID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($clients->ClientGroupID->ReadOnly || $clients->ClientGroupID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="clients" data-field="x_ClientGroupID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $clients->ClientGroupID->displayValueSeparatorAttribute() ?>" name="x_ClientGroupID" id="x_ClientGroupID" value="<?php echo HtmlEncode($clients->ClientGroupID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclientssearch.createAutoSuggest({"id":"x_ClientGroupID","forceSelect":false});
</script>
<?php echo $clients->ClientGroupID->Lookup->getParamTag("p_x_ClientGroupID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientGroupID">
		<td class="<?php echo $clients_search->TableLeftColumnClass ?>"><span id="elh_clients_ClientGroupID"><?php echo $clients->ClientGroupID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientGroupID" id="z_ClientGroupID" value="="></span></td>
		<td<?php echo $clients->ClientGroupID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_clients_ClientGroupID">
<?php
$wrkonchange = "" . trim(@$clients->ClientGroupID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$clients->ClientGroupID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientGroupID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientGroupID" id="sv_x_ClientGroupID" value="<?php echo RemoveHtml($clients->ClientGroupID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($clients->ClientGroupID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($clients->ClientGroupID->getPlaceHolder()) ?>"<?php echo $clients->ClientGroupID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($clients->ClientGroupID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientGroupID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($clients->ClientGroupID->ReadOnly || $clients->ClientGroupID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="clients" data-field="x_ClientGroupID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $clients->ClientGroupID->displayValueSeparatorAttribute() ?>" name="x_ClientGroupID" id="x_ClientGroupID" value="<?php echo HtmlEncode($clients->ClientGroupID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclientssearch.createAutoSuggest({"id":"x_ClientGroupID","forceSelect":false});
</script>
<?php echo $clients->ClientGroupID->Lookup->getParamTag("p_x_ClientGroupID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->FirstName->Visible) { // FirstName ?>
<?php if ($clients_search->IsMobileOrModal) { ?>
	<div id="r_FirstName" class="form-group row">
		<label for="x_FirstName" class="<?php echo $clients_search->LeftColumnClass ?>"><span id="elh_clients_FirstName"><?php echo $clients->FirstName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FirstName" id="z_FirstName" value="LIKE"></span>
		</label>
		<div class="<?php echo $clients_search->RightColumnClass ?>"><div<?php echo $clients->FirstName->cellAttributes() ?>>
			<span id="el_clients_FirstName">
<input type="text" data-table="clients" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->FirstName->getPlaceHolder()) ?>" value="<?php echo $clients->FirstName->EditValue ?>"<?php echo $clients->FirstName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_FirstName">
		<td class="<?php echo $clients_search->TableLeftColumnClass ?>"><span id="elh_clients_FirstName"><?php echo $clients->FirstName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FirstName" id="z_FirstName" value="LIKE"></span></td>
		<td<?php echo $clients->FirstName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_clients_FirstName">
<input type="text" data-table="clients" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->FirstName->getPlaceHolder()) ?>" value="<?php echo $clients->FirstName->EditValue ?>"<?php echo $clients->FirstName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->MiddleName->Visible) { // MiddleName ?>
<?php if ($clients_search->IsMobileOrModal) { ?>
	<div id="r_MiddleName" class="form-group row">
		<label for="x_MiddleName" class="<?php echo $clients_search->LeftColumnClass ?>"><span id="elh_clients_MiddleName"><?php echo $clients->MiddleName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_MiddleName" id="z_MiddleName" value="LIKE"></span>
		</label>
		<div class="<?php echo $clients_search->RightColumnClass ?>"><div<?php echo $clients->MiddleName->cellAttributes() ?>>
			<span id="el_clients_MiddleName">
<input type="text" data-table="clients" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($clients->MiddleName->getPlaceHolder()) ?>" value="<?php echo $clients->MiddleName->EditValue ?>"<?php echo $clients->MiddleName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $clients_search->TableLeftColumnClass ?>"><span id="elh_clients_MiddleName"><?php echo $clients->MiddleName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_MiddleName" id="z_MiddleName" value="LIKE"></span></td>
		<td<?php echo $clients->MiddleName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_clients_MiddleName">
<input type="text" data-table="clients" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($clients->MiddleName->getPlaceHolder()) ?>" value="<?php echo $clients->MiddleName->EditValue ?>"<?php echo $clients->MiddleName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->LastName->Visible) { // LastName ?>
<?php if ($clients_search->IsMobileOrModal) { ?>
	<div id="r_LastName" class="form-group row">
		<label for="x_LastName" class="<?php echo $clients_search->LeftColumnClass ?>"><span id="elh_clients_LastName"><?php echo $clients->LastName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_LastName" id="z_LastName" value="LIKE"></span>
		</label>
		<div class="<?php echo $clients_search->RightColumnClass ?>"><div<?php echo $clients->LastName->cellAttributes() ?>>
			<span id="el_clients_LastName">
<input type="text" data-table="clients" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->LastName->getPlaceHolder()) ?>" value="<?php echo $clients->LastName->EditValue ?>"<?php echo $clients->LastName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_LastName">
		<td class="<?php echo $clients_search->TableLeftColumnClass ?>"><span id="elh_clients_LastName"><?php echo $clients->LastName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_LastName" id="z_LastName" value="LIKE"></span></td>
		<td<?php echo $clients->LastName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_clients_LastName">
<input type="text" data-table="clients" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->LastName->getPlaceHolder()) ?>" value="<?php echo $clients->LastName->EditValue ?>"<?php echo $clients->LastName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->PartnersName->Visible) { // PartnersName ?>
<?php if ($clients_search->IsMobileOrModal) { ?>
	<div id="r_PartnersName" class="form-group row">
		<label for="x_PartnersName" class="<?php echo $clients_search->LeftColumnClass ?>"><span id="elh_clients_PartnersName"><?php echo $clients->PartnersName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_PartnersName" id="z_PartnersName" value="LIKE"></span>
		</label>
		<div class="<?php echo $clients_search->RightColumnClass ?>"><div<?php echo $clients->PartnersName->cellAttributes() ?>>
			<span id="el_clients_PartnersName">
<input type="text" data-table="clients" data-field="x_PartnersName" name="x_PartnersName" id="x_PartnersName" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($clients->PartnersName->getPlaceHolder()) ?>" value="<?php echo $clients->PartnersName->EditValue ?>"<?php echo $clients->PartnersName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_PartnersName">
		<td class="<?php echo $clients_search->TableLeftColumnClass ?>"><span id="elh_clients_PartnersName"><?php echo $clients->PartnersName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_PartnersName" id="z_PartnersName" value="LIKE"></span></td>
		<td<?php echo $clients->PartnersName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_clients_PartnersName">
<input type="text" data-table="clients" data-field="x_PartnersName" name="x_PartnersName" id="x_PartnersName" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($clients->PartnersName->getPlaceHolder()) ?>" value="<?php echo $clients->PartnersName->EditValue ?>"<?php echo $clients->PartnersName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->CompanyName->Visible) { // CompanyName ?>
<?php if ($clients_search->IsMobileOrModal) { ?>
	<div id="r_CompanyName" class="form-group row">
		<label for="x_CompanyName" class="<?php echo $clients_search->LeftColumnClass ?>"><span id="elh_clients_CompanyName"><?php echo $clients->CompanyName->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CompanyName" id="z_CompanyName" value="LIKE"></span>
		</label>
		<div class="<?php echo $clients_search->RightColumnClass ?>"><div<?php echo $clients->CompanyName->cellAttributes() ?>>
			<span id="el_clients_CompanyName">
<input type="text" data-table="clients" data-field="x_CompanyName" name="x_CompanyName" id="x_CompanyName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->CompanyName->getPlaceHolder()) ?>" value="<?php echo $clients->CompanyName->EditValue ?>"<?php echo $clients->CompanyName->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CompanyName">
		<td class="<?php echo $clients_search->TableLeftColumnClass ?>"><span id="elh_clients_CompanyName"><?php echo $clients->CompanyName->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CompanyName" id="z_CompanyName" value="LIKE"></span></td>
		<td<?php echo $clients->CompanyName->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_clients_CompanyName">
<input type="text" data-table="clients" data-field="x_CompanyName" name="x_CompanyName" id="x_CompanyName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($clients->CompanyName->getPlaceHolder()) ?>" value="<?php echo $clients->CompanyName->EditValue ?>"<?php echo $clients->CompanyName->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients->Notes->Visible) { // Notes ?>
<?php if ($clients_search->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label class="<?php echo $clients_search->LeftColumnClass ?>"><span id="elh_clients_Notes"><?php echo $clients->Notes->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span>
		</label>
		<div class="<?php echo $clients_search->RightColumnClass ?>"><div<?php echo $clients->Notes->cellAttributes() ?>>
			<span id="el_clients_Notes">
<input type="text" data-table="clients" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($clients->Notes->getPlaceHolder()) ?>" value="<?php echo $clients->Notes->EditValue ?>"<?php echo $clients->Notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $clients_search->TableLeftColumnClass ?>"><span id="elh_clients_Notes"><?php echo $clients->Notes->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span></td>
		<td<?php echo $clients->Notes->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_clients_Notes">
<input type="text" data-table="clients" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($clients->Notes->getPlaceHolder()) ?>" value="<?php echo $clients->Notes->EditValue ?>"<?php echo $clients->Notes->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($clients_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$clients_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $clients_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$clients_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$clients_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$clients_search->terminate();
?>
