<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$clients_list = new clients_list();

// Run the page
$clients_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$clients_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$clients->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fclientslist = currentForm = new ew.Form("fclientslist", "list");
fclientslist.formKeyCountName = '<?php echo $clients_list->FormKeyCountName ?>';

// Form_CustomValidate event
fclientslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclientslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclientslist.lists["x_ClientTypeID"] = <?php echo $clients_list->ClientTypeID->Lookup->toClientList() ?>;
fclientslist.lists["x_ClientTypeID"].options = <?php echo JsonEncode($clients_list->ClientTypeID->lookupOptions()) ?>;
fclientslist.lists["x_ClientGroupID"] = <?php echo $clients_list->ClientGroupID->Lookup->toClientList() ?>;
fclientslist.lists["x_ClientGroupID"].options = <?php echo JsonEncode($clients_list->ClientGroupID->lookupOptions()) ?>;
fclientslist.autoSuggests["x_ClientGroupID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclientslist.lists["x_TitleID"] = <?php echo $clients_list->TitleID->Lookup->toClientList() ?>;
fclientslist.lists["x_TitleID"].options = <?php echo JsonEncode($clients_list->TitleID->lookupOptions()) ?>;
fclientslist.lists["x_Gender"] = <?php echo $clients_list->Gender->Lookup->toClientList() ?>;
fclientslist.lists["x_Gender"].options = <?php echo JsonEncode($clients_list->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
var fclientslistsrch = currentSearchForm = new ew.Form("fclientslistsrch");

// Validate function for search
fclientslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fclientslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclientslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclientslistsrch.lists["x_Gender"] = <?php echo $clients_list->Gender->Lookup->toClientList() ?>;
fclientslistsrch.lists["x_Gender"].options = <?php echo JsonEncode($clients_list->Gender->options(FALSE, TRUE)) ?>;

// Filters
fclientslistsrch.filterList = <?php echo $clients_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFF0F5; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$clients->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($clients_list->TotalRecs > 0 && $clients_list->ExportOptions->visible()) { ?>
<?php $clients_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($clients_list->ImportOptions->visible()) { ?>
<?php $clients_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($clients_list->SearchOptions->visible()) { ?>
<?php $clients_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($clients_list->FilterOptions->visible()) { ?>
<?php $clients_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$clients_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$clients->isExport() && !$clients->CurrentAction) { ?>
<form name="fclientslistsrch" id="fclientslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($clients_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fclientslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="clients">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$clients_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$clients->RowType = ROWTYPE_SEARCH;

// Render row
$clients->resetAttributes();
$clients_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($clients->Gender->Visible) { // Gender ?>
	<div id="xsc_Gender" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $clients->Gender->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Gender" id="z_Gender" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="clients" data-field="x_Gender" data-value-separator="<?php echo $clients->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $clients->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $clients->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($clients_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($clients_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $clients_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($clients_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($clients_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($clients_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($clients_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $clients_list->showPageHeader(); ?>
<?php
$clients_list->showMessage();
?>
<?php if ($clients_list->TotalRecs > 0 || $clients->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($clients_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> clients">
<?php if (!$clients->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$clients->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($clients_list->Pager)) $clients_list->Pager = new PrevNextPager($clients_list->StartRec, $clients_list->DisplayRecs, $clients_list->TotalRecs, $clients_list->AutoHidePager) ?>
<?php if ($clients_list->Pager->RecordCount > 0 && $clients_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($clients_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $clients_list->pageUrl() ?>start=<?php echo $clients_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($clients_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $clients_list->pageUrl() ?>start=<?php echo $clients_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $clients_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($clients_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $clients_list->pageUrl() ?>start=<?php echo $clients_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($clients_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $clients_list->pageUrl() ?>start=<?php echo $clients_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $clients_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($clients_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $clients_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $clients_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $clients_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($clients_list->TotalRecs > 0 && (!$clients_list->AutoHidePageSizeSelector || $clients_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="clients">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($clients_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($clients_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($clients_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($clients_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($clients_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($clients_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($clients_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($clients_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($clients_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($clients->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $clients_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fclientslist" id="fclientslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($clients_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $clients_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="clients">
<div id="gmp_clients" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($clients_list->TotalRecs > 0 || $clients->isGridEdit()) { ?>
<table id="tbl_clientslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$clients_list->RowType = ROWTYPE_HEADER;

// Render list options
$clients_list->renderListOptions();

// Render list options (header, left)
$clients_list->ListOptions->render("header", "left");
?>
<?php if ($clients->ClientTypeID->Visible) { // ClientTypeID ?>
	<?php if ($clients->sortUrl($clients->ClientTypeID) == "") { ?>
		<th data-name="ClientTypeID" class="<?php echo $clients->ClientTypeID->headerCellClass() ?>"><div id="elh_clients_ClientTypeID" class="clients_ClientTypeID"><div class="ew-table-header-caption"><?php echo $clients->ClientTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientTypeID" class="<?php echo $clients->ClientTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->ClientTypeID) ?>',2);"><div id="elh_clients_ClientTypeID" class="clients_ClientTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->ClientTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($clients->ClientTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->ClientTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->ClientGroupID->Visible) { // ClientGroupID ?>
	<?php if ($clients->sortUrl($clients->ClientGroupID) == "") { ?>
		<th data-name="ClientGroupID" class="<?php echo $clients->ClientGroupID->headerCellClass() ?>"><div id="elh_clients_ClientGroupID" class="clients_ClientGroupID"><div class="ew-table-header-caption"><?php echo $clients->ClientGroupID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientGroupID" class="<?php echo $clients->ClientGroupID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->ClientGroupID) ?>',2);"><div id="elh_clients_ClientGroupID" class="clients_ClientGroupID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->ClientGroupID->caption() ?></span><span class="ew-table-header-sort"><?php if ($clients->ClientGroupID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->ClientGroupID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->TitleID->Visible) { // TitleID ?>
	<?php if ($clients->sortUrl($clients->TitleID) == "") { ?>
		<th data-name="TitleID" class="<?php echo $clients->TitleID->headerCellClass() ?>"><div id="elh_clients_TitleID" class="clients_TitleID"><div class="ew-table-header-caption"><?php echo $clients->TitleID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TitleID" class="<?php echo $clients->TitleID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->TitleID) ?>',2);"><div id="elh_clients_TitleID" class="clients_TitleID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->TitleID->caption() ?></span><span class="ew-table-header-sort"><?php if ($clients->TitleID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->TitleID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->FirstName->Visible) { // FirstName ?>
	<?php if ($clients->sortUrl($clients->FirstName) == "") { ?>
		<th data-name="FirstName" class="<?php echo $clients->FirstName->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_clients_FirstName" class="clients_FirstName"><div class="ew-table-header-caption"><?php echo $clients->FirstName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FirstName" class="<?php echo $clients->FirstName->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->FirstName) ?>',2);"><div id="elh_clients_FirstName" class="clients_FirstName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->FirstName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients->FirstName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->FirstName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->MiddleName->Visible) { // MiddleName ?>
	<?php if ($clients->sortUrl($clients->MiddleName) == "") { ?>
		<th data-name="MiddleName" class="<?php echo $clients->MiddleName->headerCellClass() ?>"><div id="elh_clients_MiddleName" class="clients_MiddleName"><div class="ew-table-header-caption"><?php echo $clients->MiddleName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MiddleName" class="<?php echo $clients->MiddleName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->MiddleName) ?>',2);"><div id="elh_clients_MiddleName" class="clients_MiddleName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->MiddleName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients->MiddleName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->MiddleName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->LastName->Visible) { // LastName ?>
	<?php if ($clients->sortUrl($clients->LastName) == "") { ?>
		<th data-name="LastName" class="<?php echo $clients->LastName->headerCellClass() ?>"><div id="elh_clients_LastName" class="clients_LastName"><div class="ew-table-header-caption"><?php echo $clients->LastName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LastName" class="<?php echo $clients->LastName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->LastName) ?>',2);"><div id="elh_clients_LastName" class="clients_LastName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->LastName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients->LastName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->LastName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->PartnersName->Visible) { // PartnersName ?>
	<?php if ($clients->sortUrl($clients->PartnersName) == "") { ?>
		<th data-name="PartnersName" class="<?php echo $clients->PartnersName->headerCellClass() ?>"><div id="elh_clients_PartnersName" class="clients_PartnersName"><div class="ew-table-header-caption"><?php echo $clients->PartnersName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PartnersName" class="<?php echo $clients->PartnersName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->PartnersName) ?>',2);"><div id="elh_clients_PartnersName" class="clients_PartnersName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->PartnersName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients->PartnersName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->PartnersName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->CompanyName->Visible) { // CompanyName ?>
	<?php if ($clients->sortUrl($clients->CompanyName) == "") { ?>
		<th data-name="CompanyName" class="<?php echo $clients->CompanyName->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_clients_CompanyName" class="clients_CompanyName"><div class="ew-table-header-caption"><?php echo $clients->CompanyName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CompanyName" class="<?php echo $clients->CompanyName->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->CompanyName) ?>',2);"><div id="elh_clients_CompanyName" class="clients_CompanyName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->CompanyName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients->CompanyName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->CompanyName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->ContactPerson->Visible) { // ContactPerson ?>
	<?php if ($clients->sortUrl($clients->ContactPerson) == "") { ?>
		<th data-name="ContactPerson" class="<?php echo $clients->ContactPerson->headerCellClass() ?>"><div id="elh_clients_ContactPerson" class="clients_ContactPerson"><div class="ew-table-header-caption"><?php echo $clients->ContactPerson->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ContactPerson" class="<?php echo $clients->ContactPerson->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->ContactPerson) ?>',2);"><div id="elh_clients_ContactPerson" class="clients_ContactPerson">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->ContactPerson->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients->ContactPerson->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->ContactPerson->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->WorkNature->Visible) { // WorkNature ?>
	<?php if ($clients->sortUrl($clients->WorkNature) == "") { ?>
		<th data-name="WorkNature" class="<?php echo $clients->WorkNature->headerCellClass() ?>"><div id="elh_clients_WorkNature" class="clients_WorkNature"><div class="ew-table-header-caption"><?php echo $clients->WorkNature->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="WorkNature" class="<?php echo $clients->WorkNature->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->WorkNature) ?>',2);"><div id="elh_clients_WorkNature" class="clients_WorkNature">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->WorkNature->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients->WorkNature->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->WorkNature->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->JobTitle->Visible) { // JobTitle ?>
	<?php if ($clients->sortUrl($clients->JobTitle) == "") { ?>
		<th data-name="JobTitle" class="<?php echo $clients->JobTitle->headerCellClass() ?>"><div id="elh_clients_JobTitle" class="clients_JobTitle"><div class="ew-table-header-caption"><?php echo $clients->JobTitle->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JobTitle" class="<?php echo $clients->JobTitle->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->JobTitle) ?>',2);"><div id="elh_clients_JobTitle" class="clients_JobTitle">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->JobTitle->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients->JobTitle->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->JobTitle->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->Photo->Visible) { // Photo ?>
	<?php if ($clients->sortUrl($clients->Photo) == "") { ?>
		<th data-name="Photo" class="<?php echo $clients->Photo->headerCellClass() ?>"><div id="elh_clients_Photo" class="clients_Photo"><div class="ew-table-header-caption"><?php echo $clients->Photo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Photo" class="<?php echo $clients->Photo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->Photo) ?>',2);"><div id="elh_clients_Photo" class="clients_Photo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->Photo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients->Photo->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->Photo->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->BirthDate->Visible) { // BirthDate ?>
	<?php if ($clients->sortUrl($clients->BirthDate) == "") { ?>
		<th data-name="BirthDate" class="<?php echo $clients->BirthDate->headerCellClass() ?>"><div id="elh_clients_BirthDate" class="clients_BirthDate"><div class="ew-table-header-caption"><?php echo $clients->BirthDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="BirthDate" class="<?php echo $clients->BirthDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->BirthDate) ?>',2);"><div id="elh_clients_BirthDate" class="clients_BirthDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->BirthDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($clients->BirthDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->BirthDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients->Gender->Visible) { // Gender ?>
	<?php if ($clients->sortUrl($clients->Gender) == "") { ?>
		<th data-name="Gender" class="<?php echo $clients->Gender->headerCellClass() ?>"><div id="elh_clients_Gender" class="clients_Gender"><div class="ew-table-header-caption"><?php echo $clients->Gender->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Gender" class="<?php echo $clients->Gender->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients->SortUrl($clients->Gender) ?>',2);"><div id="elh_clients_Gender" class="clients_Gender">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients->Gender->caption() ?></span><span class="ew-table-header-sort"><?php if ($clients->Gender->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients->Gender->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$clients_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($clients->ExportAll && $clients->isExport()) {
	$clients_list->StopRec = $clients_list->TotalRecs;
} else {

	// Set the last record to display
	if ($clients_list->TotalRecs > $clients_list->StartRec + $clients_list->DisplayRecs - 1)
		$clients_list->StopRec = $clients_list->StartRec + $clients_list->DisplayRecs - 1;
	else
		$clients_list->StopRec = $clients_list->TotalRecs;
}
$clients_list->RecCnt = $clients_list->StartRec - 1;
if ($clients_list->Recordset && !$clients_list->Recordset->EOF) {
	$clients_list->Recordset->moveFirst();
	$selectLimit = $clients_list->UseSelectLimit;
	if (!$selectLimit && $clients_list->StartRec > 1)
		$clients_list->Recordset->move($clients_list->StartRec - 1);
} elseif (!$clients->AllowAddDeleteRow && $clients_list->StopRec == 0) {
	$clients_list->StopRec = $clients->GridAddRowCount;
}

// Initialize aggregate
$clients->RowType = ROWTYPE_AGGREGATEINIT;
$clients->resetAttributes();
$clients_list->renderRow();
while ($clients_list->RecCnt < $clients_list->StopRec) {
	$clients_list->RecCnt++;
	if ($clients_list->RecCnt >= $clients_list->StartRec) {
		$clients_list->RowCnt++;

		// Set up key count
		$clients_list->KeyCount = $clients_list->RowIndex;

		// Init row class and style
		$clients->resetAttributes();
		$clients->CssClass = "";
		if ($clients->isGridAdd()) {
		} else {
			$clients_list->loadRowValues($clients_list->Recordset); // Load row values
		}
		$clients->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$clients->RowAttrs = array_merge($clients->RowAttrs, array('data-rowindex'=>$clients_list->RowCnt, 'id'=>'r' . $clients_list->RowCnt . '_clients', 'data-rowtype'=>$clients->RowType));

		// Render row
		$clients_list->renderRow();

		// Render list options
		$clients_list->renderListOptions();
?>
	<tr<?php echo $clients->rowAttributes() ?>>
<?php

// Render list options (body, left)
$clients_list->ListOptions->render("body", "left", $clients_list->RowCnt);
?>
	<?php if ($clients->ClientTypeID->Visible) { // ClientTypeID ?>
		<td data-name="ClientTypeID"<?php echo $clients->ClientTypeID->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_ClientTypeID" class="clients_ClientTypeID">
<span<?php echo $clients->ClientTypeID->viewAttributes() ?>>
<?php echo $clients->ClientTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->ClientGroupID->Visible) { // ClientGroupID ?>
		<td data-name="ClientGroupID"<?php echo $clients->ClientGroupID->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_ClientGroupID" class="clients_ClientGroupID">
<span<?php echo $clients->ClientGroupID->viewAttributes() ?>>
<?php echo $clients->ClientGroupID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->TitleID->Visible) { // TitleID ?>
		<td data-name="TitleID"<?php echo $clients->TitleID->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_TitleID" class="clients_TitleID">
<span<?php echo $clients->TitleID->viewAttributes() ?>>
<?php echo $clients->TitleID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->FirstName->Visible) { // FirstName ?>
		<td data-name="FirstName"<?php echo $clients->FirstName->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_FirstName" class="clients_FirstName">
<span<?php echo $clients->FirstName->viewAttributes() ?>>
<?php echo $clients->FirstName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->MiddleName->Visible) { // MiddleName ?>
		<td data-name="MiddleName"<?php echo $clients->MiddleName->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_MiddleName" class="clients_MiddleName">
<span<?php echo $clients->MiddleName->viewAttributes() ?>>
<?php echo $clients->MiddleName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->LastName->Visible) { // LastName ?>
		<td data-name="LastName"<?php echo $clients->LastName->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_LastName" class="clients_LastName">
<span<?php echo $clients->LastName->viewAttributes() ?>>
<?php echo $clients->LastName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->PartnersName->Visible) { // PartnersName ?>
		<td data-name="PartnersName"<?php echo $clients->PartnersName->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_PartnersName" class="clients_PartnersName">
<span<?php echo $clients->PartnersName->viewAttributes() ?>>
<?php echo $clients->PartnersName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->CompanyName->Visible) { // CompanyName ?>
		<td data-name="CompanyName"<?php echo $clients->CompanyName->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_CompanyName" class="clients_CompanyName">
<span<?php echo $clients->CompanyName->viewAttributes() ?>>
<?php echo $clients->CompanyName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->ContactPerson->Visible) { // ContactPerson ?>
		<td data-name="ContactPerson"<?php echo $clients->ContactPerson->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_ContactPerson" class="clients_ContactPerson">
<span<?php echo $clients->ContactPerson->viewAttributes() ?>>
<?php echo $clients->ContactPerson->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->WorkNature->Visible) { // WorkNature ?>
		<td data-name="WorkNature"<?php echo $clients->WorkNature->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_WorkNature" class="clients_WorkNature">
<span<?php echo $clients->WorkNature->viewAttributes() ?>>
<?php echo $clients->WorkNature->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->JobTitle->Visible) { // JobTitle ?>
		<td data-name="JobTitle"<?php echo $clients->JobTitle->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_JobTitle" class="clients_JobTitle">
<span<?php echo $clients->JobTitle->viewAttributes() ?>>
<?php echo $clients->JobTitle->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->Photo->Visible) { // Photo ?>
		<td data-name="Photo"<?php echo $clients->Photo->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_Photo" class="clients_Photo">
<span>
<?php echo GetFileViewTag($clients->Photo, $clients->Photo->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->BirthDate->Visible) { // BirthDate ?>
		<td data-name="BirthDate"<?php echo $clients->BirthDate->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_BirthDate" class="clients_BirthDate">
<span<?php echo $clients->BirthDate->viewAttributes() ?>>
<?php echo $clients->BirthDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients->Gender->Visible) { // Gender ?>
		<td data-name="Gender"<?php echo $clients->Gender->cellAttributes() ?>>
<span id="el<?php echo $clients_list->RowCnt ?>_clients_Gender" class="clients_Gender">
<span<?php echo $clients->Gender->viewAttributes() ?>>
<?php echo $clients->Gender->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$clients_list->ListOptions->render("body", "right", $clients_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$clients->isGridAdd())
		$clients_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$clients->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($clients_list->Recordset)
	$clients_list->Recordset->Close();
?>
<?php if (!$clients->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$clients->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($clients_list->Pager)) $clients_list->Pager = new PrevNextPager($clients_list->StartRec, $clients_list->DisplayRecs, $clients_list->TotalRecs, $clients_list->AutoHidePager) ?>
<?php if ($clients_list->Pager->RecordCount > 0 && $clients_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($clients_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $clients_list->pageUrl() ?>start=<?php echo $clients_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($clients_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $clients_list->pageUrl() ?>start=<?php echo $clients_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $clients_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($clients_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $clients_list->pageUrl() ?>start=<?php echo $clients_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($clients_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $clients_list->pageUrl() ?>start=<?php echo $clients_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $clients_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($clients_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $clients_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $clients_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $clients_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($clients_list->TotalRecs > 0 && (!$clients_list->AutoHidePageSizeSelector || $clients_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="clients">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($clients_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($clients_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($clients_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($clients_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($clients_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($clients_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($clients_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($clients_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($clients_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($clients->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $clients_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($clients_list->TotalRecs == 0 && !$clients->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $clients_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$clients_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$clients->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$clients->isExport()) { ?>
<script>
ew.scrollableTable("gmp_clients", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$clients_list->terminate();
?>
