<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$clients2_list = new clients2_list();

// Run the page
$clients2_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$clients2_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$clients2->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fclients2list = currentForm = new ew.Form("fclients2list", "list");
fclients2list.formKeyCountName = '<?php echo $clients2_list->FormKeyCountName ?>';

// Form_CustomValidate event
fclients2list.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclients2list.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclients2list.lists["x_ClientTypeID"] = <?php echo $clients2_list->ClientTypeID->Lookup->toClientList() ?>;
fclients2list.lists["x_ClientTypeID"].options = <?php echo JsonEncode($clients2_list->ClientTypeID->lookupOptions()) ?>;
fclients2list.lists["x_ClientGroupID"] = <?php echo $clients2_list->ClientGroupID->Lookup->toClientList() ?>;
fclients2list.lists["x_ClientGroupID"].options = <?php echo JsonEncode($clients2_list->ClientGroupID->lookupOptions()) ?>;
fclients2list.autoSuggests["x_ClientGroupID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclients2list.lists["x_TitleID"] = <?php echo $clients2_list->TitleID->Lookup->toClientList() ?>;
fclients2list.lists["x_TitleID"].options = <?php echo JsonEncode($clients2_list->TitleID->lookupOptions()) ?>;
fclients2list.lists["x_Gender"] = <?php echo $clients2_list->Gender->Lookup->toClientList() ?>;
fclients2list.lists["x_Gender"].options = <?php echo JsonEncode($clients2_list->Gender->options(FALSE, TRUE)) ?>;

// Form object for search
var fclients2listsrch = currentSearchForm = new ew.Form("fclients2listsrch");

// Validate function for search
fclients2listsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fclients2listsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclients2listsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclients2listsrch.lists["x_Gender"] = <?php echo $clients2_list->Gender->Lookup->toClientList() ?>;
fclients2listsrch.lists["x_Gender"].options = <?php echo JsonEncode($clients2_list->Gender->options(FALSE, TRUE)) ?>;

// Filters
fclients2listsrch.filterList = <?php echo $clients2_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$clients2->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($clients2_list->TotalRecs > 0 && $clients2_list->ExportOptions->visible()) { ?>
<?php $clients2_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($clients2_list->ImportOptions->visible()) { ?>
<?php $clients2_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($clients2_list->SearchOptions->visible()) { ?>
<?php $clients2_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($clients2_list->FilterOptions->visible()) { ?>
<?php $clients2_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$clients2_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$clients2->isExport() && !$clients2->CurrentAction) { ?>
<form name="fclients2listsrch" id="fclients2listsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($clients2_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fclients2listsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="clients2">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$clients2_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$clients2->RowType = ROWTYPE_SEARCH;

// Render row
$clients2->resetAttributes();
$clients2_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($clients2->Gender->Visible) { // Gender ?>
	<div id="xsc_Gender" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $clients2->Gender->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Gender" id="z_Gender" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="clients2" data-field="x_Gender" data-value-separator="<?php echo $clients2->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $clients2->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $clients2->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($clients2_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($clients2_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $clients2_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($clients2_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($clients2_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($clients2_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($clients2_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $clients2_list->showPageHeader(); ?>
<?php
$clients2_list->showMessage();
?>
<?php if ($clients2_list->TotalRecs > 0 || $clients2->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($clients2_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> clients2">
<?php if (!$clients2->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$clients2->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($clients2_list->Pager)) $clients2_list->Pager = new PrevNextPager($clients2_list->StartRec, $clients2_list->DisplayRecs, $clients2_list->TotalRecs, $clients2_list->AutoHidePager) ?>
<?php if ($clients2_list->Pager->RecordCount > 0 && $clients2_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($clients2_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $clients2_list->pageUrl() ?>start=<?php echo $clients2_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($clients2_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $clients2_list->pageUrl() ?>start=<?php echo $clients2_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $clients2_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($clients2_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $clients2_list->pageUrl() ?>start=<?php echo $clients2_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($clients2_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $clients2_list->pageUrl() ?>start=<?php echo $clients2_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $clients2_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($clients2_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $clients2_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $clients2_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $clients2_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($clients2_list->TotalRecs > 0 && (!$clients2_list->AutoHidePageSizeSelector || $clients2_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="clients2">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($clients2_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($clients2_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($clients2_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($clients2_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($clients2_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($clients2_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($clients2_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($clients2_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($clients2_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($clients2->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $clients2_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fclients2list" id="fclients2list" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($clients2_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $clients2_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="clients2">
<div id="gmp_clients2" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($clients2_list->TotalRecs > 0 || $clients2->isGridEdit()) { ?>
<table id="tbl_clients2list" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$clients2_list->RowType = ROWTYPE_HEADER;

// Render list options
$clients2_list->renderListOptions();

// Render list options (header, left)
$clients2_list->ListOptions->render("header", "left");
?>
<?php if ($clients2->ClientTypeID->Visible) { // ClientTypeID ?>
	<?php if ($clients2->sortUrl($clients2->ClientTypeID) == "") { ?>
		<th data-name="ClientTypeID" class="<?php echo $clients2->ClientTypeID->headerCellClass() ?>"><div id="elh_clients2_ClientTypeID" class="clients2_ClientTypeID"><div class="ew-table-header-caption"><?php echo $clients2->ClientTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientTypeID" class="<?php echo $clients2->ClientTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->ClientTypeID) ?>',2);"><div id="elh_clients2_ClientTypeID" class="clients2_ClientTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->ClientTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($clients2->ClientTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->ClientTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->ClientGroupID->Visible) { // ClientGroupID ?>
	<?php if ($clients2->sortUrl($clients2->ClientGroupID) == "") { ?>
		<th data-name="ClientGroupID" class="<?php echo $clients2->ClientGroupID->headerCellClass() ?>"><div id="elh_clients2_ClientGroupID" class="clients2_ClientGroupID"><div class="ew-table-header-caption"><?php echo $clients2->ClientGroupID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientGroupID" class="<?php echo $clients2->ClientGroupID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->ClientGroupID) ?>',2);"><div id="elh_clients2_ClientGroupID" class="clients2_ClientGroupID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->ClientGroupID->caption() ?></span><span class="ew-table-header-sort"><?php if ($clients2->ClientGroupID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->ClientGroupID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->WorkNature->Visible) { // WorkNature ?>
	<?php if ($clients2->sortUrl($clients2->WorkNature) == "") { ?>
		<th data-name="WorkNature" class="<?php echo $clients2->WorkNature->headerCellClass() ?>"><div id="elh_clients2_WorkNature" class="clients2_WorkNature"><div class="ew-table-header-caption"><?php echo $clients2->WorkNature->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="WorkNature" class="<?php echo $clients2->WorkNature->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->WorkNature) ?>',2);"><div id="elh_clients2_WorkNature" class="clients2_WorkNature">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->WorkNature->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients2->WorkNature->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->WorkNature->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->CompanyName->Visible) { // CompanyName ?>
	<?php if ($clients2->sortUrl($clients2->CompanyName) == "") { ?>
		<th data-name="CompanyName" class="<?php echo $clients2->CompanyName->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_clients2_CompanyName" class="clients2_CompanyName"><div class="ew-table-header-caption"><?php echo $clients2->CompanyName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CompanyName" class="<?php echo $clients2->CompanyName->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->CompanyName) ?>',2);"><div id="elh_clients2_CompanyName" class="clients2_CompanyName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->CompanyName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients2->CompanyName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->CompanyName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->TitleID->Visible) { // TitleID ?>
	<?php if ($clients2->sortUrl($clients2->TitleID) == "") { ?>
		<th data-name="TitleID" class="<?php echo $clients2->TitleID->headerCellClass() ?>"><div id="elh_clients2_TitleID" class="clients2_TitleID"><div class="ew-table-header-caption"><?php echo $clients2->TitleID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TitleID" class="<?php echo $clients2->TitleID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->TitleID) ?>',2);"><div id="elh_clients2_TitleID" class="clients2_TitleID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->TitleID->caption() ?></span><span class="ew-table-header-sort"><?php if ($clients2->TitleID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->TitleID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->FirstName->Visible) { // FirstName ?>
	<?php if ($clients2->sortUrl($clients2->FirstName) == "") { ?>
		<th data-name="FirstName" class="<?php echo $clients2->FirstName->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_clients2_FirstName" class="clients2_FirstName"><div class="ew-table-header-caption"><?php echo $clients2->FirstName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FirstName" class="<?php echo $clients2->FirstName->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->FirstName) ?>',2);"><div id="elh_clients2_FirstName" class="clients2_FirstName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->FirstName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients2->FirstName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->FirstName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->MiddleName->Visible) { // MiddleName ?>
	<?php if ($clients2->sortUrl($clients2->MiddleName) == "") { ?>
		<th data-name="MiddleName" class="<?php echo $clients2->MiddleName->headerCellClass() ?>"><div id="elh_clients2_MiddleName" class="clients2_MiddleName"><div class="ew-table-header-caption"><?php echo $clients2->MiddleName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MiddleName" class="<?php echo $clients2->MiddleName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->MiddleName) ?>',2);"><div id="elh_clients2_MiddleName" class="clients2_MiddleName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->MiddleName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients2->MiddleName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->MiddleName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->LastName->Visible) { // LastName ?>
	<?php if ($clients2->sortUrl($clients2->LastName) == "") { ?>
		<th data-name="LastName" class="<?php echo $clients2->LastName->headerCellClass() ?>"><div id="elh_clients2_LastName" class="clients2_LastName"><div class="ew-table-header-caption"><?php echo $clients2->LastName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LastName" class="<?php echo $clients2->LastName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->LastName) ?>',2);"><div id="elh_clients2_LastName" class="clients2_LastName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->LastName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients2->LastName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->LastName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->PartnersName->Visible) { // PartnersName ?>
	<?php if ($clients2->sortUrl($clients2->PartnersName) == "") { ?>
		<th data-name="PartnersName" class="<?php echo $clients2->PartnersName->headerCellClass() ?>"><div id="elh_clients2_PartnersName" class="clients2_PartnersName"><div class="ew-table-header-caption"><?php echo $clients2->PartnersName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PartnersName" class="<?php echo $clients2->PartnersName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->PartnersName) ?>',2);"><div id="elh_clients2_PartnersName" class="clients2_PartnersName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->PartnersName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients2->PartnersName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->PartnersName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->ContactPerson->Visible) { // ContactPerson ?>
	<?php if ($clients2->sortUrl($clients2->ContactPerson) == "") { ?>
		<th data-name="ContactPerson" class="<?php echo $clients2->ContactPerson->headerCellClass() ?>"><div id="elh_clients2_ContactPerson" class="clients2_ContactPerson"><div class="ew-table-header-caption"><?php echo $clients2->ContactPerson->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ContactPerson" class="<?php echo $clients2->ContactPerson->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->ContactPerson) ?>',2);"><div id="elh_clients2_ContactPerson" class="clients2_ContactPerson">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->ContactPerson->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients2->ContactPerson->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->ContactPerson->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->JobTitle->Visible) { // JobTitle ?>
	<?php if ($clients2->sortUrl($clients2->JobTitle) == "") { ?>
		<th data-name="JobTitle" class="<?php echo $clients2->JobTitle->headerCellClass() ?>"><div id="elh_clients2_JobTitle" class="clients2_JobTitle"><div class="ew-table-header-caption"><?php echo $clients2->JobTitle->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JobTitle" class="<?php echo $clients2->JobTitle->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->JobTitle) ?>',2);"><div id="elh_clients2_JobTitle" class="clients2_JobTitle">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->JobTitle->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients2->JobTitle->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->JobTitle->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->Photo->Visible) { // Photo ?>
	<?php if ($clients2->sortUrl($clients2->Photo) == "") { ?>
		<th data-name="Photo" class="<?php echo $clients2->Photo->headerCellClass() ?>"><div id="elh_clients2_Photo" class="clients2_Photo"><div class="ew-table-header-caption"><?php echo $clients2->Photo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Photo" class="<?php echo $clients2->Photo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->Photo) ?>',2);"><div id="elh_clients2_Photo" class="clients2_Photo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->Photo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($clients2->Photo->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->Photo->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->BirthDate->Visible) { // BirthDate ?>
	<?php if ($clients2->sortUrl($clients2->BirthDate) == "") { ?>
		<th data-name="BirthDate" class="<?php echo $clients2->BirthDate->headerCellClass() ?>"><div id="elh_clients2_BirthDate" class="clients2_BirthDate"><div class="ew-table-header-caption"><?php echo $clients2->BirthDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="BirthDate" class="<?php echo $clients2->BirthDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->BirthDate) ?>',2);"><div id="elh_clients2_BirthDate" class="clients2_BirthDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->BirthDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($clients2->BirthDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->BirthDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clients2->Gender->Visible) { // Gender ?>
	<?php if ($clients2->sortUrl($clients2->Gender) == "") { ?>
		<th data-name="Gender" class="<?php echo $clients2->Gender->headerCellClass() ?>"><div id="elh_clients2_Gender" class="clients2_Gender"><div class="ew-table-header-caption"><?php echo $clients2->Gender->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Gender" class="<?php echo $clients2->Gender->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $clients2->SortUrl($clients2->Gender) ?>',2);"><div id="elh_clients2_Gender" class="clients2_Gender">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $clients2->Gender->caption() ?></span><span class="ew-table-header-sort"><?php if ($clients2->Gender->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($clients2->Gender->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$clients2_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($clients2->ExportAll && $clients2->isExport()) {
	$clients2_list->StopRec = $clients2_list->TotalRecs;
} else {

	// Set the last record to display
	if ($clients2_list->TotalRecs > $clients2_list->StartRec + $clients2_list->DisplayRecs - 1)
		$clients2_list->StopRec = $clients2_list->StartRec + $clients2_list->DisplayRecs - 1;
	else
		$clients2_list->StopRec = $clients2_list->TotalRecs;
}
$clients2_list->RecCnt = $clients2_list->StartRec - 1;
if ($clients2_list->Recordset && !$clients2_list->Recordset->EOF) {
	$clients2_list->Recordset->moveFirst();
	$selectLimit = $clients2_list->UseSelectLimit;
	if (!$selectLimit && $clients2_list->StartRec > 1)
		$clients2_list->Recordset->move($clients2_list->StartRec - 1);
} elseif (!$clients2->AllowAddDeleteRow && $clients2_list->StopRec == 0) {
	$clients2_list->StopRec = $clients2->GridAddRowCount;
}

// Initialize aggregate
$clients2->RowType = ROWTYPE_AGGREGATEINIT;
$clients2->resetAttributes();
$clients2_list->renderRow();
while ($clients2_list->RecCnt < $clients2_list->StopRec) {
	$clients2_list->RecCnt++;
	if ($clients2_list->RecCnt >= $clients2_list->StartRec) {
		$clients2_list->RowCnt++;

		// Set up key count
		$clients2_list->KeyCount = $clients2_list->RowIndex;

		// Init row class and style
		$clients2->resetAttributes();
		$clients2->CssClass = "";
		if ($clients2->isGridAdd()) {
		} else {
			$clients2_list->loadRowValues($clients2_list->Recordset); // Load row values
		}
		$clients2->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$clients2->RowAttrs = array_merge($clients2->RowAttrs, array('data-rowindex'=>$clients2_list->RowCnt, 'id'=>'r' . $clients2_list->RowCnt . '_clients2', 'data-rowtype'=>$clients2->RowType));

		// Render row
		$clients2_list->renderRow();

		// Render list options
		$clients2_list->renderListOptions();
?>
	<tr<?php echo $clients2->rowAttributes() ?>>
<?php

// Render list options (body, left)
$clients2_list->ListOptions->render("body", "left", $clients2_list->RowCnt);
?>
	<?php if ($clients2->ClientTypeID->Visible) { // ClientTypeID ?>
		<td data-name="ClientTypeID"<?php echo $clients2->ClientTypeID->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_ClientTypeID" class="clients2_ClientTypeID">
<span<?php echo $clients2->ClientTypeID->viewAttributes() ?>>
<?php echo $clients2->ClientTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->ClientGroupID->Visible) { // ClientGroupID ?>
		<td data-name="ClientGroupID"<?php echo $clients2->ClientGroupID->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_ClientGroupID" class="clients2_ClientGroupID">
<span<?php echo $clients2->ClientGroupID->viewAttributes() ?>>
<?php echo $clients2->ClientGroupID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->WorkNature->Visible) { // WorkNature ?>
		<td data-name="WorkNature"<?php echo $clients2->WorkNature->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_WorkNature" class="clients2_WorkNature">
<span<?php echo $clients2->WorkNature->viewAttributes() ?>>
<?php echo $clients2->WorkNature->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->CompanyName->Visible) { // CompanyName ?>
		<td data-name="CompanyName"<?php echo $clients2->CompanyName->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_CompanyName" class="clients2_CompanyName">
<span<?php echo $clients2->CompanyName->viewAttributes() ?>>
<?php echo $clients2->CompanyName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->TitleID->Visible) { // TitleID ?>
		<td data-name="TitleID"<?php echo $clients2->TitleID->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_TitleID" class="clients2_TitleID">
<span<?php echo $clients2->TitleID->viewAttributes() ?>>
<?php echo $clients2->TitleID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->FirstName->Visible) { // FirstName ?>
		<td data-name="FirstName"<?php echo $clients2->FirstName->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_FirstName" class="clients2_FirstName">
<span<?php echo $clients2->FirstName->viewAttributes() ?>>
<?php echo $clients2->FirstName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->MiddleName->Visible) { // MiddleName ?>
		<td data-name="MiddleName"<?php echo $clients2->MiddleName->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_MiddleName" class="clients2_MiddleName">
<span<?php echo $clients2->MiddleName->viewAttributes() ?>>
<?php echo $clients2->MiddleName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->LastName->Visible) { // LastName ?>
		<td data-name="LastName"<?php echo $clients2->LastName->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_LastName" class="clients2_LastName">
<span<?php echo $clients2->LastName->viewAttributes() ?>>
<?php echo $clients2->LastName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->PartnersName->Visible) { // PartnersName ?>
		<td data-name="PartnersName"<?php echo $clients2->PartnersName->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_PartnersName" class="clients2_PartnersName">
<span<?php echo $clients2->PartnersName->viewAttributes() ?>>
<?php echo $clients2->PartnersName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->ContactPerson->Visible) { // ContactPerson ?>
		<td data-name="ContactPerson"<?php echo $clients2->ContactPerson->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_ContactPerson" class="clients2_ContactPerson">
<span<?php echo $clients2->ContactPerson->viewAttributes() ?>>
<?php echo $clients2->ContactPerson->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->JobTitle->Visible) { // JobTitle ?>
		<td data-name="JobTitle"<?php echo $clients2->JobTitle->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_JobTitle" class="clients2_JobTitle">
<span<?php echo $clients2->JobTitle->viewAttributes() ?>>
<?php echo $clients2->JobTitle->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->Photo->Visible) { // Photo ?>
		<td data-name="Photo"<?php echo $clients2->Photo->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_Photo" class="clients2_Photo">
<span>
<?php echo GetFileViewTag($clients2->Photo, $clients2->Photo->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->BirthDate->Visible) { // BirthDate ?>
		<td data-name="BirthDate"<?php echo $clients2->BirthDate->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_BirthDate" class="clients2_BirthDate">
<span<?php echo $clients2->BirthDate->viewAttributes() ?>>
<?php echo $clients2->BirthDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($clients2->Gender->Visible) { // Gender ?>
		<td data-name="Gender"<?php echo $clients2->Gender->cellAttributes() ?>>
<span id="el<?php echo $clients2_list->RowCnt ?>_clients2_Gender" class="clients2_Gender">
<span<?php echo $clients2->Gender->viewAttributes() ?>>
<?php echo $clients2->Gender->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$clients2_list->ListOptions->render("body", "right", $clients2_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$clients2->isGridAdd())
		$clients2_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$clients2->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($clients2_list->Recordset)
	$clients2_list->Recordset->Close();
?>
<?php if (!$clients2->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$clients2->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($clients2_list->Pager)) $clients2_list->Pager = new PrevNextPager($clients2_list->StartRec, $clients2_list->DisplayRecs, $clients2_list->TotalRecs, $clients2_list->AutoHidePager) ?>
<?php if ($clients2_list->Pager->RecordCount > 0 && $clients2_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($clients2_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $clients2_list->pageUrl() ?>start=<?php echo $clients2_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($clients2_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $clients2_list->pageUrl() ?>start=<?php echo $clients2_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $clients2_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($clients2_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $clients2_list->pageUrl() ?>start=<?php echo $clients2_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($clients2_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $clients2_list->pageUrl() ?>start=<?php echo $clients2_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $clients2_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($clients2_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $clients2_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $clients2_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $clients2_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($clients2_list->TotalRecs > 0 && (!$clients2_list->AutoHidePageSizeSelector || $clients2_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="clients2">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($clients2_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($clients2_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($clients2_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($clients2_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($clients2_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($clients2_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($clients2_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($clients2_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($clients2_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($clients2->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $clients2_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($clients2_list->TotalRecs == 0 && !$clients2->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $clients2_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$clients2_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$clients2->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$clients2->isExport()) { ?>
<script>
ew.scrollableTable("gmp_clients2", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$clients2_list->terminate();
?>
