<?php
namespace PHPMaker2019\project_germanos;

/**
 * Table class for complaints
 */
class complaints extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $ComplaintID;
	public $CaseNumber;
	public $FileNumber;
	public $ComplaintDate;
	public $ComplaintTime;
	public $Complaint;
	public $ComplaintEn;
	public $NextComplaintDate;
	public $NextComplaintTime;
	public $CaseID;
	public $Notes;
	public $_Case;
	public $LawyerID;
	public $JudgeID;
	public $ClientID;
	public $LitigantID;
	public $CourtID;
	public $CourtTypeID;
	public $CourtGenderID;
	public $LawyerName;
	public $JudgeName;
	public $_UserID;
	public $CreatedBy;
	public $CreatedDate;
	public $UpdatedBy;
	public $UpdatedDate;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'complaints';
		$this->TableName = 'complaints';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`complaints`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = TRUE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "AND";

		// ComplaintID
		$this->ComplaintID = new DbField('complaints', 'complaints', 'x_ComplaintID', 'ComplaintID', '`ComplaintID`', '`ComplaintID`', 3, -1, FALSE, '`ComplaintID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->ComplaintID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->ComplaintID->IsPrimaryKey = TRUE; // Primary key field
		$this->ComplaintID->Sortable = TRUE; // Allow sort
		$this->ComplaintID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ComplaintID'] = &$this->ComplaintID;

		// CaseNumber
		$this->CaseNumber = new DbField('complaints', 'complaints', 'x_CaseNumber', 'CaseNumber', '`CaseNumber`', '`CaseNumber`', 200, -1, FALSE, '`CaseNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseNumber->Sortable = TRUE; // Allow sort
		$this->fields['CaseNumber'] = &$this->CaseNumber;

		// FileNumber
		$this->FileNumber = new DbField('complaints', 'complaints', 'x_FileNumber', 'FileNumber', '`FileNumber`', '`FileNumber`', 200, -1, FALSE, '`FileNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->FileNumber->Sortable = TRUE; // Allow sort
		$this->fields['FileNumber'] = &$this->FileNumber;

		// ComplaintDate
		$this->ComplaintDate = new DbField('complaints', 'complaints', 'x_ComplaintDate', 'ComplaintDate', '`ComplaintDate`', CastDateFieldForLike('`ComplaintDate`', 7, "DB"), 133, 7, FALSE, '`ComplaintDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ComplaintDate->Sortable = TRUE; // Allow sort
		$this->ComplaintDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['ComplaintDate'] = &$this->ComplaintDate;

		// ComplaintTime
		$this->ComplaintTime = new DbField('complaints', 'complaints', 'x_ComplaintTime', 'ComplaintTime', '`ComplaintTime`', CastDateFieldForLike('`ComplaintTime`', 4, "DB"), 134, 4, FALSE, '`ComplaintTime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ComplaintTime->Sortable = FALSE; // Allow sort
		$this->ComplaintTime->DefaultErrorMessage = str_replace("%s", $GLOBALS["TIME_SEPARATOR"], $Language->phrase("IncorrectTime"));
		$this->fields['ComplaintTime'] = &$this->ComplaintTime;

		// Complaint
		$this->Complaint = new DbField('complaints', 'complaints', 'x_Complaint', 'Complaint', '`Complaint`', '`Complaint`', 200, -1, FALSE, '`Complaint`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Complaint->Nullable = FALSE; // NOT NULL field
		$this->Complaint->Required = TRUE; // Required field
		$this->Complaint->Sortable = TRUE; // Allow sort
		$this->fields['Complaint'] = &$this->Complaint;

		// ComplaintEn
		$this->ComplaintEn = new DbField('complaints', 'complaints', 'x_ComplaintEn', 'ComplaintEn', '`ComplaintEn`', '`ComplaintEn`', 200, -1, FALSE, '`ComplaintEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ComplaintEn->Sortable = FALSE; // Allow sort
		$this->fields['ComplaintEn'] = &$this->ComplaintEn;

		// NextComplaintDate
		$this->NextComplaintDate = new DbField('complaints', 'complaints', 'x_NextComplaintDate', 'NextComplaintDate', '`NextComplaintDate`', CastDateFieldForLike('`NextComplaintDate`', 7, "DB"), 135, 7, FALSE, '`NextComplaintDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NextComplaintDate->Sortable = FALSE; // Allow sort
		$this->NextComplaintDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['NextComplaintDate'] = &$this->NextComplaintDate;

		// NextComplaintTime
		$this->NextComplaintTime = new DbField('complaints', 'complaints', 'x_NextComplaintTime', 'NextComplaintTime', '`NextComplaintTime`', CastDateFieldForLike('`NextComplaintTime`', 4, "DB"), 134, 4, FALSE, '`NextComplaintTime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NextComplaintTime->Sortable = FALSE; // Allow sort
		$this->NextComplaintTime->DefaultErrorMessage = str_replace("%s", $GLOBALS["TIME_SEPARATOR"], $Language->phrase("IncorrectTime"));
		$this->fields['NextComplaintTime'] = &$this->NextComplaintTime;

		// CaseID
		$this->CaseID = new DbField('complaints', 'complaints', 'x_CaseID', 'CaseID', '`CaseID`', '`CaseID`', 3, -1, FALSE, '`CaseID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseID->IsForeignKey = TRUE; // Foreign key field
		$this->CaseID->Nullable = FALSE; // NOT NULL field
		$this->CaseID->Sortable = TRUE; // Allow sort
		$this->CaseID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CaseID'] = &$this->CaseID;

		// Notes
		$this->Notes = new DbField('complaints', 'complaints', 'x_Notes', 'Notes', '`Notes`', '`Notes`', 201, -1, FALSE, '`Notes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Notes->Sortable = TRUE; // Allow sort
		$this->fields['Notes'] = &$this->Notes;

		// Case
		$this->_Case = new DbField('complaints', 'complaints', 'x__Case', 'Case', '`Case`', '`Case`', 200, -1, FALSE, '`Case`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_Case->Sortable = FALSE; // Allow sort
		$this->fields['Case'] = &$this->_Case;

		// LawyerID
		$this->LawyerID = new DbField('complaints', 'complaints', 'x_LawyerID', 'LawyerID', '`LawyerID`', '`LawyerID`', 3, -1, FALSE, '`LawyerID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->LawyerID->Sortable = FALSE; // Allow sort
		$this->LawyerID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['LawyerID'] = &$this->LawyerID;

		// JudgeID
		$this->JudgeID = new DbField('complaints', 'complaints', 'x_JudgeID', 'JudgeID', '`JudgeID`', '`JudgeID`', 3, -1, FALSE, '`JudgeID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JudgeID->Sortable = FALSE; // Allow sort
		$this->JudgeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['JudgeID'] = &$this->JudgeID;

		// ClientID
		$this->ClientID = new DbField('complaints', 'complaints', 'x_ClientID', 'ClientID', '`ClientID`', '`ClientID`', 3, -1, FALSE, '`ClientID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->ClientID->Sortable = FALSE; // Allow sort
		$this->ClientID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ClientID'] = &$this->ClientID;

		// LitigantID
		$this->LitigantID = new DbField('complaints', 'complaints', 'x_LitigantID', 'LitigantID', '`LitigantID`', '`LitigantID`', 3, -1, FALSE, '`LitigantID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->LitigantID->Sortable = FALSE; // Allow sort
		$this->LitigantID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['LitigantID'] = &$this->LitigantID;

		// CourtID
		$this->CourtID = new DbField('complaints', 'complaints', 'x_CourtID', 'CourtID', '`CourtID`', '`CourtID`', 3, -1, FALSE, '`CourtID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtID->Sortable = FALSE; // Allow sort
		$this->CourtID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtID'] = &$this->CourtID;

		// CourtTypeID
		$this->CourtTypeID = new DbField('complaints', 'complaints', 'x_CourtTypeID', 'CourtTypeID', '`CourtTypeID`', '`CourtTypeID`', 3, -1, FALSE, '`CourtTypeID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtTypeID->Sortable = FALSE; // Allow sort
		$this->CourtTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtTypeID'] = &$this->CourtTypeID;

		// CourtGenderID
		$this->CourtGenderID = new DbField('complaints', 'complaints', 'x_CourtGenderID', 'CourtGenderID', '`CourtGenderID`', '`CourtGenderID`', 3, -1, FALSE, '`CourtGenderID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtGenderID->Sortable = FALSE; // Allow sort
		$this->CourtGenderID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtGenderID'] = &$this->CourtGenderID;

		// LawyerName
		$this->LawyerName = new DbField('complaints', 'complaints', 'x_LawyerName', 'LawyerName', '`LawyerName`', '`LawyerName`', 200, -1, FALSE, '`LawyerName`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->LawyerName->Sortable = FALSE; // Allow sort
		$this->fields['LawyerName'] = &$this->LawyerName;

		// JudgeName
		$this->JudgeName = new DbField('complaints', 'complaints', 'x_JudgeName', 'JudgeName', '`JudgeName`', '`JudgeName`', 200, -1, FALSE, '`JudgeName`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JudgeName->Sortable = FALSE; // Allow sort
		$this->fields['JudgeName'] = &$this->JudgeName;

		// UserID
		$this->_UserID = new DbField('complaints', 'complaints', 'x__UserID', 'UserID', '`UserID`', '`UserID`', 3, -1, FALSE, '`UserID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_UserID->Sortable = FALSE; // Allow sort
		$this->_UserID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['UserID'] = &$this->_UserID;

		// CreatedBy
		$this->CreatedBy = new DbField('complaints', 'complaints', 'x_CreatedBy', 'CreatedBy', '`CreatedBy`', '`CreatedBy`', 200, -1, FALSE, '`CreatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedBy->Sortable = FALSE; // Allow sort
		$this->fields['CreatedBy'] = &$this->CreatedBy;

		// CreatedDate
		$this->CreatedDate = new DbField('complaints', 'complaints', 'x_CreatedDate', 'CreatedDate', '`CreatedDate`', CastDateFieldForLike('`CreatedDate`', 0, "DB"), 135, 0, FALSE, '`CreatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedDate->Sortable = FALSE; // Allow sort
		$this->CreatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['CreatedDate'] = &$this->CreatedDate;

		// UpdatedBy
		$this->UpdatedBy = new DbField('complaints', 'complaints', 'x_UpdatedBy', 'UpdatedBy', '`UpdatedBy`', '`UpdatedBy`', 200, -1, FALSE, '`UpdatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedBy->Sortable = FALSE; // Allow sort
		$this->fields['UpdatedBy'] = &$this->UpdatedBy;

		// UpdatedDate
		$this->UpdatedDate = new DbField('complaints', 'complaints', 'x_UpdatedDate', 'UpdatedDate', '`UpdatedDate`', CastDateFieldForLike('`UpdatedDate`', 0, "DB"), 135, 0, FALSE, '`UpdatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedDate->Sortable = FALSE; // Allow sort
		$this->UpdatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['UpdatedDate'] = &$this->UpdatedDate;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "cases") {
			if ($this->CaseID->getSessionValue() <> "")
				$masterFilter .= "`CaseID`=" . QuotedValue($this->CaseID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "cases") {
			if ($this->CaseID->getSessionValue() <> "")
				$detailFilter .= "`CaseID`=" . QuotedValue($this->CaseID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_cases()
	{
		return "`CaseID`=@CaseID@";
	}

	// Detail filter
	public function sqlDetailFilter_cases()
	{
		return "`CaseID`=@CaseID@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`complaints`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->ComplaintID->setDbValue($conn->insert_ID());
			$rs['ComplaintID'] = $this->ComplaintID->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'ComplaintID';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('ComplaintID', $rs))
				AddFilter($where, QuotedName('ComplaintID', $this->Dbid) . '=' . QuotedValue($rs['ComplaintID'], $this->ComplaintID->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->ComplaintID->DbValue = $row['ComplaintID'];
		$this->CaseNumber->DbValue = $row['CaseNumber'];
		$this->FileNumber->DbValue = $row['FileNumber'];
		$this->ComplaintDate->DbValue = $row['ComplaintDate'];
		$this->ComplaintTime->DbValue = $row['ComplaintTime'];
		$this->Complaint->DbValue = $row['Complaint'];
		$this->ComplaintEn->DbValue = $row['ComplaintEn'];
		$this->NextComplaintDate->DbValue = $row['NextComplaintDate'];
		$this->NextComplaintTime->DbValue = $row['NextComplaintTime'];
		$this->CaseID->DbValue = $row['CaseID'];
		$this->Notes->DbValue = $row['Notes'];
		$this->_Case->DbValue = $row['Case'];
		$this->LawyerID->DbValue = $row['LawyerID'];
		$this->JudgeID->DbValue = $row['JudgeID'];
		$this->ClientID->DbValue = $row['ClientID'];
		$this->LitigantID->DbValue = $row['LitigantID'];
		$this->CourtID->DbValue = $row['CourtID'];
		$this->CourtTypeID->DbValue = $row['CourtTypeID'];
		$this->CourtGenderID->DbValue = $row['CourtGenderID'];
		$this->LawyerName->DbValue = $row['LawyerName'];
		$this->JudgeName->DbValue = $row['JudgeName'];
		$this->_UserID->DbValue = $row['UserID'];
		$this->CreatedBy->DbValue = $row['CreatedBy'];
		$this->CreatedDate->DbValue = $row['CreatedDate'];
		$this->UpdatedBy->DbValue = $row['UpdatedBy'];
		$this->UpdatedDate->DbValue = $row['UpdatedDate'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`ComplaintID` = @ComplaintID@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('ComplaintID', $row) ? $row['ComplaintID'] : NULL) : $this->ComplaintID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@ComplaintID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "complaintslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "complaintsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "complaintsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "complaintsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "complaintslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("complaintsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("complaintsview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "complaintsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "complaintsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("complaintsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("complaintsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("complaintsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "cases" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_CaseID=" . urlencode($this->CaseID->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "ComplaintID:" . JsonEncode($this->ComplaintID->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->ComplaintID->CurrentValue != NULL) {
			$url .= "ComplaintID=" . urlencode($this->ComplaintID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("ComplaintID") !== NULL)
				$arKeys[] = Param("ComplaintID");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->ComplaintID->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->ComplaintID->setDbValue($rs->fields('ComplaintID'));
		$this->CaseNumber->setDbValue($rs->fields('CaseNumber'));
		$this->FileNumber->setDbValue($rs->fields('FileNumber'));
		$this->ComplaintDate->setDbValue($rs->fields('ComplaintDate'));
		$this->ComplaintTime->setDbValue($rs->fields('ComplaintTime'));
		$this->Complaint->setDbValue($rs->fields('Complaint'));
		$this->ComplaintEn->setDbValue($rs->fields('ComplaintEn'));
		$this->NextComplaintDate->setDbValue($rs->fields('NextComplaintDate'));
		$this->NextComplaintTime->setDbValue($rs->fields('NextComplaintTime'));
		$this->CaseID->setDbValue($rs->fields('CaseID'));
		$this->Notes->setDbValue($rs->fields('Notes'));
		$this->_Case->setDbValue($rs->fields('Case'));
		$this->LawyerID->setDbValue($rs->fields('LawyerID'));
		$this->JudgeID->setDbValue($rs->fields('JudgeID'));
		$this->ClientID->setDbValue($rs->fields('ClientID'));
		$this->LitigantID->setDbValue($rs->fields('LitigantID'));
		$this->CourtID->setDbValue($rs->fields('CourtID'));
		$this->CourtTypeID->setDbValue($rs->fields('CourtTypeID'));
		$this->CourtGenderID->setDbValue($rs->fields('CourtGenderID'));
		$this->LawyerName->setDbValue($rs->fields('LawyerName'));
		$this->JudgeName->setDbValue($rs->fields('JudgeName'));
		$this->_UserID->setDbValue($rs->fields('UserID'));
		$this->CreatedBy->setDbValue($rs->fields('CreatedBy'));
		$this->CreatedDate->setDbValue($rs->fields('CreatedDate'));
		$this->UpdatedBy->setDbValue($rs->fields('UpdatedBy'));
		$this->UpdatedDate->setDbValue($rs->fields('UpdatedDate'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// ComplaintID
		// CaseNumber

		$this->CaseNumber->CellCssStyle = "white-space: nowrap;";

		// FileNumber
		// ComplaintDate
		// ComplaintTime

		$this->ComplaintTime->CellCssStyle = "white-space: nowrap;";

		// Complaint
		// ComplaintEn

		$this->ComplaintEn->CellCssStyle = "white-space: nowrap;";

		// NextComplaintDate
		$this->NextComplaintDate->CellCssStyle = "white-space: nowrap;";

		// NextComplaintTime
		$this->NextComplaintTime->CellCssStyle = "white-space: nowrap;";

		// CaseID
		// Notes
		// Case

		$this->_Case->CellCssStyle = "white-space: nowrap;";

		// LawyerID
		$this->LawyerID->CellCssStyle = "white-space: nowrap;";

		// JudgeID
		$this->JudgeID->CellCssStyle = "white-space: nowrap;";

		// ClientID
		$this->ClientID->CellCssStyle = "white-space: nowrap;";

		// LitigantID
		$this->LitigantID->CellCssStyle = "white-space: nowrap;";

		// CourtID
		$this->CourtID->CellCssStyle = "white-space: nowrap;";

		// CourtTypeID
		$this->CourtTypeID->CellCssStyle = "white-space: nowrap;";

		// CourtGenderID
		$this->CourtGenderID->CellCssStyle = "white-space: nowrap;";

		// LawyerName
		$this->LawyerName->CellCssStyle = "white-space: nowrap;";

		// JudgeName
		$this->JudgeName->CellCssStyle = "white-space: nowrap;";

		// UserID
		$this->_UserID->CellCssStyle = "white-space: nowrap;";

		// CreatedBy
		$this->CreatedBy->CellCssStyle = "white-space: nowrap;";

		// CreatedDate
		$this->CreatedDate->CellCssStyle = "white-space: nowrap;";

		// UpdatedBy
		$this->UpdatedBy->CellCssStyle = "white-space: nowrap;";

		// UpdatedDate
		$this->UpdatedDate->CellCssStyle = "white-space: nowrap;";

		// ComplaintID
		$this->ComplaintID->ViewValue = $this->ComplaintID->CurrentValue;
		$this->ComplaintID->ViewCustomAttributes = "";

		// CaseNumber
		$this->CaseNumber->ViewValue = $this->CaseNumber->CurrentValue;
		$this->CaseNumber->ViewCustomAttributes = "";

		// FileNumber
		$this->FileNumber->ViewValue = $this->FileNumber->CurrentValue;
		$this->FileNumber->ViewCustomAttributes = "";

		// ComplaintDate
		$this->ComplaintDate->ViewValue = $this->ComplaintDate->CurrentValue;
		$this->ComplaintDate->ViewValue = FormatDateTime($this->ComplaintDate->ViewValue, 7);
		$this->ComplaintDate->ViewCustomAttributes = "";

		// ComplaintTime
		$this->ComplaintTime->ViewValue = $this->ComplaintTime->CurrentValue;
		$this->ComplaintTime->ViewValue = FormatDateTime($this->ComplaintTime->ViewValue, 4);
		$this->ComplaintTime->ViewCustomAttributes = "";

		// Complaint
		$this->Complaint->ViewValue = $this->Complaint->CurrentValue;
		$this->Complaint->ViewCustomAttributes = "";

		// ComplaintEn
		$this->ComplaintEn->ViewValue = $this->ComplaintEn->CurrentValue;
		$this->ComplaintEn->ViewCustomAttributes = "";

		// NextComplaintDate
		$this->NextComplaintDate->ViewValue = $this->NextComplaintDate->CurrentValue;
		$this->NextComplaintDate->ViewValue = FormatDateTime($this->NextComplaintDate->ViewValue, 7);
		$this->NextComplaintDate->ViewCustomAttributes = "";

		// NextComplaintTime
		$this->NextComplaintTime->ViewValue = $this->NextComplaintTime->CurrentValue;
		$this->NextComplaintTime->ViewValue = FormatDateTime($this->NextComplaintTime->ViewValue, 4);
		$this->NextComplaintTime->ViewCustomAttributes = "";

		// CaseID
		$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
		$this->CaseID->ViewValue = FormatNumber($this->CaseID->ViewValue, 0, -2, -2, -2);
		$this->CaseID->ViewCustomAttributes = "";

		// Notes
		$this->Notes->ViewValue = $this->Notes->CurrentValue;
		$this->Notes->ViewCustomAttributes = "";

		// Case
		$this->_Case->ViewValue = $this->_Case->CurrentValue;
		$this->_Case->ViewCustomAttributes = "";

		// LawyerID
		$this->LawyerID->ViewValue = $this->LawyerID->CurrentValue;
		$this->LawyerID->ViewValue = FormatNumber($this->LawyerID->ViewValue, 0, -2, -2, -2);
		$this->LawyerID->ViewCustomAttributes = "";

		// JudgeID
		$this->JudgeID->ViewValue = $this->JudgeID->CurrentValue;
		$this->JudgeID->ViewValue = FormatNumber($this->JudgeID->ViewValue, 0, -2, -2, -2);
		$this->JudgeID->ViewCustomAttributes = "";

		// ClientID
		$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
		$this->ClientID->ViewValue = FormatNumber($this->ClientID->ViewValue, 0, -2, -2, -2);
		$this->ClientID->ViewCustomAttributes = "";

		// LitigantID
		$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
		$this->LitigantID->ViewValue = FormatNumber($this->LitigantID->ViewValue, 0, -2, -2, -2);
		$this->LitigantID->ViewCustomAttributes = "";

		// CourtID
		$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
		$this->CourtID->ViewValue = FormatNumber($this->CourtID->ViewValue, 0, -2, -2, -2);
		$this->CourtID->ViewCustomAttributes = "";

		// CourtTypeID
		$this->CourtTypeID->ViewValue = $this->CourtTypeID->CurrentValue;
		$this->CourtTypeID->ViewValue = FormatNumber($this->CourtTypeID->ViewValue, 0, -2, -2, -2);
		$this->CourtTypeID->ViewCustomAttributes = "";

		// CourtGenderID
		$this->CourtGenderID->ViewValue = $this->CourtGenderID->CurrentValue;
		$this->CourtGenderID->ViewValue = FormatNumber($this->CourtGenderID->ViewValue, 0, -2, -2, -2);
		$this->CourtGenderID->ViewCustomAttributes = "";

		// LawyerName
		$this->LawyerName->ViewValue = $this->LawyerName->CurrentValue;
		$this->LawyerName->ViewCustomAttributes = "";

		// JudgeName
		$this->JudgeName->ViewValue = $this->JudgeName->CurrentValue;
		$this->JudgeName->ViewCustomAttributes = "";

		// UserID
		$this->_UserID->ViewValue = $this->_UserID->CurrentValue;
		$this->_UserID->ViewValue = FormatNumber($this->_UserID->ViewValue, 0, -2, -2, -2);
		$this->_UserID->ViewCustomAttributes = "";

		// CreatedBy
		$this->CreatedBy->ViewValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->ViewCustomAttributes = "";

		// CreatedDate
		$this->CreatedDate->ViewValue = $this->CreatedDate->CurrentValue;
		$this->CreatedDate->ViewValue = FormatDateTime($this->CreatedDate->ViewValue, 0);
		$this->CreatedDate->ViewCustomAttributes = "";

		// UpdatedBy
		$this->UpdatedBy->ViewValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->ViewCustomAttributes = "";

		// UpdatedDate
		$this->UpdatedDate->ViewValue = $this->UpdatedDate->CurrentValue;
		$this->UpdatedDate->ViewValue = FormatDateTime($this->UpdatedDate->ViewValue, 0);
		$this->UpdatedDate->ViewCustomAttributes = "";

		// ComplaintID
		$this->ComplaintID->LinkCustomAttributes = "";
		$this->ComplaintID->HrefValue = "";
		$this->ComplaintID->TooltipValue = "";

		// CaseNumber
		$this->CaseNumber->LinkCustomAttributes = "";
		$this->CaseNumber->HrefValue = "";
		$this->CaseNumber->TooltipValue = "";

		// FileNumber
		$this->FileNumber->LinkCustomAttributes = "";
		$this->FileNumber->HrefValue = "";
		$this->FileNumber->TooltipValue = "";

		// ComplaintDate
		$this->ComplaintDate->LinkCustomAttributes = "";
		$this->ComplaintDate->HrefValue = "";
		$this->ComplaintDate->TooltipValue = "";

		// ComplaintTime
		$this->ComplaintTime->LinkCustomAttributes = "";
		$this->ComplaintTime->HrefValue = "";
		$this->ComplaintTime->TooltipValue = "";

		// Complaint
		$this->Complaint->LinkCustomAttributes = "";
		$this->Complaint->HrefValue = "";
		$this->Complaint->TooltipValue = "";

		// ComplaintEn
		$this->ComplaintEn->LinkCustomAttributes = "";
		$this->ComplaintEn->HrefValue = "";
		$this->ComplaintEn->TooltipValue = "";

		// NextComplaintDate
		$this->NextComplaintDate->LinkCustomAttributes = "";
		$this->NextComplaintDate->HrefValue = "";
		$this->NextComplaintDate->TooltipValue = "";

		// NextComplaintTime
		$this->NextComplaintTime->LinkCustomAttributes = "";
		$this->NextComplaintTime->HrefValue = "";
		$this->NextComplaintTime->TooltipValue = "";

		// CaseID
		$this->CaseID->LinkCustomAttributes = "";
		$this->CaseID->HrefValue = "";
		$this->CaseID->TooltipValue = "";

		// Notes
		$this->Notes->LinkCustomAttributes = "";
		$this->Notes->HrefValue = "";
		$this->Notes->TooltipValue = "";

		// Case
		$this->_Case->LinkCustomAttributes = "";
		$this->_Case->HrefValue = "";
		$this->_Case->TooltipValue = "";

		// LawyerID
		$this->LawyerID->LinkCustomAttributes = "";
		$this->LawyerID->HrefValue = "";
		$this->LawyerID->TooltipValue = "";

		// JudgeID
		$this->JudgeID->LinkCustomAttributes = "";
		$this->JudgeID->HrefValue = "";
		$this->JudgeID->TooltipValue = "";

		// ClientID
		$this->ClientID->LinkCustomAttributes = "";
		$this->ClientID->HrefValue = "";
		$this->ClientID->TooltipValue = "";

		// LitigantID
		$this->LitigantID->LinkCustomAttributes = "";
		$this->LitigantID->HrefValue = "";
		$this->LitigantID->TooltipValue = "";

		// CourtID
		$this->CourtID->LinkCustomAttributes = "";
		$this->CourtID->HrefValue = "";
		$this->CourtID->TooltipValue = "";

		// CourtTypeID
		$this->CourtTypeID->LinkCustomAttributes = "";
		$this->CourtTypeID->HrefValue = "";
		$this->CourtTypeID->TooltipValue = "";

		// CourtGenderID
		$this->CourtGenderID->LinkCustomAttributes = "";
		$this->CourtGenderID->HrefValue = "";
		$this->CourtGenderID->TooltipValue = "";

		// LawyerName
		$this->LawyerName->LinkCustomAttributes = "";
		$this->LawyerName->HrefValue = "";
		$this->LawyerName->TooltipValue = "";

		// JudgeName
		$this->JudgeName->LinkCustomAttributes = "";
		$this->JudgeName->HrefValue = "";
		$this->JudgeName->TooltipValue = "";

		// UserID
		$this->_UserID->LinkCustomAttributes = "";
		$this->_UserID->HrefValue = "";
		$this->_UserID->TooltipValue = "";

		// CreatedBy
		$this->CreatedBy->LinkCustomAttributes = "";
		$this->CreatedBy->HrefValue = "";
		$this->CreatedBy->TooltipValue = "";

		// CreatedDate
		$this->CreatedDate->LinkCustomAttributes = "";
		$this->CreatedDate->HrefValue = "";
		$this->CreatedDate->TooltipValue = "";

		// UpdatedBy
		$this->UpdatedBy->LinkCustomAttributes = "";
		$this->UpdatedBy->HrefValue = "";
		$this->UpdatedBy->TooltipValue = "";

		// UpdatedDate
		$this->UpdatedDate->LinkCustomAttributes = "";
		$this->UpdatedDate->HrefValue = "";
		$this->UpdatedDate->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// ComplaintID
		$this->ComplaintID->EditAttrs["class"] = "form-control";
		$this->ComplaintID->EditCustomAttributes = "";

		// CaseNumber
		$this->CaseNumber->EditAttrs["class"] = "form-control";
		$this->CaseNumber->EditCustomAttributes = "";
		$this->CaseNumber->EditValue = $this->CaseNumber->CurrentValue;
		$this->CaseNumber->PlaceHolder = RemoveHtml($this->CaseNumber->caption());

		// FileNumber
		$this->FileNumber->EditAttrs["class"] = "form-control";
		$this->FileNumber->EditCustomAttributes = "";
		$this->FileNumber->EditValue = $this->FileNumber->CurrentValue;
		$this->FileNumber->PlaceHolder = RemoveHtml($this->FileNumber->caption());

		// ComplaintDate
		$this->ComplaintDate->EditAttrs["class"] = "form-control";
		$this->ComplaintDate->EditCustomAttributes = "";
		$this->ComplaintDate->EditValue = FormatDateTime($this->ComplaintDate->CurrentValue, 7);
		$this->ComplaintDate->PlaceHolder = RemoveHtml($this->ComplaintDate->caption());

		// ComplaintTime
		$this->ComplaintTime->EditAttrs["class"] = "form-control";
		$this->ComplaintTime->EditCustomAttributes = "";
		$this->ComplaintTime->EditValue = $this->ComplaintTime->CurrentValue;
		$this->ComplaintTime->PlaceHolder = RemoveHtml($this->ComplaintTime->caption());

		// Complaint
		$this->Complaint->EditAttrs["class"] = "form-control";
		$this->Complaint->EditCustomAttributes = "";
		$this->Complaint->EditValue = $this->Complaint->CurrentValue;
		$this->Complaint->PlaceHolder = RemoveHtml($this->Complaint->caption());

		// ComplaintEn
		$this->ComplaintEn->EditAttrs["class"] = "form-control";
		$this->ComplaintEn->EditCustomAttributes = "";
		$this->ComplaintEn->EditValue = $this->ComplaintEn->CurrentValue;
		$this->ComplaintEn->PlaceHolder = RemoveHtml($this->ComplaintEn->caption());

		// NextComplaintDate
		$this->NextComplaintDate->EditAttrs["class"] = "form-control";
		$this->NextComplaintDate->EditCustomAttributes = "";
		$this->NextComplaintDate->EditValue = FormatDateTime($this->NextComplaintDate->CurrentValue, 7);
		$this->NextComplaintDate->PlaceHolder = RemoveHtml($this->NextComplaintDate->caption());

		// NextComplaintTime
		$this->NextComplaintTime->EditAttrs["class"] = "form-control";
		$this->NextComplaintTime->EditCustomAttributes = "";
		$this->NextComplaintTime->EditValue = $this->NextComplaintTime->CurrentValue;
		$this->NextComplaintTime->PlaceHolder = RemoveHtml($this->NextComplaintTime->caption());

		// CaseID
		$this->CaseID->EditAttrs["class"] = "form-control";
		$this->CaseID->EditCustomAttributes = "";
		if ($this->CaseID->getSessionValue() <> "") {
			$this->CaseID->CurrentValue = $this->CaseID->getSessionValue();
		$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
		$this->CaseID->ViewValue = FormatNumber($this->CaseID->ViewValue, 0, -2, -2, -2);
		$this->CaseID->ViewCustomAttributes = "";
		} else {
		$this->CaseID->EditValue = $this->CaseID->CurrentValue;
		$this->CaseID->PlaceHolder = RemoveHtml($this->CaseID->caption());
		}

		// Notes
		$this->Notes->EditAttrs["class"] = "form-control";
		$this->Notes->EditCustomAttributes = "";
		$this->Notes->EditValue = $this->Notes->CurrentValue;
		$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

		// Case
		$this->_Case->EditAttrs["class"] = "form-control";
		$this->_Case->EditCustomAttributes = "";
		$this->_Case->EditValue = $this->_Case->CurrentValue;
		$this->_Case->PlaceHolder = RemoveHtml($this->_Case->caption());

		// LawyerID
		$this->LawyerID->EditAttrs["class"] = "form-control";
		$this->LawyerID->EditCustomAttributes = "";
		$this->LawyerID->EditValue = $this->LawyerID->CurrentValue;
		$this->LawyerID->PlaceHolder = RemoveHtml($this->LawyerID->caption());

		// JudgeID
		$this->JudgeID->EditAttrs["class"] = "form-control";
		$this->JudgeID->EditCustomAttributes = "";
		$this->JudgeID->EditValue = $this->JudgeID->CurrentValue;
		$this->JudgeID->PlaceHolder = RemoveHtml($this->JudgeID->caption());

		// ClientID
		$this->ClientID->EditAttrs["class"] = "form-control";
		$this->ClientID->EditCustomAttributes = "";

		// LitigantID
		$this->LitigantID->EditAttrs["class"] = "form-control";
		$this->LitigantID->EditCustomAttributes = "";

		// CourtID
		$this->CourtID->EditAttrs["class"] = "form-control";
		$this->CourtID->EditCustomAttributes = "";
		$this->CourtID->EditValue = $this->CourtID->CurrentValue;
		$this->CourtID->PlaceHolder = RemoveHtml($this->CourtID->caption());

		// CourtTypeID
		$this->CourtTypeID->EditAttrs["class"] = "form-control";
		$this->CourtTypeID->EditCustomAttributes = "";
		$this->CourtTypeID->EditValue = $this->CourtTypeID->CurrentValue;
		$this->CourtTypeID->PlaceHolder = RemoveHtml($this->CourtTypeID->caption());

		// CourtGenderID
		$this->CourtGenderID->EditAttrs["class"] = "form-control";
		$this->CourtGenderID->EditCustomAttributes = "";
		$this->CourtGenderID->EditValue = $this->CourtGenderID->CurrentValue;
		$this->CourtGenderID->PlaceHolder = RemoveHtml($this->CourtGenderID->caption());

		// LawyerName
		$this->LawyerName->EditAttrs["class"] = "form-control";
		$this->LawyerName->EditCustomAttributes = "";
		$this->LawyerName->EditValue = $this->LawyerName->CurrentValue;
		$this->LawyerName->PlaceHolder = RemoveHtml($this->LawyerName->caption());

		// JudgeName
		$this->JudgeName->EditAttrs["class"] = "form-control";
		$this->JudgeName->EditCustomAttributes = "";
		$this->JudgeName->EditValue = $this->JudgeName->CurrentValue;
		$this->JudgeName->PlaceHolder = RemoveHtml($this->JudgeName->caption());

		// UserID
		$this->_UserID->EditAttrs["class"] = "form-control";
		$this->_UserID->EditCustomAttributes = "";
		$this->_UserID->EditValue = $this->_UserID->CurrentValue;
		$this->_UserID->PlaceHolder = RemoveHtml($this->_UserID->caption());

		// CreatedBy
		$this->CreatedBy->EditAttrs["class"] = "form-control";
		$this->CreatedBy->EditCustomAttributes = "";
		$this->CreatedBy->EditValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->PlaceHolder = RemoveHtml($this->CreatedBy->caption());

		// CreatedDate
		$this->CreatedDate->EditAttrs["class"] = "form-control";
		$this->CreatedDate->EditCustomAttributes = "";
		$this->CreatedDate->EditValue = FormatDateTime($this->CreatedDate->CurrentValue, 8);
		$this->CreatedDate->PlaceHolder = RemoveHtml($this->CreatedDate->caption());

		// UpdatedBy
		$this->UpdatedBy->EditAttrs["class"] = "form-control";
		$this->UpdatedBy->EditCustomAttributes = "";
		$this->UpdatedBy->EditValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->PlaceHolder = RemoveHtml($this->UpdatedBy->caption());

		// UpdatedDate
		$this->UpdatedDate->EditAttrs["class"] = "form-control";
		$this->UpdatedDate->EditCustomAttributes = "";
		$this->UpdatedDate->EditValue = FormatDateTime($this->UpdatedDate->CurrentValue, 8);
		$this->UpdatedDate->PlaceHolder = RemoveHtml($this->UpdatedDate->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->ComplaintID);
					$doc->exportCaption($this->CaseNumber);
					$doc->exportCaption($this->FileNumber);
					$doc->exportCaption($this->ComplaintDate);
					$doc->exportCaption($this->Complaint);
					$doc->exportCaption($this->CaseID);
					$doc->exportCaption($this->Notes);
				} else {
					$doc->exportCaption($this->ComplaintID);
					$doc->exportCaption($this->CaseNumber);
					$doc->exportCaption($this->FileNumber);
					$doc->exportCaption($this->ComplaintDate);
					$doc->exportCaption($this->Complaint);
					$doc->exportCaption($this->CaseID);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->ComplaintID);
						$doc->exportField($this->CaseNumber);
						$doc->exportField($this->FileNumber);
						$doc->exportField($this->ComplaintDate);
						$doc->exportField($this->Complaint);
						$doc->exportField($this->CaseID);
						$doc->exportField($this->Notes);
					} else {
						$doc->exportField($this->ComplaintID);
						$doc->exportField($this->CaseNumber);
						$doc->exportField($this->FileNumber);
						$doc->exportField($this->ComplaintDate);
						$doc->exportField($this->Complaint);
						$doc->exportField($this->CaseID);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		if (!$validRequest)
			return FALSE;

		// Load lookup parameters
		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'complaints';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'complaints';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['ComplaintID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'complaints';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['ComplaintID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'complaints';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['ComplaintID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
